(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42026,       1473]
NotebookOptionsPosition[     31779,       1153]
NotebookOutlinePosition[     36703,       1276]
CellTagsIndexPosition[     36398,       1265]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Transformation Rules and Definitions" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Transformation Rules and Definitions\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Associating Definitions with Different Symbols", "Title",
 CellTags->{"S2.5.10", "10.1"},
 CellID->6972],

Cell[TextData[{
 "When you make a definition in the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "[", 
    StyleBox["args", "TI"], "]"}], "=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "[", 
    StyleBox["args", "TI"], "]"}], ":=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " associates your definition with the object ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". This means, for example, that such definitions are displayed when you \
type ",
 Cell[BoxData[
  RowBox[{"?", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 ". In general, definitions for expressions in which the symbol ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " appears as the head are termed ",
 StyleBox["downvalues",
  FontSlant->"Italic"],
 " of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->26821],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " however also supports ",
 StyleBox["upvalues",
  FontSlant->"Italic"],
 ", which allow definitions to be associated with symbols that do not appear \
directly as their head. "
}], "Text",
 CellID->26122],

Cell[TextData[{
 "Consider for example a definition like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Exp",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Exp"], "[", 
    RowBox[{"g", "[", "x_", "]"}], "]"}], ":=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ". One possibility is that this definition could be associated with the \
symbol ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 ", and considered as a downvalue of ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 ". This is however probably not the best thing either from the point of view \
of organization or efficiency. "
}], "Text",
 CellID->25547],

Cell[TextData[{
 "Better is to consider ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Exp",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Exp"], "[", 
    RowBox[{"g", "[", "x_", "]"}], "]"}], ":=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " to be associated with ",
 Cell[BoxData["g"], "InlineFormula"],
 ", and to correspond to an upvalue of\[NonBreakingSpace]",
 Cell[BoxData["g"], "InlineFormula"],
 ". "
}], "Text",
 CellID->21577],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["args", "TI"], "]", ":=", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     "define a downvalue for ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["g", "TI"], "[", 
     StyleBox["args", "TI"], "]", ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", "^:=", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     "define an upvalue for ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9789],

Cell["Associating definitions with different symbols. ", "Caption",
 CellID->25605],

Cell[TextData[{
 "This is taken to define a downvalue for\[NonBreakingSpace]",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30195],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"fg", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27594],

Cell[TextData[{
 "You can see the definition when you ask about ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16343],

Cell[CellGroupData[{

Cell["Global`f", "Print", "PrintUsage",
 CellTags->"Info3384451318-4682455",
 CellID->31687254],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"g", "[", "x_", "]"}], "]"}], ":=", 
         RowBox[{"fg", "[", "x", "]"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["f"],
  Editable->False]], "Print",
 CellTags->"Info3384451318-4682455",
 CellID->30095257]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "This defines an upvalue for ",
 Cell[BoxData["g"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1012],

Cell[BoxData[
 RowBox[{
  RowBox[{"Exp", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}], "^:=", 
  RowBox[{"expg", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->11672],

Cell[TextData[{
 "The definition is associated with ",
 Cell[BoxData["g"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "g"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13428],

Cell[CellGroupData[{

Cell["Global`g", "Print", "PrintUsage",
 CellTags->"Info3384451327-2156389",
 CellID->78488836],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"g", "[", "x_", "]"}]], "^:=", 
         RowBox[{"expg", "[", "x", "]"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["g"],
  Editable->False]], "Print",
 CellTags->"Info3384451327-2156389",
 CellID->245838042]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "It is not associated with ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->5967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", "Exp"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->24408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Exp\\\", \\\"[\\\", StyleBox[\\\"z\\\", \
\\\"TI\\\"], \\\"]\\\"}]\) is the exponential function. \"\>", "MSG"], " ", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]}]], "Print", "PrintUsage",
 CellTags->"Info3384451331-3673133",
 CellID->733571597],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "Exp", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{
       "Listable", ",", "NumericFunction", ",", "Protected", ",", 
        "ReadProtected"}], "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["Exp"],
  Editable->False]], "Print",
 CellTags->"Info3384451331-3673133",
 CellID->271377073]
}, Open  ]]
}, Open  ]],

Cell["The definition is used to evaluate this expression. ", "MathCaption",
 CellID->17223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"g", "[", "5", "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->11759],

Cell[BoxData[
 RowBox[{"expg", "[", "5", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->304925138]
}, Open  ]],

Cell[TextData[{
 "In simple cases, you will get the same answers to calculations whether you \
give a definition for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["g", "TI"], "[", 
    StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
 " as a downvalue for ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " or an upvalue for ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ". However, one of the two choices is usually much more natural and \
efficient than the other. "
}], "Text",
 CellID->5204],

Cell[TextData[{
 "A good rule of thumb is that a definition for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["g", "TI"], "[", 
    StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
 " should be given as an upvalue for ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " in cases where the function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is more common than ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ". Thus, for example, in the case of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exp"], "[", 
   RowBox[{
    StyleBox["g", "TI"], "[", 
    StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 " is a built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function, while ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " is presumably a function you have added. In such a case, you will \
typically think of definitions for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exp"], "[", 
   RowBox[{
    StyleBox["g", "TI"], "[", 
    StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
 " as giving relations satisfied by ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ". As a result, it is more natural to treat the definitions as upvalues for \
",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " than as downvalues for ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->29486],

Cell[TextData[{
 "This gives the definition as an upvalue for ",
 Cell[BoxData["g"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4319],

Cell[BoxData[
 RowBox[{"g", "/:", 
  RowBox[{
   RowBox[{"g", "[", "x_", "]"}], "+", 
   RowBox[{"g", "[", "y_", "]"}]}], ":=", 
  RowBox[{"gplus", "[", 
   RowBox[{"x", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->958],

Cell[TextData[{
 "Here are the definitions for ",
 Cell[BoxData["g"], "InlineFormula"],
 " so far. "
}], "MathCaption",
 CellID->5945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "g"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->26806],

Cell[CellGroupData[{

Cell["Global`g", "Print", "PrintUsage",
 CellTags->"Info3384451340-8769298",
 CellID->677678332],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"g", "[", "x_", "]"}]], "^:=", 
         RowBox[{"expg", "[", "x", "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{
          RowBox[{"g", "[", "x_", "]"}], "+", 
          RowBox[{"g", "[", "y_", "]"}]}], "^:=", 
         RowBox[{"gplus", "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["g"],
  Editable->False]], "Print",
 CellTags->"Info3384451340-8769298",
 CellID->433352793]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "The definition for a sum of ",
 Cell[BoxData["g"], "InlineFormula"],
 "\[CloseCurlyQuote]s is used whenever possible. "
}], "MathCaption",
 CellID->11367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "5", "]"}], "+", 
  RowBox[{"g", "[", "7", "]"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->17692],

Cell[BoxData[
 RowBox[{"gplus", "[", 
  RowBox[{"5", ",", "7"}], "]"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->980980699]
}, Open  ]],

Cell[TextData[{
 "Since the full form of the pattern ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"g", "[", "x_", "]"}], "+", 
   RowBox[{"g", "[", "y_", "]"}]}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Plus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plus"], "[", 
   RowBox[{
    RowBox[{"g", "[", "x_", "]"}], ",", 
    RowBox[{"g", "[", "y_", "]"}]}], "]"}]], "InlineFormula"],
 ", a definition for this pattern could be given as a downvalue for ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ". It is almost always better, however, to give the definition as an upvalue \
for ",
 Cell[BoxData["g"], "InlineFormula"],
 ". "
}], "Text",
 CellID->28532],

Cell[TextData[{
 "In general, whenever ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " encounters a particular function, it tries all the definitions you have \
given for that function. If you had made the definition for ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"g", "[", "x_", "]"}], "+", 
   RowBox[{"g", "[", "y_", "]"}]}]], "InlineFormula"],
 " a downvalue for ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ", then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " would have tried this definition whenever ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " occurs. The definition would thus be tested every time ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " added expressions together, making this very common operation slower in \
all cases. "
}], "Text",
 CellID->30556],

Cell[TextData[{
 "However, by giving a definition for ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"g", "[", "x_", "]"}], "+", 
   RowBox[{"g", "[", "y_", "]"}]}]], "InlineFormula"],
 " as an upvalue for ",
 Cell[BoxData["g"], "InlineFormula"],
 ", you associate the definition with ",
 Cell[BoxData["g"], "InlineFormula"],
 ". In this case, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " only tries the definition when it finds a ",
 Cell[BoxData["g"], "InlineFormula"],
 " inside a function such as ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ". Since ",
 Cell[BoxData["g"], "InlineFormula"],
 " presumably occurs much less frequently than ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ", this is a much more efficient procedure. "
}], "Text",
 CellID->30974],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["g", "TI"], "]", "^=", 
     StyleBox["value", "TI"], Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     StyleBox["f", "TI"], "[", 
     StyleBox["g", "TI"], "[", 
     StyleBox["args", "TI"], "]", "]", "^=", 
     StyleBox["value", "TI"]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "make assignments to be associated with ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     ", rather than ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["g", "TI"], "]", "^:=", 
     StyleBox["value", "TI"], Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     StyleBox["f", "TI"], "[", 
     StyleBox["g", "TI"], "[", 
     StyleBox["args", "TI"], "]", "]", "^:=", 
     StyleBox["value", "TI"]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "make delayed assignments associated with ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["f", "TI"], "[", 
     SubscriptBox[
      StyleBox["arg", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["arg", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", "^=", 
     StyleBox["value", "TI"]}], Cell[TextData[{
     "make assignments associated with the heads of ",
     StyleBox["all",
      FontSlant->"Italic"],
     " the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["arg", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3447],

Cell["Shorter ways to define upvalues. ", "Caption",
 CellID->5021],

Cell["\<\
A typical use of upvalues is in setting up a \[OpenCurlyDoubleQuote]database\
\[CloseCurlyDoubleQuote] of properties of a particular object. With upvalues, \
you can associate each definition you make with the object that it concerns, \
rather than with the property you are specifying. \
\>", "Text",
 CellID->18283],

Cell[TextData[{
 "This defines an upvalue for ",
 Cell[BoxData["square"], "InlineFormula"],
 " which gives its area. "
}], "MathCaption",
 CellID->26222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"area", "[", "square", "]"}], "^=", "1"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->29331],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->67375775]
}, Open  ]],

Cell["This adds a definition for the perimeter. ", "MathCaption",
 CellID->28583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"perimeter", "[", "square", "]"}], "^=", "4"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->26948],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->3346765]
}, Open  ]],

Cell[TextData[{
 "Both definitions are now associated with the object ",
 Cell[BoxData["square"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "square"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->22018],

Cell[CellGroupData[{

Cell["Global`square", "Print", "PrintUsage",
 CellTags->"Info3384451355-7834600",
 CellID->259412690],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"area", "[", "square", "]"}], "^=", "1"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"perimeter", "[", "square", "]"}], "^=", "4"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["square"],
  Editable->False]], "Print",
 CellTags->"Info3384451355-7834600",
 CellID->142101959]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "In general, you can associate definitions for an expression with any symbol \
that occurs at a sufficiently high level in the expression. With an \
expression of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["args", "TI"], "]"}]], "InlineFormula"],
 ", you can define an upvalue for a symbol ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " so long as either ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " itself, or an object with head ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ", occurs in ",
 Cell[BoxData[
  StyleBox["args", "TI"]], "InlineFormula"],
 ". If ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " occurs at a lower level in an expression, however, you cannot associate \
definitions with it. "
}], "Text",
 CellID->31111],

Cell[TextData[{
 Cell[BoxData["g"], "InlineFormula"],
 " occurs as the head of an argument, so you can associate a definition with \
it. "
}], "MathCaption",
 CellID->32182],

Cell[BoxData[
 RowBox[{"g", "/:", 
  RowBox[{"h", "[", 
   RowBox[{
    RowBox[{"w", "[", "x_", "]"}], ",", 
    RowBox[{"g", "[", "y_", "]"}]}], "]"}], ":=", 
  RowBox[{"hwg", "[", 
   RowBox[{"x", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[13]:=",
 CellID->23856],

Cell[TextData[{
 "Here ",
 Cell[BoxData["g"], "InlineFormula"],
 " appears too deep in the left\[Hyphen]hand side for you to associate a \
definition with it. "
}], "MathCaption",
 CellID->19490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "/:", 
  RowBox[{"h", "[", 
   RowBox[{
    RowBox[{"w", "[", 
     RowBox[{"g", "[", "x_", "]"}], "]"}], ",", "y_"}], "]"}], ":=", 
  RowBox[{"hw", "[", 
   RowBox[{"x", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[14]:=",
 CellID->8925],

Cell[BoxData[
 RowBox[{
  RowBox[{"TagSetDelayed", "::", "\<\"tagpos\"\>"}], ":", 
  " ", "\<\"Tag \\!\\(g\\) in \\!\\(h[\\(\\(\\(\\(w[\\(\\(g[x_]\\)\\)]\\)\\), \
y_\\)\\)]\\) is too deep for an assigned rule to be found. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/TagSetDelayed/tagpos\\\", ButtonNote -> \\\
\"TagSetDelayed::tagpos\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[14]:=",
 CellID->472567486],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->71770237]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]", ":=", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     "downvalue for ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["f", "TI"], "/:", 
     StyleBox["f", "TI"], "[", 
     StyleBox["g", "TI"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]", "]", "[", 
     StyleBox["\[Ellipsis]", "TR"], "]", ":=", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     "downvalue for ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["g", "TI"], "/:", 
     StyleBox["f", "TI"], "[", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     StyleBox["g", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", ":=", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     "upvalue for ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["g", "TI"], "/:", 
     StyleBox["f", "TI"], "[", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     StyleBox["g", "TI"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]", ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", ":=", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     "upvalue for ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19677],

Cell["Possible positions for symbols in definitions. ", "Caption",
 CellID->15969],

Cell[TextData[{
 "As discussed in \"",
 ButtonBox["The Meaning of Expressions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheMeaningOfExpressions"],
 ", you can use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbols as \[OpenCurlyDoubleQuote]tags\[CloseCurlyDoubleQuote], to \
indicate the \[OpenCurlyDoubleQuote]type\[CloseCurlyDoubleQuote] of an \
expression. For example, complex numbers in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are represented internally in the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Complex",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Complex"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ", where the symbol ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " serves as a tag to indicate that the object is a complex number. "
}], "Text",
 CellID->11643],

Cell[TextData[{
 "Upvalues provide a convenient mechanism for specifying how operations act \
on objects that are tagged to have a certain type. For example, you might \
want to introduce a class of abstract mathematical objects of type ",
 Cell[BoxData["quat"], "InlineFormula"],
 ". You can represent each object of this type by a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression of the form ",
 Cell[BoxData[
  RowBox[{"quat", "[", 
   StyleBox["data", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->7534],

Cell[TextData[{
 "In a typical case, you might want ",
 Cell[BoxData["quat"], "InlineFormula"],
 " objects to have special properties with respect to arithmetic operations \
such as addition and multiplication. You can set up such properties by \
defining upvalues for ",
 Cell[BoxData["quat"], "InlineFormula"],
 " with respect to ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->15677],

Cell[TextData[{
 "This defines an upvalue for ",
 Cell[BoxData["quat"], "InlineFormula"],
 " with respect to ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->22668],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"quat", "[", "x_", "]"}], "+", 
   RowBox[{"quat", "[", "y_", "]"}]}], "^:=", 
  RowBox[{"quat", "[", 
   RowBox[{"x", "+", "y"}], "]"}]}]], "Input",
 CellLabel->"In[15]:=",
 CellID->31068],

Cell["\<\
The upvalue you have defined is used to simplify this expression. \
\>", "MathCaption",
 CellID->21991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"quat", "[", "a", "]"}], "+", 
  RowBox[{"quat", "[", "b", "]"}], "+", 
  RowBox[{"quat", "[", "c", "]"}]}]], "Input",
 CellLabel->"In[16]:=",
 CellID->32196],

Cell[BoxData[
 RowBox[{"quat", "[", 
  RowBox[{"a", "+", "b", "+", "c"}], "]"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->576503958]
}, Open  ]],

Cell[TextData[{
 "When you define an upvalue for ",
 Cell[BoxData["quat"], "InlineFormula"],
 " with respect to an operation like ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ", what you are effectively doing is to extend the domain of the ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " operation to include ",
 Cell[BoxData["quat"], "InlineFormula"],
 " objects. You are telling ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to use special rules for addition in the case where the things to be added \
together are ",
 Cell[BoxData["quat"], "InlineFormula"],
 " objects. "
}], "Text",
 CellID->16828],

Cell[TextData[{
 "In defining addition for ",
 Cell[BoxData["quat"], "InlineFormula"],
 " objects, you could always have a special addition operation, say ",
 Cell[BoxData["quatPlus"], "InlineFormula"],
 ", to which you assign an appropriate downvalue. It is usually much more \
convenient, however, to use the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " operation to represent addition, but then to \
\[OpenCurlyDoubleQuote]overload\[CloseCurlyDoubleQuote] this operation by \
specifying special behavior when ",
 Cell[BoxData["quat"], "InlineFormula"],
 " objects are encountered. "
}], "Text",
 CellID->7727],

Cell[TextData[{
 "You can think of upvalues as a way to implement certain aspects of object\
\[Hyphen]oriented programming. A symbol like ",
 Cell[BoxData["quat"], "InlineFormula"],
 " represents a particular type of object. Then the various upvalues for ",
 Cell[BoxData["quat"], "InlineFormula"],
 " specify \[OpenCurlyDoubleQuote]methods\[CloseCurlyDoubleQuote] that define \
how ",
 Cell[BoxData["quat"], "InlineFormula"],
 " objects should behave under certain operations, or on receipt of certain \
\[OpenCurlyDoubleQuote]messages\[CloseCurlyDoubleQuote]. "
}], "Text",
 CellID->29426],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->660065298],

Cell[TextData[ButtonBox["Transformation Rules and Definitions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], \
"RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Associating Definitions with Different Symbols - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Transformation Rules and Definitions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/FunctionsThatRememberValuesTheyHaveFound"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DefiningNumericalValues"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 53.1231902}", "context" -> "", 
    "keywords" -> {
     "/:", "^:=", "^=", ":=", "assignments", "databases", "definitions", 
      "DownValues", "down values", "messages", "methods", 
      "object-oriented programming", "objects", "OOP", "operators", 
      "organization", "overloading", "quat objects", "rules", "tags", 
      "TagSet", "TagSetDelayed", "UpSet", "UpSetDelayed", "Upvalues", 
      "values"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "When you make a definition in the form f[args]=rhs or f[args]:=rhs, \
Mathematica associates your definition with the object f. This means, for \
example, that such definitions are displayed when you type ?f. In general, \
definitions for expressions in which the symbol f appears as the head are \
termed downvalues of f. Mathematica however also supports upvalues, which \
allow definitions to be associated with symbols that do not appear directly \
as their head. Consider for example a definition like Exp[g[x_]]:=rhs. One \
possibility is that this definition could be associated with the symbol Exp, \
and considered as a downvalue of Exp. This is however probably not the best \
thing either from the point of view of organization or efficiency. ", 
    "synonyms" -> {"2.5.10"}, "title" -> 
    "Associating Definitions with Different Symbols", "type" -> "Tutorial", 
    "uri" -> "tutorial/AssociatingDefinitionsWithDifferentSymbols"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.5.10"->{
  Cell[1309, 44, 110, 2, 70, "Title",
   CellTags->{"S2.5.10", "10.1"},
   CellID->6972]},
 "10.1"->{
  Cell[1309, 44, 110, 2, 70, "Title",
   CellTags->{"S2.5.10", "10.1"},
   CellID->6972]},
 "Info3384451318-4682455"->{
  Cell[5574, 207, 95, 2, 70, "Print",
   CellTags->"Info3384451318-4682455",
   CellID->31687254],
  Cell[5672, 211, 817, 24, 70, "Print",
   CellTags->"Info3384451318-4682455",
   CellID->30095257]},
 "Info3384451327-2156389"->{
  Cell[7095, 270, 95, 2, 70, "Print",
   CellTags->"Info3384451327-2156389",
   CellID->78488836],
  Cell[7193, 274, 831, 24, 70, "Print",
   CellTags->"Info3384451327-2156389",
   CellID->245838042]},
 "Info3384451331-3673133"->{
  Cell[8382, 321, 384, 10, 70, "Print",
   CellTags->"Info3384451331-3673133",
   CellID->733571597],
  Cell[8769, 333, 536, 17, 70, "Print",
   CellTags->"Info3384451331-3673133",
   CellID->271377073]},
 "Info3384451340-8769298"->{
  Cell[12745, 490, 96, 2, 70, "Print",
   CellTags->"Info3384451340-8769298",
   CellID->677678332],
  Cell[12844, 494, 1064, 32, 70, "Print",
   CellTags->"Info3384451340-8769298",
   CellID->433352793]},
 "Info3384451355-7834600"->{
  Cell[20806, 780, 101, 2, 70, "Print",
   CellTags->"Info3384451355-7834600",
   CellID->259412690],
  Cell[20910, 784, 864, 26, 70, "Print",
   CellTags->"Info3384451355-7834600",
   CellID->142101959]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.5.10", 35017, 1219},
 {"10.1", 35119, 1223},
 {"Info3384451318-4682455", 35239, 1227},
 {"Info3384451327-2156389", 35469, 1234},
 {"Info3384451331-3673133", 35700, 1241},
 {"Info3384451340-8769298", 35934, 1248},
 {"Info3384451355-7834600", 36169, 1255}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 684, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1309, 44, 110, 2, 70, "Title",
 CellTags->{"S2.5.10", "10.1"},
 CellID->6972],
Cell[1422, 48, 1014, 37, 70, "Text",
 CellID->26821],
Cell[2439, 87, 271, 9, 70, "Text",
 CellID->26122],
Cell[2713, 98, 764, 24, 70, "Text",
 CellID->25547],
Cell[3480, 124, 461, 16, 70, "Text",
 CellID->21577],
Cell[3944, 142, 925, 29, 70, "DefinitionBox",
 CellID->9789],
Cell[4872, 173, 83, 1, 70, "Caption",
 CellID->25605],
Cell[4958, 176, 157, 5, 70, "MathCaption",
 CellID->30195],
Cell[5118, 183, 176, 6, 70, "Input",
 CellID->27594],
Cell[5297, 191, 144, 5, 70, "MathCaption",
 CellID->7950],
Cell[CellGroupData[{
Cell[5466, 200, 83, 3, 70, "Input",
 CellID->16343],
Cell[CellGroupData[{
Cell[5574, 207, 95, 2, 70, "Print",
 CellTags->"Info3384451318-4682455",
 CellID->31687254],
Cell[5672, 211, 817, 24, 70, "Print",
 CellTags->"Info3384451318-4682455",
 CellID->30095257]
}, Open  ]]
}, Open  ]],
Cell[6516, 239, 126, 5, 70, "MathCaption",
 CellID->1012],
Cell[6645, 246, 181, 6, 70, "Input",
 CellID->11672],
Cell[6829, 254, 133, 5, 70, "MathCaption",
 CellID->23439],
Cell[CellGroupData[{
Cell[6987, 263, 83, 3, 70, "Input",
 CellID->13428],
Cell[CellGroupData[{
Cell[7095, 270, 95, 2, 70, "Print",
 CellTags->"Info3384451327-2156389",
 CellID->78488836],
Cell[7193, 274, 831, 24, 70, "Print",
 CellTags->"Info3384451327-2156389",
 CellID->245838042]
}, Open  ]]
}, Open  ]],
Cell[8051, 302, 195, 8, 70, "MathCaption",
 CellID->5967],
Cell[CellGroupData[{
Cell[8271, 314, 86, 3, 70, "Input",
 CellID->24408],
Cell[CellGroupData[{
Cell[8382, 321, 384, 10, 70, "Print",
 CellTags->"Info3384451331-3673133",
 CellID->733571597],
Cell[8769, 333, 536, 17, 70, "Print",
 CellTags->"Info3384451331-3673133",
 CellID->271377073]
}, Open  ]]
}, Open  ]],
Cell[9332, 354, 91, 1, 70, "MathCaption",
 CellID->17223],
Cell[CellGroupData[{
Cell[9448, 359, 123, 4, 70, "Input",
 CellID->11759],
Cell[9574, 365, 188, 6, 36, "Output",
 CellID->304925138]
}, Open  ]],
Cell[9777, 374, 565, 18, 70, "Text",
 CellID->5204],
Cell[10345, 394, 1745, 61, 70, "Text",
 CellID->29486],
Cell[12093, 457, 142, 5, 70, "MathCaption",
 CellID->4319],
Cell[12238, 464, 237, 8, 70, "Input",
 CellID->958],
Cell[12478, 474, 134, 5, 70, "MathCaption",
 CellID->5945],
Cell[CellGroupData[{
Cell[12637, 483, 83, 3, 70, "Input",
 CellID->26806],
Cell[CellGroupData[{
Cell[12745, 490, 96, 2, 70, "Print",
 CellTags->"Info3384451340-8769298",
 CellID->677678332],
Cell[12844, 494, 1064, 32, 70, "Print",
 CellTags->"Info3384451340-8769298",
 CellID->433352793]
}, Open  ]]
}, Open  ]],
Cell[13935, 530, 172, 5, 70, "MathCaption",
 CellID->11367],
Cell[CellGroupData[{
Cell[14132, 539, 144, 5, 70, "Input",
 CellID->17692],
Cell[14279, 546, 212, 7, 36, "Output",
 CellID->980980699]
}, Open  ]],
Cell[14506, 556, 754, 25, 70, "Text",
 CellID->28532],
Cell[15263, 583, 932, 29, 70, "Text",
 CellID->30556],
Cell[16198, 614, 904, 29, 70, "Text",
 CellID->30974],
Cell[17105, 645, 2111, 64, 70, "DefinitionBox",
 CellID->3447],
Cell[19219, 711, 67, 1, 70, "Caption",
 CellID->5021],
Cell[19289, 714, 327, 6, 70, "Text",
 CellID->18283],
Cell[19619, 722, 153, 5, 70, "MathCaption",
 CellID->26222],
Cell[CellGroupData[{
Cell[19797, 731, 126, 4, 70, "Input",
 CellID->29331],
Cell[19926, 737, 158, 5, 36, "Output",
 CellID->67375775]
}, Open  ]],
Cell[20099, 745, 81, 1, 70, "MathCaption",
 CellID->28583],
Cell[CellGroupData[{
Cell[20205, 750, 131, 4, 70, "Input",
 CellID->26948],
Cell[20339, 756, 157, 5, 36, "Output",
 CellID->3346765]
}, Open  ]],
Cell[20511, 764, 156, 5, 70, "MathCaption",
 CellID->17982],
Cell[CellGroupData[{
Cell[20692, 773, 89, 3, 70, "Input",
 CellID->22018],
Cell[CellGroupData[{
Cell[20806, 780, 101, 2, 70, "Print",
 CellTags->"Info3384451355-7834600",
 CellID->259412690],
Cell[20910, 784, 864, 26, 70, "Print",
 CellTags->"Info3384451355-7834600",
 CellID->142101959]
}, Open  ]]
}, Open  ]],
Cell[21801, 814, 850, 26, 70, "Text",
 CellID->31111],
Cell[22654, 842, 173, 5, 70, "MathCaption",
 CellID->32182],
Cell[22830, 849, 269, 9, 70, "Input",
 CellID->23856],
Cell[23102, 860, 195, 6, 70, "MathCaption",
 CellID->19490],
Cell[CellGroupData[{
Cell[23322, 870, 268, 9, 70, "Input",
 CellID->8925],
Cell[23593, 881, 521, 10, 70, "Message",
 CellID->472567486],
Cell[24117, 893, 164, 5, 36, "Output",
 CellID->71770237]
}, Open  ]],
Cell[24296, 901, 1753, 55, 70, "DefinitionBox",
 CellID->19677],
Cell[26052, 958, 82, 1, 70, "Caption",
 CellID->15969],
Cell[26137, 961, 967, 29, 70, "Text",
 CellID->11643],
Cell[27107, 992, 538, 14, 70, "Text",
 CellID->7534],
Cell[27648, 1008, 602, 19, 70, "Text",
 CellID->15677],
Cell[28253, 1029, 263, 10, 70, "MathCaption",
 CellID->22668],
Cell[28519, 1041, 235, 8, 70, "Input",
 CellID->31068],
Cell[28757, 1051, 113, 3, 70, "MathCaption",
 CellID->21991],
Cell[CellGroupData[{
Cell[28895, 1058, 192, 6, 70, "Input",
 CellID->32196],
Cell[29090, 1066, 222, 7, 36, "Output",
 CellID->576503958]
}, Open  ]],
Cell[29327, 1076, 750, 23, 70, "Text",
 CellID->16828],
Cell[30080, 1101, 748, 20, 70, "Text",
 CellID->7727],
Cell[30831, 1123, 591, 12, 70, "Text",
 CellID->29426],
Cell[CellGroupData[{
Cell[31447, 1139, 72, 1, 70, "RelatedTutorialsSection",
 CellID->660065298],
Cell[31522, 1142, 203, 5, 70, "RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],
Cell[31752, 1151, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

