(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48785,       1694]
NotebookOptionsPosition[     39057,       1384]
NotebookOutlinePosition[     43022,       1481]
CellTagsIndexPosition[     42845,       1473]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EvaluationOfExpressionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Evaluation of Expressions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:ref/Attributes"], "Clear" :> 
          Documentation`HelpLookup["paclet:ref/Clear"], "ClearAll" :> 
          Documentation`HelpLookup["paclet:ref/ClearAll"], "ClearAttributes" :> 
          Documentation`HelpLookup["paclet:ref/ClearAttributes"], "Constant" :> 
          Documentation`HelpLookup["paclet:ref/Constant"], "Constants" :> 
          Documentation`HelpLookup["paclet:ref/Constants"], "Dt" :> 
          Documentation`HelpLookup["paclet:ref/Dt"], "Flat" :> 
          Documentation`HelpLookup["paclet:ref/Flat"], "Flatten" :> 
          Documentation`HelpLookup["paclet:ref/Flatten"], "Function" :> 
          Documentation`HelpLookup["paclet:ref/Function"], "HoldAll" :> 
          Documentation`HelpLookup["paclet:ref/HoldAll"], "HoldAllComplete" :> 
          Documentation`HelpLookup["paclet:ref/HoldAllComplete"], "HoldFirst" :> 
          Documentation`HelpLookup["paclet:ref/HoldFirst"], "HoldRest" :> 
          Documentation`HelpLookup["paclet:ref/HoldRest"], "Listable" :> 
          Documentation`HelpLookup["paclet:ref/Listable"], "Locked" :> 
          Documentation`HelpLookup["paclet:ref/Locked"], "N" :> 
          Documentation`HelpLookup["paclet:ref/N"], "Needs" :> 
          Documentation`HelpLookup["paclet:ref/Needs"], "NHoldAll" :> 
          Documentation`HelpLookup["paclet:ref/NHoldAll"], "NHoldFirst" :> 
          Documentation`HelpLookup["paclet:ref/NHoldFirst"], "NHoldRest" :> 
          Documentation`HelpLookup["paclet:ref/NHoldRest"], "NumericFunction" :> 
          Documentation`HelpLookup["paclet:ref/NumericFunction"], 
          "OneIdentity" :> Documentation`HelpLookup["paclet:ref/OneIdentity"],
           "Orderless" :> Documentation`HelpLookup["paclet:ref/Orderless"], 
          "Protected" :> Documentation`HelpLookup["paclet:ref/Protected"], 
          "ReadProtected" :> 
          Documentation`HelpLookup["paclet:ref/ReadProtected"], "Sequence" :> 
          Documentation`HelpLookup["paclet:ref/Sequence"], "SequenceHold" :> 
          Documentation`HelpLookup["paclet:ref/SequenceHold"], 
          "SetAttributes" :> 
          Documentation`HelpLookup["paclet:ref/SetAttributes"], "Sort" :> 
          Documentation`HelpLookup["paclet:ref/Sort"], "Stub" :> 
          Documentation`HelpLookup["paclet:ref/Stub"], "Temporary" :> 
          Documentation`HelpLookup["paclet:ref/Temporary"], "Thread" :> 
          Documentation`HelpLookup["paclet:ref/Thread"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Attributes\"\>", 2->"\<\"Clear\"\>", 
       3->"\<\"ClearAll\"\>", 4->"\<\"ClearAttributes\"\>", 
       5->"\<\"Constant\"\>", 6->"\<\"Constants\"\>", 7->"\<\"Dt\"\>", 
       8->"\<\"Flat\"\>", 9->"\<\"Flatten\"\>", 10->"\<\"Function\"\>", 
       11->"\<\"HoldAll\"\>", 12->"\<\"HoldAllComplete\"\>", 
       13->"\<\"HoldFirst\"\>", 14->"\<\"HoldRest\"\>", 
       15->"\<\"Listable\"\>", 16->"\<\"Locked\"\>", 17->"\<\"N\"\>", 
       18->"\<\"Needs\"\>", 19->"\<\"NHoldAll\"\>", 20->"\<\"NHoldFirst\"\>", 
       21->"\<\"NHoldRest\"\>", 22->"\<\"NumericFunction\"\>", 
       23->"\<\"OneIdentity\"\>", 24->"\<\"Orderless\"\>", 
       25->"\<\"Protected\"\>", 26->"\<\"ReadProtected\"\>", 
       27->"\<\"Sequence\"\>", 28->"\<\"SequenceHold\"\>", 
       29->"\<\"SetAttributes\"\>", 30->"\<\"Sort\"\>", 31->"\<\"Stub\"\>", 
       32->"\<\"Temporary\"\>", 33->"\<\"Thread\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Attributes", "Title",
 CellTags->{"S2.6.3", "3.1"},
 CellID->9508],

Cell[TextData[{
 "Definitions such as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "=", 
   RowBox[{"x", "^", "2"}]}]], "InlineFormula"],
 " specify ",
 StyleBox["values",
  FontSlant->"Italic"],
 " for functions. Sometimes, however, you need to specify general properties \
of functions, without necessarily giving explicit values. "
}], "Text",
 CellID->7185],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a selection of ",
 StyleBox["attributes",
  FontSlant->"Italic"],
 " that you can use to specify various properties of functions. For example, \
you can use the attribute ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " to specify that a particular function is \[OpenCurlyDoubleQuote]flat\
\[CloseCurlyDoubleQuote], so that nested invocations are automatically \
flattened, and it behaves as if it were associative. "
}], "Text",
 CellID->30238],

Cell[TextData[{
 "This assigns the attribute ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " to the function ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24237],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "Flat"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26443],

Cell[TextData[{
 "Now ",
 Cell[BoxData["f"], "InlineFormula"],
 " behaves as a flat, or associative, function, so that nested invocations \
are automatically flattened. "
}], "MathCaption",
 CellID->21313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "c"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22501],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->115040948]
}, Open  ]],

Cell[TextData[{
 "Attributes like ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " can affect not only evaluation, but also operations such as pattern \
matching. If you give definitions or transformation rules for a function, you \
must be sure to have specified the attributes of the function first. "
}], "Text",
 CellID->25128],

Cell[TextData[{
 "Here is a definition for the flat function\[NonBreakingSpace]",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2111],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", "x_"}], "]"}], ":=", 
  RowBox[{"f", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->23650],

Cell[TextData[{
 "Because ",
 Cell[BoxData["f"], "InlineFormula"],
 " is flat, the definition is automatically applied to every subsequence of \
arguments. "
}], "MathCaption",
 CellID->28149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
  "a", ",", "a", ",", "a", ",", "b", ",", "b", ",", "b", ",", "c", ",", "c"}],
   "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->11192],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->78378103]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Attributes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Attributes"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "give the attributes of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Attributes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Attributes"], "[", 
     StyleBox["f", "TI"], "]", "=", "{", 
     SubscriptBox[
      StyleBox["attr", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["attr", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "set the attributes of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Attributes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Attributes"], "[", 
     StyleBox["f", "TI"], "]", "=", "{", "}"}], Cell[TextData[{
     "set ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to have no attributes"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SetAttributes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SetAttributes"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["attr", "TI"], "]"}], Cell[TextData[{
     "add ",
     Cell[BoxData[
      StyleBox["attr", "TI"]], "InlineFormula"],
     " to the attributes of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ClearAttributes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ClearAttributes"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["attr", "TI"], "]"}], Cell[TextData[{
     "remove ",
     Cell[BoxData[
      StyleBox["attr", "TI"]], "InlineFormula"],
     " from the attributes of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15869],

Cell["Manipulating attributes of symbols. ", "Caption",
 CellID->681],

Cell[TextData[{
 "This shows the attributes assigned to ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "f", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->20267],

Cell[BoxData[
 RowBox[{"{", "Flat", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->24590760]
}, Open  ]],

Cell[TextData[{
 "This removes the attributes assigned to\[NonBreakingSpace]",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Attributes", "[", "f", "]"}], "=", 
  RowBox[{"{", "}"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->18634],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->508537251]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Orderless",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Orderless"], Cell["\<\
orderless, commutative function (arguments are sorted into standard order)\
\>", "TableText"]},
   {
    ButtonBox["Flat",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Flat"], Cell["\<\
flat, associative function (arguments are \[OpenCurlyDoubleQuote]flattened \
out\[CloseCurlyDoubleQuote])\
\>", "TableText"]},
   {
    ButtonBox["OneIdentity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/OneIdentity"], Cell[TextData[{
     StyleBox["f", "TI"],
     "[",
     StyleBox["f", "TI"],
     "[",
     StyleBox["a", "TI"],
     "]",
     "]",
     ", etc. are equivalent to ",
     StyleBox["a", "TI"],
     " for pattern matching"
    }], "TableText"]},
   {
    ButtonBox["Listable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Listable"], Cell[TextData[{
     StyleBox["f", "TI"],
     " is automatically \[OpenCurlyDoubleQuote]threaded\
\[CloseCurlyDoubleQuote] over lists that appear as arguments (e.g., ",
     StyleBox["f", "TI"],
     "[",
     "{",
     StyleBox["a", "TI"],
     ",",
     StyleBox["b", "TI"],
     "}",
     "]",
     " becomes ",
     "{",
     StyleBox["f", "TI"],
     "[",
     StyleBox["a", "TI"],
     "]",
     ",",
     StyleBox["f", "TI"],
     "[",
     StyleBox["b", "TI"],
     "]",
     "}",
     ")"
    }], "TableText"]},
   {
    ButtonBox["Constant",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Constant"], Cell[TextData[{
     "all derivatives of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " are zero"
    }], "TableText"]},
   {
    ButtonBox["NumericFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumericFunction"], Cell[TextData[{
     StyleBox["f", "TI"],
     " is assumed to have a numerical value when its arguments are numeric \
quantities"
    }], "TableText"]},
   {
    ButtonBox["Protected",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Protected"], Cell[TextData[{
     "values of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " cannot be changed"
    }], "TableText"]},
   {
    ButtonBox["Locked",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Locked"], Cell[TextData[{
     "attributes of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " cannot be changed"
    }], "TableText"]},
   {
    ButtonBox["ReadProtected",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ReadProtected"], Cell[TextData[{
     "values of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " cannot be read"
    }], "TableText"]},
   {
    ButtonBox["HoldFirst",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/HoldFirst"], Cell[TextData[{
     "the first argument of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is not evaluated"
    }], "TableText"]},
   {
    ButtonBox["HoldRest",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/HoldRest"], Cell[TextData[{
     "all but the first argument of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is not evaluated"
    }], "TableText"]},
   {
    ButtonBox["HoldAll",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/HoldAll"], Cell[TextData[{
     "none of the arguments of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " are evaluated"
    }], "TableText"]},
   {
    ButtonBox["HoldAllComplete",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/HoldAllComplete"], Cell[TextData[{
     "the arguments of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " are treated as completely inert"
    }], "TableText"]},
   {
    ButtonBox["NHoldFirst",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NHoldFirst"], Cell[TextData[{
     "the first argument of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is not affected by ",
     Cell[BoxData[
      ButtonBox["N",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/N"]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["NHoldRest",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NHoldRest"], Cell[TextData[{
     "all but the first argument of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is not affected by ",
     Cell[BoxData[
      ButtonBox["N",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/N"]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["NHoldAll",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NHoldAll"], Cell[TextData[{
     "none of the arguments of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " are affected by ",
     StyleBox[ButtonBox["N",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/N"], "MR"]
    }], "TableText"]},
   {
    ButtonBox["SequenceHold",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SequenceHold"], 
    RowBox[{
     ButtonBox["Sequence",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sequence"], Cell[
     " objects appearing in the arguments of ", "TableText"], 
     StyleBox["f", "TI"], Cell[" are not flattened out", "TableText"]}]},
   {
    ButtonBox["Temporary",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Temporary"], Cell[TextData[{
     StyleBox["f", "TI"],
     " is a local variable, removed when no longer used"
    }], "TableText"]},
   {
    ButtonBox["Stub",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Stub"], 
    RowBox[{
     ButtonBox["Needs",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Needs"], Cell[
     " is automatically called if ", "TableText"], 
     StyleBox["f", "TI"], Cell[" is ever explicitly input", "TableText"]}]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, 
     False, False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20972],

Cell[TextData[{
 "The complete list of attributes for symbols in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->22830],

Cell[TextData[{
 "Here are the attributes for the built\[Hyphen]in function ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Plus", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->28442],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity", ",", 
   "Orderless", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{466, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->24926627]
}, Open  ]],

Cell[TextData[{
 "An important attribute assigned to built\[Hyphen]in mathematical functions \
in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is the attribute ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 ". This attribute specifies that a function should automatically be \
distributed or \[OpenCurlyDoubleQuote]threaded\[CloseCurlyDoubleQuote] over \
lists that appear as its arguments. This means that the function effectively \
gets applied separately to each element in any lists that appear as its \
arguments. "
}], "Text",
 CellID->13877],

Cell[TextData[{
 "The built\[Hyphen]in ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " function is ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"{", 
   RowBox[{"5", ",", "8", ",", "11"}], "}"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->702],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Log", "[", "5", "]"}], ",", 
   RowBox[{"Log", "[", "8", "]"}], ",", 
   RowBox[{"Log", "[", "11", "]"}]}], "}"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->543902148]
}, Open  ]],

Cell[TextData[{
 "This defines the function ",
 Cell[BoxData["p"], "InlineFormula"],
 " to be listable. "
}], "MathCaption",
 CellID->1381],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"p", ",", "Listable"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->16590],

Cell[TextData[{
 "Now ",
 Cell[BoxData["p"], "InlineFormula"],
 " is automatically threaded over lists that appear as its arguments. "
}], "MathCaption",
 CellID->8823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "d"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->2237],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"a", ",", "d"}], "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{"b", ",", "d"}], "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{"c", ",", "d"}], "]"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->717637344]
}, Open  ]],

Cell[TextData[{
 "Many of the attributes you can assign to functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " directly affect the evaluation of those functions. Some attributes, \
however, affect only other aspects of the treatment of functions. For \
example, the attribute ",
 Cell[BoxData[
  ButtonBox["OneIdentity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OneIdentity"]], "InlineFormula"],
 " affects only pattern matching, as discussed in \"",
 ButtonBox["Flat and Orderless Functions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/FlatAndOrderlessFunctions"],
 ". Similarly, the attribute ",
 Cell[BoxData[
  ButtonBox["Constant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Constant"]], "InlineFormula"],
 " is only relevant in differentiation, and operations that rely on \
differentiation. "
}], "Text",
 CellID->32179],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 " attribute affects assignments. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not allow you to make any definition associated with a symbol that \
carries this attribute. The functions ",
 Cell[BoxData[
  ButtonBox["Protect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protect"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Unprotect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unprotect"]], "InlineFormula"],
 " discussed in \"",
 ButtonBox["Modifying Built-in Functions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ModifyingBuiltInFunctions"],
 " can be used as alternatives to ",
 Cell[BoxData[
  ButtonBox["SetAttributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetAttributes"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ClearAttributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClearAttributes"]], "InlineFormula"],
 " to set and clear this attribute. As discussed in \"",
 ButtonBox["Modifying Built-in Functions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ModifyingBuiltInFunctions"],
 " most built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " objects are initially protected so that you do not make definitions for \
them by mistake. "
}], "Text",
 CellID->16595],

Cell[TextData[{
 "Here is a definition for the function ",
 Cell[BoxData["g"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], "=", 
  RowBox[{"x", "+", "1"}]}]], "Input",
 CellLabel->"In[11]:=",
 CellID->2327],

Cell[BoxData[
 RowBox[{"1", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->91324689]
}, Open  ]],

Cell[TextData[{
 "This sets the ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 " attribute for\[NonBreakingSpace]",
 Cell[BoxData["g"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Protect", "[", "g", "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->28182],

Cell[BoxData[
 RowBox[{"{", "\<\"g\"\>", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->310540089]
}, Open  ]],

Cell[TextData[{
 "Now you cannot modify the definition of ",
 Cell[BoxData["g"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], "=", "x"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->9487],

Cell[BoxData[
 RowBox[{
  RowBox[{"Set", "::", "\<\"write\"\>"}], ":", 
  " ", "\<\"Tag \\!\\(g\\) in \\!\\(g[x_]\\) is Protected. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/write\\\", \
ButtonNote -> \\\"Set::write\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[13]:=",
 CellID->378958406],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->369591818]
}, Open  ]],

Cell[TextData[{
 "You can usually see the definitions you have made for a particular symbol \
by typing ",
 Cell[BoxData[
  RowBox[{"?", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 ", or by using a variety of built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions. However, if you set the attribute ",
 Cell[BoxData[
  ButtonBox["ReadProtected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadProtected"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will not allow you to look at the definition of a particular symbol. It \
will nevertheless continue to use the definitions in performing evaluation. "
}], "Text",
 CellID->5651],

Cell[TextData[{
 "Although you cannot modify it, you can still look at the definition of ",
 Cell[BoxData["g"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "g"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->7213],

Cell[CellGroupData[{

Cell["Global`g", "Print", "PrintUsage",
 CellTags->"Info3384451662-6244704",
 CellID->381750248],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "g", "]"}], "=", 
      RowBox[{"{", "Protected", "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"g", "[", "x_", "]"}], "=", 
         RowBox[{"1", "+", "x"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["g"],
  Editable->False]], "Print",
 CellTags->"Info3384451662-6244704",
 CellID->199467698]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "This sets the ",
 Cell[BoxData[
  ButtonBox["ReadProtected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadProtected"]], "InlineFormula"],
 " attribute for ",
 Cell[BoxData["g"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21286],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"g", ",", "ReadProtected"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->2742],

Cell[TextData[{
 "Now you can no longer read the definition of ",
 Cell[BoxData["g"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "g"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->4472],

Cell[CellGroupData[{

Cell["Global`g", "Print", "PrintUsage",
 CellTags->"Info3384451668-2548824",
 CellID->90493700],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "g", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"Protected", ",", "ReadProtected"}], "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["g"],
  Editable->False]], "Print",
 CellTags->"Info3384451668-2548824",
 CellID->688040568]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["SetAttributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetAttributes"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ClearAttributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClearAttributes"]], "InlineFormula"],
 " usually allow you to modify the attributes of a symbol in any way. \
However, if you once set the ",
 Cell[BoxData[
  ButtonBox["Locked",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locked"]], "InlineFormula"],
 " attribute on a symbol, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will not allow you to modify the attributes of that symbol for the \
remainder of your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. Using the ",
 Cell[BoxData[
  ButtonBox["Locked",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locked"]], "InlineFormula"],
 " attribute in addition to ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ReadProtected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadProtected"]], "InlineFormula"],
 ", you can arrange for it to be impossible for users to modify or read \
definitions. "
}], "Text",
 CellID->5841],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Clear",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Clear"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "remove values for ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ", but not attributes"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ClearAll",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ClearAll"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "remove both values and attributes of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20718],

Cell["Clearing values and attributes. ", "Caption",
 CellID->3503],

Cell[TextData[{
 "This clears values and attributes of ",
 Cell[BoxData["p"], "InlineFormula"],
 " which was given attribute ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 " above. "
}], "MathCaption",
 CellID->14867],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "p", "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->24865],

Cell[TextData[{
 "Now ",
 Cell[BoxData["p"], "InlineFormula"],
 " is no longer listable. "
}], "MathCaption",
 CellID->10938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "d"}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->1881],

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "d"}], "]"}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->36571062]
}, Open  ]],

Cell[TextData[{
 "By defining attributes for a function you specify properties that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " should assume whenever that function appears. Often, however, you want to \
assume the properties only in a particular instance. In such cases, you will \
be better off not to use attributes, but instead to call a particular \
function to implement the transformation associated with the attributes. "
}], "Text",
 CellID->22750],

Cell[TextData[{
 "By explicitly calling ",
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 ", you can implement the transformation that would be done automatically if \
",
 Cell[BoxData["p"], "InlineFormula"],
 " were listable. "
}], "MathCaption",
 CellID->28614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"p", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "d"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->18598],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"a", ",", "d"}], "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{"b", ",", "d"}], "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{"c", ",", "d"}], "]"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->403832593]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Orderless",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Orderless"], 
    RowBox[{
     ButtonBox["Sort",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sort"], "[", 
     StyleBox["f", "TI"], "[", 
     StyleBox["args", "TI"], "]", "]"}]},
   {
    ButtonBox["Flat",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Flat"], 
    RowBox[{
     ButtonBox["Flatten",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Flatten"], "[", 
     StyleBox["f", "TI"], "[", 
     StyleBox["args", "TI"], "]", "]"}]},
   {
    ButtonBox["Listable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Listable"], 
    RowBox[{
     ButtonBox["Thread",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Thread"], "[", 
     StyleBox["f", "TI"], "[", 
     StyleBox["args", "TI"], "]", "]"}]},
   {
    ButtonBox["Constant",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Constant"], 
    RowBox[{
     ButtonBox["Dt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dt"], "[", 
     StyleBox["expr", "TI"], ",", 
     ButtonBox["Constants",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Constants"], "->", 
     StyleBox["f", "TI"], "]"}]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2661],

Cell["\<\
Functions that perform transformations associated with some attributes. \
\>", "Caption",
 CellID->26063],

Cell[TextData[{
 "Attributes in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can only be permanently defined for single symbols. However, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also allows you to set up pure functions which behave as if they carry \
attributes. "
}], "Text",
 CellID->32756],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Function",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Function"], "[", 
     StyleBox["vars", "TI"], ",", 
     StyleBox["body", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["attr", "TI"], "1"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "a pure function with attributes ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["attr", "TI"], "1"]], "InlineFormula"],
     ", \[Ellipsis]",
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20807],

Cell["Pure functions with attributes. ", "Caption",
 CellID->20278],

Cell[TextData[{
 "This pure function applies ",
 Cell[BoxData["p"], "InlineFormula"],
 " to the whole list. "
}], "MathCaption",
 CellID->19489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{"p", "[", "x", "]"}]}], "]"}], "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->19435],

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->211152311]
}, Open  ]],

Cell[TextData[{
 "By adding the attribute ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 ", the function gets distributed over the elements of the list before \
applying ",
 Cell[BoxData["p"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->32075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{"p", "[", "x", "]"}], ",", 
    RowBox[{"{", "Listable", "}"}]}], "]"}], "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->7586],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p", "[", "a", "]"}], ",", 
   RowBox[{"p", "[", "b", "]"}], ",", 
   RowBox[{"p", "[", "c", "]"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->75846936]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->101895465],

Cell[TextData[ButtonBox["Evaluation of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EvaluationOfExpressionsOverview"]], "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Attributes - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Evaluation of Expressions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/EvaluationOfExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ReducingExpressionsToTheirStandardForm"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheStandardEvaluationProcedure"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 53.5919522}", "context" -> "", 
    "keywords" -> {
     "attributes", "builtin functions", "built-in functions", "clear", 
      "ClearAll", "ClearAttributes", "constant", "flat", "functions", 
      "hidden", "HoldAll", "HoldAllComplete", "HoldFirst", "HoldRest", 
      "invisible", "Listable", "lists", "locked", "NHoldAll", "NHoldFirst", 
      "NHoldRest", "NumericFunction", "OneIdentity", "orderless", 
      "properties", "protect", "protected", "protection", "pure functions", 
      "ReadProtected", "security", "SequenceHold", "SetAttributes", "stub", 
      "symbols", "temporary", "threading", "Unprotect"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Definitions such as f[x_]=x^2 specify values for functions. Sometimes, \
however, you need to specify general properties of functions, without \
necessarily giving explicit values. Mathematica provides a selection of \
attributes that you can use to specify various properties of functions. For \
example, you can use the attribute Flat to specify that a particular function \
is 'flat', so that nested invocations are automatically flattened, and it \
behaves as if it were associative. This assigns the attribute Flat to the \
function f. ", "synonyms" -> {"2.6.3"}, "title" -> "Attributes", "type" -> 
    "Tutorial", "uri" -> "tutorial/Attributes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.6.3"->{
  Cell[5109, 105, 72, 2, 70, "Title",
   CellTags->{"S2.6.3", "3.1"},
   CellID->9508]},
 "3.1"->{
  Cell[5109, 105, 72, 2, 70, "Title",
   CellTags->{"S2.6.3", "3.1"},
   CellID->9508]},
 "Info3384451662-6244704"->{
  Cell[26909, 922, 96, 2, 70, "Print",
   CellTags->"Info3384451662-6244704",
   CellID->381750248],
  Cell[27008, 926, 899, 28, 70, "Print",
   CellTags->"Info3384451662-6244704",
   CellID->199467698]},
 "Info3384451668-2548824"->{
  Cell[28618, 992, 95, 2, 70, "Print",
   CellTags->"Info3384451668-2548824",
   CellID->90493700],
  Cell[28716, 996, 474, 15, 70, "Print",
   CellTags->"Info3384451668-2548824",
   CellID->688040568]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.6.3", 42167, 1448},
 {"3.1", 42266, 1452},
 {"Info3384451662-6244704", 42384, 1456},
 {"Info3384451668-2548824", 42618, 1463}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 4484, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5109, 105, 72, 2, 70, "Title",
 CellTags->{"S2.6.3", "3.1"},
 CellID->9508],
Cell[5184, 109, 379, 12, 70, "Text",
 CellID->7185],
Cell[5566, 123, 590, 16, 70, "Text",
 CellID->30238],
Cell[6159, 141, 259, 10, 70, "MathCaption",
 CellID->24237],
Cell[6421, 153, 131, 4, 70, "Input",
 CellID->26443],
Cell[6555, 159, 205, 6, 70, "MathCaption",
 CellID->21313],
Cell[CellGroupData[{
Cell[6785, 169, 170, 6, 28, "Input",
 CellID->22501],
Cell[6958, 177, 218, 7, 36, "Output",
 CellID->115040948]
}, Open  ]],
Cell[7191, 187, 399, 10, 70, "Text",
 CellID->25128],
Cell[7593, 199, 159, 5, 70, "MathCaption",
 CellID->2111],
Cell[7755, 206, 171, 6, 70, "Input",
 CellID->23650],
Cell[7929, 214, 192, 6, 70, "MathCaption",
 CellID->28149],
Cell[CellGroupData[{
Cell[8146, 224, 182, 6, 70, "Input",
 CellID->11192],
Cell[8331, 232, 217, 7, 36, "Output",
 CellID->78378103]
}, Open  ]],
Cell[8563, 242, 2438, 78, 70, "DefinitionBox",
 CellID->15869],
Cell[11004, 322, 69, 1, 70, "Caption",
 CellID->681],
Cell[11076, 325, 137, 5, 70, "MathCaption",
 CellID->27465],
Cell[CellGroupData[{
Cell[11238, 334, 102, 3, 70, "Input",
 CellID->20267],
Cell[11343, 339, 182, 6, 36, "Output",
 CellID->24590760]
}, Open  ]],
Cell[11540, 348, 157, 5, 70, "MathCaption",
 CellID->19793],
Cell[CellGroupData[{
Cell[11722, 357, 143, 5, 70, "Input",
 CellID->18634],
Cell[11868, 364, 175, 6, 36, "Output",
 CellID->508537251]
}, Open  ]],
Cell[12058, 373, 6216, 214, 70, "DefinitionBox",
 CellID->20972],
Cell[18277, 589, 153, 6, 70, "Caption",
 CellID->22830],
Cell[18433, 597, 230, 8, 70, "MathCaption",
 CellID->24901],
Cell[CellGroupData[{
Cell[18688, 609, 105, 3, 70, "Input",
 CellID->28442],
Cell[18796, 614, 300, 9, 36, "Output",
 CellID->24926627]
}, Open  ]],
Cell[19111, 626, 634, 16, 70, "Text",
 CellID->13877],
Cell[19748, 644, 328, 13, 70, "MathCaption",
 CellID->25770],
Cell[CellGroupData[{
Cell[20101, 661, 151, 5, 70, "Input",
 CellID->702],
Cell[20255, 668, 308, 10, 36, "Output",
 CellID->543902148]
}, Open  ]],
Cell[20578, 681, 139, 5, 70, "MathCaption",
 CellID->1381],
Cell[20720, 688, 135, 4, 70, "Input",
 CellID->16590],
Cell[20858, 694, 168, 5, 70, "MathCaption",
 CellID->8823],
Cell[CellGroupData[{
Cell[21051, 703, 175, 6, 70, "Input",
 CellID->2237],
Cell[21229, 711, 377, 13, 36, "Output",
 CellID->717637344]
}, Open  ]],
Cell[21621, 727, 868, 23, 70, "Text",
 CellID->32179],
Cell[22492, 752, 1437, 44, 70, "Text",
 CellID->16595],
Cell[23932, 798, 137, 5, 70, "MathCaption",
 CellID->20169],
Cell[CellGroupData[{
Cell[24094, 807, 140, 5, 70, "Input",
 CellID->2327],
Cell[24237, 814, 180, 6, 36, "Output",
 CellID->91324689]
}, Open  ]],
Cell[24432, 823, 272, 10, 70, "MathCaption",
 CellID->31310],
Cell[CellGroupData[{
Cell[24729, 837, 100, 3, 70, "Input",
 CellID->28182],
Cell[24832, 842, 189, 6, 36, "Output",
 CellID->310540089]
}, Open  ]],
Cell[25036, 851, 138, 5, 70, "MathCaption",
 CellID->7926],
Cell[CellGroupData[{
Cell[25199, 860, 117, 4, 70, "Input",
 CellID->9487],
Cell[25319, 866, 410, 8, 70, "Message",
 CellID->378958406],
Cell[25732, 876, 159, 5, 36, "Output",
 CellID->369591818]
}, Open  ]],
Cell[25906, 884, 698, 20, 70, "Text",
 CellID->5651],
Cell[26607, 906, 169, 5, 70, "MathCaption",
 CellID->2258],
Cell[CellGroupData[{
Cell[26801, 915, 83, 3, 70, "Input",
 CellID->7213],
Cell[CellGroupData[{
Cell[26909, 922, 96, 2, 70, "Print",
 CellTags->"Info3384451662-6244704",
 CellID->381750248],
Cell[27008, 926, 899, 28, 70, "Print",
 CellTags->"Info3384451662-6244704",
 CellID->199467698]
}, Open  ]]
}, Open  ]],
Cell[27934, 958, 262, 10, 70, "MathCaption",
 CellID->21286],
Cell[28199, 970, 140, 4, 70, "Input",
 CellID->2742],
Cell[28342, 976, 143, 5, 70, "MathCaption",
 CellID->8610],
Cell[CellGroupData[{
Cell[28510, 985, 83, 3, 70, "Input",
 CellID->4472],
Cell[CellGroupData[{
Cell[28618, 992, 95, 2, 70, "Print",
 CellTags->"Info3384451668-2548824",
 CellID->90493700],
Cell[28716, 996, 474, 15, 70, "Print",
 CellTags->"Info3384451668-2548824",
 CellID->688040568]
}, Open  ]]
}, Open  ]],
Cell[29217, 1015, 1297, 42, 70, "Text",
 CellID->5841],
Cell[30517, 1059, 939, 30, 70, "DefinitionBox",
 CellID->20718],
Cell[31459, 1091, 66, 1, 70, "Caption",
 CellID->3503],
Cell[31528, 1094, 293, 10, 70, "MathCaption",
 CellID->14867],
Cell[31824, 1106, 101, 3, 70, "Input",
 CellID->24865],
Cell[31928, 1111, 125, 5, 70, "MathCaption",
 CellID->10938],
Cell[CellGroupData[{
Cell[32078, 1120, 175, 6, 70, "Input",
 CellID->1881],
Cell[32256, 1128, 268, 9, 36, "Output",
 CellID->36571062]
}, Open  ]],
Cell[32539, 1140, 468, 9, 70, "Text",
 CellID->22750],
Cell[33010, 1151, 332, 11, 70, "MathCaption",
 CellID->28614],
Cell[CellGroupData[{
Cell[33367, 1166, 215, 8, 70, "Input",
 CellID->18598],
Cell[33585, 1176, 377, 13, 36, "Output",
 CellID->403832593]
}, Open  ]],
Cell[33977, 1192, 1564, 52, 70, "DefinitionBox",
 CellID->2661],
Cell[35544, 1246, 115, 3, 70, "Caption",
 CellID->26063],
Cell[35662, 1251, 317, 10, 70, "Text",
 CellID->32756],
Cell[35982, 1263, 999, 30, 70, "DefinitionBox",
 CellID->20807],
Cell[36984, 1295, 67, 1, 70, "Caption",
 CellID->20278],
Cell[37054, 1298, 144, 5, 70, "MathCaption",
 CellID->19489],
Cell[CellGroupData[{
Cell[37223, 1307, 265, 9, 70, "Input",
 CellID->19435],
Cell[37491, 1318, 243, 8, 36, "Output",
 CellID->211152311]
}, Open  ]],
Cell[37749, 1329, 327, 11, 70, "MathCaption",
 CellID->32075],
Cell[CellGroupData[{
Cell[38101, 1344, 306, 10, 70, "Input",
 CellID->7586],
Cell[38410, 1356, 301, 10, 36, "Output",
 CellID->75846936]
}, Open  ]],
Cell[CellGroupData[{
Cell[38748, 1371, 72, 1, 70, "RelatedTutorialsSection",
 CellID->101895465],
Cell[38823, 1374, 180, 4, 70, "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],
Cell[39030, 1382, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

