(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16876,        524]
NotebookOptionsPosition[     12049,        384]
NotebookOutlinePosition[     15111,        461]
CellTagsIndexPosition[     15019,        455]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"The Internals of Mathematica" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TheInternalsOfMathematicaOverview"], 
         "The Algorithms of Mathematica" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TheAlgorithmsOfMathematica"], 
         "The Software Engineering of Mathematica" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TheSoftwareEngineeringOfMathematica"], 
         "Testing and Verification" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TestingAndVerification"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"The Internals of Mathematica\"\>", 
      2->"\<\"The Algorithms of Mathematica\"\>", 
      3->"\<\"The Software Engineering of Mathematica\"\>", 
      4->"\<\"Testing and Verification\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Basic Internal Architecture", "Title",
 CellTags->{"S1.12.2", "2.1"},
 CellID->6608],

Cell[BoxData[GridBox[{
   {Cell["numbers", "TableText"], Cell[
    "sequences of binary digits", "TableText"]},
   {Cell["strings", "TableText"], Cell[
    "sequences of character code bytes or byte pairs", "TableText"]},
   {Cell["symbols", "TableText"], Cell[
    "pointers to the central table of symbols", "TableText"]},
   {Cell["general expressions", "TableText"], Cell[
    "sequences of pointers to the head and elements", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9252],

Cell[TextData[{
 "Internal representations used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->11647],

Cell[TextData[{
 "When you type input into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", a data structure is created in the memory of your computer to represent \
the expression you have entered. "
}], "Text",
 CellID->17432],

Cell[TextData[{
 "In general, different pieces of your expression will be stored at different \
places in memory. Thus, for example, for a list such as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"2", ",", "x", ",", 
    RowBox[{"y", "+", "z"}]}], "}"}]], "InlineFormula"],
 " the \[OpenCurlyDoubleQuote]backbone\[CloseCurlyDoubleQuote] of the list \
will be stored at one place, while each of the actual elements will be stored \
at a different place. "
}], "Text",
 CellID->9535],

Cell["\<\
The backbone of the list then consists just of three \
\[OpenCurlyDoubleQuote]pointers\[CloseCurlyDoubleQuote] that specify the \
addresses in computer memory at which the actual expressions that form the \
elements of the list are to be found. These expressions then in turn contain \
pointers to their subexpressions. The chain of pointers ends when one reaches \
an object such as a number or a string, which is stored directly as a pattern \
of bits in computer memory. \
\>", "Text",
 CellID->7208],

Cell[TextData[{
 "Crucial to the operation of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is the notion of symbols such as ",
 Cell[BoxData["x"], "InlineFormula"],
 ". Whenever ",
 Cell[BoxData["x"], "InlineFormula"],
 " appears in an expression, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " represents it by a pointer. But the pointer is always to the same place in \
computer memory\[LongDash]an entry in a central table of all symbols defined \
in your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session."
}], "Text",
 CellID->3264],

Cell["\<\
This table is a repository of all information about each symbol. It contains \
a pointer to a string giving the symbol\[CloseCurlyQuote]s name, as well as \
pointers to expressions which give rules for evaluating the symbol. \
\>", "Text",
 CellID->3497],

Cell[BoxData[GridBox[{
   {Cell["\<\
\[FilledSmallSquare] Recycle memory as soon as the data in it is no longer \
referenced.\
\>", "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23243],

Cell[TextData[{
 "The basic principle of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " memory management. "
}], "Caption",
 CellID->27649],

Cell[TextData[{
 "Every piece of memory used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " maintains a count of how many pointers currently point to it. When this \
count drops to zero, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows that the piece of memory is no longer being referenced, and \
immediately makes the piece of memory available for something new. "
}], "Text",
 CellID->22015],

Cell[TextData[{
 "This strategy essentially ensures that no memory is ever wasted, and that \
any piece of memory that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses is actually storing data that you need to access in your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Text",
 CellID->26841],

Cell[BoxData[GridBox[{
   {Cell["\<\
\[FilledSmallSquare] Create an expression corresponding to the input you have \
given.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Process the expression using all rules known for the \
objects in it.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Generate output corresponding to the resulting \
expression.\
\>", "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->189],

Cell[TextData[{
 "The basic actions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->16100],

Cell[TextData[{
 "At the heart of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is a conceptually simple procedure known as the ",
 StyleBox["evaluator",
  FontSlant->"Italic"],
 " which takes every function that appears in an expression and evaluates \
that function. "
}], "Text",
 CellID->19812],

Cell[TextData[{
 "When the function is one of the thousand or so that are built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", what the evaluator does is to execute directly internal code in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system. This code is set up to perform the operations corresponding to the \
function, and then to build a new expression representing the result. "
}], "Text",
 CellID->30648],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] The built\[Hyphen]in functions of ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " support universal computation."
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9523],

Cell[TextData[{
 "The basic feature that makes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " a self\[Hyphen]contained system. "
}], "Caption",
 CellID->19851],

Cell[TextData[{
 "A crucial feature of the built\[Hyphen]in functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is that they support ",
 StyleBox["universal computation",
  FontSlant->"Italic"],
 ". What this means is that out of these functions you can construct programs \
that perform absolutely any kinds of operations that are possible for a \
computer. "
}], "Text",
 CellID->24474],

Cell[TextData[{
 "As it turns out, small subsets of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s built\[Hyphen]in functions would be quite sufficient to \
support universal computation. But having the whole collection of functions \
makes it in practice easier to construct the programs one needs. "
}], "Text",
 CellID->28633],

Cell[TextData[{
 "The underlying point, however, is that because ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports universal computation you never have to modify its \
built\[Hyphen]in functions: all you have to do to perform a particular task \
is to combine these functions in an appropriate way. "
}], "Text",
 CellID->29891],

Cell[TextData[{
 "Universal computation is the basis for all standard computer languages. But \
many of these languages rely on the idea of ",
 StyleBox["compilation",
  FontSlant->"Italic"],
 ". If you use C or Fortran, for example, you first write your program, then \
you compile it to generate machine code that can actually be executed on your \
computer."
}], "Text",
 CellID->27200],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not require you to go through the compilation step: once you have \
input an expression, the functions in the expression can immediately be \
executed. "
}], "Text",
 CellID->19854],

Cell[TextData[{
 "Often ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will preprocess expressions that you enter, arranging things so that \
subsequent execution will be as efficient as possible. But such preprocessing \
never affects the results that are generated, and can rarely be seen \
explicitly. "
}], "Text",
 CellID->9990],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->395869591],

Cell[TextData[{
 ButtonBox["The Internals of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheInternalsOfMathematicaOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheInternalsOfMathematicaOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->666254040],

Cell[TextData[{
 ButtonBox["The Algorithms of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheAlgorithmsOfMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheAlgorithmsOfMathematica"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->820035495],

Cell[TextData[{
 ButtonBox["The Software Engineering of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheSoftwareEngineeringOfMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheSoftwareEngineeringOfMathematica"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->889871574],

Cell[TextData[ButtonBox["Testing and Verification",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TestingAndVerification"]], "RelatedTutorials",
 CellID->449263826]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Basic Internal Architecture - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Internals of Mathematica", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheInternalsOfMathematicaOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/WhyYouDoNotUsuallyNeedToKnowAboutInternals"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheAlgorithmsOfMathematica"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 55.5451272}", "context" -> "", 
    "keywords" -> {
     "data structures", "expressions", "garbage collection", 
      "internal representation", "interpreter", "memory management", 
      "pointers", "programmability", "storage", "symbol table", 
      "universal computation"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Internal representations used by Mathematica. When you type input into \
Mathematica, a data structure is created in the memory of your computer to \
represent the expression you have entered. In general, different pieces of \
your expression will be stored at different places in memory. Thus, for \
example, for a list such as {2,x,y+z} the 'backbone' of the list will be \
stored at one place, while each of the actual elements will be stored at a \
different place. ", "synonyms" -> {"1.12.2"}, "title" -> 
    "Basic Internal Architecture", "type" -> "Tutorial", "uri" -> 
    "tutorial/BasicInternalArchitecture"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.12.2"->{
  Cell[1857, 54, 90, 2, 70, "Title",
   CellTags->{"S1.12.2", "2.1"},
   CellID->6608]},
 "2.1"->{
  Cell[1857, 54, 90, 2, 70, "Title",
   CellTags->{"S1.12.2", "2.1"},
   CellID->6608]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.12.2", 14808, 444},
 {"2.1", 14907, 448}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1232, 27, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1857, 54, 90, 2, 70, "Title",
 CellTags->{"S1.12.2", "2.1"},
 CellID->6608],
Cell[1950, 58, 785, 17, 70, "DefinitionBox",
 CellID->9252],
Cell[2738, 77, 139, 6, 70, "Caption",
 CellID->11647],
Cell[2880, 85, 235, 7, 70, "Text",
 CellID->17432],
Cell[3118, 94, 482, 11, 70, "Text",
 CellID->9535],
Cell[3603, 107, 513, 9, 70, "Text",
 CellID->7208],
Cell[4119, 118, 568, 18, 70, "Text",
 CellID->3264],
Cell[4690, 138, 264, 5, 70, "Text",
 CellID->3497],
Cell[4957, 145, 460, 13, 70, "FramedBox",
 CellID->23243],
Cell[5420, 160, 147, 6, 70, "Caption",
 CellID->27649],
Cell[5570, 168, 417, 11, 70, "Text",
 CellID->22015],
Cell[5990, 181, 329, 10, 70, "Text",
 CellID->26841],
Cell[6322, 193, 715, 21, 70, "FramedBox",
 CellID->189],
Cell[7040, 216, 127, 6, 70, "Caption",
 CellID->16100],
Cell[7170, 224, 307, 10, 70, "Text",
 CellID->19812],
Cell[7480, 236, 440, 10, 70, "Text",
 CellID->30648],
Cell[7923, 248, 538, 15, 70, "FramedBox",
 CellID->9523],
Cell[8464, 265, 167, 6, 70, "Caption",
 CellID->19851],
Cell[8634, 273, 404, 11, 70, "Text",
 CellID->24474],
Cell[9041, 286, 356, 8, 70, "Text",
 CellID->28633],
Cell[9400, 296, 342, 8, 70, "Text",
 CellID->29891],
Cell[9745, 306, 389, 9, 70, "Text",
 CellID->27200],
Cell[10137, 317, 254, 7, 70, "Text",
 CellID->19854],
Cell[10394, 326, 341, 9, 70, "Text",
 CellID->9990],
Cell[CellGroupData[{
Cell[10760, 339, 72, 1, 70, "RelatedTutorialsSection",
 CellID->395869591],
Cell[10835, 342, 327, 9, 70, "RelatedTutorials",
 CellID->666254040],
Cell[11165, 353, 314, 9, 70, "RelatedTutorials",
 CellID->820035495],
Cell[11482, 364, 342, 9, 70, "RelatedTutorials",
 CellID->889871574],
Cell[11827, 375, 168, 3, 70, "RelatedTutorials",
 CellID->449263826]
}, Open  ]]
}, Open  ]],
Cell[12022, 382, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

