(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25173,        932]
NotebookOptionsPosition[     19918,        754]
NotebookOutlinePosition[     21966,        810]
CellTagsIndexPosition[     21875,        804]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ConjugateTranspose" :> 
         Documentation`HelpLookup["paclet:ref/ConjugateTranspose"], "Det" :> 
         Documentation`HelpLookup["paclet:ref/Det"], "Inverse" :> 
         Documentation`HelpLookup["paclet:ref/Inverse"], "MatrixExp" :> 
         Documentation`HelpLookup["paclet:ref/MatrixExp"], "MatrixPower" :> 
         Documentation`HelpLookup["paclet:ref/MatrixPower"], "MatrixRank" :> 
         Documentation`HelpLookup["paclet:ref/MatrixRank"], "Minors" :> 
         Documentation`HelpLookup["paclet:ref/Minors"], "Tr" :> 
         Documentation`HelpLookup["paclet:ref/Tr"], "Transpose" :> 
         Documentation`HelpLookup["paclet:ref/Transpose"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"ConjugateTranspose\"\>", 
      2->"\<\"Det\"\>", 3->"\<\"Inverse\"\>", 4->"\<\"MatrixExp\"\>", 
      5->"\<\"MatrixPower\"\>", 6->"\<\"MatrixRank\"\>", 7->"\<\"Minors\"\>", 
      8->"\<\"Tr\"\>", 9->"\<\"Transpose\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Basic Matrix Operations", "Title",
 CellTags->{"S3.7.7", "7.1"},
 CellID->25697],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "transpose ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["m", "TI"], "\[Transpose]"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ConjugateTranspose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ConjugateTranspose"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "conjugate transpose ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["m", "TI"], "\[ConjugateTranspose]"]], "InlineFormula"],
     " (Hermitian conjugate)"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Inverse",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Inverse"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["matrix inverse", "TableText"]},
   {
    RowBox[{
     ButtonBox["Det",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Det"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["determinant", "TableText"]},
   {
    RowBox[{
     ButtonBox["Minors",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Minors"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["matrix of minors", "TableText"]},
   {
    RowBox[{
     ButtonBox["Minors",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Minors"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " minors"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Tr",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tr"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["trace", "TableText"]},
   {
    RowBox[{
     ButtonBox["MatrixRank",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixRank"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["rank of matrix", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4919],

Cell["Some basic matrix operations. ", "Caption",
 CellID->17780],

Cell[TextData[{
 "Transposing a matrix interchanges the rows and columns in the matrix. If \
you transpose an ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 "\[Times]",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " matrix, you get an ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "\[Times]",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " matrix as the result. "
}], "Text",
 CellID->22578],

Cell["\<\
Transposing a 2\[Times]3 matrix gives a 3\[Times]2 result. \
\>", "MathCaption",
 CellID->12931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"ap", ",", "bp", ",", "cp"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32544],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "ap"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "bp"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "cp"}], "}"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19668749]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Det",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Det"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " gives the determinant of a square matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Minors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minors"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " is the matrix whose ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"i", ",", "j"}], ")"}], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " element gives the determinant of the submatrix obtained by deleting the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"n", "-", "i", "+", "1"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " row and the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"n", "-", "j", "+", "1"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " column of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". The ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"i", ",", "j"}], ")"}], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " cofactor of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"i", "+", "j"}]], TraditionalForm]], "InlineMath"],
 " times the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"n", "-", "i", "+", "1", ",", "n", "-", "j", "+", "1"}], ")"}], 
   TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " element of the matrix of minors. "
}], "Text",
 CellID->13487],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Minors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minors"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " gives the determinants of the ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 "\[Times]",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " submatrices obtained by picking each possible set of ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " rows and ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " columns from ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". Note that you can apply ",
 Cell[BoxData[
  ButtonBox["Minors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minors"]], "InlineFormula"],
 " to rectangular, as well as square, matrices. "
}], "Text",
 CellID->899],

Cell["\<\
Here is the determinant of a simple 2\[Times]2 matrix. \
\>", "MathCaption",
 CellID->22525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8483],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "b"}], " ", "c"}], "+", 
  RowBox[{"a", " ", "d"}]}]], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8081856]
}, Open  ]],

Cell[TextData[{
 "This generates a 3",
 "\[Times]",
 "3 matrix, whose ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", ",", "j"}], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " entry is ",
 Cell[BoxData[
  RowBox[{"a", "[", 
   RowBox[{
    StyleBox["i", "TI"], ",", 
    StyleBox["j", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"Array", "[", 
   RowBox[{"a", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6193],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "2"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "3"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "2"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "3"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"3", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"3", ",", "2"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"3", ",", "3"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{566, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->13826472]
}, Open  ]],

Cell[TextData[{
 "Here is the determinant of ",
 Cell[BoxData["m"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", "m", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1560],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWcFS2zAQVew4gbaJDZcCJ/oz7akfkWE6Ew4MDPC77a9QyYpjz7Jid6W1
nACZiceW5Cft02otvf29ed7+uds8395srn89bh62tzdP1z/vH21ROTNm9tcY
8+PC2PsXe9f+3e+f/ftbf3dmr4Wt/Oqeyq7Vi6l35U1i/dWR49d7loa1X3a1
sHyt3O7ig/W7atk+tdfKFpagttiVz0H5gijn4iztxT1WTJySaA/xm4nskuKE
7Arxs8w8vqns9N554q7VvrQte90n9uw8/pRoV7HQi2Ar18eShZGvpzqJsXzW
HM7cwBXF6/nT53TWaq3CF4w255iVYtQFeP6GoYDnqotlYibgdxtDlzPRqPAL
mYCzhvEbz8Q4PgFR4/iVMtHvsuYKli+YOHCvB0cVwoHWrYh+msx2xeJIZw3b
Zb1HO6eP3HAVuihYmNf7QX4kwc46aCwQWwxjKUSNtzidx87y7oxNnRumjMxw
bBA1jleKgT4Sl0htzArEcKQrUAunYdrF+TJwxkN9GXLbdWzz5b0RzobUKhg7
8N38Ci0dEwtqWuiJQWlEOTmi7DrW+eq9sTAGjaTDZ1df7pgvkfah+isEn3pf
0j+Grzl+r087wqCyL7+LzQU0RH33/mXi+1PnAtZ7loa1Us0b6gBcbfy7Mt6h
5wJaZUOcC5Bq+G/haGjJIU0a2/uOOb6pch6puQGt+dTKDYRwvLem5Qbyaai8
cebQ1KF/zJMYzGfX4WQldHMFh2NXvlnya9eHAP9zlWHkt0ZNnWV1FHMdnZg6
L3ffpLg1qaNt58micJmIW1t5fCJu/cTmk1ob2DmEWO2fUjtjNWhqvrGYOub4
tPhKtXPs8cUoZBp2puzOhid++fqCb+no9UN1YPzdFZW5mDKrImUgPseg5wO6
2RVqdvpzdIlYELOyMRy4IuG8jKXp1wEc2I7aN+TW4jlZ7JzzlSt34r2RyjFo
qs1rRSzqewU1OrSXrCq6jl3vNXfSe6MkByDNEVwC/DPG+xL8sXMYXvd2hHGy
CGb2H6jsxbg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{477, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->567855433]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["trace",
  FontSlant->"Italic"],
 " or ",
 StyleBox["spur",
  FontSlant->"Italic"],
 " of a matrix ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tr",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tr"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " is the sum of the terms on the leading diagonal."
}], "Text",
 CellID->1840],

Cell["\<\
This finds the trace of a simple 2\[Times]2 matrix. \
\>", "MathCaption",
 CellID->31497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2785],

Cell[BoxData[
 RowBox[{"a", "+", "d"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->47707012]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["rank",
  FontSlant->"Italic"],
 " of a matrix is the number of linearly independent rows or columns."
}], "Text",
 CellID->6737245],

Cell["This finds the rank of a matrix.", "MathCaption",
 CellID->4512519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixRank", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->145533041],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->22327703]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MatrixPower",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixPower"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " matrix power"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MatrixExp",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixExp"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["matrix exponential", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31540],

Cell["Powers and exponentials of matrices. ", "Caption",
 CellID->18805],

Cell["Here is a 2\[Times]2 matrix. ", "MathCaption",
 CellID->28791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.525", ",", "0.475"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->13392],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.4`", ",", "0.6`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.525`", ",", "0.475`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->461113231]
}, Open  ]],

Cell[TextData[{
 "This gives the third matrix power of ",
 Cell[BoxData["m"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->13549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPower", "[", 
  RowBox[{"m", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->21578],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.46562499999999996`", ",", "0.534375`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.467578125`", ",", "0.5324218749999999`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{304, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->115239599]
}, Open  ]],

Cell["It is equivalent to multiplying three copies of the matrix. ", \
"MathCaption",
 CellID->30971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", ".", "m", ".", "m"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->9277],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.46562499999999996`", ",", "0.534375`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.46757812500000007`", ",", "0.5324218749999999`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{304, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->364633630]
}, Open  ]],

Cell["Here is the millionth matrix power. ", "MathCaption",
 CellID->20193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPower", "[", 
  RowBox[{"m", ",", 
   RowBox[{"10", "^", "6"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->1620],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.466666666663054`", ",", "0.5333333333292046`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.466666666663054`", ",", "0.5333333333292046`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{304, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->258393362]
}, Open  ]],

Cell[TextData[{
 "The matrix exponential of a matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "0"}], "\[Infinity]"], 
    RowBox[{
     SuperscriptBox["m", "k"], "/", 
     RowBox[{"k", "!"}]}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["m", "k"], TraditionalForm]], "InlineMath"],
 " indicates a matrix power."
}], "Text",
 CellID->283027242],

Cell[TextData[{
 "This gives the matrix exponential of ",
 Cell[BoxData["m"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->13826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixExp", "[", "m", "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->31276],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.7391965346593388`", ",", "0.9790852937997064`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8566996320747433`", ",", "1.861582196384302`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->699548337]
}, Open  ]],

Cell[TextData[{
 "Here is an approximation to the exponential of ",
 Cell[BoxData["m"], "InlineFormula"],
 ", based on a power series approximation. "
}], "MathCaption",
 CellID->6582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"MatrixPower", "[", 
     RowBox[{"m", ",", "k"}], "]"}], "/", 
    RowBox[{"k", "!"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->13578],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.7384427897135417`", ",", "0.978223876953125`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8559458923339844`", ",", "1.8607207743326821`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{290, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->593007387]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Basic Matrix Operations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 55.8420098}", "context" -> "", 
    "keywords" -> {
     "CharacteristicPolynomial", "cofactors", "combinations", 
      "ConjugateTranspose", "Det", "determinants", "diagonal of matrix", 
      "exponentials", "Hermitian conjugate", "Inverse", "matrices", 
      "MatrixExp", "MatrixPower", "Minors", "powers", "spur of matrix", "Tr", 
      "trace of matrix", "Transpose"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Some basic matrix operations. Transposing a matrix interchanges the rows \
and columns in the matrix. If you transpose an mxn matrix, you get an nxm \
matrix as the result. Transposing a 2x3 matrix gives a 3x2 result. ", 
    "synonyms" -> {"3.7.7"}, "title" -> "Basic Matrix Operations", "type" -> 
    "Tutorial", "uri" -> "tutorial/BasicMatrixOperations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.7.7"->{
  Cell[1976, 52, 86, 2, 70, "Title",
   CellTags->{"S3.7.7", "7.1"},
   CellID->25697]},
 "7.1"->{
  Cell[1976, 52, 86, 2, 70, "Title",
   CellTags->{"S3.7.7", "7.1"},
   CellID->25697]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.7.7", 21664, 793},
 {"7.1", 21763, 797}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1351, 25, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1976, 52, 86, 2, 70, "Title",
 CellTags->{"S3.7.7", "7.1"},
 CellID->25697],
Cell[2065, 56, 2535, 81, 70, "DefinitionBox",
 CellID->4919],
Cell[4603, 139, 65, 1, 70, "Caption",
 CellID->17780],
Cell[4671, 142, 446, 16, 70, "Text",
 CellID->22578],
Cell[5120, 160, 106, 3, 70, "MathCaption",
 CellID->12931],
Cell[CellGroupData[{
Cell[5251, 167, 273, 9, 28, "Input",
 CellID->32544],
Cell[5527, 178, 363, 13, 36, "Output",
 CellID->19668749]
}, Open  ]],
Cell[5905, 194, 2029, 75, 70, "Text",
 CellID->13487],
Cell[7937, 271, 876, 31, 70, "Text",
 CellID->899],
Cell[8816, 304, 102, 3, 70, "MathCaption",
 CellID->22525],
Cell[CellGroupData[{
Cell[8943, 311, 243, 9, 70, "Input",
 CellID->8483],
Cell[9189, 322, 243, 9, 36, "Output",
 CellID->8081856]
}, Open  ]],
Cell[9447, 334, 429, 18, 70, "MathCaption",
 CellID->7492],
Cell[CellGroupData[{
Cell[9901, 356, 194, 7, 70, "Input",
 CellID->6193],
Cell[10098, 365, 912, 31, 36, "Output",
 CellID->13826472]
}, Open  ]],
Cell[11025, 399, 126, 5, 70, "MathCaption",
 CellID->25011],
Cell[CellGroupData[{
Cell[11176, 408, 94, 3, 28, "Input",
 CellID->1560],
Cell[11273, 413, 1261, 25, 54, "Output",
 Evaluatable->False,
 CellID->567855433]
}, Open  ]],
Cell[12549, 441, 374, 16, 70, "Text",
 CellID->1840],
Cell[12926, 459, 99, 3, 70, "MathCaption",
 CellID->31497],
Cell[CellGroupData[{
Cell[13050, 466, 242, 9, 70, "Input",
 CellID->2785],
Cell[13295, 477, 179, 6, 36, "Output",
 CellID->47707012]
}, Open  ]],
Cell[13489, 486, 167, 6, 70, "Text",
 CellID->6737245],
Cell[13659, 494, 73, 1, 70, "MathCaption",
 CellID->4512519],
Cell[CellGroupData[{
Cell[13757, 499, 255, 9, 70, "Input",
 CellID->145533041],
Cell[14015, 510, 157, 5, 36, "Output",
 CellID->22327703]
}, Open  ]],
Cell[14187, 518, 945, 29, 70, "DefinitionBox",
 CellID->31540],
Cell[15135, 549, 72, 1, 70, "Caption",
 CellID->18805],
Cell[15210, 552, 68, 1, 70, "MathCaption",
 CellID->28791],
Cell[CellGroupData[{
Cell[15303, 557, 249, 9, 70, "Input",
 CellID->13392],
Cell[15555, 568, 318, 11, 36, "Output",
 CellID->461113231]
}, Open  ]],
Cell[15888, 582, 136, 5, 70, "MathCaption",
 CellID->13549],
Cell[CellGroupData[{
Cell[16049, 591, 126, 4, 70, "Input",
 CellID->21578],
Cell[16178, 597, 361, 12, 36, "Output",
 CellID->115239599]
}, Open  ]],
Cell[16554, 612, 101, 2, 70, "MathCaption",
 CellID->30971],
Cell[CellGroupData[{
Cell[16680, 618, 97, 3, 70, "Input",
 CellID->9277],
Cell[16780, 623, 369, 12, 36, "Output",
 CellID->364633630]
}, Open  ]],
Cell[17164, 638, 75, 1, 70, "MathCaption",
 CellID->20193],
Cell[CellGroupData[{
Cell[17264, 643, 151, 5, 70, "Input",
 CellID->1620],
Cell[17418, 650, 376, 12, 36, "Output",
 CellID->258393362]
}, Open  ]],
Cell[17809, 665, 517, 19, 70, "Text",
 CellID->283027242],
Cell[18329, 686, 136, 5, 70, "MathCaption",
 CellID->13826],
Cell[CellGroupData[{
Cell[18490, 695, 102, 3, 70, "Input",
 CellID->31276],
Cell[18595, 700, 377, 12, 36, "Output",
 CellID->699548337]
}, Open  ]],
Cell[18987, 715, 184, 5, 70, "MathCaption",
 CellID->6582],
Cell[CellGroupData[{
Cell[19196, 724, 288, 10, 70, "Input",
 CellID->13578],
Cell[19487, 736, 377, 12, 36, "Output",
 CellID->593007387]
}, Open  ]]
}, Open  ]],
Cell[19891, 752, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

