(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33761,       1175]
NotebookOptionsPosition[     26783,        948]
NotebookOutlinePosition[     30851,       1065]
CellTagsIndexPosition[     30514,       1049]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Characters" :> 
         Documentation`HelpLookup["paclet:ref/Characters"], "Complex" :> 
         Documentation`HelpLookup["paclet:ref/Complex"], "Denominator" :> 
         Documentation`HelpLookup["paclet:ref/Denominator"], "I" :> 
         Documentation`HelpLookup["paclet:ref/I"], "Im" :> 
         Documentation`HelpLookup["paclet:ref/Im"], "Integer" :> 
         Documentation`HelpLookup["paclet:ref/Integer"], "IntegerDigits" :> 
         Documentation`HelpLookup["paclet:ref/IntegerDigits"], "Numerator" :> 
         Documentation`HelpLookup["paclet:ref/Numerator"], "Rational" :> 
         Documentation`HelpLookup["paclet:ref/Rational"], "Re" :> 
         Documentation`HelpLookup["paclet:ref/Re"], "Real" :> 
         Documentation`HelpLookup["paclet:ref/Real"], "RealDigits" :> 
         Documentation`HelpLookup["paclet:ref/RealDigits"], "String" :> 
         Documentation`HelpLookup["paclet:ref/String"], "Symbol" :> 
         Documentation`HelpLookup["paclet:ref/Symbol"], "SymbolName" :> 
         Documentation`HelpLookup["paclet:ref/SymbolName"], "$Context" :> 
         Documentation`HelpLookup["paclet:ref/$Context"], "$ContextPath" :> 
         Documentation`HelpLookup["paclet:ref/$ContextPath"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Characters\"\>", 
      2->"\<\"Complex\"\>", 3->"\<\"Denominator\"\>", 4->"\<\"I\"\>", 
      5->"\<\"Im\"\>", 6->"\<\"Integer\"\>", 7->"\<\"IntegerDigits\"\>", 
      8->"\<\"Numerator\"\>", 9->"\<\"Rational\"\>", 10->"\<\"Re\"\>", 
      11->"\<\"Real\"\>", 12->"\<\"RealDigits\"\>", 13->"\<\"String\"\>", 
      14->"\<\"Symbol\"\>", 15->"\<\"SymbolName\"\>", 16->"\<\"$Context\"\>", 
      17->"\<\"$ContextPath\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Basic Objects", "Title",
 CellID->1874945521],

Cell[CellGroupData[{

Cell["Expressions", "Section",
 CellTags->{"SA.1.1", "1.1"},
 CellID->30783],

Cell[TextData[{
 StyleBox["Expressions",
  FontSlant->"Italic"],
 " are the main type of data in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->17540],

Cell[TextData[{
 "Expressions can be written in the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["h", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ". The object ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " is known generically as the ",
 StyleBox["head",
  FontSlant->"Italic"],
 " of the expression. The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are termed the ",
 StyleBox["elements",
  FontSlant->"Italic"],
 " of the expression. Both the head and the elements may themselves be \
expressions."
}], "Text",
 CellID->22795],

Cell[TextData[{
 "The ",
 StyleBox["parts",
  FontSlant->"Italic"],
 " of an expression can be referred to by numerical indices. The head has \
index 0; element ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " has index ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Part",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["i", "TI"]}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "[", 
   RowBox[{"[", 
    StyleBox["i", "TI"], "]"}], "]"}]], "InlineFormula"],
 " gives the part of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with index ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 ". Negative indices count from the end. "
}], "Text",
 CellID->7266],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Part",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Extract",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extract"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " gives the piece of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " found by successively extracting parts of subexpressions with indices ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["i", "TI"], 
    StyleBox["1", "TR"]], ",", 
   SubscriptBox[
    StyleBox["i", "TI"], 
    StyleBox["2", "TR"]], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 ". If you think of expressions as trees, the indices specify which branch to \
take at each node as you descend from the root. "
}], "Text",
 CellID->18633],

Cell[TextData[{
 "The pieces of an expression that are specified by giving a sequence of \
exactly ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " indices are defined to be at ",
 StyleBox["level",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " in the expression. You can use levels to determine the domain of \
application of functions like ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 ". Level 0 corresponds to the whole expression."
}], "Text",
 CellID->13509],

Cell[TextData[{
 "The ",
 StyleBox["depth",
  FontSlant->"Italic"],
 " of an expression is defined to be the maximum number of indices needed to \
specify any part of the expression, plus one. A negative level number ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " refers to all parts of an expression that have depth ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->24557]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbols", "Section",
 CellTags->{"SA.1.2", "2.1"},
 CellID->11134],

Cell[TextData[{
 StyleBox["Symbols",
  FontSlant->"Italic"],
 " are the basic named objects in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->23016],

Cell[TextData[{
 "The name of a symbol must be a sequence of letters, letter\[Hyphen]like \
forms and digits, not starting with a digit. Upper\[Hyphen] and \
lower\[Hyphen]case letters are always distinguished in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->25050],

Cell[BoxData[GridBox[{
   {
    StyleBox["aaaaa", "TI"], Cell[
    "user\[Hyphen]defined symbol", "TableText"]},
   {
    StyleBox["Aaaaa", "TI"], Cell[
    "system\[Hyphen]defined symbol", "TableText"]},
   {
    StyleBox[
     RowBox[{"$", 
      StyleBox["Aaaa", "TI"]}]], Cell["\<\
global or internal system\[Hyphen]defined symbol\
\>", "TableText"]},
   {
    StyleBox[
     RowBox[{
      StyleBox["aaaa", "TI"], "$"}]], Cell[
    "symbol renamed in a scoping construct", "TableText"]},
   {
    StyleBox[
     RowBox[{
      StyleBox["aa", "TI"], "$", 
      StyleBox["nn", "TI"]}]], Cell[
    "unique local symbol generated in a module", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9193],

Cell["Conventions for symbol names. ", "Caption",
 CellID->21945],

Cell[TextData[{
 "Essentially all system\[Hyphen]defined symbols have names that contain only \
ordinary English letters, together with numbers and ",
 Cell[BoxData["$"], "InlineFormula"],
 ". The exceptions are ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["\[ExponentialE]", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["\[ImaginaryI]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[ImaginaryJ]", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->1852],

Cell["\<\
System\[Hyphen]defined symbols conventionally have names that consist of one \
or more complete English words. The first letter of each word is capitalized, \
and the words are run together. \
\>", "Text",
 CellID->20747],

Cell[TextData[{
 "Once created, an ordinary symbol in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " continues to exist unless it is explicitly removed using ",
 Cell[BoxData[
  ButtonBox["Remove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Remove"]], "InlineFormula"],
 ". However, symbols created automatically in scoping constructs such as ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " carry the attribute ",
 Cell[BoxData[
  ButtonBox["Temporary",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Temporary"]], "InlineFormula"],
 " which specifies that they should automatically be removed as soon as they \
no longer appear in any expression. "
}], "Text",
 CellID->32521],

Cell[TextData[{
 "When a new symbol is to be created, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " first applies any value that has been assigned to ",
 Cell[BoxData[
  ButtonBox["$NewSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$NewSymbol"]], "InlineFormula"],
 " to strings giving the name of the symbol, and the context in which the \
symbol would be created. "
}], "Text",
 CellID->8061],

Cell[TextData[{
 "If the message ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["General",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/General"], "::", "newsym"}]], "InlineFormula"],
 " is switched on, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " reports new symbols that are created. This message is switched off by \
default. Symbols created automatically in scoping constructs are not \
reported."
}], "Text",
 CellID->6344]
}, Open  ]],

Cell[CellGroupData[{

Cell["Contexts", "Section",
 CellTags->{"SA.1.3", "3.1"},
 CellID->1832],

Cell[TextData[{
 "The full name of any symbol in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " consists of two parts: a ",
 StyleBox["context",
  FontSlant->"Italic"],
 " and a ",
 StyleBox["short name",
  FontSlant->"Italic"],
 ". The full name is written in the form ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["context", "TI"], "`", 
    StyleBox["name", "TI"]}]]], "InlineFormula"],
 ". The context ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["context", "TI"], "`"}]]], "InlineFormula"],
 " can contain the same characters as the short name. It may also contain any \
number of context mark characters ",
 Cell[BoxData["`"], "InlineFormula"],
 ", and must end with a context mark."
}], "Text",
 CellID->20945],

Cell[TextData[{
 "At any point in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, there is a ",
 StyleBox["current",
  FontSlant->"Italic"],
 " ",
 StyleBox["context",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 " and a ",
 StyleBox["context",
  FontSlant->"Italic"],
 " ",
 StyleBox["search",
  FontSlant->"Italic"],
 " ",
 StyleBox["path",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 " consisting of a list of contexts. Symbols in the current context, or in \
contexts on the context search path, can be specified by giving only their \
short names."
}], "Text",
 CellID->4313],

Cell[BoxData[GridBox[{
   {
    StyleBox["name", "TI"], Cell[TextData[{
     "search ",
     Cell[BoxData[
      ButtonBox["$Context",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
     ", then ",
     Cell[BoxData[
      ButtonBox["$ContextPath",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
     "; create in ",
     Cell[BoxData[
      ButtonBox["$Context",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
     " if necessary"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["`", "MR"], 
     StyleBox["name", "TI"]}], Cell[TextData[{
     "search ",
     Cell[BoxData[
      ButtonBox["$Context",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
     " only; create there if necessary"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["context", "TI"], 
     StyleBox["`", "MR"], 
     StyleBox["name", "TI"]}], Cell[TextData[{
     "search ",
     Cell[BoxData[
      StyleBox["context", "TI"]], "InlineFormula"],
     " only; create there if necessary"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["`", "MR"], 
     StyleBox["context", "TI"], 
     StyleBox["`", "MR"], 
     StyleBox["name", "TI"]}], Cell[TextData[{
     "search ",
     Cell[BoxData[
      RowBox[{
       StyleBox["$Context`", "MR"], 
       StyleBox["context", "TI"]}]], "InlineFormula"],
     " only; create there if necessary"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27756],

Cell["Contexts used for various specifications of symbols. ", "Caption",
 CellID->28321],

Cell[TextData[{
 "With ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages, it is conventional to associate contexts whose names correspond \
to the names of the packages. Packages typically use ",
 Cell[BoxData[
  ButtonBox["BeginPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BeginPackage"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EndPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndPackage"]], "InlineFormula"],
 " to define objects in the appropriate context, and to add the context to \
the global ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["EndPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndPackage"]], "InlineFormula"],
 " prints a warning about any symbols that were created in a package but \
which are \[OpenCurlyDoubleQuote]shadowed\[CloseCurlyDoubleQuote] by existing \
symbols on the context search path. "
}], "Text",
 CellID->19558],

Cell[TextData[{
 "The context is included in the printed form of a symbol only if it would be \
needed to specify the symbol ",
 StyleBox["at the time of printing",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->23646]
}, Open  ]],

Cell[CellGroupData[{

Cell["Atomic Objects", "Section",
 CellTags->{"SA.1.4", "4.1"},
 CellID->15871],

Cell[TextData[{
 "All expressions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are ultimately made up from a small number of basic or atomic types of \
objects. "
}], "Text",
 CellID->10697],

Cell[TextData[{
 "These objects have heads which are symbols that can be thought of as \
\[OpenCurlyDoubleQuote]tagging\[CloseCurlyDoubleQuote] their types. The \
objects contain \[OpenCurlyDoubleQuote]raw data\[CloseCurlyDoubleQuote], \
which can usually be accessed only by functions specific to the particular \
type of object. You can extract the head of the object using ",
 Cell[BoxData[
  ButtonBox["Head",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Head"]], "InlineFormula"],
 ", but you cannot directly extract any of its other parts."
}], "Text",
 CellID->17612],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Symbol",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Symbol"], Cell[TextData[{
     "symbol (extract name using ",
     Cell[BoxData[
      ButtonBox["SymbolName",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SymbolName"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["String",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/String"], Cell[TextData[{
     "character string ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"cccc\", \"TI\"]\)\>\""], "InlineFormula"],
     " (extract characters using ",
     Cell[BoxData[
      ButtonBox["Characters",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Characters"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["Integer",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integer"], Cell[TextData[{
     "integer (extract digits using ",
     Cell[BoxData[
      ButtonBox["IntegerDigits",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/IntegerDigits"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["Real",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Real"], Cell[TextData[{
     "approximate real number (extract digits using ",
     Cell[BoxData[
      ButtonBox["RealDigits",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RealDigits"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["Rational",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Rational"], Cell[TextData[{
     "rational number (extract parts using ",
     Cell[BoxData[
      ButtonBox["Numerator",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Numerator"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Denominator",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Denominator"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["Complex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Complex"], Cell[TextData[{
     "complex number (extract parts using ",
     Cell[BoxData[
      ButtonBox["Re",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Re"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Im",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Im"]], "InlineFormula"],
     ")"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18703],

Cell["Atomic objects. ", "Caption",
 CellID->11027],

Cell[TextData[{
 "Atomic objects in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are considered to have depth 0 and yield ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " when tested with ",
 Cell[BoxData[
  ButtonBox["AtomQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AtomQ"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->11408]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numbers", "Section",
 CellTags->{"SA.1.5", "5.1"},
 CellID->10971],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Integer",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integer"], Cell[TextData[{
     "integer ",
     Cell[BoxData[
      StyleBox["nnnn", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["Real",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Real"], Cell[TextData[{
     "approximate real number ",
     Cell[BoxData[
      RowBox[{
       StyleBox["nnn", "TI"], ".", 
       StyleBox["nnn", "TI"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["Rational",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Rational"], Cell[TextData[{
     "rational number ",
     Cell[BoxData[
      RowBox[{
       StyleBox["nnn", "TI"], "/", 
       StyleBox["nnn", "TI"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["Complex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Complex"], Cell[TextData[{
     "complex number ",
     Cell[BoxData[
      RowBox[{
       StyleBox["nnn", "TI"], "+", 
       StyleBox["nnn", "TI"], " ", 
       ButtonBox["I",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/I"]}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21587],

Cell["Basic types of numbers. ", "Caption",
 CellID->11743],

Cell[TextData[{
 "All numbers in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can contain any number of digits. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does exact computations when possible with integers and rational numbers, \
and with complex numbers whose real and imaginary parts are integers or \
rational numbers. "
}], "Text",
 CellID->24468],

Cell[TextData[{
 "There are two types of approximate real numbers in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ": ",
 StyleBox["arbitrary precision",
  FontSlant->"Italic"],
 " and ",
 StyleBox["machine precision",
  FontSlant->"Italic"],
 ". In manipulating arbitrary\[Hyphen]precision numbers, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tries to modify the precision so as to ensure that all digits actually \
given are correct. "
}], "Text",
 CellID->3802],

Cell["\<\
With machine\[Hyphen]precision numbers, all computations are done to the same \
fixed precision, so some digits given may not be correct. \
\>", "Text",
 CellID->30088],

Cell[TextData[{
 "Unless otherwise specified, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " treats as machine\[Hyphen]precision numbers all approximate real numbers \
that lie between ",
 Cell[BoxData[
  ButtonBox["$MinMachineNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinMachineNumber"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$MaxMachineNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxMachineNumber"]], "InlineFormula"],
 " and that are input with less than ",
 Cell[BoxData[
  ButtonBox["$MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
 " digits. "
}], "Text",
 CellID->24298],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prints machine\[Hyphen]precision numbers with ",
 Cell[BoxData[
  ButtonBox["$MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
 " digits, except when trailing digits are zero. "
}], "Text",
 CellID->6582],

Cell[TextData[{
 "In any implementation of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the magnitudes of numbers (except 0) must lie between ",
 Cell[BoxData[
  ButtonBox["$MinNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinNumber"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$MaxNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxNumber"]], "InlineFormula"],
 ". Numbers with magnitudes outside this range are represented by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Underflow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Underflow"], "[", "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overflow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overflow"], "[", "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->22252]
}, Open  ]],

Cell[CellGroupData[{

Cell["Character Strings", "Section",
 CellTags->{"SA.1.6", "6.1"},
 CellID->25023],

Cell[TextData[{
 "Character strings in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can contain any sequence of characters. They are input in the form ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"ccccc\", \"TI\"]\)\>\""], "InlineFormula"],
 "."
}], "Text",
 CellID->17226],

Cell[TextData[{
 "The individual characters can be printable ASCII (with character codes \
between 32 and 126), or in general any 8\[Hyphen] or 16\[Hyphen]bit \
characters. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the Unicode character encoding for 16\[Hyphen]bit characters. "
}], "Text",
 CellID->31203],

Cell[TextData[{
 "In input form, 16\[Hyphen]bit characters are represented when possible in \
the form ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"[", 
    StyleBox["name", "TI"], "]"}]}]], "InlineFormula"],
 ", and otherwise as ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{":", 
    StyleBox["nnnn", "TI"]}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->30048],

Cell[TextData[{
 "Null bytes can appear at any point within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " strings. "
}], "Text",
 CellID->21051]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Basic Objects - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 56.1857686}", "context" -> "", 
    "keywords" -> {
     "`", "\\.", "\\:", "atoms", "byte array", "case sensitive", 
      "case independence", "character strings", "complex", "depth", 
      "dollar sign", "expressions", "fundamental objects", "Head", "heads", 
      "hexadecimal form", "identifiers", "indices", "integer", 
      "international characters", "levels", "lowercase letters", 
      "MaxMachineNumber", "MinMachineNumber", "messages", "names", 
      "naming conventions", "newsym", "NewSymbol", "new symbols", "overflow", 
      "parts", "rational", "raw", "raw data", "real", "special characters", 
      "special objects", "spell", "string", "strings", "symbol names", 
      "symbol", "symbols", "text strings", "underflow", "uppercase letters", 
      "variables"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Expressions are the main type of data in Mathematica. Expressions can be \
written in the form h[e_1,e_2,...]. The object h is known generically as the \
head of the expression. The e_i are termed the elements of the expression. \
Both the head and the elements may themselves be expressions. The parts of an \
expression can be referred to by numerical indices. The head has index 0; \
element e_i has index i. Part[expr,i] or expr[[i]] gives the part of expr \
with index i. Negative indices count from the end. ", 
    "synonyms" -> {"A.1.1", "A.1.2", "A.1.3", "A.1.4", "A.1.5", "A.1.6"}, 
    "title" -> "Basic Objects", "type" -> "Tutorial", "uri" -> 
    "tutorial/BasicObjects"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "SA.1.1"->{
  Cell[2810, 68, 76, 2, 70, "Section",
   CellTags->{"SA.1.1", "1.1"},
   CellID->30783]},
 "1.1"->{
  Cell[2810, 68, 76, 2, 70, "Section",
   CellTags->{"SA.1.1", "1.1"},
   CellID->30783]},
 "SA.1.2"->{
  Cell[7608, 255, 72, 2, 70, "Section",
   CellTags->{"SA.1.2", "2.1"},
   CellID->11134]},
 "2.1"->{
  Cell[7608, 255, 72, 2, 70, "Section",
   CellTags->{"SA.1.2", "2.1"},
   CellID->11134]},
 "SA.1.3"->{
  Cell[11800, 404, 72, 2, 70, "Section",
   CellTags->{"SA.1.3", "3.1"},
   CellID->1832]},
 "3.1"->{
  Cell[11800, 404, 72, 2, 70, "Section",
   CellTags->{"SA.1.3", "3.1"},
   CellID->1832]},
 "SA.1.4"->{
  Cell[16695, 582, 79, 2, 70, "Section",
   CellTags->{"SA.1.4", "4.1"},
   CellID->15871]},
 "4.1"->{
  Cell[16695, 582, 79, 2, 70, "Section",
   CellTags->{"SA.1.4", "4.1"},
   CellID->15871]},
 "SA.1.5"->{
  Cell[20779, 724, 72, 2, 70, "Section",
   CellTags->{"SA.1.5", "5.1"},
   CellID->10971]},
 "5.1"->{
  Cell[20779, 724, 72, 2, 70, "Section",
   CellTags->{"SA.1.5", "5.1"},
   CellID->10971]},
 "SA.1.6"->{
  Cell[25493, 895, 82, 2, 70, "Section",
   CellTags->{"SA.1.6", "6.1"},
   CellID->25023]},
 "6.1"->{
  Cell[25493, 895, 82, 2, 70, "Section",
   CellTags->{"SA.1.6", "6.1"},
   CellID->25023]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"SA.1.1", 29258, 998},
 {"1.1", 29359, 1002},
 {"SA.1.2", 29463, 1006},
 {"2.1", 29565, 1010},
 {"SA.1.3", 29670, 1014},
 {"3.1", 29772, 1018},
 {"SA.1.4", 29877, 1022},
 {"4.1", 29980, 1026},
 {"SA.1.5", 30086, 1030},
 {"5.1", 30189, 1034},
 {"SA.1.6", 30295, 1038},
 {"6.1", 30398, 1042}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2109, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2734, 63, 51, 1, 70, "Title",
 CellID->1874945521],
Cell[CellGroupData[{
Cell[2810, 68, 76, 2, 70, "Section",
 CellTags->{"SA.1.1", "1.1"},
 CellID->30783],
Cell[2889, 72, 181, 8, 70, "Text",
 CellID->17540],
Cell[3073, 82, 808, 30, 70, "Text",
 CellID->22795],
Cell[3884, 114, 925, 36, 70, "Text",
 CellID->7266],
Cell[4812, 152, 1719, 61, 70, "Text",
 CellID->18633],
Cell[6534, 215, 589, 19, 70, "Text",
 CellID->13509],
Cell[7126, 236, 445, 14, 70, "Text",
 CellID->24557]
}, Open  ]],
Cell[CellGroupData[{
Cell[7608, 255, 72, 2, 70, "Section",
 CellTags->{"SA.1.2", "2.1"},
 CellID->11134],
Cell[7683, 259, 179, 8, 70, "Text",
 CellID->23016],
Cell[7865, 269, 297, 8, 70, "Text",
 CellID->25050],
Cell[8165, 279, 1011, 33, 70, "DefinitionBox",
 CellID->9193],
Cell[9179, 314, 65, 1, 70, "Caption",
 CellID->21945],
Cell[9247, 317, 649, 21, 70, "Text",
 CellID->1852],
Cell[9899, 340, 231, 5, 70, "Text",
 CellID->20747],
Cell[10133, 347, 766, 22, 70, "Text",
 CellID->32521],
Cell[10902, 371, 414, 12, 70, "Text",
 CellID->8061],
Cell[11319, 385, 444, 14, 70, "Text",
 CellID->6344]
}, Open  ]],
Cell[CellGroupData[{
Cell[11800, 404, 72, 2, 70, "Section",
 CellTags->{"SA.1.3", "3.1"},
 CellID->1832],
Cell[11875, 408, 744, 26, 70, "Text",
 CellID->20945],
Cell[12622, 436, 817, 33, 70, "Text",
 CellID->4313],
Cell[13442, 471, 1860, 62, 70, "DefinitionBox",
 CellID->27756],
Cell[15305, 535, 88, 1, 70, "Caption",
 CellID->28321],
Cell[15396, 538, 1038, 30, 70, "Text",
 CellID->19558],
Cell[16437, 570, 221, 7, 70, "Text",
 CellID->23646]
}, Open  ]],
Cell[CellGroupData[{
Cell[16695, 582, 79, 2, 70, "Section",
 CellTags->{"SA.1.4", "4.1"},
 CellID->15871],
Cell[16777, 586, 203, 7, 70, "Text",
 CellID->10697],
Cell[16983, 595, 578, 12, 70, "Text",
 CellID->17612],
Cell[17564, 609, 2706, 89, 70, "DefinitionBox",
 CellID->18703],
Cell[20273, 700, 51, 1, 70, "Caption",
 CellID->11027],
Cell[20327, 703, 415, 16, 70, "Text",
 CellID->11408]
}, Open  ]],
Cell[CellGroupData[{
Cell[20779, 724, 72, 2, 70, "Section",
 CellTags->{"SA.1.5", "5.1"},
 CellID->10971],
Cell[20854, 728, 1509, 50, 70, "DefinitionBox",
 CellID->21587],
Cell[22366, 780, 59, 1, 70, "Caption",
 CellID->11743],
Cell[22428, 783, 374, 11, 70, "Text",
 CellID->24468],
Cell[22805, 796, 482, 16, 70, "Text",
 CellID->3802],
Cell[23290, 814, 178, 4, 70, "Text",
 CellID->30088],
Cell[23471, 820, 697, 22, 70, "Text",
 CellID->24298],
Cell[24171, 844, 467, 16, 70, "Text",
 CellID->6582],
Cell[24641, 862, 815, 28, 70, "Text",
 CellID->22252]
}, Open  ]],
Cell[CellGroupData[{
Cell[25493, 895, 82, 2, 70, "Section",
 CellTags->{"SA.1.6", "6.1"},
 CellID->25023],
Cell[25578, 899, 277, 9, 70, "Text",
 CellID->17226],
Cell[25858, 910, 324, 8, 70, "Text",
 CellID->31203],
Cell[26185, 920, 388, 14, 70, "Text",
 CellID->30048],
Cell[26576, 936, 153, 6, 70, "Text",
 CellID->21051]
}, Open  ]]
}, Open  ]],
Cell[26756, 946, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

