(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28963,       1132]
NotebookOptionsPosition[     21161,        866]
NotebookOutlinePosition[     23927,        937]
CellTagsIndexPosition[     23836,        931]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Modularity and the Naming of Things" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Modularity and the Naming of Things\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Block" :> Documentation`HelpLookup["paclet:ref/Block"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Block\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Blocks and Local Values", "Title",
 CellTags->{"S2.7.6", "6.1"},
 CellID->30189],

Cell[TextData[{
 "Modules in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allow you to treat the ",
 StyleBox["names",
  FontSlant->"Italic"],
 " of variables as local. Sometimes, however, you want the names to be \
global, but ",
 StyleBox["values",
  FontSlant->"Italic"],
 " to be local. You can do this in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->30422],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Block",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Block"], "[", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["body", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["body", "TI"]], "InlineFormula"],
     " using local values ",
     "for ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", ",", "y", ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Block",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Block"], "[", "{", 
     StyleBox["x", "TI"], "=", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], ",", 
     StyleBox["y", "TI"], "=", 
     SubscriptBox[
      StyleBox["y", "TI"], "0"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["body", "TI"], "]"}], Cell[TextData[{
     "assign initial values ",
     "to ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", ",", "y", ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27666],

Cell["Setting up local values. ", "Caption",
 CellID->8486],

Cell[TextData[{
 "Here is an expression involving ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->3455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "^", "2"}], "+", "3"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->2028],

Cell[BoxData[
 RowBox[{"3", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->29614]
}, Open  ]],

Cell[TextData[{
 "This evaluates the previous expression, using a local value for ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", 
     RowBox[{"a", "+", "1"}]}], "}"}], ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->29253],

Cell[BoxData[
 RowBox[{"3", "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "a"}], ")"}], "2"]}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->11777]
}, Open  ]],

Cell[TextData[{
 "There is no global value for ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31348],

Cell[CellGroupData[{

Cell[BoxData["x"], "Input",
 CellLabel->"In[3]:= ",
 CellID->12503],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->10861]
}, Open  ]],

Cell[TextData[{
 "As described in the sections above, the variable ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in a module such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Module",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Module"], "[", 
   RowBox[{
    RowBox[{"{", 
     StyleBox["x", "TI"], "}"}], ",", 
    StyleBox["body", "TI"]}], "]"}]], "InlineFormula"],
 " is always set up to refer to a unique symbol, different each time the \
module is used, and distinct from the global symbol ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". The ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in a block such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Block",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Block"], "[", 
   RowBox[{
    RowBox[{"{", 
     StyleBox["x", "TI"], "}"}], ",", 
    StyleBox["body", "TI"]}], "]"}]], "InlineFormula"],
 " is, however, taken to be the global symbol ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". What the block does is to make the ",
 StyleBox["value",
  FontSlant->"Italic"],
 " of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " local. The value ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " had when you entered the block is always restored when you exit the block. \
And during the execution of the block, ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " can take on any value. "
}], "Text",
 CellID->22431],

Cell[TextData[{
 "This sets the symbol ",
 Cell[BoxData["t"], "InlineFormula"],
 " to have value\[NonBreakingSpace]",
 Cell[BoxData["17"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->29082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", "17"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->12455],

Cell[BoxData["17"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->14197]
}, Open  ]],

Cell["Variables in modules have unique local names. ", "MathCaption",
 CellID->22106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "t", "}"}], ",", 
   RowBox[{"Print", "[", "t", "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->8752],

Cell[BoxData["t$1"], "Print",
 CellID->15821]
}, Open  ]],

Cell["\<\
In blocks, variables retain their global names, but can have local values. \
\>", "MathCaption",
 CellID->17296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", "t", "}"}], ",", 
   RowBox[{"Print", "[", "t", "]"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->26281],

Cell[BoxData["t"], "Print",
 CellID->26021]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["t"], "InlineFormula"],
 " is given a local value inside the block. "
}], "MathCaption",
 CellID->24455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", "t", "}"}], ",", 
   RowBox[{
    RowBox[{"t", "=", "6"}], ";", 
    RowBox[{
     RowBox[{"t", "^", "4"}], "+", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->15947],

Cell[BoxData["1297"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->27124]
}, Open  ]],

Cell[TextData[{
 "When the execution of the block is over, the previous value of ",
 Cell[BoxData["t"], "InlineFormula"],
 " is restored. "
}], "MathCaption",
 CellID->18318],

Cell[CellGroupData[{

Cell[BoxData["t"], "Input",
 CellLabel->"In[8]:= ",
 CellID->9135],

Cell[BoxData["17"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->11376]
}, Open  ]],

Cell[TextData[{
 "Blocks in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " effectively allow you to set up \[OpenCurlyDoubleQuote]environments\
\[CloseCurlyDoubleQuote] in which you can temporarily change the values of \
variables. Expressions you evaluate at any point during the execution of a \
block will use the values currently defined for variables in the block. This \
is true whether the expressions appear directly as part of the body of the \
block, or are produced at any point in its evaluation. "
}], "Text",
 CellID->1774],

Cell[TextData[{
 "This defines a delayed value for the symbol ",
 Cell[BoxData["u"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->29859],

Cell[BoxData[
 RowBox[{"u", ":=", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"t", "^", "2"}]}]}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->24998],

Cell[TextData[{
 "If you evaluate ",
 Cell[BoxData["u"], "InlineFormula"],
 " outside a block, the global value for ",
 Cell[BoxData["t"], "InlineFormula"],
 " is used. "
}], "MathCaption",
 CellID->12074],

Cell[CellGroupData[{

Cell[BoxData["u"], "Input",
 CellLabel->"In[10]:= ",
 CellID->9253],

Cell[BoxData[
 RowBox[{"289", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->6922]
}, Open  ]],

Cell[TextData[{
 "You can specify a temporary value for ",
 Cell[BoxData["t"], "InlineFormula"],
 " to use inside the block. "
}], "MathCaption",
 CellID->10635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "=", "5"}], "}"}], ",", 
   RowBox[{"u", "+", "7"}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->1643],

Cell[BoxData[
 RowBox[{"32", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->28888]
}, Open  ]],

Cell[TextData[{
 "An important implicit use of ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is for iteration constructs such as ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " effectively uses ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " to set up local values for the iteration variables in all of these \
constructs. "
}], "Text",
 CellID->8153],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " automatically makes the value of the iterator ",
 Cell[BoxData["t"], "InlineFormula"],
 " local. "
}], "MathCaption",
 CellID->13232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"t", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->4747],

Cell[BoxData["385"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->28680]
}, Open  ]],

Cell[TextData[{
 "The local values in iteration constructs are slightly more general than in \
",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 ". They handle variables such as ",
 Cell[BoxData[
  RowBox[{"a", "[", "1", "]"}]], "InlineFormula"],
 ", as well as pure symbols. "
}], "MathCaption",
 CellID->19926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "1", "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", "1", "]"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->25678],

Cell[BoxData["385"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->6450]
}, Open  ]],

Cell[TextData[{
 "When you set up functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", it is sometimes convenient to have \[OpenCurlyDoubleQuote]global \
variables\[CloseCurlyDoubleQuote] which can affect the functions without \
being given explicitly as arguments. Thus, for example, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " itself has a global variable ",
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 " which affects the evaluation of all functions, but is never explicitly \
given as an argument. "
}], "Text",
 CellID->14801],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will usually keep any value you define for a global variable until you \
explicitly change it. Often, however, you want to set up values which last \
only for the duration of a particular computation, or part of a computation. \
You can do this by making the values local to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " block. "
}], "Text",
 CellID->24961],

Cell[TextData[{
 "This defines a function which depends on the \[OpenCurlyDoubleQuote]global \
variable\[CloseCurlyDoubleQuote] ",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14199],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", "t"}]}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->20855],

Cell[TextData[{
 "In this case, the global value of ",
 Cell[BoxData["t"], "InlineFormula"],
 " is used. "
}], "MathCaption",
 CellID->26363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->5716],

Cell[BoxData[
 RowBox[{"17", "+", 
  SuperscriptBox["a", "2"]}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->10573]
}, Open  ]],

Cell[TextData[{
 "Inside a block, you can set up a local value for ",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "=", "2"}], "}"}], ",", 
   RowBox[{"f", "[", "b", "]"}]}], "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->23245],

Cell[BoxData[
 RowBox[{"2", "+", 
  SuperscriptBox["b", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->6473]
}, Open  ]],

Cell["\<\
You can use global variables not only to set parameters in functions, but \
also to accumulate results from functions. By setting up such variables to be \
local to a block, you can arrange to accumulate results only from functions \
called during the execution of the block. \
\>", "Text",
 CellID->28274],

Cell[TextData[{
 "This function increments the global variable ",
 Cell[BoxData["t"], "InlineFormula"],
 ", and returns its current value. "
}], "MathCaption",
 CellID->1550],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "x_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{"t", "+=", 
    RowBox[{"x", "^", "2"}]}], ")"}]}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->24353],

Cell[TextData[{
 "If you do not use a block, evaluating ",
 Cell[BoxData[
  RowBox[{"h", "[", "a", "]"}]], "InlineFormula"],
 " changes the global value of ",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", "a", "]"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->4287],

Cell[BoxData[
 RowBox[{"17", "+", 
  SuperscriptBox["a", "2"]}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->2699]
}, Open  ]],

Cell[TextData[{
 "With a block, only the local value of ",
 Cell[BoxData["t"], "InlineFormula"],
 " is affected. "
}], "MathCaption",
 CellID->18110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "=", "0"}], "}"}], ",", 
   RowBox[{"h", "[", "c", "]"}]}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->18643],

Cell[BoxData[
 SuperscriptBox["c", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->17465]
}, Open  ]],

Cell[TextData[{
 "The global value of ",
 Cell[BoxData["t"], "InlineFormula"],
 " remains unchanged. "
}], "MathCaption",
 CellID->7172],

Cell[CellGroupData[{

Cell[BoxData["t"], "Input",
 CellLabel->"In[20]:= ",
 CellID->2529],

Cell[BoxData[
 RowBox[{"17", "+", 
  SuperscriptBox["a", "2"]}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->9981]
}, Open  ]],

Cell[TextData[{
 "When you enter a block such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Block",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Block"], "[", 
   RowBox[{
    RowBox[{"{", 
     StyleBox["x", "TI"], "}"}], ",", 
    StyleBox["body", "TI"]}], "]"}]], "InlineFormula"],
 ", any value for ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is removed. This means that you can in principle treat ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " as a \[OpenCurlyDoubleQuote]symbolic variable\[CloseCurlyDoubleQuote] \
inside the block. However, if you explicitly return ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " from the block, it will be replaced by its value outside the block as soon \
as it is evaluated. "
}], "Text",
 CellID->2112],

Cell[TextData[{
 "The value of ",
 Cell[BoxData["t"], "InlineFormula"],
 " is removed when you enter the block. "
}], "MathCaption",
 CellID->13476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", "t", "}"}], ",", 
   RowBox[{"Print", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"t", "+", "1"}], ")"}], "^", "2"}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->4381],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "t"}], "+", 
  SuperscriptBox["t", "2"]}]], "Print",
 CellID->8247]
}, Open  ]],

Cell[TextData[{
 "If you return an expression involving ",
 Cell[BoxData["t"], "InlineFormula"],
 ", however, it is evaluated using the global value for ",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", "t", "}"}], ",", 
   RowBox[{
    RowBox[{"t", "^", "2"}], "-", "3"}]}], "]"}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->16671],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"17", "+", 
     SuperscriptBox["a", "2"]}], ")"}], "2"]}]], "Output",
 ImageSize->{90, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->8805]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->723369548],

Cell[TextData[ButtonBox["Modularity and the Naming of Things",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], \
"RelatedTutorials",
 CellID->405226890]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Blocks and Local Values - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Modularity and the Naming of Things", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DummyVariablesInMathematics"],
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/BlocksComparedWithModules"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 59.3108486}", "context" -> "", 
    "keywords" -> {
     "block", "environments", "fluid variables", "global variables", 
      "iteration constructs", "local values", "temporary values", 
      "dummy variables", "RecursionLimit"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Modules in Mathematica allow you to treat the names of variables as \
local. Sometimes, however, you want the names to be global, but values to be \
local. You can do this in Mathematica using Block. Setting up local values. \
Here is an expression involving x. ", "synonyms" -> {"2.7.6"}, "title" -> 
    "Blocks and Local Values", "type" -> "Tutorial", "uri" -> 
    "tutorial/BlocksAndLocalValues"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.7.6"->{
  Cell[1841, 59, 86, 2, 70, "Title",
   CellTags->{"S2.7.6", "6.1"},
   CellID->30189]},
 "6.1"->{
  Cell[1841, 59, 86, 2, 70, "Title",
   CellTags->{"S2.7.6", "6.1"},
   CellID->30189]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.7.6", 23625, 920},
 {"6.1", 23724, 924}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1216, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1841, 59, 86, 2, 70, "Title",
 CellTags->{"S2.7.6", "6.1"},
 CellID->30189],
Cell[1930, 63, 530, 21, 70, "Text",
 CellID->30422],
Cell[2463, 86, 1629, 51, 70, "DefinitionBox",
 CellID->27666],
Cell[4095, 139, 59, 1, 70, "Caption",
 CellID->8486],
Cell[4157, 142, 130, 5, 70, "MathCaption",
 CellID->3455],
Cell[CellGroupData[{
Cell[4312, 151, 111, 4, 28, "Input",
 CellID->2028],
Cell[4426, 157, 201, 7, 36, "Output",
 CellID->29614]
}, Open  ]],
Cell[4642, 167, 162, 5, 70, "MathCaption",
 CellID->4860],
Cell[CellGroupData[{
Cell[4829, 176, 196, 7, 28, "Input",
 CellID->29253],
Cell[5028, 185, 250, 9, 36, "Output",
 CellID->11777]
}, Open  ]],
Cell[5293, 197, 128, 5, 70, "MathCaption",
 CellID->31348],
Cell[CellGroupData[{
Cell[5446, 206, 67, 2, 70, "Input",
 CellID->12503],
Cell[5516, 210, 155, 5, 36, "Output",
 CellID->10861]
}, Open  ]],
Cell[5686, 218, 1484, 49, 70, "Text",
 CellID->22431],
Cell[7173, 269, 197, 7, 70, "MathCaption",
 CellID->29082],
Cell[CellGroupData[{
Cell[7395, 280, 90, 3, 70, "Input",
 CellID->12455],
Cell[7488, 285, 156, 5, 36, "Output",
 CellID->14197]
}, Open  ]],
Cell[7659, 293, 85, 1, 70, "MathCaption",
 CellID->22106],
Cell[CellGroupData[{
Cell[7769, 298, 178, 6, 70, "Input",
 CellID->8752],
Cell[7950, 306, 45, 1, 70, "Print",
 CellID->15821]
}, Open  ]],
Cell[8010, 310, 122, 3, 70, "MathCaption",
 CellID->17296],
Cell[CellGroupData[{
Cell[8157, 317, 178, 6, 70, "Input",
 CellID->26281],
Cell[8338, 325, 43, 1, 70, "Print",
 CellID->26021]
}, Open  ]],
Cell[8396, 329, 134, 4, 70, "MathCaption",
 CellID->24455],
Cell[CellGroupData[{
Cell[8555, 337, 245, 9, 70, "Input",
 CellID->15947],
Cell[8803, 348, 158, 5, 36, "Output",
 CellID->27124]
}, Open  ]],
Cell[8976, 356, 174, 5, 70, "MathCaption",
 CellID->18318],
Cell[CellGroupData[{
Cell[9175, 365, 66, 2, 70, "Input",
 CellID->9135],
Cell[9244, 369, 156, 5, 36, "Output",
 CellID->11376]
}, Open  ]],
Cell[9415, 377, 545, 11, 70, "Text",
 CellID->1774],
Cell[9963, 390, 143, 5, 70, "MathCaption",
 CellID->29859],
Cell[10109, 397, 161, 6, 70, "Input",
 CellID->24998],
Cell[10273, 405, 205, 7, 70, "MathCaption",
 CellID->12074],
Cell[CellGroupData[{
Cell[10503, 416, 67, 2, 70, "Input",
 CellID->9253],
Cell[10573, 420, 203, 7, 36, "Output",
 CellID->6922]
}, Open  ]],
Cell[10791, 430, 161, 5, 70, "MathCaption",
 CellID->10635],
Cell[CellGroupData[{
Cell[10977, 439, 194, 7, 70, "Input",
 CellID->1643],
Cell[11174, 448, 203, 7, 36, "Output",
 CellID->28888]
}, Open  ]],
Cell[11392, 458, 913, 35, 70, "Text",
 CellID->8153],
Cell[12308, 495, 261, 9, 70, "MathCaption",
 CellID->13232],
Cell[CellGroupData[{
Cell[12594, 508, 193, 7, 70, "Input",
 CellID->4747],
Cell[12790, 517, 158, 5, 36, "Output",
 CellID->28680]
}, Open  ]],
Cell[12963, 525, 379, 12, 70, "MathCaption",
 CellID->19926],
Cell[CellGroupData[{
Cell[13367, 541, 255, 9, 70, "Input",
 CellID->25678],
Cell[13625, 552, 157, 5, 36, "Output",
 CellID->6450]
}, Open  ]],
Cell[13797, 560, 648, 17, 70, "Text",
 CellID->14801],
Cell[14448, 579, 436, 11, 70, "Text",
 CellID->24961],
Cell[14887, 592, 209, 6, 70, "MathCaption",
 CellID->14199],
Cell[15099, 600, 167, 6, 70, "Input",
 CellID->20855],
Cell[15269, 608, 141, 5, 70, "MathCaption",
 CellID->26363],
Cell[CellGroupData[{
Cell[15435, 617, 94, 3, 70, "Input",
 CellID->5716],
Cell[15532, 622, 203, 7, 36, "Output",
 CellID->10573]
}, Open  ]],
Cell[15750, 632, 148, 5, 70, "MathCaption",
 CellID->31561],
Cell[CellGroupData[{
Cell[15923, 641, 200, 7, 70, "Input",
 CellID->23245],
Cell[16126, 650, 201, 7, 36, "Output",
 CellID->6473]
}, Open  ]],
Cell[16342, 660, 316, 6, 70, "Text",
 CellID->28274],
Cell[16661, 668, 174, 5, 70, "MathCaption",
 CellID->1550],
Cell[16838, 675, 193, 7, 70, "Input",
 CellID->24353],
Cell[17034, 684, 236, 8, 70, "MathCaption",
 CellID->1181],
Cell[CellGroupData[{
Cell[17295, 696, 94, 3, 70, "Input",
 CellID->4287],
Cell[17392, 701, 202, 7, 36, "Output",
 CellID->2699]
}, Open  ]],
Cell[17609, 711, 149, 5, 70, "MathCaption",
 CellID->18110],
Cell[CellGroupData[{
Cell[17783, 720, 200, 7, 70, "Input",
 CellID->18643],
Cell[17986, 729, 179, 6, 36, "Output",
 CellID->17465]
}, Open  ]],
Cell[18180, 738, 136, 5, 70, "MathCaption",
 CellID->7172],
Cell[CellGroupData[{
Cell[18341, 747, 67, 2, 70, "Input",
 CellID->2529],
Cell[18411, 751, 202, 7, 36, "Output",
 CellID->9981]
}, Open  ]],
Cell[18628, 761, 802, 24, 70, "Text",
 CellID->2112],
Cell[19433, 787, 148, 5, 70, "MathCaption",
 CellID->13476],
Cell[CellGroupData[{
Cell[19606, 796, 297, 11, 70, "Input",
 CellID->4381],
Cell[19906, 809, 121, 4, 70, "Print",
 CellID->8247]
}, Open  ]],
Cell[20042, 816, 234, 7, 70, "MathCaption",
 CellID->26890],
Cell[CellGroupData[{
Cell[20301, 827, 195, 7, 70, "Input",
 CellID->16671],
Cell[20499, 836, 296, 11, 41, "Output",
 CellID->8805]
}, Open  ]],
Cell[CellGroupData[{
Cell[20832, 852, 72, 1, 70, "RelatedTutorialsSection",
 CellID->723369548],
Cell[20907, 855, 200, 5, 70, "RelatedTutorials",
 CellID->405226890]
}, Open  ]]
}, Open  ]],
Cell[21134, 864, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

