(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13097,        439]
NotebookOptionsPosition[      8686,        313]
NotebookOutlinePosition[     11763,        388]
CellTagsIndexPosition[     11672,        382]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Modularity and the Naming of Things" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Modularity and the Naming of Things\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Block" :> Documentation`HelpLookup["paclet:ref/Block"], 
          "Module" :> Documentation`HelpLookup["paclet:ref/Module"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Block\"\>", 
       2->"\<\"Module\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Blocks Compared with Modules", "Title",
 CellTags->{"S2.7.7", "7.1"},
 CellID->32372],

Cell[TextData[{
 "When you write a program in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you should always try to set it up so that its parts are as independent \
as possible. In this way, the program will be easier for you to understand, \
maintain and add to. "
}], "Text",
 CellID->30032],

Cell[TextData[{
 "One of the main ways to ensure that different parts of a program do not \
interfere is to give their variables only a certain \
\[OpenCurlyDoubleQuote]scope\[CloseCurlyDoubleQuote]. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides two basic mechanisms for limiting the scope of variables: modules \
and blocks. "
}], "Text",
 CellID->3989],

Cell["\<\
In writing actual programs, modules are far more common than blocks. When \
scoping is needed in interactive calculations, however, blocks are often \
convenient. \
\>", "Text",
 CellID->9320],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Module",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Module"], "[", 
     StyleBox["vars", "TI"], ",", 
     StyleBox["body", "TI"], "]"}], Cell["lexical scoping", "TableText"]},
   {
    RowBox[{
     ButtonBox["Block",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Block"], "[", 
     StyleBox["vars", "TI"], ",", 
     StyleBox["body", "TI"], "]"}], Cell["dynamic scoping", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23165],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " variable scoping mechanisms. "
}], "Caption",
 CellID->15431],

Cell[TextData[{
 "Most traditional computer languages use a so\[Hyphen]called \
\[OpenCurlyDoubleQuote]lexical scoping\[CloseCurlyDoubleQuote] mechanism for \
variables, which is analogous to the module mechanism in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Some symbolic computer languages such as LISP also allow \
\[OpenCurlyDoubleQuote]dynamic scoping\[CloseCurlyDoubleQuote], analogous to \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " blocks. "
}], "Text",
 CellID->9658],

Cell[TextData[{
 "When lexical scoping is used, variables are treated as local to a \
particular section of the ",
 StyleBox["code",
  FontSlant->"Italic"],
 " in a program. In dynamic scoping, the values of variables are local to a \
part of the ",
 StyleBox["execution history",
  FontSlant->"Italic"],
 " of the program. "
}], "Text",
 CellID->11293],

Cell[TextData[{
 "In compiled languages like C and Java, there is a very clear distinction \
between \[OpenCurlyDoubleQuote]code\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]execution history\[CloseCurlyDoubleQuote]. The \
symbolic nature of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " makes this distinction slightly less clear, since \
\[OpenCurlyDoubleQuote]code\[CloseCurlyDoubleQuote] can in principle be built \
up dynamically during the execution of a program. "
}], "Text",
 CellID->17206],

Cell[TextData[{
 "What ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Module",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Module"], "[", 
   RowBox[{
    StyleBox["vars", "TI"], ",", 
    StyleBox["body", "TI"]}], "]"}]], "InlineFormula"],
 " does is to treat the form of the expression ",
 Cell[BoxData[
  StyleBox["body", "TI"]], "InlineFormula"],
 " at the time when the module is executed as the \[OpenCurlyDoubleQuote]code\
\[CloseCurlyDoubleQuote] of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program. Then when any of the ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 " explicitly appears in this \[OpenCurlyDoubleQuote]code\
\[CloseCurlyDoubleQuote], it is considered to be local. "
}], "Text",
 CellID->26578],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Block",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Block"], "[", 
   RowBox[{
    StyleBox["vars", "TI"], ",", 
    StyleBox["body", "TI"]}], "]"}]], "InlineFormula"],
 " does not look at the ",
 StyleBox["form",
  FontSlant->"Italic"],
 " of the expression ",
 Cell[BoxData[
  StyleBox["body", "TI"]], "InlineFormula"],
 ". Instead, throughout the evaluation of ",
 Cell[BoxData[
  StyleBox["body", "TI"]], "InlineFormula"],
 ", the block uses local values for the ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->16948],

Cell[TextData[{
 "This defines ",
 Cell[BoxData["m"], "InlineFormula"],
 " in terms of ",
 Cell[BoxData["i"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"i", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->27171],

Cell[BoxData[
 SuperscriptBox["i", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->18166]
}, Open  ]],

Cell[TextData[{
 "The local value for ",
 Cell[BoxData["i"], "InlineFormula"],
 " in the block is used throughout the evaluation of ",
 Cell[BoxData[
  RowBox[{"i", "+", "m"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->3396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"i", "=", "a"}], "}"}], ",", 
   RowBox[{"i", "+", "m"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->16697],

Cell[BoxData[
 RowBox[{"a", "+", 
  SuperscriptBox["a", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->31020]
}, Open  ]],

Cell[TextData[{
 "Here only the ",
 Cell[BoxData["i"], "InlineFormula"],
 " that appears explicitly in ",
 Cell[BoxData[
  RowBox[{"i", "+", "m"}]], "InlineFormula"],
 " is treated as a local variable. "
}], "MathCaption",
 CellID->23694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"i", "=", "a"}], "}"}], ",", 
   RowBox[{"i", "+", "m"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->15529],

Cell[BoxData[
 RowBox[{"a", "+", 
  SuperscriptBox["i", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->14788]
}, Open  ]],

Cell[TextData[ButtonBox["Modularity and the Naming of Things",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], \
"RelatedTutorials",
 CellID->405226890]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Blocks Compared with Modules - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Modularity and the Naming of Things", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/BlocksAndLocalValues"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Contexts"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 59.6389820}", "context" -> "", 
    "keywords" -> {
     "blocks", "compiled languages", "dynamic scoping", "history", 
      "lexical scoping", "modules", "programs", "scoping", "static scoping"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "When you write a program in Mathematica, you should always try to set it \
up so that its parts are as independent as possible. In this way, the program \
will be easier for you to understand, maintain and add to. One of the main \
ways to ensure that different parts of a program do not interfere is to give \
their variables only a certain 'scope'. Mathematica provides two basic \
mechanisms for limiting the scope of variables: modules and blocks. In \
writing actual programs, modules are far more common than blocks. When \
scoping is needed in interactive calculations, however, blocks are often \
convenient. ", "synonyms" -> {"2.7.7"}, "title" -> 
    "Blocks Compared with Modules", "type" -> "Tutorial", "uri" -> 
    "tutorial/BlocksComparedWithModules"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.7.7"->{
  Cell[1931, 60, 91, 2, 70, "Title",
   CellTags->{"S2.7.7", "7.1"},
   CellID->32372]},
 "7.1"->{
  Cell[1931, 60, 91, 2, 70, "Title",
   CellTags->{"S2.7.7", "7.1"},
   CellID->32372]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.7.7", 11461, 371},
 {"7.1", 11560, 375}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1306, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1931, 60, 91, 2, 70, "Title",
 CellTags->{"S2.7.7", "7.1"},
 CellID->32372],
Cell[2025, 64, 304, 8, 70, "Text",
 CellID->30032],
Cell[2332, 74, 372, 9, 70, "Text",
 CellID->3989],
Cell[2707, 85, 202, 5, 70, "Text",
 CellID->9320],
Cell[2912, 92, 781, 23, 70, "DefinitionBox",
 CellID->23165],
Cell[3696, 117, 129, 5, 70, "Caption",
 CellID->15431],
Cell[3828, 124, 501, 13, 70, "Text",
 CellID->9658],
Cell[4332, 139, 353, 11, 70, "Text",
 CellID->11293],
Cell[4688, 152, 516, 11, 70, "Text",
 CellID->17206],
Cell[5207, 165, 755, 23, 70, "Text",
 CellID->26578],
Cell[5965, 190, 626, 23, 70, "Text",
 CellID->16948],
Cell[6594, 215, 167, 7, 70, "MathCaption",
 CellID->2206],
Cell[CellGroupData[{
Cell[6786, 226, 112, 4, 70, "Input",
 CellID->27171],
Cell[6901, 232, 178, 6, 36, "Output",
 CellID->18166]
}, Open  ]],
Cell[7094, 241, 235, 8, 70, "MathCaption",
 CellID->3396],
Cell[CellGroupData[{
Cell[7354, 253, 194, 7, 70, "Input",
 CellID->16697],
Cell[7551, 262, 201, 7, 36, "Output",
 CellID->31020]
}, Open  ]],
Cell[7767, 272, 238, 8, 70, "MathCaption",
 CellID->23694],
Cell[CellGroupData[{
Cell[8030, 284, 195, 7, 70, "Input",
 CellID->15529],
Cell[8228, 293, 201, 7, 36, "Output",
 CellID->14788]
}, Open  ]],
Cell[8444, 303, 200, 5, 70, "RelatedTutorials",
 CellID->405226890]
}, Open  ]],
Cell[8659, 311, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

