(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39858,       1426]
NotebookOptionsPosition[     30767,       1125]
NotebookOutlinePosition[     33931,       1205]
CellTagsIndexPosition[     33837,       1199]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DisplayEndPacket" :> 
          Documentation`HelpLookup["paclet:ref/DisplayEndPacket"], 
          "DisplayPacket" :> 
          Documentation`HelpLookup["paclet:ref/DisplayPacket"], 
          "EnterExpressionPacket" :> 
          Documentation`HelpLookup["paclet:ref/EnterExpressionPacket"], 
          "EnterTextPacket" :> 
          Documentation`HelpLookup["paclet:ref/EnterTextPacket"], 
          "EvaluatePacket" :> 
          Documentation`HelpLookup["paclet:ref/EvaluatePacket"], 
          "InputNamePacket" :> 
          Documentation`HelpLookup["paclet:ref/InputNamePacket"], 
          "LinkInterrupt" :> 
          Documentation`HelpLookup["paclet:ref/LinkInterrupt"], "LinkLaunch" :> 
          Documentation`HelpLookup["paclet:ref/LinkLaunch"], "MessagePacket" :> 
          Documentation`HelpLookup["paclet:ref/MessagePacket"], 
          "OutputNamePacket" :> 
          Documentation`HelpLookup["paclet:ref/OutputNamePacket"], "Print" :> 
          Documentation`HelpLookup["paclet:ref/Print"], 
          "ReturnExpressionPacket" :> 
          Documentation`HelpLookup["paclet:ref/ReturnExpressionPacket"], 
          "ReturnPacket" :> 
          Documentation`HelpLookup["paclet:ref/ReturnPacket"], 
          "ReturnTextPacket" :> 
          Documentation`HelpLookup["paclet:ref/ReturnTextPacket"], 
          "TextPacket" :> 
          Documentation`HelpLookup["paclet:ref/TextPacket"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DisplayEndPacket\"\>", 
       2->"\<\"DisplayPacket\"\>", 3->"\<\"EnterExpressionPacket\"\>", 
       4->"\<\"EnterTextPacket\"\>", 5->"\<\"EvaluatePacket\"\>", 
       6->"\<\"InputNamePacket\"\>", 7->"\<\"LinkInterrupt\"\>", 
       8->"\<\"LinkLaunch\"\>", 9->"\<\"MessagePacket\"\>", 
       10->"\<\"OutputNamePacket\"\>", 11->"\<\"Print\"\>", 
       12->"\<\"ReturnExpressionPacket\"\>", 13->"\<\"ReturnPacket\"\>", 
       14->"\<\"ReturnTextPacket\"\>", 
       15->"\<\"TextPacket\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Calling Subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Processes"
}], "Title",
 CellTags->{"S2.13.7", "7.1"},
 CellID->20968],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LinkLaunch",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkLaunch"], "[", "\"\<\!\(\*
StyleBox[\"prog\", \"TI\"]\)\>\"", "]"}], Cell[
    "start an external program and open a connection to it", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3251],

Cell[TextData[{
 "Connecting to a subsidiary program via ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->27216],

Cell[TextData[{
 "This starts a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process on the computer system used here. "
}], "MathCaption",
 CellID->12079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"LinkLaunch", "[", "\"\<math -mathlink\>\"", "]"}]}]], "Input", \
"ConversionLockdown",
 CellLabel->"In[1]:=",
 CellID->28768],

Cell["LinkObject[math -mathlink, 4, 4]", "Output", "ConversionLockdown",
 ImageSize->{224, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17040]
}, Open  ]],

Cell[TextData[{
 "Here is a packet representing the first input prompt from the subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process. "
}], "MathCaption",
 CellID->31531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[2]:= ",
 CellID->12933],

Cell["InputNamePacket[In[1]:= ]", "Output", "ConversionLockdown",
 ImageSize->{175, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23779]
}, Open  ]],

Cell[TextData[{
 "This writes a packet representing text to enter in the subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process. "
}], "MathCaption",
 CellID->20663],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"EnterTextPacket", "[", "\"\<10!\>\"", "]"}]}], "]"}]], "Input", \
"ConversionLockdown",
 CellLabel->"In[3]:= ",
 CellID->12259],

Cell[TextData[{
 "Here is a packet representing the output prompt from the subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process. "
}], "MathCaption",
 CellID->26653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[4]:= ",
 CellID->27936],

Cell["OutputNamePacket[Out[1]= ]", "Output", "ConversionLockdown",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2095]
}, Open  ]],

Cell["And here is the actual result from the computation. ", "MathCaption",
 CellID->24365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[5]:= ",
 CellID->11874],

Cell["ReturnTextPacket[3628800]", "Output", "ConversionLockdown",
 ImageSize->{175, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->7720]
}, Open  ]],

Cell[TextData[{
 "The basic way that the various different objects involved in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session are kept organized is by using ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " ",
 StyleBox["packets",
  FontSlant->"Italic"],
 ". A ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " packet is simply an expression with a definite head that indicates its \
role or meaning."
}], "Text",
 CellID->26835],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["EnterTextPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EnterTextPacket"], "[", "\"\<\!\(\*
StyleBox[\"input\", \"TI\"]\)\>\"", "]"}], Cell[
    "text to enter corresponding to an input line", "TableText"]},
   {
    RowBox[{
     ButtonBox["ReturnTextPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReturnTextPacket"], "[", "\"\<\!\(\*
StyleBox[\"output\", \"TI\"]\)\>\"", "]"}], Cell[
    "text returned corresponding to an output line", "TableText"]},
   {
    RowBox[{
     ButtonBox["InputNamePacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InputNamePacket"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}], Cell[
    "text returned for the name of an input line", "TableText"]},
   {
    RowBox[{
     ButtonBox["OutputNamePacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OutputNamePacket"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}], Cell[
    "text returned for the name of an output line", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25680],

Cell[TextData[{
 "Basic packets used in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sessions. "
}], "Caption",
 CellID->8976],

Cell[TextData[{
 "The fact that ",
 Cell[BoxData[
  ButtonBox["LinkRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkRead"]], "InlineFormula"],
 " returns an ",
 Cell[BoxData[
  ButtonBox["InputNamePacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputNamePacket"]], "InlineFormula"],
 " indicates that the subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is now ready for new input. "
}], "MathCaption",
 CellID->18455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[6]:= ",
 CellID->5725],

Cell["InputNamePacket[In[2]:= ]", "Output", "ConversionLockdown",
 ImageSize->{175, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->4071]
}, Open  ]],

Cell[TextData[{
 "This enters two ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " commands as input. "
}], "MathCaption",
 CellID->24808],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"EnterTextPacket", "[", "\"\<Print[a]; Print[b];\>\"", "]"}]}], 
  "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[7]:= ",
 CellID->13559],

Cell[TextData[{
 "Here is the text from the first ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->9156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[8]:= ",
 CellID->5602],

Cell["\<\
TextPacket[a
]\
\>", "Output", "ConversionLockdown",
 ImageSize->{84, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->17832]
}, Open  ]],

Cell[TextData[{
 "And here is the text from the second ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[9]:= ",
 CellID->10440],

Cell["\<\
TextPacket[b
]\
\>", "Output", "ConversionLockdown",
 ImageSize->{84, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->7375]
}, Open  ]],

Cell[TextData[{
 "No output line is generated, so the new packet is an ",
 Cell[BoxData[
  ButtonBox["InputNamePacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputNamePacket"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21562],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[10]:= ",
 CellID->22885],

Cell["InputNamePacket[In[3]:= ]", "Output", "ConversionLockdown",
 ImageSize->{175, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->21962]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["TextPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TextPacket"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "text from ",
     Cell[BoxData[
      ButtonBox["Print",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Print"]], "InlineFormula"],
     " etc."
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MessagePacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MessagePacket"], "[", 
     StyleBox["symb", "TI"], ",", "\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\"", "]"}], Cell[
    "a message name", "TableText"]},
   {
    RowBox[{
     ButtonBox["DisplayPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DisplayPacket"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}], Cell[
    "parts of PostScript graphics", "TableText"]},
   {
    RowBox[{
     ButtonBox["DisplayEndPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DisplayEndPacket"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}], Cell[
    "the end of PostScript graphics", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21080],

Cell[TextData[{
 "Some additional packets generated in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sessions. "
}], "Caption",
 CellID->1836],

Cell[TextData[{
 "If you enter input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EnterTextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EnterTextPacket"], "[", "\"\<\!\(\*
StyleBox[\"input\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 ", then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will automatically generate a string version of your output, and will \
respond with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ReturnTextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnTextPacket"], "[", "\"\<\!\(\*
StyleBox[\"output\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 ". But if you instead enter input using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EnterExpressionPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EnterExpressionPacket"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will respond with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ReturnExpressionPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnExpressionPacket"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " and will not turn your output into a string. "
}], "Text",
 CellID->10797],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["EnterExpressionPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EnterExpressionPacket"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "an expression to enter corresponding to an input line", "TableText"]},
   {
    RowBox[{
     ButtonBox["ReturnExpressionPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReturnExpressionPacket"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "an expression returned corresponding to an output line", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31202],

Cell["\<\
Packets for representing input and output lines using expressions. \
\>", "Caption",
 CellID->10508],

Cell[TextData[{
 "This enters an expression into the subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session without evaluating it. "
}], "MathCaption",
 CellID->10080],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{"EnterExpressionPacket", "[", 
     RowBox[{"Factor", "[", 
      RowBox[{
       RowBox[{"x", "^", "6"}], "-", "1"}], "]"}], "]"}], "]"}]}], 
  "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[11]:= ",
 CellID->5340],

Cell[TextData[{
 "Here are the next 3 packets that come back from the subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "MathCaption",
 CellID->12076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"LinkRead", "[", "link", "]"}], ",", 
   RowBox[{"{", "3", "}"}]}], "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[12]:= ",
 CellID->9058],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OutputNamePacket", "[", "\<\"Out[3]=\"\>", "]"}], ",", 
   RowBox[{"ReturnExpressionPacket", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "x", "-", 
       SuperscriptBox["x", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}], ")"}]}], "]"}], ",", 
   RowBox[{"InputNamePacket", "[", "\<\"In[4]:=\"\>", "]"}]}], 
  "}"}]], "Output", "ConversionLockdown",
 ImageSize->{416, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->31493]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputNamePacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputNamePacket"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["OutputNamePacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputNamePacket"]], "InlineFormula"],
 " packets are often convenient for making it possible to tell the current \
state of a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. But you can suppress the generation of these packets by calling \
the subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session with a string such as ",
 Cell[BoxData["\"\<math -mathlink -batchoutput\>\""], "InlineFormula"],
 ". "
}], "Text",
 CellID->7740],

Cell[TextData[{
 "Even if you suppress the explicit generation of ",
 Cell[BoxData[
  ButtonBox["InputNamePacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputNamePacket"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["OutputNamePacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputNamePacket"]], "InlineFormula"],
 " packets, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will still process any input that you give with ",
 Cell[BoxData[
  ButtonBox["EnterTextPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EnterTextPacket"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["EnterExpressionPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EnterExpressionPacket"]], "InlineFormula"],
 " as if you were entering an input line. This means for example that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will call ",
 Cell[BoxData[
  ButtonBox["$Pre",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Pre"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$Post",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Post"]], "InlineFormula"],
 ", and will assign values to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["In",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/In"], "[", 
   ButtonBox["$Line",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Line"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", 
   ButtonBox["$Line",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Line"], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->8546],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["EvaluatePacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EvaluatePacket"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "an expression to be sent purely for evaluation", "TableText"]},
   {
    RowBox[{
     ButtonBox["ReturnPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReturnPacket"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "an expression returned from an evaluation", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20474],

Cell["\<\
Evaluating expressions without explicit input and output lines. \
\>", "Caption",
 CellID->24773],

Cell[TextData[{
 "This sends an ",
 Cell[BoxData[
  ButtonBox["EvaluatePacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EvaluatePacket"]], "InlineFormula"],
 ". The ",
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 " prevents evaluation before the packet is sent. "
}], "MathCaption",
 CellID->19097],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{"EvaluatePacket", "[", 
     RowBox[{"10", "!"}], "]"}], "]"}]}], "]"}]], "Input", \
"ConversionLockdown",
 CellLabel->"In[13]:= ",
 CellID->8880],

Cell[TextData[{
 "The result is a pure ",
 Cell[BoxData[
  ButtonBox["ReturnPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReturnPacket"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[14]:= ",
 CellID->11072],

Cell[BoxData[
 RowBox[{"ReturnPacket", "[", "3628800", "]"}]], "Output", "ConversionLockdown",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->23400]
}, Open  ]],

Cell[TextData[{
 "This sends an ",
 Cell[BoxData[
  ButtonBox["EvaluatePacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EvaluatePacket"]], "InlineFormula"],
 " requesting evaluation of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "[", "x", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->707],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{"EvaluatePacket", "[", 
     RowBox[{"Print", "[", "x", "]"}], "]"}], "]"}]}], "]"}]], "Input", \
"ConversionLockdown",
 CellLabel->"In[15]:= ",
 CellID->22955],

Cell[TextData[{
 "The first packet to come back is a ",
 Cell[BoxData[
  ButtonBox["TextPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TextPacket"]], "InlineFormula"],
 " representing text generated by the ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[16]:= ",
 CellID->4141],

Cell["\<\
TextPacket[x
]\
\>", "Output", "ConversionLockdown",
 ImageSize->{84, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->23588]
}, Open  ]],

Cell[TextData[{
 "After that, the actual result of the ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " is returned. "
}], "MathCaption",
 CellID->12481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[17]:= ",
 CellID->17168],

Cell["ReturnPacket[Null]", "Output", "ConversionLockdown",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->28315]
}, Open  ]],

Cell[TextData[{
 "In most cases, it is reasonable to assume that sending an ",
 Cell[BoxData[
  ButtonBox["EvaluatePacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EvaluatePacket"]], "InlineFormula"],
 " to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will simply cause ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to do a computation and to return various other packets, ending with a ",
 Cell[BoxData[
  ButtonBox["ReturnPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReturnPacket"]], "InlineFormula"],
 ". However, if the computation involves a function like ",
 Cell[BoxData[
  ButtonBox["Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Input"]], "InlineFormula"],
 ", then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will have to request additional input before it can proceed with the \
computation. "
}], "Text",
 CellID->19396],

Cell[TextData[{
 "This sends a packet whose evaluation involves an ",
 Cell[BoxData[
  ButtonBox["Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Input"]], "InlineFormula"],
 " function. "
}], "MathCaption",
 CellID->16225],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{"EvaluatePacket", "[", 
     RowBox[{"2", "+", 
      RowBox[{"Input", "[", "\"\<data =\>\"", "]"}]}], "]"}], "]"}]}], 
  "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[18]:= ",
 CellID->1009],

Cell[TextData[{
 "What comes back is an ",
 Cell[BoxData[
  ButtonBox["InputPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputPacket"]], "InlineFormula"],
 " which indicates that further input is required. "
}], "MathCaption",
 CellID->22012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[19]:= ",
 CellID->18136],

Cell["InputPacket[data =]", "Output", "ConversionLockdown",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->11455]
}, Open  ]],

Cell["There is nothing more to be read on the link at this point. ", \
"MathCaption",
 CellID->18762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkReadyQ", "[", "link", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[20]:= ",
 CellID->25043],

Cell["False", "Output", "ConversionLockdown",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->742]
}, Open  ]],

Cell["This enters more input. ", "MathCaption",
 CellID->21],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"EnterTextPacket", "[", "\"\<x + y\>\"", "]"}]}], "]"}]], "Input", \
"ConversionLockdown",
 CellLabel->"In[21]:= ",
 CellID->17922],

Cell[TextData[{
 "Now the ",
 Cell[BoxData[
  ButtonBox["Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Input"]], "InlineFormula"],
 " function can be evaluated, and a ",
 Cell[BoxData[
  ButtonBox["ReturnPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReturnPacket"]], "InlineFormula"],
 " is generated. "
}], "MathCaption",
 CellID->24512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[22]:= ",
 CellID->9248],

Cell["ReturnPacket[2 + x + y]", "Output", "ConversionLockdown",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->26018]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LinkInterrupt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkInterrupt"], "[", 
     StyleBox["link", "TI"], "]"}], Cell[TextData[{
     "send an interrupt to a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     "\[Hyphen]compatible program"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27368],

Cell[TextData[{
 "Interrupting a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "-compatible program. "
}], "Caption",
 CellID->23717],

Cell["\<\
This sends a very time\[Hyphen]consuming calculation to the subsidiary \
process. \
\>", "MathCaption",
 CellID->9714],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"EnterTextPacket", "[", "\"\<FactorInteger[2^777-1]\>\"", "]"}]}], 
  "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[23]:= ",
 CellID->17650],

Cell["The calculation is still going on. ", "MathCaption",
 CellID->13290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkReadyQ", "[", "link", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[24]:= ",
 CellID->3335],

Cell["False", "Output", "ConversionLockdown",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->12759]
}, Open  ]],

Cell["This sends an interrupt. ", "MathCaption",
 CellID->3169],

Cell[BoxData[
 RowBox[{"LinkInterrupt", "[", "link", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[25]:= ",
 CellID->21895],

Cell["\<\
Now the subsidiary process has stopped, and is sending back an interrupt \
menu. \
\>", "MathCaption",
 CellID->5303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[26]:= ",
 CellID->22640],

Cell["MenuPacket[1, Interrupt> ]", "Output", "ConversionLockdown",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->21979]
}, Open  ]],

Cell["This closes the link", "MathCaption", "ConversionLockdown",
 CellID->1362606416],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "link", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[27]:=",
 CellID->77511614],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->129209020],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Calling Subsidiary Mathematica Processes - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "MathLink and External Program Communication", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/\
UsingMathLinkToCommunicateBetweenMathematicaSessions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TwoWayCommunicationWithExternalPrograms"]}], "Text",
       FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 8.1704504}", "context" -> "", 
    "keywords" -> {
     "child processes", "DisplayEndPacket", "DisplayPacket", 
      "EnterExpressionPacket", "EnterTextPacket", "EvaluatePacket", 
      "InputNamePacket", "interrupts", "launching programs", "LinkInterrupt", 
      "LinkLaunch", "main loop", "MessagePacket", "OutputNamePacket", 
      "packets", "ReturnExpressionPacket", "ReturnPacket", "ReturnTextPacket",
       "sessions", "slave processes", "starting programs", 
      "subsidiary processes", "TextPacket"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Connecting to a subsidiary program via MathLink. This starts a \
subsidiary Mathematica process on the computer system used here. Here is a \
packet representing the first input prompt from the subsidiary Mathematica \
process. ", "synonyms" -> {"2.13.7"}, "title" -> 
    "Calling Subsidiary Mathematica Processes", "type" -> "Tutorial", "uri" -> 
    "tutorial/CallingSubsidiaryMathematicaProcesses"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.13.7"->{
  Cell[3691, 92, 162, 7, 70, "Title",
   CellTags->{"S2.13.7", "7.1"},
   CellID->20968]},
 "7.1"->{
  Cell[3691, 92, 162, 7, 70, "Title",
   CellTags->{"S2.13.7", "7.1"},
   CellID->20968]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.13.7", 33622, 1188},
 {"7.1", 33723, 1192}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3066, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3691, 92, 162, 7, 70, "Title",
 CellTags->{"S2.13.7", "7.1"},
 CellID->20968],
Cell[3856, 101, 596, 16, 70, "DefinitionBox",
 CellID->3251],
Cell[4455, 119, 142, 6, 70, "Caption",
 CellID->27216],
Cell[4600, 127, 176, 6, 70, "MathCaption",
 CellID->12079],
Cell[CellGroupData[{
Cell[4801, 137, 173, 5, 28, "Input",
 CellID->28768],
Cell[4977, 144, 199, 5, 36, "Output",
 CellID->17040]
}, Open  ]],
Cell[5191, 152, 191, 6, 70, "MathCaption",
 CellID->31531],
Cell[CellGroupData[{
Cell[5407, 162, 126, 3, 28, "Input",
 CellID->12933],
Cell[5536, 167, 192, 5, 36, "Output",
 CellID->23779]
}, Open  ]],
Cell[5743, 175, 184, 6, 70, "MathCaption",
 CellID->20663],
Cell[5930, 183, 205, 6, 70, "Input",
 CellID->12259],
Cell[6138, 191, 186, 6, 70, "MathCaption",
 CellID->26653],
Cell[CellGroupData[{
Cell[6349, 201, 126, 3, 70, "Input",
 CellID->27936],
Cell[6478, 206, 192, 5, 36, "Output",
 CellID->2095]
}, Open  ]],
Cell[6685, 214, 91, 1, 70, "MathCaption",
 CellID->24365],
Cell[CellGroupData[{
Cell[6801, 219, 126, 3, 70, "Input",
 CellID->11874],
Cell[6930, 224, 191, 5, 36, "Output",
 CellID->7720]
}, Open  ]],
Cell[7136, 232, 451, 16, 70, "Text",
 CellID->26835],
Cell[7590, 250, 1401, 37, 70, "DefinitionBox",
 CellID->25680],
Cell[8994, 289, 136, 6, 70, "Caption",
 CellID->8976],
Cell[9133, 297, 456, 16, 70, "MathCaption",
 CellID->18455],
Cell[CellGroupData[{
Cell[9614, 317, 125, 3, 70, "Input",
 CellID->5725],
Cell[9742, 322, 191, 5, 36, "Output",
 CellID->4071]
}, Open  ]],
Cell[9948, 330, 208, 8, 70, "MathCaption",
 CellID->24808],
Cell[10159, 340, 222, 6, 70, "Input",
 CellID->13559],
Cell[10384, 348, 205, 8, 70, "MathCaption",
 CellID->9156],
Cell[CellGroupData[{
Cell[10614, 360, 125, 3, 70, "Input",
 CellID->5602],
Cell[10742, 365, 188, 8, 52, "Output",
 CellID->17832]
}, Open  ]],
Cell[10945, 376, 210, 8, 70, "MathCaption",
 CellID->7905],
Cell[CellGroupData[{
Cell[11180, 388, 126, 3, 70, "Input",
 CellID->10440],
Cell[11309, 393, 187, 8, 52, "Output",
 CellID->7375]
}, Open  ]],
Cell[11511, 404, 247, 8, 70, "MathCaption",
 CellID->21562],
Cell[CellGroupData[{
Cell[11783, 416, 127, 3, 70, "Input",
 CellID->22885],
Cell[11913, 421, 193, 5, 36, "Output",
 CellID->21962]
}, Open  ]],
Cell[12121, 429, 1486, 44, 70, "DefinitionBox",
 CellID->21080],
Cell[13610, 475, 151, 6, 70, "Caption",
 CellID->1836],
Cell[13764, 483, 1278, 41, 70, "Text",
 CellID->10797],
Cell[15045, 526, 862, 23, 70, "DefinitionBox",
 CellID->31202],
Cell[15910, 551, 110, 3, 70, "Caption",
 CellID->10508],
Cell[16023, 556, 186, 6, 70, "MathCaption",
 CellID->10080],
Cell[16212, 564, 333, 10, 70, "Input",
 CellID->5340],
Cell[16548, 576, 181, 6, 70, "MathCaption",
 CellID->12076],
Cell[CellGroupData[{
Cell[16754, 586, 206, 6, 70, "Input",
 CellID->9058],
Cell[16963, 594, 760, 23, 77, "Output",
 CellID->31493]
}, Open  ]],
Cell[17738, 620, 730, 22, 70, "Text",
 CellID->7740],
Cell[18471, 644, 1632, 57, 70, "Text",
 CellID->8546],
Cell[20106, 703, 808, 23, 70, "DefinitionBox",
 CellID->20474],
Cell[20917, 728, 107, 3, 70, "Caption",
 CellID->24773],
Cell[21027, 733, 388, 13, 70, "MathCaption",
 CellID->19097],
Cell[21418, 748, 256, 8, 70, "Input",
 CellID->8880],
Cell[21677, 758, 209, 8, 70, "MathCaption",
 CellID->23335],
Cell[CellGroupData[{
Cell[21911, 770, 127, 3, 70, "Input",
 CellID->11072],
Cell[22041, 775, 223, 6, 36, "Output",
 CellID->23400]
}, Open  ]],
Cell[22279, 784, 379, 14, 70, "MathCaption",
 CellID->707],
Cell[22661, 800, 270, 8, 70, "Input",
 CellID->22955],
Cell[22934, 810, 373, 13, 70, "MathCaption",
 CellID->20666],
Cell[CellGroupData[{
Cell[23332, 827, 126, 3, 70, "Input",
 CellID->4141],
Cell[23461, 832, 189, 8, 52, "Output",
 CellID->23588]
}, Open  ]],
Cell[23665, 843, 223, 8, 70, "MathCaption",
 CellID->12481],
Cell[CellGroupData[{
Cell[23913, 855, 127, 3, 70, "Input",
 CellID->17168],
Cell[24043, 860, 186, 5, 36, "Output",
 CellID->28315]
}, Open  ]],
Cell[24244, 868, 895, 28, 70, "Text",
 CellID->19396],
Cell[25142, 898, 232, 8, 70, "MathCaption",
 CellID->16225],
Cell[25377, 908, 310, 9, 70, "Input",
 CellID->1009],
Cell[25690, 919, 255, 8, 70, "MathCaption",
 CellID->22012],
Cell[CellGroupData[{
Cell[25970, 931, 127, 3, 70, "Input",
 CellID->18136],
Cell[26100, 936, 187, 5, 36, "Output",
 CellID->11455]
}, Open  ]],
Cell[26302, 944, 101, 2, 70, "MathCaption",
 CellID->18762],
Cell[CellGroupData[{
Cell[26428, 950, 129, 3, 70, "Input",
 CellID->25043],
Cell[26560, 955, 170, 5, 36, "Output",
 CellID->742]
}, Open  ]],
Cell[26745, 963, 60, 1, 70, "MathCaption",
 CellID->21],
Cell[26808, 966, 208, 6, 70, "Input",
 CellID->17922],
Cell[27019, 974, 361, 13, 70, "MathCaption",
 CellID->24512],
Cell[CellGroupData[{
Cell[27405, 991, 126, 3, 70, "Input",
 CellID->9248],
Cell[27534, 996, 191, 5, 36, "Output",
 CellID->26018]
}, Open  ]],
Cell[27740, 1004, 664, 20, 70, "DefinitionBox",
 CellID->27368],
Cell[28407, 1026, 137, 6, 70, "Caption",
 CellID->23717],
Cell[28547, 1034, 128, 4, 70, "MathCaption",
 CellID->9714],
Cell[28678, 1040, 226, 6, 70, "Input",
 CellID->17650],
Cell[28907, 1048, 74, 1, 70, "MathCaption",
 CellID->13290],
Cell[CellGroupData[{
Cell[29006, 1053, 128, 3, 70, "Input",
 CellID->3335],
Cell[29137, 1058, 172, 5, 36, "Output",
 CellID->12759]
}, Open  ]],
Cell[29324, 1066, 63, 1, 70, "MathCaption",
 CellID->3169],
Cell[29390, 1069, 132, 3, 70, "Input",
 CellID->21895],
Cell[29525, 1074, 127, 4, 70, "MathCaption",
 CellID->5303],
Cell[CellGroupData[{
Cell[29677, 1082, 127, 3, 70, "Input",
 CellID->22640],
Cell[29807, 1087, 194, 5, 36, "Output",
 CellID->21979]
}, Open  ]],
Cell[30016, 1095, 86, 1, 70, "MathCaption",
 CellID->1362606416],
Cell[30105, 1098, 130, 3, 70, "Input",
 CellID->77511614],
Cell[CellGroupData[{
Cell[30260, 1105, 72, 1, 70, "RelatedTutorialsSection",
 CellID->129209020],
Cell[30335, 1108, 378, 11, 70, "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],
Cell[30740, 1123, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

