(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     61268,       1335]
NotebookOptionsPosition[     55495,       1171]
NotebookOutlinePosition[     58749,       1248]
CellTagsIndexPosition[     58655,       1242]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cell" :> Documentation`HelpLookup["paclet:ref/Cell"], 
          "CellPrint" :> Documentation`HelpLookup["paclet:ref/CellPrint"], 
          "Show Expression" :> 
          Documentation`HelpLookup["paclet:ref/menuitem/ShowExpression"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Cell\"\>", 
       2->"\<\"CellPrint\"\>", 
       3->"\<\"Show Expression\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Cells as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Expressions"
}], "Title",
 CellTags->{"S2.11.1", "1.1"},
 CellID->24199],

Cell[TextData[{
 "Like other objects in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the cells in a notebook, and in fact the whole notebook itself, are all \
ultimately represented as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. With the standard notebook front end, you can use the command \
",
 StyleBox[ButtonBox["Show Expression",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/ShowExpression"], "MenuName"],
 " to see the text of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression that corresponds to any particular cell."
}], "Text",
 CellID->29105],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox[ButtonBox["Show Expression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/menuitem/ShowExpression"], "MenuName"],
     " menu item"
    }], "TableText"], Cell[TextData[{
     "toggle between displayed form and underlying ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression"
    }], "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["*", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["8", "KeyEvent"],
     " (between existing cells)"
    }], "TableText"], Cell[TextData[{
     "put up a dialog box to allow input of a cell in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression form"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->24791],

Cell[TextData[{
 "Handling ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " expressions in the notebook front end. "
}], "Caption",
 CellID->18661],

Cell["Here is a cell displayed in its usual way in the front end.", \
"MathCaption",
 CellID->8681],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 55},
 ImageMargins->0,
 CellID->1638759295],

Cell[TextData[{
 "Here is the underlying ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression that corresponds to the cell."
}], "MathCaption",
 CellID->8753],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 55},
 ImageMargins->0,
 CellID->911750343],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Cell",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cell"], "[", 
     StyleBox["contents", "TI"], ",", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\"", "]"}], Cell[
    "a cell with a specific style", "TableText"]},
   {
    RowBox[{
     ButtonBox["Cell",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cell"], "[", 
     StyleBox["contents", "TI"], ",", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\"", ",", 
     StyleBox["options", "TI"], "]"}], Cell[
    "a cell with additional options specified", "TableText"]},
   {
    RowBox[{
     ButtonBox["Cell",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cell"], "[", 
     RowBox[{
      StyleBox["contents", "TI"], ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"style\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"style\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      StyleBox["options", "TI"]}], "]"}], Cell[
    "a cell with several styles", "TableText"]}
  }]], "DefinitionBox",
 CellID->32029],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions corresponding to cells in notebooks. "
}], "Caption",
 CellID->15987],

Cell[TextData[{
 "Within a given notebook, there is always a collection of ",
 StyleBox["styles",
  FontSlant->"Italic"],
 " that can be used to determine the appearance and behavior of cells. \
Typically the styles are named so as to reflect what role cells which have \
them will play in the notebook. "
}], "Text",
 CellID->7042],

Cell[BoxData[GridBox[{
   {"\"\<Title\>\"", Cell["the title of the notebook", "TableText"]},
   {"\"\<Section\>\"", Cell["a section heading", "TableText"]},
   {"\"\<Subsection\>\"", Cell["a subsection heading", "TableText"]},
   {"\"\<Text\>\"", Cell["ordinary text", "TableText"]},
   {"\"\<Input\>\"", Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " input"
    }], "TableText"]},
   {"\"\<Output\>\"", Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " output"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->26253],

Cell["Some typical cell styles defined in notebooks. ", "Caption",
 CellID->20083],

Cell["Here are several cells in different styles.", "MathCaption",
 CellID->11420],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnQd4VEXXgJfNJiEQiiBgFwQsFJVmF+zYC6KiYkEsIGIDu34qKBawADZs
n9h7x4qFqnSkCIh0AgGkSxGF+ec9d87k7rKJYTdE+H7nee7N7twpZ04/Z+Zu
TmvXtcMVndt17di+Xc2WN7a7vkPH9l1qnnDdjbYqo0wkEq0WiUQerRnhs7Ef
3a2g1OAWiWQE3+SZvVXlVsbVZPhHEX1eVKOZM2fa5++9957cKnKLSmWGVOo4
2jGzYGJbbDvz888/R4JP3MpL3xi1+tQMGDAgmnxy/hT0rVzEvPF9okEfLbnc
ioI6Kw5qhU0WregpJx1iflmuQRGAJ04YLEZLtnzPTEQVrSMlOiiXxXDJDpoU
0uxCsRjPpWULgXKrLL1EBw2tqRQg3ebw6YR1GyfS9oXPf+V9G2aldOV9uRuv
339/MG2veE2uC9q/au7vOdB2KvxZ+eIurhgkWOHGWrFynVmQv1KuOXOXmVYX
vuRhSPas2DAUExer5GOGyV+0yq7zNfkWS1JXLsm8KSqe691Qs2bNMu+++65c
H3/8sVm3bl2ktgPg+5ErzFufL5br2xFCMHNuGqCmiCIF9e677zaxWMxEo1Gz
ww47mHHjxjlQM80+p4422Y2GmkiDIab2iaPMpk2bgnnPSRHeNNi7pZtk2Yo/
zYYNG828hev5XNFVL166waxbv9HMnLeOxzs6YK655hqz//77y7csV7d8eYD0
ALSgbunSpQl1mw2pTVeuDgAIvgX3WfPXmdgBQ8zXw5dHKrg6uuuQiptNf23y
dXJvUdKEL1o+m8jDSuaYyyYIUfWqevgP5i8L29NvLjBl7HfW8v7XS0yFg4bL
83O7TJHxrn9whgXP1kTKmkvvmCZ1p18z2WQeONTkNBlmKh863DQ5d5xZ9Nsf
Abpyza7HjIibKmP/Iebj734TzEYbDpGuTE/XDt2mB91qm+bNm8sq9KpSpYrF
+gbz7LPPmjJlypiMjAyRrgoVKsjzc88VGRKC16hRwxx22GFmxx13NKeffrrJ
y8uTZ4sXLzaNGzeW9ieffLKw/U477QRby/MJEyaY3Xbbzc93/vnnm7Vr1zoq
ZxUGctQ9BoEtr5woq0RqDrlgvBn78+qoIye96XHK1ZM835xn8eoQAxntPcfc
0XuWQAOP3fvUHLPvaaM9jS65fZr5889NER1z0eClZkibMWbGy/MCgh9V0vz0
94LZWO67mlETV5me/50nsHa671fz5bBl0tfygtnLKo8jL/7JrF7zl+nSc6a0
GTFBFLT5de5a0YVNzxtn6p0+Wj5PmbFGnoGfK++Zbtb/sVHGgXnu6zfXiWgF
0aWvfbpIxrvsrl/Me5ZnV6wK5HOHw34wb3+xRMZ55q0F0mbqzDUOHbua0aNH
m0cffVTW0blzZzNw4MAA3kWLTJ06dYSDVq5cabp27SptfvjhB89hfG/durXp
1q2bKVeunLn66qvl2VtvvSXP3nzzTeFIPvfs2TOiLHL77bcL97788svUm5Yt
W5qFCxcG7FCxKLDl+7gpq+U7KHn540UilhZdUUfmlz7MN1mWN8HStFlro27U
ib/8Lkit1XKkObztePk8O2+djPjg8wHBer+SJ+2ee3ehKIe8ReuVx+Z/mm8G
tx5tpvaemT6PpWhXm7jh4QvAtTT3Uom+adM10E+Az3Oro1XEzug82bS49Cc3
dNBl1e9/StPjr5hoyjcbJl1eH7BYDQRkoOrJNxb4WeDS2x6fZRq1His6oFzT
YcyiRmHKlCkC7Guvvea67GgOOuggc845YirNiy++KM9hKGWi8uXL4xjI9wsv
vNBUq1bNCvef5rbbbhPVRRkzZoz0++STT5QedN1jjz3kW7ZDdCHQyRCDRq1Q
eVPLdlCbAGXHXT7RXN19uhKv8Tljzfk3TQmhKsMc3W6C2anFjyJ1UblnmF5W
yjHD4XZrrAV01m0rWbb0uaT5JcIG5pGX5stzq42K4pLuz8yRZvXPGGPa3TnN
vGnlZuPGTYVzSabZv9UYkcCjLp1gulo9N2byau92FMYiRx55pED12GOPiRNm
LY5nkZycHLNmTSD8bdq0EQftjz/+MDfffLNYKsr06dMTWaRTp06mdu3aIRZJ
Dpq2R42yFGutHI2yeC511qUx7361RORk+UovVpvzSrY5ueMkU8PyChaM65wb
A+s2ZMyKgLbHOi7QCOT8y141Z7ftr0K0FRyewDhVMHf1nW0eeG5umDXEQJ16
9STpB3ugNu/sM1uWZmnujXSPZ+eaOieNgj88O3Xu8asYZHxDqzmkz88z1qiA
4Q/e1Cuwc0+8nhf2EPCHkD1EFvNu6ZGMQ4Iuu5mffvrJ7LzzzuLvQPWGDRua
Aw44QID+7bffhIPoc8opp5hbb73VlC1bVqwRTu4RRxzhuaR3797KJZ6bsFyM
iw+0++67m0GDBgXUr14YpNL1FWt5WLs6JagHlA8FI40cgUsUzxdDl4lDiSG3
RlwZLhn3vPHZYhkSsYPhmll/YI/jRpo1a/+K5x6NHSdMXgAHpcU9f69UGjkO
am/dC+xumIOwzweePdZzEHoVd23vU0axhIgaZlQFy4GLrCZRJpoxd50wYK4V
rV2OHmGqN/8RI6xM9N3I5RKB0ct6BKpj1FdCmPezkzU8a0xSHaMchE9St25d
07FjR+EefJt33nlHgJ40aZKpV6+emJ/DDz/c5ObmCifhMf/yyy+mfv365phj
jpG2F198sfQdOnSofAdJzZo1E510zz33mPvuu88sWLAggL5aMjADCbX4Q5uC
w6vunW7ueXKO6B/K+KmrxQVkxXgkD70wTz4f0GqsWbJsQyQZ+yha+r29UPCO
noJTJ03/Pcw28WmP0897kb+R4vJOinmzRm5ANE/Fg4eLtBAm4eMRCuC/WeUo
9VbSsh00Nz8y0/T/KF++VXR1VvUSOcAzLsLMMhdccIHIbqVKlUz16tXNgQce
aAX3rxo6jFUXGvvqMDjpYN66hy7fEhOnvGO36aaKhcph1ZzqkBDO03CtXbuh
2EhLMS94iBue3AgWxMakEcXMSR0mmVsfmxW3pKUrNpiyjYea0ZNWR+q5Omwo
0R7fKrm6uQvXG1ccuDHxkS6+bZppfcPP5ikb+1KS5WKKzRNFW6Nj3dDWi/Cg
KHh/JaYGXt4CNKeaIvtjG5kj3bRnWusoRkpzgxt/8ZLV5t4Hv/pHaZHOnsi2
Qu+SoMW2sIZ09lO2BE9bm96p7rZoqj/ZlsJW9sukgW53JNtOKI3509liSHHe
Lm54nP9bbrnFnXaw5c5/CpaYmTt3rrnjjjtM27ZtzerVq6XfHaUPzhFuePK5
K1YEvFk2VPf777+TYPEJ/o0bN+Ivybj2b6aDRHMyFFLOdkWRHL5E6R1LMknU
P1UPlTxPnz595FtBwmCDYsd7suvXr5ecj+eoa9JAW4raqIHcd5TEwuOPPy71
V1xxBc689H366aclTCRhOmrUKPn83HPPyWfS7zj/rJdg4P3335ekqE9qluWj
5DlbtGghny+55BLz8MMPS1Mbm2gwBCb23ntvCUz79esnQe/AgQODx1XMnXfe
aY4++mgzcuRI8+WXX0qk0rRpU8nOQsPPP//cXHbZZQIw2VV84sGDB8uw+MU3
3XQTmd0A77nCCgnwJjaVoWARO612o9lxxx0nV35+flJIKKAPiCmd0xSEFHR/
Qzc80EOtYcOGRTQbPGfOHLPrrrt6Dt9ll11EfikkFsg4knJiaZQuXbqYJ598
MoA4W6I88gwUkEf58ccfzVFHHeVDsRkzZkg8goh88cUX8izoX9k0atRIGIkC
Fp9//nn5vGrVKmlLIVcxb948+plnnnlG6shy1apVS8FIAqE28XmbTz/91NSs
WROWcasvL7RWwhQ2PZ/Z9kmbeilY1QOcNGRlZQlatUCh3XffPermgoDz58+X
R7DsuHHj5DNoQb7AvqWCYuv++++XrLIWstEVK1Y0L7zwgltMzFx//fXmm2++
gVfg+JhbDxkDclAoRXJJbAHrsCi0s846yzRp0kRYjTJ16lTE2OnYrESI9LnS
6MQTTzRvv/02JPdnA5RG4SkDQqdBixRNiu4cF0mPnELpgd6DzWbNmuUxEiYG
7Edfy6pqJZjl3nvvhQaeNhBh/Pjx0qV58+ZR88QTT9iR2L2CNhSU9z777GP6
9++vtsWhOoSmrDBAYXIpX5HzQfFC2V69enmqhsXGA5ARBiAsLSWb4C0ukaok
JRJ2gEwAGYHs7GxR8hSyXmPHjpUVkoHnL3rJKn5lb+yaEurSSy8VXFE+++yz
OMqg9L/77ju2i1XLhQnGMDrrXnvtJTk6yoMPPijGjgMY4FvJUbduXYUgCXDa
xOtz5FahJDX37bffbkaywkC41q2idDOqRZGLXYsePXqIQe3QoYPUs3KOAyhC
8T3QGSQqly1bpn7GkiVLZM8EC0UZPny4eeWVV8x1111nXn/9daUYBoUjOWy/
Wg8m6F1VnJmqVavKTjAsDapvuOEGcWlBH2XEiBFmv/32Q22SYZUEG/rtoYce
kr4PPPAAcugMULVEQOPaTZw4UXgQMChoDJgMmxkmXQIckRDd0ktppki8+nLP
ERxoCROSzDJGrU6dOh4UPV9hEvxxravs6vr27atEdsnJDHGYYfFw33CdZgZR
mQ5nwRpvdGtOJ4OZokOtODr++ONNq1atBC7Ok1x11VViCzFqTz31FPrag7Ln
nnuqw+3XyRppx7fGrg4PlIy8HTOA864toHcaO+84RUovNd6EoIl0hTbYonBf
FKRmY6V1slC1JNMS21KKaHtJnf7Tqc3tJQX8T9P7fyUF/P+c3oPlHhMdyp78
999/L7qdsp+bJp2saoosMtgN9dVXX0kdF8ck8fel876uwT+QcQ1gy5IolaML
Ch/nqBR19ZKAsBXP0w5zE+ANKjjqf5Y4KH+PoXoOQ4QTOJhkQD766CMJdGwA
tIObCWQRKuCrwXfW8fY7ovhl+KIkV5YvX17JjUgEAlDgHpeWw5DWpGeHuJiR
SKHk5eXpmSPg4IgBMOJg4xxnuS5E93j8s2fPJgOaE4Lt66+/FpngEcH/zg4I
0q2kpxjOBmESCtkpskKgAwhphqVLl2o2implF4IfRsx1z0i9QlOQxKptkBQQ
Yac0iJei16gn2W2s4nnp7LPP1mQ1iRatzs/PVx+MeIKqatWq+eMmevKUy4Z6
mg9444035OBgRMAJ7qRlyJ3RQokJ/Nr9vPPO82eNbSTCiYNoNMoZcOlOZONS
CY6w2RKHHXLIIX4IzrSddNJJUC5Aie237777aszr0+OwWP/+/V3kELSz6zfT
pk1zOHPoz8+XSKlMmTJ+GZyCIncRtAjuVvvJMUpa6LxEKpyzK2iXZdq3by8w
KrwIjkVB0CULDJhwgbvsdIqBWrVq6clgj3/iRx3NBrEZrprIU6sfeeQR9Zhh
mXbt2qFmPV7JwdDces4+q0o868invOGfkbTTeq7Bgwf7FIWeD+SyUaSiB+FX
blD0kCAhIPUZt+ppiEGKAUdJiUF2ohjIzBzyhoF1xWAAZszIyPB16DdXnEnL
TpQJeej2Bnw/7FCDBg2AxdeRDFRG17EIAXUszvyS6+BQuFVSvh/hrMKgAkKW
x/Wzddwz5fAViKaQ4alfv35EOZcxYXidi42K+fPna5oVE08TfVwgT7Hw9MiV
ihmeAPqcPceogyAsH7BaxYoV3TCZccPT1065hUKi4T3bAeiqiJjkYHQSO+Fi
lZOfmVc3wqVTp05eWWheKSyyCUKiOHr11Vfj5MoKiB/GZSCkpdz1naNS2iqo
VEKCkpVUUFq1ahV1zPDSSy95PE6ePFlZFJ0eLyZZScVkwoQJyivsL7k9Uyl2
Ys/xJNd0OM1/kg1U3kHtU0izkzjRfppAKwAjJ04dciCWlDvmHYcCN6V169a+
P9lwyn/+85+IrpijjiRj2NW07pxWc4JSS7NmzYLqHHPXXXfJqhiZNA6zIpea
cf3www/9yNdee63fJPRGJhYnRJaGWk3CCHMKHD169NBqlIwOYsVIsRviaylW
lPwqrShthqUTTjjBYwmDjcuHMUcySV1a4+n6Z5shQ4b4cdFpEWfYLVWcEcoW
Zwp9xjN2HfmLAWbLPWhTOVHOZDx8NvBFHbtSKCbGIu9LupV69JjuUlZzrFyK
jnVJGaXcpLLGe2xsefNumzsMIG5G165dlX5sscXTL7mwWfpFGcs2UoHC0cZb
xq/S4fQUeAHqYubQQw+VoTIzMyGTakY4R2fp1auXOolEOVpt4Yw5nsLZ5kiq
Sh62T51BXmYoSI9nijTCb+h2inUwvVVxjrrnOQuFfcYSMoQ/EuWKnSgtXq4y
PFosi8X5gO6dCq8B2SbW1XBqgJKCZOmmKURktcq5NhrxaCahq1N169ZNvVoV
KsynNuVMQ8hEKjQQM1wssTw0KlM2EPO4ZDshXKyuss/Ykszwp3WMGrGqDp7t
ULg2C3y0KU4fqtRS2XvYKG1duM6UIFDqkhD4cC6G4yfWAVD7j8pCOReMkC07
PDoCu7Hdu3eXrUHrR3gSsa+aODOqFxbmsoQJEF5WbBBepQ7JW8qqKW2IkM1Y
jt2IDrTZqaee6vLxMYTE19vRleGT6Y6hQ4cqjJy8UBi1y+WXX+67oK0oKctI
TGyaLtlGpooJ9rp0ls6dOxcuHtnmoosu8k3RJZxkcXbFB3fJ7E3v3r0VMOJI
6AEeY3LP8PKftkikkeHcApGwPJJCLoDXol21d2ix57w6hI7+m1wArg6mOlC+
QXdUtnMT/K4c77vGx+AxCTJDBiXXzQQTY7I4XGSjMqUQe2UEWkTHOY7V+I5U
6Sht2rRJhd9tU52FHEAiv7MNrV1wIBP4HYVSHH7XxBr+K9vRVjjxjjRI0wNI
lBCTByTNkWMLxG1Uc6iAQrIg4uI5zikpwMl43QZyOQ4o6+CWDF+nmCvdgnhl
wIABytO6eOtUFBmvWGdRg1eSJxys4NziwoULc4pi5bJCD63Ga8UNYmOfcxSW
0XTx8BxnD0mWoeoqVKiQVKOr4KCqyTRx4MYG9pmO3CSKKbxIFXE+kXX7ovCB
fYwHqPLB0UqKdXuV50hzhcvy5cstEBMnTrRAuA3WLfGKbCjv18AbYroGxTMR
nqJGkyIhCeDsVrj06dMnqQSoMkBk0S8FCb5siQj1hVdKWM+rDteX6rn06KGt
00WG0jWB3xpAoBJQYHoz5W1sBE4vUmjJIJb7tu0JderUSVW8vvTHZXFblJRY
/0TRxrEj9bDHjh0bNVdeeaXLmioaCvGLdF71cIn5rJxpNe6mHUteQrZSo9l5
Uin8+AaX1fPaGs2qY1vDrElReMWJvuOVTDkuAy9oOfPMMz2n4yprsf6xhq2a
BkJ6OYHBLMhXkMAK8MRZ3UQu96ahEBkqiNg562BHDqrLabJaCr61em/YVs3T
hUQIi61HjSkWFs+QhODxlAhOUpxxxhkhtGTI3gYmwZLA5743F6Mc7SeXvsPJ
qSQN1QN0mkJNyfjx4xXsgw8+2ISL1Use7BAG0pejFHcxi5Sj7Dg54uI9aV6l
sK61Z6iwcrOSpKtTQQoymUFTLAgOPARr0KCBNtUw1fydJOXIT40oa2ICCFg4
iKb5U/vcadFs8+uvv/ohyI8hQBgg+9nTgF26RNbhhXAXO3jI8ZjZ0sFSWrqp
Y81WnU5duXJlSVqR7SxIbMfCq0N1ht01XHiLUt+UhALWif0n62hpteU3CatI
/xSSChMHLqhmYHIOpPs8kmNhxw25UheAtBEKDnMTdZs7Ca69ZsE43BdmBnKN
vApNtp1Iu+AHgHIlWwHIHNmlLRkOvqM0ESXNtiPWVlRVmjQBAnk1/ektVcwL
GOW0005TYGEKzoi2aNEiEq6LE650cs5b30hZyYg5lYGxGDRoUFimPIOoUFEs
+bPcYtlcdGlOv2tcSDzCBrczRz4eAdvEKSbkgsBcrrtvxwFb98qPmyb++APp
LOtdBq8A2fbYtwKWCu5Ii+4rhl/t4VemwroaQaM0bdrUmzW3oRJelh8D68Ie
aMEYmcJNYZth2d7zB8h3v4jlYePorDvH7denCocLcbXBuMcRhwYUR7qdwm8d
od5CNsG7Z2EB4sWCOO7OjONuOI6zy4oOIhp3bD5gyxJP7aYRkuTEsTLnEpBG
MMeherwrfipPk0S87IUq5crLy9PoAsTjafLyEyqMvT7eV+HAgWU6jVr5vQXt
3bdvX82oAyspCvBEb1iBiaZOnepQkC0ohzy0wS6jqPGS1qxZ44Ni/fUhLsu+
moL54IMPRJVx2ehQCYqYEj+hRBmV16qsJsxyj+EDTrWS38KZ47cjJHUUrBh9
GHY1SCWxYhAoiAm26Tjr64rfsMX0IfT8Fgmbfccee6zo/A0bNjg8l5NNADZQ
uYCf88K8ecUPHbB88nqWm3XlumGOk2TxHaw8V2SeVYNUNDKMAZBui1EUOd85
j2DlOgA605+t10LkpQvipSXH+k4cy8fxPoW0MwCSSWSniOCQsJyMrDTQn24o
RXWuQ8GCHKjRi2SYutHsFIWfqY9nBcSrHt2fMyFtTY4Py89lNXkVV63ngbls
E/21SfZ7lGvYk0cp6UYsiVb2QPS5ldjITm64pCmfzWap6arD8b5lOJXfsIiE
3k8KO9Jq+JI5x7XSIFyK54XKueGRRdXXZR0xcGKKQ6CEGFEJlGCOAgKVFYyG
LQeRAykJkGRnDB/ucb9zFqlRNI0SJgpolC1+V/jsAD/oiMxY8XQmKVAW4VIa
lErxSEvpUaqOm4mXPNGIYd8DsoAQWqjo4Hnx4jbXsGHDCiGLogz751xc7z3h
3LvMoo8+yZExYvfu3UtXaIq29vpKCccL4R57WTJwz/Bp2CFD+CFOG6nYutB7
4J4MvPKKSeKygYuSAfWk1bZJXScwWH9yvqRDOGeAK4Y1JRdihalm8t57OSkA
dqIQslY4fQRM5L9gsOquK3Lm1iI5k5Lg8O3oxxDSmjfdE+gr3Eyl92t2UrnS
TVu6L+1Jg2S/Lq7vnSX7dXF9luyXvVNM7ciSpMlsE3H//aOQt7yS/da4Pivp
3xqX8u//BSgJa5kCpNscPkt80H//D8i//wfkX3nfZvFZevIev/SQbPzPLL10
5T05PkuclRyB/gkot3NZ3ypUj//3a2F8BpWRlP/9WsF/rsuVaTOKa7qDWbgV
/7/OpdZHi/7sQpg3N+8TUYTITbbQA8c6NJL7J4CRMv8HEvXnxg==\
\>"], "Picture",
 ImageSize->{533, 142},
 CellID->714984167],

Cell["Here are the expressions that correspond to these cells.", "MathCaption",
 CellID->32718],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{567, 110},
 ImageMargins->0,
 CellID->877982436],

Cell[TextData[{
 "A particular style such as ",
 Cell[BoxData["\"\<Section\>\""], "InlineFormula"],
 " or ",
 Cell[BoxData["\"\<Text\>\""], "InlineFormula"],
 " defines various settings for the options associated with a cell. You can \
override these settings by explicitly setting options within a specific cell. \
"
}], "Text",
 CellID->31063],

Cell["\<\
Here is the expression for a cell in which options are set to use a gray \
background and to put a frame around the cell. \
\>", "MathCaption",
 CellID->7229],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 81},
 ImageMargins->0,
 CellID->1795334606],

Cell["This is how the cell looks in a notebook. ", "MathCaption",
 CellID->18864],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 68},
 ImageMargins->0,
 CellID->311453356],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["default value", "TableHeader"], ""},
   {
    ButtonBox["CellFrame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellFrame"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to draw a frame around the cell", "TableText"]},
   {
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what color to draw the background for the cell", "TableText"]},
   {
    ButtonBox["Editable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Editable"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to allow the contents of the cell to be edited", "TableText"]},
   {
    ButtonBox["TextAlignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TextAlignment"], 
    ButtonBox["Left",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Left"], Cell[
    "how to align text in the cell", "TableText"]},
   {
    ButtonBox["FontSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FontSize"], "12", Cell[
    "the point size of the font for text", "TableText"]},
   {
    ButtonBox["CellTags",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellTags"], 
    RowBox[{"{", "}"}], Cell[
    "tags to be associated with the cell", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.5, 1, 0.5}, "RowsIndexed" -> {}}},
 CellID->30470],

Cell["A few of the large number of possible options for cells. ", "Caption",
 CellID->15005],

Cell[TextData[{
 "The standard notebook front end for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides several ways to change the options of a cell. In simple cases, \
such as changing the size or color of text, there will often be a specific \
menu item for the purpose. But in general you can use the ",
 StyleBox["option inspector",
  FontSlant->"Italic"],
 " that is built into the front end. This is typically accessed using the ",
 StyleBox["Option Inspector", "SR"],
 " menu item in the ",
 StyleBox["Format", "SR"],
 " menu. "
}], "Text",
 CellID->21047],

Cell[BoxData[GridBox[{
   {Cell["\<\
\[FilledSmallSquare] Change settings for specific options with menus.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Look at and modify all options with the option \
inspector.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Edit the textual form of the expression corresponding to \
the cell.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Change the settings for all cells with a particular \
style.\
\>", "TableText"]}
  }]], "DefinitionBox1Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Rows" -> {False, False, False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{"Rows" -> {0.5, 0.5, 0.5, 1}, "RowsIndexed" -> {}}},
 CellID->1594],

Cell["Ways to manipulate cells in the front end.", "Caption",
 CellID->21487],

Cell[TextData[{
 "Sometimes you will want just to change the options associated with a \
specific cell. But often you may want to change the options associated with \
all cells in your notebook that have a particular style. You can do this by \
using the ",
 StyleBox[ButtonBox["Edit Stylesheet",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/EditStylesheet"], "MenuName"],
 " command in the front end to create a custom stylesheet associated with \
your notebook. Then use the controls in the stylesheet to create a cell \
corresponding to the style you want to change and modify the options for that \
cell."
}], "Text",
 CellID->24326],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CellPrint",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CellPrint"], "[", 
     ButtonBox["Cell",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cell"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]", "]"}], Cell[
    "insert a cell into your currently selected notebook", "TableText"]},
   {
    RowBox[{
     ButtonBox["CellPrint",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CellPrint"], "[", "{", 
     ButtonBox["Cell",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cell"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]", ",", 
     ButtonBox["Cell",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cell"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell["\<\
insert a sequence of cells into your currently selected notebook\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->3276],

Cell["Inserting cells into a notebook. ", "Caption",
 CellID->21323],

Cell["This inserts a section cell into the current notebook. ", "MathCaption",
 CellID->6540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{"\"\<The heading\>\"", ",", "\"\<Section\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->7679],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 91},
 ImageMargins->0,
 CellID->1287301016]
}, Open  ]],

Cell["This inserts a text cell with a frame around it. ", "MathCaption",
 CellID->32588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{"\"\<Some text\>\"", ",", "\"\<Text\>\"", ",", 
    RowBox[{"CellFrame", "->", "True"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->24710],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 126},
 CellID->957844377]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CellPrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellPrint"]], "InlineFormula"],
 " allows you to take a raw ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " expression and insert it into your current notebook. The cell created by \
",
 Cell[BoxData[
  ButtonBox["CellPrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellPrint"]], "InlineFormula"],
 " is grouped with the input and will be overwritten if the input is \
re-evaluated."
}], "Text",
 CellID->17945],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->117671157],

Cell[TextData[ButtonBox["Manipulating Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksOverview"]], "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cells as Mathematica Expressions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Manipulating Notebooks", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingNotebooksOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/NotebooksAsMathematicaExpressions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 8.6392124}", "context" -> "", 
    "keywords" -> {
     "appending", "Background", "Cell", "CellFrame", "CellPrint", "cells", 
      "CellTags", "control", "Editable", "edit stylesheet menu item", 
      "edit style sheet menu item", "expression form", "expressions", 
      "FontSize", "front end", "global style changes", "input style", 
      "inserting cells", "inspector", "Notebook", "notebook option inspector",
       "Notebooks", "option inspector", "Options", "output", "output style", 
      "printing", "raw cell", "raw form", "section style", 
      "show expression menu item", "StylePrint", "styles", "stylesheets", 
      "subsection style", "Table", "TextAlignment", "TextStyle", 
      "title style", "Toggle", "underlying expression", "Unformatting"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Like other objects in Mathematica, the cells in a notebook, and in fact \
the whole notebook itself, are all ultimately represented as Mathematica \
expressions. With the standard notebook front end, you can use the command \
Show Expression to see the text of the Mathematica expression that \
corresponds to any particular cell. Handling Cell expressions in the notebook \
front end. Here is a cell displayed in its usual way in the front end.", 
    "synonyms" -> {"2.11.1"}, "title" -> "Cells as Mathematica Expressions", 
    "type" -> "Tutorial", "uri" -> 
    "tutorial/CellsAsMathematicaExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.11.1"->{
  Cell[2045, 62, 154, 7, 70, "Title",
   CellTags->{"S2.11.1", "1.1"},
   CellID->24199]},
 "1.1"->{
  Cell[2045, 62, 154, 7, 70, "Title",
   CellTags->{"S2.11.1", "1.1"},
   CellID->24199]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.11.1", 58440, 1231},
 {"1.1", 58541, 1235}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1420, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2045, 62, 154, 7, 70, "Title",
 CellTags->{"S2.11.1", "1.1"},
 CellID->24199],
Cell[2202, 71, 618, 18, 70, "Text",
 CellID->29105],
Cell[2823, 91, 909, 28, 70, "DefinitionBox",
 CellID->24791],
Cell[3735, 121, 215, 8, 70, "Caption",
 CellID->18661],
Cell[3953, 131, 99, 2, 70, "MathCaption",
 CellID->8681],
Cell[4055, 135, 2367, 41, 70, "Picture",
 CellID->1638759295],
Cell[6425, 178, 171, 6, 70, "MathCaption",
 CellID->8753],
Cell[6599, 186, 3647, 62, 70, "Picture",
 CellID->911750343],
Cell[10249, 250, 1121, 33, 70, "DefinitionBox",
 CellID->32029],
Cell[11373, 285, 149, 5, 70, "Caption",
 CellID->15987],
Cell[11525, 292, 332, 8, 70, "Text",
 CellID->7042],
Cell[11860, 302, 586, 16, 70, "DefinitionBox",
 CellID->26253],
Cell[12449, 320, 82, 1, 70, "Caption",
 CellID->20083],
Cell[12534, 323, 82, 1, 70, "MathCaption",
 CellID->11420],
Cell[12619, 326, 9429, 156, 70, "Picture",
 CellID->714984167],
Cell[22051, 484, 95, 1, 70, "MathCaption",
 CellID->32718],
Cell[22149, 487, 9224, 154, 70, "Picture",
 CellID->877982436],
Cell[31376, 643, 345, 9, 70, "Text",
 CellID->31063],
Cell[31724, 654, 168, 4, 70, "MathCaption",
 CellID->7229],
Cell[31895, 660, 7048, 118, 70, "Picture",
 CellID->1795334606],
Cell[38946, 780, 81, 1, 70, "MathCaption",
 CellID->18864],
Cell[39030, 783, 2431, 42, 70, "Picture",
 CellID->311453356],
Cell[41464, 827, 1847, 54, 70, "DefinitionBox3Col",
 CellID->30470],
Cell[43314, 883, 92, 1, 70, "Caption",
 CellID->15005],
Cell[43409, 886, 577, 15, 70, "Text",
 CellID->21047],
Cell[43989, 903, 710, 21, 70, "DefinitionBox1Col",
 CellID->1594],
Cell[44702, 926, 77, 1, 70, "Caption",
 CellID->21487],
Cell[44782, 929, 648, 13, 70, "Text",
 CellID->24326],
Cell[45433, 944, 947, 28, 70, "DefinitionBox",
 CellID->3276],
Cell[46383, 974, 68, 1, 70, "Caption",
 CellID->21323],
Cell[46454, 977, 93, 1, 70, "MathCaption",
 CellID->6540],
Cell[CellGroupData[{
Cell[46572, 982, 191, 6, 70, "Input",
 CellID->7679],
Cell[46766, 990, 3042, 52, 70, "Picture",
 CellID->1287301016]
}, Open  ]],
Cell[49823, 1045, 88, 1, 70, "MathCaption",
 CellID->32588],
Cell[CellGroupData[{
Cell[49936, 1050, 231, 6, 70, "Input",
 CellID->24710],
Cell[50170, 1058, 4387, 74, 70, "Picture",
 CellID->957844377]
}, Open  ]],
Cell[54572, 1135, 594, 19, 70, "Text",
 CellID->17945],
Cell[CellGroupData[{
Cell[55191, 1158, 72, 1, 70, "RelatedTutorialsSection",
 CellID->117671157],
Cell[55266, 1161, 175, 4, 70, "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],
Cell[55468, 1169, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

