(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    115802,       3260]
NotebookOptionsPosition[    104669,       2879]
NotebookOutlinePosition[    107293,       2947]
CellTagsIndexPosition[    107198,       2941]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Operations on Data" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalOperationsOnDataOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Operations on Data\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"All" :> Documentation`HelpLookup["paclet:ref/All"], 
          "Automatic" :> Documentation`HelpLookup["paclet:ref/Automatic"], 
          "CellularAutomaton" :> 
          Documentation`HelpLookup["paclet:ref/CellularAutomaton"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"All\"\>", 2->"\<\"Automatic\"\>", 
       3->"\<\"CellularAutomaton\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Cellular Automata", "Title",
 CellTags->{"S3.8.6", "6.1"},
 CellID->29033],

Cell["\<\
Cellular automata provide a convenient way to represent many kinds of systems \
in which the values of cells in an array are updated in discrete steps \
according to a local rule. \
\>", "Text",
 CellID->2088],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CellularAutomaton",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CellularAutomaton"], "[", 
     StyleBox["rnum", "TI"], ",", 
     StyleBox["init", "TI"], ",", 
     StyleBox["t", "TI"], "]"}], Cell[TextData[{
     "evolve rule ",
     Cell[BoxData[
      StyleBox["rnum", "TI"]], "InlineFormula"],
     " from ",
     Cell[BoxData[
      StyleBox["init", "TI"]], "InlineFormula"],
     " for ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " steps"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->12935],

Cell["Generating a cellular automaton evolution. ", "Caption",
 CellID->19779],

Cell["\<\
This starts with the list given, then evolves rule 30 for four steps. \
\>", "MathCaption",
 CellID->15993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellularAutomaton", "[", 
  RowBox[{"30", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->14790],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0"}],
     "}"}]}], "}"}]], "Output",
 ImageSize->{431, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->42922855]
}, Open  ]],

Cell["\<\
This shows 100 steps of rule 30 evolution from random initial conditions. \
\>", "MathCaption",
 CellID->18965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"30", ",", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{"1", ",", "250"}], "]"}], ",", "100"}], "]"}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->11001],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJxtlEmWJUdyBM15E16JR+j3uO77c0UAnSYiFlkJVA7xw21QFfX//te//+df
/zUz//vXv//76997b/767/396z8/3j+///3H+MfP87evjIf++fr75f+UmD31
c/Q/B34e/acsD34O/px7vw//NE97RuD9aS/K/Uy1o+2Q/LcLuxwKUHoL7HjP
+Wm+4/4cPXV2PRb1wZyF/nCYB5VgnPxtT8vs8NeGleU5OqPEIsz+2OoYCvM6
LtZTZ53baZCwpE3M4bB7romYuaWAaDe03DDvOKR7Fytlc8NjqyyL14721hes
V7yAHga3yCH+wGxJRBSeE6GIv+XMntlwa4ud5ZLWY+t0jKQoxEuq4gX0RrpB
/mZk92kBiDC3k2BMNyDInFo5Mnr2fV0Uq6JYQiZeiWdJvRw05vfBdpt7+LG4
UyXc953LSoOsZCfhoUallyLO3WT9AS/NOKROJ2fZ6YP+8TmcxWMGylTnOL82
0BAgDulqLZryaypvsn7hhazF/Hw6DvTug9XtN+bTL/dRBRNS57e5gqb7dPQD
PHw0oFHsz3hB4sG8n7Lf8TMtP6PP5LTyv00lUh8D+AkUyZwJiUdJ2zFW169G
rTZcEXsSD/aj7Y8e6+djrVP1wXw3k+CGHtgmP4HiZG7/jEfvrFFjmV69Ut3I
i1Iw/5mKTSSaPCNNqy6NBmgjvXmI1MPI/blOncw9JzwKuIaO6zp6aWMeFyUW
nn27uaqfy1lekG13AnHDZOiFrT+luUBkwsxs9I7jovA+s/LYZK6xn0+bK4hm
+vIQtnVMxM37vhsF+GkmiUQDg0DZFSQYsShALhPgds6ho5/G7qSQ6eVUh9rS
/RxftFZq2PcCaCQaGBgfSoKheKADnOf1ysg58gALqlqi9+9yOpVgb4gl8WX8
5/jX+Wx7IpHAIBTOGF/xUIexpdFnh9C3q4BQ7S7Rbyee78zqhAgN6EHrOE+E
5PMbGIVqSqWo2B35fD0KLQoZOGzHbkGkkhbRYo8ajSUreLzW9OD0Q/fkO0JR
edUMM2EWn986YKo4V2PDNp9W/FSK1sw5vSGQwTSIVpzH+zUK2f1OBBvuE//s
KXACmPfENybodj6t+EIcrR3ev8ySC7WATZN6dVtU+O4CEVaUpnsen5fg+Yxw
dk0q+mnFd4Kx55EP87a9wxMjZ5pOYCBBxe8y5KSZYudbZXZGCb47fHZNiAT0
iL9HnXo6vH/ZXpQnQ52po+6KFJSeB5IKRDc5CzNJS7Tms0NvAHSf108/4u/4
7XlysWIa9I82pPRUiKjjlI42t9Q2JIvJxGPEQ7DvfG4AdX/nU2V/Cvpuzwy/
4Ni+2sjYmRql3QyvJwcqLF1NTl5pVF1rXLhkaPX5FAIxA+UDSoxGH/kHuVpn
7tBKkfT6+ccV9oRorJ8RL8EQ/rVGbW5uWvHRwZ53ePU5eeQGi4pO8OKHCxXa
RClhX9swwAg5klI58MeaMGcm5lTk0RryHR59wv/GdSkZprLudH71PjfDR1j4
OEmdiLAF0NUEHGsOczsYikx+o8cdfhfmh8uYoFAwTgqM9G6uMvZd2RC9bHZE
HttQrGS8q80uCKTRRsC9+E41fqTS7IgmkFgB2PSEuL6M3ZUJEYZaeVxXejKd
8H61EdFVJLXTTSe6Lmwg1aMR/fdxADsnBONGyfKz1jhkQ6gqbOM59cX7sWMh
DRL+lOxWG/cz0idzaiDjM/dEwWiURA5vKCI/qiqb07rCGwu2yv6/Jmun7P9h
nnG/7fpOoxcNNmlG3ZjTOGQVubPPa2VU3dEMXCp4LsFe7aKLU8bWX/Mo0nJE
shx1TadBoi6GaXwc9+G4z7RyVJXNJib6SjXlVj6s6L2xKf09j4ciIqOaK7Ml
WdM5aTyd2GnUmnCfmAjOCdyWO+eChJDEvOmMYafzMGtuB1s6abN1rDrbr/np
EvInw5BYRMnZd7a4+ubHiQqxP7ab0t/zrPHh0EJM2iAeq872EC39uEKlXhtH
lJzlHFeB58r3dFDNK/378DOPLfWgLbGWIGr8u3NyWt0fg71UwrUvzp4lcIR6
B7d3Tvhm2+/IUvwmvTR++T8t11qD+GoVMs86GEC2cdQWKHLFxz3rs3hn79gf
mbZ8MEmw6H18YKndkPuBeKx6i0eWTV6eR2lMYhvglb9mYM/Ls8hFj2N/39xE
jmWlGJjjgxeF8b8UP4p9rMpwUUTrDMgn7DukZrhpgWGfR4+P/ewhGWFOip9L
EnXRYo8vxRd80uWYg/m1Dl/tVCpiRgA+wLAPon/t3z1KhrGUYjNFWItWA3wo
ViZdkzkVyb6QJVsJVw02fyhuwpBpu9T+fMbULnwoptrxAcEzfB2PTNiTVKnI
2de7ox8Zz+sUdJVUvTcGMJ3kRE1YDaXKPXl80HLClaIJzl43VfPyRjYE435k
PKGNuW4+BA8XfPsmJ2o+lHinO1qxteU7YaM83+HXari+QiYC4cgU99ogw9vI
idhuJy/6LwWOmkx+KE61VbaLxlhAOwnODZHAITFCNj7v90c9QCppFFRkZ5Ew
SS2gmsx0KKYadH5UOPr4boFx2VcJrpCNz/z+KAc2aWkEKuIt1k1SXlJNQGW9
dFo6tTm5F13fjeMuy9CSSSdHVJjvAsv5OmujXWFjT3vZVNjXL4UkJO90Wmmi
wgfo5Syf7iRBEsBSgrvFtdWYtxk6qbQRvCNY6FONH3P8UkhOTDoRGrkxSwv0
exGguF4kn9vSqel87lcxn0PrbBrB+3sZEVFO99f/t2xCgrYuCDfja0Njpzq4
WvhZz5coC4+8dXv8CBhn22hl4EIw1UaUZBNMPklIoq2J1XdeQ1I4M8dvUng1
Kre5YvZPu24VqWas3434YIUNtjTVyA0d4W1IZFV2mQB6kNRggstatQe+gCWf
7Oq0IXR/c7tPI6Uc+2wFkXDTQXoKJCQSkaVPd5SXMyQryWgzdq3k3RUNezsV
jqQn18ttj2YpSLQhCCx/hQQiKubpvkYfZROGQIHbjr7W3F1/3QYY/6LUwWYd
ToZMtRJrJJSQDNnzNghr89QqewUQLXdQaKZiCNG9GHE3/MAxWc+gtCO/Okqj
3cAhf8PIMPFSrZA8NBfADDqnZG4UI3N2DZTQXDhcr0F553ybAhWmSInySwU+
HS9/JbU0xzMWBBnc2ZonMt21Gwon80XtBGVyPof0tRlmjibDMEaTz2XSpH4A
yTepOiWFLJE5bh6n3f5kbxxtxTDaDnOuBE1xjiTjnVE+ZPuh2RQQnVzHV5t6
QMjXndWFCIh/Rk8tOfGNxwI7rPqsGbkomCOxPKN8yN6S2ZcPtaWOB67iElN5
h5kExHC0lpxoCCFyHgqZO9GKiD7Wyo4KJHHyfKgtx3FNKS74Ai4708U/nKNf
Obl50M1kwxwk8Ewbybr6c5737n7Sa6DY4QzLfVBclAN3GT3MkUJpdYBH6f3V
K4KkU6AHMu3cxxb2fqhuHA50IfQ5SQIU4535XCdcOwG6V8dCcfwXxyabpBeZ
m9gE6t3F68W7ui2pBzoJdZKd+GN85HD6/fYBupKvR8lZ7Aid+0IyKDD5yEHv
l16E3jT+QLfDMcmGQHGZNMRSrHqVq1wRCfPNww6Sf6vEqn0TW4LV48wK8rjB
4Qsd18ljTULGfvDezMz5doE2tJqMoOLImDzSEp5Pzjb50RJuOUeAezhgMkC8
3REqtg4ErHxzPvHQthPmkwfH7DvyiGbKmUGjpSTttgaS4ZLdDBBv8x5lo+eC
tUnkBqj6Cv8YpVG7kwQjEBKHe9ZXhNMm7hVgxcXgMy+BakqFi4UCFvdFxArI
z7Er6B/zEIwkjQSes76SEUH2l9qf4XYoByBQmerAtXP6m0tUrDt90nWj9tJO
6gFUrSXrk/yOuGb3+vnlZCDPAOgRxQ5cO+cW8KOPWMNo/jfRD2h2C+8SAdXW
kPVNfkdMfivSp/Fa5wDqcRRjJWKDa36EpQSoNY0AwpOHH7f68IQ863BxNPlh
5uQ3IuVWOJA3ibymYqwEEkATNIaK1G5Ncbl5EOSGZCrB4x24WME6XNDU4jop
2Cy4mmaUxYnbYjKv0AQNLExta6JjHN9KLTDZK1NH2Jt8hztoXpG8FbaZCtwL
xLGc/eTXhdYqtToBSghzPyyjynrvkmPZ1uv0CGaEDpofkeCUZiqwaOn6dd7Q
QPexipzdADWE9AujTH4MW8sQTGHftiA1VXRsH5GGvR6z57W1M6i4jTkL3Tv/
OWKAWGJuP+ZNCK5hxE0xkw3xa+aC5rXYXG12kjJhTwoeBrMAyYDKpzDaZrxP
IOkXRhvtOufrbrDFTQ51IPrd1XQNC81rlk42oIVpy41U8tLJWd7Zp0l1Gc16
17mkbYfAQjh8nzVxBnNJHrwmr3h2svGWqrOhzOkX41Cm7+TpyXjcuIZBTIzf
BiicnBwWSI6R24VNFDH84wWyYZqzYZlbjYgd+iD5fZqMexNExPf5BeN3iFTN
VLBAajUgP5IoY6jNlyz+csP0IYzEDn3W3c/Tk3C6FyUdhECHQICAkIhCvQYk
eVqYGObYhyyUKtSuN7ysfPsK14tPT8LtXpR0sMYfTy4IRpTHgx9NXizkKsix
D1lRSne1HwNQhijlZvBpSd/3djtBOdCuR3MFuFNJcA5Esl8Wlldbi27/0t0A
rpWRbxu/z9MFU3K6nSwV2ufJ+He02ZeD4xwFDkubD4o8+wbdo5QZE3CUjtk2
vqL+7MrzON9QF1q5/PjXQJubTKP4ZYlUGMOsUHSjVDKWa0bDNdvGirr7nueY
lFCntDL88u9oc3RtqzRYFdafxNDxi66pM2ORwKm9DYhdDYHq8xyTtNOgHRkG
wRVltbm6tlUbPB5+YyizRXe+h/YYNijCfnCzMxRDnXFwZ7b6QY+3Zsep7Ggc
XSW7DSjxO4Ywe9D9fSj8Q9eqQVmrErjGJYOrZlnIj8TcLUO/uuoJgUuDn322
+D0rGOvQHw4VhTCOKq+rW7BxOYOfOF6WT/HJ2UM/qCi9gZPin2kRmbOCutiQ
yWXnRQVfq29xvK2haZ9ncM9N/jyInMNXdmhZErNHjkKwXD8ncGy2FA0gR4XQ
NWner1OQUH4Hh89KJ6hrmTWP7CxCxKfvChs+uZzpuwObJjCKCr6W0HIVmLvw
nYsggyv7Cfhj8snvkR0pYYuDfddnSOlyldkFTRMYkZjmK6GlhY8P97kIHBzZ
Q96ohcT4J+h2EX0/79qKV1iuMpshIxSMgL86kCxa5FRWR5sOHtlD3mv7Xi2V
XRwL+/fdtCJeZU610v2jaBJTHUjWtpDUu3qdX5Uqu3DMbe+dsLIX3C5dL3t0
lxW6qPvYbrtfNFhufDON0KKk9uvmVuVuep+Nba/BBMKPEysz2aO02lWDmgdl
54vGz5msK0sKarpY6Y3zgjDzcSOEkPm2xxYtyseKHIuHzsK6K+hLD/r4oKEL
7uWUCqod3hni5cdNxnX8hIsCwwzj85s2vGTRY8fKFPnPwRJYNDyTLQuN+K1n
evpy6s3/A6FNNKQ=
   "], {{0, 0}, {250, 101}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->116416598]
}, Open  ]],

Cell["\<\
This starts with the list given, then evolves rule 30 for four steps. \
\>", "MathCaption",
 CellID->13827538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellularAutomaton", "[", 
  RowBox[{"30", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->294948713],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0"}],
     "}"}]}], "}"}]], "Output",
 ImageSize->{431, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->262285699]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["a", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[TextData[{
     "explicit list of values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"{", "{", 
     SubscriptBox[
      StyleBox["a", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["b", "TI"], "}"}], Cell[TextData[{
     "values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " superimposed on a ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     " background"
    }], "TableText"]},
   {
    RowBox[{"{", "{", 
     SubscriptBox[
      StyleBox["a", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["blist", "TI"], "}"}], Cell[TextData[{
     "values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " superimposed on a background of repetitions of ",
     Cell[BoxData[
      StyleBox["blist", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["a", "TI"], 
             StyleBox["11", "TR"]], ",", 
            SubscriptBox[
             StyleBox["a", "TI"], 
             StyleBox["12", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
          RowBox[{"{", 
           SubscriptBox[
            StyleBox["d", "TI"], 
            StyleBox["1", "TR"]], "}"}]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["blist", "TI"]}], "}"}], Cell[TextData[{
     "values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["ij", "TI"]]], "InlineFormula"],
     " at offsets ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["d", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11807],

Cell["\<\
Ways of specifying initial conditions for one\[Hyphen]dimensional cellular \
automata. \
\>", "Caption",
 CellID->24567],

Cell[TextData[{
 "If you give an explicit list of initial values, ",
 Cell[BoxData[
  ButtonBox["CellularAutomaton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFormula"],
 " will take the elements in this list to correspond to all the cells in the \
system, arranged cyclically. "
}], "Text",
 CellID->2669],

Cell["\<\
The right neighbor of the cell at the end is the cell at the beginning. \
\>", "MathCaption",
 CellID->3134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellularAutomaton", "[", 
  RowBox[{"30", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->32671],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->97936752]
}, Open  ]],

Cell[TextData[{
 "It is often convenient to set up initial conditions in which there is a \
small \[OpenCurlyDoubleQuote]seed\[CloseCurlyDoubleQuote] region, \
superimposed on a constant \[OpenCurlyDoubleQuote]background\
\[CloseCurlyDoubleQuote]. By default, ",
 Cell[BoxData[
  ButtonBox["CellularAutomaton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFormula"],
 " automatically fills in enough background to cover the size of the pattern \
that can be produced in the number of steps of evolution you specify. "
}], "Text",
 CellID->12998],

Cell["\<\
This shows rule 30 evolving from an initial condition containing a single \
black cell. \
\>", "MathCaption",
 CellID->3545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"30", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "100"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->13597],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzdl2uWrDYMhK3sJFvKEu45+Z11Zle5DKjqkxswM/0A4tMzzcPYqiqVRP/5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   "], {{0, 0}, {201, 101}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->7553989]
}, Open  ]],

Cell[TextData[{
 "This shows rule 30 evolving from an initial condition consisting of a ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "1"}], "}"}]], "InlineFormula"],
 " seed on a background of repeated ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "0", ",", "1", ",", "1"}], "}"}]], "InlineFormula"],
 " blocks. "
}], "MathCaption",
 CellID->8838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"30", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "1", ",", "1"}], "}"}]}], "}"}], ",", 
    "100"}], "]"}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->14844],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzNlG2S20YQQ7tzk1wpR3BVfuc4uW681gAPTX1SIVd2rdZcajiDBh74549/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   "], {{0, 0}, {151, 101}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->350423843]
}, Open  ]],

Cell["\<\
Particularly in studying interactions between structures, you may sometimes \
want to specify initial conditions for cellular automata in which certain \
blocks are placed at particular offsets. \
\>", "Text",
 CellID->8563],

Cell[TextData[{
 "This sets up an initial condition with black cells at offsets ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[PlusMinus]", "40"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->21028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"30", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "1", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"-", "40"}], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "1", "}"}], ",", 
          RowBox[{"{", "40", "}"}]}], "}"}]}], "}"}], ",", "0"}], "}"}], ",", 
    "100"}], "]"}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->29264],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzdWFuS2zYQnMkt8pkr5Qiuynfu/5f1iv0YkAQfggg7qPWaIqHGTHdPS7V/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   "], {{0, 0}, {281, 101}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->330192129]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    StyleBox["n", "TI"], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"k", "=", "2"}], TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox[
       RowBox[{"r", "=", "1"}], TraditionalForm]], "InlineMath"],
     ", elementary rule"
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["n", "TI"], ",", 
     StyleBox["k", "TI"], "}"}], Cell[TextData[{
     "general nearest\[Hyphen]neighbor rule with ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " colors"
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["n", "TI"], ",", 
     StyleBox["k", "TI"], ",", 
     StyleBox["r", "TI"], "}"}], Cell[TextData[{
     "general rule with ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " colors and range ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["n", "TI"], ",", "{", 
     StyleBox["k", "TI"], ",", "1", "}", "}"}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     "\[Hyphen]color nearest\[Hyphen]neighbor totalistic rule"
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["n", "TI"], ",", "{", 
     StyleBox["k", "TI"], ",", "1", "}", ",", 
     StyleBox["r", "TI"], "}"}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     "\[Hyphen]color range ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " totalistic rule"
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["n", "TI"], ",", "{", 
     StyleBox["k", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["wt", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["wt", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "}", ",", 
     StyleBox["r", "TI"], "}"}], Cell[TextData[{
     "rule in which neighbor ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " is assigned weight ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["wt", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"{", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["kspec", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         SubscriptBox[
          StyleBox["off", "TI"], 
          StyleBox["1", "TR"]], "}"}], ",", 
        RowBox[{"{", 
         SubscriptBox[
          StyleBox["off", "TI"], 
          StyleBox["2", "TR"]], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        RowBox[{"{", 
         SubscriptBox[
          StyleBox["off", "TI"], 
          StyleBox["s", "TI"]], "}"}]}], "}"}]}], "}"}], Cell[
    "rule with neighbors at specified offsets", "TableText"]},
   {
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["lhs", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["rhs", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["lhs", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["rhs", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "explicit replacements for lists of neighbors ", "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["fun", "TI"], ",", "{", "}", ",", 
     StyleBox["rspec", "TI"], "}"}], Cell[TextData[{
     "rule obtained by applying function ",
     Cell[BoxData[
      StyleBox["fun", "TI"]], "InlineFormula"],
     " to each neighbor list"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14723],

Cell["\<\
Specifying rules for one\[Hyphen]dimensional cellular automata. \
\>", "Caption",
 CellID->13490],

Cell[TextData[{
 "In the simplest cases, a cellular automaton allows ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " possible values or \[OpenCurlyDoubleQuote]colors\[CloseCurlyDoubleQuote] \
for each cell, and has rules that involve up to ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " neighbors on each side. The digits of the \[OpenCurlyDoubleQuote]rule \
number\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " then specify what the color of a new cell should be for each possible \
configuration of the neighborhood."
}], "Text",
 CellID->7604],

Cell["This evolves a single neighborhood for 1 step. ", "MathCaption",
 CellID->31601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellularAutomaton", "[", 
  RowBox[{"30", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->24227],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->203025962]
}, Open  ]],

Cell[TextData[{
 "Here are the 8 possible neighborhoods for a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "=", "2"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "=", "1"}], TraditionalForm]], "InlineMath"],
 " cellular automaton. "
}], "MathCaption",
 CellID->23692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->19771],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{556, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->52916940]
}, Open  ]],

Cell["\<\
This shows the new color of the center cell for each of the 8 neighborhoods. \
\
\>", "MathCaption",
 CellID->29301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"CellularAutomaton", "[", 
      RowBox[{"30", ",", "#", ",", "1"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "2"}], "]"}], "]"}], "&"}], ",", "%"}], 
  "]"}]], "Input",
 CellLabel->"In[33]:=",
 CellID->22363],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0"}],
   "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->28609306]
}, Open  ]],

Cell["\<\
For rule 30, this sequence corresponds to the base\[Hyphen]2 digits of the \
number 30. \
\>", "MathCaption",
 CellID->3565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "[", 
  RowBox[{"%", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->17421],

Cell[BoxData["30"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->258868986]
}, Open  ]],

Cell[TextData[{
 "This runs the general ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "=", "3"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "=", "1"}], TraditionalForm]], "InlineMath"],
 " rule with rule number 921408. "
}], "MathCaption",
 CellID->18610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"921408", ",", "3", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "100"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->495],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzNmFGO2zAMRGXepFfqERbod4/T69aJLYuypLXeIOb6IYt1AplDi6QSzK+v
v7+/LKX0Z/37t/4ttr6WxWz9v12/L+z1Saa35vVmfaW8Jr3vsm/j9Ein97tW
2m+3LcIr3J5AOm7qrknv3JaUly1LiTyI000rvUK1WouVx1w/cwmU3eiuWT98
XS/705VtGcfp7dUWqtFK/jGTT8DtRm/NTNFPcbp7NdDyj1kn4Hajt2am6D5O
2aF6r/paLuApAb8bbitI0as4Njkmdgp4TsDtRqVSbrwsehVnckyagKcE/G5U
KuXGq6LXcSbHpAl4SqCRMFz0Ks7kmLQBx63rI4Ci13Emx6QNOGzdSgUUvYoz
OSbt4nHrehVQ9DrO5Ji0i4etW6mAopswJu3icetWKvNFN2VMjrS/O0NaFVJ0
E8akpN0THauAopsyJiXtnuhYBRTdhDE50rbr1vUqoOimjMmR9nXrVirl+rLo
JoxJDj7TupVKub4quiljkoNPtK5XMVB0E8YkC820rlcBRTdlTLLQROtWKqDo
JoxJFpppXa8Cim7KmGShaQnDRTdhTLLQvITRopsyJlkIZEWLbsKYZCGQFS26
KWOShS7iNir0QeCYZCHkGLDgpozJBnMMYHATxmRXZo4BzUoYkw3oGFzn0cSH
fbWHOaq/xbxyDFT/ilKqP+cYiP4VhToGqn9FoY6B6F9RqGOg+lcU6hjQbhSh
joHqX1F8tDrJfoeI/hWFOgaqf0WhjoHoX1GoY6D6VxTqGNBuFKGOgepfUUbf
eqOnFv0rCnUMVP+KQh0D0b+iUMdA9a8o1DGg3ShCv9FU/4pCv9FE/4pCO0T1
ryi0Q0T/ikI75NO/r0bQDvnw76sRtEPuPK88tENuPK88tEPuPK88tENuPK88
tEPuPK889KlvPK889KnvPK88V/E/5F9RovwrSpB/RYnyryhB/hUlyr+ilLPo
Vv+KEuVfUYL8K0qUf0UJ8q8oUf4VJci/okT5V5Qg/4oS5V9RgvwrSpR/RQny
ryhR/hUlyL+iRPlXlCD/ivLTv69G/PDvqxFPOq88DzqvPE86rzwPOq88Tzqv
PA86rzxPOq88DzqvPE86rzxP3Ct7Yl9thGT1H1g/bLE=
   "], {{0, 0}, {151, 101}}, {0, 2}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->66896081]
}, Open  ]],

Cell[TextData[{
 "For a general cellular automaton rule, each digit of the rule number \
specifies what color a different possible neighborhood of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "r", "+", "1"}], TraditionalForm]], "InlineMath"],
 " cells should yield. To find out which digit corresponds to which \
neighborhood, one effectively treats the cells in a neighborhood as digits in \
a number. For an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "=", "1"}], TraditionalForm]], "InlineMath"],
 " cellular automaton, the number is obtained from the list of elements ",
 Cell[BoxData[
  StyleBox["neig", "TI"]], "InlineFormula"],
 " in the neighborhood by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["neig", "TI"], ".", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      StyleBox["k", "TI"], "^", "2"}], ",", 
     StyleBox["k", "TI"], ",", "1"}], "}"}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->15022],

Cell[TextData[{
 "It is sometimes convenient to consider ",
 StyleBox["totalistic",
  FontSlant->"Italic"],
 " cellular automata, in which the new value of a cell depends only on the \
total of the values in its neighborhood. One can specify totalistic cellular \
automata by rule numbers or \[OpenCurlyDoubleQuote]codes\
\[CloseCurlyDoubleQuote] in which each digit refers to neighborhoods with a \
given total value, obtained for example from ",
 Cell[BoxData[
  RowBox[{
   StyleBox["neig", "TI"], ".", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->31812],

Cell[TextData[{
 "In general, ",
 Cell[BoxData[
  ButtonBox["CellularAutomaton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFormula"],
 " allows one to specify rules using any sequence of weights. Another choice \
sometimes convenient is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["k", "TI"], ",", "1", ",", 
    StyleBox["k", "TI"]}], "}"}]], "InlineFormula"],
 ", which yields outer totalistic rules. "
}], "Text",
 CellID->29151],

Cell[TextData[{
 "This runs the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "=", "3"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "=", "1"}], TraditionalForm]], "InlineMath"],
 " totalistic rule with code number 867. "
}], "MathCaption",
 CellID->23015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"867", ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "1"}], "}"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "100"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->8055],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzVm2t2Y7kNhAHsJFvKEuac/M46s6tYRH0FXts9Q9uSLXO62/J9kHgQhQKo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   "], {{0, 0}, {201, 101}}, {0, 2}],
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{184, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->100471056]
}, Open  ]],

Cell[TextData[{
 "Rules with range ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " involve all cells with offsets ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "r"}], TraditionalForm]], "InlineMath"],
 " through ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "r"}], TraditionalForm]], "InlineMath"],
 ". Sometimes it is convenient to think about rules that involve only cells \
with specific offsets. You can do this by replacing a single ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " with a list of offsets. "
}], "Text",
 CellID->8738],

Cell[TextData[{
 "Any ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "=", "2"}], TraditionalForm]], "InlineMath"],
 " cellular automaton rule can be thought of as corresponding to a Boolean \
function. In the simplest case, basic Boolean functions like ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Nor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nor"]], "InlineFormula"],
 " take two arguments. These are conveniently specified in a cellular \
automaton rule as being at offsets ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "0", "}"}], ",", 
    RowBox[{"{", "1", "}"}]}], "}"}]], "InlineFormula"],
 ". Note that for compatibility with handling higher\[Hyphen]dimensional \
cellular automata, offsets must always be given in lists, even for one\
\[Hyphen]dimensional cellular automata. "
}], "Text",
 CellID->15279],

Cell["\<\
This generates the truth table for 2\[Hyphen]cell\[Hyphen]neighborhood rule \
number 7, which turns out to be the Boolean function Nand. \
\>", "MathCaption",
 CellID->19882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"CellularAutomaton", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"7", ",", "2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "0", "}"}], ",", 
           RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}], ",", "#", ",", "1"}], 
      "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "2"}], "]"}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->1608],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->428186820]
}, Open  ]],

Cell["\<\
Rule numbers provide a highly compact way to specify cellular automaton \
rules. But sometimes it is more convenient to specify rules by giving an \
explicit function that should be applied to each possible neighborhood. \
\>", "Text",
 CellID->3822],

Cell["\<\
This runs an additive cellular automaton whose rule adds all values in each \
neighborhood modulo 4. \
\>", "MathCaption",
 CellID->32707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"Apply", "[", 
          RowBox[{"Plus", ",", "#"}], "]"}], ",", "4"}], "]"}], "&"}], ",", 
      RowBox[{"{", "}"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "100"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->24245],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzVW1G2pSgMDGQls6VZQp8z37PO2dWIz9JYEgMXvfrS2hhCxNxGYnXBX3/+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   "], {{0, 0}, {201, 101}}, {0, 3}],
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{184, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->187270265]
}, Open  ]],

Cell["The function is given the step number as a second argument.", \
"MathCaption",
 CellID->144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Total", "[", "#", "]"}], "+", "#2"}], ",", "4"}], "]"}], 
       "&"}], ",", 
      RowBox[{"{", "}"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "100"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->22290],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzVW2HW2ygMRHCSvdIeoe/1956ztyrGyJHHKAMGJ99Ok9pCKNhOPPJ8gn9+
/ffvrxhC+J3ff/I7SJKY30F2JPPewPzMfjr+5Q8x5X/aL/dIuTmlw2Z+Zj8d
r/4YJaRtcyCUfy8wP7Ofjn/582lFi/x7O9nMz+yn43d/yij/GQjYzM/sp+Nf
/hjOryjnF7jzjXV+YQD2j+n8wgD4uEt/DAB3OYdQUO6X3EXqfu6b97dbaN+3
vm0/R+f97Rvd9wVisH+5IzeKrPsCMfazUqM/Ho/11VOoSDuJbbdSzF9d3t8u
RCztm51Z4tRvu9+k+OTUb2tv9Zd6yaT4Xv10HCn7r8/F/ng823HafuGgtVC4
eGdo5e1keDpCv1S3Efolp78OFKGfjhPhc7E/Ho9Avxf2bzxTWSi/iv2WKie8
24XAy8WQUH6m+2/o4PW4s6DbX23177wZj3gd3+uPx6PjKwyLZed+Y+7bWN9q
71bYxglS2yW+eD2Z9lZ/tdW/tScTL6a91R+PJ0F+OfPxxtG61bfayuGF5mq7
5XXb3uqvtvq3dhtv21v98XjO+QX5WMxWwFYOD6bd8nog/RP4A8RH0h+PB/OL
OZOaQzRXaE6w3L/ZofyY830g6XiE214YrzkBbc0FGB/KLRYu46mN8RYnEj5y
SDD5IQD3h8r5Ur7q15ceG/GaE9DWXIDxUj8bxwsm39h4HzZvKG8rX1tb88Rx
C5af8zVe8wDayv8Yr/kEx7P5xsa/cGFhkweUtwPwuOYPEV8faHx0bE9fRGe8
4MT70Od7mx8s36ut8PSBzQ8t24v3xvPij7grCzfyQ2rYCk8f2PzQsr14bzwv
3oc08kPLPo7E0Q82P7RsL94bz4s/oq4s3MgPLTtBuxfv2V68N54X7wN1B+qE
g/jrCxtQd6BOYfFs/BYcFgbuR50QDffHi3XVHahTWDwbvx+oO1AnRMP9dhtN
PrC6A3UKi2fjX+GyMOgD1An4tyhsQ92BOoXFs/H7gfoAn/+V13GrQH2i+qM3
no2PcCg4XvUBPv8rr+P24EPQJ+LkHy+ejd8PAX2Ap628jtvjTECfJCf/ePFs
/DPesnBq6w+FONuDEU2c1R+98Wz8fqi+aD3/l5FBTyBUX6h+GY1n45/Ges/C
9dnfe/5HPXHhRD2Mmj9G49n4/VB94fF3BD2BUH2h+WM0no1vRyIsTJ7/UU9c
WBH0y2g8G78f3vP/cSTA/wjUL6PxbPxjHM7ChL+R/y+8CPljNL5ffzCw0w3h
3XFc9ctofNfl7qJm1unKm8CMk/H388flk7DgQeol+GL+S8GjUf9gIKSmLNio
ebyrl+A+82M9xK9/zALrJ6xegvUO5sd6SLzUPxgorSkLyrl+wuolWO9gfqyH
+PWPWWD9hNVLPD3RWw9h+gPRQWzKglA/YfUST0/01kPu6w96JlA/2RDe1EvE
0ROeX312nH4MsXAaq5d4eqK3HrIufyBY/QP/TjXqf1f/YBhkYVL/wL9Tjfr7
6x+zYPWPDXY76vfrHwzDLGzySKv+IbAd9ffXP2bB6h+4HfX36g/EDRYm9Q/c
jvrX6Q96JqT+gdtR/63Le4uqWf0Dt6P+5/IHAnUIzvNSpaHtqixwfpe299Q/
GG6yMHA/zvNSvaHtqi9wfpe2369/zAJ1iOoUWw+37aovcH6XtvP6B8NtFgY9
gfO8IrSrvsD5XSKz9Y9ZoJ7w5l+hvrD1c43rqX8w3CC6CtQT3vwr1Be2fi5x
Rf1jFgJ6IjnzrwT0hfptXBjWH4gpFk5nPeHNv0J9Yevna+ofs8D6hTf/is3v
uqM/EJMsDPULrHdgfQT96+ofs8D6RXTmX7H5Xffzh2KahUE/ePOv2Pyuz+cP
RO/8K89/V38gJgivonf+lef/nP5gwMsRnPlXnn/J5VxC3b3zrzz/9/IHgq0/
6Vn/MYtJ0qtg60/61398G1g/UV1i80Rs6JD5/KGYpr0Ktv6kf/3Ht8HWn6A9
qz8QC4ivgq0/Qft7+oNByPoTtJdexqUUztafoP1z8geCrT+ZqX8wLCK/Crb+
5HP1j1lg/UTzi/171xr9gVhGfxVs/cnn6h+zYOtPVukPxEICrGDrT36O/mCQ
xt+vrP3I5XuEytn6k5+bPxB31n/MYjEJVqxb//FtjK//mMVyGqxYt/7j2xhd
/zGLB4iwYt36j29DhtZ/zOIRKqxYt/7j21hZ/2B4iAwrfk79Yxbr6h8Mj9Fh
xc+pf8ziKf2BeJAQK/4/+oPhI5frI9T+kUH+Apybf0s=
   "], {{0, 0}, {201, 101}}, {0, 3}],
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{184, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->116441154]
}, Open  ]],

Cell["\<\
When you specify rules by functions, the values of cells need not be \
integers.\
\>", "MathCaption",
 CellID->23154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "/", "2"}], " ", 
          RowBox[{"Apply", "[", 
           RowBox[{"Plus", ",", "#"}], "]"}]}], ",", "1"}], "]"}], "&"}], ",",
       
      RowBox[{"{", "}"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "100"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->24604],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->507091226]
}, Open  ]],

Cell["They can even be symbolic. ", "MathCaption",
 CellID->22225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Mod", "[", 
         RowBox[{
          RowBox[{"Apply", "[", 
           RowBox[{"Plus", ",", "#"}], "]"}], ",", "2"}], "]"}], "&"}], ",", 
       RowBox[{"{", "}"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "a", "}"}], ",", "0"}], "}"}], ",", "2"}], "]"}], ",", 
   RowBox[{"a", " ", "\[Element]", " ", "Integers"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->20078],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "a", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"Mod", "[", 
      RowBox[{"a", ",", "2"}], "]"}], ",", 
     RowBox[{"Mod", "[", 
      RowBox[{"a", ",", "2"}], "]"}], ",", 
     RowBox[{"Mod", "[", 
      RowBox[{"a", ",", "2"}], "]"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{"a", ",", "2"}], "]"}], ",", "0", ",", 
     RowBox[{"Mod", "[", 
      RowBox[{"a", ",", "2"}], "]"}], ",", "0", ",", 
     RowBox[{"Mod", "[", 
      RowBox[{"a", ",", "2"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{377, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->13551488]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CellularAutomaton",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CellularAutomaton"], "[", 
     StyleBox["rnum", "TI"], ",", 
     StyleBox["init", "TI"], ",", 
     StyleBox["t", "TI"], "]"}], Cell[TextData[{
     "evolve for ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " steps, keeping all steps"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CellularAutomaton",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CellularAutomaton"], "[", 
     RowBox[{
      StyleBox["rnum", "TI"], ",", 
      StyleBox["init", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        StyleBox["t", "TI"], 
        StyleBox["}", "TI"]}], "}"}]}], "]"}], Cell[TextData[{
     "evolve for ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " steps, keeping only the last step"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CellularAutomaton",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CellularAutomaton"], "[", 
     RowBox[{
      StyleBox["rnum", "TI"], ",", 
      StyleBox["init", "TI"], ",", 
      RowBox[{"{", 
       SubscriptBox[
        StyleBox["spec", "TI"], 
        StyleBox["t", "TI"]], "}"}]}], "]"}], Cell[TextData[{
     "keep only steps specified by ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["t", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CellularAutomaton",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CellularAutomaton"], "[", 
     RowBox[{
      StyleBox["rnum", "TI"], ",", 
      StyleBox["init", "TI"]}], "]"}], Cell[
    "evolve rule for one step, giving only the last step", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31981],

Cell["Selecting which steps to keep. ", "Caption",
 CellID->2330],

Cell["This runs rule 30 for 5 steps, keeping only the last step. ", \
"MathCaption",
 CellID->29733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellularAutomaton", "[", 
  RowBox[{"30", ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", " ", "0"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"{", "5", "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[38]:=",
 CellID->350689650],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", 
    ",", "1", ",", "1", ",", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]=",
 CellID->67259448]
}, Open  ]],

Cell["This keeps the last 2 steps. ", "MathCaption",
 CellID->29130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellularAutomaton", "[", 
  RowBox[{"30", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->18846],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0",
      ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0",
      ",", "1", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{435, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->696356525]
}, Open  ]],

Cell["This gives one step. ", "MathCaption",
 CellID->290464341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellularAutomaton", "[", 
  RowBox[{"30", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[43]:=",
 CellID->94293804],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "1", ",", "1", ",", "0"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[43]=",
 CellID->457897312]
}, Open  ]],

Cell[TextData[{
 "The step specification ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["t", "TI"]]], "InlineFormula"],
 " works very much like taking elements from a list with ",
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 ". One difference, though, is that the initial condition for the cellular \
automaton is considered to be step ",
 Cell[BoxData["0"], "InlineFormula"],
 ". Note that any step specification of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", "\[Ellipsis]", "}"}], TraditionalForm]], "InlineMath"],
 " must be enclosed in an additional list. "
}], "Text",
 CellID->29445],

Cell[BoxData[GridBox[{
   {
    StyleBox["u", "TI"], Cell[TextData[{
     "steps ",
     Cell[BoxData["0"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["u", "TI"], "}"}], Cell[TextData[{
     "step ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["u", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["u", "TI"], "2"], "}"}], Cell[TextData[{
     "steps ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["u", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["u", "TI"], "2"], ",", 
     StyleBox["du", "TI"], "}"}], Cell[TextData[{
     "steps ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["u", "TI"], 
        StyleBox["1", "TR"]], "+", 
       StyleBox["du", "TI"]}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18805],

Cell["Cellular automaton step specifications. ", "Caption",
 CellID->8616],

Cell["\<\
This evolves for 100 steps, but keeps only every other step. \
\>", "MathCaption",
 CellID->5750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"30", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "100", ",", "2"}], "}"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[48]:=",
 CellID->20489],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzVV4uVozAMlK6Tq+E6uRK2ga3zuroleD5yCA75ENDbTcA2lkajkcnvr++/
X78i4s/P/7+YLPPnL+eLy+f8NV3MM5e5eWxe3EYz23O6j7Z6/rpMcQvchj3u
K+bbeRrusFb+ORzubA6rXXoM88ZY3zyGeSOm8HvPCKbwDGNm4hoy2w4ZxOoW
RWggADTDQmv78nKRFXrUdcEkHuiWXpUMQxVKgHAZmU419tIAgDIrfKBAWWSF
2+M6tAl2rfVAEjw1KeyIqJZFGnLlgvCxwOuTM9dQHtaKys/KhKyZQ6CkOkxD
nmBuAC+6o0iuYAxZGWslbIURwlJgAk0bQiLZMkkh38KCO3lesie14issOOsE
TLvl1Le1MPRoOBZmxtavQXlIK+EDyYQk92OW05IjD/YgvbvULJoFbWxiZV0r
LkxLSCke8RhljAutijPoiyGVghzY41oxYeoBzgOqhe5j/qAeRb+LuvYOGENW
VrRi8vcCJyHMTp+Q/kHtF6F+1re1LVC2aiVckK0oRIgzx1sbEKLCWMKblex2
KNu0Qnk2dB0hFQ4WuADkUoyl9tsMY8jKDa1AyEQuQsLhWBGZAMR5omytj2zQ
xiZWFrWSzC1CtXKK1FcofBeARayaojgehOFQ7tWKcktkVk6Ezgo0AdhGILP4
fwaGQ7lXK+EBQqKmHckAmkCfqPxqGF6etq1aQa6DONAEAj2WgXP3EASKvvf/
Oij3aqUUOGC0eaSX5Sc5G6Wd/9fAcCj3aYU1IzlQLrUcsQeh22b290rbohXJ
AosklxI5gWHO1vDz5bZFK6on62AGLEhAWtPS9vp8i92vlfQ562lsXi3+jCxz
CN0/3wplpBWbSyBPCEYdVf05UWbqtm+E4VBGWuEckUv3zD/LjNBZYW+G4VBG
WkFEyn8b5Twlj+2SfeH9MBzKQCtRlrPsG/ZyflacO8FwKOta0XIrfmG38zMl
rD1hOJQ1rVj+DZl6FuB7Z9gZhkNZ0wraUiD91rPY0LBmfzZ6KGtaYaEF36TS
8Oi8zI/BcCi3taLheb2VFETfMHwQxhzaSCulXwGynSS7nRsjG2mFh2Hq1E+d
fp/URm/rWkkcf7jgscHnPxH0sq2xUroWKLLXlwPBmOw2K+XdUO+7qraj2S1W
2KlQYlx0SBiTLbPCg8LesD5+boxsiZUgHVLOAbXR2xIrVIu9dR0cxmTXrNgP
DztdTmDXrLSTr8V/EhiT9axAIyfQRm8dK2jAZ4MxWWXl0OfGyAoreVoYkxkr
Z4Yx2YF+bzxrJ9ZGb7vA+A9FEiDT
   "], {{0, 0}, {201, 51}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{184, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[48]=",
 CellID->211106046]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CellularAutomaton",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CellularAutomaton"], "[", 
     StyleBox["rnum", "TI"], ",", 
     StyleBox["init", "TI"], ",", 
     StyleBox["t", "TI"], "]"}], Cell[
    "keep all steps, and all relevant cells", "TableText"]},
   {
    RowBox[{
     ButtonBox["CellularAutomaton",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CellularAutomaton"], "[", 
     RowBox[{
      StyleBox["rnum", "TI"], ",", 
      StyleBox["init", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["spec", "TI"], 
         StyleBox["t", "TI"]], ",", 
        SubscriptBox[
         StyleBox["spec", "TI"], 
         StyleBox["x", "TI"]]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["keep only specified steps and cells", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21963],

Cell["Selecting steps and cells to keep. ", "Caption",
 CellID->28135],

Cell[TextData[{
 "Much as you can specify which steps to keep in a cellular automaton \
evolution, so also you can specify which cells to keep. If you give an \
initial condition such as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["a", "1"], ",", 
      SubscriptBox["a", "2"], ",", "\[Ellipsis]"}], "}"}], ",", 
    StyleBox["blist",
     FontSlant->"Italic"]}], TraditionalForm]], "InlineMath"],
 ", then ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "i"], TraditionalForm]], "InlineMath"],
 " is taken to have offset 0 for the purpose of specifying which cells to \
keep. "
}], "Text",
 CellID->14697],

Cell[BoxData[GridBox[{
   {
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell["\<\
all cells that can be affected by the specified initial condition\
\>", "TableText"]},
   {
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
all cells in the region that differs from the background (default)\
\>", "TableText"]},
   {"0", Cell[TextData[{
     "cell aligned with beginning of ",
     Cell[BoxData[
      StyleBox["aspec", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    StyleBox["x", "TI"], Cell[TextData[{
     "cells at offsets up to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " on the right"
    }], "TableText"]},
   {
    RowBox[{"-", 
     StyleBox["x", "TI"]}], Cell[TextData[{
     "cells at offsets up to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " on the left"
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["x", "TI"], "}"}], Cell[TextData[{
     "cell at offset ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " to the right"
    }], "TableText"]},
   {
    RowBox[{"{", "-", 
     StyleBox["x", "TI"], "}"}], Cell[TextData[{
     "cell at offset ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " to the left"
    }], "TableText"]},
   {
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], "}"}], Cell[TextData[{
     "cells at offsets ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["dx", "TI"], "}"}], Cell[TextData[{
     "cells ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], "+", 
       StyleBox["dx", "TI"]}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32209],

Cell["Cellular automaton cell specifications. ", "Caption",
 CellID->21630],

Cell["\<\
This keeps all steps, but drops cells at offsets more than 20 on the left. \
\>", "MathCaption",
 CellID->23224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"30", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "20"}], ",", "100"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[49]:=",
 CellID->363624373],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzFllt2G0cMRBvZSbaUJficfPs7u49kNW5djCiZjyFNSzRn2NOFqkKh9feP
n//8+Gut9e/b739vv6vef+vXf+8Xb/+4+rhc+069/6cVH5cfX1fv1E/3DT5W
b/brY+0Pez1f7W8bdN+p0or9DuauJdjlEsUhlfRbb7+pQI4KG7D0DubqN+oS
CfhWy1QFdIVcSl2SsGXdnBa0+poL30ARqZZturxVocKTaGUBIjrXbdEaNxC9
b2uD7gcsS6mWcAgQx2hEpMwNucDtJeJoh+v2Fgl38QfR48LKXgcSlm8Qj61p
ENDp8s7GQfTVgdJeJjGiAd9Ea3kDV6ZWwgRX1gvZIHFye+nxorllcXdhLEkr
pV+IgzxePBpx0l5L3EC2xSP67C6XtBq300RNJGFIkO1vtD1s0MUeWknO21ya
iBmx5pUGQFprpQBt0FsvnoXEYke7lfY3aSTU+sH3uEG2jn/uO/WWkuCmypWi
Phi7CBVHj0nD3Jt+JRpOUoZHHdZjAP3LY12C5dc9d32vHokjvrNfDpRXKsp0
UnDgmHssJAMjca3PzMKRMj8KoIJj1XJv6UE9StXltRf4du2J3VY5D4ij7/lB
Ja7TNtdewEUeOrmRMnGiGpv0IxBVD7SBXnsReMaukTRxKEPdNx504pIcAC/h
ZsM2SBaPrqoURQtDffQAU6ZUxUXGGgCorP1kJC52JSxWDyC10vIFYw2AmuDi
HfqKiRPXvoJ/Ob/2OANgWjx5rxQYfapcdGG24/fVKwPgaPHgXSlmi5nOa0tk
tny5jCq3hspDR/WvQnpMHB2aOfodX9yKymM/XXQwM2WglnYG8Tu+1SrCSfsx
TmARbUbnyZKB+D1uu4Va7JfCSNMxpIUqauelnb5VWkxmJ6+Vi2LTTBAetiVx
4zq6ip0iq7glxDLCDhEnzZFvGYsJaYEiQ4UR0kxix8rHcP4drpZW0lIAOlrQ
xwGyWyEoIlcgE0Km0ArL8EqZK1wzMj4R+S2yQtjyamao8/q6xLXMF92uoMsI
piFb6LSs8DObVit/JHg93xFChM5gED6ShytO9es6WIVQkY30oahpmry4DH6u
4wtrRTZT1BTpOTTKGn6uxNWYTGSzc02KVNDfaQ3vV78c3XQvHU7XSQq+IwUr
j18N6+iO9EgBtlSPQ54Ou43vjG5CTUdFbk9Xky+/X8+YokkTg54huVdSQX+X
5sz71YxTroZVh3TIHV+wVkLcxLcKDh2pXc3+zg3HpNlrSqRv87c30KxQOBli
GYyZq2hE0G7FTV+PUTiGGI5K1kQhYbsZ1rTVWXCMo5I10b8tvwJuTnSNxiPL
uqEi60rRt/Mt9k5bjvHYsqahsCWm38GXvd2WGb/IWoLPUKHou3Czs2oJVH+z
JE4dBLkHd+ysahLQNHzEYajck18hZ+5qa1tOCyRWyve9wP22rLskyKRmbGrM
3Y3LUKjh6LR8Bafnenfc3bjdNcuOIm4ULpSPN4/wTUJ0PDS/HlGBBCzE7wZe
K12a02coL0gOQoq+GzhmNaojgwa0VpVKeYjxOPqk9dZjQhLpB/lWQJYJW/lA
Fl33oL+79Pjskz5tlBZeCP8wX8IDkTmlGSUZHY/mN9D2OTNMbdTLcnSfgJvw
FB3Wp9OY0zoFT+HblJLnVOM5zQldp/At0qs8Vx0+5Lw6Ib8B1pCUrmNC5rw6
x98qDeM1dJ0TsjgWTuObYVzSNUdDRkYa/awXyipGVJPOfvj8vYA8fdakXO7s
k/ILqpXV7hwM3W+n5beB6+izJmVanLXnAQ9lj5MSB07Mb6A/3vB5uQz+JDiZ
r46l+KxJyVH4BL7rs8867FPLybgaTpcmZQt+Ot+NfPA5x+PSKf0U5IPPNQCf
wxeYss8T8Fm4n33uGXLq+fsV8vCZ0/Jp/gp5+Az/p/LdyPa5VX8y341sn8ef
YE9HHojPy+8F5IH4Gr4beSC+Cnf4/CJ/hdw+v5DvRuZIfO3LR+LLkV/sr5D/
AN8P5D+D+yK+/wPGRyRQ
   "], {{0, 0}, {121, 101}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{184, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[49]=",
 CellID->277329654]
}, Open  ]],

Cell["This keeps just the center column of cells. ", "MathCaption",
 CellID->24474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellularAutomaton", "[", 
  RowBox[{"30", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", 
     RowBox[{"{", "0", "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[50]:=",
 CellID->31920],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWclOwzAQdRIisYj1xLH8DJz4iChUakAIVPoN7WebTCI4vI4Uu17TTqVE
M87Y82axlby+NpvV8rPZdG2zeFk336uu/Vk8f637oapQqtgqpZ4eVS/rXhou
+u36axRH6Yru1d9TrS5APwP98sTsTy0/tvFWdNvzgquQVamOxw7Hc8PnKw6s
dqm5atNo3atojfo5g4LUOvN5oePDPXaov7nUwRQn5sXUH9+lU95Ipz3BVUPV
//qwNo89t9lxIvaV5znWxxQzd2Kaed3va8SAuwH1a9Ar1ndOs8JEdOPoJec8
T2HD2M28YP8Vg53tfr8F3az3U84KE9Gdo5ec8zyFDWN3Of+k/6T/pP+k/+aU
Mek/n9mU/kvZf8gR0Sh94+Db4z1jVzFeYti54HtwWC9VXji/XBzcejzDSyL+
d2Av2TI++Dw3tjw3Nj40nje6jR1hgTo1y30s7P/SKPtzYY9j4wzNOsfOS6tN
umFebGxstKbzDudv0+VoPKvLCes8WdDQqMLwpXFi77SPfZ/m6yY0qjDfQXFi
f9dSV6mr1FXqKnVNX9cpq5QskG+/LmyR7zg+huyTaMInqeIXE2msHA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{390, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[50]=",
 CellID->124893491]
}, Open  ]],

Cell[TextData[{
 "If you give an initial condition such as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["a", "1"], ",", 
       SubscriptBox["a", "2"], ",", "\[Ellipsis]"}], "}"}], ",", 
     StyleBox["blist",
      FontSlant->"Italic"]}], 
    StyleBox["}",
     FontSlant->"Italic"]}], TraditionalForm]], "InlineMath"],
 ", then ",
 Cell[BoxData[
  ButtonBox["CellularAutomaton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFormula"],
 " will always effectively do the cellular automaton as if there were an \
infinite number of cells. By using a ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["x", "TI"]]], "InlineFormula"],
 " such as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "1"], ",", 
     SubscriptBox["x", "2"]}], "}"}], TraditionalForm]], "InlineMath"],
 " you can tell ",
 Cell[BoxData[
  ButtonBox["CellularAutomaton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFormula"],
 " to include only cells at specific offsets ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "1"], TraditionalForm]], "InlineMath"],
 " through ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "2"], TraditionalForm]], "InlineMath"],
 " in its output. ",
 Cell[BoxData[
  ButtonBox["CellularAutomaton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFormula"],
 " by default includes cells out just far enough that their values never \
simply stay the same as in the background ",
 Cell[BoxData[
  StyleBox["blist", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->10293],

Cell[TextData[{
 "In general, given a cellular automaton rule with range ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 ", cells out to distance ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "\[InvisibleSpace]", "t"}], TraditionalForm]], "InlineMath"],
 " on each side could in principle be affected in the evolution of the \
system. With ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["x", "TI"]]], "InlineFormula"],
 " being ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 ", all these cells are included; with the default setting of ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", cells whose values effectively stay the same as in ",
 Cell[BoxData[
  StyleBox["blist", "TI"]], "InlineFormula"],
 " are trimmed off. "
}], "Text",
 CellID->3855],

Cell["\<\
By default, only the parts that are not constant black are kept. \
\>", "MathCaption",
 CellID->6734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"225", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "100"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->9561],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJy9mUuOQjEQAx1uMlfiCEiw5f47mEw6aaRZUvXEJysKyzLG8HN7Xm+XJPf3
/RHoGu/b+Of8Zco4L9zP34W0dz8oJenvnlLy6QMHmV7UhUF+BewbB5luDNKT
LQb1pBLCerISwnpSCWGVlBs0JHRO0tJCQ3hPyD5pEDonPS0wxPAkuCfB++Tv
ic9J8D4piKCEz0l9ruAQw5Pwnhh9EqNPYvRJjD6ZJ0GJkJN5NCCcko95wkGE
fbKbhMzJbhIyJ6dJWE/4fdKahFWC75MFYfukIHROgu+TBhGU0DnB98mBGJ4E
9wTeJ+3XAl6JkBN4n/TfPQyIocTwJLwnRp/E6JMYfRKjT+ZBUCLkZJ4MCKjE
+P8klRA0J5UQNCf76yPqibFPYuyTSaH3yaKcRw4C98mC0DkJv08ORFBC54Tf
JxtieBLcE3qfLIiQE3qfHIighM8JvU82xPAkvCdGn8Tokxh9EqNPJkVQIuRk
UgzI/mLEXi8LsQUY
   "], {{0, 0}, {102, 101}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{184, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->336610848]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["x", "TI"]]], "InlineFormula"],
 " includes all cells that could be affected by a cellular automaton with \
this range. "
}], "MathCaption",
 CellID->27606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"225", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "All"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[51]:=",
 CellID->718951609],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzdm8sNAjEQQz10QkuUsBJn6qQryGSTDBInkHblZ/HJjbUsY4zhuj1u20XS
/X1/yhfxvsWXsx0i1rXXsxuiaBDGeqhqYKzHpyeseaQvBs6+mt/R36bmzRax
S7I/2iKmJO7+GMlh7489Oez9MZLDXo/hDAAPAfJDJUVssXgg/GHePwoPQH7U
FHHF4gHxhwj+EKF/9CdEfojQP/oTIj+E6B+aH0zOvZZ/sHhA/CGEPyD9Q5D+
IUj/EKR/5ImhByM/8gjhYa3Hx/xhzYOxf8zmYZ4fs3mY58dqHvb+QOwfpXnY
60HYP3Ye9v1j8ADkhwj7R+HB0AOQH4T9Y/GA+EMEf/jvH+WHAAg9GPnhv3/U
H2ZAeED0gPhDCH9A+ocg/UOQ/iFI/8gDQw9GfuQJwsNbD8j/PzSSwz0/RnK4
58f8MtHdH5D9Q5D9o4GwfyQA+0cCsH8kAPtHArB/JAD7RwKwfyQA+0cCsH8k
APtHB6F/NBD6RwOhfzQg+ocI+0cHo38Q9o8OSP8A7B8DjPyA9A9B+kcDxB+M
/Gg4Ro84AIe8yAsGOwXe
   "], {{0, 0}, {201, 101}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{184, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[51]=",
 CellID->525544886]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CellularAutomaton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFormula"],
 " generalizes quite directly to any number of dimensions. Above two \
dimensions, however, totalistic and other special types of rules tend to be \
more useful, since the number of entries in the rule table for a general rule \
rapidly becomes astronomical. "
}], "Text",
 CellID->28382],

Cell[BoxData[GridBox[{
   {
    RowBox[{"{", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["k", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["r", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["r", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["r", "TI"], 
         StyleBox["d", "TI"]]}], "}"}]}], "}"}], Cell[TextData[{
     Cell[BoxData[
      FormBox["d", TraditionalForm]], "InlineMath"],
     "\[Hyphen]dimensional rule with ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", 
           SubscriptBox["r", "1"]}], "+", "1"}], ")"}], "\[Cross]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", 
           SubscriptBox["r", "2"]}], "+", "1"}], ")"}], "\[Cross]", 
        "\[Ellipsis]", "\[Cross]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", 
           SubscriptBox["r", "d"]}], "+", "1"}], ")"}]}], TraditionalForm]], 
      "InlineMath"],
     " neighborhood"
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["n", "TI"], ",", "{", 
     StyleBox["k", "TI"], ",", "1", "}", ",", "{", "1", ",", "1", "}", "}"}], 
    Cell["\<\
two\[Hyphen]dimensional 9\[Hyphen]neighbor totalistic rule\
\>", "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["n", "TI"], ",", "{", 
     StyleBox["k", "TI"], ",", "{", "{", "0", ",", "1", ",", "0", "}", ",", 
     "{", "1", ",", "1", ",", "1", "}", ",", "{", "0", ",", "1", ",", "0", 
     "}", "}", "}", ",", "{", "1", ",", "1", "}", "}"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
two\[Hyphen]dimensional 5\[Hyphen]neighbor totalistic rule\
\>", "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["n", "TI"], ",", "{", 
     StyleBox["k", "TI"], ",", "{", "{", "0", ",", 
     StyleBox["k", "TI"], ",", "0", "}", ",", "{", 
     StyleBox["k", "TI"], ",", "1", ",", 
     StyleBox["k", "TI"], "}", ",", "{", "0", ",", 
     StyleBox["k", "TI"], ",", "0", "}", "}", "}", ",", "{", "1", ",", "1", 
     "}", "}"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
two\[Hyphen]dimensional 5\[Hyphen]neighbor outer totalistic rule\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14119],

Cell["\<\
Higher\[Hyphen]dimensional rule specifications. \
\>", "Caption",
 CellID->6741],

Cell["\<\
This is the rule specification for the two\[Hyphen]dimensional \
9\[Hyphen]neighbor totalistic cellular automaton with code 797. \
\>", "MathCaption",
 CellID->30432],

Cell[BoxData[
 RowBox[{
  RowBox[{"code797", "=", 
   RowBox[{"{", 
    RowBox[{"797", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->24684],

Cell["This gives steps 0 and 1 in its evolution. ", "MathCaption",
 CellID->12779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellularAutomaton", "[", 
  RowBox[{"code797", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", "1", "}"}], "}"}], ",", "0"}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->12279],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{447, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->782423357]
}, Open  ]],

Cell["This shows step 70 in the evolution. ", "MathCaption",
 CellID->20667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"First", "[", 
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"code797", ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", "1", "}"}], "}"}], ",", " ", "0"}], "}"}], ",", "\n", 
     "                                               ", 
     RowBox[{"{", 
      RowBox[{"{", "70", "}"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[52]:=",
 CellID->577135031],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzNmI2x4zYMhIF0kpauhGsglaTnZM7C7gdS8rNl/ZgzZ8sUCS4XiyXf/f37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   "], {{0, 0}, {141, 141}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[52]=",
 CellID->184147062]
}, Open  ]],

Cell[TextData[{
 "This shows all steps in a slice along the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis. "
}], "MathCaption",
 CellID->24118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Map", "[", 
   RowBox[{"First", ",", "\n", "    ", 
    RowBox[{"CellularAutomaton", "[", 
     RowBox[{"code797", ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", "1", "}"}], "}"}], ",", " ", "0"}], "}"}], ",", "\n", 
      "                                      ", 
      RowBox[{"{", 
       RowBox[{"70", ",", " ", 
        RowBox[{"{", "0", "}"}], ",", " ", "All"}], "}"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->320238549],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzNluth20AMg8lu0mn6vyNkgU7SnZtER+DjWZbtRI+qjSXdg8SBBKmfb39+
v/2IiF/vf3/f/zI+r4z8uD4fPl6XZ91i+R9jPpeZWp6LnRpolqI2N3vZLAHE
Yig/H7uRgbXmsINPKQtrsxG23A3PXqOvKBrGohSeFGawmHJbJ683n7Z2pfZm
yn0m/FaM6mS1oR0Qmwp8C0fh7gOgojYnLMKP/GIoGvLUecu3GKrQ+bXSoh4r
7RDCEDvFYTbmI3j4OjOzUbnMnY4LyMpAGEUVVlsAjLf4SmKBpkILtMyaSKGS
M+WhM1+BxR6yRPvN8cQN0rKBcTKSU8hHh45pBTc3MCFvOWNhxqiKsLqkT1dm
GjmNFs3dbHbMUXBusDj8PNzwQn2EzfYTI1fnpTZiGnLyucbNlK9Z1U6Bnven
vHTxVtS9NxrN7TzraOZkGLmaYkZctbqgBANbyaeStPMuu8t73IT7lMlGIUEE
nNDpnZwW2R6sxF3V0S03dSydCJ0p+CD29S/urpTGK2b386XtV4msnElG14Jr
ZICmVoo8JgRlf5MXcuN0pb4FaRI+jpEUjp26xyjHHvCCk5QFElNurY5QTVLt
wDhPrmA3vh5gEWBksJSLjlQ5wkTRAIWkZBW5q/1om5ueABUXiL6BzdlZCRhR
66n3HBbkTdU4nCWNKQpjZUSXcFZOI71h80ksVo2EiAHJndnCX03Mm1xknucF
3Pj4HDfL6b/kK7bdsfECFsjStELzXpMIiFNbK6atj/rRBppeVbKfzIpbxupB
giYrTVCv8gLswpG0bRcuL0oVTcuSCs9LOprQWCE2J1WEapgPXMVHKmTxe6of
bXLjPpU2KYSthWYNTIsE+ql+9IgbqhvVrASNDa65AQxqS1/mxWewveFAL2t2
PWfWXutHG2h8qARHVfAcKqXT2sLX+tEGGt3w0z8IAhQox+Ytzd7X0RQr7i7O
VAJhNTBB/rj4Ji8DDU6sUOgtAYZSFg5v/zYWcYMB1JJ6d6Fnkblv4zto5NJH
beBwK0DBogw7O6BJPKDeq12nmzfbwbRzLzTLTaFHiQ+oC+PWXbOxD5qET7ks
JEZ6O7dfvgCNCykElhKW8LAbYNOeV0sXfDVB0gjIvG5fLEhE39O5otBMFWVP
HU1orFe7YtssUFx2AC/lWtYtnoktiGl3HU1olKBo2y6GagFedhQWZooKXOBl
Gj5CRxMapE4sUVGdYQPdsx9toCl3lSLqSX3wKB1NaFTz0p/EY47N9GhehosB
Zrn1ycTc8Vhan1r5Itc3wwm8DDSmRDIfnSo8eQYW6ESyEUgUl3Ow3HQcJO3K
7Blo5j7F1xN5GWh0Y98+th9toFHqqnsf3o820PiLxt/jJ+poQpPO1rwZOx1N
iBQJ/RosrU8hQNdgQZ+qn7gOyw0RF/Iy3G++n3vhs/diXgaa1edrruw/F185
it7/gOXKurt28RPr+mvta/iLdna4djLzD2aKCzI=
   "], {{0, 0}, {141, 71}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{184, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]=",
 CellID->11129306]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->71283771],

Cell[TextData[ButtonBox["Numerical Operations on Data",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalOperationsOnDataOverview"]], "RelatedTutorials",
 CellID->618122]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cellular Automata - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Operations on Data", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NumericalOperationsOnDataOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ConvolutionsAndCorrelations"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 9.4517332}", "context" -> "", 
    "keywords" -> {
     "additive cellular automata", "array automata", "automata", "CAs", 
      "CellularAutomaton", "coupled map lattices", "discrete models", 
      "elementary cellular automata", "iterative arrays", "models", "padding",
       "rule 30", "rule numbers", "totalistic cellular automata"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Cellular automata provide a convenient way to represent many kinds of \
systems in which the values of cells in an array are updated in discrete \
steps according to a local rule. Generating a cellular automaton evolution. \
This starts with the list given, then evolves rule 30 for four steps. ", 
    "synonyms" -> {"3.8.6"}, "title" -> "Cellular Automata", "type" -> 
    "Tutorial", "uri" -> "tutorial/CellularAutomata"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.8.6"->{
  Cell[2049, 62, 80, 2, 70, "Title",
   CellTags->{"S3.8.6", "6.1"},
   CellID->29033]},
 "6.1"->{
  Cell[2049, 62, 80, 2, 70, "Title",
   CellTags->{"S3.8.6", "6.1"},
   CellID->29033]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.8.6", 106987, 2930},
 {"6.1", 107086, 2934}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1424, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2049, 62, 80, 2, 70, "Title",
 CellTags->{"S3.8.6", "6.1"},
 CellID->29033],
Cell[2132, 66, 219, 5, 70, "Text",
 CellID->2088],
Cell[2354, 73, 883, 28, 70, "DefinitionBox",
 CellID->12935],
Cell[3240, 103, 78, 1, 70, "Caption",
 CellID->19779],
Cell[3321, 106, 117, 3, 70, "MathCaption",
 CellID->15993],
Cell[CellGroupData[{
Cell[3463, 113, 248, 7, 28, "Input",
 CellID->14790],
Cell[3714, 122, 754, 22, 54, "Output",
 CellID->42922855]
}, Open  ]],
Cell[4483, 147, 121, 3, 70, "MathCaption",
 CellID->18965],
Cell[CellGroupData[{
Cell[4629, 154, 253, 7, 28, "Input",
 CellID->11001],
Cell[4885, 163, 5924, 103, 98, "Output",
 CellID->116416598]
}, Open  ]],
Cell[10824, 269, 120, 3, 70, "MathCaption",
 CellID->13827538],
Cell[CellGroupData[{
Cell[10969, 276, 252, 7, 70, "Input",
 CellID->294948713],
Cell[11224, 285, 755, 22, 54, "Output",
 CellID->262285699]
}, Open  ]],
Cell[11994, 310, 2725, 90, 70, "DefinitionBox",
 CellID->11807],
Cell[14722, 402, 130, 4, 70, "Caption",
 CellID->24567],
Cell[14855, 408, 342, 9, 70, "Text",
 CellID->2669],
Cell[15200, 419, 118, 3, 70, "MathCaption",
 CellID->3134],
Cell[CellGroupData[{
Cell[15343, 426, 226, 7, 70, "Input",
 CellID->32671],
Cell[15572, 435, 365, 12, 36, "Output",
 CellID->97936752]
}, Open  ]],
Cell[15952, 450, 578, 12, 70, "Text",
 CellID->12998],
Cell[16533, 464, 134, 4, 70, "MathCaption",
 CellID->3545],
Cell[CellGroupData[{
Cell[16692, 472, 264, 9, 70, "Input",
 CellID->13597],
Cell[16959, 483, 2994, 55, 115, "Output",
 CellID->7553989]
}, Open  ]],
Cell[19968, 541, 366, 11, 70, "MathCaption",
 CellID->8838],
Cell[CellGroupData[{
Cell[20359, 556, 369, 12, 70, "Input",
 CellID->14844],
Cell[20731, 570, 2785, 51, 144, "Output",
 CellID->350423843]
}, Open  ]],
Cell[23531, 624, 234, 5, 70, "Text",
 CellID->8563],
Cell[23768, 631, 218, 7, 70, "MathCaption",
 CellID->21028],
Cell[CellGroupData[{
Cell[24011, 642, 565, 19, 70, "Input",
 CellID->29264],
Cell[24579, 663, 3947, 70, 91, "Output",
 CellID->330192129]
}, Open  ]],
Cell[28541, 736, 4004, 131, 70, "DefinitionBox",
 CellID->14723],
Cell[32548, 869, 107, 3, 70, "Caption",
 CellID->13490],
Cell[32658, 874, 618, 15, 70, "Text",
 CellID->7604],
Cell[33279, 891, 86, 1, 70, "MathCaption",
 CellID->31601],
Cell[CellGroupData[{
Cell[33390, 896, 203, 6, 70, "Input",
 CellID->24227],
Cell[33596, 904, 323, 11, 36, "Output",
 CellID->203025962]
}, Open  ]],
Cell[33934, 918, 307, 11, 70, "MathCaption",
 CellID->23692],
Cell[CellGroupData[{
Cell[34266, 933, 171, 6, 70, "Input",
 CellID->19771],
Cell[34440, 941, 736, 23, 36, "Output",
 CellID->52916940]
}, Open  ]],
Cell[35191, 967, 126, 4, 70, "MathCaption",
 CellID->29301],
Cell[CellGroupData[{
Cell[35342, 975, 309, 11, 70, "Input",
 CellID->22363],
Cell[35654, 988, 270, 9, 36, "Output",
 CellID->28609306]
}, Open  ]],
Cell[35939, 1000, 134, 4, 70, "MathCaption",
 CellID->3565],
Cell[CellGroupData[{
Cell[36098, 1008, 126, 4, 70, "Input",
 CellID->17421],
Cell[36227, 1014, 160, 5, 36, "Output",
 CellID->258868986]
}, Open  ]],
Cell[36402, 1022, 295, 11, 70, "MathCaption",
 CellID->18610],
Cell[CellGroupData[{
Cell[36722, 1037, 327, 11, 70, "Input",
 CellID->495],
Cell[37052, 1050, 1499, 30, 144, "Output",
 CellID->66896081]
}, Open  ]],
Cell[38566, 1083, 912, 26, 70, "Text",
 CellID->15022],
Cell[39481, 1111, 624, 16, 70, "Text",
 CellID->31812],
Cell[40108, 1129, 483, 15, 70, "Text",
 CellID->29151],
Cell[40594, 1146, 295, 11, 70, "MathCaption",
 CellID->23015],
Cell[CellGroupData[{
Cell[40914, 1161, 380, 13, 70, "Input",
 CellID->8055],
Cell[41297, 1176, 4271, 75, 115, "Output",
 CellID->100471056]
}, Open  ]],
Cell[45583, 1254, 580, 18, 70, "Text",
 CellID->8738],
Cell[46166, 1274, 942, 27, 70, "Text",
 CellID->15279],
Cell[47111, 1303, 184, 4, 70, "MathCaption",
 CellID->19882],
Cell[CellGroupData[{
Cell[47320, 1311, 784, 27, 70, "Input",
 CellID->1608],
Cell[48107, 1340, 224, 7, 36, "Output",
 CellID->428186820]
}, Open  ]],
Cell[48346, 1350, 260, 5, 70, "Text",
 CellID->3822],
Cell[48609, 1357, 148, 4, 70, "MathCaption",
 CellID->32707],
Cell[CellGroupData[{
Cell[48782, 1365, 505, 17, 70, "Input",
 CellID->24245],
Cell[49290, 1384, 2469, 45, 115, "Output",
 CellID->187270265]
}, Open  ]],
Cell[51774, 1432, 98, 2, 70, "MathCaption",
 CellID->144],
Cell[CellGroupData[{
Cell[51897, 1438, 511, 18, 70, "Input",
 CellID->22290],
Cell[52411, 1458, 2587, 47, 115, "Output",
 CellID->116441154]
}, Open  ]],
Cell[55013, 1508, 127, 4, 70, "MathCaption",
 CellID->23154],
Cell[CellGroupData[{
Cell[55165, 1516, 575, 20, 28, "Input",
 CellID->24604],
Cell[55743, 1538, 12840, 215, 115, "Output",
 Evaluatable->False,
 CellID->507091226]
}, Open  ]],
Cell[68598, 1756, 66, 1, 70, "MathCaption",
 CellID->22225],
Cell[CellGroupData[{
Cell[68689, 1761, 585, 18, 70, "Input",
 CellID->20078],
Cell[69277, 1781, 811, 25, 54, "Output",
 CellID->13551488]
}, Open  ]],
Cell[70103, 1809, 2100, 66, 70, "DefinitionBox",
 CellID->31981],
Cell[72206, 1877, 65, 1, 70, "Caption",
 CellID->2330],
Cell[72274, 1880, 100, 2, 70, "MathCaption",
 CellID->29733],
Cell[CellGroupData[{
Cell[72399, 1886, 287, 9, 70, "Input",
 CellID->350689650],
Cell[72689, 1897, 327, 10, 36, "Output",
 CellID->67259448]
}, Open  ]],
Cell[73031, 1910, 68, 1, 70, "MathCaption",
 CellID->29130],
Cell[CellGroupData[{
Cell[73124, 1915, 294, 10, 70, "Input",
 CellID->18846],
Cell[73421, 1927, 505, 15, 36, "Output",
 CellID->696356525]
}, Open  ]],
Cell[73941, 1945, 64, 1, 70, "MathCaption",
 CellID->290464341],
Cell[CellGroupData[{
Cell[74030, 1950, 219, 7, 70, "Input",
 CellID->94293804],
Cell[74252, 1959, 234, 7, 36, "Output",
 CellID->457897312]
}, Open  ]],
Cell[74501, 1969, 693, 20, 70, "Text",
 CellID->29445],
Cell[75197, 1991, 1815, 65, 70, "DefinitionBox",
 CellID->18805],
Cell[77015, 2058, 74, 1, 70, "Caption",
 CellID->8616],
Cell[77092, 2061, 107, 3, 70, "MathCaption",
 CellID->5750],
Cell[CellGroupData[{
Cell[77224, 2068, 352, 12, 70, "Input",
 CellID->20489],
Cell[77579, 2082, 1594, 31, 73, "Output",
 CellID->211106046]
}, Open  ]],
Cell[79188, 2116, 1184, 35, 70, "DefinitionBox",
 CellID->21963],
Cell[80375, 2153, 70, 1, 70, "Caption",
 CellID->28135],
Cell[80448, 2156, 656, 20, 70, "Text",
 CellID->14697],
Cell[81107, 2178, 2814, 99, 70, "DefinitionBox",
 CellID->32209],
Cell[83924, 2279, 75, 1, 70, "Caption",
 CellID->21630],
Cell[84002, 2282, 122, 3, 70, "MathCaption",
 CellID->23224],
Cell[CellGroupData[{
Cell[84149, 2289, 401, 14, 70, "Input",
 CellID->363624373],
Cell[84553, 2305, 2320, 43, 172, "Output",
 CellID->277329654]
}, Open  ]],
Cell[86888, 2351, 83, 1, 70, "MathCaption",
 CellID->24474],
Cell[CellGroupData[{
Cell[86996, 2356, 295, 10, 28, "Input",
 CellID->31920],
Cell[87294, 2368, 818, 17, 54, "Output",
 Evaluatable->False,
 CellID->124893491]
}, Open  ]],
Cell[88127, 2388, 1698, 56, 70, "Text",
 CellID->10293],
Cell[89828, 2446, 939, 29, 70, "Text",
 CellID->3855],
Cell[90770, 2477, 111, 3, 70, "MathCaption",
 CellID->6734],
Cell[CellGroupData[{
Cell[90906, 2484, 264, 9, 70, "Input",
 CellID->9561],
Cell[91173, 2495, 791, 18, 199, "Output",
 CellID->336610848]
}, Open  ]],
Cell[91979, 2516, 373, 14, 70, "MathCaption",
 CellID->27606],
Cell[CellGroupData[{
Cell[92377, 2534, 319, 10, 70, "Input",
 CellID->718951609],
Cell[92699, 2546, 855, 19, 115, "Output",
 CellID->525544886]
}, Open  ]],
Cell[93569, 2568, 441, 10, 70, "Text",
 CellID->28382],
Cell[94013, 2580, 2613, 76, 70, "DefinitionBox",
 CellID->14119],
Cell[96629, 2658, 90, 3, 70, "Caption",
 CellID->6741],
Cell[96722, 2663, 176, 4, 70, "MathCaption",
 CellID->30432],
Cell[96901, 2669, 280, 10, 70, "Input",
 CellID->24684],
Cell[97184, 2681, 82, 1, 70, "MathCaption",
 CellID->12779],
Cell[CellGroupData[{
Cell[97291, 2686, 254, 9, 70, "Input",
 CellID->12279],
Cell[97548, 2697, 701, 23, 36, "Output",
 CellID->782423357]
}, Open  ]],
Cell[98264, 2723, 76, 1, 70, "MathCaption",
 CellID->20667],
Cell[CellGroupData[{
Cell[98365, 2728, 461, 13, 70, "Input",
 CellID->577135031],
Cell[98829, 2743, 2934, 53, 201, "Output",
 CellID->184147062]
}, Open  ]],
Cell[101778, 2799, 172, 6, 70, "MathCaption",
 CellID->24118],
Cell[CellGroupData[{
Cell[101975, 2809, 555, 16, 70, "Input",
 CellID->320238549],
Cell[102533, 2827, 1788, 34, 116, "Output",
 CellID->11129306]
}, Open  ]],
Cell[CellGroupData[{
Cell[104358, 2866, 71, 1, 70, "RelatedTutorialsSection",
 CellID->71283771],
Cell[104432, 2869, 183, 4, 70, "RelatedTutorials",
 CellID->618122]
}, Open  ]]
}, Open  ]],
Cell[104642, 2877, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

