(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22550,        831]
NotebookOptionsPosition[     16809,        650]
NotebookOutlinePosition[     19720,        724]
CellTagsIndexPosition[     19627,        718]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EvaluationOfExpressionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Evaluation of Expressions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reap" :> Documentation`HelpLookup["paclet:ref/Reap"], "Sow" :> 
          Documentation`HelpLookup["paclet:ref/Sow"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Reap\"\>", 
       2->"\<\"Sow\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Collecting Expressions During Evaluation", "Title",
 CellTags->{"S2.6.11", "11.1"},
 CellID->8044],

Cell[TextData[{
 "In many computations one is concerned only with the final result of \
evaluating the expression given as input. But sometimes one also wants to \
collect expressions that were generated in the course of the evaluation. You \
can do this using ",
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->30591],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Sow",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sow"], "[", 
     StyleBox["val", "TI"], "]"}], Cell[TextData[{
     "sow the value ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     " for the nearest enclosing ",
     Cell[BoxData[
      ButtonBox["Reap",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Reap"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Reap",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Reap"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", returning also a list of values sown by ",
     Cell[BoxData[
      ButtonBox["Sow",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sow"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26803],

Cell[TextData[{
 "Using ",
 StyleBox["Sow", "MR"],
 " and ",
 StyleBox["Reap", "MR"],
 ". "
}], "Caption",
 CellID->3388],

Cell["Here the output contains only the final result. ", "MathCaption",
 CellID->18915],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", "3"}], ";", 
  RowBox[{"a", "+=", 
   RowBox[{
    RowBox[{"a", "^", "2"}], "+", "1"}]}], ";", 
  RowBox[{"a", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"a", "+", 
     RowBox[{"a", "^", "2"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7450],

Cell[BoxData[
 SqrtBox["182"]], "Output",
 ImageSize->{42, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56516430]
}, Open  ]],

Cell["Here two intermediate results are also given. ", "MathCaption",
 CellID->6272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{"Sow", "[", 
    RowBox[{"a", "=", "3"}], "]"}], ";", 
   RowBox[{"a", "+=", 
    RowBox[{"Sow", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", "1"}], "]"}]}], ";", 
   RowBox[{"a", "=", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"a", "+", 
      RowBox[{"a", "^", "2"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25791],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox["182"], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"3", ",", "10"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{128, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->381205061]
}, Open  ]],

Cell["This computes a sum, collecting all terms that are even. ", \
"MathCaption",
 CellID->10133],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"EvenQ", "[", "#", "]"}], ",", 
        RowBox[{"Sow", "[", "#", "]"}], ",", "#"}], "]"}], "&"}], "[", 
     RowBox[{
      RowBox[{"i", "^", "2"}], "+", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1775],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"395", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"2", ",", "10", ",", "26", ",", "50", ",", "82"}], "}"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->54530863]
}, Open  ]],

Cell[TextData[{
 "Like ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " can be used anywhere in a computation. "
}], "Text",
 CellID->23569],

Cell[TextData[{
 "This defines a function that can do a ",
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18300],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"x", "<", 
       RowBox[{"1", "/", "2"}]}], ",", 
      RowBox[{"Sow", "[", "x", "]"}]}], "]"}], ";", 
    RowBox[{"3.5", " ", "x", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}]}]}], ")"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->17954],

Cell["This nests the function, reaping all cases below 1/2. ", "MathCaption",
 CellID->12078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{"Nest", "[", 
   RowBox[{"f", ",", "0.8", ",", "10"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->3585],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8683116395335331`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "0.4153318399999999`", ",", "0.4464715508717464`", ",", 
      "0.408785396490616`", ",", "0.4562854699982232`"}], "}"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->180841765]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Sow",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sow"], "[", 
     StyleBox["val", "TI"], ",", 
     StyleBox["tag", "TI"], "]"}], Cell[TextData[{
     "sow ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     " with a tag to indicate when to reap"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Sow",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sow"], "[", 
     StyleBox["val", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["tag", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["tag", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "sow ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     " for each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["tag", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Reap",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Reap"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "reap all values whose tags match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Reap",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Reap"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["form", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["form", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "make separate lists for each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["form", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Reap",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Reap"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["form", "TI"], "1"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to each distinct tag and list of values"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, True, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25333],

Cell["Sowing and reaping with tags. ", "Caption",
 CellID->893],

Cell[TextData[{
 "This reaps only values sown with tag\[NonBreakingSpace]",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sow", "[", 
     RowBox[{"1", ",", "x"}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"2", ",", "y"}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"3", ",", "x"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->10103],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->191973532]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData["1"], "InlineFormula"],
 " is sown twice with tag ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sow", "[", 
     RowBox[{"1", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "x"}], "}"}]}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"2", ",", "y"}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"3", ",", "x"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->10722],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "3"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->867326709]
}, Open  ]],

Cell["\<\
Values sown with different tags always appear in different sublists. \
\>", "MathCaption",
 CellID->19611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{"Sow", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x"}], "}"}]}], "]"}], ";", 
   RowBox[{"Sow", "[", 
    RowBox[{"2", ",", "y"}], "]"}], ";", 
   RowBox[{"Sow", "[", 
    RowBox[{"3", ",", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->18990],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->4223065]
}, Open  ]],

Cell["The makes a sublist for each form of tag being reaped. ", "MathCaption",
 CellID->21641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sow", "[", 
     RowBox[{"1", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "x"}], "}"}]}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"2", ",", "y"}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"3", ",", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->23258],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "3"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "3"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", "2", "}"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->75539364]
}, Open  ]],

Cell[TextData[{
 "This applies ",
 Cell[BoxData["f"], "InlineFormula"],
 " to each distinct tag and list of values. "
}], "MathCaption",
 CellID->2352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sow", "[", 
     RowBox[{"1", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "x"}], "}"}]}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"2", ",", "y"}], "]"}], ";", 
    RowBox[{"Sow", "[", 
     RowBox[{"3", ",", "x"}], "]"}]}], ",", "_", ",", "f"}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->9658],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "3"}], "}"}]}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"y", ",", 
       RowBox[{"{", "2", "}"}]}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{219, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->479]
}, Open  ]],

Cell["The tags can be part of the computation. ", "MathCaption",
 CellID->25302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"Sow", "[", 
     RowBox[{
      RowBox[{"i", "/", "j"}], ",", 
      RowBox[{"GCD", "[", 
       RowBox[{"i", ",", "j"}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "i"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->32683],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Null", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", 
       FractionBox["3", "2"], ",", "4", ",", 
       FractionBox["4", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{307, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->8908117]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->372120526],

Cell[TextData[ButtonBox["Evaluation of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EvaluationOfExpressionsOverview"]], "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Collecting Expressions During Evaluation - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Evaluation of Expressions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/EvaluationOfExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/LoopsAndControlStructures"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TracingEvaluation"]}], "Text",
       FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 13.2955816}", "context" -> "", 
    "keywords" -> {
     "accumulating expressions", "appending", "bags", 
      "collecting expressions", "collecting intermediate results", 
      "growing lists", "intermediate results", "linked lists", "lists", 
      "Reap", "Sow", "tags"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "In many computations one is concerned only with the final result of \
evaluating the expression given as input. But sometimes one also wants to \
collect expressions that were generated in the course of the evaluation. You \
can do this using Sow and Reap. Using Sow and Reap. Here the output contains \
only the final result. ", "synonyms" -> {"2.6.10"}, "title" -> 
    "Collecting Expressions During Evaluation", "type" -> "Tutorial", "uri" -> 
    "tutorial/CollectingExpressionsDuringEvaluation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.6.11"->{
  Cell[1889, 59, 104, 2, 70, "Title",
   CellTags->{"S2.6.11", "11.1"},
   CellID->8044]},
 "11.1"->{
  Cell[1889, 59, 104, 2, 70, "Title",
   CellTags->{"S2.6.11", "11.1"},
   CellID->8044]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.6.11", 19411, 707},
 {"11.1", 19513, 711}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1264, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1889, 59, 104, 2, 70, "Title",
 CellTags->{"S2.6.11", "11.1"},
 CellID->8044],
Cell[1996, 63, 527, 16, 70, "Text",
 CellID->30591],
Cell[2526, 81, 1215, 39, 70, "DefinitionBox",
 CellID->26803],
Cell[3744, 122, 121, 7, 70, "Caption",
 CellID->3388],
Cell[3868, 131, 87, 1, 70, "MathCaption",
 CellID->18915],
Cell[CellGroupData[{
Cell[3980, 136, 299, 11, 28, "Input",
 CellID->7450],
Cell[4282, 149, 170, 6, 38, "Output",
 CellID->56516430]
}, Open  ]],
Cell[4467, 158, 84, 1, 70, "MathCaption",
 CellID->6272],
Cell[CellGroupData[{
Cell[4576, 163, 405, 14, 28, "Input",
 CellID->25791],
Cell[4984, 179, 295, 11, 43, "Output",
 CellID->381205061]
}, Open  ]],
Cell[5294, 193, 98, 2, 70, "MathCaption",
 CellID->10133],
Cell[CellGroupData[{
Cell[5417, 199, 450, 15, 70, "Input",
 CellID->1775],
Cell[5870, 216, 319, 11, 36, "Output",
 CellID->54530863]
}, Open  ]],
Cell[6204, 230, 570, 23, 70, "Text",
 CellID->23569],
Cell[6777, 255, 208, 8, 70, "MathCaption",
 CellID->18300],
Cell[6988, 265, 401, 14, 70, "Input",
 CellID->17954],
Cell[7392, 281, 93, 1, 70, "MathCaption",
 CellID->12078],
Cell[CellGroupData[{
Cell[7510, 286, 163, 5, 70, "Input",
 CellID->3585],
Cell[7676, 293, 404, 13, 36, "Output",
 CellID->180841765]
}, Open  ]],
Cell[8095, 309, 2599, 85, 70, "DefinitionBox",
 CellID->25333],
Cell[10697, 396, 63, 1, 70, "Caption",
 CellID->893],
Cell[10763, 399, 154, 5, 70, "MathCaption",
 CellID->10490],
Cell[CellGroupData[{
Cell[10942, 408, 327, 11, 70, "Input",
 CellID->10103],
Cell[11272, 421, 278, 10, 36, "Output",
 CellID->191973532]
}, Open  ]],
Cell[11565, 434, 171, 7, 70, "MathCaption",
 CellID->17233],
Cell[CellGroupData[{
Cell[11761, 445, 382, 13, 70, "Input",
 CellID->10722],
Cell[12146, 460, 289, 10, 36, "Output",
 CellID->867326709]
}, Open  ]],
Cell[12450, 473, 116, 3, 70, "MathCaption",
 CellID->19611],
Cell[CellGroupData[{
Cell[12591, 480, 350, 12, 70, "Input",
 CellID->18990],
Cell[12944, 494, 340, 12, 36, "Output",
 CellID->4223065]
}, Open  ]],
Cell[13299, 509, 94, 1, 70, "MathCaption",
 CellID->21641],
Cell[CellGroupData[{
Cell[13418, 514, 441, 15, 70, "Input",
 CellID->23258],
Cell[13862, 531, 497, 17, 36, "Output",
 CellID->75539364]
}, Open  ]],
Cell[14374, 551, 151, 5, 70, "MathCaption",
 CellID->2352],
Cell[CellGroupData[{
Cell[14550, 560, 393, 13, 70, "Input",
 CellID->9658],
Cell[14946, 575, 460, 16, 36, "Output",
 CellID->479]
}, Open  ]],
Cell[15421, 594, 80, 1, 70, "MathCaption",
 CellID->25302],
Cell[CellGroupData[{
Cell[15526, 599, 409, 14, 70, "Input",
 CellID->32683],
Cell[15938, 615, 525, 17, 51, "Output",
 CellID->8908117]
}, Open  ]],
Cell[CellGroupData[{
Cell[16500, 637, 72, 1, 70, "RelatedTutorialsSection",
 CellID->372120526],
Cell[16575, 640, 180, 4, 70, "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],
Cell[16782, 648, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

