(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41420,       1519]
NotebookOptionsPosition[     32674,       1238]
NotebookOutlinePosition[     36184,       1324]
CellTagsIndexPosition[     36049,       1317]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EvaluationOfExpressionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Evaluation of Expressions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"False" :> Documentation`HelpLookup["paclet:ref/False"], "If" :> 
          Documentation`HelpLookup["paclet:ref/If"], "MatchQ" :> 
          Documentation`HelpLookup["paclet:ref/MatchQ"], "Piecewise" :> 
          Documentation`HelpLookup["paclet:ref/Piecewise"], "SameQ" :> 
          Documentation`HelpLookup["paclet:ref/SameQ"], "Switch" :> 
          Documentation`HelpLookup["paclet:ref/Switch"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"], "TrueQ" :> 
          Documentation`HelpLookup["paclet:ref/TrueQ"], "UnsameQ" :> 
          Documentation`HelpLookup["paclet:ref/UnsameQ"], "Which" :> 
          Documentation`HelpLookup["paclet:ref/Which"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"False\"\>", 2->"\<\"If\"\>", 3->"\<\"MatchQ\"\>",
        4->"\<\"Piecewise\"\>", 5->"\<\"SameQ\"\>", 6->"\<\"Switch\"\>", 
       7->"\<\"True\"\>", 8->"\<\"TrueQ\"\>", 9->"\<\"UnsameQ\"\>", 
       10->"\<\"Which\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Conditionals", "Title",
 CellTags->{"S2.6.9", "9.1"},
 CellID->1655],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides various ways to set up ",
 StyleBox["conditionals",
  FontSlant->"Italic"],
 ", which specify that particular expressions should be evaluated only if \
certain conditions hold. "
}], "Text",
 CellID->17410],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["lhs", "TI"], ":=", 
     StyleBox["rhs", "TI"], "/;", 
     StyleBox["test", "TI"]}], Cell[TextData[{
     "use the definition only if ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " evaluates to ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["If",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/If"], "[", 
     StyleBox["test", "TI"], ",", 
     StyleBox["then", "TI"], ",", 
     StyleBox["else", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["then", "TI"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      StyleBox["else", "TI"]], "InlineFormula"],
     " if it is ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Which",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Which"], "[", 
     SubscriptBox[
      StyleBox["test", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["value", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["test", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "evaluate the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["test", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in turn, giving the value associated with the first one that is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Switch",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Switch"], "[", 
     StyleBox["expr", "TI"], ",", 
     SubscriptBox[
      StyleBox["form", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["value", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["form", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "compare ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["form", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", giving the value associated with the first form it matches"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Switch",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Switch"], "[", 
     StyleBox["expr", "TI"], ",", 
     SubscriptBox[
      StyleBox["form", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["value", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["form", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", "_", ",", 
     StyleBox["def", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["def", "TI"]], "InlineFormula"],
     " as a default value"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Piecewise",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Piecewise"], "[", "{", "{", 
     SubscriptBox[
      StyleBox["value", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["test", "TI"], "1"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["def", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the value corresponding to the first ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["test", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " which yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6359],

Cell["Conditional constructs. ", "Caption",
 CellID->27624],

Cell[TextData[{
 "The test gives ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", so the \[OpenCurlyDoubleQuote]",
 Cell[BoxData[
  StyleBox["else", "TI"]], "InlineFormula"],
 "\[CloseCurlyDoubleQuote] expression ",
 Cell[BoxData["y"], "InlineFormula"],
 " is returned. "
}], "MathCaption",
 CellID->20537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"7", ">", "8"}], ",", "x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21548],

Cell[BoxData["y"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->634561841]
}, Open  ]],

Cell[TextData[{
 "Only the \[OpenCurlyDoubleQuote]",
 Cell[BoxData[
  StyleBox["else", "TI"]], "InlineFormula"],
 "\[CloseCurlyDoubleQuote] expression is evaluated in this case. "
}], "MathCaption",
 CellID->27595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"7", ">", "8"}], ",", 
   RowBox[{"Print", "[", "x", "]"}], ",", 
   RowBox[{"Print", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4041],

Cell[BoxData["y"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->986527322]
}, Open  ]],

Cell[TextData[{
 "When you write programs in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you will often have a choice between making a single definition whose \
right\[Hyphen]hand side involves several branches controlled by ",
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 " functions, or making several definitions, each controlled by an \
appropriate ",
 Cell[BoxData["/;"], "InlineFormula"],
 " condition. By using several definitions, you can often produce programs \
that are both clearer, and easier to modify. "
}], "Text",
 CellID->24350],

Cell[TextData[{
 "This defines a step function, with value ",
 Cell[BoxData["1"], "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{"x", ">", "0"}]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " otherwise. "
}], "MathCaption",
 CellID->10291],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"x", ">", "0"}], ",", "1", ",", 
    RowBox[{"-", "1"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30836],

Cell[TextData[{
 "This defines the positive part of the step function using a ",
 Cell[BoxData["/;"], "InlineFormula"],
 " condition. "
}], "MathCaption",
 CellID->9374],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"1", "/;", 
   RowBox[{"x", ">", "0"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->11020],

Cell["Here is the negative part of the step function. ", "MathCaption",
 CellID->4596],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"-", "1"}], "/;", 
   RowBox[{"x", "<=", "0"}]}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->24021],

Cell[TextData[{
 "This shows the complete definition using ",
 Cell[BoxData["/;"], "InlineFormula"],
 " conditions. "
}], "MathCaption",
 CellID->27348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "g"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->23199],

Cell[CellGroupData[{

Cell["Global`g", "Print", "PrintUsage",
 CellTags->"Info3370846881-4197688",
 CellID->66077366],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"g", "[", "x_", "]"}], ":=", 
         RowBox[{"1", "/;", 
          RowBox[{"x", ">", "0"}]}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"g", "[", "x_", "]"}], ":=", 
         RowBox[{
          RowBox[{"-", "1"}], "/;", 
          RowBox[{"x", "\[LessEqual]", "0"}]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["g"],
  Editable->False]], "Print",
 CellTags->"Info3370846881-4197688",
 CellID->458810059]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 " provides a way to choose between two alternatives. Often, however, there \
will be more than two alternatives. One way to handle this is to use a nested \
set of ",
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 " functions. Usually, however, it is instead better to use functions like ",
 Cell[BoxData[
  ButtonBox["Which",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Which"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Switch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Switch"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->8281],

Cell[TextData[{
 "This defines a function with three regions. Using ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " as the third test makes this the default case. "
}], "MathCaption",
 CellID->4734],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "x_", "]"}], ":=", 
  RowBox[{"Which", "[", 
   RowBox[{
    RowBox[{"x", "<", "0"}], ",", 
    RowBox[{"x", "^", "2"}], ",", 
    RowBox[{"x", ">", "5"}], ",", 
    RowBox[{"x", "^", "3"}], ",", "True", ",", "0"}], "]"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->53],

Cell[TextData[{
 "This uses the first case in the ",
 Cell[BoxData[
  ButtonBox["Which",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Which"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{"-", "5"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->26418],

Cell[BoxData["25"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1096143701]
}, Open  ]],

Cell["This uses the third case. ", "MathCaption",
 CellID->6900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", "2", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->3788],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->991687248]
}, Open  ]],

Cell[TextData[{
 "This defines a function that depends on the values of its argument modulo \
",
 Cell[BoxData["3"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->467],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "[", "x_", "]"}], ":=", 
  RowBox[{"Switch", "[", 
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{"x", ",", "3"}], "]"}], ",", "0", ",", "a", ",", "1", ",", "b", 
    ",", "2", ",", "c"}], "]"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->3728],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"], "[", 
   RowBox[{"7", ",", "3"}], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData["1"], "InlineFormula"],
 ", so this uses the second case in the ",
 Cell[BoxData[
  ButtonBox["Switch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Switch"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "[", "7", "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->24648],

Cell[BoxData["b"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->1677634165]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["17"], "InlineFormula"],
 " matches neither ",
 Cell[BoxData["0"], "InlineFormula"],
 " nor ",
 Cell[BoxData["1"], "InlineFormula"],
 ", but does match ",
 Cell[BoxData["_"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Switch", "[", 
  RowBox[{"17", ",", "0", ",", "a", ",", "1", ",", "b", ",", "_", ",", "q"}], 
  "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->2421],

Cell[BoxData["q"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->1083451271]
}, Open  ]],

Cell[TextData[{
 "An important point about symbolic systems such as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is that the conditions you give may yield neither ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " nor ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". Thus, for example, the condition ",
 Cell[BoxData[
  RowBox[{"x", "==", "y"}]], "InlineFormula"],
 " does not yield ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " unless ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 " have specific values, such as numerical ones. "
}], "Text",
 CellID->6617],

Cell[TextData[{
 "In this case, the test gives neither ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " nor ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", so both branches in the ",
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 " remain unevaluated. "
}], "MathCaption",
 CellID->22813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"x", "==", "y"}], ",", "a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->9514],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"x", "\[Equal]", "y"}], ",", "a", ",", "b"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->238627376]
}, Open  ]],

Cell[TextData[{
 "You can add a special fourth argument to ",
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 ", which is used if the test does not yield ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"x", "==", "y"}], ",", "a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->18935],

Cell[BoxData["c"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->90867912]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["If",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/If"], "[", 
     StyleBox["test", "TI"], ",", 
     StyleBox["then", "TI"], ",", 
     StyleBox["else", "TI"], ",", 
     StyleBox["unknown", "TI"], "]"}], Cell[TextData[{
     "a form of ",
     Cell[BoxData[
      ButtonBox["If",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/If"]], "InlineFormula"],
     " which includes the expression to use if ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " is neither ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " nor ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TrueQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TrueQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["lhs", "TI"], "===", 
     StyleBox["rhs", "TI"], Cell[" \[ThinSpace]or \[ThinSpace]", "TableText"],
      
     ButtonBox["SameQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SameQ"], "[", 
     StyleBox["lhs", "TI"], ",", 
     StyleBox["rhs", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " are identical, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["lhs", "TI"], "=!=", 
     StyleBox["rhs", "TI"], Cell[" \[ThinSpace]or \[ThinSpace]", "TableText"],
      
     ButtonBox["UnsameQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UnsameQ"], "[", 
     StyleBox["lhs", "TI"], ",", 
     StyleBox["rhs", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " are not identical, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MatchQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatchQ"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the pattern ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " matches ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", and give ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20600],

Cell["Functions for dealing with symbolic conditions. ", "Caption",
 CellID->5249],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " leaves this as a symbolic equation. "
}], "MathCaption",
 CellID->16519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "==", "y"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->31556],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", "y"}]], "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->1518186660]
}, Open  ]],

Cell[TextData[{
 "Unless ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is manifestly ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TrueQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrueQ"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " effectively assumes that ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrueQ", "[", 
  RowBox[{"x", "==", "y"}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->6224],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->1220191371]
}, Open  ]],

Cell[TextData[{
 "Unlike ",
 Cell[BoxData["=="], "InlineFormula"],
 ", ",
 Cell[BoxData["==="], "InlineFormula"],
 " tests whether two expressions are manifestly identical. In this case, they \
are not. "
}], "MathCaption",
 CellID->5844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "===", "y"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->32609],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->1584264026]
}, Open  ]],

Cell[TextData[{
 "The main difference between ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "===", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "==", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " is that ",
 Cell[BoxData["==="], "InlineFormula"],
 " always returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", whereas ",
 Cell[BoxData["=="], "InlineFormula"],
 " can leave its input in symbolic form, representing a symbolic equation, as \
discussed in \"",
 ButtonBox["Equations\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Equations"],
 ". You should typically use ",
 Cell[BoxData["==="], "InlineFormula"],
 " when you want to test the ",
 StyleBox["structure",
  FontSlant->"Italic"],
 " of an expression, and ",
 Cell[BoxData["=="], "InlineFormula"],
 " if you want to test mathematical equality. The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " pattern matcher effectively uses ",
 Cell[BoxData["==="], "InlineFormula"],
 " to determine when one literal expression matches another. "
}], "Text",
 CellID->32702],

Cell[TextData[{
 "You can use ",
 Cell[BoxData["==="], "InlineFormula"],
 " to test the structure of expressions. "
}], "MathCaption",
 CellID->3195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Head", "[", 
   RowBox[{"a", "+", "b", "+", "c"}], "]"}], "===", "Times"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->20485],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->1642744257]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["=="], "InlineFormula"],
 " operator gives a less useful result. "
}], "MathCaption",
 CellID->14343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Head", "[", 
   RowBox[{"a", "+", "b", "+", "c"}], "]"}], "==", "Times"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->30523],

Cell[BoxData[
 RowBox[{"Plus", "\[Equal]", "Times"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->1997871069]
}, Open  ]],

Cell[TextData[{
 "In setting up conditionals, you will often need to use combinations of \
tests, such as ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["test", "TI"], "1"], TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData["&&"], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["test", "TI"], "2"], TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  RowBox[{"&&", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 " ",
 ". An important point is that the result from this combination of tests will \
be ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " if ",
 StyleBox["any",
  FontSlant->"Italic"],
 " of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["test", "TI"], "i"], TraditionalForm]], "InlineMath"],
 " yield ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always evaluates the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["test", "TI"], "i"], TraditionalForm]], "InlineMath"],
 " in turn, stopping if any of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["test", "TI"], "i"], TraditionalForm]], "InlineMath"],
 " yield ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->29314],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], "1"], "&&", 
     SubscriptBox[
      StyleBox["expr", "TI"], "2"], "&&", 
     SubscriptBox[
      StyleBox["expr", "TI"], "3"]}], Cell[TextData[{
     "evaluate until one of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " is found to be ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], "1"], "||", 
     SubscriptBox[
      StyleBox["expr", "TI"], "2"], "||", 
     SubscriptBox[
      StyleBox["expr", "TI"], "3"]}], Cell[TextData[{
     "evaluate until one of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " is found to be ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9503],

Cell["Evaluation of logical expressions. ", "Caption",
 CellID->7448],

Cell["This function involves a combination of two tests. ", "MathCaption",
 CellID->25200],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "[", "x_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "!=", "0"}], "&&", 
    RowBox[{
     RowBox[{"1", "/", "x"}], "<", "3"}]}], ")"}]}]], "Input",
 CellLabel->"In[20]:=",
 CellID->13458],

Cell["Here both tests are evaluated. ", "MathCaption",
 CellID->6618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "[", "2", "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->20580],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->946531122]
}, Open  ]],

Cell[TextData[{
 "Here the first test yields ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", so the second test is not tried. The second test would involve ",
 Cell[BoxData[
  RowBox[{"1", "/", "0"}]], "InlineFormula"],
 ", and would generate an error. "
}], "MathCaption",
 CellID->14798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "[", "0", "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->15281],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->519964631]
}, Open  ]],

Cell[TextData[{
 "The way that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " evaluates logical expressions allows you to combine sequences of tests \
where later tests may make sense only if the earlier ones are satisfied. The \
behavior, which is analogous to that found in languages such as C, is \
convenient in constructing many kinds of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs. "
}], "Text",
 CellID->20798],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->441485544],

Cell[TextData[ButtonBox["Evaluation of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EvaluationOfExpressionsOverview"]], "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Conditionals - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Evaluation of Expressions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/EvaluationOfExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/EvaluationInIterationFunctions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/LoopsAndControlStructures"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 23.2802122}", "context" -> "", 
    "keywords" -> {
     "||", "&&", "=!=", "===", "/;", "And", "Boolean expressions", "Branch", 
      "Cases", "choose", "combinations of tests", "condition", "conditionals",
       "conditions", "definitions", "else", "equality testing", "equivalence",
       "evaluation", "False", "heads", "identical", "If", 
      "logical operations", "MatchQ", "mathematical equivalence", "Or", 
      "patterns", "piecewise functions", "rules", "SameQ", "step function", 
      "structural equivalence", "Switch", "symbolic conditions", 
      "symbolic systems", "test", "tests", "then", "threshold function", 
      "true", "TrueQ", "Truth values", "undetermined truth values", 
      "unknown truth values", "UnsameQ", "Which"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica provides various ways to set up conditionals, which specify \
that particular expressions should be evaluated only if certain conditions \
hold. Conditional constructs. The test gives False, so the 'else' expression \
y is returned. ", "synonyms" -> {"2.6.8"}, "title" -> "Conditionals", "type" -> 
    "Tutorial", "uri" -> "tutorial/Conditionals"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.6.9"->{
  Cell[2631, 69, 74, 2, 70, "Title",
   CellTags->{"S2.6.9", "9.1"},
   CellID->1655]},
 "9.1"->{
  Cell[2631, 69, 74, 2, 70, "Title",
   CellTags->{"S2.6.9", "9.1"},
   CellID->1655]},
 "Info3370846881-4197688"->{
  Cell[10914, 375, 95, 2, 70, "Print",
   CellTags->"Info3370846881-4197688",
   CellID->66077366],
  Cell[11012, 379, 1001, 31, 70, "Print",
   CellTags->"Info3370846881-4197688",
   CellID->458810059]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.6.9", 35606, 1299},
 {"9.1", 35704, 1303},
 {"Info3370846881-4197688", 35821, 1307}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2006, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2631, 69, 74, 2, 70, "Title",
 CellTags->{"S2.6.9", "9.1"},
 CellID->1655],
Cell[2708, 73, 283, 9, 70, "Text",
 CellID->17410],
Cell[2994, 84, 4514, 146, 70, "DefinitionBox",
 CellID->6359],
Cell[7511, 232, 59, 1, 70, "Caption",
 CellID->27624],
Cell[7573, 235, 377, 13, 70, "MathCaption",
 CellID->20537],
Cell[CellGroupData[{
Cell[7975, 252, 151, 5, 28, "Input",
 CellID->21548],
Cell[8129, 259, 158, 5, 36, "Output",
 CellID->634561841]
}, Open  ]],
Cell[8302, 267, 214, 6, 70, "MathCaption",
 CellID->27595],
Cell[CellGroupData[{
Cell[8541, 277, 216, 7, 70, "Input",
 CellID->4041],
Cell[8760, 286, 91, 2, 70, "Print",
 CellID->986527322]
}, Open  ]],
Cell[8866, 291, 621, 16, 70, "Text",
 CellID->24350],
Cell[9490, 309, 288, 11, 70, "MathCaption",
 CellID->10291],
Cell[9781, 322, 226, 8, 70, "Input",
 CellID->30836],
Cell[10010, 332, 169, 5, 70, "MathCaption",
 CellID->9374],
Cell[10182, 339, 166, 6, 70, "Input",
 CellID->11020],
Cell[10351, 347, 86, 1, 70, "MathCaption",
 CellID->4596],
Cell[10440, 350, 186, 7, 70, "Input",
 CellID->24021],
Cell[10629, 359, 152, 5, 70, "MathCaption",
 CellID->27348],
Cell[CellGroupData[{
Cell[10806, 368, 83, 3, 70, "Input",
 CellID->23199],
Cell[CellGroupData[{
Cell[10914, 375, 95, 2, 70, "Print",
 CellTags->"Info3370846881-4197688",
 CellID->66077366],
Cell[11012, 379, 1001, 31, 70, "Print",
 CellTags->"Info3370846881-4197688",
 CellID->458810059]
}, Open  ]]
}, Open  ]],
Cell[12040, 414, 764, 25, 70, "Text",
 CellID->8281],
Cell[12807, 441, 267, 8, 70, "MathCaption",
 CellID->4734],
Cell[13077, 451, 314, 10, 70, "Input",
 CellID->53],
Cell[13394, 463, 205, 8, 70, "MathCaption",
 CellID->1999],
Cell[CellGroupData[{
Cell[13624, 475, 111, 4, 70, "Input",
 CellID->26418],
Cell[13738, 481, 160, 5, 36, "Output",
 CellID->1096143701]
}, Open  ]],
Cell[13913, 489, 64, 1, 70, "MathCaption",
 CellID->6900],
Cell[CellGroupData[{
Cell[14002, 494, 92, 3, 70, "Input",
 CellID->3788],
Cell[14097, 499, 158, 5, 36, "Output",
 CellID->991687248]
}, Open  ]],
Cell[14270, 507, 173, 6, 70, "MathCaption",
 CellID->467],
Cell[14446, 515, 288, 9, 70, "Input",
 CellID->3728],
Cell[14737, 526, 425, 16, 70, "MathCaption",
 CellID->14893],
Cell[CellGroupData[{
Cell[15187, 546, 94, 3, 70, "Input",
 CellID->24648],
Cell[15284, 551, 160, 5, 36, "Output",
 CellID->1677634165]
}, Open  ]],
Cell[15459, 559, 263, 10, 70, "MathCaption",
 CellID->17807],
Cell[CellGroupData[{
Cell[15747, 573, 175, 5, 70, "Input",
 CellID->2421],
Cell[15925, 580, 160, 5, 36, "Output",
 CellID->1083451271]
}, Open  ]],
Cell[16100, 588, 942, 33, 70, "Text",
 CellID->6617],
Cell[17045, 623, 489, 18, 70, "MathCaption",
 CellID->22813],
Cell[CellGroupData[{
Cell[17559, 645, 152, 5, 70, "Input",
 CellID->9514],
Cell[17714, 652, 252, 8, 36, "Output",
 CellID->238627376]
}, Open  ]],
Cell[17981, 663, 489, 18, 70, "MathCaption",
 CellID->7616],
Cell[CellGroupData[{
Cell[18495, 685, 163, 5, 70, "Input",
 CellID->18935],
Cell[18661, 692, 158, 5, 36, "Output",
 CellID->90867912]
}, Open  ]],
Cell[18834, 700, 4283, 145, 70, "DefinitionBox",
 CellID->20600],
Cell[23120, 847, 82, 1, 70, "Caption",
 CellID->5249],
Cell[23205, 850, 140, 5, 70, "MathCaption",
 CellID->16519],
Cell[CellGroupData[{
Cell[23370, 859, 90, 3, 70, "Input",
 CellID->31556],
Cell[23463, 864, 189, 6, 36, "Output",
 CellID->1518186660]
}, Open  ]],
Cell[23667, 873, 646, 26, 70, "MathCaption",
 CellID->30303],
Cell[CellGroupData[{
Cell[24338, 903, 121, 4, 70, "Input",
 CellID->6224],
Cell[24462, 909, 164, 5, 36, "Output",
 CellID->1220191371]
}, Open  ]],
Cell[24641, 917, 238, 8, 70, "MathCaption",
 CellID->5844],
Cell[CellGroupData[{
Cell[24904, 929, 91, 3, 70, "Input",
 CellID->32609],
Cell[24998, 934, 164, 5, 36, "Output",
 CellID->1584264026]
}, Open  ]],
Cell[25177, 942, 1312, 44, 70, "Text",
 CellID->32702],
Cell[26492, 988, 149, 5, 70, "MathCaption",
 CellID->3195],
Cell[CellGroupData[{
Cell[26666, 997, 160, 5, 70, "Input",
 CellID->20485],
Cell[26829, 1004, 164, 5, 36, "Output",
 CellID->1642744257]
}, Open  ]],
Cell[27008, 1012, 140, 5, 70, "MathCaption",
 CellID->14343],
Cell[CellGroupData[{
Cell[27173, 1021, 159, 5, 70, "Input",
 CellID->30523],
Cell[27335, 1028, 196, 6, 36, "Output",
 CellID->1997871069]
}, Open  ]],
Cell[27546, 1037, 1480, 58, 70, "Text",
 CellID->29314],
Cell[29029, 1097, 1422, 47, 70, "DefinitionBox",
 CellID->9503],
Cell[30454, 1146, 69, 1, 70, "Caption",
 CellID->7448],
Cell[30526, 1149, 90, 1, 70, "MathCaption",
 CellID->25200],
Cell[30619, 1152, 244, 9, 70, "Input",
 CellID->13458],
Cell[30866, 1163, 69, 1, 70, "MathCaption",
 CellID->6618],
Cell[CellGroupData[{
Cell[30960, 1168, 94, 3, 70, "Input",
 CellID->20580],
Cell[31057, 1173, 162, 5, 36, "Output",
 CellID->946531122]
}, Open  ]],
Cell[31234, 1181, 361, 11, 70, "MathCaption",
 CellID->14798],
Cell[CellGroupData[{
Cell[31620, 1196, 94, 3, 70, "Input",
 CellID->15281],
Cell[31717, 1201, 163, 5, 36, "Output",
 CellID->519964631]
}, Open  ]],
Cell[31895, 1209, 445, 12, 70, "Text",
 CellID->20798],
Cell[CellGroupData[{
Cell[32365, 1225, 72, 1, 70, "RelatedTutorialsSection",
 CellID->441485544],
Cell[32440, 1228, 180, 4, 70, "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],
Cell[32647, 1236, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

