(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21226,        727]
NotebookOptionsPosition[     11794,        419]
NotebookOutlinePosition[     18104,        615]
CellTagsIndexPosition[     17757,        598]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
         "System Administration for Single-User Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]\
}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>", 
      2->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Configuration Files on Mac OS X", "Title",
 CellTags->"i:1",
 CellID->51646792],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stores preference settings and initialization data in two directories, ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 ". Within each of these directories are several possible subdirectories with \
titles such as FrontEnd, Kernel, and Licensing."
}], "Text",
 CellTags->{"i:10", "b:7.3"},
 CellID->193573205],

Cell[TextData[{
 "Global settings that affect all users are stored in subdirectories of the \
directory ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 ". The default value of ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 " on Mac OS X is /Library/Mathematica. To redefine the location of global \
preference settings and initialization data, set the environment variable \
MATHEMATICA_BASE."
}], "BulletedText",
 CellTags->{"b:7.3", "i:2"},
 CellID->252663996],

Cell[CellGroupData[{

Cell[TextData[{
 "Settings that only affect a particular user are stored in subdirectories of \
the directory ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 ", which is typically a subdirectory of the user\[CloseCurlyQuote]s home \
directory. The default value of ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 " on Mac OS X is ~/Library/Mathematica. To redefine the location of user \
preferences and initialization data, set the environment variable \
MATHEMATICA_USERBASE."
}], "BulletedText",
 CellTags->{"b:7.3", "i:3"},
 CellID->924159708],

Cell[TextData[{
 "Settings in the directory ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 " override global settings defined in the directory ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:7.3",
 CellID->213504546],

Cell[TextData[{
 "In the pathnames that follow, replace the variables ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 " with the appropriate directories for your system. To find their locations \
on your system, evaluate the command ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 " (or ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 ") in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook."
}], "Text",
 CellTags->"b:7.3",
 CellID->515351419]
}, Open  ]],

Cell[CellGroupData[{

Cell["Kernel", "Section",
 CellTags->{"i:13", "b:7.3", "net: 2"},
 CellID->20390899],

Cell[TextData[{
 "The initialization files used by the kernel contain ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands that are evaluated at startup, such as function definitions, \
packages to load, or kernel option settings. These commands are also",
 " ",
 "available to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end. "
}], "Text",
 CellTags->"b:7.3",
 CellID->104494566],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 "/Kernel/init.m"
}], "IndentedText",
 CellTags->"b:7.3",
 CellID->167131046],

Cell["\<\
This file is used to initialize the kernel and therefore should store any \
kernel commands that are appropriate for all users running the kernel. \
\>", "ItemizedTextParagraph",
 CellTags->"b:7.3",
 CellID->239117450],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 "/Kernel/init.m"
}], "IndentedText",
 CellTags->"b:7.3",
 CellID->343954288],

Cell[CellGroupData[{

Cell["\<\
This file stores user-specific commands used to initialize the kernel. \
\>", "ItemizedTextParagraph",
 CellTags->"b:7.3",
 CellID->3054303],

Cell["Kernel initialization files are not created automatically.", "Text",
 CellTags->"b:7.3",
 CellID->153985664]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Front End", "Section",
 CellTags->{"i:12", "b:7.3", "net: 3"},
 CellID->112250068],

Cell[TextData[{
 "Front end initialization files store preference settings such as the values \
of global options in the Option Inspector. These files are automatically \
updated by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " when you change a setting in the front end. To make changes to this \
file,",
 " ",
 "make your changes from within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " rather than editing the file directly."
}], "Text",
 CellTags->"b:7.3",
 CellID->130731558],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 "/FrontEnd/init.m"
}], "IndentedText",
 CellTags->"b:7.3",
 CellID->137167314],

Cell[TextData[{
 "This file stores systemwide defaults used by all ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front ends. The settings in this file affect all users. ",
 ButtonBox["Systemwide Defaults on Mac OS X",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SystemwideDefaultsOnMacOSX"],
 " explains how to implement changes to this global file."
}], "ItemizedTextParagraph",
 CellTags->"b:7.3",
 CellID->296865362],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 "/FrontEnd/init.m"
}], "IndentedText",
 CellTags->"b:7.3",
 CellID->449367215],

Cell["\<\
This file defines settings within the front end that are specific to each \
user. \
\>", "ItemizedTextParagraph",
 CellTags->"b:7.3",
 CellID->164334771],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 "/FrontEnd/6.0 Caches/"
}], "IndentedText",
 CellTags->{"i:11", "b:7.3"},
 CellID->16836672],

Cell[CellGroupData[{

Cell["\<\
This directory within the user\[CloseCurlyQuote]s home directory stores \
information on system settings that are read by the front end. \
\>", "ItemizedTextParagraph",
 CellTags->"b:7.3",
 CellID->529328205],

Cell["Front end initialization files are created automatically.", "Text",
 CellTags->"b:7.3",
 CellID->79829937]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Passwords", "Section",
 CellTags->{"i:14", "b:7.3", "net: 4"},
 CellID->632029800],

Cell[TextData[{
 "Passwords are stored in the mathpass file, described in further detail in \
\"",
 ButtonBox["Registration and Passwords\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/RegistrationAndPasswords"],
 ". In the following pathname, replace the variable ",
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 " with the directory where you installed ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". To find the value of ",
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 " on your system, evaluate the command ",
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 " in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook."
}], "Text",
 CellTags->{"i:21", "b:7.3"},
 CellID->1030556305],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 "/Licensing/mathpass"
}], "IndentedText",
 CellTags->"b:7.3",
 CellID->350574590],

Cell["This is the default location for the global password file. ", \
"ItemizedTextParagraph",
 CellTags->"b:7.3",
 CellID->48710416],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 "/Configuration/Licensing/mathpass"
}], "IndentedText",
 CellTags->"b:7.3",
 CellID->99006380],

Cell["\<\
This is an alternative location for the global password file. \
\>", "ItemizedTextParagraph",
 CellTags->"b:7.3",
 CellID->488073648],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 "/Licensing/mathpass"
}], "IndentedText",
 CellTags->"b:7.3",
 CellID->19715165],

Cell["\<\
While this is not normally the location for the password file, a \
user-specific mathpass file can be stored here. \
\>", "ItemizedTextParagraph",
 CellTags->"b:7.3",
 CellID->7909769],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->422401447],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Configuration Files on Mac OS X - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 24.4208664}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica stores preference settings and initialization data in two \
directories, $BaseDirectory and $UserBaseDirectory. Within each of these \
directories are several possible subdirectories with titles such as FrontEnd, \
Kernel, and Licensing. Settings in the directory $UserBaseDirectory override \
global settings defined in the directory $BaseDirectory. In the pathnames \
that follow, replace the variables $BaseDirectory and $UserBaseDirectory with \
the appropriate directories for your system. To find their locations on your \
system, evaluate the command $BaseDirectory (or $UserBaseDirectory) in a \
Mathematica notebook.", "synonyms" -> {}, "title" -> 
    "Configuration Files on Mac OS X", "type" -> "Tutorial", "uri" -> 
    "tutorial/ConfigurationFilesOnMacOSX"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "i:1"->{
  Cell[1565, 48, 85, 2, 70, "Title",
   CellTags->"i:1",
   CellID->51646792]},
 "i:10"->{
  Cell[1653, 52, 612, 17, 70, "Text",
   CellTags->{"i:10", "b:7.3"},
   CellID->193573205]},
 "b:7.3"->{
  Cell[1653, 52, 612, 17, 70, "Text",
   CellTags->{"i:10", "b:7.3"},
   CellID->193573205],
  Cell[2268, 71, 637, 17, 70, "BulletedText",
   CellTags->{"b:7.3", "i:2"},
   CellID->252663996],
  Cell[2930, 92, 737, 18, 70, "BulletedText",
   CellTags->{"b:7.3", "i:3"},
   CellID->924159708],
  Cell[3670, 112, 429, 14, 70, "Text",
   CellTags->"b:7.3",
   CellID->213504546],
  Cell[4102, 128, 878, 28, 70, "Text",
   CellTags->"b:7.3",
   CellID->515351419],
  Cell[5017, 161, 84, 2, 70, "Section",
   CellTags->{"i:13", "b:7.3", "net: 2"},
   CellID->20390899],
  Cell[5104, 165, 412, 13, 70, "Text",
   CellTags->"b:7.3",
   CellID->104494566],
  Cell[5519, 180, 224, 8, 70, "IndentedText",
   CellTags->"b:7.3",
   CellID->167131046],
  Cell[5746, 190, 228, 5, 70, "ItemizedTextParagraph",
   CellTags->"b:7.3",
   CellID->239117450],
  Cell[5977, 197, 232, 8, 70, "IndentedText",
   CellTags->"b:7.3",
   CellID->343954288],
  Cell[6234, 209, 150, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:7.3",
   CellID->3054303],
  Cell[6387, 215, 114, 2, 70, "Text",
   CellTags->"b:7.3",
   CellID->153985664],
  Cell[6550, 223, 88, 2, 70, "Section",
   CellTags->{"i:12", "b:7.3", "net: 3"},
   CellID->112250068],
  Cell[6641, 227, 499, 15, 70, "Text",
   CellTags->"b:7.3",
   CellID->130731558],
  Cell[7143, 244, 226, 8, 70, "IndentedText",
   CellTags->"b:7.3",
   CellID->137167314],
  Cell[7372, 254, 436, 11, 70, "ItemizedTextParagraph",
   CellTags->"b:7.3",
   CellID->296865362],
  Cell[7811, 267, 234, 8, 70, "IndentedText",
   CellTags->"b:7.3",
   CellID->449367215],
  Cell[8048, 277, 163, 5, 70, "ItemizedTextParagraph",
   CellTags->"b:7.3",
   CellID->164334771],
  Cell[8214, 284, 248, 8, 70, "IndentedText",
   CellTags->{"i:11", "b:7.3"},
   CellID->16836672],
  Cell[8487, 296, 218, 5, 70, "ItemizedTextParagraph",
   CellTags->"b:7.3",
   CellID->529328205],
  Cell[8708, 303, 112, 2, 70, "Text",
   CellTags->"b:7.3",
   CellID->79829937],
  Cell[8869, 311, 88, 2, 70, "Section",
   CellTags->{"i:14", "b:7.3", "net: 4"},
   CellID->632029800],
  Cell[8960, 315, 1019, 30, 70, "Text",
   CellTags->{"i:21", "b:7.3"},
   CellID->1030556305],
  Cell[9982, 347, 229, 8, 70, "IndentedText",
   CellTags->"b:7.3",
   CellID->350574590],
  Cell[10214, 357, 133, 3, 70, "ItemizedTextParagraph",
   CellTags->"b:7.3",
   CellID->48710416],
  Cell[10350, 362, 258, 8, 70, "IndentedText",
   CellTags->"b:7.3",
   CellID->99006380],
  Cell[10611, 372, 143, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:7.3",
   CellID->488073648],
  Cell[10757, 378, 236, 8, 70, "IndentedText",
   CellTags->"b:7.3",
   CellID->19715165],
  Cell[10996, 388, 194, 5, 70, "ItemizedTextParagraph",
   CellTags->"b:7.3",
   CellID->7909769]},
 "i:2"->{
  Cell[2268, 71, 637, 17, 70, "BulletedText",
   CellTags->{"b:7.3", "i:2"},
   CellID->252663996]},
 "i:3"->{
  Cell[2930, 92, 737, 18, 70, "BulletedText",
   CellTags->{"b:7.3", "i:3"},
   CellID->924159708]},
 "i:13"->{
  Cell[5017, 161, 84, 2, 70, "Section",
   CellTags->{"i:13", "b:7.3", "net: 2"},
   CellID->20390899]},
 "net: 2"->{
  Cell[5017, 161, 84, 2, 70, "Section",
   CellTags->{"i:13", "b:7.3", "net: 2"},
   CellID->20390899]},
 "i:12"->{
  Cell[6550, 223, 88, 2, 70, "Section",
   CellTags->{"i:12", "b:7.3", "net: 3"},
   CellID->112250068]},
 "net: 3"->{
  Cell[6550, 223, 88, 2, 70, "Section",
   CellTags->{"i:12", "b:7.3", "net: 3"},
   CellID->112250068]},
 "i:11"->{
  Cell[8214, 284, 248, 8, 70, "IndentedText",
   CellTags->{"i:11", "b:7.3"},
   CellID->16836672]},
 "i:14"->{
  Cell[8869, 311, 88, 2, 70, "Section",
   CellTags->{"i:14", "b:7.3", "net: 4"},
   CellID->632029800]},
 "net: 4"->{
  Cell[8869, 311, 88, 2, 70, "Section",
   CellTags->{"i:14", "b:7.3", "net: 4"},
   CellID->632029800]},
 "i:21"->{
  Cell[8960, 315, 1019, 30, 70, "Text",
   CellTags->{"i:21", "b:7.3"},
   CellID->1030556305]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"i:1", 13648, 459},
 {"i:10", 13739, 463},
 {"b:7.3", 13845, 467},
 {"i:2", 16596, 555},
 {"i:3", 16707, 559},
 {"i:13", 16819, 563},
 {"net: 2", 16937, 567},
 {"i:12", 17053, 571},
 {"net: 3", 17172, 575},
 {"i:11", 17289, 579},
 {"i:14", 17401, 583},
 {"net: 4", 17520, 587},
 {"i:21", 17637, 591}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 940, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1565, 48, 85, 2, 70, "Title",
 CellTags->"i:1",
 CellID->51646792],
Cell[1653, 52, 612, 17, 70, "Text",
 CellTags->{"i:10", "b:7.3"},
 CellID->193573205],
Cell[2268, 71, 637, 17, 70, "BulletedText",
 CellTags->{"b:7.3", "i:2"},
 CellID->252663996],
Cell[CellGroupData[{
Cell[2930, 92, 737, 18, 70, "BulletedText",
 CellTags->{"b:7.3", "i:3"},
 CellID->924159708],
Cell[3670, 112, 429, 14, 70, "Text",
 CellTags->"b:7.3",
 CellID->213504546],
Cell[4102, 128, 878, 28, 70, "Text",
 CellTags->"b:7.3",
 CellID->515351419]
}, Open  ]],
Cell[CellGroupData[{
Cell[5017, 161, 84, 2, 70, "Section",
 CellTags->{"i:13", "b:7.3", "net: 2"},
 CellID->20390899],
Cell[5104, 165, 412, 13, 70, "Text",
 CellTags->"b:7.3",
 CellID->104494566],
Cell[5519, 180, 224, 8, 70, "IndentedText",
 CellTags->"b:7.3",
 CellID->167131046],
Cell[5746, 190, 228, 5, 70, "ItemizedTextParagraph",
 CellTags->"b:7.3",
 CellID->239117450],
Cell[5977, 197, 232, 8, 70, "IndentedText",
 CellTags->"b:7.3",
 CellID->343954288],
Cell[CellGroupData[{
Cell[6234, 209, 150, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:7.3",
 CellID->3054303],
Cell[6387, 215, 114, 2, 70, "Text",
 CellTags->"b:7.3",
 CellID->153985664]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6550, 223, 88, 2, 70, "Section",
 CellTags->{"i:12", "b:7.3", "net: 3"},
 CellID->112250068],
Cell[6641, 227, 499, 15, 70, "Text",
 CellTags->"b:7.3",
 CellID->130731558],
Cell[7143, 244, 226, 8, 70, "IndentedText",
 CellTags->"b:7.3",
 CellID->137167314],
Cell[7372, 254, 436, 11, 70, "ItemizedTextParagraph",
 CellTags->"b:7.3",
 CellID->296865362],
Cell[7811, 267, 234, 8, 70, "IndentedText",
 CellTags->"b:7.3",
 CellID->449367215],
Cell[8048, 277, 163, 5, 70, "ItemizedTextParagraph",
 CellTags->"b:7.3",
 CellID->164334771],
Cell[8214, 284, 248, 8, 70, "IndentedText",
 CellTags->{"i:11", "b:7.3"},
 CellID->16836672],
Cell[CellGroupData[{
Cell[8487, 296, 218, 5, 70, "ItemizedTextParagraph",
 CellTags->"b:7.3",
 CellID->529328205],
Cell[8708, 303, 112, 2, 70, "Text",
 CellTags->"b:7.3",
 CellID->79829937]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8869, 311, 88, 2, 70, "Section",
 CellTags->{"i:14", "b:7.3", "net: 4"},
 CellID->632029800],
Cell[8960, 315, 1019, 30, 70, "Text",
 CellTags->{"i:21", "b:7.3"},
 CellID->1030556305],
Cell[9982, 347, 229, 8, 70, "IndentedText",
 CellTags->"b:7.3",
 CellID->350574590],
Cell[10214, 357, 133, 3, 70, "ItemizedTextParagraph",
 CellTags->"b:7.3",
 CellID->48710416],
Cell[10350, 362, 258, 8, 70, "IndentedText",
 CellTags->"b:7.3",
 CellID->99006380],
Cell[10611, 372, 143, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:7.3",
 CellID->488073648],
Cell[10757, 378, 236, 8, 70, "IndentedText",
 CellTags->"b:7.3",
 CellID->19715165],
Cell[10996, 388, 194, 5, 70, "ItemizedTextParagraph",
 CellTags->"b:7.3",
 CellID->7909769],
Cell[CellGroupData[{
Cell[11215, 397, 72, 1, 70, "RelatedTutorialsSection",
 CellID->422401447],
Cell[11290, 400, 214, 5, 70, "RelatedTutorials",
 CellID->13855348],
Cell[11507, 407, 221, 5, 70, "RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[11767, 417, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

