(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21632,        746]
NotebookOptionsPosition[     12182,        438]
NotebookOutlinePosition[     18510,        634]
CellTagsIndexPosition[     18163,        617]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
         "System Administration for Single-User Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]\
}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>", 
      2->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Configuration Files on Unix and Linux", "Title",
 CellTags->"i:1",
 CellID->3790618],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stores preference settings and initialization data in two directories, ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 ". Within each of these directories are several possible subdirectories with \
titles such as ",
 "FrontEnd",
 ", ",
 "Kernel",
 ", and ",
 "Licensing",
 "."
}], "Text",
 CellTags->{"i:20", "b:6.3"},
 CellID->4325511],

Cell[TextData[{
 "Global settings that affect all users are stored in subdirectories of the \
directory ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 ". The default value of ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 " on Unix and Linux is ",
 "/usr/share/Mathematica",
 ". To redefine the location of global preference settings and initialization \
data, set the environment variable MATHEMATICA_BASE."
}], "BulletedText",
 CellTags->{"b:6.3", "i:2"},
 CellID->822691248],

Cell[CellGroupData[{

Cell[TextData[{
 "Settings that only affect a particular user are stored in subdirectories of \
the directory ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 ", which is typically a subdirectory of the user\[CloseCurlyQuote]s home \
directory. The default value of ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 " on Unix and Linux is ",
 "~/.Mathematica",
 ". To redefine the location of user preferences and initialization data, set \
the environment variable MATHEMATICA_USERBASE."
}], "BulletedText",
 CellTags->{"b:6.3", "i:3"},
 CellID->69268605],

Cell[TextData[{
 "Settings in the directory ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 " override global settings defined in the directory ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:6.3",
 CellID->99474321],

Cell[TextData[{
 "In the pathnames that follow, replace the variables ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 " with the appropriate directories for your system. To find their locations \
on your system, evaluate the command ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 " (or ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 ") in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook."
}], "Text",
 CellTags->"b:6.3",
 CellID->383527263]
}, Open  ]],

Cell[CellGroupData[{

Cell["Kernel", "Section",
 CellTags->{"i:21", "b:6.3", "net: 2"},
 CellID->105445989],

Cell[TextData[{
 "The initialization files used by the kernel contain ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands that are evaluated at startup, such as function definitions, \
packages to load, or kernel option settings. These commands are also",
 " ",
 "available to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end."
}], "Text",
 CellTags->"b:6.3",
 CellID->573275514],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 "/Kernel/init.m"
}], "IndentedText",
 CellTags->"b:6.3",
 CellID->180747481],

Cell["\<\
This file is used to initialize the kernel and therefore should store any \
kernel commands that are appropriate for all users running the kernel.\
\>", "ItemizedTextParagraph",
 CellTags->"b:6.3",
 CellID->273026856],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 "/Kernel/init.m"
}], "IndentedText",
 CellTags->"b:6.3",
 CellID->231921661],

Cell[CellGroupData[{

Cell["\<\
This file stores user-specific commands used to initialize the kernel. \
\>", "ItemizedTextParagraph",
 CellTags->"b:6.3",
 CellID->39182319],

Cell["Kernel initialization files are not created automatically.", "Text",
 CellTags->"b:6.3",
 CellID->9346801]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Front End", "Section",
 CellTags->{"i:19", "b:6.3", "net: 3"},
 CellID->517351936],

Cell[TextData[{
 "Front end initialization files store preference settings such as the values \
of global options in the Option Inspector. These files are automatically \
updated by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " when you change a setting in the front end. To make changes to this \
file,",
 " ",
 "make your changes from within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " rather than editing the file directly."
}], "Text",
 CellTags->"b:6.3",
 CellID->671474262],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 "/FrontEnd/init.m"
}], "IndentedText",
 CellTags->"b:6.3",
 CellID->544995252],

Cell[TextData[{
 "This file stores systemwide defaults used by all ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front ends. The settings in this file affect all users. ",
 ButtonBox["Systemwide Defaults on Unix and Linux",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SystemwideDefaultsOnUnixAndLinux"],
 " explains how to implement changes to this global file."
}], "ItemizedTextParagraph",
 CellTags->"b:6.3",
 CellID->133884703],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 "/FrontEnd/init.m"
}], "IndentedText",
 CellTags->"b:6.3",
 CellID->197561477],

Cell["\<\
This file defines settings within the front end that are specific to each \
user. \
\>", "ItemizedTextParagraph",
 CellTags->"b:6.3",
 CellID->486006717],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 "/FrontEnd/6.0_Caches/"
}], "IndentedText",
 CellTags->{"i:17", "b:6.3"},
 CellID->621955155],

Cell[CellGroupData[{

Cell["\<\
This directory within the user\[CloseCurlyQuote]s home directory stores \
information on system settings that are read by the front end.\
\>", "ItemizedTextParagraph",
 CellTags->"b:6.3",
 CellID->151914420],

Cell["Front end initialization files are created automatically.", "Text",
 CellTags->"b:6.3",
 CellID->440560516]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Passwords", "Section",
 CellTags->{"i:22", "b:6.3", "net: 4"},
 CellID->331489403],

Cell[TextData[{
 "Passwords are stored in the ",
 StyleBox["mathpass", "InlineCode"],
 " file, described in further detail in \"",
 ButtonBox["Registration and Passwords\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/RegistrationAndPasswords"],
 ". In the following pathname, replace the variable ",
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 " with the directory where you installed ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The default value of ",
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 " on Unix and Linux is ",
 "/usr/local/Wolfram/Mathematica/6.0",
 ". To find the value of ",
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 " on your system, evaluate the command ",
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 " in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook."
}], "Text",
 CellTags->{"i:46", "b:6.3"},
 CellID->165555612],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 "/Licensing/mathpass"
}], "IndentedText",
 CellTags->"b:6.3",
 CellID->189956533],

Cell["This is the default location for the global password file. ", \
"ItemizedTextParagraph",
 CellTags->"b:6.3",
 CellID->270166126],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 "/Configuration/Licensing/mathpass"
}], "IndentedText",
 CellTags->"b:6.3",
 CellID->305749283],

Cell["\<\
This is an alternative location for the global password file. \
\>", "ItemizedTextParagraph",
 CellTags->"b:6.3",
 CellID->492726723],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 "/Licensing/mathpass"
}], "IndentedText",
 CellTags->"b:6.3",
 CellID->196356382],

Cell[TextData[{
 "While this is not normally the location for the password file, a",
 " ",
 "user-specific ",
 StyleBox["mathpass", "InlineCode"],
 " file can be stored here."
}], "ItemizedTextParagraph",
 CellTags->"b:6.3",
 CellID->81063374],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->64115994],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Configuration Files on Unix and Linux - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 24.7646252}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica stores preference settings and initialization data in two \
directories, $BaseDirectory and $UserBaseDirectory. Within each of these \
directories are several possible subdirectories with titles such as FrontEnd, \
Kernel, and Licensing. Settings in the directory $UserBaseDirectory override \
global settings defined in the directory $BaseDirectory. In the pathnames \
that follow, replace the variables $BaseDirectory and $UserBaseDirectory with \
the appropriate directories for your system. To find their locations on your \
system, evaluate the command $BaseDirectory (or $UserBaseDirectory) in a \
Mathematica notebook.", "synonyms" -> {}, "title" -> 
    "Configuration Files on Unix and Linux", "type" -> "Tutorial", "uri" -> 
    "tutorial/ConfigurationFilesOnUnixAndLinux"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "i:1"->{
  Cell[1565, 48, 90, 2, 70, "Title",
   CellTags->"i:1",
   CellID->3790618]},
 "i:20"->{
  Cell[1658, 52, 640, 23, 70, "Text",
   CellTags->{"i:20", "b:6.3"},
   CellID->4325511]},
 "b:6.3"->{
  Cell[1658, 52, 640, 23, 70, "Text",
   CellTags->{"i:20", "b:6.3"},
   CellID->4325511],
  Cell[2301, 77, 653, 18, 70, "BulletedText",
   CellTags->{"b:6.3", "i:2"},
   CellID->822691248],
  Cell[2979, 99, 743, 19, 70, "BulletedText",
   CellTags->{"b:6.3", "i:3"},
   CellID->69268605],
  Cell[3725, 120, 428, 14, 70, "Text",
   CellTags->"b:6.3",
   CellID->99474321],
  Cell[4156, 136, 878, 28, 70, "Text",
   CellTags->"b:6.3",
   CellID->383527263],
  Cell[5071, 169, 85, 2, 70, "Section",
   CellTags->{"i:21", "b:6.3", "net: 2"},
   CellID->105445989],
  Cell[5159, 173, 411, 13, 70, "Text",
   CellTags->"b:6.3",
   CellID->573275514],
  Cell[5573, 188, 224, 8, 70, "IndentedText",
   CellTags->"b:6.3",
   CellID->180747481],
  Cell[5800, 198, 227, 5, 70, "ItemizedTextParagraph",
   CellTags->"b:6.3",
   CellID->273026856],
  Cell[6030, 205, 232, 8, 70, "IndentedText",
   CellTags->"b:6.3",
   CellID->231921661],
  Cell[6287, 217, 151, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:6.3",
   CellID->39182319],
  Cell[6441, 223, 112, 2, 70, "Text",
   CellTags->"b:6.3",
   CellID->9346801],
  Cell[6602, 231, 88, 2, 70, "Section",
   CellTags->{"i:19", "b:6.3", "net: 3"},
   CellID->517351936],
  Cell[6693, 235, 499, 15, 70, "Text",
   CellTags->"b:6.3",
   CellID->671474262],
  Cell[7195, 252, 226, 8, 70, "IndentedText",
   CellTags->"b:6.3",
   CellID->544995252],
  Cell[7424, 262, 448, 11, 70, "ItemizedTextParagraph",
   CellTags->"b:6.3",
   CellID->133884703],
  Cell[7875, 275, 234, 8, 70, "IndentedText",
   CellTags->"b:6.3",
   CellID->197561477],
  Cell[8112, 285, 163, 5, 70, "ItemizedTextParagraph",
   CellTags->"b:6.3",
   CellID->486006717],
  Cell[8278, 292, 249, 8, 70, "IndentedText",
   CellTags->{"i:17", "b:6.3"},
   CellID->621955155],
  Cell[8552, 304, 217, 5, 70, "ItemizedTextParagraph",
   CellTags->"b:6.3",
   CellID->151914420],
  Cell[8772, 311, 113, 2, 70, "Text",
   CellTags->"b:6.3",
   CellID->440560516],
  Cell[8934, 319, 88, 2, 70, "Section",
   CellTags->{"i:22", "b:6.3", "net: 4"},
   CellID->331489403],
  Cell[9025, 323, 1291, 38, 70, "Text",
   CellTags->{"i:46", "b:6.3"},
   CellID->165555612],
  Cell[10319, 363, 229, 8, 70, "IndentedText",
   CellTags->"b:6.3",
   CellID->189956533],
  Cell[10551, 373, 134, 3, 70, "ItemizedTextParagraph",
   CellTags->"b:6.3",
   CellID->270166126],
  Cell[10688, 378, 259, 8, 70, "IndentedText",
   CellTags->"b:6.3",
   CellID->305749283],
  Cell[10950, 388, 143, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:6.3",
   CellID->492726723],
  Cell[11096, 394, 237, 8, 70, "IndentedText",
   CellTags->"b:6.3",
   CellID->196356382],
  Cell[11336, 404, 243, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:6.3",
   CellID->81063374]},
 "i:2"->{
  Cell[2301, 77, 653, 18, 70, "BulletedText",
   CellTags->{"b:6.3", "i:2"},
   CellID->822691248]},
 "i:3"->{
  Cell[2979, 99, 743, 19, 70, "BulletedText",
   CellTags->{"b:6.3", "i:3"},
   CellID->69268605]},
 "i:21"->{
  Cell[5071, 169, 85, 2, 70, "Section",
   CellTags->{"i:21", "b:6.3", "net: 2"},
   CellID->105445989]},
 "net: 2"->{
  Cell[5071, 169, 85, 2, 70, "Section",
   CellTags->{"i:21", "b:6.3", "net: 2"},
   CellID->105445989]},
 "i:19"->{
  Cell[6602, 231, 88, 2, 70, "Section",
   CellTags->{"i:19", "b:6.3", "net: 3"},
   CellID->517351936]},
 "net: 3"->{
  Cell[6602, 231, 88, 2, 70, "Section",
   CellTags->{"i:19", "b:6.3", "net: 3"},
   CellID->517351936]},
 "i:17"->{
  Cell[8278, 292, 249, 8, 70, "IndentedText",
   CellTags->{"i:17", "b:6.3"},
   CellID->621955155]},
 "i:22"->{
  Cell[8934, 319, 88, 2, 70, "Section",
   CellTags->{"i:22", "b:6.3", "net: 4"},
   CellID->331489403]},
 "net: 4"->{
  Cell[8934, 319, 88, 2, 70, "Section",
   CellTags->{"i:22", "b:6.3", "net: 4"},
   CellID->331489403]},
 "i:46"->{
  Cell[9025, 323, 1291, 38, 70, "Text",
   CellTags->{"i:46", "b:6.3"},
   CellID->165555612]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"i:1", 14054, 478},
 {"i:20", 14144, 482},
 {"b:6.3", 14248, 486},
 {"i:2", 17001, 574},
 {"i:3", 17112, 578},
 {"i:21", 17223, 582},
 {"net: 2", 17342, 586},
 {"i:19", 17459, 590},
 {"net: 3", 17578, 594},
 {"i:17", 17695, 598},
 {"i:22", 17808, 602},
 {"net: 4", 17927, 606},
 {"i:46", 18044, 610}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 940, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1565, 48, 90, 2, 70, "Title",
 CellTags->"i:1",
 CellID->3790618],
Cell[1658, 52, 640, 23, 70, "Text",
 CellTags->{"i:20", "b:6.3"},
 CellID->4325511],
Cell[2301, 77, 653, 18, 70, "BulletedText",
 CellTags->{"b:6.3", "i:2"},
 CellID->822691248],
Cell[CellGroupData[{
Cell[2979, 99, 743, 19, 70, "BulletedText",
 CellTags->{"b:6.3", "i:3"},
 CellID->69268605],
Cell[3725, 120, 428, 14, 70, "Text",
 CellTags->"b:6.3",
 CellID->99474321],
Cell[4156, 136, 878, 28, 70, "Text",
 CellTags->"b:6.3",
 CellID->383527263]
}, Open  ]],
Cell[CellGroupData[{
Cell[5071, 169, 85, 2, 70, "Section",
 CellTags->{"i:21", "b:6.3", "net: 2"},
 CellID->105445989],
Cell[5159, 173, 411, 13, 70, "Text",
 CellTags->"b:6.3",
 CellID->573275514],
Cell[5573, 188, 224, 8, 70, "IndentedText",
 CellTags->"b:6.3",
 CellID->180747481],
Cell[5800, 198, 227, 5, 70, "ItemizedTextParagraph",
 CellTags->"b:6.3",
 CellID->273026856],
Cell[6030, 205, 232, 8, 70, "IndentedText",
 CellTags->"b:6.3",
 CellID->231921661],
Cell[CellGroupData[{
Cell[6287, 217, 151, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:6.3",
 CellID->39182319],
Cell[6441, 223, 112, 2, 70, "Text",
 CellTags->"b:6.3",
 CellID->9346801]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6602, 231, 88, 2, 70, "Section",
 CellTags->{"i:19", "b:6.3", "net: 3"},
 CellID->517351936],
Cell[6693, 235, 499, 15, 70, "Text",
 CellTags->"b:6.3",
 CellID->671474262],
Cell[7195, 252, 226, 8, 70, "IndentedText",
 CellTags->"b:6.3",
 CellID->544995252],
Cell[7424, 262, 448, 11, 70, "ItemizedTextParagraph",
 CellTags->"b:6.3",
 CellID->133884703],
Cell[7875, 275, 234, 8, 70, "IndentedText",
 CellTags->"b:6.3",
 CellID->197561477],
Cell[8112, 285, 163, 5, 70, "ItemizedTextParagraph",
 CellTags->"b:6.3",
 CellID->486006717],
Cell[8278, 292, 249, 8, 70, "IndentedText",
 CellTags->{"i:17", "b:6.3"},
 CellID->621955155],
Cell[CellGroupData[{
Cell[8552, 304, 217, 5, 70, "ItemizedTextParagraph",
 CellTags->"b:6.3",
 CellID->151914420],
Cell[8772, 311, 113, 2, 70, "Text",
 CellTags->"b:6.3",
 CellID->440560516]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8934, 319, 88, 2, 70, "Section",
 CellTags->{"i:22", "b:6.3", "net: 4"},
 CellID->331489403],
Cell[9025, 323, 1291, 38, 70, "Text",
 CellTags->{"i:46", "b:6.3"},
 CellID->165555612],
Cell[10319, 363, 229, 8, 70, "IndentedText",
 CellTags->"b:6.3",
 CellID->189956533],
Cell[10551, 373, 134, 3, 70, "ItemizedTextParagraph",
 CellTags->"b:6.3",
 CellID->270166126],
Cell[10688, 378, 259, 8, 70, "IndentedText",
 CellTags->"b:6.3",
 CellID->305749283],
Cell[10950, 388, 143, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:6.3",
 CellID->492726723],
Cell[11096, 394, 237, 8, 70, "IndentedText",
 CellTags->"b:6.3",
 CellID->196356382],
Cell[11336, 404, 243, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:6.3",
 CellID->81063374],
Cell[CellGroupData[{
Cell[11604, 416, 71, 1, 70, "RelatedTutorialsSection",
 CellID->64115994],
Cell[11678, 419, 214, 5, 70, "RelatedTutorials",
 CellID->13855348],
Cell[11895, 426, 221, 5, 70, "RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[12155, 436, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

