(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25187,        854]
NotebookOptionsPosition[     14544,        504]
NotebookOutlinePosition[     21596,        724]
CellTagsIndexPosition[     21246,        707]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
         "System Administration for Single-User Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]\
}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>", 
      2->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Configuration Files on Windows", "Title",
 CellTags->"i:2",
 CellID->100067327],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stores preference settings and initialization data in two directories, ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 ". Within each of these directories are several possible subdirectories with \
titles such as FrontEnd, Kernel, and Licensing."
}], "Text",
 CellTags->{"i:16", "b:5.3"},
 CellID->358759974],

Cell[TextData[{
 "Global settings that affect all users are stored in subdirectories of the \
directory ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 ". The default value of ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 " for different versions of Windows is shown in the following table. To \
redefine the location of global preference settings and initialization data, \
set the environment variable MATHEMATICA_BASE."
}], "Text",
 CellTags->"b:5.3",
 CellID->106622735],

Cell[BoxData[GridBox[{
   {Cell["Windows 98/Me", "TableText"], Cell[
    " C:\\Windows\\All Users\\Application Data\\Mathematica", "TableText"]},
   {Cell["Windows NT", "TableText"], Cell[
    " C:\\WINNT\\Profiles\\All Users\\Application Data\\Mathematica", 
     "TableText"]},
   {Cell["Windows 2000/XP", "TableText"], Cell["\<\
 C:\\Documents and Settings\\All Users\\Application Data\\Mathematica\
\>", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "FramedBox",
 CellTags->{"b:5.3", "i:3"},
 CellID->337336835],

Cell[TextData[{
 "Location of the directory ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 " for different versions of Windows."
}], "Caption",
 CellTags->"b:5.3",
 CellID->109640437],

Cell[TextData[{
 "Settings that only affect a particular user are stored in subdirectories of \
the directory ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 ". The default value of ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 " for different versions of Windows is shown in the following table. To \
redefine the location of user preferences and initialization data, set the \
environment variable MATHEMATICA_USERBASE."
}], "Text",
 CellTags->"b:5.3",
 CellID->207366270],

Cell[BoxData[GridBox[{
   {Cell["Windows 98/Me", "TableText"], Cell[
    "C:\\Windows\\Application Data\\Mathematica", "TableText"]},
   {Cell["Windows NT", "TableText"], Cell[TextData[{
     "C:\\WINNT\\Profiles\\",
     StyleBox["username", "TI"],
     "\\Application Data\\Mathematica"
    }], "TableText"]},
   {Cell["Windows 2000/XP", "TableText"], Cell[TextData[{
     "C:\\Documents and Settings\\",
     StyleBox["username", "TI"],
     "\\Application Data\\Mathematica"
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "FramedBox",
 CellTags->{"b:5.3", "i:3"},
 CellID->660085573],

Cell[TextData[{
 "Location of the directory ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 " for different versions of Windows."
}], "Caption",
 CellTags->"b:5.3",
 CellID->305162409],

Cell[TextData[{
 "Settings in the directory ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 " override global settings defined in the directory ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:5.3",
 CellID->62068314],

Cell[TextData[{
 "In the pathnames that follow, replace the variables ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 " with the appropriate directories for your system. To find their locations \
on your system, evaluate the command ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 " (or ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 ") in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook."
}], "Text",
 CellTags->"b:5.3",
 CellID->29516731],

Cell[CellGroupData[{

Cell["Kernel", "Section",
 CellTags->{"i:19", "b:5.3", "net: 2"},
 CellID->91255683],

Cell[TextData[{
 "The initialization files used by the kernel contain ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands that are evaluated at startup, such as function definitions, \
packages to load, and kernel option settings. These commands are also",
 " ",
 "available to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end."
}], "Text",
 CellTags->"b:5.3",
 CellID->517107579],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 "\\Kernel\\init.m"
}], "IndentedText",
 CellTags->"b:5.3",
 CellID->201683040],

Cell["\<\
This file is used to initialize the kernel and therefore should store any \
kernel commands that are appropriate for all users running the kernel.\
\>", "ItemizedTextParagraph",
 CellTags->"b:5.3",
 CellID->88002480],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 "\\Kernel\\init.m"
}], "IndentedText",
 CellTags->"b:5.3",
 CellID->129822047],

Cell[CellGroupData[{

Cell["\<\
This file stores user-specific commands used to initialize the kernel. \
\>", "ItemizedTextParagraph",
 CellTags->"b:5.3",
 CellID->543725624],

Cell["Kernel initialization files are not created automatically.", "Text",
 CellTags->"b:5.3",
 CellID->82569296]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Front End", "Section",
 CellTags->{"i:18", "b:5.3", "net: 3"},
 CellID->103844667],

Cell[TextData[{
 "Front end initialization files store preference settings such as the values \
of global options in the Option Inspector. These files are automatically \
updated by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " when you change a setting in the front end. To make changes to this \
file,",
 " ",
 "make your changes from within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " rather than editing the file directly."
}], "Text",
 CellTags->"b:5.3",
 CellID->60180],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 "\\FrontEnd\\init.m"
}], "IndentedText",
 CellTags->"b:5.3",
 CellID->23166028],

Cell[TextData[{
 "This file stores systemwide defaults used by all ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front ends. The settings in this file affect all users. \"",
 ButtonBox["Systemwide Defaults on Windows\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SystemwideDefaultsOnWindows"],
 " explains how to implement changes to this global file."
}], "ItemizedTextParagraph",
 CellTags->"b:5.3",
 CellID->43694035],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 "\\FrontEnd\\init.m"
}], "IndentedText",
 CellTags->"b:5.3",
 CellID->22611779],

Cell[CellGroupData[{

Cell["\<\
This file defines settings within the front end that are specific to each \
user. \
\>", "ItemizedTextParagraph",
 CellTags->"b:5.3",
 CellID->77187175],

Cell["Front end initialization files are created automatically.", "Text",
 CellTags->"b:5.3",
 CellID->39603026]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Front End Caches", "Section",
 CellTags->{"i:17", "b:5.3", "net: 4"},
 CellID->91849351],

Cell["\<\
The front end stores certain information about system settings in caches \
specific to each user. The default location for front end caches is shown \
here.\
\>", "Text",
 CellTags->"b:5.3",
 CellID->269884221],

Cell[BoxData[GridBox[{
   {Cell["Windows 98/Me/NT", "TableText"], Cell["\<\
C:\\Windows\\Local Settings\\Application \
Data\\Mathematica\\\[LineSeparator]FrontEnd\\6.0 Caches\
\>", "TableText"]},
   {Cell["Windows 2000/XP", "TableText"], Cell[TextData[{
     "C:\\Documents and Settings\\",
     StyleBox["username", "TI"],
     "\\Local Settings\\\[LineSeparator]Application \
Data\\Mathematica\\FrontEnd\\6.0 Caches"
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "FramedBox",
 CellTags->{"b:5.3", "i:3"},
 CellID->81759129],

Cell["\<\
Location of the front end caches for different versions of Windows.\
\>", "Caption",
 CellTags->"b:5.3",
 CellID->176081087]
}, Open  ]],

Cell[CellGroupData[{

Cell["Passwords", "Section",
 CellTags->{"i:20", "b:5.3", "net: 5"},
 CellID->114175334],

Cell[TextData[{
 "Passwords are stored in the mathpass file, described in further detail in \
\"",
 ButtonBox["Registration and Passwords\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/RegistrationAndPasswords"],
 ". In the following pathname, replace the variable ",
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 " with the directory where you installed ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The default value of ",
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 " on Windows is ",
 "C:\\Program Files\\Wolfram Research\\Mathematica\\6.0",
 ". To find the value of ",
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 " on your system, evaluate the command ",
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 " in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook."
}], "Text",
 CellTags->{"i:26", "b:5.3"},
 CellID->50388847],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 "\\Licensing\\mathpass"
}], "IndentedText",
 CellTags->"b:5.3",
 CellID->566604606],

Cell["This is the default location for the global password file.", \
"ItemizedTextParagraph",
 CellTags->"b:5.3",
 CellID->157726021],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 "\\Configuration\\Licensing\\mathpass"
}], "IndentedText",
 CellTags->"b:5.3",
 CellID->330937518],

Cell["\<\
This is an alternative location for the global password file.\
\>", "ItemizedTextParagraph",
 CellTags->"b:5.3",
 CellID->19826773],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 "\\Licensing\\mathpass"
}], "IndentedText",
 CellTags->"b:5.3",
 CellID->129192481],

Cell[TextData[{
 "While this is not normally the location for the password file, a \
user-specific ",
 StyleBox["mathpass", "InlineCode"],
 " file can be stored here."
}], "ItemizedTextParagraph",
 CellTags->"b:5.3",
 CellID->161299958],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->463719644],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Configuration Files on Windows - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 24.9208792}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica stores preference settings and initialization data in two \
directories, $BaseDirectory and $UserBaseDirectory. Within each of these \
directories are several possible subdirectories with titles such as FrontEnd, \
Kernel, and Licensing. Global settings that affect all users are stored in \
subdirectories of the directory $BaseDirectory. The default value of \
$BaseDirectory for different versions of Windows is shown in the following \
table. To redefine the location of global preference settings and \
initialization data, set the environment variable MATHEMATICA_BASE. Location \
of the directory $BaseDirectory for different versions of Windows.", 
    "synonyms" -> {}, "title" -> "Configuration Files on Windows", "type" -> 
    "Tutorial", "uri" -> "tutorial/ConfigurationFilesOnWindows"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "i:2"->{
  Cell[1565, 48, 85, 2, 70, "Title",
   CellTags->"i:2",
   CellID->100067327]},
 "i:16"->{
  Cell[1653, 52, 612, 17, 70, "Text",
   CellTags->{"i:16", "b:5.3"},
   CellID->358759974]},
 "b:5.3"->{
  Cell[1653, 52, 612, 17, 70, "Text",
   CellTags->{"i:16", "b:5.3"},
   CellID->358759974],
  Cell[2268, 71, 650, 17, 70, "Text",
   CellTags->"b:5.3",
   CellID->106622735],
  Cell[2921, 90, 620, 14, 70, "FramedBox",
   CellTags->{"b:5.3", "i:3"},
   CellID->337336835],
  Cell[3544, 106, 271, 9, 70, "Caption",
   CellTags->"b:5.3",
   CellID->109640437],
  Cell[3818, 117, 666, 17, 70, "Text",
   CellTags->"b:5.3",
   CellID->207366270],
  Cell[4487, 136, 699, 18, 70, "FramedBox",
   CellTags->{"b:5.3", "i:3"},
   CellID->660085573],
  Cell[5189, 156, 279, 9, 70, "Caption",
   CellTags->"b:5.3",
   CellID->305162409],
  Cell[5471, 167, 428, 14, 70, "Text",
   CellTags->"b:5.3",
   CellID->62068314],
  Cell[5902, 183, 877, 28, 70, "Text",
   CellTags->"b:5.3",
   CellID->29516731],
  Cell[6804, 215, 84, 2, 70, "Section",
   CellTags->{"i:19", "b:5.3", "net: 2"},
   CellID->91255683],
  Cell[6891, 219, 412, 13, 70, "Text",
   CellTags->"b:5.3",
   CellID->517107579],
  Cell[7306, 234, 226, 8, 70, "IndentedText",
   CellTags->"b:5.3",
   CellID->201683040],
  Cell[7535, 244, 226, 5, 70, "ItemizedTextParagraph",
   CellTags->"b:5.3",
   CellID->88002480],
  Cell[7764, 251, 234, 8, 70, "IndentedText",
   CellTags->"b:5.3",
   CellID->129822047],
  Cell[8023, 263, 152, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:5.3",
   CellID->543725624],
  Cell[8178, 269, 113, 2, 70, "Text",
   CellTags->"b:5.3",
   CellID->82569296],
  Cell[8340, 277, 88, 2, 70, "Section",
   CellTags->{"i:18", "b:5.3", "net: 3"},
   CellID->103844667],
  Cell[8431, 281, 495, 15, 70, "Text",
   CellTags->"b:5.3",
   CellID->60180],
  Cell[8929, 298, 227, 8, 70, "IndentedText",
   CellTags->"b:5.3",
   CellID->23166028],
  Cell[9159, 308, 439, 11, 70, "ItemizedTextParagraph",
   CellTags->"b:5.3",
   CellID->43694035],
  Cell[9601, 321, 235, 8, 70, "IndentedText",
   CellTags->"b:5.3",
   CellID->22611779],
  Cell[9861, 333, 162, 5, 70, "ItemizedTextParagraph",
   CellTags->"b:5.3",
   CellID->77187175],
  Cell[10026, 340, 112, 2, 70, "Text",
   CellTags->"b:5.3",
   CellID->39603026],
  Cell[10187, 348, 94, 2, 70, "Section",
   CellTags->{"i:17", "b:5.3", "net: 4"},
   CellID->91849351],
  Cell[10284, 352, 220, 6, 70, "Text",
   CellTags->"b:5.3",
   CellID->269884221],
  Cell[10507, 360, 638, 16, 70, "FramedBox",
   CellTags->{"b:5.3", "i:3"},
   CellID->81759129],
  Cell[11148, 378, 134, 4, 70, "Caption",
   CellTags->"b:5.3",
   CellID->176081087],
  Cell[11319, 387, 88, 2, 70, "Section",
   CellTags->{"i:20", "b:5.3", "net: 5"},
   CellID->114175334],
  Cell[11410, 391, 1270, 37, 70, "Text",
   CellTags->{"i:26", "b:5.3"},
   CellID->50388847],
  Cell[12683, 430, 231, 8, 70, "IndentedText",
   CellTags->"b:5.3",
   CellID->566604606],
  Cell[12917, 440, 133, 3, 70, "ItemizedTextParagraph",
   CellTags->"b:5.3",
   CellID->157726021],
  Cell[13053, 445, 262, 8, 70, "IndentedText",
   CellTags->"b:5.3",
   CellID->330937518],
  Cell[13318, 455, 141, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:5.3",
   CellID->19826773],
  Cell[13462, 461, 239, 8, 70, "IndentedText",
   CellTags->"b:5.3",
   CellID->129192481],
  Cell[13704, 471, 236, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:5.3",
   CellID->161299958]},
 "i:3"->{
  Cell[2921, 90, 620, 14, 70, "FramedBox",
   CellTags->{"b:5.3", "i:3"},
   CellID->337336835],
  Cell[4487, 136, 699, 18, 70, "FramedBox",
   CellTags->{"b:5.3", "i:3"},
   CellID->660085573],
  Cell[10507, 360, 638, 16, 70, "FramedBox",
   CellTags->{"b:5.3", "i:3"},
   CellID->81759129]},
 "i:19"->{
  Cell[6804, 215, 84, 2, 70, "Section",
   CellTags->{"i:19", "b:5.3", "net: 2"},
   CellID->91255683]},
 "net: 2"->{
  Cell[6804, 215, 84, 2, 70, "Section",
   CellTags->{"i:19", "b:5.3", "net: 2"},
   CellID->91255683]},
 "i:18"->{
  Cell[8340, 277, 88, 2, 70, "Section",
   CellTags->{"i:18", "b:5.3", "net: 3"},
   CellID->103844667]},
 "net: 3"->{
  Cell[8340, 277, 88, 2, 70, "Section",
   CellTags->{"i:18", "b:5.3", "net: 3"},
   CellID->103844667]},
 "i:17"->{
  Cell[10187, 348, 94, 2, 70, "Section",
   CellTags->{"i:17", "b:5.3", "net: 4"},
   CellID->91849351]},
 "net: 4"->{
  Cell[10187, 348, 94, 2, 70, "Section",
   CellTags->{"i:17", "b:5.3", "net: 4"},
   CellID->91849351]},
 "i:20"->{
  Cell[11319, 387, 88, 2, 70, "Section",
   CellTags->{"i:20", "b:5.3", "net: 5"},
   CellID->114175334]},
 "net: 5"->{
  Cell[11319, 387, 88, 2, 70, "Section",
   CellTags->{"i:20", "b:5.3", "net: 5"},
   CellID->114175334]},
 "i:26"->{
  Cell[11410, 391, 1270, 37, 70, "Text",
   CellTags->{"i:26", "b:5.3"},
   CellID->50388847]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"i:2", 16425, 544},
 {"i:16", 16517, 548},
 {"b:5.3", 16623, 552},
 {"i:3", 19878, 658},
 {"i:19", 20183, 668},
 {"net: 2", 20301, 672},
 {"i:18", 20417, 676},
 {"net: 3", 20536, 680},
 {"i:17", 20653, 684},
 {"net: 4", 20772, 688},
 {"i:20", 20889, 692},
 {"net: 5", 21009, 696},
 {"i:26", 21127, 700}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 940, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1565, 48, 85, 2, 70, "Title",
 CellTags->"i:2",
 CellID->100067327],
Cell[1653, 52, 612, 17, 70, "Text",
 CellTags->{"i:16", "b:5.3"},
 CellID->358759974],
Cell[2268, 71, 650, 17, 70, "Text",
 CellTags->"b:5.3",
 CellID->106622735],
Cell[2921, 90, 620, 14, 70, "FramedBox",
 CellTags->{"b:5.3", "i:3"},
 CellID->337336835],
Cell[3544, 106, 271, 9, 70, "Caption",
 CellTags->"b:5.3",
 CellID->109640437],
Cell[3818, 117, 666, 17, 70, "Text",
 CellTags->"b:5.3",
 CellID->207366270],
Cell[4487, 136, 699, 18, 70, "FramedBox",
 CellTags->{"b:5.3", "i:3"},
 CellID->660085573],
Cell[5189, 156, 279, 9, 70, "Caption",
 CellTags->"b:5.3",
 CellID->305162409],
Cell[5471, 167, 428, 14, 70, "Text",
 CellTags->"b:5.3",
 CellID->62068314],
Cell[5902, 183, 877, 28, 70, "Text",
 CellTags->"b:5.3",
 CellID->29516731],
Cell[CellGroupData[{
Cell[6804, 215, 84, 2, 70, "Section",
 CellTags->{"i:19", "b:5.3", "net: 2"},
 CellID->91255683],
Cell[6891, 219, 412, 13, 70, "Text",
 CellTags->"b:5.3",
 CellID->517107579],
Cell[7306, 234, 226, 8, 70, "IndentedText",
 CellTags->"b:5.3",
 CellID->201683040],
Cell[7535, 244, 226, 5, 70, "ItemizedTextParagraph",
 CellTags->"b:5.3",
 CellID->88002480],
Cell[7764, 251, 234, 8, 70, "IndentedText",
 CellTags->"b:5.3",
 CellID->129822047],
Cell[CellGroupData[{
Cell[8023, 263, 152, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:5.3",
 CellID->543725624],
Cell[8178, 269, 113, 2, 70, "Text",
 CellTags->"b:5.3",
 CellID->82569296]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8340, 277, 88, 2, 70, "Section",
 CellTags->{"i:18", "b:5.3", "net: 3"},
 CellID->103844667],
Cell[8431, 281, 495, 15, 70, "Text",
 CellTags->"b:5.3",
 CellID->60180],
Cell[8929, 298, 227, 8, 70, "IndentedText",
 CellTags->"b:5.3",
 CellID->23166028],
Cell[9159, 308, 439, 11, 70, "ItemizedTextParagraph",
 CellTags->"b:5.3",
 CellID->43694035],
Cell[9601, 321, 235, 8, 70, "IndentedText",
 CellTags->"b:5.3",
 CellID->22611779],
Cell[CellGroupData[{
Cell[9861, 333, 162, 5, 70, "ItemizedTextParagraph",
 CellTags->"b:5.3",
 CellID->77187175],
Cell[10026, 340, 112, 2, 70, "Text",
 CellTags->"b:5.3",
 CellID->39603026]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10187, 348, 94, 2, 70, "Section",
 CellTags->{"i:17", "b:5.3", "net: 4"},
 CellID->91849351],
Cell[10284, 352, 220, 6, 70, "Text",
 CellTags->"b:5.3",
 CellID->269884221],
Cell[10507, 360, 638, 16, 70, "FramedBox",
 CellTags->{"b:5.3", "i:3"},
 CellID->81759129],
Cell[11148, 378, 134, 4, 70, "Caption",
 CellTags->"b:5.3",
 CellID->176081087]
}, Open  ]],
Cell[CellGroupData[{
Cell[11319, 387, 88, 2, 70, "Section",
 CellTags->{"i:20", "b:5.3", "net: 5"},
 CellID->114175334],
Cell[11410, 391, 1270, 37, 70, "Text",
 CellTags->{"i:26", "b:5.3"},
 CellID->50388847],
Cell[12683, 430, 231, 8, 70, "IndentedText",
 CellTags->"b:5.3",
 CellID->566604606],
Cell[12917, 440, 133, 3, 70, "ItemizedTextParagraph",
 CellTags->"b:5.3",
 CellID->157726021],
Cell[13053, 445, 262, 8, 70, "IndentedText",
 CellTags->"b:5.3",
 CellID->330937518],
Cell[13318, 455, 141, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:5.3",
 CellID->19826773],
Cell[13462, 461, 239, 8, 70, "IndentedText",
 CellTags->"b:5.3",
 CellID->129192481],
Cell[13704, 471, 236, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:5.3",
 CellID->161299958],
Cell[CellGroupData[{
Cell[13965, 482, 72, 1, 70, "RelatedTutorialsSection",
 CellID->463719644],
Cell[14040, 485, 214, 5, 70, "RelatedTutorials",
 CellID->13855348],
Cell[14257, 492, 221, 5, 70, "RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[14517, 502, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

