(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41885,       1241]
NotebookOptionsPosition[     37408,       1102]
NotebookOutlinePosition[     39310,       1147]
CellTagsIndexPosition[     39267,       1144]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Constrained Optimization" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/ConstrainedOptimizationOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Constrained Optimization\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Comparison of Constrained Optimization Functions", "Title",
 CellID->85183321],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["NMaximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMaximize"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " employ global optimization algorithms, and are thus suitable when a global \
optimum is needed."
}], "Text",
 CellID->113196048],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " can find exact global optima for a class of optimization problems \
containing arbitrary polynomial problems. However, the algorithms used have a \
very high asymptotic complexity and therefore are suitable only for problems \
with a small number of variables. "
}], "Text",
 CellID->189777937],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " always finds a global maximum, even in cases that are numerically \
unstable. The left-hand side of the constraint here is ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "-", 
      SuperscriptBox["10", "10"]}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], ")"}]}]]],
 "."
}], "MathCaption",
 CellID->524491902],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Maximize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "+", "y"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"100000000000000000000", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"20000000000", " ", 
         SuperscriptBox["x", "4"]}], "+", 
        SuperscriptBox["x", "6"], "+", 
        RowBox[{"100000000000000000000", " ", 
         SuperscriptBox["y", "2"]}], "-", 
        RowBox[{"40000000000", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["y", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["x", "4"], " ", 
         SuperscriptBox["y", "2"]}], "-", 
        RowBox[{"20000000000", " ", 
         SuperscriptBox["y", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["y", "4"]}], "+", 
        SuperscriptBox["y", "6"]}], "\[LessEqual]", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"#", ",", "20"}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->129356264],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"141421.35623730957559084699107566922`20.", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "70710.67811865478779542349553783462`20."}], ",",
      
     RowBox[{"y", "\[Rule]", "70710.6781186547877954234955378346`20."}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{548, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1377716748]
}, Open  ]],

Cell["\<\
This input differs from the previous one only in the twenty-first decimal \
digit, but the answer is quite different, especially the location of the \
maximum point. For an algorithm using 16 digits of precision both problems \
look the same, hence it cannot possibly solve them both correctly.\
\>", "MathCaption",
 CellID->259993022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Maximize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "+", "y"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"100000000000000000001", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"20000000000", " ", 
         SuperscriptBox["x", "4"]}], "+", 
        SuperscriptBox["x", "6"], "+", 
        RowBox[{"100000000000000000000", " ", 
         SuperscriptBox["y", "2"]}], "-", 
        RowBox[{"40000000000", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["y", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["x", "4"], " ", 
         SuperscriptBox["y", "2"]}], "-", 
        RowBox[{"20000000000", " ", 
         SuperscriptBox["y", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["y", "4"]}], "+", 
        SuperscriptBox["y", "6"]}], "\[LessEqual]", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"#", ",", "20"}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->530085079],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100000.99999499999999987500125000626`20.", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.99999999999999999999874997499949999125`20."}],
      ",", 
     RowBox[{"y", "\[Rule]", "99999.99999499999999987500250003125`20."}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{546, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1211843637]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NMaximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMaximize"]], "InlineFormula"],
 ", which by default uses machine-precision numbers, is not able to solve \
either of the problems."
}], "MathCaption",
 CellID->442421760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMaximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"100000000000000000000", " ", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{"20000000000", " ", 
        SuperscriptBox["x", "4"]}], "+", 
       SuperscriptBox["x", "6"], "+", 
       RowBox[{"100000000000000000000", " ", 
        SuperscriptBox["y", "2"]}], "-", 
       RowBox[{"40000000000", " ", 
        SuperscriptBox["x", "2"], " ", 
        SuperscriptBox["y", "2"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "4"], " ", 
        SuperscriptBox["y", "2"]}], "-", 
       RowBox[{"20000000000", " ", 
        SuperscriptBox["y", "4"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"], " ", 
        SuperscriptBox["y", "4"]}], "+", 
       SuperscriptBox["y", "6"]}], "\[LessEqual]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->49324260],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMaximize", "::", "\<\"incst\"\>"}], ":", 
  " ", "\<\"\\!\\(NMaximize\\) was unable to generate any initial points \
satisfying the inequality constraints \\!\\({\\(\\(\\(\\(-1\\)\\) + \
\\(\\(100000000000000000000\\\\ x\\^2\\)\\) - \\(\\(20000000000\\\\ \
x\\^4\\)\\) + x\\^6 + \\(\\(100000000000000000000\\\\ y\\^2\\)\\) - \
\\(\\(40000000000\\\\ x\\^2\\\\ y\\^2\\)\\) + \\(\\(3\\\\ x\\^4\\\\ \
y\\^2\\)\\) - \\(\\(20000000000\\\\ y\\^4\\)\\) + \\(\\(3\\\\ x\\^2\\\\ y\\^4\
\\)\\) + y\\^6\\)\\) \[LessEqual] 0}\\). The initial region specified may not \
contain any feasible points. Changing the initial region or specifying \
explicit initial points may provide a better solution. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"MessageLink\\\", ButtonFrame->None, ButtonData:>{\\\"System`\
\\\", \\\"NMaximize\\\", \\\"incst\\\"}, ButtonNote -> \\\"NMaximize::incst\\\
\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->999873896],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.3524776336105607`*^-10", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "4.6964396056669106`*^-11"}], ",", 
     RowBox[{"y", "\[Rule]", "8.828336730438696`*^-11"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{370, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2094347179]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMaximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"100000000000000000001", " ", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{"20000000000", " ", 
        SuperscriptBox["x", "4"]}], "+", 
       SuperscriptBox["x", "6"], "+", 
       RowBox[{"100000000000000000000", " ", 
        SuperscriptBox["y", "2"]}], "-", 
       RowBox[{"40000000000", " ", 
        SuperscriptBox["x", "2"], " ", 
        SuperscriptBox["y", "2"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "4"], " ", 
        SuperscriptBox["y", "2"]}], "-", 
       RowBox[{"20000000000", " ", 
        SuperscriptBox["y", "4"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"], " ", 
        SuperscriptBox["y", "4"]}], "+", 
       SuperscriptBox["y", "6"]}], "\[LessEqual]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->98222158],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMaximize", "::", "\<\"incst\"\>"}], ":", 
  " ", "\<\"\\!\\(NMaximize\\) was unable to generate any initial points \
satisfying the inequality constraints \\!\\({\\(\\(\\(\\(-1\\)\\) + \
\\(\\(100000000000000000001\\\\ x\\^2\\)\\) - \\(\\(20000000000\\\\ \
x\\^4\\)\\) + x\\^6 + \\(\\(100000000000000000000\\\\ y\\^2\\)\\) - \
\\(\\(40000000000\\\\ x\\^2\\\\ y\\^2\\)\\) + \\(\\(3\\\\ x\\^4\\\\ \
y\\^2\\)\\) - \\(\\(20000000000\\\\ y\\^4\\)\\) + \\(\\(3\\\\ x\\^2\\\\ y\\^4\
\\)\\) + y\\^6\\)\\) \[LessEqual] 0}\\). The initial region specified may not \
contain any feasible points. Changing the initial region or specifying \
explicit initial points may provide a better solution. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"MessageLink\\\", ButtonFrame->None, ButtonData:>{\\\"System`\
\\\", \\\"NMaximize\\\", \\\"incst\\\"}, ButtonNote -> \\\"NMaximize::incst\\\
\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[4]:=",
 CellID->643383881],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.3524776336105607`*^-10", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "4.6964396056669106`*^-11"}], ",", 
     RowBox[{"y", "\[Rule]", "8.828336730438696`*^-11"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{370, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->841771085]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " only attempts to find a local minimum, therefore is suitable when a local \
optimum is needed, or when it is known in advance that the problem has only \
one optimum or only a few optima that can be discovered using different \
starting points."
}], "Text",
 CellID->9398496],

Cell[TextData[{
 "Even for local optimization, it may still be worth using ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " for small problems. ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " uses one of the four direct search algorithms (Nelder\[Dash]Mead, \
differential evolution, simulated annealing, and random search), then \
finetunes the solution by using a combination of KKT solution, the interior \
point, and a penalty method. So if efficiency is not an issue, ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " should be more robust than ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 ", in addition to being a global optimizer."
}], "Text",
 CellID->160563630],

Cell[TextData[{
 "This shows the default behavior of ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " on a problem with four variables."
}], "Text",
 CellID->44807765],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"f", ",", "x", ",", "y", ",", "z", ",", "t"}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", "x", "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", "y", "]"}]}], " ", "-", " ", 
    RowBox[{"3", 
     RowBox[{"Log", "[", "y", "]"}]}], "-", 
    RowBox[{"3", 
     RowBox[{"Log", "[", "t", "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"cons", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"200", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"], "+", 
       SuperscriptBox["t", "2"]}], "==", "100"}], ",", 
     RowBox[{"x", ">", "0"}], ",", 
     RowBox[{"y", ">", "0"}], ",", 
     RowBox[{"z", ">", "0"}], ",", 
     RowBox[{"t", ">", "0"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vars", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}]}], ";"}], "\n", 
 RowBox[{"sol", "=", 
  RowBox[{"NMinimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f", ",", "cons"}], "}"}], ",", "vars"}], "]"}]}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->435532328],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "13.85810976974682`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", "5.773502691896258`"}], ",", 
     RowBox[{"x", "\[Rule]", "0.23570226039551584`"}], ",", 
     RowBox[{"y", "\[Rule]", "7.453559924999299`"}], ",", 
     RowBox[{"z", "\[Rule]", "2.791021745934306`*^-8"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{458, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->2038568158]
}, Open  ]],

Cell[TextData[{
 "This shows that two of the post-processors, ",
 "KKT",
 " and ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 ", do not give the default result. Notice that for historical reasons, the \
name ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 ", when used as an option value of ",
 Cell[BoxData["PostProcess"], "InlineFormula"],
 ", stands for the process where a penalty method is used to convert the \
constrained optimization problem into unconstrained optimization methods and \
then solved using (unconstrained) ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 "."
}], "Text",
 CellID->21027941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"NMinimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f", ",", "cons"}], "}"}], ",", "vars", ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"NelderMead", ",", " ", 
       RowBox[{"PostProcess", "\[Rule]", "KKT"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->194384423],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "13.85810976974682`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", "5.773502691896258`"}], ",", 
     RowBox[{"x", "\[Rule]", "0.23570226039551584`"}], ",", 
     RowBox[{"y", "\[Rule]", "7.453559924999299`"}], ",", 
     RowBox[{"z", "\[Rule]", "2.791021745934306`*^-8"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{458, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->1157988222]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"NMinimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f", ",", "cons"}], "}"}], ",", "vars", ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"NelderMead", ",", " ", 
       RowBox[{"PostProcess", "\[Rule]", "FindMinimum"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[11]:=",
 CellID->352281952],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "13.856607223839067`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", "5.876843569741325`"}], ",", 
     RowBox[{"x", "\[Rule]", "0.23503146527247548`"}], ",", 
     RowBox[{"y", "\[Rule]", "7.376628818795464`"}], ",", 
     RowBox[{"z", "\[Rule]", "0.00994951661922553`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{450, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->951531897]
}, Open  ]],

Cell[TextData[{
 "However, if efficiency is important, ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " can be used if you just need a local minimum, or you can provide a good \
starting point, or you know the problem has only one minimum (e.g., convex), \
or your problem is large/expensive. This uses ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " to solve the same problem with seven variables. The constraints are \
relatively expensive to compute. Clearly ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " in this case is much faster than ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 "."
}], "Text",
 CellID->894516491],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"f", ",", "cons", ",", "vars", ",", "x"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", ",", "cons", ",", "vars"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"20", " ", 
        RowBox[{"x", "[", "2", "]"}], " ", 
        RowBox[{"x", "[", "6", "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"x", "[", "1", "]"}], "2"], " ", 
        RowBox[{"x", "[", "4", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"x", "[", "5", "]"}], "2"]}]], "+", 
      FractionBox[
       RowBox[{"15", " ", 
        RowBox[{"x", "[", "3", "]"}], " ", 
        RowBox[{"x", "[", "4", "]"}]}], 
       RowBox[{
        RowBox[{"x", "[", "1", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"x", "[", "2", "]"}], "2"], " ", 
        RowBox[{"x", "[", "5", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"x", "[", "7", "]"}], "0.5`"]}]], "+", 
      FractionBox[
       RowBox[{"10", " ", 
        RowBox[{"x", "[", "1", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"x", "[", "4", "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"x", "[", "7", "]"}], "0.125`"]}], 
       RowBox[{
        RowBox[{"x", "[", "2", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"x", "[", "6", "]"}], "3"]}]], "+", 
      FractionBox[
       RowBox[{"25", " ", 
        SuperscriptBox[
         RowBox[{"x", "[", "1", "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"x", "[", "2", "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"x", "[", "5", "]"}], "0.5`"], " ", 
        RowBox[{"x", "[", "7", "]"}]}], 
       RowBox[{
        RowBox[{"x", "[", "3", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"x", "[", "6", "]"}], "2"]}]]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.1`", "\[LessEqual]", 
        RowBox[{"x", "[", "1", "]"}], "\[LessEqual]", "10"}], ",", 
       RowBox[{"0.1`", "\[LessEqual]", 
        RowBox[{"x", "[", "2", "]"}], "\[LessEqual]", "10"}], ",", 
       RowBox[{"0.1`", "\[LessEqual]", 
        RowBox[{"x", "[", "3", "]"}], "\[LessEqual]", "10"}], ",", 
       RowBox[{"0.1`", "\[LessEqual]", 
        RowBox[{"x", "[", "4", "]"}], "\[LessEqual]", "10"}], ",", 
       RowBox[{"0.1`", "\[LessEqual]", 
        RowBox[{"x", "[", "5", "]"}], "\[LessEqual]", "10"}], ",", 
       RowBox[{"0.1`", "\[LessEqual]", 
        RowBox[{"x", "[", "6", "]"}], "\[LessEqual]", "10"}], ",", 
       RowBox[{"0.01`", "\[LessEqual]", 
        RowBox[{"x", "[", "7", "]"}], "\[LessEqual]", "10"}], ",", 
       RowBox[{
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"0.2`", " ", 
           RowBox[{"x", "[", "3", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "6", "]"}], 
            RowBox[{"2", "/", "3"}]], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "7", "]"}], "0.25`"]}], 
          RowBox[{
           RowBox[{"x", "[", "2", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "4", "]"}], "0.5`"]}]], "-", 
         FractionBox[
          RowBox[{"0.7`", " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "1", "]"}], "3"], " ", 
           RowBox[{"x", "[", "2", "]"}], " ", 
           RowBox[{"x", "[", "6", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "7", "]"}], "0.5`"]}], 
          SuperscriptBox[
           RowBox[{"x", "[", "3", "]"}], "2"]], "-", 
         FractionBox[
          RowBox[{"0.5`", " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "1", "]"}], "0.5`"], " ", 
           RowBox[{"x", "[", "7", "]"}]}], 
          RowBox[{
           RowBox[{"x", "[", "3", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "6", "]"}], "2"]}]]}], "\[GreaterEqual]", "0"}],
        ",", 
       RowBox[{
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"3.1`", " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "2", "]"}], "0.5`"], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "6", "]"}], 
            RowBox[{"1", "/", "3"}]]}], 
          RowBox[{
           RowBox[{"x", "[", "1", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "4", "]"}], "2"], " ", 
           RowBox[{"x", "[", "5", "]"}]}]], "-", 
         FractionBox[
          RowBox[{"1.3`", " ", 
           RowBox[{"x", "[", "2", "]"}], " ", 
           RowBox[{"x", "[", "6", "]"}]}], 
          RowBox[{
           SuperscriptBox[
            RowBox[{"x", "[", "1", "]"}], "0.5`"], " ", 
           RowBox[{"x", "[", "3", "]"}], " ", 
           RowBox[{"x", "[", "5", "]"}]}]], "-", 
         FractionBox[
          RowBox[{"0.8`", " ", 
           RowBox[{"x", "[", "3", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "6", "]"}], "2"]}], 
          RowBox[{
           RowBox[{"x", "[", "4", "]"}], " ", 
           RowBox[{"x", "[", "5", "]"}]}]]}], "\[GreaterEqual]", "0"}], ",", 
       RowBox[{
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{
           RowBox[{"x", "[", "2", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "3", "]"}], "0.5`"], " ", 
           RowBox[{"x", "[", "5", "]"}]}], 
          RowBox[{"x", "[", "1", "]"}]], "-", 
         FractionBox[
          RowBox[{"0.1`", " ", 
           RowBox[{"x", "[", "2", "]"}], " ", 
           RowBox[{"x", "[", "5", "]"}]}], 
          RowBox[{
           SuperscriptBox[
            RowBox[{"x", "[", "3", "]"}], "0.5`"], " ", 
           RowBox[{"x", "[", "6", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "7", "]"}], "0.5`"]}]], "-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"x", "[", "1", "]"}], " ", 
           RowBox[{"x", "[", "5", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "7", "]"}], 
            RowBox[{"1", "/", "3"}]]}], 
          RowBox[{
           SuperscriptBox[
            RowBox[{"x", "[", "3", "]"}], "1.5`"], " ", 
           RowBox[{"x", "[", "6", "]"}]}]], "-", 
         FractionBox[
          RowBox[{"0.65`", " ", 
           RowBox[{"x", "[", "3", "]"}], " ", 
           RowBox[{"x", "[", "5", "]"}], " ", 
           RowBox[{"x", "[", "7", "]"}]}], 
          RowBox[{
           SuperscriptBox[
            RowBox[{"x", "[", "2", "]"}], "2"], " ", 
           RowBox[{"x", "[", "6", "]"}]}]]}], "\[GreaterEqual]", "0"}], ",", 
       RowBox[{
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"0.3`", " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "1", "]"}], "0.5`"], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "2", "]"}], "2"], " ", 
           RowBox[{"x", "[", "3", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "4", "]"}], 
            RowBox[{"1", "/", "3"}]], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "7", "]"}], "0.25`"]}], 
          SuperscriptBox[
           RowBox[{"x", "[", "5", "]"}], 
           RowBox[{"2", "/", "3"}]]], "-", 
         FractionBox[
          RowBox[{"0.2`", " ", 
           RowBox[{"x", "[", "2", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "5", "]"}], "0.5`"], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "7", "]"}], 
            RowBox[{"1", "/", "3"}]]}], 
          RowBox[{
           SuperscriptBox[
            RowBox[{"x", "[", "1", "]"}], "2"], " ", 
           RowBox[{"x", "[", "4", "]"}]}]], "-", 
         FractionBox[
          RowBox[{"0.5`", " ", 
           RowBox[{"x", "[", "4", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "7", "]"}], "0.5`"]}], 
          SuperscriptBox[
           RowBox[{"x", "[", "3", "]"}], "2"]], "-", 
         FractionBox[
          RowBox[{"0.4`", " ", 
           RowBox[{"x", "[", "3", "]"}], " ", 
           RowBox[{"x", "[", "5", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "7", "]"}], "0.75`"]}], 
          RowBox[{
           SuperscriptBox[
            RowBox[{"x", "[", "1", "]"}], "3"], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "2", "]"}], "2"]}]]}], "\[GreaterEqual]", "0"}],
        ",", 
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{"20", " ", 
           RowBox[{"x", "[", "2", "]"}], " ", 
           RowBox[{"x", "[", "6", "]"}]}], 
          RowBox[{
           SuperscriptBox[
            RowBox[{"x", "[", "1", "]"}], "2"], " ", 
           RowBox[{"x", "[", "4", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "5", "]"}], "2"]}]], "+", 
         FractionBox[
          RowBox[{"15", " ", 
           RowBox[{"x", "[", "3", "]"}], " ", 
           RowBox[{"x", "[", "4", "]"}]}], 
          RowBox[{
           RowBox[{"x", "[", "1", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "2", "]"}], "2"], " ", 
           RowBox[{"x", "[", "5", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "7", "]"}], "0.5`"]}]], "+", 
         FractionBox[
          RowBox[{"10", " ", 
           RowBox[{"x", "[", "1", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "4", "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "7", "]"}], "0.125`"]}], 
          RowBox[{
           RowBox[{"x", "[", "2", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "6", "]"}], "3"]}]], "+", 
         FractionBox[
          RowBox[{"25", " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "1", "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "2", "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "5", "]"}], "0.5`"], " ", 
           RowBox[{"x", "[", "7", "]"}]}], 
          RowBox[{
           RowBox[{"x", "[", "3", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "6", "]"}], "2"]}]]}], "\[GreaterEqual]", 
        "100"}], ",", 
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{"20", " ", 
           RowBox[{"x", "[", "2", "]"}], " ", 
           RowBox[{"x", "[", "6", "]"}]}], 
          RowBox[{
           SuperscriptBox[
            RowBox[{"x", "[", "1", "]"}], "2"], " ", 
           RowBox[{"x", "[", "4", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "5", "]"}], "2"]}]], "+", 
         FractionBox[
          RowBox[{"15", " ", 
           RowBox[{"x", "[", "3", "]"}], " ", 
           RowBox[{"x", "[", "4", "]"}]}], 
          RowBox[{
           RowBox[{"x", "[", "1", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "2", "]"}], "2"], " ", 
           RowBox[{"x", "[", "5", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "7", "]"}], "0.5`"]}]], "+", 
         FractionBox[
          RowBox[{"10", " ", 
           RowBox[{"x", "[", "1", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "4", "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "7", "]"}], "0.125`"]}], 
          RowBox[{
           RowBox[{"x", "[", "2", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "6", "]"}], "3"]}]], "+", 
         FractionBox[
          RowBox[{"25", " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "1", "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "2", "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "5", "]"}], "0.5`"], " ", 
           RowBox[{"x", "[", "7", "]"}]}], 
          RowBox[{
           RowBox[{"x", "[", "3", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "6", "]"}], "2"]}]]}], "\[LessEqual]", 
        "3000"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "1", "]"}], ",", 
       RowBox[{"x", "[", "2", "]"}], ",", 
       RowBox[{"x", "[", "3", "]"}], ",", 
       RowBox[{"x", "[", "4", "]"}], ",", 
       RowBox[{"x", "[", "5", "]"}], ",", 
       RowBox[{"x", "[", "6", "]"}], ",", 
       RowBox[{"x", "[", "7", "]"}]}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[12]:=",
 CellID->298509492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f", ",", "cons"}], "}"}], ",", "vars"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->615638664],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.2059689999999998`", ",", 
   RowBox[{"{", 
    RowBox[{"911.8805714792686`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", "1", "]"}], "\[Rule]", "3.8962531793874473`"}], ",",
        
       RowBox[{
        RowBox[{"x", "[", "2", "]"}], "\[Rule]", "0.8093587596971846`"}], ",",
        
       RowBox[{
        RowBox[{"x", "[", "3", "]"}], "\[Rule]", "2.664385993372662`"}], ",", 
       
       RowBox[{
        RowBox[{"x", "[", "4", "]"}], "\[Rule]", "4.30091285876142`"}], ",", 
       RowBox[{
        RowBox[{"x", "[", "5", "]"}], "\[Rule]", "0.8535549339429952`"}], ",",
        
       RowBox[{
        RowBox[{"x", "[", "6", "]"}], "\[Rule]", "1.0952874414685732`"}], ",",
        
       RowBox[{
        RowBox[{"x", "[", "7", "]"}], "\[Rule]", "0.027310459675766095`"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{473, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->781463831]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f", ",", "cons"}], "}"}], ",", "vars"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->645777195],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "::", "\<\"incst\"\>"}], ":", 
  " ", "\<\"\\!\\(NMinimize\\) was unable to generate any initial points \
satisfying the inequality constraints \\!\\({\\(\\(\\(\\(\\(\\(-1\\)\\) + \
\\(3.1`\\\\ \\(x[2]\\)\\^0.5`\\\\ \
\\(x[6]\\)\\^\\(1/3\\)\\)\\/\\(\\(\\(x[1]\\)\\)\\\\ \\(x[4]\\)\\^2\\\\ \
\\(\\(x[5]\\)\\)\\) + \\(1.3`\\\\ \\(\\(x[2]\\)\\)\\\\ \\(\\(x[6]\\)\\)\\)\\/\
\\(\\(x[1]\\)\\^0.5`\\\\ \\(\\(x[3]\\)\\)\\\\ \\(\\(x[5]\\)\\)\\) + \\(0.8`\\\
\\ \\(\\(x[3]\\)\\)\\\\ \\(x[6]\\)\\^2\\)\\/\\(\\(\\(x[4]\\)\\)\\\\ \
\\(\\(x[5]\\)\\)\\)\\)\\) \[LessEqual] 0\\)\\), \\(\\(\[LeftSkeleton] 4 \
\[RightSkeleton]\\)\\), \\(\\(\\(\\(\\(\\(-1\\)\\) + \\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\) + \\(0.65`\\\\ \\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)\\\\ \\(\\(x[7]\\)\\)\\)\\/\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\^2\\\\ \\(\\(x[6]\\)\\)\\)\\)\\) \[LessEqual] \
0\\)\\)}\\). The initial region specified may not contain any feasible \
points. Changing the initial region or specifying explicit initial points may \
provide a better solution. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"MessageLink\\\", ButtonFrame->None, ButtonData:>{\\\"System`\
\\\", \\\"NMinimize\\\", \\\"incst\\\"}, ButtonNote -> \\\"NMinimize::incst\\\
\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[15]:=",
 CellID->863625617],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "::", "\<\"incst\"\>"}], ":", 
  " ", "\<\"\\!\\(NMinimize\\) was unable to generate any initial points \
satisfying the inequality constraints \\!\\({\\(\\(\\(\\(\\(\\(-1\\)\\) + \
\\(3.1`\\\\ \\(x[2]\\)\\^0.5`\\\\ \
\\(x[6]\\)\\^\\(1/3\\)\\)\\/\\(\\(\\(x[1]\\)\\)\\\\ \\(x[4]\\)\\^2\\\\ \
\\(\\(x[5]\\)\\)\\) + \\(1.3`\\\\ \\(\\(x[2]\\)\\)\\\\ \\(\\(x[6]\\)\\)\\)\\/\
\\(\\(x[1]\\)\\^0.5`\\\\ \\(\\(x[3]\\)\\)\\\\ \\(\\(x[5]\\)\\)\\) + \\(0.8`\\\
\\ \\(\\(x[3]\\)\\)\\\\ \\(x[6]\\)\\^2\\)\\/\\(\\(\\(x[4]\\)\\)\\\\ \
\\(\\(x[5]\\)\\)\\)\\)\\) \[LessEqual] 0\\)\\), \\(\\(\[LeftSkeleton] 4 \
\[RightSkeleton]\\)\\), \\(\\(\\(\\(\\(\\(-1\\)\\) + \\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\) + \\(0.65`\\\\ \\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)\\\\ \\(\\(x[7]\\)\\)\\)\\/\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\^2\\\\ \\(\\(x[6]\\)\\)\\)\\)\\) \[LessEqual] \
0\\)\\)}\\). The initial region specified may not contain any feasible \
points. Changing the initial region or specifying explicit initial points may \
provide a better solution. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"MessageLink\\\", ButtonFrame->None, ButtonData:>{\\\"System`\
\\\", \\\"NMinimize\\\", \\\"incst\\\"}, ButtonNote -> \\\"NMinimize::incst\\\
\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[15]:=",
 CellID->281135892],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.424024`", ",", 
   RowBox[{"{", 
    RowBox[{"911.8805722456067`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", "1", "]"}], "\[Rule]", "3.896252917082432`"}], ",", 
       
       RowBox[{
        RowBox[{"x", "[", "2", "]"}], "\[Rule]", "0.8093587478036796`"}], ",",
        
       RowBox[{
        RowBox[{"x", "[", "3", "]"}], "\[Rule]", "2.6643859775546725`"}], ",",
        
       RowBox[{
        RowBox[{"x", "[", "4", "]"}], "\[Rule]", "4.3009124954320965`"}], ",",
        
       RowBox[{
        RowBox[{"x", "[", "5", "]"}], "\[Rule]", "0.8535549060283586`"}], ",",
        
       RowBox[{
        RowBox[{"x", "[", "6", "]"}], "\[Rule]", "1.0952873739004438`"}], ",",
        
       RowBox[{
        RowBox[{"x", "[", "7", "]"}], "\[Rule]", "0.027310459982942167`"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{473, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->1166428590]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->899480670],

Cell[TextData[ButtonBox["Constrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationOverview"]], "RelatedTutorials",
 CellID->1633042]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Comparison of Constrained Optimization Functions - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 25.2802634}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "NMinimize, NMaximize, Minimize and Maximize employ global optimization \
algorithms, and are thus suitable when a global optimum is needed. Minimize \
and Maximize can find exact global optima for a class of optimization \
problems containing arbitrary polynomial problems. However, the algorithms \
used have a very high asymptotic complexity and therefore are suitable only \
for problems with a small number of variables. Maximize always finds a global \
maximum, even in cases that are numerically unstable. The left-hand side of \
the constraint here is (x^2+y^2-10^10)^2 (x^2+y^2).", "synonyms" -> {}, 
    "title" -> "Comparison of Constrained Optimization Functions", "type" -> 
    "Tutorial", "uri" -> "tutorial/ConstrainedOptimizationComparison"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 647, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1272, 43, 84, 1, 70, "Title",
 CellID->85183321],
Cell[1359, 46, 651, 23, 70, "Text",
 CellID->113196048],
Cell[2013, 71, 561, 15, 70, "Text",
 CellID->189777937],
Cell[2577, 88, 626, 21, 70, "MathCaption",
 CellID->524491902],
Cell[CellGroupData[{
Cell[3228, 113, 1163, 34, 68, "Input",
 CellID->129356264],
Cell[4394, 149, 443, 13, 36, "Output",
 CellID->1377716748]
}, Open  ]],
Cell[4852, 165, 345, 6, 70, "MathCaption",
 CellID->259993022],
Cell[CellGroupData[{
Cell[5222, 175, 1163, 34, 68, "Input",
 CellID->530085079],
Cell[6388, 211, 449, 13, 36, "Output",
 CellID->1211843637]
}, Open  ]],
Cell[6852, 227, 276, 8, 70, "MathCaption",
 CellID->442421760],
Cell[CellGroupData[{
Cell[7153, 239, 1039, 30, 70, "Input",
 CellID->49324260],
Cell[8195, 271, 1024, 17, 70, "Message",
 CellID->999873896],
Cell[9222, 290, 389, 12, 39, "Output",
 CellID->2094347179]
}, Open  ]],
Cell[CellGroupData[{
Cell[9648, 307, 1039, 30, 70, "Input",
 CellID->98222158],
Cell[10690, 339, 1024, 17, 70, "Message",
 CellID->643383881],
Cell[11717, 358, 388, 12, 39, "Output",
 CellID->841771085]
}, Open  ]],
Cell[12120, 373, 419, 10, 70, "Text",
 CellID->9398496],
Cell[12542, 385, 989, 26, 70, "Text",
 CellID->160563630],
Cell[13534, 413, 245, 8, 70, "Text",
 CellID->44807765],
Cell[CellGroupData[{
Cell[13804, 425, 1255, 41, 70, "Input",
 CellID->435532328],
Cell[15062, 468, 515, 15, 39, "Output",
 CellID->2038568158]
}, Open  ]],
Cell[15592, 486, 857, 25, 70, "Text",
 CellID->21027941],
Cell[CellGroupData[{
Cell[16474, 515, 375, 12, 70, "Input",
 CellID->194384423],
Cell[16852, 529, 516, 15, 39, "Output",
 CellID->1157988222]
}, Open  ]],
Cell[CellGroupData[{
Cell[17405, 549, 383, 12, 70, "Input",
 CellID->352281952],
Cell[17791, 563, 514, 15, 36, "Output",
 CellID->951531897]
}, Open  ]],
Cell[18320, 581, 1082, 31, 70, "Text",
 CellID->894516491],
Cell[19405, 614, 12244, 330, 70, "Input",
 CellID->298509492],
Cell[CellGroupData[{
Cell[31674, 948, 221, 8, 70, "Input",
 CellID->615638664],
Cell[31898, 958, 1040, 31, 54, "Output",
 CellID->781463831]
}, Open  ]],
Cell[CellGroupData[{
Cell[32975, 994, 219, 8, 70, "Input",
 CellID->645777195],
Cell[33197, 1004, 1410, 22, 70, "Message",
 CellID->863625617],
Cell[34610, 1028, 1410, 22, 70, "Message",
 CellID->281135892],
Cell[36023, 1052, 1041, 32, 54, "Output",
 CellID->1166428590]
}, Open  ]],
Cell[CellGroupData[{
Cell[37101, 1089, 72, 1, 70, "RelatedTutorialsSection",
 CellID->899480670],
Cell[37176, 1092, 178, 4, 70, "RelatedTutorials",
 CellID->1633042]
}, Open  ]]
}, Open  ]],
Cell[37381, 1100, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

