(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30209,       1010]
NotebookOptionsPosition[     24057,        816]
NotebookOutlinePosition[     26775,        886]
CellTagsIndexPosition[     26679,        880]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Constrained Optimization" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/ConstrainedOptimizationOverview"], 
         "Linear Programming" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/ConstrainedOptimizationLinearProgramming"], 
         "Numerical Nonlinear Local Optimization" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/ConstrainedOptimizationLocalNumerical"], 
         "Numerical Nonlinear Global Optimization" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/ConstrainedOptimizationGlobalNumerical"], 
         "Exact Global Optimization" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/ConstrainedOptimizationExact"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Constrained Optimization\"\>", 
      2->"\<\"Linear Programming\"\>", 
      3->"\<\"Numerical Nonlinear Local Optimization\"\>", 
      4->"\<\"Numerical Nonlinear Global Optimization\"\>", 
      5->"\<\"Exact Global Optimization\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Introduction to Constrained Optimization in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Title",
 CellID->248488806],

Cell[CellGroupData[{

Cell["Optimization Problems", "Section",
 CellID->1039976465],

Cell[TextData[{
 "Constrained optimization problems are problems for which a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " is to be minimized or maximized subject to constraints ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ". Here ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", ":", 
     SuperscriptBox["\[DoubleStruckCapitalR]", "n"]}], "\[Rule]", " ", 
    "\[DoubleStruckCapitalR]"}], TraditionalForm]], "InlineMath"],
 " is called the objective function and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is a Boolean-valued formula. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " the constraints ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " can be an arbitrary Boolean combination of equations ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "x", ")"}], "\[LongEqual]", "0"}], TraditionalForm]], 
  "InlineMath"],
 ", weak inequalities ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "x", ")"}], "\[GreaterEqual]", "0"}], TraditionalForm]],
   "InlineMath"],
 ", strict inequalities ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "x", ")"}], ">", "0"}], TraditionalForm]], 
  "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[Element]", "\[DoubleStruckCapitalZ]"}], TraditionalForm]], 
  "InlineMath"],
 " statements. The following notation will be used."
}], "Text",
 CellID->97759825],

Cell[BoxData[{
 FormBox[
  RowBox[{"Min", " ", 
   RowBox[{"f", "(", "x", ")"}]}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{"s", ".", "t", ".", "   ", 
   RowBox[{"\[CapitalPhi]", "(", "x", ")"}]}], 
  TraditionalForm]}], "NumberedEquation",
 CellID->359556120],

Cell[TextData[{
 "stands for \"minimize ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " subject to constraints ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 "\", and"
}], "Text",
 CellID->396584907],

Cell[BoxData[{
 FormBox[
  RowBox[{"Max", " ", 
   RowBox[{"f", "(", "x", ")"}]}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{"s", ".", "t", ".", "   ", 
   RowBox[{"\[CapitalPhi]", "(", "x", ")"}]}], 
  TraditionalForm]}], "NumberedEquation",
 CellID->655247],

Cell[TextData[{
 "stands for \"maximize ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " subject to constraints ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 "\"."
}], "Text",
 CellID->116540820],

Cell[TextData[{
 "You say a point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "\[Element]", 
    SuperscriptBox["\[DoubleStruckCapitalR]", "n"]}], TraditionalForm]], 
  "InlineMath"],
 " satisfies the constraints ",
 Cell[BoxData[
  FormBox["\[CapitalPhi]", TraditionalForm]], "InlineMath"],
 " if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", "u", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is true."
}], "Text",
 CellID->413926793],

Cell["\<\
The following describes constrained optimization problems more precisely, \
restricting the discussion to minimization problems for brevity.\
\>", "Text",
 CellID->167519381]
}, Open  ]],

Cell[CellGroupData[{

Cell["Global Optimization", "Section",
 CellID->170940268],

Cell[TextData[{
 "A point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "\[Element]", 
    SuperscriptBox["\[DoubleStruckCapitalR]", "n"]}], TraditionalForm]], 
  "InlineMath"],
 " is said to be a global minimum of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " subject to constraints ",
 Cell[BoxData[
  FormBox["\[CapitalPhi]", TraditionalForm]], "InlineMath"],
 " if ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " satisfies the constraints and for any point ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]], "InlineMath"],
 " that satisfies the constraints, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "u", ")"}], "\[LessEqual]", 
    RowBox[{"f", "(", "v", ")"}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->190074994],

Cell[TextData[{
 "A value ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "\[Element]", 
    RowBox[{"\[DoubleStruckCapitalR]", "\[Union]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}]}], 
   TraditionalForm]], "InlineMath"],
 " is said to be the global minimum value of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " subject to constraints ",
 Cell[BoxData[
  FormBox["\[CapitalPhi]", TraditionalForm]], "InlineMath"],
 " if for any point ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]], "InlineMath"],
 " that satisfies the constraints, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "\[LessEqual]", 
    RowBox[{"f", "(", "v", ")"}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->136330640],

Cell[TextData[{
 "The global minimum value ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " exists for any ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[CapitalPhi]", TraditionalForm]], "InlineMath"],
 ". The global minimum value ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " is attained if there exists a point ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", "u", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is true and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "u", ")"}], "\[Equal]", "a"}], TraditionalForm]], 
  "InlineMath"],
 ". Such a point ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " is necessarily a global minimum."
}], "Text",
 CellID->130027821],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " is a continuous function and the set of points satisfying the constraints \
",
 Cell[BoxData[
  FormBox["\[CapitalPhi]", TraditionalForm]], "InlineMath"],
 " is compact (closed and bounded) and nonempty, then a global minimum \
exists. Otherwise a global minimum may or may not exist."
}], "Text",
 CellID->437897756],

Cell["\<\
Here the minimum value is not attained. The set of points satisfying the \
constraints is not closed.\
\>", "MathCaption",
 CellTags->"b:0.2.1",
 CellID->117718009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], " ", "<", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->741406091],

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "::", "\<\"wksol\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Warning: There is no minimum in the \
region described by the constraints; returning a result on the \
boundary.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/Minimize\\\"]\\)\"\>"}]], \
"Message", "MSG",
 CellLabel->"During evaluation of In[1]:=",
 CellID->135930097],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48659934]
}, Open  ]],

Cell["\<\
Here the set of points satisfying the constraints is closed but unbounded. \
Again, the minimum value is not attained.\
\>", "MathCaption",
 CellTags->"b:0.2.1",
 CellID->127637934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["x", "2"], ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->521050388],

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "::", "\<\"natt\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The minimum is not attained at any \
point satisfying the given constraints.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/Minimize\\\"]\\)\"\>"}]], \
"Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->726481233],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "Indeterminate"}], ",", 
     RowBox[{"y", "\[Rule]", "Indeterminate"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{290, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->504337622]
}, Open  ]],

Cell["\<\
The minimum value may be attained even if the set of points satisfying the \
constraints is neither closed nor bounded. \
\>", "MathCaption",
 CellTags->"b:0.2.1",
 CellID->223549055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"y", "-", "1"}], ")"}], "2"]}], ",", 
     RowBox[{"y", ">", 
      SuperscriptBox["x", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->545282996],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->481567585]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Local Optimization", "Section",
 CellID->171458460],

Cell[TextData[{
 "A point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "\[Element]", 
    SuperscriptBox["\[DoubleStruckCapitalR]", "n"]}], TraditionalForm]], 
  "InlineMath"],
 " is said to be a local minimum of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " subject to constraints ",
 Cell[BoxData[
  FormBox["\[CapitalPhi]", TraditionalForm]], "InlineMath"],
 " if ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " satisfies the constraints and, for some ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", ">", "0"}], TraditionalForm]], "InlineMath"],
 ", if ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]], "InlineMath"],
 " satisfies ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"v", "-", "u"}], "|", 
    RowBox[{
     RowBox[{"<", "r"}], "\[And]", 
     RowBox[{"\[CapitalPhi]", "(", "v", ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "u", ")"}], "\[LessEqual]", 
    RowBox[{"f", "(", "v", ")"}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->154253],

Cell["\<\
A local minimum may not be a global minimum. A global minimum is always a \
local minimum.\
\>", "Text",
 CellID->235688859],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " finds a local minimum that is not a global minimum. "
}], "MathCaption",
 CellTags->"b:0.2.1",
 CellID->24916071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", 
     SuperscriptBox["x", "4"]}], "-", 
    RowBox[{"28", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"84", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"96", "x"}], "+", "42"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1.1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->606801206],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.999999999999998`", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.9999999999943516`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->954435823]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", 
     SuperscriptBox["x", "4"]}], "-", 
    RowBox[{"28", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"84", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"96", "x"}], "+", "42"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->694322071],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "22"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->94122306]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", 
     SuperscriptBox["x", "4"]}], "-", 
    RowBox[{"28", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"84", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"96", "x"}], "+", "42"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->896034415],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->451051461]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solving Optimization Problems", "Section",
 CellID->32353590],

Cell[TextData[{
 "The methods used to solve local and global optimization problems depend on \
specific problem types. Optimization problems can be categorized according to \
several criteria. Depending on the type of functions involved there are \
linear and nonlinear (polynomial, algebraic, transcendental, ...) \
optimization problems. If the constraints involve ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[Element]", "\[DoubleStruckCapitalZ]"}], TraditionalForm]], 
  "InlineMath"],
 ", you have integer and mixed integer-real optimization problems. \
Additionally, optimization algorithms can be divided into numeric and \
symbolic (exact) algorithms."
}], "Text",
 CellID->536730383],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions for constrained optimization include ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NMaximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMaximize"]], "InlineFormula"],
 " for global constrained optimization, ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " for local constrained optimization, and ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinearProgramming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearProgramming"],
   FontFamily->"Courier"]], "InlineFormula"],
 " for efficient and direct access to linear programming methods. The \
following table briefly summarizes each of the functions."
}], "Text",
 CellID->98440369],

Cell[BoxData[GridBox[{
   {Cell["Function", "TableHeader"], Cell["Solves", "TableHeader"], Cell[
    "Algorithms", "TableHeader"]},
   {
    RowBox[{
     ButtonBox["FindMinimum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindMinimum"], Cell[", ", "TableText"], 
     ButtonBox["FindMaximum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindMaximum"]}], Cell[
    "numeric local optimization", "TableText"], Cell["\<\
linear programming methods, nonlinear interior point algorithms, utilize \
second derivatives\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["NMinimize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NMinimize"], Cell[", ", "TableText"], 
     ButtonBox["NMaximize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NMaximize"]}], Cell[
    "numeric global optimization", "TableText"], Cell["\<\
linear programming methods, Nelder-Mead, differential evolution, simulated \
annealing, random search\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Minimize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Minimize"], Cell[", ", "TableText"], 
     ButtonBox["Maximize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Maximize"]}], Cell[
    "exact global optimization", "TableText"], Cell["\<\
linear programming methods, cylindrical algebraic decomposition, Lagrange \
multipliers and other analytic methods, integer linear programming\
\>", "TableText"]},
   {
    ButtonBox["LinearProgramming",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LinearProgramming"], Cell[
    "linear optimization", "TableText"], Cell["\<\
linear programming methods (simplex, revised simplex, interior point)\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.33], 
     Scaled[0.3], {
      Scaled[0.37]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->30119049],

Cell["Summary of constrained optimization functions.", "Caption",
 CellTags->"b:0.2.0",
 CellID->164158555],

Cell["\<\
Here is a decision tree to help in deciding which optimization function to \
use.\
\>", "Text",
 CellID->1374080272],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->26492378],

Cell[TextData[ButtonBox["Constrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationOverview"]], "RelatedTutorials",
 CellID->1633042],

Cell[TextData[ButtonBox["Linear Programming",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming"]], \
"RelatedTutorials",
 CellID->282186215],

Cell[TextData[ButtonBox["Numerical Nonlinear Local Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLocalNumerical"]], \
"RelatedTutorials",
 CellID->511088424],

Cell[TextData[ButtonBox["Numerical Nonlinear Global Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationGlobalNumerical"]], \
"RelatedTutorials",
 CellID->125693634],

Cell[TextData[ButtonBox["Exact Global Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationExact"]], "RelatedTutorials",
 CellID->140984286]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction to Constrained Optimization in Mathematica - \
Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 31.3272932}", "context" -> "", 
    "keywords" -> {
     "constrained optimization", "nonlinear optimization", 
      "nonlinear programming", "linear programming", "finding a minimum"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Constrained optimization problems are problems for which a function f(x) \
is to be minimized or maximized subject to constraints \\[CapitalPhi](x). \
Here f:\\[DoubleStruckCapitalR]^n-> \\[DoubleStruckCapitalR] is called the \
objective function and \\[CapitalPhi](x) is a Boolean-valued formula. In \
Mathematica the constraints \\[CapitalPhi](x) can be an arbitrary Boolean \
combination of equations g(x)==0, weak inequalities g(x)>=0, strict \
inequalities g(x)>0, and x\\[Element]\\[DoubleStruckCapitalZ] statements. The \
following notation will be used. stands for \"minimize f(x) subject to \
constraints \\[CapitalPhi](x)\", and stands for \"maximize f(x) subject to \
constraints \\[CapitalPhi](x)\".", "synonyms" -> {}, "title" -> 
    "Introduction to Constrained Optimization in Mathematica", "type" -> 
    "Tutorial", "uri" -> "tutorial/ConstrainedOptimizationIntroduction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:0.2.1"->{
  Cell[8773, 310, 174, 5, 70, "MathCaption",
   CellTags->"b:0.2.1",
   CellID->117718009],
  Cell[10183, 361, 191, 5, 70, "MathCaption",
   CellTags->"b:0.2.1",
   CellID->127637934],
  Cell[11528, 408, 193, 5, 70, "MathCaption",
   CellTags->"b:0.2.1",
   CellID->223549055],
  Cell[13834, 502, 267, 9, 70, "MathCaption",
   CellTags->"b:0.2.1",
   CellID->24916071]},
 "b:0.2.0"->{
  Cell[22697, 763, 107, 2, 70, "Caption",
   CellTags->"b:0.2.0",
   CellID->164158555]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:0.2.1", 26181, 860},
 {"b:0.2.0", 26566, 873}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1443, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2068, 58, 145, 5, 70, "Title",
 CellID->248488806],
Cell[CellGroupData[{
Cell[2238, 67, 61, 1, 70, "Section",
 CellID->1039976465],
Cell[2302, 70, 1646, 55, 70, "Text",
 CellID->97759825],
Cell[3951, 127, 265, 8, 70, "NumberedEquation",
 CellID->359556120],
Cell[4219, 137, 315, 12, 70, "Text",
 CellID->396584907],
Cell[4537, 151, 262, 8, 70, "NumberedEquation",
 CellID->655247],
Cell[4802, 161, 311, 12, 70, "Text",
 CellID->116540820],
Cell[5116, 175, 454, 17, 70, "Text",
 CellID->413926793],
Cell[5573, 194, 184, 4, 70, "Text",
 CellID->167519381]
}, Open  ]],
Cell[CellGroupData[{
Cell[5794, 203, 58, 1, 70, "Section",
 CellID->170940268],
Cell[5855, 206, 806, 27, 70, "Text",
 CellID->190074994],
Cell[6664, 235, 787, 26, 70, "Text",
 CellID->136330640],
Cell[7454, 263, 905, 32, 70, "Text",
 CellID->130027821],
Cell[8362, 297, 408, 11, 70, "Text",
 CellID->437897756],
Cell[8773, 310, 174, 5, 70, "MathCaption",
 CellTags->"b:0.2.1",
 CellID->117718009],
Cell[CellGroupData[{
Cell[8972, 319, 341, 12, 70, "Input",
 CellID->741406091],
Cell[9316, 333, 492, 10, 70, "Message",
 CellID->135930097],
Cell[9811, 345, 357, 13, 36, "Output",
 CellID->48659934]
}, Open  ]],
Cell[10183, 361, 191, 5, 70, "MathCaption",
 CellTags->"b:0.2.1",
 CellID->127637934],
Cell[CellGroupData[{
Cell[10399, 370, 312, 11, 70, "Input",
 CellID->521050388],
Cell[10714, 383, 455, 9, 70, "Message",
 CellID->726481233],
Cell[11172, 394, 341, 11, 36, "Output",
 CellID->504337622]
}, Open  ]],
Cell[11528, 408, 193, 5, 70, "MathCaption",
 CellTags->"b:0.2.1",
 CellID->223549055],
Cell[CellGroupData[{
Cell[11746, 417, 418, 15, 70, "Input",
 CellID->545282996],
Cell[12167, 434, 317, 11, 36, "Output",
 CellID->481567585]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12533, 451, 57, 1, 70, "Section",
 CellID->171458460],
Cell[12593, 454, 1101, 40, 70, "Text",
 CellID->154253],
Cell[13697, 496, 134, 4, 70, "Text",
 CellID->235688859],
Cell[13834, 502, 267, 9, 70, "MathCaption",
 CellTags->"b:0.2.1",
 CellID->24916071],
Cell[CellGroupData[{
Cell[14126, 515, 401, 14, 70, "Input",
 CellID->606801206],
Cell[14530, 531, 296, 10, 36, "Output",
 CellID->954435823]
}, Open  ]],
Cell[CellGroupData[{
Cell[14863, 546, 371, 13, 70, "Input",
 CellID->694322071],
Cell[15237, 561, 278, 10, 36, "Output",
 CellID->94122306]
}, Open  ]],
Cell[CellGroupData[{
Cell[15552, 576, 402, 14, 30, "Input",
 CellID->896034415],
Cell[15957, 592, 2670, 48, 124, "Output",
 Evaluatable->False,
 CellID->451051461]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18676, 646, 67, 1, 70, "Section",
 CellID->32353590],
Cell[18746, 649, 694, 14, 70, "Text",
 CellID->536730383],
Cell[19443, 665, 1176, 38, 70, "Text",
 CellID->98440369],
Cell[20622, 705, 2072, 56, 70, "DefinitionBox3Col",
 CellID->30119049],
Cell[22697, 763, 107, 2, 70, "Caption",
 CellTags->"b:0.2.0",
 CellID->164158555],
Cell[22807, 767, 126, 4, 70, "Text",
 CellID->1374080272],
Cell[CellGroupData[{
Cell[22958, 775, 71, 1, 70, "RelatedTutorialsSection",
 CellID->26492378],
Cell[23032, 778, 178, 4, 70, "RelatedTutorials",
 CellID->1633042],
Cell[23213, 784, 185, 5, 70, "RelatedTutorials",
 CellID->282186215],
Cell[23401, 791, 202, 5, 70, "RelatedTutorials",
 CellID->511088424],
Cell[23606, 798, 204, 5, 70, "RelatedTutorials",
 CellID->125693634],
Cell[23813, 805, 178, 4, 70, "RelatedTutorials",
 CellID->140984286]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[24030, 814, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

