(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18895,        672]
NotebookOptionsPosition[     13244,        490]
NotebookOutlinePosition[     14578,        527]
CellTagsIndexPosition[     14535,        524]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA OVERVIEW", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Constrained Optimization", "TOCDocumentTitle"],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationIntroduction#248488806"]], \
"TOCChapter",
 CellID->293365741],

Cell[TextData[ButtonBox["Optimization Problems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationIntroduction#248488806"]], \
"TOCSection",
 CellID->1990822444],

Cell[TextData[ButtonBox["Global Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationIntroduction#170940268"]], \
"TOCSection",
 CellID->2123039122],

Cell[TextData[ButtonBox["Local Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationIntroduction#171458460"]], \
"TOCSection",
 CellID->1477728549],

Cell[TextData[ButtonBox["Solving Optimization Problems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationIntroduction#32353590"]], \
"TOCSection",
 CellID->535345488]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Linear Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming#100661346"]], \
"TOCChapter",
 CellID->824513345],

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming#430238072"]], \
"TOCSection",
 CellID->2031298971],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["The LinearProgramming Function",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming#113426546"]], \
"TOCSection",
 CellID->1494269238],

Cell[TextData[ButtonBox["Options for LinearProgramming",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming#40914068"]], \
"TOCSubsection",
 CellID->1509315048]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Examples",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming#414335858"]], \
"TOCSection",
 CellID->981173372],

Cell[TextData[ButtonBox["Difference Between Interior Point and Simplex and/or \
Revised Simplex",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming#589526112"]], \
"TOCSubsection",
 CellID->53937891],

Cell[TextData[ButtonBox["Finding Dual Variables",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming#224700240"]], \
"TOCSubsection",
 CellID->296035003],

Cell[TextData[ButtonBox["Dealing with Infeasibility and Unboundedness in the \
Interior Point Method",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming#512388034"]], \
"TOCSubsection",
 CellID->1888168969],

Cell[TextData[ButtonBox["The Method Options of \"InteriorPoint\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming#605660219"]], \
"TOCSubsection",
 CellID->1090010264]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Importing Large Data Sets and Solving Large-Scale \
Problems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming#9813130"]], \
"TOCSection",
 CellID->1766998138],

Cell[TextData[ButtonBox["Importing MPS Formatted Files in Equation Form",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming#208553956"]], \
"TOCSubsection",
 CellID->386351003],

Cell[TextData[ButtonBox["Large-Scale Problems: Importing in Matrix and Vector \
Form",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming#445507631"]], \
"TOCSubsection",
 CellID->1558242540],

Cell[TextData[ButtonBox["Free Formatted MPS Files",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming#298767088"]], \
"TOCSubsection",
 CellID->819294615]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Application Examples of Linear Programming",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming#261990371"]], \
"TOCSection",
 CellID->219449741],

Cell[TextData[ButtonBox["L1 Norm Minimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming#293106634"]], \
"TOCSubsection",
 CellID->1062375088],

Cell[TextData[ButtonBox["Design of an Optimal Anchor",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming#326994842"]], \
"TOCSubsection",
 CellID->1159062858]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Algorithms for Linear Programming",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming#38991160"]], \
"TOCSection",
 CellID->545292469],

Cell[TextData[ButtonBox["Simplex and Revised Simplex Algorithms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming#160402625"]], \
"TOCSubsection",
 CellID->1417804734],

Cell[TextData[ButtonBox["Interior Point Algorithm",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLinearProgramming#155201634"]], \
"TOCSubsection",
 CellID->565617226]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Numerical Nonlinear Local Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLocalNumerical#85183321"]], \
"TOCChapter",
 CellID->1832616058],

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLocalNumerical#469184158"]], \
"TOCSection",
 CellID->1567621532],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["The FindMinimum Function",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLocalNumerical#73716527"]], \
"TOCSection",
 CellID->1685706928],

Cell[TextData[ButtonBox["Options for FindMinimum",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLocalNumerical#396232162"]], \
"TOCSubsection",
 CellID->2072067672]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Examples of FindMinimum",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLocalNumerical#804055587"]], \
"TOCSection",
 CellID->1646543552],

Cell[TextData[ButtonBox["Finding a Global Minimum",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLocalNumerical#92384034"]], \
"TOCSubsection",
 CellID->983203222],

Cell[TextData[ButtonBox["An Application Example",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLocalNumerical#609426104"]], \
"TOCSubsection",
 CellID->1957372136],

Cell[TextData[ButtonBox["Limitations of Interior Point Method",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLocalNumerical#417182119"]], \
"TOCSubsection",
 CellID->251501359]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Numerical Algorithms for Constrained Local \
Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLocalNumerical#442312913"]], \
"TOCSection",
 CellID->735523417],

Cell[TextData[ButtonBox["The Interior Point Algorithm",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationLocalNumerical#2552526"]], \
"TOCSubsection",
 CellID->1026197387]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Numerical Nonlinear Global Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationGlobalNumerical#85183321"]], \
"TOCChapter"],

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationGlobalNumerical#469184158"]], \
"TOCSection"],

Cell[TextData[ButtonBox["The NMinimize Function",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationGlobalNumerical#217856200"]], \
"TOCSection"],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Numerical Algorithms for Constrained Global \
Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationGlobalNumerical#252245038"]], \
"TOCSection"],

Cell[TextData[ButtonBox["Nelder\[Dash]Mead",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationGlobalNumerical#323477034"]], \
"TOCSubsection"],

Cell[TextData[ButtonBox["Differential Evolution",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationGlobalNumerical#24713453"]], \
"TOCSubsection"],

Cell[TextData[ButtonBox["Simulated Annealing",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationGlobalNumerical#7062708"]], \
"TOCSubsection"],

Cell[TextData[ButtonBox["Random Search",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationGlobalNumerical#155930577"]], \
"TOCSubsection"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Exact Global Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationExact#509267359"]], "TOCChapter",
 CellID->1566095760],

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationExact#412364824"]], "TOCSection",
 CellID->1811860688],

Cell[TextData[ButtonBox["Algorithms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationExact#248466559"]], "TOCSection",
 CellID->624468756],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Optimization by Cylindrical Algebraic Decomposition",
 
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationExact#828680012"]], "TOCSection",
 CellID->693799203],

Cell[TextData[ButtonBox["Examples",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationExact#370765765"]], "TOCSubsection",\

 CellID->1994485258],

Cell[TextData[ButtonBox["Customized CAD Algorithm for Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationExact#4979907"]], "TOCSubsection",
 CellID->1241485183],

Cell[TextData[ButtonBox["Reduction to Minimizing a Coordinate Function",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationExact#211764667"]], "TOCSubsection",\

 CellID->690356429],

Cell[TextData[ButtonBox["The Projection Phase of CAD",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationExact#215663124"]], "TOCSubsection",\

 CellID->2113841109],

Cell[TextData[ButtonBox["The Lifting Phase of CAD",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationExact#431999683"]], "TOCSubsection",\

 CellID->1505546642],

Cell[TextData[ButtonBox["Strict Inequality Constraints",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationExact#289075302"]], "TOCSubsection",\

 CellID->2070083140]
}, Open  ]],

Cell[TextData[ButtonBox["Linear Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationExact#765665707"]], "TOCSection",
 CellID->504768933],

Cell[TextData[ButtonBox["Univariate Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationExact#132591628"]], "TOCSection",
 CellID->1091051281],

Cell[TextData[ButtonBox["Optimization by Finding Stationary and Singular \
Points",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationExact#60567692"]], "TOCSection",
 CellID->2083501681],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Optimization over the Integers",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationExact#7488435"]], "TOCSection",
 CellID->544404585],

Cell[TextData[ButtonBox["Integer Linear Programming",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationExact#683534434"]], "TOCSubsection",\

 CellID->1527523875],

Cell[TextData[ButtonBox["Optimization over the Reals Combined with Integer \
Solution Finding",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationExact#544345886"]], "TOCSubsection",\

 CellID->2074250887]
}, Open  ]]
}, Open  ]],

Cell[TextData[ButtonBox["Comparison of Constrained Optimization Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationComparison#85183321"]], "TOCChapter",\

 CellID->858314252],

Cell[TextData[ButtonBox["Constrained Optimization References",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConstrainedOptimizationReferences"]], "TOCChapter",
 CellID->878065497],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Constrained Optimization - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 36.4993006}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Overview", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Introduction Linear Optimization Numerical Nonlinear Local Optimization",
     "synonyms" -> {}, "title" -> "Constrained Optimization", "type" -> 
    "Overview", "uri" -> "tutorial/ConstrainedOptimizationOverview"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[704, 27, 52, 0, 70, "TOCDocumentTitle"],
Cell[CellGroupData[{
Cell[781, 31, 178, 5, 70, "TOCChapter",
 CellID->293365741],
Cell[962, 38, 188, 5, 70, "TOCSection",
 CellID->1990822444],
Cell[1153, 45, 186, 5, 70, "TOCSection",
 CellID->2123039122],
Cell[1342, 52, 185, 5, 70, "TOCSection",
 CellID->1477728549],
Cell[1530, 59, 194, 5, 70, "TOCSection",
 CellID->535345488]
}, Open  ]],
Cell[CellGroupData[{
Cell[1761, 69, 190, 5, 70, "TOCChapter",
 CellID->824513345],
Cell[1954, 76, 184, 5, 70, "TOCSection",
 CellID->2031298971],
Cell[CellGroupData[{
Cell[2163, 85, 202, 5, 70, "TOCSection",
 CellID->1494269238],
Cell[2368, 92, 203, 5, 70, "TOCSubsection",
 CellID->1509315048]
}, Open  ]],
Cell[CellGroupData[{
Cell[2608, 102, 179, 5, 70, "TOCSection",
 CellID->981173372],
Cell[2790, 109, 243, 6, 70, "TOCSubsection",
 CellID->53937891],
Cell[3036, 117, 196, 5, 70, "TOCSubsection",
 CellID->296035003],
Cell[3235, 124, 250, 6, 70, "TOCSubsection",
 CellID->1888168969],
Cell[3488, 132, 214, 5, 70, "TOCSubsection",
 CellID->1090010264]
}, Open  ]],
Cell[CellGroupData[{
Cell[3739, 142, 230, 6, 70, "TOCSection",
 CellID->1766998138],
Cell[3972, 150, 220, 5, 70, "TOCSubsection",
 CellID->386351003],
Cell[4195, 157, 234, 6, 70, "TOCSubsection",
 CellID->1558242540],
Cell[4432, 165, 198, 5, 70, "TOCSubsection",
 CellID->819294615]
}, Open  ]],
Cell[CellGroupData[{
Cell[4667, 175, 213, 5, 70, "TOCSection",
 CellID->219449741],
Cell[4883, 182, 195, 5, 70, "TOCSubsection",
 CellID->1062375088],
Cell[5081, 189, 202, 5, 70, "TOCSubsection",
 CellID->1159062858]
}, Open  ]],
Cell[CellGroupData[{
Cell[5320, 199, 203, 5, 70, "TOCSection",
 CellID->545292469],
Cell[5526, 206, 213, 5, 70, "TOCSubsection",
 CellID->1417804734],
Cell[5742, 213, 198, 5, 70, "TOCSubsection",
 CellID->565617226]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5989, 224, 206, 5, 70, "TOCChapter",
 CellID->1832616058],
Cell[6198, 231, 181, 5, 70, "TOCSection",
 CellID->1567621532],
Cell[CellGroupData[{
Cell[6404, 240, 192, 5, 70, "TOCSection",
 CellID->1685706928],
Cell[6599, 247, 195, 5, 70, "TOCSubsection",
 CellID->2072067672]
}, Open  ]],
Cell[CellGroupData[{
Cell[6831, 257, 192, 5, 70, "TOCSection",
 CellID->1646543552],
Cell[7026, 264, 194, 5, 70, "TOCSubsection",
 CellID->983203222],
Cell[7223, 271, 194, 5, 70, "TOCSubsection",
 CellID->1957372136],
Cell[7420, 278, 207, 5, 70, "TOCSubsection",
 CellID->251501359]
}, Open  ]],
Cell[CellGroupData[{
Cell[7664, 288, 225, 6, 70, "TOCSection",
 CellID->735523417],
Cell[7892, 296, 198, 5, 70, "TOCSubsection",
 CellID->1026197387]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8139, 307, 187, 4, 70, "TOCChapter"],
Cell[8329, 313, 161, 4, 70, "TOCSection"],
Cell[8493, 319, 171, 4, 70, "TOCSection"],
Cell[CellGroupData[{
Cell[8689, 327, 207, 5, 70, "TOCSection"],
Cell[8899, 334, 169, 4, 70, "TOCSubsection"],
Cell[9071, 340, 173, 4, 70, "TOCSubsection"],
Cell[9247, 346, 169, 4, 70, "TOCSubsection"],
Cell[9419, 352, 165, 4, 70, "TOCSubsection"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9633, 362, 183, 4, 70, "TOCChapter",
 CellID->1566095760],
Cell[9819, 368, 170, 4, 70, "TOCSection",
 CellID->1811860688],
Cell[9992, 374, 167, 4, 70, "TOCSection",
 CellID->624468756],
Cell[CellGroupData[{
Cell[10184, 382, 210, 5, 70, "TOCSection",
 CellID->693799203],
Cell[10397, 389, 171, 5, 70, "TOCSubsection",
 CellID->1994485258],
Cell[10571, 396, 200, 4, 70, "TOCSubsection",
 CellID->1241485183],
Cell[10774, 402, 207, 5, 70, "TOCSubsection",
 CellID->690356429],
Cell[10984, 409, 190, 5, 70, "TOCSubsection",
 CellID->2113841109],
Cell[11177, 416, 187, 5, 70, "TOCSubsection",
 CellID->1505546642],
Cell[11367, 423, 192, 5, 70, "TOCSubsection",
 CellID->2070083140]
}, Open  ]],
Cell[11574, 431, 176, 4, 70, "TOCSection",
 CellID->504768933],
Cell[11753, 437, 181, 4, 70, "TOCSection",
 CellID->1091051281],
Cell[11937, 443, 213, 5, 70, "TOCSection",
 CellID->2083501681],
Cell[CellGroupData[{
Cell[12175, 452, 185, 4, 70, "TOCSection",
 CellID->544404585],
Cell[12363, 458, 189, 5, 70, "TOCSubsection",
 CellID->1527523875],
Cell[12555, 465, 231, 6, 70, "TOCSubsection",
 CellID->2074250887]
}, Open  ]]
}, Open  ]],
Cell[12813, 475, 211, 5, 70, "TOCChapter",
 CellID->858314252],
Cell[13027, 482, 187, 4, 70, "TOCChapter",
 CellID->878065497],
Cell[13217, 488, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

