(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36017,       1293]
NotebookOptionsPosition[     26981,       1003]
NotebookOutlinePosition[     30493,       1084]
CellTagsIndexPosition[     30400,       1078]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Modularity and the Naming of Things" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Modularity and the Naming of Things\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Clear" :> Documentation`HelpLookup["paclet:ref/Clear"], 
          "Context" :> Documentation`HelpLookup["paclet:ref/Context"], 
          "Contexts" :> Documentation`HelpLookup["paclet:ref/Contexts"], 
          "Remove" :> Documentation`HelpLookup["paclet:ref/Remove"], 
          "$Context" :> Documentation`HelpLookup["paclet:ref/$Context"], 
          "$ContextPath" :> 
          Documentation`HelpLookup["paclet:ref/$ContextPath"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Clear\"\>", 2->"\<\"Context\"\>", 
       3->"\<\"Contexts\"\>", 4->"\<\"Remove\"\>", 5->"\<\"$Context\"\>", 
       6->"\<\"$ContextPath\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Contexts", "Title",
 CellTags->{"S2.7.8", "8.1"},
 CellID->27982],

Cell["\<\
It is always a good idea to give variables and functions names that are as \
explicit as possible. Sometimes, however, such names may get inconveniently \
long. \
\>", "Text",
 CellID->481],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you can use the notion of \[OpenCurlyDoubleQuote]contexts\
\[CloseCurlyDoubleQuote] to organize the names of symbols. Contexts are \
particularly important in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages which introduce symbols whose names must not conflict with those \
of any other symbols. If you write ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages, or make sophisticated use of packages that others have written, \
then you will need to know about contexts. "
}], "Text",
 CellID->4144],

Cell[TextData[{
 "The basic idea is that the ",
 StyleBox["full name",
  FontSlant->"Italic"],
 " of any symbol is broken into two parts: a ",
 StyleBox["context",
  FontSlant->"Italic"],
 " and a ",
 StyleBox["short name",
  FontSlant->"Italic"],
 ". The full name is written as ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["context", "TI"], "`", 
    StyleBox["short", "TI"]}]]], "InlineFormula"],
 ", where the ",
 Cell[BoxData["`"], "InlineFormula"],
 " is the backquote or grave accent character (ASCII decimal code 96), called \
a \[OpenCurlyDoubleQuote]context mark\[CloseCurlyDoubleQuote] in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->23196],

Cell[TextData[{
 "Here is a symbol with short name ",
 Cell[BoxData["x"], "InlineFormula"],
 ", and context ",
 Cell[BoxData["aaaa"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20222],

Cell[CellGroupData[{

Cell[BoxData["aaaa`x"], "Input",
 CellLabel->"In[1]:=",
 CellID->7129],

Cell[BoxData["aaaa`x"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51680573]
}, Open  ]],

Cell["You can use this symbol just like any other symbol. ", "MathCaption",
 CellID->5535],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "^", "2"}], "-", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20450],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "aaaa`x"}], "+", 
  SuperscriptBox["aaaa`x", "2"]}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1117725137]
}, Open  ]],

Cell["You can for example define a value for the symbol. ", "MathCaption",
 CellID->10466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"aaaa`x", "=", "78"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12044],

Cell[BoxData["78"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->124948519]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " treats ",
 Cell[BoxData["a`x"], "InlineFormula"],
 " and ",
 Cell[BoxData["b`x"], "InlineFormula"],
 " as completely different symbols. "
}], "MathCaption",
 CellID->26292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a`x", "==", "b`x"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->26439],

Cell[BoxData[
 RowBox[{"a`x", "\[Equal]", "b`x"}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->164257850]
}, Open  ]],

Cell[TextData[{
 "It is typical to have all the symbols that relate a particular topic in a \
particular context. Thus, for example, symbols that represent physical units \
might have a context ",
 Cell[BoxData["PhysicalUnits`"], "InlineFormula"],
 ". Such symbols might have full names like ",
 Cell[BoxData["PhysicalUnits`Joule"], "InlineFormula"],
 " or ",
 Cell[BoxData["PhysicalUnits`Mole"], "InlineFormula"],
 ". "
}], "Text",
 CellID->20024],

Cell["\<\
Although you can always refer to a symbol by its full name, it is often \
convenient to use a shorter name. \
\>", "Text",
 CellID->26154],

Cell[TextData[{
 "At any given point in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, there is always a ",
 StyleBox["current",
  FontSlant->"Italic"],
 " ",
 StyleBox["context",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 ". You can refer to symbols that are in this context simply by giving their \
short names. "
}], "Text",
 CellID->29510],

Cell[TextData[{
 "The default context for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sessions is ",
 Cell[BoxData["Global`"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4745],

Cell[CellGroupData[{

Cell[BoxData["$Context"], "Input",
 CellLabel->"In[5]:=",
 CellID->20649],

Cell[BoxData["\<\"Global`\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->454348048]
}, Open  ]],

Cell["\<\
Short names are sufficient for symbols that are in the current context. \
\>", "MathCaption",
 CellID->8313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "Global`x"}], "}"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->4474],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "x"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->556656442]
}, Open  ]],

Cell[TextData[{
 "Contexts in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " work somewhat like file directories in many operating systems. You can \
always specify a particular file by giving its complete name, including its \
directory. But at any given point, there is usually a current working \
directory, analogous to the current ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " context. Files that are in this directory can then be specified just by \
giving their short names. "
}], "Text",
 CellID->2168],

Cell[TextData[{
 "Like directories in many operating systems, contexts in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can be hierarchical. Thus, for example, the full name of a symbol can \
involve a sequence of context names, as in ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["c", "TI"], 
    StyleBox["1", "TR"]], 
   SubscriptBox[
    StyleBox[
     RowBox[{"`", 
      StyleBox["c", "TI"]}]], 
    StyleBox["2", "TR"]], 
   SubscriptBox[
    StyleBox[
     RowBox[{"`", 
      StyleBox["c", "TI"]}]], 
    StyleBox["3", "TR"]], 
   StyleBox[
    RowBox[{"`", 
     StyleBox["name", "TI"]}]]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->14018],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["context", "TI"], 
     StyleBox["`", "MR"], 
     StyleBox["name", "TI"], Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["1", "TR"]], "`", 
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["2", "TR"]], "`", 
     StyleBox["\[Ellipsis]", "TR"], 
     StyleBox["`", "MR"], 
     StyleBox["name", "TI"]}], Cell[
    "a symbol in an explicitly specified context", "TableText"]},
   {
    RowBox[{
     StyleBox["`", "MR"], 
     StyleBox["name", "TI"]}], Cell[
    "a symbol in the current context", "TableText"]},
   {
    RowBox[{
     StyleBox["`", "MR"], 
     StyleBox["context", "TI"], 
     StyleBox["`", "MR"], 
     StyleBox["name", "TI"], Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], "`", 
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["1", "TR"]], Cell["`", "TableText"], 
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["2", "TR"]], Cell["` \[Ellipsis] `", "TableText"], 
     StyleBox["name", "TI"]}], Cell["\<\
a symbol in a specific context relative to the current context\
\>", "TableText"]},
   {
    StyleBox["name", "TI"], Cell["\<\
a symbol in the current context, or found on the context search path\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18787],

Cell["Specifying symbols in various contexts. ", "Caption",
 CellID->9905],

Cell[TextData[{
 "Here is a symbol in the context ",
 Cell[BoxData["a`b`"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17958],

Cell[CellGroupData[{

Cell[BoxData["a`b`x"], "Input",
 CellLabel->"In[7]:=",
 CellID->7391],

Cell[BoxData["a`b`x"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->114724020]
}, Open  ]],

Cell[TextData[{
 "When you start a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, the default current context is ",
 Cell[BoxData["Global`"], "InlineFormula"],
 ". Symbols that you introduce will usually be in this context. However, \
built\[Hyphen]in symbols such as ",
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 " are in the context ",
 Cell[BoxData["System`"], "InlineFormula"],
 ". "
}], "Text",
 CellID->3625],

Cell[TextData[{
 "In order to let you easily access not only symbols in the context ",
 Cell[BoxData["Global`"], "InlineFormula"],
 ", but also in contexts such as ",
 Cell[BoxData["System`"], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports the notion of a ",
 StyleBox["context search path",
  FontSlant->"Italic"],
 ". At any point in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, there is both a current context ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 ", and also a current context search path ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ". The idea of the search path is to allow you to type in the short name of \
a symbol, then have ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " search in a sequence of contexts to find a symbol with that short name. "
}], "Text",
 CellID->26477],

Cell[TextData[{
 "The context search path for symbols in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is analogous to the \[OpenCurlyDoubleQuote]search path\
\[CloseCurlyDoubleQuote] for program files provided in operating systems. "
}], "Text",
 CellID->4414],

Cell["\<\
The default context path includes the contexts for system\[Hyphen]defined \
symbols. \
\>", "MathCaption",
 CellID->9314],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[8]:=",
 CellID->25824],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"System`\"\>", ",", "\<\"Global`\"\>"}], "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->908800597]
}, Open  ]],

Cell[TextData[{
 "When you type in ",
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " interprets it as the symbol with full name ",
 Cell[BoxData["System`Pi"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "Pi", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->24372],

Cell[BoxData["\<\"System`\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->2088666281]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Context",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Context"], "[", 
     StyleBox["s", "TI"], "]"}], Cell[
    "the context of a symbol", "TableText"]},
   {
    ButtonBox["$Context",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Context"], Cell[TextData[{
     "the current context in a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " session"
    }], "TableText"]},
   {
    ButtonBox["$ContextPath",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$ContextPath"], Cell[
    "the current context search path", "TableText"]},
   {
    RowBox[{
     ButtonBox["Contexts",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Contexts"], "[", "]"}], Cell[
    "a list of all contexts", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11833],

Cell["Finding contexts and context search paths. ", "Caption",
 CellID->28070],

Cell[TextData[{
 "When you use contexts in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", there is no reason that two symbols which are in different contexts \
cannot have the same short name. Thus, for example, you can have symbols with \
the short name ",
 Cell[BoxData["Mole"], "InlineFormula"],
 " both in the context ",
 Cell[BoxData["PhysicalUnits`"], "InlineFormula"],
 " and in the context ",
 Cell[BoxData["BiologicalOrganisms`"], "InlineFormula"],
 ". "
}], "Text",
 CellID->7487],

Cell[TextData[{
 "There is, however, then the question of which symbol you actually get when \
you type in only the short name ",
 Cell[BoxData["Mole"], "InlineFormula"],
 ". The answer to this question is determined by which of the contexts comes \
first in the sequence of contexts listed in the context search path. "
}], "Text",
 CellID->28297],

Cell[TextData[{
 "This introduces two symbols, both with short name ",
 Cell[BoxData["Mole"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PhysicalUnits`Mole", ",", "BiologicalOrganisms`Mole"}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8177],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PhysicalUnits`Mole", ",", "BiologicalOrganisms`Mole"}], 
  "}"}]], "Output",
 ImageSize->{324, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->234879415]
}, Open  ]],

Cell[TextData[{
 "This adds two additional contexts to ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ". Typically, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " adds new contexts to the beginning of ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->32270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$ContextPath", "=", 
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<PhysicalUnits`\>\"", ",", "\"\<BiologicalOrganisms`\>\""}], 
     "}"}], ",", "$ContextPath"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1763],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"PhysicalUnits`\"\>", ",", "\<\"BiologicalOrganisms`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"Global`\"\>"}], "}"}]], "Output",
 ImageSize->{388, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->162634169]
}, Open  ]],

Cell[TextData[{
 "Now if you type in ",
 Cell[BoxData["Mole"], "InlineFormula"],
 ", you get the symbol in the context ",
 Cell[BoxData["PhysicalUnits`"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "Mole", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13985],

Cell[BoxData["\<\"PhysicalUnits`\"\>"], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->172797768]
}, Open  ]],

Cell[TextData[{
 "In general, when you type in a short name for a symbol, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that you want the symbol with that name whose context appears \
earliest in the context search path. As a result, symbols with the same short \
name whose contexts appear later in the context search path are effectively \
\[OpenCurlyDoubleQuote]shadowed\[CloseCurlyDoubleQuote]. To refer to these \
symbols, you need to use their full names. "
}], "Text",
 CellID->8480],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " issues a message when you introduce new symbols that \
\[OpenCurlyDoubleQuote]shadow\[CloseCurlyDoubleQuote] existing symbols with \
your current choice for ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ". In addition, in the notebook front end ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " warns you of shadowed symbols by coloring them red. "
}], "Text",
 CellID->29213],

Cell[TextData[{
 "This introduces a symbol with short name ",
 Cell[BoxData["Mole"], "InlineFormula"],
 " in the context ",
 Cell[BoxData["Global`"], "InlineFormula"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " warns you that the new symbol shadows existing symbols with short name ",
 Cell[BoxData["Mole"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7627],

Cell[CellGroupData[{

Cell[BoxData["Global`Mole"], "Input",
 CellLabel->"In[4]:=",
 CellID->4802],

Cell[BoxData[
 RowBox[{
  RowBox[{"Global`Mole", "::", "\<\"shdw\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(\\\"Mole\\\"\\) appears in multiple contexts \\!\\({\
\\\"Global`\\\", \\\"PhysicalUnits`\\\", \\\"BiologicalOrganisms`\\\"}\\); \
definitions in context \\!\\(\\\"Global`\\\"\\) may shadow or be shadowed by \
other definitions. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\
\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/shdw\\\", ButtonNote -> \
\\\"Global`Mole::shdw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[4]:=",
 CellID->347229418],

Cell[BoxData["Global`Mole"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->76472204]
}, Open  ]],

Cell[TextData[{
 "Now when you type in ",
 Cell[BoxData["Mole"], "InlineFormula"],
 ", you get the symbol that appears first in the context path, ",
 Cell[BoxData["PhysicalUnits`"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "Mole", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1543],

Cell[BoxData["\<\"PhysicalUnits`\"\>"], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->5195363]
}, Open  ]],

Cell[TextData[{
 "If you once introduce a symbol which shadows existing symbols, it will \
continue to do so until you either rearrange ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ", or explicitly remove the symbol. You should realize that it is not \
sufficient to clear the ",
 StyleBox["value",
  FontSlant->"Italic"],
 " of the symbol; you need to actually remove the symbol completely from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You can do this using the function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Remove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Remove"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->11023],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Clear",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Clear"], "[", 
     StyleBox["s", "TI"], "]"}], Cell[
    "clear the values of a symbol", "TableText"]},
   {
    RowBox[{
     ButtonBox["Remove",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Remove"], "[", 
     StyleBox["s", "TI"], "]"}], Cell[
    "remove a symbol completely from the system", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29972],

Cell[TextData[{
 "Clearing and removing symbols in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->13061],

Cell[TextData[{
 "This removes the symbol ",
 Cell[BoxData["PhysicalUnits`Mole"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14181],

Cell[BoxData[
 RowBox[{"Remove", "[", "Mole", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->31003],

Cell[TextData[{
 "Now if you type in ",
 Cell[BoxData["Mole"], "InlineFormula"],
 ", you get the symbol ",
 Cell[BoxData["BiologicalOrganisms`Mole"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "Mole", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->17505],

Cell[BoxData["\<\"BiologicalOrganisms`\"\>"], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->51285171]
}, Open  ]],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prints out the name of a symbol, it has to choose whether to give the full \
name, or just the short name. What it does is to give whatever version of the \
name you would have to type in to get the particular symbol, given your \
current settings for ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->22725],

Cell["\<\
The short name is printed for the first symbol, so this would give that \
symbol if you typed it in. \
\>", "MathCaption",
 CellID->13031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"BiologicalOrganisms`Mole", ",", "Global`Mole"}], "}"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->8492],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Mole", ",", "Global`Mole"}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->88632577]
}, Open  ]],

Cell[TextData[{
 "If you type in a short name for which there is no symbol either in the \
current context, or in any context on the context search path, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has to ",
 StyleBox["create",
  FontSlant->"Italic"],
 " a new symbol with this name. It always puts new symbols of this kind in \
the current context, as specified by ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->17222],

Cell[TextData[{
 "This introduces the new symbol with short name ",
 Cell[BoxData["tree"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31286],

Cell[CellGroupData[{

Cell[BoxData["tree"], "Input",
 CellLabel->"In[18]:=",
 CellID->13064],

Cell[BoxData["tree"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->396955103]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " puts ",
 Cell[BoxData["tree"], "InlineFormula"],
 " in the current context ",
 Cell[BoxData["Global`"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "tree", "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->8360],

Cell[BoxData["\<\"Global`\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->738322775]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->35812312],

Cell[TextData[ButtonBox["Modularity and the Naming of Things",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], \
"RelatedTutorials",
 CellID->405226890]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Contexts - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Modularity and the Naming of Things", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/BlocksComparedWithModules"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ContextsAndPackages"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 37.8430850}", "context" -> "", 
    "keywords" -> {
     "`", "accent grave", "back quote", "built-in functions", 
      "builtin functions", "clear", "Context", "`", "Contexts", 
      "creation of symbols", "current context", "directories", 
      "full names of symbols", "global context", "grave accent", "names", 
      "packages", "path", "printing", "Remove", "scoping", "search path", 
      "shadowing of names", "symbols", "system context", "$ContextPath"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "It is always a good idea to give variables and functions names that are \
as explicit as possible. Sometimes, however, such names may get \
inconveniently long. In Mathematica, you can use the notion of 'contexts' to \
organize the names of symbols. Contexts are particularly important in \
Mathematica packages which introduce symbols whose names must not conflict \
with those of any other symbols. If you write Mathematica packages, or make \
sophisticated use of packages that others have written, then you will need to \
know about contexts. The basic idea is that the full name of any symbol is \
broken into two parts: a context and a short name. The full name is written \
as context`short, where the ` is the backquote or grave accent character \
(ASCII decimal code 96), called a 'context mark' in Mathematica. ", 
    "synonyms" -> {"2.7.8"}, "title" -> "Contexts", "type" -> "Tutorial", 
    "uri" -> "tutorial/Contexts"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.7.8"->{
  Cell[2347, 66, 71, 2, 70, "Title",
   CellTags->{"S2.7.8", "8.1"},
   CellID->27982]},
 "8.1"->{
  Cell[2347, 66, 71, 2, 70, "Title",
   CellTags->{"S2.7.8", "8.1"},
   CellID->27982]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.7.8", 30189, 1067},
 {"8.1", 30288, 1071}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1722, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2347, 66, 71, 2, 70, "Title",
 CellTags->{"S2.7.8", "8.1"},
 CellID->27982],
Cell[2421, 70, 199, 5, 70, "Text",
 CellID->481],
Cell[2623, 77, 604, 16, 70, "Text",
 CellID->4144],
Cell[3230, 95, 695, 24, 70, "Text",
 CellID->23196],
Cell[3928, 121, 192, 7, 70, "MathCaption",
 CellID->20222],
Cell[CellGroupData[{
Cell[4145, 132, 70, 2, 28, "Input",
 CellID->7129],
Cell[4218, 136, 162, 5, 36, "Output",
 CellID->51680573]
}, Open  ]],
Cell[4395, 144, 90, 1, 70, "MathCaption",
 CellID->5535],
Cell[CellGroupData[{
Cell[4510, 149, 111, 4, 28, "Input",
 CellID->20450],
Cell[4624, 155, 234, 8, 36, "Output",
 CellID->1117725137]
}, Open  ]],
Cell[4873, 166, 90, 1, 70, "MathCaption",
 CellID->10466],
Cell[CellGroupData[{
Cell[4988, 171, 94, 3, 70, "Input",
 CellID->12044],
Cell[5085, 176, 159, 5, 36, "Output",
 CellID->124948519]
}, Open  ]],
Cell[5259, 184, 240, 9, 70, "MathCaption",
 CellID->26292],
Cell[CellGroupData[{
Cell[5524, 197, 93, 3, 70, "Input",
 CellID->26439],
Cell[5620, 202, 191, 6, 36, "Output",
 CellID->164257850]
}, Open  ]],
Cell[5826, 211, 448, 11, 70, "Text",
 CellID->20024],
Cell[6277, 224, 148, 4, 70, "Text",
 CellID->26154],
Cell[6428, 230, 469, 18, 70, "Text",
 CellID->29510],
Cell[6900, 250, 195, 8, 70, "MathCaption",
 CellID->4745],
Cell[CellGroupData[{
Cell[7120, 262, 73, 2, 70, "Input",
 CellID->20649],
Cell[7196, 266, 172, 5, 36, "Output",
 CellID->454348048]
}, Open  ]],
Cell[7383, 274, 118, 3, 70, "MathCaption",
 CellID->8313],
Cell[CellGroupData[{
Cell[7526, 281, 117, 4, 70, "Input",
 CellID->4474],
Cell[7646, 287, 203, 7, 36, "Output",
 CellID->556656442]
}, Open  ]],
Cell[7864, 297, 527, 13, 70, "Text",
 CellID->2168],
Cell[8394, 312, 676, 26, 70, "Text",
 CellID->14018],
Cell[9073, 340, 1801, 54, 70, "DefinitionBox",
 CellID->18787],
Cell[10877, 396, 74, 1, 70, "Caption",
 CellID->9905],
Cell[10954, 399, 134, 5, 70, "MathCaption",
 CellID->17958],
Cell[CellGroupData[{
Cell[11113, 408, 69, 2, 70, "Input",
 CellID->7391],
Cell[11185, 412, 162, 5, 36, "Output",
 CellID->114724020]
}, Open  ]],
Cell[11362, 420, 496, 16, 70, "Text",
 CellID->3625],
Cell[11861, 438, 1023, 30, 70, "Text",
 CellID->26477],
Cell[12887, 470, 270, 7, 70, "Text",
 CellID->4414],
Cell[13160, 479, 131, 4, 70, "MathCaption",
 CellID->9314],
Cell[CellGroupData[{
Cell[13316, 487, 77, 2, 70, "Input",
 CellID->25824],
Cell[13396, 491, 232, 7, 36, "Output",
 CellID->908800597]
}, Open  ]],
Cell[13643, 501, 336, 13, 70, "MathCaption",
 CellID->25874],
Cell[CellGroupData[{
Cell[14004, 518, 100, 3, 70, "Input",
 CellID->24372],
Cell[14107, 523, 173, 5, 36, "Output",
 CellID->2088666281]
}, Open  ]],
Cell[14295, 531, 1145, 36, 70, "DefinitionBox",
 CellID->11833],
Cell[15443, 569, 78, 1, 70, "Caption",
 CellID->28070],
Cell[15524, 572, 499, 14, 70, "Text",
 CellID->7487],
Cell[16026, 588, 348, 7, 70, "Text",
 CellID->28297],
Cell[16377, 597, 151, 5, 70, "MathCaption",
 CellID->7518],
Cell[CellGroupData[{
Cell[16553, 606, 153, 5, 70, "Input",
 CellID->8177],
Cell[16709, 613, 247, 8, 36, "Output",
 CellID->234879415]
}, Open  ]],
Cell[16971, 624, 462, 16, 70, "MathCaption",
 CellID->32270],
Cell[CellGroupData[{
Cell[17458, 644, 269, 8, 70, "Input",
 CellID->1763],
Cell[17730, 654, 304, 8, 36, "Output",
 CellID->162634169]
}, Open  ]],
Cell[18049, 665, 213, 7, 70, "MathCaption",
 CellID->17192],
Cell[CellGroupData[{
Cell[18287, 676, 102, 3, 70, "Input",
 CellID->13985],
Cell[18392, 681, 180, 5, 36, "Output",
 CellID->172797768]
}, Open  ]],
Cell[18587, 689, 507, 10, 70, "Text",
 CellID->8480],
Cell[19097, 701, 534, 15, 70, "Text",
 CellID->29213],
Cell[19634, 718, 381, 12, 70, "MathCaption",
 CellID->7627],
Cell[CellGroupData[{
Cell[20040, 734, 75, 2, 70, "Input",
 CellID->4802],
Cell[20118, 738, 617, 11, 70, "Message",
 CellID->347229418],
Cell[20738, 751, 167, 5, 36, "Output",
 CellID->76472204]
}, Open  ]],
Cell[20920, 759, 239, 7, 70, "MathCaption",
 CellID->2625],
Cell[CellGroupData[{
Cell[21184, 770, 101, 3, 70, "Input",
 CellID->1543],
Cell[21288, 775, 178, 5, 36, "Output",
 CellID->5195363]
}, Open  ]],
Cell[21481, 783, 775, 23, 70, "Text",
 CellID->11023],
Cell[22259, 808, 755, 23, 70, "DefinitionBox",
 CellID->29972],
Cell[23017, 833, 139, 6, 70, "Caption",
 CellID->13061],
Cell[23159, 841, 140, 5, 70, "MathCaption",
 CellID->14181],
Cell[23302, 848, 101, 3, 70, "Input",
 CellID->31003],
Cell[23406, 853, 208, 7, 70, "MathCaption",
 CellID->27432],
Cell[CellGroupData[{
Cell[23639, 864, 102, 3, 70, "Input",
 CellID->17505],
Cell[23744, 869, 185, 5, 36, "Output",
 CellID->51285171]
}, Open  ]],
Cell[23944, 877, 622, 19, 70, "Text",
 CellID->22725],
Cell[24569, 898, 148, 4, 70, "MathCaption",
 CellID->13031],
Cell[CellGroupData[{
Cell[24742, 906, 143, 4, 70, "Input",
 CellID->8492],
Cell[24888, 912, 216, 7, 36, "Output",
 CellID->88632577]
}, Open  ]],
Cell[25119, 922, 537, 16, 70, "Text",
 CellID->17222],
Cell[25659, 940, 149, 5, 70, "MathCaption",
 CellID->31286],
Cell[CellGroupData[{
Cell[25833, 949, 70, 2, 70, "Input",
 CellID->13064],
Cell[25906, 953, 162, 5, 36, "Output",
 CellID->396955103]
}, Open  ]],
Cell[26083, 961, 230, 9, 70, "MathCaption",
 CellID->19187],
Cell[CellGroupData[{
Cell[26338, 974, 102, 3, 70, "Input",
 CellID->8360],
Cell[26443, 979, 173, 5, 36, "Output",
 CellID->738322775]
}, Open  ]],
Cell[CellGroupData[{
Cell[26653, 989, 71, 1, 70, "RelatedTutorialsSection",
 CellID->35812312],
Cell[26727, 992, 200, 5, 70, "RelatedTutorials",
 CellID->405226890]
}, Open  ]]
}, Open  ]],
Cell[26954, 1001, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

