(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18017,        609]
NotebookOptionsPosition[     12284,        430]
NotebookOutlinePosition[     15228,        504]
CellTagsIndexPosition[     15137,        498]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Modularity and the Naming of Things" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"], 
          "Mathematica Packages" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaPackages"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Modularity and the Naming of Things\"\>", 
       2->"\<\"Mathematica Packages\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$Packages" :> 
          Documentation`HelpLookup["paclet:ref/$Packages"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"$Packages\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Contexts and Packages", "Title",
 CellTags->{"S2.7.9", "9.1"},
 CellID->3434],

Cell[TextData[{
 "A typical package written in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " introduces several new symbols intended for use outside the package. These \
symbols may correspond for example to new functions or new objects defined in \
the package. "
}], "Text",
 CellID->16549],

Cell[TextData[{
 "There is a general convention that all new symbols introduced in a \
particular package are put into a context whose name is related to the name \
of the package. When you read in the package, it adds this context at the \
beginning of your context search path ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->7441],

Cell["This reads in a package for proving primality.", "MathCaption",
 CellID->9512],

Cell[BoxData[
 RowBox[{"<<", "PrimalityProving`"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30145],

Cell[TextData[{
 "The package prepends its context to ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18060],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[3]:=",
 CellID->1428237801],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"PrimalityProving`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"Global`\"\>"}], "}"}]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->453262091]
}, Open  ]],

Cell[TextData[{
 "The symbol ",
 Cell[BoxData["ProvablePrimeQ"], "InlineFormula"],
 " is in the context set up by the package. "
}], "MathCaption",
 CellID->16139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "ProvablePrimeQ", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->12423],

Cell[BoxData["\<\"PrimalityProving`\"\>"], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->98211406]
}, Open  ]],

Cell["You can refer to the symbol using its short name. ", "MathCaption",
 CellID->25996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProvablePrimeQ", "[", "2143", "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->16687],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->1371659746]
}, Open  ]],

Cell[TextData[{
 "The full names of symbols defined in packages are often quite long. In most \
cases, however, you will only need to use their short names. The reason for \
this is that after you have read in a package, its context is added to ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ", so the context is automatically searched whenever you type in a short \
name. "
}], "Text",
 CellID->22549],

Cell[TextData[{
 "There is a complication, however, when two symbols with the same short name \
appear in two different packages. In such a case, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will warn you when you read in the second package. It will tell you which \
symbols will be \[OpenCurlyDoubleQuote]shadowed\[CloseCurlyDoubleQuote] by \
the new symbols that are being introduced. "
}], "Text",
 CellID->17437],

Cell[TextData[{
 "The symbol ",
 Cell[BoxData["ProvablePrimeQ"], "InlineFormula"],
 " in the context ",
 Cell[BoxData["PrimalityProving`"], "InlineFormula"],
 " is shadowed by the symbol with the same short name in the new package. "
}], "MathCaption",
 CellID->19866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "NewPrimalityProving`"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->248400477],

Cell[BoxData[
 RowBox[{
  RowBox[{"ProvablePrimeQ", "::", "\<\"shdw\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(\\\"ProvablePrimeQ\\\"\\) appears in multiple \
contexts \\!\\({\\\"NewPrimalityProving`\\\", \\\"PrimalityProving`\\\"}\\); \
definitions in context \\!\\(\\\"NewPrimalityProving`\\\"\\) may shadow or be \
shadowed by other definitions. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/shdw\\\", ButtonNote -> \
\\\"NewPrimalityProving`ProvablePrimeQ::shdw\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellLabel->"During evaluation of In[11]:=",
 CellID->683517070]
}, Open  ]],

Cell["You can access the shadowed symbol by giving its full name. ", \
"MathCaption",
 CellID->23195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimalityProving`ProvablePrimeQ", "[", "2143", "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->981367687],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->1172306449]
}, Open  ]],

Cell[TextData[{
 "Conflicts can occur not only between symbols in different packages, but \
also between symbols in packages and symbols that you introduce directly in \
your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. If you define a symbol in your current context, then this symbol \
may become shadowed by another symbol with the same short name in packages \
that you read in. The reason for this is that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " searches for symbols in contexts on the context search path before looking \
in the current context. "
}], "Text",
 CellID->28286],

Cell["This defines a function in the current context. ", "MathCaption",
 CellID->16105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Div", "[", "f_", "]"}], "=", 
  RowBox[{"1", "/", "f"}]}]], "Input",
 CellLabel->"In[12]:=",
 CellID->24488],

Cell[BoxData[
 FractionBox["1", "f"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->1939510765]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["Div"], "InlineFormula"],
 " function in your current context will be shadowed by the one in the \
package. "
}], "MathCaption",
 CellID->12455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "VectorAnalysis`"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->703149542],

Cell[BoxData[
 RowBox[{
  RowBox[{"Div", "::", "\<\"shdw\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(\\\"Div\\\"\\) appears in multiple contexts \
\\!\\({\\\"VectorAnalysis`\\\", \\\"Global`\\\"}\\); definitions in context \
\\!\\(\\\"VectorAnalysis`\\\"\\) may shadow or be shadowed by other \
definitions. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/shdw\\\", ButtonNote -> \
\\\"VectorAnalysis`Div::shdw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[13]:=",
 CellID->1049175413]
}, Open  ]],

Cell["This sets up the coordinate system for vector analysis. ", "MathCaption",
 CellID->11701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetCoordinates", "[", 
  RowBox[{"Cartesian", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->31316],

Cell[BoxData[
 RowBox[{"Cartesian", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->502940774]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["Div"], "InlineFormula"],
 " from the package is used. "
}], "MathCaption",
 CellID->4313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Div", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", 
    RowBox[{"y", "^", "2"}], ",", "x"}], "}"}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->24355],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "y"}]}]], "Output",
 ImageSize->{41, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->429954026]
}, Open  ]],

Cell[TextData[{
 "If you get into the situation where unwanted symbols are shadowing the \
symbols you want, the best thing to do is usually to get rid of the unwanted \
symbols using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Remove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Remove"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 ". An alternative that is sometimes appropriate is to rearrange the entries \
in ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 " and to reset the value of ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 " so as to make the contexts that contain the symbols you want be the ones \
that are searched first."
}], "Text",
 CellID->20053],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$Packages",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Packages"], Cell[TextData[{
     "a list of the contexts corresponding to all packages loaded into your ",
     
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " session"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->912],

Cell["Getting a list of packages. ", "Caption",
 CellID->10808],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->575670838],

Cell[TextData[ButtonBox["Modularity and the Naming of Things",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], \
"RelatedTutorials",
 CellID->405226890],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"]
}], "RelatedTutorials",
 CellID->369732296]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Contexts and Packages - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Modularity and the Naming of Things", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Contexts"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SettingUpMathematicaPackages"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 37.6087040}", "context" -> "", 
    "keywords" -> {
     "`", "contexts", "files", "loaded packages", "Remove", 
      "shadowing of names", "$Packages"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "A typical package written in Mathematica introduces several new symbols \
intended for use outside the package. These symbols may correspond for \
example to new functions or new objects defined in the package. There is a \
general convention that all new symbols introduced in a particular package \
are put into a context whose name is related to the name of the package. When \
you read in the package, it adds this context at the beginning of your \
context search path $ContextPath. This reads in a package for proving \
primality.", "synonyms" -> {"2.7.9"}, "title" -> "Contexts and Packages", 
    "type" -> "Tutorial", "uri" -> "tutorial/ContextsAndPackages"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.7.9"->{
  Cell[2017, 62, 83, 2, 70, "Title",
   CellTags->{"S2.7.9", "9.1"},
   CellID->3434]},
 "9.1"->{
  Cell[2017, 62, 83, 2, 70, "Title",
   CellTags->{"S2.7.9", "9.1"},
   CellID->3434]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.7.9", 14928, 487},
 {"9.1", 15026, 491}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1392, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2017, 62, 83, 2, 70, "Title",
 CellTags->{"S2.7.9", "9.1"},
 CellID->3434],
Cell[2103, 66, 301, 8, 70, "Text",
 CellID->16549],
Cell[2407, 76, 441, 11, 70, "Text",
 CellID->7441],
Cell[2851, 89, 84, 1, 70, "MathCaption",
 CellID->9512],
Cell[2938, 92, 100, 3, 70, "Input",
 CellID->30145],
Cell[3041, 97, 224, 8, 70, "MathCaption",
 CellID->18060],
Cell[CellGroupData[{
Cell[3290, 109, 82, 2, 28, "Input",
 CellID->1428237801],
Cell[3375, 113, 270, 8, 36, "Output",
 CellID->453262091]
}, Open  ]],
Cell[3660, 124, 163, 5, 70, "MathCaption",
 CellID->16139],
Cell[CellGroupData[{
Cell[3848, 133, 112, 3, 28, "Input",
 CellID->12423],
Cell[3963, 138, 182, 5, 36, "Output",
 CellID->98211406]
}, Open  ]],
Cell[4160, 146, 89, 1, 70, "MathCaption",
 CellID->25996],
Cell[CellGroupData[{
Cell[4274, 151, 110, 3, 70, "Input",
 CellID->16687],
Cell[4387, 156, 163, 5, 36, "Output",
 CellID->1371659746]
}, Open  ]],
Cell[4565, 164, 486, 11, 70, "Text",
 CellID->22549],
Cell[5054, 177, 426, 9, 70, "Text",
 CellID->17437],
Cell[5483, 188, 268, 7, 70, "MathCaption",
 CellID->19866],
Cell[CellGroupData[{
Cell[5776, 199, 108, 3, 70, "Input",
 CellID->248400477],
Cell[5887, 204, 655, 12, 70, "Message",
 CellID->683517070]
}, Open  ]],
Cell[6557, 219, 101, 2, 70, "MathCaption",
 CellID->23195],
Cell[CellGroupData[{
Cell[6683, 225, 131, 3, 70, "Input",
 CellID->981367687],
Cell[6817, 230, 163, 5, 36, "Output",
 CellID->1172306449]
}, Open  ]],
Cell[6995, 238, 614, 14, 70, "Text",
 CellID->28286],
Cell[7612, 254, 87, 1, 70, "MathCaption",
 CellID->16105],
Cell[CellGroupData[{
Cell[7724, 259, 143, 5, 70, "Input",
 CellID->24488],
Cell[7870, 266, 180, 6, 51, "Output",
 CellID->1939510765]
}, Open  ]],
Cell[8065, 275, 183, 6, 70, "MathCaption",
 CellID->12455],
Cell[CellGroupData[{
Cell[8273, 285, 103, 3, 70, "Input",
 CellID->703149542],
Cell[8379, 290, 596, 11, 70, "Message",
 CellID->1049175413]
}, Open  ]],
Cell[8990, 304, 95, 1, 70, "MathCaption",
 CellID->11701],
Cell[CellGroupData[{
Cell[9110, 309, 177, 5, 70, "Input",
 CellID->31316],
Cell[9290, 316, 228, 7, 36, "Output",
 CellID->502940774]
}, Open  ]],
Cell[9533, 326, 129, 5, 70, "MathCaption",
 CellID->4313],
Cell[CellGroupData[{
Cell[9687, 335, 178, 6, 70, "Input",
 CellID->24355],
Cell[9868, 343, 204, 7, 36, "Output",
 CellID->429954026]
}, Open  ]],
Cell[10087, 353, 847, 24, 70, "Text",
 CellID->20053],
Cell[10937, 379, 633, 19, 70, "DefinitionBox",
 CellID->912],
Cell[11573, 400, 63, 1, 70, "Caption",
 CellID->10808],
Cell[CellGroupData[{
Cell[11661, 405, 72, 1, 70, "RelatedTutorialsSection",
 CellID->575670838],
Cell[11736, 408, 200, 5, 70, "RelatedTutorials",
 CellID->405226890],
Cell[11939, 415, 291, 9, 70, "RelatedTutorials",
 CellID->369732296]
}, Open  ]]
}, Open  ]],
Cell[12257, 428, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

