(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     68535,       2224]
NotebookOptionsPosition[     62761,       2051]
NotebookOutlinePosition[     65036,       2101]
CellTagsIndexPosition[     64993,       2098]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BetaDistribution" :> 
         Documentation`HelpLookup["paclet:ref/BetaDistribution"], 
         "CauchyDistribution" :> 
         Documentation`HelpLookup["paclet:ref/CauchyDistribution"], "CDF" :> 
         Documentation`HelpLookup["paclet:ref/CDF"], "CharacteristicFunction" :> 
         Documentation`HelpLookup["paclet:ref/CharacteristicFunction"], 
         "ChiDistribution" :> 
         Documentation`HelpLookup["paclet:ref/ChiDistribution"], 
         "ChiSquareDistribution" :> 
         Documentation`HelpLookup["paclet:ref/ChiSquareDistribution"], 
         "ExpectedValue" :> 
         Documentation`HelpLookup["paclet:ref/ExpectedValue"], 
         "ExponentialDistribution" :> 
         Documentation`HelpLookup["paclet:ref/ExponentialDistribution"], 
         "ExtremeValueDistribution" :> 
         Documentation`HelpLookup["paclet:ref/ExtremeValueDistribution"], 
         "FRatioDistribution" :> 
         Documentation`HelpLookup["paclet:ref/FRatioDistribution"], 
         "GammaDistribution" :> 
         Documentation`HelpLookup["paclet:ref/GammaDistribution"], 
         "GumbelDistribution" :> 
         Documentation`HelpLookup["paclet:ref/GumbelDistribution"], 
         "HalfNormalDistribution" :> 
         Documentation`HelpLookup["paclet:ref/HalfNormalDistribution"], 
         "InverseCDF" :> Documentation`HelpLookup["paclet:ref/InverseCDF"], 
         "InverseGaussianDistribution" :> 
         Documentation`HelpLookup["paclet:ref/InverseGaussianDistribution"], 
         "Kurtosis" :> Documentation`HelpLookup["paclet:ref/Kurtosis"], 
         "LaplaceDistribution" :> 
         Documentation`HelpLookup["paclet:ref/LaplaceDistribution"], 
         "LogisticDistribution" :> 
         Documentation`HelpLookup["paclet:ref/LogisticDistribution"], 
         "LogNormalDistribution" :> 
         Documentation`HelpLookup["paclet:ref/LogNormalDistribution"], 
         "MaxwellDistribution" :> 
         Documentation`HelpLookup["paclet:ref/MaxwellDistribution"], "Mean" :> 
         Documentation`HelpLookup["paclet:ref/Mean"], 
         "NoncentralChiSquareDistribution" :> 
         Documentation`HelpLookup[
          "paclet:ref/NoncentralChiSquareDistribution"], 
         "NoncentralFRatioDistribution" :> 
         Documentation`HelpLookup["paclet:ref/NoncentralFRatioDistribution"], 
         "NoncentralStudentTDistribution" :> 
         Documentation`HelpLookup[
          "paclet:ref/NoncentralStudentTDistribution"], "NormalDistribution" :> 
         Documentation`HelpLookup["paclet:ref/NormalDistribution"], 
         "ParetoDistribution" :> 
         Documentation`HelpLookup["paclet:ref/ParetoDistribution"], "PDF" :> 
         Documentation`HelpLookup["paclet:ref/PDF"], "Quantile" :> 
         Documentation`HelpLookup["paclet:ref/Quantile"], "RandomReal" :> 
         Documentation`HelpLookup["paclet:ref/RandomReal"], 
         "RayleighDistribution" :> 
         Documentation`HelpLookup["paclet:ref/RayleighDistribution"], 
         "Skewness" :> Documentation`HelpLookup["paclet:ref/Skewness"], 
         "StandardDeviation" :> 
         Documentation`HelpLookup["paclet:ref/StandardDeviation"], 
         "StudentTDistribution" :> 
         Documentation`HelpLookup["paclet:ref/StudentTDistribution"], 
         "TriangularDistribution" :> 
         Documentation`HelpLookup["paclet:ref/TriangularDistribution"], 
         "UniformDistribution" :> 
         Documentation`HelpLookup["paclet:ref/UniformDistribution"], 
         "Variance" :> Documentation`HelpLookup["paclet:ref/Variance"], 
         "WeibullDistribution" :> 
         Documentation`HelpLookup["paclet:ref/WeibullDistribution"]}, #, 2]& ,
        Evaluator -> Automatic], {1->"\<\"BetaDistribution\"\>", 
      2->"\<\"CauchyDistribution\"\>", 3->"\<\"CDF\"\>", 
      4->"\<\"CharacteristicFunction\"\>", 5->"\<\"ChiDistribution\"\>", 
      6->"\<\"ChiSquareDistribution\"\>", 7->"\<\"ExpectedValue\"\>", 
      8->"\<\"ExponentialDistribution\"\>", 
      9->"\<\"ExtremeValueDistribution\"\>", 10->"\<\"FRatioDistribution\"\>",
       11->"\<\"GammaDistribution\"\>", 12->"\<\"GumbelDistribution\"\>", 
      13->"\<\"HalfNormalDistribution\"\>", 14->"\<\"InverseCDF\"\>", 
      15->"\<\"InverseGaussianDistribution\"\>", 16->"\<\"Kurtosis\"\>", 
      17->"\<\"LaplaceDistribution\"\>", 18->"\<\"LogisticDistribution\"\>", 
      19->"\<\"LogNormalDistribution\"\>", 20->"\<\"MaxwellDistribution\"\>", 
      21->"\<\"Mean\"\>", 22->"\<\"NoncentralChiSquareDistribution\"\>", 
      23->"\<\"NoncentralFRatioDistribution\"\>", 
      24->"\<\"NoncentralStudentTDistribution\"\>", 
      25->"\<\"NormalDistribution\"\>", 26->"\<\"ParetoDistribution\"\>", 
      27->"\<\"PDF\"\>", 28->"\<\"Quantile\"\>", 29->"\<\"RandomReal\"\>", 
      30->"\<\"RayleighDistribution\"\>", 31->"\<\"Skewness\"\>", 
      32->"\<\"StandardDeviation\"\>", 33->"\<\"StudentTDistribution\"\>", 
      34->"\<\"TriangularDistribution\"\>", 35->"\<\"UniformDistribution\"\>",
       36->"\<\"Variance\"\>", 
      37->"\<\"WeibullDistribution\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Continuous Distributions", "Title",
 CellID->11002],

Cell[TextData[{
 "The functions described here are among the most commonly used continuous \
statistical distributions. You can compute their densities, means, variances, \
and other related properties. The distributions themselves are represented in \
the symbolic form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["name", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["param", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["param", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ". Functions such as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", which give properties of statistical distributions, take the symbolic \
representation of the distribution as an argument. \"",
 ButtonBox["Discrete Distributions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DiscreteDistributions"],
 " describes many discrete statistical distributions."
}], "Text",
 CellID->4255],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NormalDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NormalDistribution"], "[", 
     RowBox[{
      StyleBox["\[Mu]", "TR"], ",", 
      StyleBox["\[Sigma]", "TR"]}], "]"}], Cell[TextData[{
     "normal (Gaussian) distribution with mean ",
     Cell[BoxData[
      StyleBox["\[Mu]", "TR"]], "InlineFormula"],
     " and standard deviation ",
     Cell[BoxData[
      StyleBox["\[Sigma]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["HalfNormalDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HalfNormalDistribution"], "[", 
     StyleBox["\[Theta]", "TR"], "]"}], Cell[TextData[{
     "half\[Hyphen]normal distribution with scale inversely proportional to \
parameter ",
     Cell[BoxData[
      StyleBox["\[Theta]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LogNormalDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LogNormalDistribution"], "[", 
     RowBox[{
      StyleBox["\[Mu]", "TR"], ",", 
      StyleBox["\[Sigma]", "TR"]}], "]"}], Cell[TextData[{
     "lognormal distribution based on a normal distribution with mean ",
     Cell[BoxData[
      StyleBox["\[Mu]", "TR"]], "InlineFormula"],
     " and standard deviation ",
     Cell[BoxData[
      StyleBox["\[Sigma]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseGaussianDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseGaussianDistribution"], "[", 
     RowBox[{
      StyleBox["\[Mu]", "TR"], ",", 
      StyleBox["\[Lambda]", "TR"]}], "]"}], Cell[TextData[{
     "inverse Gaussian distribution with mean ",
     Cell[BoxData[
      StyleBox["\[Mu]", "TR"]], "InlineFormula"],
     " and scale ",
     Cell[BoxData[
      StyleBox["\[Lambda]", "TR"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->46851034],

Cell["Distributions related to the normal distribution. ", "Caption",
 CellID->216572643],

Cell[TextData[{
 "The ",
 StyleBox["lognormal distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LogNormalDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogNormalDistribution"], "[", 
   RowBox[{
    StyleBox["\[Mu]", "TR"], ",", 
    StyleBox["\[Sigma]", "TR"]}], "]"}]], "InlineFormula"],
 " is the distribution followed by the exponential of a normally distributed \
random variable. This distribution arises when many independent random \
variables are combined in a multiplicative fashion. The ",
 StyleBox["half-normal distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HalfNormalDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HalfNormalDistribution"], "[", 
   StyleBox["\[Theta]", "TR"], "]"}]], "InlineFormula"],
 " is proportional to the distribution ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NormalDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NormalDistribution"], "[", 
   RowBox[{"0", ",", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["\[Theta]", "TR"], " ", 
       RowBox[{
        ButtonBox["Sqrt",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Sqrt"], "[", 
        RowBox[{"2", "/", 
         StyleBox["\[Pi]", "TR"]}], "]"}]}], ")"}]}]}], "]"}]], 
  "InlineFormula"],
 " limited to the domain ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"[", 
     RowBox[{"0", ",", "\[Infinity]"}]}], ")"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->37175843],

Cell[TextData[{
 "The ",
 StyleBox["inverse Gaussian distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseGaussianDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseGaussianDistribution"], "[", 
   RowBox[{
    StyleBox["\[Mu]", "TR"], ",", 
    StyleBox["\[Lambda]", "TR"]}], "]"}]], "InlineFormula"],
 ", sometimes called the Wald distribution, is the distribution of first \
passage times in Brownian motion with positive drift. "
}], "Text",
 CellID->522464858],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ChiSquareDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ChiSquareDistribution"], "[", 
     StyleBox["\[Nu]", "TR"], "]"}], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
     " distribution with ",
     Cell[BoxData[
      StyleBox["\[Nu]", "TR"]], "InlineFormula"],
     " degrees of freedom"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FRatioDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FRatioDistribution"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[TextData[{
     "F-ratio distribution with ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " numerator and ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " denominator degrees of freedom"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StudentTDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StudentTDistribution"], "[", 
     StyleBox["\[Nu]", "TR"], "]"}], Cell[TextData[{
     "Student ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " distribution with ",
     Cell[BoxData[
      StyleBox["\[Nu]", "TR"]], "InlineFormula"],
     " degrees of freedom"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NoncentralChiSquareDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NoncentralChiSquareDistribution"], "[", 
     RowBox[{
      StyleBox["\[Nu]", "TR"], ",", 
      StyleBox["\[Lambda]", "TR"]}], "]"}], Cell[TextData[{
     "noncentral ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
     " distribution with ",
     Cell[BoxData[
      StyleBox["\[Nu]", "TR"]], "InlineFormula"],
     " degrees of freedom and noncentrality parameter ",
     Cell[BoxData[
      StyleBox["\[Lambda]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NoncentralStudentTDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NoncentralStudentTDistribution"], "[", 
     RowBox[{
      StyleBox["\[Nu]", "TR"], ",", 
      StyleBox["\[Delta]", "TR"]}], "]"}], Cell[TextData[{
     "noncentral Student ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " distribution with ",
     Cell[BoxData[
      StyleBox["\[Nu]", "TR"]], "InlineFormula"],
     " degrees of freedom and noncentrality parameter ",
     Cell[BoxData[
      StyleBox["\[Delta]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NoncentralFRatioDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NoncentralFRatioDistribution"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["\[Lambda]", "TR"]}], "]"}], Cell[TextData[{
     "noncentral F-ratio distribution with ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " numerator degrees of freedom and ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " denominator degrees of freedom and numerator noncentrality parameter ",
     
     Cell[BoxData[
      StyleBox["\[Lambda]", "TR"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->15786],

Cell["Distributions related to normally distributed samples. ", "Caption",
 CellID->5218],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "1"], TraditionalForm]], "InlineMath"],
 ",",
 StyleBox["\[Ellipsis]",
  Deletable->True],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "\[Nu]"], TraditionalForm]], "InlineMath"],
 " are independent normal random variables with unit variance and mean zero, \
then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "\[Nu]"], 
    SubsuperscriptBox["X", "i", "2"]}], TraditionalForm]], "InlineMath"],
 " has a ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 StyleBox[" distribution",
  FontWeight->"Bold"],
 " with ",
 Cell[BoxData[
  FormBox["\[Nu]", TraditionalForm]], "InlineMath"],
 " degrees of freedom. If a normal variable is standardized by subtracting \
its mean and dividing by its standard deviation, then the sum of squares of \
such quantities follows this distribution. The ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 " distribution is most typically used when describing the variance of normal \
samples. "
}], "Text",
 CellID->26791],

Cell[TextData[{
 "A variable that has a ",
 StyleBox["Student ",
  FontWeight->"Bold"],
 StyleBox["t",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" distribution",
  FontWeight->"Bold"],
 " can also be written as a function of normal random variables. Let ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]], "InlineMath"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "and ",
 Cell[BoxData[
  FormBox["Z", TraditionalForm]], "InlineMath"],
 " be independent random variables, where ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]], "InlineMath"],
 " is a standard normal distribution and ",
 Cell[BoxData[
  FormBox["Z", TraditionalForm]], "InlineMath"],
 " is a ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 " variable with ",
 Cell[BoxData[
  FormBox["\[Nu]", TraditionalForm]], "InlineMath"],
 " degrees of freedom. In this case, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", "/", 
    SqrtBox[
     RowBox[{"Z", "/", "\[Nu]"}]]}], TraditionalForm]], "InlineMath"],
 " has a ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " distribution with ",
 Cell[BoxData[
  FormBox["\[Nu]", TraditionalForm]], "InlineMath"],
 " degrees of freedom. The Student ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " distribution is symmetric about the vertical axis, and characterizes the \
ratio of a normal variable to its standard deviation. When ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Nu]", "=", "1"}], TraditionalForm]], "InlineMath"],
 ", the ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " distribution is the same as the Cauchy distribution. "
}], "Text",
 CellID->7838],

Cell[TextData[{
 "The ",
 StyleBox["F\[Hyphen]ratio distribution",
  FontWeight->"Bold"],
 " is the distribution of the ratio of two independent ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 " variables divided by their respective degrees of freedom. It is commonly \
used when comparing the variances of two populations in hypothesis testing. "
}], "Text",
 CellID->24346],

Cell[TextData[{
 "Distributions that are derived from normal distributions with nonzero means \
are called ",
 StyleBox["noncentral distributions",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->85717943],

Cell[TextData[{
 "The sum of the squares of ",
 Cell[BoxData[
  FormBox["\[Nu]", TraditionalForm]], "InlineMath"],
 " normally distributed random variables with variance ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Sigma]", "2"], "=", "1"}], TraditionalForm]], 
  "InlineMath"],
 " and nonzero means follows a ",
 StyleBox["noncentral ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 StyleBox[" distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NoncentralChiSquareDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NoncentralChiSquareDistribution"], "[", 
   RowBox[{
    StyleBox["\[Nu]", "TR"], ",", 
    StyleBox["\[Lambda]", "TR"]}], "]"}]], "InlineFormula"],
 ". The noncentrality parameter ",
 Cell[BoxData[
  FormBox[
   StyleBox["\[Lambda]", "TR"], TraditionalForm]], "InlineMath"],
 " is the sum of the squares of the means of the random variables in the sum. \
Note that in various places in the literature, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Lambda]", "/", "2"}], TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   SqrtBox["\[Lambda]"], TraditionalForm]], "InlineMath"],
 " is used as the noncentrality parameter. "
}], "Text",
 CellID->88989109],

Cell[TextData[{
 "The ",
 StyleBox["noncentral Student ",
  FontWeight->"Bold"],
 StyleBox["t", "TBI"],
 StyleBox[" distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NoncentralStudentTDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NoncentralStudentTDistribution"], "[", 
   RowBox[{
    StyleBox["\[Nu]", "TR"], ",", 
    StyleBox["\[Delta]", "TR"]}], "]"}]], "InlineFormula"],
 " describes the ratio ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", "/", 
    SqrtBox[
     RowBox[{
      SubsuperscriptBox["\[Chi]", "\[Nu]", "2"], "/", "\[Nu]"}]]}], 
   TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[Chi]", "\[Nu]", "2"], TraditionalForm]], 
  "InlineMath"],
 " is a central ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 " random variable with ",
 Cell[BoxData[
  FormBox["\[Nu]", TraditionalForm]], "InlineMath"],
 " degrees of freedom, and ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]], "InlineMath"],
 " is an independent normally distributed random variable with variance ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Sigma]", "2"], "=", "1"}], TraditionalForm]], 
  "InlineMath"],
 " and mean ",
 Cell[BoxData[
  FormBox["\[Delta]", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->306596152],

Cell[TextData[{
 "The ",
 StyleBox["noncentral ",
  FontWeight->"Bold"],
 StyleBox["F", "TBI"],
 StyleBox["\[Hyphen]ratio distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NoncentralFRatioDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NoncentralFRatioDistribution"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["\[Lambda]", "TR"]}], "]"}]], "InlineFormula"],
 " is the distribution of the ratio of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "n"], 
    RowBox[{
     SubsuperscriptBox["\[Chi]", "n", "2"], "(", "\[Lambda]", ")"}]}], 
   TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "m"], 
    SubsuperscriptBox["\[Chi]", "m", "2"]}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Chi]", "n", "2"], "(", "\[Lambda]", ")"}], 
   TraditionalForm]], "InlineMath"],
 " is a noncentral ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 " random variable with noncentrality parameter ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "1"], TraditionalForm]], "InlineMath"],
 " degrees of freedom and ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[Chi]", "m", "2"], TraditionalForm]], "InlineMath"],
 " is a central ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 " random variable with ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " degrees of freedom. "
}], "Text",
 CellID->32827621],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["TriangularDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TriangularDistribution"], "[", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["a", "TI"], ",", 
       StyleBox["b", "TI"]}], "}"}], "]"}], Cell[TextData[{
     "symmetric triangular distribution on the interval ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TriangularDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TriangularDistribution"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "}"}], ",", 
      StyleBox["c", "TI"]}], "]"}], Cell[TextData[{
     "triangular distribution on the interval ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "}"}]], "InlineFormula"],
     " with maximum at ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["UniformDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UniformDistribution"], "[", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["min", "TI"], ",", 
       StyleBox["max", "TI"]}], "}"}], "]"}], Cell[TextData[{
     "uniform distribution on the interval ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["min", "TI"], ",", 
        StyleBox["max", "TI"]}], "}"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->45881053],

Cell["Piecewise linear distributions. ", "Caption",
 CellID->118596088],

Cell[TextData[{
 "The ",
 StyleBox["triangular distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TriangularDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TriangularDistribution"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "}"}], ",", 
    StyleBox["c", "TI"]}], "]"}]], "InlineFormula"],
 " is a triangular distribution for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "<", "X", "<", "b"}], TraditionalForm]], "InlineMath"],
 " with maximum probability at ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "<", "c", "<", "b"}], TraditionalForm]], "InlineMath"],
 ". If ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " is ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"a", "+", "b"}], "2"], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TriangularDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TriangularDistribution"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "}"}], ",", 
    StyleBox["c", "TI"]}], "]"}]], "InlineFormula"],
 " is the symmetric triangular distribution ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TriangularDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TriangularDistribution"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->92695939],

Cell[TextData[{
 "The ",
 StyleBox["uniform distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["UniformDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UniformDistribution"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["min", "TI"], ",", 
     StyleBox["max", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 ", commonly referred to as the rectangular distribution, characterizes a \
random variable whose value is everywhere equally likely. An example of a \
uniformly distributed random variable is the location of a point chosen \
randomly on a line from ",
 Cell[BoxData[
  StyleBox["min", "TI"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  StyleBox["max", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->310268923],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["BetaDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BetaDistribution"], "[", 
     RowBox[{
      StyleBox["\[Alpha]", "TR"], ",", 
      StyleBox["\[Beta]", "TR"]}], "]"}], Cell[TextData[{
     "continuous beta distribution with shape parameters ",
     Cell[BoxData[
      StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["\[Beta]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CauchyDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CauchyDistribution"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[TextData[{
     "Cauchy distribution with location parameter ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and scale parameter ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ChiDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ChiDistribution"], "[", 
     StyleBox["\[Nu]", "TR"], "]"}], Cell[TextData[{
     Cell[BoxData[
      FormBox["\[Chi]", TraditionalForm]], "InlineMath"],
     " distribution with ",
     Cell[BoxData[
      StyleBox["\[Nu]", "TR"]], "InlineFormula"],
     " degrees of freedom "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ExponentialDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExponentialDistribution"], "[", 
     StyleBox["\[Lambda]", "TR"], "]"}], Cell[TextData[{
     "exponential distribution with scale inversely proportional to parameter \
",
     Cell[BoxData[
      StyleBox["\[Lambda]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ExtremeValueDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExtremeValueDistribution"], "[", 
     RowBox[{
      StyleBox["\[Alpha]", "TR"], ",", 
      StyleBox["\[Beta]", "TR"]}], "]"}], Cell[TextData[{
     "extreme maximum value (Fisher\[Dash]Tippett) distribution with location \
parameter ",
     Cell[BoxData[
      StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
     " and scale parameter ",
     Cell[BoxData[
      StyleBox["\[Beta]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GammaDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GammaDistribution"], "[", 
     RowBox[{
      StyleBox["\[Alpha]", "TR"], ",", 
      StyleBox["\[Lambda]", "TR"]}], "]"}], Cell[TextData[{
     "gamma distribution with shape parameter ",
     Cell[BoxData[
      StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
     " and scale parameter ",
     Cell[BoxData[
      StyleBox["\[Lambda]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GumbelDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GumbelDistribution"], "[", 
     RowBox[{
      StyleBox["\[Alpha]", "TR"], ",", 
      StyleBox["\[Beta]", "TR"]}], "]"}], Cell[TextData[{
     "Gumbel minimum extreme value distribution with location parameter ",
     Cell[BoxData[
      StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
     " and scale parameter ",
     Cell[BoxData[
      StyleBox["\[Beta]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LaplaceDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LaplaceDistribution"], "[", 
     RowBox[{
      StyleBox["\[Mu]", "TR"], ",", 
      StyleBox["\[Beta]", "TR"]}], "]"}], Cell[TextData[{
     "Laplace (double exponential) distribution with mean ",
     Cell[BoxData[
      StyleBox["\[Mu]", "TR"]], "InlineFormula"],
     " and scale parameter ",
     Cell[BoxData[
      StyleBox["\[Beta]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LogisticDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LogisticDistribution"], "[", 
     RowBox[{
      StyleBox["\[Mu]", "TR"], ",", 
      StyleBox["\[Beta]", "TR"]}], "]"}], Cell[TextData[{
     "logistic distribution with mean ",
     Cell[BoxData[
      StyleBox["\[Mu]", "TR"]], "InlineFormula"],
     " and scale parameter ",
     Cell[BoxData[
      StyleBox["\[Beta]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MaxwellDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MaxwellDistribution"], "[", 
     StyleBox["\[Sigma]", "TR"], "]"}], Cell[TextData[{
     "Maxwell (Maxwell-Boltzmann) distribution with scale parameter ",
     Cell[BoxData[
      StyleBox["\[Sigma]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ParetoDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ParetoDistribution"], "[", 
     RowBox[{
      StyleBox["k", "TI"], ",", 
      StyleBox["\[Alpha]", "TR"]}], "]"}], Cell[TextData[{
     "Pareto distribution with minimum value parameter ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " and shape parameter ",
     Cell[BoxData[
      StyleBox["\[Alpha]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RayleighDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RayleighDistribution"], "[", 
     StyleBox["\[Sigma]", "TR"], "]"}], Cell[TextData[{
     "Rayleigh distribution with scale parameter ",
     Cell[BoxData[
      StyleBox["\[Sigma]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["WeibullDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WeibullDistribution"], "[", 
     RowBox[{
      StyleBox["\[Alpha]", "TR"], ",", 
      StyleBox["\[Beta]", "TR"]}], "]"}], Cell[TextData[{
     "Weibull distribution with shape parameter ",
     Cell[BoxData[
      StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
     " and scale parameter ",
     Cell[BoxData[
      StyleBox["\[Beta]", "TR"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->992],

Cell["Other continuous statistical distributions. ", "Caption",
 CellID->7207],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]], "InlineMath"],
 " is uniformly distributed on",
 Cell[BoxData[
  RowBox[{"[", 
   RowBox[{
    RowBox[{"-", 
     StyleBox["\[Pi]", "TR"]}], ",", " ", 
    StyleBox["\[Pi]", "TR"]}], "]"}]], "InlineFormula"],
 ", then the random variable ",
 Cell[BoxData[
  FormBox[
   RowBox[{"tan", "(", "X", ")"}], TraditionalForm]], "InlineMath"],
 " follows a ",
 StyleBox["Cauchy distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CauchyDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CauchyDistribution"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", "0"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", "=", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->2441941],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", "=", 
    RowBox[{"n", "/", "2"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Lambda]", "=", "2"}], TraditionalForm]], "InlineMath"],
 ", the ",
 StyleBox["gamma distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GammaDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GammaDistribution"], "[", 
   RowBox[{
    StyleBox["\[Alpha]", "TR"], ",", 
    StyleBox["\[Lambda]", "TR"]}], "]"}]], "InlineFormula"],
 " describes the distribution of a sum of squares of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 "-unit normal random variables. This form of the gamma distribution is \
called a ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 StyleBox[" distribution",
  FontWeight->"Bold"],
 " with ",
 Cell[BoxData[
  FormBox["\[Nu]", TraditionalForm]], "InlineMath"],
 " degrees of freedom. When ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", "=", "1"}], TraditionalForm]], "InlineMath"],
 ", the gamma distribution takes on the form of the ",
 StyleBox["exponential distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExponentialDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExponentialDistribution"], "[", 
   StyleBox["\[Lambda]", "TR"], "]"}]], "InlineFormula"],
 ", often used in describing the waiting time between events."
}], "Text",
 CellID->891935298],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "1"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "2"], TraditionalForm]], "InlineMath"],
 " have independent gamma distributions with equal scale parameters, the \
random variable ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SubscriptBox["X", "1"], 
    RowBox[{
     SubscriptBox["X", "1"], "+", 
     SubscriptBox["X", "2"]}]], TraditionalForm]], "InlineMath"],
 " follows the ",
 StyleBox["beta distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BetaDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BetaDistribution"], "[", 
   RowBox[{
    StyleBox["\[Alpha]", "TR"], ",", 
    StyleBox["\[Beta]", "TR"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineMath"],
 " are the shape parameters of the gamma variables. "
}], "Text",
 CellID->30740],

Cell[TextData[{
 "The ",
 StyleBox["\[Chi] distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ChiDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChiDistribution"], "[", 
   StyleBox["\[Nu]", "TR"], "]"}]], "InlineFormula"],
 " is followed by the square root of a ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 " random variable. For ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", "1"}], TraditionalForm]], "InlineMath"],
 ", the ",
 Cell[BoxData[
  FormBox["\[Chi]", TraditionalForm]], "InlineMath"],
 " distribution is identical to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HalfNormalDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HalfNormalDistribution"], "[", 
   StyleBox["\[Theta]", "TR"], "]"}]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", 
    SqrtBox[
     FractionBox["\[Pi]", "2"]]}], TraditionalForm]], "InlineMath"],
 ". For ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", "2"}], TraditionalForm]], "InlineMath"],
 ", the ",
 Cell[BoxData[
  FormBox["\[Chi]", TraditionalForm]], "InlineMath"],
 " distribution is identical to the ",
 StyleBox["Rayleigh distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RayleighDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RayleighDistribution"], "[", 
   StyleBox["\[Sigma]", "TR"], "]"}]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Sigma]", "=", "1"}], TraditionalForm]], "InlineMath"],
 ". For ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", "3"}], TraditionalForm]], "InlineMath"],
 ", the ",
 Cell[BoxData[
  FormBox["\[Chi]", TraditionalForm]], "InlineMath"],
 " distribution is identical to the ",
 StyleBox["Maxwell\[Dash]Boltzmann distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MaxwellDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxwellDistribution"], "[", 
   StyleBox["\[Sigma]", "TR"], "]"}]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Sigma]", "=", "1"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->412578314],

Cell[TextData[{
 "The ",
 StyleBox["Laplace distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LaplaceDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LaplaceDistribution"], "[", 
   RowBox[{
    StyleBox["\[Mu]", "TR"], ",", 
    StyleBox["\[Beta]", "TR"]}], "]"}]], "InlineFormula"],
 " is the distribution of the difference of two independent random variables \
with identical exponential distributions. The ",
 StyleBox["logistic distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LogisticDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogisticDistribution"], "[", 
   RowBox[{
    StyleBox["\[Mu]", "TR"], ",", 
    StyleBox["\[Beta]", "TR"]}], "]"}]], "InlineFormula"],
 " is frequently used in place of the normal distribution when a distribution \
with longer tails is desired. "
}], "Text",
 CellID->19758049],

Cell[TextData[{
 "The ",
 StyleBox["Pareto distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ParetoDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParetoDistribution"], "[", 
   RowBox[{
    StyleBox["k", "TI"], ",", 
    StyleBox["\[Alpha]", "TR"]}], "]"}]], "InlineFormula"],
 " may be used to describe income, with ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " representing the minimum income possible. "
}], "Text",
 CellID->236940748],

Cell[TextData[{
 "The ",
 StyleBox["Weibull distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WeibullDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeibullDistribution"], "[", 
   RowBox[{
    StyleBox["\[Alpha]", "TR"], ",", 
    StyleBox["\[Beta]", "TR"]}], "]"}]], "InlineFormula"],
 " is commonly used in engineering to describe the lifetime of an object. The \
",
 StyleBox["extreme value distribution",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExtremeValueDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExtremeValueDistribution"], "[", 
   RowBox[{
    StyleBox["\[Alpha]", "TR"], ",", 
    StyleBox["\[Beta]", "TR"]}], "]"}]], "InlineFormula"],
 " is the limiting distribution for the largest values in large samples drawn \
from a variety of distributions, including the normal distribution. The \
limiting distribution for the smallest values in such samples is the ",
 StyleBox["Gumbel distribution",
  FontWeight->"Bold"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GumbelDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GumbelDistribution"], "[", 
   RowBox[{
    StyleBox["\[Alpha]", "TR"], ",", 
    StyleBox["\[Beta]", "TR"]}], "]"}]], "InlineFormula"],
 ". The names extreme value and Gumbel distribution are sometimes used \
interchangeably because the distributions of the largest and smallest extreme \
values are related by a linear change of variable. The extreme value \
distribution is also sometimes referred to as the log\[Hyphen]Weibull \
distribution because of logarithmic relationships between an extreme value \
distributed random variable and a properly shifted and scaled Weibull \
distributed random variable. "
}], "Text",
 CellID->182364425],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PDF",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PDF"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["dist", "TI"], 
      StyleBox[",", "MR"], 
      StyleBox["x", "TI"]}], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "probability density function at ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CDF",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CDF"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["dist", "TI"], 
      StyleBox[",", "MR"], 
      StyleBox["x", "TI"]}], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "cumulative distribution function at ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseCDF",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseCDF"], "[", 
     RowBox[{
      StyleBox["dist", "TI"], ",", 
      StyleBox["q", "TI"]}], "]"}], Cell[TextData[{
     "the value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " such that ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["CDF",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CDF"], "[", 
       RowBox[{
        StyleBox["dist", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     " equals ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Quantile",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Quantile"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["dist", "TI"], 
      StyleBox[",", "MR"], 
      StyleBox["q", "TI"]}], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " quantile "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Mean",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Mean"], 
     StyleBox["[", "MR"], 
     StyleBox["dist", "TI"], 
     StyleBox["]", "MR"]}], Cell["mean", "TableText"]},
   {
    RowBox[{
     ButtonBox["Variance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Variance"], 
     StyleBox["[", "MR"], 
     StyleBox["dist", "TI"], 
     StyleBox["]", "MR"]}], Cell["variance", "TableText"]},
   {
    RowBox[{
     ButtonBox["StandardDeviation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StandardDeviation"], 
     StyleBox["[", "MR"], 
     StyleBox["dist", "TI"], 
     StyleBox["]", "MR"]}], Cell["standard deviation ", "TableText"]},
   {
    RowBox[{
     ButtonBox["Skewness",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Skewness"], 
     StyleBox["[", "MR"], 
     StyleBox["dist", "TI"], 
     StyleBox["]", "MR"]}], Cell["coefficient of skewness ", "TableText"]},
   {
    RowBox[{
     ButtonBox["Kurtosis",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Kurtosis"], 
     StyleBox["[", "MR"], 
     StyleBox["dist", "TI"], 
     StyleBox["]", "MR"]}], Cell["coefficient of kurtosis ", "TableText"]},
   {
    RowBox[{
     ButtonBox["CharacteristicFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CharacteristicFunction"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["dist", "TI"], 
      StyleBox[",", "MR"], 
      StyleBox["t", "TI"]}], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "characteristic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Phi]", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ExpectedValue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpectedValue"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      StyleBox["dist", "TI"]}], "]"}], Cell[TextData[{
     "expected value of the pure function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ExpectedValue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpectedValue"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      StyleBox["dist", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[TextData[{
     "expected value of ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     " for ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomReal"], 
     StyleBox["[", "MR"], 
     StyleBox["dist", "TI"], 
     StyleBox["]", "MR"]}], Cell[
    "pseudorandom number with specified distribution ", "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomReal"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["dist", "TI"], 
      StyleBox[",", "MR"], 
      StyleBox["dims", "TI"]}], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "pseudorandom array with dimensionality ",
     Cell[BoxData[
      StyleBox["dims", "TI"]], "InlineFormula"],
     ", and elements from the specified distribution "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->294100013],

Cell["Functions of statistical distributions.", "Caption",
 CellID->11121],

Cell[TextData[{
 "The ",
 StyleBox["cumulative distribution function",
  FontWeight->"Bold"],
 " (cdf) at ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is given by the integral of the ",
 StyleBox["probability density function",
  FontWeight->"Bold"],
 " (pdf) up to ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". The pdf can therefore be obtained by differentiating the cdf (perhaps in \
a generalized sense). In this package the distributions are represented in \
symbolic form. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PDF"], "[", 
   RowBox[{
    StyleBox["dist", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " evaluates the density at ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " if ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is a numerical value, and otherwise leaves the function in symbolic form. \
Similarly, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CDF"], "[", 
   RowBox[{"dist", ",", "x"}], "]"}]], "InlineFormula"],
 " gives the cumulative distribution. ",
 Cell[BoxData[
  RowBox[{"Domain", "[", 
   StyleBox["dist", "TI"], "]"}]], "InlineFormula"],
 " gives the domain of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PDF"], "[", 
   RowBox[{
    StyleBox["dist", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CDF"], "[", 
   RowBox[{
    StyleBox["dist", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->21149],

Cell[TextData[{
 "The inverse cdf ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseCDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseCDF"], "[", 
   RowBox[{
    StyleBox["dist", "TI"], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 " gives the value of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " at which ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CDF"], "[", 
   RowBox[{
    StyleBox["dist", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " reaches ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 ". The median is given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseCDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseCDF"], "[", 
   RowBox[{
    StyleBox["dist", "TI"], ",", 
    RowBox[{"1", "/", "2"}]}], "]"}]], "InlineFormula"],
 ". Quartiles, deciles and percentiles are particular values of the inverse \
cdf. Inverse cdfs are used in constructing confidence intervals for \
statistical parameters. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseCDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseCDF"], "[", 
   RowBox[{
    StyleBox["dist", "TI"], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"], "[", 
   RowBox[{
    StyleBox["dist", "TI"], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 " are equivalent for continuous distributions. "
}], "Text",
 CellID->25814],

Cell[TextData[{
 "The mean ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"], "[", 
   StyleBox["dist", "TI"], "]"}]], "InlineFormula"],
 " is the expectation of the random variable distributed according to ",
 Cell[BoxData[
  StyleBox["dist", "TI"]], "InlineFormula"],
 " and is usually denoted by ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]], "InlineMath"],
 ". The mean is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", 
    RowBox[{"\[Integral]", 
     RowBox[{"x", " ", 
      RowBox[{"f", "(", "x", ")"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " is the pdf of the distribution. The variance ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Variance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Variance"], "[", 
   StyleBox["dist", "TI"], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "\[Mu]"}], ")"}], "2"], 
     RowBox[{"f", "(", "x", ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath"],
 ". The square root of the variance is called the standard deviation, and is \
usually denoted by ",
 Cell[BoxData[
  FormBox["\[Sigma]", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->31361],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Skewness",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Skewness"], "[", 
   StyleBox["dist", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Kurtosis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Kurtosis"], "[", 
   StyleBox["dist", "TI"], "]"}]], "InlineFormula"],
 " functions give shape statistics summarizing the asymmetry and the \
peakedness of a distribution, respectively. Skewness is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     SuperscriptBox["\[Sigma]", "3"]], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "\[Mu]"}], ")"}], "3"], 
      RowBox[{"f", "(", "x", ")"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 " and kurtosis is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     SuperscriptBox["\[Sigma]", "4"]], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "\[Mu]"}], ")"}], "4"], 
      RowBox[{"f", "(", "x", ")"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->16049],

Cell[TextData[{
 "The characteristic function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CharacteristicFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacteristicFunction"], "[", 
   RowBox[{
    StyleBox["dist", "TI"], ",", 
    StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Phi]", 
     RowBox[{"(", "t", ")"}]}], "=", 
    RowBox[{"\[Integral]", 
     RowBox[{
      RowBox[{"f", "(", "x", ")"}], 
      RowBox[{"exp", "(", 
       RowBox[{"i", "t", "x"}], ")"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". In the discrete case, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Phi]", 
     RowBox[{"(", "t", ")"}]}], "=", 
    RowBox[{"\[Sum]", 
     RowBox[{
      RowBox[{"f", "(", "x", ")"}], 
      RowBox[{"exp", "(", 
       RowBox[{"i", "t", "x"}], ")"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". Each distribution has a unique characteristic function, which is \
sometimes used instead of the pdf to define a distribution. "
}], "Text",
 CellID->595730917],

Cell[TextData[{
 "The expected value ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExpectedValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpectedValue"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    StyleBox["dist", "TI"]}], "]"}]], "InlineFormula"],
 " of a function ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"f", "(", "x", ")"}], 
     RowBox[{"g", "(", "x", ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath"],
 ". In the discrete case, the expected value of ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Sum]", 
    RowBox[{
     RowBox[{"f", "(", "x", ")"}], 
     RowBox[{"g", "(", "x", ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExpectedValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpectedValue"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["g", "TI"], "[", 
     StyleBox["x", "TI"], "]"}], ",", 
    StyleBox["dist", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExpectedValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpectedValue"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    StyleBox["dist", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->524388714],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomReal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomReal"], "[", 
   StyleBox["dist", "TI"], "]"}]], "InlineFormula"],
 " gives pseudorandom numbers from the specified distribution."
}], "Text",
 CellID->23100],

Cell[TextData[{
 "This gives a symbolic representation of the gamma distribution with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", "=", "3"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Beta]", "=", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->26142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gdist", "=", 
  RowBox[{"GammaDistribution", "[", 
   RowBox[{"3", ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27224],

Cell[BoxData[
 RowBox[{"GammaDistribution", "[", 
  RowBox[{"3", ",", "1"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5958379]
}, Open  ]],

Cell[TextData[{
 "Here is the cumulative distribution function evaluated at ",
 Cell[BoxData[
  FormBox["10", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->20513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{"gdist", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20642],

Cell[BoxData[
 RowBox[{"GammaRegularized", "[", 
  RowBox[{"3", ",", "0", ",", "10"}], "]"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->409789562]
}, Open  ]],

Cell[TextData[{
 "This is the cumulative distribution function. It is given in terms of the \
built\[Hyphen]in function ",
 Cell[BoxData[
  ButtonBox["GammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaRegularized"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cdfunction", "=", 
  RowBox[{"CDF", "[", 
   RowBox[{"gdist", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->32696],

Cell[BoxData[
 RowBox[{"GammaRegularized", "[", 
  RowBox[{"3", ",", "0", ",", "x"}], "]"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->261435933]
}, Open  ]],

Cell["Here is a plot of the cumulative distribution function. ", "MathCaption",
 CellID->7029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"cdfunction", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->31113],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WE1QHEUUbnZ2FyRJidHoCoRsEhPRGII/qeD/aoygFhW0tETLH1aMLmrM
SjCuGl2jUaLGEKORI+XBonLikiqOHDly5MiRI0eO4/de9+xM97z9Yat0qna2
3/TXX79+7+vXszucnyqcOp2fmhjPZwcn88XCxPjZ7PNnJvHIa1FK3cSnlFFo
+2jx56bv4zt+P4x7EoDdZHmE5Et145Ywz+mbbOpOGNvj0X2RUUpg6aJbMrSV
8KQ79oTmoGW00Dc/OuLwdhqv42Ob4+93+O+W1hVjTYg99dk7I2M90cNGfD5c
1aeeullohL+vCltUEdFvz1JGVGMdDsPfNZ7uwP0f44/BtFcwuJaWlubm5gqF
QiaTwfO1tbW0w5OqYye3iP+/7f/aP0+MPs+a3NzcRHR7e3unp6d3OYhux5Yq
Rq1+ed50MG+pVMrlcuvr67Miro1tZL+/v39lZUX9VUGR5tq5F4NBQb3XRQ6N
2tjYMKg/RdQ2B/WHiNrONuQHFO7qmojawTZYBgYGsEb1u+X1rdy7sLAwMjJC
zasih0YVi8WZmRlqztRAYQ74s7y8XAWl7dXVVUSR/Lkiom5jG9NhUmr+Znl9
O/diGiSDmpdFjp1BRiAmxNKgjAj48iIj2MbH1b6eC5IcGxuj5q8aa1WulMPj
ctzB9tDQ0OLiIjV/ETjcGuKJHMgzVkNxkzhanTFUwcjc5UTz5wbHRu072dbS
p+YlgUPv4NiTGEuoxkuxnKRNjt2acZdva3BazLlGgTmbzSLzERRx6jM1VPtP
IodGAQIgNX+sgcIcmIlWIqM62UYpQ22h5kXLn67AW+SUdvBFkaPL8foHEdXt
aOz7Gqhw98koXTfhMhyn5gXL6x4nxhdEjh7H6+9E1B7H63JMD9xMRc9fJahj
j7Muw7OlHZZ1Vv2twEF6TppvGpp1MlhtTLQ6uL7vZRsBQBio+Y3AkfLlXbHP
t7V6fstjQwWfj8XerQluxPb7dl352tLJAd+uGF+JCrjHNxUBwOqoA05uvqyB
CrMhow468S5ZXvdyL4o9Sj41vxA57mUbpwpmoj0gozQXDikcVdQ8J6LuYxvv
k7Oz/OLxeQ1UuLYQRV4f4l6cuqir1JwSOQiVKJfLU7FMu5mV9HIo8MCc72cF
rdU/AR7w7Z062RQL//LwEDCEjZqfNcxCJH1OjotVRntCFPqCKMB/rEIcW+99
+ogTgzOxfLSavLoj9e+48G3kUzHPD7IdnpWnLa08zL1hzf1E5HjINwqHomid
MkpzQY9A0T74WEQ94ps9DuXQm9hHIuqob/YlyhlFZcLy+hj3zs/Pj46OUrMg
chxz4vOhiBpwUB+IqEcd1CkR9RjbKEsG9b7l9RMBh1nTuMihUfqspPi8F9ND
I/vzySB+JmN5QZn1d9ZTgTbBAi411jALkTwdqAbyQkzUu8LoaufRM2yjxmMs
aentpvx/NogC9hYqr3qrKZbjjNC/5uARUvdmLCfV3lRPBIqAB1Qn37AUMcjM
Or6QMqZ4XdQEH01J6B2nM7jgwWsi7gXG6V+vgEJqr4q4l4IVQaca94qIG6Zb
Cjta41BiSbcnrTWMBBhUX2AwM51IwyLfy3RLY14sAljEE5QQyIsimn1PI29g
7ujowH6Ao0APimiOXBr7Br5qNLgR2udENGewFWhw4xDNZDKIvx6gctb63iHr
FviM8FfAUCWOTgiLtPm4OAPvuG3oBwpYjMA4OIZFoxgjAFgYzXY0Irrgcn9v
ScriOrUd4QAPSrv+vwLeAYE72nAW82JNCZI+nVJm5P08lTuHV3cf8MmRgs/g
Ay3IMYVKYCrltbW1AUh/grGdQhLKwYUo84sPVxLDtbtJH84Fyl3iC4LwMINK
Id254KIgpGlPsmcVT1Q73Tx90FVma9AHAtDv0zSvA9NanPpFdKuc8X8bmx0n
VaIb/Cj+D7tq+RdmTGYN\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->55585970]
}, Open  ]],

Cell["\<\
This is a pseudorandom array with elements distributed according to the gamma \
distribution. \
\>", "MathCaption",
 CellID->14290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{"gdist", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->10197],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.464456956965619`", ",", "8.563588349943194`", ",", "2.706472226371482`", 
   ",", "1.9774833749018284`", ",", "2.9710828452382962`"}], "}"}]], "Output",\

 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->960813246]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->417005788],

Cell[TextData[{
 ButtonBox["M215: Applied Statistical Analysis with ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m215.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m215.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->221766396]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Continuous Distributions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 38.3587232}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The functions described here are among the most commonly used continuous \
statistical distributions. You can compute their densities, means, variances, \
and other related properties. The distributions themselves are represented in \
the symbolic form name[param_1,param_2,...]. Functions such as Mean, which \
give properties of statistical distributions, take the symbolic \
representation of the distribution as an argument. \"Discrete Distributions\" \
describes many discrete statistical distributions. Distributions related to \
the normal distribution. The lognormal distribution \
LogNormalDistribution[\\[Mu],\\[Sigma]] is the distribution followed by the \
exponential of a normally distributed random variable. This distribution \
arises when many independent random variables are combined in a \
multiplicative fashion. The half-normal distribution \
HalfNormalDistribution[\\[Theta]] is proportional to the distribution \
NormalDistribution[0,1/(\\[Theta] Sqrt[2/\\[Pi]])] limited to the domain \
[0,Infinity). ", "synonyms" -> {}, "title" -> "Continuous Distributions", 
    "type" -> "Tutorial", "uri" -> "tutorial/ContinuousDistributions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 5472, 97, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[6097, 124, 57, 1, 70, "Title",
 CellID->11002],
Cell[6157, 127, 1037, 28, 70, "Text",
 CellID->4255],
Cell[7197, 157, 1968, 58, 70, "DefinitionBox",
 CellID->46851034],
Cell[9168, 217, 89, 1, 70, "Caption",
 CellID->216572643],
Cell[9260, 220, 1563, 52, 70, "Text",
 CellID->37175843],
Cell[10826, 274, 525, 16, 70, "Text",
 CellID->522464858],
Cell[11354, 292, 3383, 103, 70, "DefinitionBox",
 CellID->15786],
Cell[14740, 397, 89, 1, 70, "Caption",
 CellID->5218],
Cell[14832, 400, 1186, 38, 70, "Text",
 CellID->26791],
Cell[16021, 440, 1690, 55, 70, "Text",
 CellID->7838],
Cell[17714, 497, 425, 11, 70, "Text",
 CellID->24346],
Cell[18142, 510, 208, 7, 70, "Text",
 CellID->85717943],
Cell[18353, 519, 1325, 42, 70, "Text",
 CellID->88989109],
Cell[19681, 563, 1383, 50, 70, "Text",
 CellID->306596152],
Cell[21067, 615, 1731, 62, 70, "Text",
 CellID->32827621],
Cell[22801, 679, 1693, 55, 70, "DefinitionBox",
 CellID->45881053],
Cell[24497, 736, 71, 1, 70, "Caption",
 CellID->118596088],
Cell[24571, 739, 1628, 59, 70, "Text",
 CellID->92695939],
Cell[26202, 800, 774, 25, 70, "Text",
 CellID->310268923],
Cell[26979, 827, 6055, 182, 70, "DefinitionBox",
 CellID->992],
Cell[33037, 1011, 78, 1, 70, "Caption",
 CellID->7207],
Cell[33118, 1014, 956, 37, 70, "Text",
 CellID->2441941],
Cell[34077, 1053, 1552, 51, 70, "Text",
 CellID->891935298],
Cell[35632, 1106, 1057, 38, 70, "Text",
 CellID->30740],
Cell[36692, 1146, 2221, 79, 70, "Text",
 CellID->412578314],
Cell[38916, 1227, 920, 29, 70, "Text",
 CellID->19758049],
Cell[39839, 1258, 515, 18, 70, "Text",
 CellID->236940748],
Cell[40357, 1278, 1797, 48, 70, "Text",
 CellID->182364425],
Cell[42157, 1328, 5592, 194, 70, "DefinitionBox",
 CellID->294100013],
Cell[47752, 1524, 74, 1, 70, "Caption",
 CellID->11121],
Cell[47829, 1527, 1791, 62, 70, "Text",
 CellID->21149],
Cell[49623, 1591, 1612, 56, 70, "Text",
 CellID->25814],
Cell[51238, 1649, 1496, 50, 70, "Text",
 CellID->31361],
Cell[52737, 1701, 1298, 46, 70, "Text",
 CellID->16049],
Cell[54038, 1749, 1118, 38, 70, "Text",
 CellID->595730917],
Cell[55159, 1789, 1484, 54, 70, "Text",
 CellID->524388714],
Cell[56646, 1845, 284, 9, 70, "Text",
 CellID->23100],
Cell[56933, 1856, 328, 11, 70, "MathCaption",
 CellID->26142],
Cell[CellGroupData[{
Cell[57286, 1871, 160, 5, 70, "Input",
 CellID->27224],
Cell[57449, 1878, 223, 7, 36, "Output",
 CellID->5958379]
}, Open  ]],
Cell[57687, 1888, 184, 6, 70, "MathCaption",
 CellID->20513],
Cell[CellGroupData[{
Cell[57896, 1898, 123, 4, 70, "Input",
 CellID->20642],
Cell[58022, 1904, 235, 7, 36, "Output",
 CellID->409789562]
}, Open  ]],
Cell[58272, 1914, 298, 9, 70, "MathCaption",
 CellID->25265],
Cell[CellGroupData[{
Cell[58595, 1927, 155, 5, 70, "Input",
 CellID->32696],
Cell[58753, 1934, 234, 7, 36, "Output",
 CellID->261435933]
}, Open  ]],
Cell[59002, 1944, 94, 1, 70, "MathCaption",
 CellID->7029],
Cell[CellGroupData[{
Cell[59121, 1949, 188, 6, 28, "Input",
 CellID->31113],
Cell[59312, 1957, 2184, 40, 141, "Output",
 Evaluatable->False,
 CellID->55585970]
}, Open  ]],
Cell[61511, 2000, 141, 4, 70, "MathCaption",
 CellID->14290],
Cell[CellGroupData[{
Cell[61677, 2008, 129, 4, 70, "Input",
 CellID->10197],
Cell[61809, 2014, 330, 10, 36, "Output",
 CellID->960813246]
}, Open  ]],
Cell[CellGroupData[{
Cell[62176, 2029, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->417005788],
Cell[62277, 2032, 430, 13, 70, "TutorialRelatedLinks",
 CellID->221766396]
}, Open  ]]
}, Open  ]],
Cell[62734, 2049, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

