(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25946,        817]
NotebookOptionsPosition[     19660,        630]
NotebookOutlinePosition[     23061,        710]
CellTagsIndexPosition[     22968,        704]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EvaluationOfExpressionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Evaluation of Expressions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$IterationLimit" :> 
          Documentation`HelpLookup["paclet:ref/$IterationLimit"], 
          "$RecursionLimit" :> 
          Documentation`HelpLookup["paclet:ref/$RecursionLimit"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$IterationLimit\"\>", 
       2->"\<\"$RecursionLimit\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Controlling Infinite Evaluation", "Title",
 CellTags->{"S2.6.14", "14.1"},
 CellID->22466],

Cell[TextData[{
 "The general principle that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " follows in evaluating expressions is to go on applying transformation \
rules until the expressions no longer change. This means, for example, that \
if you make an assignment like ",
 Cell[BoxData[
  RowBox[{"x", "=", 
   RowBox[{"x", "+", "1"}]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " should go into an infinite loop. In fact, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stops after a definite number of steps, determined by the value of the \
global variable ",
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 ". You can always stop ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " earlier by explicitly interrupting it. "
}], "Text",
 CellID->4678],

Cell[TextData[{
 "This assignment could cause an infinite loop. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stops after a number of steps determined by ",
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->22593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"x", "+", "1"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23851],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"Recursion depth of \\!\\(256\\) exceeded. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/$RecursionLimit/reclim\\\", ButtonNote -> \
\\\"$RecursionLimit::reclim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[1]:=",
 CellID->347595217],

Cell[BoxData[
 RowBox[{"255", "+", 
  RowBox[{"Hold", "[", 
   RowBox[{"1", "+", "x"}], "]"}]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->593507993]
}, Open  ]],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stops without finishing evaluation, it returns a held result. You can \
continue the evaluation by explicitly calling ",
 Cell[BoxData[
  ButtonBox["ReleaseHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReleaseHold"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->28464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReleaseHold", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21119],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"Recursion depth of \\!\\(256\\) exceeded. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/$RecursionLimit/reclim\\\", ButtonNote -> \
\\\"$RecursionLimit::reclim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[2]:=",
 CellID->29596410],

Cell[BoxData[
 RowBox[{"510", "+", 
  RowBox[{"Hold", "[", 
   RowBox[{"1", "+", "x"}], "]"}]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->505154191]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$RecursionLimit",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$RecursionLimit"], Cell[
    "maximum depth of the evaluation stack", "TableText"]},
   {
    ButtonBox["$IterationLimit",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$IterationLimit"], Cell[
    "maximum length of an evaluation chain", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18087],

Cell["Global variables that limit infinite evaluation. ", "Caption",
 CellID->31060],

Cell[TextData[{
 "Here is a circular definition, whose evaluation is stopped by ",
 Cell[BoxData[
  ButtonBox["$IterationLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$IterationLimit"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}], "=", 
  RowBox[{"{", 
   RowBox[{"b", ",", "a"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->9010],

Cell[BoxData[
 RowBox[{
  RowBox[{"$IterationLimit", "::", "\<\"itlim\"\>"}], ":", 
  " ", "\<\"Iteration limit of \\!\\(4096\\) exceeded. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/$IterationLimit/itlim\\\
\", ButtonNote -> \\\"$IterationLimit::itlim\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->357396639],

Cell[BoxData[
 RowBox[{
  RowBox[{"$IterationLimit", "::", "\<\"itlim\"\>"}], ":", 
  " ", "\<\"Iteration limit of \\!\\(4096\\) exceeded. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/$IterationLimit/itlim\\\
\", ButtonNote -> \\\"$IterationLimit::itlim\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->54212303],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Hold", "[", "b", "]"}], ",", 
   RowBox[{"Hold", "[", "a", "]"}]}], "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->621202309]
}, Open  ]],

Cell[TextData[{
 "The variables ",
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$IterationLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$IterationLimit"]], "InlineFormula"],
 " control the two basic ways that an evaluation can become infinite in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". ",
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 " limits the maximum depth of the evaluation stack, or equivalently, the \
maximum nesting depth that would occur in the list structure produced by ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["$IterationLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$IterationLimit"]], "InlineFormula"],
 " limits the maximum length of any particular evaluation chain, or the \
maximum length of any single list in the structure produced by ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->9576],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$IterationLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$IterationLimit"]], "InlineFormula"],
 " are by default set to values that are appropriate for most computations, \
and most computer systems. You can, however, reset these variables to any \
integer (above a lower limit), or to ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 ". Note that on most computer systems, you should never set ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["$RecursionLimit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$RecursionLimit"], "=", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 ", as discussed in\[NonBreakingSpace]\"",
 ButtonBox["Memory Management\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MemoryManagement"],
 ". "
}], "Text",
 CellID->30227],

Cell[TextData[{
 "This resets ",
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$IterationLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$IterationLimit"]], "InlineFormula"],
 " to ",
 Cell[BoxData["20"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$RecursionLimit", "=", 
  RowBox[{"$IterationLimit", "=", "20"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->22758],

Cell[BoxData["20"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->33296986]
}, Open  ]],

Cell["\<\
Now infinite definitions like this are stopped after just 20 steps. \
\>", "MathCaption",
 CellID->5109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"{", "t", "}"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->7882],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"Recursion depth of \\!\\(20\\) exceeded. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/$RecursionLimit/reclim\\\", ButtonNote -> \
\\\"$RecursionLimit::reclim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[5]:=",
 CellID->88175530],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmVEPgiAQxw+QWuuh197y09Ry60M416YPrWZ+f+NUmiM21GVgOzaR3wl1
4f84zEta5ddbWhVZGp/K9JEX2TM+3ktlEgyAnQFgtwfVrlWrObAk6gCIsBba
VhM7+KAqrnBl2DeWcdhPBuZ/6MyxAhGYV6Fz7Li+DczfpTOrSaUDOXqzKnix
NevCOyvOpTTOrs8WQPmLlB0CN1lL9pWutf1pHTbW9Y3COoru2xzRwAPzKnS2
a/Ob0eDSubk7N/vTrtzN6tGx0T9lhCnsKSOQxmfOBRQH4+NAjlN+n0n33pl0
P4XtesdZxE6mRtHOdYfW7JxxHVm+f+m/Mel9Ctv1bv7vaO7LXU9WtLb/Quu+
vVgaY7M16oJvf3D9XnfnqKa3RLOvNg0kA1rAXpBLK80=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{329, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->66900417]
}, Open  ]],

Cell["\<\
Without an end condition, this recursive definition leads to infinite \
computations. \
\>", "MathCaption",
 CellID->3487],

Cell[BoxData[
 RowBox[{
  RowBox[{"fn", "[", "n_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"fn", "[", 
     RowBox[{"n", "-", "1"}], "]"}], ",", "n"}], "}"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->29577],

Cell["\<\
A fairly large structure is built up before the computation is stopped. \
\>", "MathCaption",
 CellID->14474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fn", "[", "10", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->2625],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"Recursion depth of \\!\\(20\\) exceeded. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/$RecursionLimit/reclim\\\", ButtonNote -> \
\\\"$RecursionLimit::reclim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[7]:=",
 CellID->12437845],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWlFP2zAQNklTVqC0DEbhad0L/2FMe9gehqaNH1GhSfAwbWL8fy927CZc
P+fOSWi6KZHq5uzL2f58Z5/Pvl093f/4uXp6uFstbx5Xv+8f7v4sv/x6zLPS
PaWSG6XUuwuVv+v8zf788zX/lWRBfTJpuuZSI0LPdrx8zpSfE9okt7bnn0lJ
midJTp70lP86kH8BevDd9uA6T01BxmAwcXwpw7cvlCfle8WUt61/zPCZ8sz1
G8ktkXxv0qxqK/k7bK8ZkUOSnwT49qOkxnFPBNjGS6U9QxqDak9EtZR4f2Tq
OcqTMZBArR19t9kOOu7cnCKTguy4Sh+LMEI6+Q1iRLVsKsKctrKZFA53mRSD
+yiQ30abPuhCKymWdgRGJb0pw3CgmWHqWkrzORxC8o7F+HRpVXSsq/KRJKqx
CBU6v3ava9vBSjbjt0VMhCjbil3CzfscaJ4xNkgtwts8zZ9r7JOYXmQBOaje
eSB/pss5AZWbpPADfb+Rd9wNxfk9A/2cfquLsTt1/1e6HEs0zy8YeVw53SPE
ft93+UvvsawtsruHgX5OLwlN93dXAtSNtl9G5tP9YlM5XeV3tT+2+AxaKKFL
n1cXq58Dzz2JLtfejPxT38DkFxOufzwT5T5wUufuq9iW+xWe2/1zER+pj9+0
/hMti6ZI5XmPR9IPCZ80ijIWypPyWU9ysM9IGvvfMq9cxkVHJBV9NYFcdG6W
9NbM3TNRnZ5bUovhk+14mrXhFGHdWurL4LALkcPCR0QoDXSYxrbYv/X7lT8c
s8y8hkT0dqorfgYbCT1y3FyU3/PJ4qvTgFQU0fRSUSTa10oxQBFptHrS+j0f
bS9Che9l20iePbkZ1vJI+v9ey9+I6kK7zyp9JpJC95J0XZG1hZPSNu4iP/Wo
k8KV29EbbDGSrl/BoPVVaaHtJWrT56G03xfT+A/Xg3ON93ESC0NnVyF5NvpZ
e0q20DjuyrVkO/bDnckN9tOExnYTuknhbcFtAxQah3U0aeSE2RKkV9tcr7g1
4ozQ1FOiZwd1ZxNN6m+7hnVjY9zJ7mBjTWhsY/QODtU4ij28A9OTNUVw1dhM
W5vqsq3bsS+ZlMLK+tbaf41O11D6x+DoI1ze06veFTjU5W241NkKPX/2J20p
GCejv+g8ZaHxyYHJR3ckLjW+U7EI1FuXj9bZ0J2KWST/gQVXuyf2doTa+wsp
OnIg\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{583, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->284065764]
}, Open  ]],

Cell["Here is another recursive definition. ", "MathCaption",
 CellID->31928],

Cell[BoxData[
 RowBox[{
  RowBox[{"fm", "[", "n_", "]"}], ":=", 
  RowBox[{"fm", "[", 
   RowBox[{"n", "-", "1"}], "]"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->25423],

Cell[TextData[{
 "In this case, no complicated structure is built up, and the computation is \
stopped by ",
 Cell[BoxData[
  ButtonBox["$IterationLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$IterationLimit"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fm", "[", "0", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->6902],

Cell[BoxData[
 RowBox[{
  RowBox[{"$IterationLimit", "::", "\<\"itlim\"\>"}], ":", 
  " ", "\<\"Iteration limit of \\!\\(20\\) exceeded. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/$IterationLimit/itlim\\\", ButtonNote -> \
\\\"$IterationLimit::itlim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[9]:=",
 CellID->712470993],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"fm", "[", 
   RowBox[{
    RowBox[{"-", "19"}], "-", "1"}], "]"}], "]"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->678088347]
}, Open  ]],

Cell[TextData[{
 "It is important to realize that infinite loops can take up not only time \
but also computer memory. Computations limited by ",
 Cell[BoxData[
  ButtonBox["$IterationLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$IterationLimit"]], "InlineFormula"],
 " do not normally build up large intermediate structures. But those limited \
by ",
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 " often do. In many cases, the size of the structures produced is a linear \
function of the value of ",
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 ". But in some cases, the size can grow exponentially, or worse, with ",
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->24596],

Cell[TextData[{
 "An assignment like ",
 Cell[BoxData[
  RowBox[{"x", "=", 
   RowBox[{"x", "+", "1"}]}]], "InlineFormula"],
 " is obviously circular. When you set up more complicated recursive \
definitions, however, it can be much more difficult to be sure that the \
recursion terminates, and that you will not end up in an infinite loop. The \
main thing to check is that the right\[Hyphen]hand sides of your \
transformation rules will always be different from the left\[Hyphen]hand \
sides. This ensures that evaluation will always \[OpenCurlyDoubleQuote]make \
progress\[CloseCurlyDoubleQuote], and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will not simply end up applying the same transformation rule to the same \
expression over and over again. "
}], "Text",
 CellID->3737],

Cell[TextData[{
 "Some of the trickiest cases occur when you have rules that depend on \
complicated ",
 Cell[BoxData["/;"], "InlineFormula"],
 " conditions (see \"",
 ButtonBox["Putting Constraints on Patterns\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"],
 "). One particularly awkward case is when the condition involves a \
\[OpenCurlyDoubleQuote]global variable\[CloseCurlyDoubleQuote]. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " may think that the evaluation is finished because the expression did not \
change. However, a side effect of some other operation could change the value \
of the global variable, and so should lead to a new result in the evaluation. \
The best way to avoid this kind of difficulty is not to use global variables \
in ",
 Cell[BoxData["/;"], "InlineFormula"],
 " conditions. If all else fails, you can type ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Update",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Update"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 " to tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to update all expressions involving ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Update",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Update"], "[", "]"}]], "InlineFormula"],
 " tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to update absolutely all expressions. "
}], "Text",
 CellID->13261],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->625351867],

Cell[TextData[ButtonBox["Evaluation of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EvaluationOfExpressionsOverview"]], "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Controlling Infinite Evaluation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Evaluation of Expressions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/EvaluationOfExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TheEvaluationStack"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/InterruptsAndAborts"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 38.7962344}", "context" -> "", 
    "keywords" -> {
     "circular definitions", "definitions", "endless loops", "errors", 
      "evaluation chain", "global variables", "hold", "infinite recursion", 
      "limit", "loops", "memory", "recursion", "ReleaseHold", "stack", 
      "stopping iteration", "stopping recursion", "update", "IterationLimit", 
      "RecursionLimit"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The general principle that Mathematica follows in evaluating expressions \
is to go on applying transformation rules until the expressions no longer \
change. This means, for example, that if you make an assignment like x=x+1, \
Mathematica should go into an infinite loop. In fact, Mathematica stops after \
a definite number of steps, determined by the value of the global variable \
$RecursionLimit. You can always stop Mathematica earlier by explicitly \
interrupting it. This assignment could cause an infinite loop. Mathematica \
stops after a number of steps determined by $RecursionLimit. When Mathematica \
stops without finishing evaluation, it returns a held result. You can \
continue the evaluation by explicitly calling ReleaseHold.", 
    "synonyms" -> {"2.6.13"}, "title" -> "Controlling Infinite Evaluation", 
    "type" -> "Tutorial", "uri" -> 
    "tutorial/ControllingInfiniteEvaluation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.6.14"->{
  Cell[1980, 61, 96, 2, 70, "Title",
   CellTags->{"S2.6.14", "14.1"},
   CellID->22466]},
 "14.1"->{
  Cell[1980, 61, 96, 2, 70, "Title",
   CellTags->{"S2.6.14", "14.1"},
   CellID->22466]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.6.14", 22752, 693},
 {"14.1", 22854, 697}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1355, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1980, 61, 96, 2, 70, "Title",
 CellTags->{"S2.6.14", "14.1"},
 CellID->22466],
Cell[2079, 65, 896, 27, 70, "Text",
 CellID->4678],
Cell[2978, 94, 339, 11, 70, "MathCaption",
 CellID->22593],
Cell[CellGroupData[{
Cell[3342, 109, 111, 4, 70, "Input",
 CellID->23851],
Cell[3456, 115, 439, 8, 19, "Message",
 CellID->347595217],
Cell[3898, 125, 238, 8, 36, "Output",
 CellID->593507993]
}, Open  ]],
Cell[4151, 136, 363, 12, 70, "MathCaption",
 CellID->28464],
Cell[CellGroupData[{
Cell[4539, 152, 103, 3, 70, "Input",
 CellID->21119],
Cell[4645, 157, 438, 8, 19, "Message",
 CellID->29596410],
Cell[5086, 167, 238, 8, 36, "Output",
 CellID->505154191]
}, Open  ]],
Cell[5339, 178, 687, 19, 70, "DefinitionBox",
 CellID->18087],
Cell[6029, 199, 84, 1, 70, "Caption",
 CellID->31060],
Cell[6116, 202, 255, 8, 70, "MathCaption",
 CellID->1926],
Cell[CellGroupData[{
Cell[6396, 214, 181, 7, 70, "Input",
 CellID->9010],
Cell[6580, 223, 439, 9, 70, "Message",
 CellID->357396639],
Cell[7022, 234, 438, 9, 70, "Message",
 CellID->54212303],
Cell[7463, 245, 268, 9, 36, "Output",
 CellID->621202309]
}, Open  ]],
Cell[7746, 257, 1265, 38, 70, "Text",
 CellID->9576],
Cell[9014, 297, 1094, 32, 70, "Text",
 CellID->30227],
Cell[10111, 331, 397, 15, 70, "MathCaption",
 CellID->12043],
Cell[CellGroupData[{
Cell[10533, 350, 140, 4, 70, "Input",
 CellID->22758],
Cell[10676, 356, 158, 5, 36, "Output",
 CellID->33296986]
}, Open  ]],
Cell[10849, 364, 114, 3, 70, "MathCaption",
 CellID->5109],
Cell[CellGroupData[{
Cell[10988, 371, 110, 4, 70, "Input",
 CellID->7882],
Cell[11101, 377, 437, 8, 19, "Message",
 CellID->88175530],
Cell[11541, 387, 621, 14, 36, "Output",
 Evaluatable->False,
 CellID->66900417]
}, Open  ]],
Cell[12177, 404, 132, 4, 70, "MathCaption",
 CellID->3487],
Cell[12312, 410, 223, 8, 70, "Input",
 CellID->29577],
Cell[12538, 420, 119, 3, 70, "MathCaption",
 CellID->14474],
Cell[CellGroupData[{
Cell[12682, 427, 94, 3, 70, "Input",
 CellID->2625],
Cell[12779, 432, 437, 8, 19, "Message",
 CellID->12437845],
Cell[13219, 442, 1436, 28, 54, "Output",
 Evaluatable->False,
 CellID->284065764]
}, Open  ]],
Cell[14670, 473, 77, 1, 70, "MathCaption",
 CellID->31928],
Cell[14750, 476, 172, 6, 70, "Input",
 CellID->25423],
Cell[14925, 484, 282, 9, 70, "MathCaption",
 CellID->28520],
Cell[CellGroupData[{
Cell[15232, 497, 93, 3, 70, "Input",
 CellID->6902],
Cell[15328, 502, 435, 8, 70, "Message",
 CellID->712470993],
Cell[15766, 512, 263, 9, 36, "Output",
 CellID->678088347]
}, Open  ]],
Cell[16044, 524, 976, 26, 70, "Text",
 CellID->24596],
Cell[17023, 552, 796, 17, 70, "Text",
 CellID->3737],
Cell[17822, 571, 1504, 42, 70, "Text",
 CellID->13261],
Cell[CellGroupData[{
Cell[19351, 617, 72, 1, 70, "RelatedTutorialsSection",
 CellID->625351867],
Cell[19426, 620, 180, 4, 70, "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],
Cell[19633, 628, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

