(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12391,        420]
NotebookOptionsPosition[      7906,        293]
NotebookOutlinePosition[     11099,        371]
CellTagsIndexPosition[     11008,        365]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Calculations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicCalculationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Calculations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Short" :> Documentation`HelpLookup["paclet:ref/Short"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Short\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Controlling the Display of Large Expressions", "Title",
 CellTags->{"S1.4.8", "8.1"},
 CellID->25547],

Cell[TextData[{
 "When you do symbolic calculations, it is quite easy to end up with \
extremely complicated expressions. Often, you will not even want to ",
 StyleBox["see",
  FontSlant->"Italic"],
 " the complete result of a computation. "
}], "Text",
 CellID->21153],

Cell[TextData[{
 "If you end your input with a semicolon, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will do the computation you asked for, but will not display the result. \
You can nevertheless use ",
 Cell[BoxData["%"], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " to refer to the result."
}], "Text",
 CellID->21520],

Cell[TextData[{
 "Even though you may not want to see the ",
 StyleBox["whole",
  FontSlant->"Italic"],
 " result from a computation, you often do need to see its basic form. You \
can use ",
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " to display the ",
 StyleBox["outline",
  FontSlant->"Italic"],
 " of an expression, omitting some of the terms."
}], "Text",
 CellID->29790],

Cell[TextData[{
 "Ending your input with ",
 Cell[BoxData[";"], "InlineFormula"],
 " stops ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from displaying the complicated result of the computation. "
}], "MathCaption",
 CellID->14924],

Cell[BoxData[
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", 
      RowBox[{"5", " ", "y"}], "+", "10"}], ")"}], "^", "8"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->30188],

Cell[TextData[{
 "You can still refer to the result as ",
 Cell[BoxData["%"], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{"//", 
   ButtonBox["Short",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Short"]}]], "InlineFormula"],
 " displays a one\[Hyphen]line outline of the result. The ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"<<", 
    StyleBox["n", "TI"]}], ">>"}]], "InlineFormula"],
 " stands for ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " terms that have been left out. "
}], "MathCaption",
 CellID->21763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Short"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->4940],

Cell[BoxData[
 TagBox[
  RowBox[{"100000000", "+", 
   RowBox[{"80000000", " ", "x"}], "+", 
   RowBox[{"\[LeftSkeleton]", "42", "\[RightSkeleton]"}], "+", 
   RowBox[{"390625", " ", 
    SuperscriptBox["y", "8"]}]}],
  Short]], "Output",
 ImageSize->{281, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short= ",
 CellID->20851]
}, Open  ]],

Cell["\<\
This shows a three\[Hyphen]line version of the expression. More parts are now \
visible. \
\>", "MathCaption",
 CellID->18662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"%", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->13829],

Cell[BoxData[
 TagBox[
  RowBox[{"100000000", "+", 
   RowBox[{"80000000", " ", "x"}], "+", 
   RowBox[{"28000000", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"5600000", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"700000", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"\[LeftSkeleton]", "35", "\[RightSkeleton]"}], "+", 
   RowBox[{"8750000", " ", "x", " ", 
    SuperscriptBox["y", "6"]}], "+", 
   RowBox[{"437500", " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "6"]}], "+", 
   RowBox[{"6250000", " ", 
    SuperscriptBox["y", "7"]}], "+", 
   RowBox[{"625000", " ", "x", " ", 
    SuperscriptBox["y", "7"]}], "+", 
   RowBox[{"390625", " ", 
    SuperscriptBox["y", "8"]}]}],
  Short[#, 3]& ]], "Output",
 ImageSize->{468, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//Short= ",
 CellID->30900]
}, Open  ]],

Cell["This gives the total number of terms in the sum.", "MathCaption",
 CellID->17713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->18958],

Cell[BoxData["45"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->17578]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["command", "TI"], ";"}], Cell[TextData[{
     "execute ",
     Cell[BoxData[
      StyleBox["command", "TI"]], "InlineFormula"],
     ", but do not print the result"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["expr", "TI"], "//", 
     ButtonBox["Short",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Short"]}], Cell[TextData[{
     "show a one\[Hyphen]line outline form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Short",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Short"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "show an ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "\[Hyphen]line outline of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8365],

Cell["Some ways to shorten your output. ", "Caption",
 CellID->13007],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->686338117],

Cell[TextData[ButtonBox["Algebraic Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicCalculationsOverview"]], "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Controlling the Display of Large Expressions - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicCalculationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/PickingOutPiecesOfAlgebraicExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TheLimitsOfMathematica"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 43.6401084}", "context" -> "", 
    "keywords" -> {
     "display", "expressions", "length", "number of terms", "omitted terms", 
      "Oneline output", "outline", "output", "semicolon", "Short", 
      "silent operation", "skeleton", "skeleton output", 
      "suppressing output"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "When you do symbolic calculations, it is quite easy to end up with \
extremely complicated expressions. Often, you will not even want to see the \
complete result of a computation. If you end your input with a semicolon, \
Mathematica will do the computation you asked for, but will not display the \
result. You can nevertheless use % or Out[n] to refer to the result. Even \
though you may not want to see the whole result from a computation, you often \
do need to see its basic form. You can use Short to display the outline of an \
expression, omitting some of the terms.", "synonyms" -> {"1.4.8"}, "title" -> 
    "Controlling the Display of Large Expressions", "type" -> "Tutorial", 
    "uri" -> "tutorial/ControllingTheDisplayOfLargeExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.4.8"->{
  Cell[1803, 58, 107, 2, 70, "Title",
   CellTags->{"S1.4.8", "8.1"},
   CellID->25547]},
 "8.1"->{
  Cell[1803, 58, 107, 2, 70, "Title",
   CellTags->{"S1.4.8", "8.1"},
   CellID->25547]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.4.8", 10795, 354},
 {"8.1", 10895, 358}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1178, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1803, 58, 107, 2, 70, "Title",
 CellTags->{"S1.4.8", "8.1"},
 CellID->25547],
Cell[1913, 62, 269, 7, 70, "Text",
 CellID->21153],
Cell[2185, 71, 477, 16, 70, "Text",
 CellID->21520],
Cell[2665, 89, 448, 15, 70, "Text",
 CellID->29790],
Cell[3116, 106, 241, 8, 70, "MathCaption",
 CellID->14924],
Cell[3360, 116, 233, 9, 70, "Input",
 CellID->30188],
Cell[3596, 127, 541, 19, 70, "MathCaption",
 CellID->21763],
Cell[CellGroupData[{
Cell[4162, 150, 93, 3, 28, "Input",
 CellID->4940],
Cell[4258, 155, 373, 12, 36, "Output",
 CellID->20851]
}, Open  ]],
Cell[4646, 170, 136, 4, 70, "MathCaption",
 CellID->18662],
Cell[CellGroupData[{
Cell[4807, 178, 121, 4, 70, "Input",
 CellID->13829],
Cell[4931, 184, 897, 27, 54, "Output",
 CellID->30900]
}, Open  ]],
Cell[5843, 214, 87, 1, 70, "MathCaption",
 CellID->17713],
Cell[CellGroupData[{
Cell[5955, 219, 99, 3, 70, "Input",
 CellID->18958],
Cell[6057, 224, 156, 5, 36, "Output",
 CellID->17578]
}, Open  ]],
Cell[6228, 232, 1277, 41, 70, "DefinitionBox",
 CellID->8365],
Cell[7508, 275, 69, 1, 70, "Caption",
 CellID->13007],
Cell[CellGroupData[{
Cell[7602, 280, 72, 1, 70, "RelatedTutorialsSection",
 CellID->686338117],
Cell[7677, 283, 175, 4, 70, "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],
Cell[7879, 291, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

