(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32685,       1209]
NotebookOptionsPosition[     24621,        936]
NotebookOutlinePosition[     27466,       1010]
CellTagsIndexPosition[     27373,       1004]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TextualInputAndOutputOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Textual Input and Output\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InputForm" :> Documentation`HelpLookup["paclet:ref/InputForm"],
           "OutputForm" :> Documentation`HelpLookup["paclet:ref/OutputForm"], 
          "StandardForm" :> 
          Documentation`HelpLookup["paclet:ref/StandardForm"], "SyntaxLength" :> 
          Documentation`HelpLookup["paclet:ref/SyntaxLength"], "SyntaxQ" :> 
          Documentation`HelpLookup["paclet:ref/SyntaxQ"], "ToBoxes" :> 
          Documentation`HelpLookup["paclet:ref/ToBoxes"], "ToExpression" :> 
          Documentation`HelpLookup["paclet:ref/ToExpression"], "ToString" :> 
          Documentation`HelpLookup["paclet:ref/ToString"], "TraditionalForm" :> 
          Documentation`HelpLookup["paclet:ref/TraditionalForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InputForm\"\>", 
       2->"\<\"OutputForm\"\>", 3->"\<\"StandardForm\"\>", 
       4->"\<\"SyntaxLength\"\>", 5->"\<\"SyntaxQ\"\>", 6->"\<\"ToBoxes\"\>", 
       7->"\<\"ToExpression\"\>", 8->"\<\"ToString\"\>", 
       9->"\<\"TraditionalForm\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Converting between Strings, Boxes and Expressions", "Title",
 CellTags->{"S2.9.13", "13.1"},
 CellID->6072],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ToString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToString"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "create a string representing the specified textual form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ToBoxes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToBoxes"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "create boxes representing the specified textual form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ToExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToExpression"], "[", 
     StyleBox["input", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell["\<\
create an expression by interpreting a string or boxes as input in the \
specified textual form\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ToString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToString"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "create a string using ",
     Cell[BoxData[
      ButtonBox["OutputForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ToBoxes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToBoxes"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "create boxes using ",
     Cell[BoxData[
      ButtonBox["StandardForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ToExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToExpression"], "[", 
     StyleBox["input", "TI"], "]"}], Cell[TextData[{
     "create an expression using ",
     Cell[BoxData[
      ButtonBox["StandardForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, True, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29350],

Cell["Converting between strings, boxes and expressions. ", "Caption",
 CellID->18823],

Cell["Here is a simple expression. ", "MathCaption",
 CellID->14485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "^", "2"}], "+", 
  RowBox[{"y", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20556],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["y", "2"]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120784683]
}, Open  ]],

Cell[TextData[{
 "This gives the ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " of the expression as a string. "
}], "MathCaption",
 CellID->1626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", "InputForm"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9357],

Cell[BoxData["\<\"x^2 + y^2\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->349082188]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " explicit quotes are shown around the string. "
}], "MathCaption",
 CellID->13357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29337],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<x^2 + y^2\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm=",
 CellID->107144726]
}, Open  ]],

Cell[TextData[{
 "This gives a string representation for the ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " boxes that correspond to the expression. "
}], "MathCaption",
 CellID->23869],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToString", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], ",", "StandardForm"}], "]"}], "//", 
  "FullForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->29361],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<\\!\\(x\\^2 + y\\^2\\)\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//FullForm=",
 CellID->177628355]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToBoxes"]], "InlineFormula"],
 " yields the boxes themselves. "
}], "MathCaption",
 CellID->13022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", "StandardForm"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->29617],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"SuperscriptBox", "[", 
     RowBox[{"\<\"x\"\>", ",", "\<\"2\"\>"}], "]"}], ",", "\<\"+\"\>", ",", 
    RowBox[{"SuperscriptBox", "[", 
     RowBox[{"\<\"y\"\>", ",", "\<\"2\"\>"}], "]"}]}], "}"}], "]"}]], "Output",\

 ImageSize->{378, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->57633513]
}, Open  ]],

Cell[TextData[{
 "In generating data for files and external programs, it is sometimes \
necessary to produce two\[Hyphen]dimensional forms which use only ordinary \
keyboard characters. You can do this using ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->12717],

Cell["\<\
This produces a string which gives a two\[Hyphen]dimensional rendering of the \
expression, using only ordinary keyboard characters. \
\>", "MathCaption",
 CellID->18696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", "OutputForm"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->11585],

Cell[BoxData["\<\" 2    2\\nx  + y\"\>"], "Output",
 ImageSize->{53, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->39269263]
}, Open  ]],

Cell[TextData[{
 "The string consists of two lines, separated by an explicit ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", "n"}]], "InlineFormula"],
 " newline. "
}], "MathCaption",
 CellID->24423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->24129],

Cell[BoxData[
 TagBox[
  StyleBox["\"\< 2    2\\nx  + y\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//FullForm=",
 CellID->41741699]
}, Open  ]],

Cell["The string looks right only in a monospaced font. ", "MathCaption",
 CellID->4565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"%", ",", 
   RowBox[{"FontFamily", "->", "\"\<Times\>\""}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->6559],

Cell[BoxData[
 StyleBox[
  StyleBox["\<\" 2    2\\nx  + y\"\>",
   StripOnInput->False,
   FontFamily->"Times"],
  StripOnInput->False,
  FontFamily->"Times"]], "Output",
 ImageSize->{33, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->417860739]
}, Open  ]],

Cell[TextData[{
 "If you operate only with one\[Hyphen]dimensional structures, you can \
effectively use ",
 Cell[BoxData[
  ButtonBox["ToString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToString"]], "InlineFormula"],
 " to do string manipulation with formatting functions. "
}], "Text",
 CellID->22296],

Cell[TextData[{
 "This generates a string corresponding to the ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  ButtonBox["StringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->29855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToString", "[", 
   RowBox[{"StringForm", "[", 
    RowBox[{"\"\<``^10 = ``\>\"", ",", "4", ",", 
     RowBox[{"4", "^", "10"}]}], "]"}], "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->12053],

Cell["\"4^10 = 1048576\"", "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]//InputForm= ",
 CellID->16962]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["InputForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/InputForm"], Cell[
    "strings corresponding to keyboard input", "TableText"]},
   {
    ButtonBox["StandardForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StandardForm"], Cell["\<\
strings or boxes corresponding to standard two\[Hyphen]dimensional input \
(default)\
\>", "TableText"]},
   {
    ButtonBox["TraditionalForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TraditionalForm"], Cell[
    "strings or boxes mimicking traditional mathematical notation", 
     "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3584],

Cell[TextData[{
 "Some forms handled by ",
 StyleBox["ToExpression", "MR"],
 ". "
}], "Caption",
 CellID->29734],

Cell[TextData[{
 "This creates an expression from an ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " string. "
}], "MathCaption",
 CellID->6654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", "\"\<x^2 + y^2\>\"", "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->16972],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["y", "2"]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->21457]
}, Open  ]],

Cell[TextData[{
 "This creates the same expression from ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " boxes. "
}], "MathCaption",
 CellID->14369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{"RowBox", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SuperscriptBox", "[", 
      RowBox[{"\"\<x\>\"", ",", "\"\<2\>\""}], "]"}], ",", "\"\<+\>\"", ",", 
     RowBox[{"SuperscriptBox", "[", 
      RowBox[{"\"\<y\>\"", ",", "\"\<2\>\""}], "]"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->22532],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["y", "2"]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->2963]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " these are interpreted as functions. "
}], "MathCaption",
 CellID->22142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{"\"\<c(1 + x) + log(x)\>\"", ",", "TraditionalForm"}], 
  "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->23754],

Cell[BoxData[
 RowBox[{
  RowBox[{"c", "[", 
   RowBox[{"1", "+", "x"}], "]"}], "+", 
  RowBox[{"Log", "[", "x", "]"}]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->6511]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ToExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToExpression"], "[", 
     StyleBox["input", "TI"], ",", 
     StyleBox["form", "TI"], ",", 
     StyleBox["h", "TI"], "]"}], Cell[TextData[{
     "create an expression, then wrap it with head ",
     Cell[BoxData[
      FormBox["h", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22741],

Cell["Creating expressions wrapped with special heads. ", "Caption",
 CellID->20175],

Cell["This creates an expression, then immediately evaluates it. ", \
"MathCaption",
 CellID->21459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", "\"\<1 + 1\>\"", "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->17825],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->3221]
}, Open  ]],

Cell[TextData[{
 "This creates an expression using ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " rules, then wraps it in ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{"\"\<1 + 1\>\"", ",", "StandardForm", ",", "Hold"}], "]"}]], "Input",\

 CellLabel->"In[17]:= ",
 CellID->31934],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"1", "+", "1"}], "]"}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->15205]
}, Open  ]],

Cell[TextData[{
 "You can get rid of the ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  ButtonBox["ReleaseHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReleaseHold"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReleaseHold", "[", "%", "]"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->23850],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->17398]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SyntaxQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SyntaxQ"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "determine whether a string represents syntactically correct ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " input"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SyntaxLength",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SyntaxLength"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}], Cell["\<\
find out how long a sequence of characters starting at the beginning of a \
string is syntactically correct\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22279],

Cell["Testing correctness of strings as input. ", "Caption",
 CellID->22701],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " will attempt to interpret any string as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. But if you give it a string that does not correspond to \
syntactically correct input, then it will print a message, and return ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->12193],

Cell[TextData[{
 "This is not syntactically correct input, so ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " does not convert it to an expression. "
}], "MathCaption",
 CellID->12734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", "\"\<1 +/+ 2\>\"", "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->1637],

Cell["\<\
ToExpression::sntx: Syntax error in or before \"1 +/+ 2\".                    \
                                ^\
\>", "Message", "MSG",
 CellID->26534],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->5556]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " requires that the string correspond to a ",
 StyleBox["complete",
  FontSlant->"Italic"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. "
}], "MathCaption",
 CellID->1993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", "\"\<1 + 2 + \>\"", "]"}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->10176],

Cell["\<\
ToExpression::sntxi:     Incomplete expression; more input is needed. \
\>", "Message", "MSG",
 CellID->25705],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->6962]
}, Open  ]],

Cell[TextData[{
 "You can use the function ",
 Cell[BoxData[
  ButtonBox["SyntaxQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxQ"]], "InlineFormula"],
 " to test whether a particular string corresponds to syntactically correct \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. If ",
 Cell[BoxData[
  ButtonBox["SyntaxQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxQ"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", you can find out where the error occurred using ",
 Cell[BoxData[
  ButtonBox["SyntaxLength",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxLength"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["SyntaxLength",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxLength"]], "InlineFormula"],
 " returns the number of characters which were successfully processed before \
a syntax error was detected. "
}], "Text",
 CellID->10548],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SyntaxQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxQ"]], "InlineFormula"],
 " shows that this string does not correspond to syntactically correct ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. "
}], "MathCaption",
 CellID->15881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SyntaxQ", "[", "\"\<1 +/+ 2\>\"", "]"}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->300],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]= ",
 CellID->14413]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SyntaxLength",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxLength"]], "InlineFormula"],
 " reveals that an error was detected after the third character in the \
string. "
}], "MathCaption",
 CellID->16641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SyntaxLength", "[", "\"\<1 +/+ 2\>\"", "]"}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->19855],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->24855]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["SyntaxLength",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxLength"]], "InlineFormula"],
 " returns a value greater than the length of the string, indicating that the \
input was correct so far as it went, but needs to be continued."
}], "MathCaption",
 CellID->13142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SyntaxLength", "[", "\"\<1 + 2 + \>\"", "]"}]], "Input",
 CellLabel->"In[23]:= ",
 CellID->11462],

Cell[BoxData["10"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]= ",
 CellID->27611]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->273486087],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Converting between Strings, Boxes and Expressions - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/RepresentingTextualFormsByBoxes"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheSyntaxOfTheMathematicaLanguage"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 44.2026228}", "context" -> "", 
    "keywords" -> {
     "boxes", "conversion", "error", "expression", "expressions", "grammar", 
      "held expressions", "interpretation of input", "OutputForm", "parsing", 
      "StringForm", "strings", "syntax checking", "SyntaxLength", "SyntaxQ", 
      "ToBoxes", "ToExpression", "ToString"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Converting between strings, boxes and expressions. Here is a simple \
expression. This gives the InputForm of the expression as a string. ", 
    "synonyms" -> {"2.9.13"}, "title" -> 
    "Converting between Strings, Boxes and Expressions", "type" -> "Tutorial",
     "uri" -> "tutorial/ConvertingBetweenStringsBoxesAndExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.13"->{
  Cell[2686, 70, 113, 2, 70, "Title",
   CellTags->{"S2.9.13", "13.1"},
   CellID->6072]},
 "13.1"->{
  Cell[2686, 70, 113, 2, 70, "Title",
   CellTags->{"S2.9.13", "13.1"},
   CellID->6072]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.13", 27157, 993},
 {"13.1", 27259, 997}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2061, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2686, 70, 113, 2, 70, "Title",
 CellTags->{"S2.9.13", "13.1"},
 CellID->6072],
Cell[2802, 74, 2529, 78, 70, "DefinitionBox",
 CellID->29350],
Cell[5334, 154, 86, 1, 70, "Caption",
 CellID->18823],
Cell[5423, 157, 68, 1, 70, "MathCaption",
 CellID->14485],
Cell[CellGroupData[{
Cell[5516, 162, 134, 5, 28, "Input",
 CellID->20556],
Cell[5653, 169, 228, 8, 36, "Output",
 CellID->120784683]
}, Open  ]],
Cell[5896, 180, 226, 8, 70, "MathCaption",
 CellID->1626],
Cell[CellGroupData[{
Cell[6147, 192, 204, 7, 28, "Input",
 CellID->9357],
Cell[6354, 201, 174, 5, 36, "Output",
 CellID->349082188]
}, Open  ]],
Cell[6543, 209, 227, 8, 70, "MathCaption",
 CellID->13357],
Cell[CellGroupData[{
Cell[6795, 221, 100, 3, 28, "Input",
 CellID->29337],
Cell[6898, 226, 305, 11, 50, "Output",
 CellID->107144726]
}, Open  ]],
Cell[7218, 240, 271, 8, 70, "MathCaption",
 CellID->23869],
Cell[CellGroupData[{
Cell[7514, 252, 246, 9, 70, "Input",
 CellID->29361],
Cell[7763, 263, 319, 11, 50, "Output",
 CellID->177628355]
}, Open  ]],
Cell[8097, 277, 201, 7, 70, "MathCaption",
 CellID->13022],
Cell[CellGroupData[{
Cell[8323, 288, 207, 7, 70, "Input",
 CellID->29617],
Cell[8533, 297, 427, 13, 36, "Output",
 CellID->57633513]
}, Open  ]],
Cell[8975, 313, 367, 10, 70, "Text",
 CellID->12717],
Cell[9345, 325, 180, 4, 70, "MathCaption",
 CellID->18696],
Cell[CellGroupData[{
Cell[9550, 333, 206, 7, 70, "Input",
 CellID->11585],
Cell[9759, 342, 180, 5, 54, "Output",
 CellID->39269263]
}, Open  ]],
Cell[9954, 350, 195, 6, 70, "MathCaption",
 CellID->24423],
Cell[CellGroupData[{
Cell[10174, 360, 100, 3, 70, "Input",
 CellID->24129],
Cell[10277, 365, 312, 11, 50, "Output",
 CellID->41741699]
}, Open  ]],
Cell[10604, 379, 88, 1, 70, "MathCaption",
 CellID->4565],
Cell[CellGroupData[{
Cell[10717, 384, 165, 5, 70, "Input",
 CellID->6559],
Cell[10885, 391, 300, 11, 54, "Output",
 CellID->417860739]
}, Open  ]],
Cell[11200, 405, 312, 9, 70, "Text",
 CellID->22296],
Cell[11515, 416, 361, 13, 70, "MathCaption",
 CellID->29855],
Cell[CellGroupData[{
Cell[11901, 433, 250, 7, 70, "Input",
 CellID->12053],
Cell[12154, 442, 175, 5, 50, "Output",
 CellID->16962]
}, Open  ]],
Cell[12344, 450, 946, 27, 70, "DefinitionBox",
 CellID->3584],
Cell[13293, 479, 112, 5, 70, "Caption",
 CellID->29734],
Cell[13408, 486, 223, 8, 70, "MathCaption",
 CellID->6654],
Cell[CellGroupData[{
Cell[13656, 498, 122, 3, 70, "Input",
 CellID->16972],
Cell[13781, 503, 226, 8, 36, "Output",
 CellID->21457]
}, Open  ]],
Cell[14022, 514, 232, 8, 70, "MathCaption",
 CellID->14369],
Cell[CellGroupData[{
Cell[14279, 526, 383, 11, 70, "Input",
 CellID->22532],
Cell[14665, 539, 225, 8, 36, "Output",
 CellID->2963]
}, Open  ]],
Cell[14905, 550, 232, 8, 70, "MathCaption",
 CellID->22142],
Cell[CellGroupData[{
Cell[15162, 562, 170, 5, 70, "Input",
 CellID->23754],
Cell[15335, 569, 260, 9, 36, "Output",
 CellID->6511]
}, Open  ]],
Cell[15610, 581, 734, 21, 70, "DefinitionBox",
 CellID->22741],
Cell[16347, 604, 84, 1, 70, "Caption",
 CellID->20175],
Cell[16434, 607, 100, 2, 70, "MathCaption",
 CellID->21459],
Cell[CellGroupData[{
Cell[16559, 613, 118, 3, 70, "Input",
 CellID->17825],
Cell[16680, 618, 155, 5, 36, "Output",
 CellID->3221]
}, Open  ]],
Cell[16850, 626, 362, 13, 70, "MathCaption",
 CellID->17870],
Cell[CellGroupData[{
Cell[17237, 643, 167, 5, 70, "Input",
 CellID->31934],
Cell[17407, 650, 209, 7, 36, "Output",
 CellID->15205]
}, Open  ]],
Cell[17631, 660, 332, 13, 70, "MathCaption",
 CellID->31783],
Cell[CellGroupData[{
Cell[17988, 677, 105, 3, 70, "Input",
 CellID->23850],
Cell[18096, 682, 156, 5, 36, "Output",
 CellID->17398]
}, Open  ]],
Cell[18267, 690, 1005, 29, 70, "DefinitionBox",
 CellID->22279],
Cell[19275, 721, 76, 1, 70, "Caption",
 CellID->22701],
Cell[19354, 724, 529, 16, 70, "Text",
 CellID->12193],
Cell[19886, 742, 269, 8, 70, "MathCaption",
 CellID->12734],
Cell[CellGroupData[{
Cell[20180, 754, 119, 3, 70, "Input",
 CellID->1637],
Cell[20302, 759, 163, 4, 70, "Message",
 CellID->26534],
Cell[20468, 765, 161, 5, 36, "Output",
 CellID->5556]
}, Open  ]],
Cell[20644, 773, 341, 13, 70, "MathCaption",
 CellID->1993],
Cell[CellGroupData[{
Cell[21010, 790, 121, 3, 70, "Input",
 CellID->10176],
Cell[21134, 795, 120, 3, 70, "Message",
 CellID->25705],
Cell[21257, 800, 161, 5, 36, "Output",
 CellID->6962]
}, Open  ]],
Cell[21433, 808, 1006, 33, 70, "Text",
 CellID->10548],
Cell[22442, 843, 302, 10, 70, "MathCaption",
 CellID->15881],
Cell[CellGroupData[{
Cell[22769, 857, 113, 3, 70, "Input",
 CellID->300],
Cell[22885, 862, 160, 5, 36, "Output",
 CellID->14413]
}, Open  ]],
Cell[23060, 870, 260, 8, 70, "MathCaption",
 CellID->16641],
Cell[CellGroupData[{
Cell[23345, 882, 120, 3, 70, "Input",
 CellID->19855],
Cell[23468, 887, 156, 5, 36, "Output",
 CellID->24855]
}, Open  ]],
Cell[23639, 895, 332, 9, 70, "MathCaption",
 CellID->13142],
Cell[CellGroupData[{
Cell[23996, 908, 121, 3, 70, "Input",
 CellID->11462],
Cell[24120, 913, 157, 5, 36, "Output",
 CellID->27611]
}, Open  ]],
Cell[CellGroupData[{
Cell[24314, 923, 72, 1, 70, "RelatedTutorialsSection",
 CellID->273486087],
Cell[24389, 926, 178, 4, 70, "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],
Cell[24594, 934, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

