(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    291945,       5627]
NotebookOptionsPosition[    282186,       5331]
NotebookOutlinePosition[    286295,       5422]
CellTagsIndexPosition[    286197,       5416]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"The Structure of Graphics and Sound\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automatic" :> Documentation`HelpLookup["paclet:ref/Automatic"],
           "BoxRatios" :> Documentation`HelpLookup["paclet:ref/BoxRatios"], 
          "False" :> Documentation`HelpLookup["paclet:ref/False"], 
          "Graphics3D" :> Documentation`HelpLookup["paclet:ref/Graphics3D"], 
          "Scaled" :> Documentation`HelpLookup["paclet:ref/Scaled"], 
          "SphericalRegion" :> 
          Documentation`HelpLookup["paclet:ref/SphericalRegion"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"], "ViewCenter" :> 
          Documentation`HelpLookup["paclet:ref/ViewCenter"], "ViewPoint" :> 
          Documentation`HelpLookup["paclet:ref/ViewPoint"], "ViewVector" :> 
          Documentation`HelpLookup["paclet:ref/ViewVector"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Automatic\"\>", 
       2->"\<\"BoxRatios\"\>", 3->"\<\"False\"\>", 4->"\<\"Graphics3D\"\>", 
       5->"\<\"Scaled\"\>", 6->"\<\"SphericalRegion\"\>", 7->"\<\"True\"\>", 
       8->"\<\"ViewCenter\"\>", 9->"\<\"ViewPoint\"\>", 
       10->"\<\"ViewVector\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\<\
Coordinate Systems for Three\[Hyphen]Dimensional Graphics\
\>", "Title",
 CellTags->{"S2.10.10", "10.1"},
 CellID->9601],

Cell[TextData[{
 "Whenever ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " draws a three\[Hyphen]dimensional object, it always effectively puts a \
cuboidal box around the object. With the default option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Boxed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Boxed"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in fact draws the edges of this box explicitly. But in general, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically \[OpenCurlyDoubleQuote]clips\[CloseCurlyDoubleQuote] any \
parts of your object that extend outside of the cuboidal box. "
}], "Text",
 CellID->28323],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " specifies the range of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " coordinates that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " should include in the box. As in two dimensions the default setting is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", which makes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " use an internal algorithm to try and include the \
\[OpenCurlyDoubleQuote]interesting parts\[CloseCurlyDoubleQuote] of a plot, \
but drop outlying parts. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will include all parts. "
}], "Text",
 CellID->21132],

Cell["This loads a package defining polyhedron operations. ", "MathCaption",
 CellID->24472],

Cell[BoxData[
 RowBox[{"<<", "PolyhedronOperations`"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->27152],

Cell["This creates a stellated icosahedron.", "MathCaption",
 CellID->21367079],

Cell[BoxData[
 RowBox[{
  RowBox[{"stel", "=", 
   RowBox[{"Stellate", "[", 
    RowBox[{"PolyhedronData", "[", 
     RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<Faces\>\""}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->67827138],

Cell["This shows the stellated icosahedron, drawn in a box. ", "MathCaption",
 CellID->29763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"stel", ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->29901],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 188},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->155975824]
}, Open  ]],

Cell[TextData[{
 "With this setting for ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ", many parts of the stellated icosahedron lie outside the box, and are \
clipped. "
}], "MathCaption",
 CellID->14423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->3527],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->300547872]
}, Open  ]],

Cell[TextData[{
 "Much as in two dimensions, you can use either \
\[OpenCurlyDoubleQuote]original\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]scaled\[CloseCurlyDoubleQuote] coordinates to specify \
the positions of elements in three\[Hyphen]dimensional objects. Scaled \
coordinates, specified as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["sx", "TI"], ",", 
     StyleBox["sy", "TI"], ",", 
     StyleBox["sz", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " are taken to run from 0 to 1 in each dimension. The coordinates are set up \
to define a right\[Hyphen]handed coordinate system on the box. "
}], "Text",
 CellID->26969],

Cell[BoxData[GridBox[{
   {
    RowBox[{"{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"], "}"}], Cell["original coordinates", "TableText"]},
   {
    RowBox[{
     ButtonBox["Scaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scaled"], "[", "{", 
     StyleBox["sx", "TI"], ",", 
     StyleBox["sy", "TI"], ",", 
     StyleBox["sz", "TI"], "}", "]"}], Cell[
    "scaled coordinates, running from 0 to 1 in each dimension", 
     "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14015],

Cell["\<\
Coordinate systems for three\[Hyphen]dimensional objects. \
\>", "Caption",
 CellID->5565],

Cell["This puts a cuboid in one corner of the box. ", "MathCaption",
 CellID->28],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"stel", ",", 
    RowBox[{"Cuboid", "[", 
     RowBox[{
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"0.2", ",", "0.2", ",", "0.2"}], "}"}], "]"}]}], "]"}]}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->21543],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->291409727]
}, Open  ]],

Cell[TextData[{
 "Once you have specified where various graphical elements go inside a three\
\[Hyphen]dimensional box, you must then tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " how to draw the box. The first step is to specify what shape the box \
should be. This is analogous to specifying the aspect ratio of a \
two\[Hyphen]dimensional plot. In three dimensions, you can use the option ",
 Cell[BoxData[
  ButtonBox["BoxRatios",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoxRatios"]], "InlineFormula"],
 " to specify the ratio of side lengths for the box. For ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " objects, the default is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BoxRatios",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BoxRatios"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", specifying that the shape of the box should be determined from the ranges \
of actual coordinates for its contents. "
}], "Text",
 CellID->2088],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["BoxRatios",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BoxRatios"], "->", "{", 
     StyleBox["xr", "TI"], ",", 
     StyleBox["yr", "TI"], ",", 
     StyleBox["zr", "TI"], "}"}], Cell[
    "specify the ratio of side lengths for the box", "TableText"]},
   {
    RowBox[{
     ButtonBox["BoxRatios",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BoxRatios"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}], Cell[TextData[{
     "determine the ratio of side lengths from the range of actual \
coordinates (default for ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     ")"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2943],

Cell["\<\
Specifying the shape of the bounding box for three\[Hyphen]dimensional \
objects. \
\>", "Caption",
 CellID->12637],

Cell["This displays the stellated icosahedron in a tall box. ", "MathCaption",
 CellID->22409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"stel", ",", 
   RowBox[{"BoxRatios", "->", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "5"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->26463],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{67, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->200532319]
}, Open  ]],

Cell[TextData[{
 "To produce an image of a three\[Hyphen]dimensional object, you have to tell \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from what view point you want to look at the object. You can do this using \
the option ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->4681],

Cell[TextData[{
 "Some common settings for this option were given in\[NonBreakingSpace]\"",
 ButtonBox["Three-Dimensional Surface Plots\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ThreeDimensionalSurfacePlots"],
 ". In general, however, you can tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to use any view point. "
}], "Text",
 CellID->1588],

Cell[TextData[{
 "View points are specified in the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ViewPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewPoint"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["sx", "TI"], ",", 
     StyleBox["sy", "TI"], ",", 
     StyleBox["sz", "TI"]}], "}"}]}]], "InlineFormula"],
 ". The values ",
 Cell[BoxData[
  StyleBox["si", "TI"]], "InlineFormula"],
 " are given in a special coordinate system, in which the center of the box \
is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "InlineFormula"],
 ". The special coordinates are scaled so that the longest side of the box \
corresponds to one unit. The lengths of the other sides of the box in this \
coordinate system are determined by the setting for the ",
 Cell[BoxData[
  ButtonBox["BoxRatios",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BoxRatios"]], "InlineFormula"],
 " option. For a cubical box, therefore, each of the special coordinates runs \
from ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "1"}], "/", "2"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "2"}], TraditionalForm]], "InlineMath"],
 " across the box. Note that the view point must always lie outside the box. \
"
}], "Text",
 CellID->11342],

Cell[TextData[{
 "This generates a picture using the default view point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1.3", ",", 
    RowBox[{"-", "2.4"}], ",", "2"}], "}"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"surf", "=", 
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"Sin", "[", "x", "]"}]}], ")"}], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "y"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
    RowBox[{"AxesLabel", "->", 
     RowBox[{"{", 
      RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32060],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->360959365]
}, Open  ]],

Cell["\<\
This is what you get with a view point close to one of the corners of the \
box. \
\>", "MathCaption",
 CellID->1758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"surf", ",", 
   RowBox[{"ViewPoint", "->", 
    RowBox[{"{", 
     RowBox[{"1.2", ",", "1.2", ",", "1.2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->29954],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->197816202]
}, Open  ]],

Cell["\<\
As you move away from the box, the perspective effect gets smaller. \
\>", "MathCaption",
 CellID->14146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"surf", ",", 
   RowBox[{"ViewPoint", "->", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5", ",", "5"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->690],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->79380596]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["ViewPoint",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewPoint"], 
    RowBox[{"{", "1.3", ",", "-", "2.4", ",", "2", "}"}], Cell["\<\
the point in a special scaled coordinate system from which to view the object\
\
\>", "TableText"]},
   {
    ButtonBox["ViewCenter",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewCenter"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
the point in the scaled coordinate system which appears at the center of the \
final image\
\>", "TableText"]},
   {
    ButtonBox["ViewVertical",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewVertical"], 
    RowBox[{"{", "0", ",", "0", ",", "1", "}"}], Cell["\<\
the direction in the scaled coordinate system which appears as vertical in \
the final image\
\>", "TableText"]},
   {
    ButtonBox["ViewAngle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewAngle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
the opening half-angle for a simulated camera used to view the graphic\
\>", "TableText"]},
   {
    ButtonBox["ViewVector",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewVector"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
the position and direction of the simulated camera in the graphic's regular \
coordinate system\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->12843],

Cell["\<\
Specifying the position and orientation of three\[Hyphen]dimensional objects. \
\
\>", "Caption",
 CellID->21430],

Cell[TextData[{
 "In making a picture of a three\[Hyphen]dimensional object you have to \
specify more than just ",
 StyleBox["where",
  FontSlant->"Italic"],
 " you want to look at the object from. You also have to specify how you want \
to \"frame\" the object in your final image. You can do this using the \
additional options ",
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ViewVertical",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVertical"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ViewAngle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewAngle"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->25620],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 " allows you to tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " what point in the object should appear at the center of your final image. \
The point is specified by giving its scaled coordinates, running from 0 to 1 \
in each direction across the box. With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ViewCenter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewCenter"], "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}]}], "}"}]}]], "InlineFormula"],
 ", the center of the box will therefore appear at the center of your final \
image. With many choices of view point, however, the box will not appear \
symmetrical, so this setting for ",
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 " will not center the whole box in the final image area. You can do this by \
setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ViewCenter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewCenter"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->748],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ViewVertical",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVertical"]], "InlineFormula"],
 " specifies which way up the object should appear in your final image. The \
setting for ",
 Cell[BoxData[
  ButtonBox["ViewVertical",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVertical"]], "InlineFormula"],
 " gives the direction in scaled coordinates which ends up vertical in the \
final image. With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ViewVertical",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewVertical"], "->", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " direction in your original coordinate system always ends up vertical in \
the final image. "
}], "Text",
 CellID->27067],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the properties of a simulated camera to visualize the final image. \
The position, orientation, and facing of the camera are determined by the ",
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ViewVertical",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVertical"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 " options. The ",
 Cell[BoxData[
  ButtonBox["ViewAngle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewAngle"]], "InlineFormula"],
 " option specifies the width of the opening of the camera lens. The ",
 Cell[BoxData[
  ButtonBox["ViewAngle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewAngle"]], "InlineFormula"],
 " specifies, in radians, the maximum angle from the line stretching from the \
",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 " to the ",
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 " which can be viewed by the camera. The effective viewing angle is double \
the value of ",
 Cell[BoxData[
  ButtonBox["ViewAngle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewAngle"]], "InlineFormula"],
 ". This means that ViewAngle can effectively be used to zoom in on a part of \
the image. The default value of ",
 Cell[BoxData[
  ButtonBox["ViewAngle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewAngle"]], "InlineFormula"],
 " resolves to 35\[Degree], which is the typical viewing angle for the human \
eye."
}], "Text",
 CellID->559976476],

Cell[TextData[{
 "This setting for ",
 Cell[BoxData[
  ButtonBox["ViewVertical",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVertical"]], "InlineFormula"],
 " makes the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis of the box appear vertical in your image. "
}], "MathCaption",
 CellID->32226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"surf", ",", 
   RowBox[{"ViewVertical", "->", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->15185],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{158, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->131773537]
}, Open  ]],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["ViewAngle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewAngle"]], "InlineFormula"],
 " to effectively zoom in on the center of the image."
}], "MathCaption",
 CellID->124559076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"surf", ",", 
   RowBox[{"ViewAngle", "\[Rule]", 
    RowBox[{"10", "Degree"}]}]}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->222593067],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->814937398]
}, Open  ]],

Cell[TextData[{
 "When you set the options ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ViewVertical",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVertical"]], "InlineFormula"],
 ", you can think about it as specifying how you would look at a physical \
object. ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 " specifies where your head is relative to the object. ",
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 " specifies where you are looking (the center of your gaze). And ",
 Cell[BoxData[
  ButtonBox["ViewVertical",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVertical"]], "InlineFormula"],
 " specifies which way up your head is. "
}], "Text",
 CellID->9853],

Cell[TextData[{
 "In terms of coordinate systems, settings for ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ViewVertical",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVertical"]], "InlineFormula"],
 " specify how coordinates in the three\[Hyphen]dimensional box should be \
transformed into coordinates for your image in the final display area. "
}], "Text",
 CellID->25629],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ViewVector",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ViewVector"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}], Cell[TextData[{
     "uses the values of the ",
     Cell[BoxData[
      ButtonBox["ViewPoint",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["ViewCenter",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
     " options to determine the position and facing of the simulated camera"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ViewVector",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ViewVector"], "->", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], ",", 
       StyleBox["z", "TI"]}], "}"}]}], Cell[TextData[{
     "position of the camera in the coordinates used for objects; the facing \
of the camera is determined by the ",
     Cell[BoxData[
      ButtonBox["ViewCenter",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
     " option"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ViewVector",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ViewVector"], "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         StyleBox["y", "TI"], ",", 
         StyleBox["z", "TI"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["tx", "TI"], ",", 
         StyleBox["ty", "TI"], ",", 
         StyleBox["tz", "TI"]}], "}"}]}], "}"}]}], Cell["\<\
position of the camera and of the point the camera is focused on in the \
coordinates used for objects\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->330853370],

Cell[TextData[{
 "Possible values of the ",
 Cell[BoxData[
  ButtonBox["ViewVector",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVector"]], "InlineFormula"],
 " option. "
}], "Caption",
 CellID->289417968],

Cell[TextData[{
 "The position and facing of the camera can be fully determined by the ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 " options, but the ",
 Cell[BoxData[
  ButtonBox["ViewVector",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVector"]], "InlineFormula"],
 " option offers a useful generalization. Instead of specifying the position \
and facing of the camera using scaled coordinates, ",
 Cell[BoxData[
  ButtonBox["ViewVector",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVector"]], "InlineFormula"],
 " provides the ability to position the camera using the same coordinate \
system used to position objects within the graphic."
}], "Text",
 CellID->431806326],

Cell["\<\
This specifies that the camera should be placed on the negative x axis and \
facing toward the center of the graphic. \
\>", "MathCaption",
 CellID->2620803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"surf", ",", 
   RowBox[{"ViewVector", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "5"}], ",", "0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->277296951],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->393288738]
}, Open  ]],

Cell[TextData[{
 "The camera is in the same position but pointing in a different direction. \
In combination with ",
 Cell[BoxData[
  ButtonBox["ViewAngle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewAngle"]], "InlineFormula"],
 ", this zooms in on a particular section of the graphic."
}], "MathCaption",
 CellID->115051531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"surf", ",", 
   RowBox[{"ViewVector", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5"}], ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "3"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ViewAngle", "\[Rule]", 
    RowBox[{"20", " ", "Degree"}]}]}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->344727871],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->186846937]
}, Open  ]],

Cell[TextData[{
 "Once you have obtained a two\[Hyphen]dimensional image of a \
three\[Hyphen]dimensional object, there are still some issues about how this \
image should be rendered. The issues however are identical to those that \
occur for two\[Hyphen]dimensional graphics. Thus, for example, you can modify \
the final shape of your image by changing the ",
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 " option. And you specify what region of your whole display area your image \
should take up by setting the ",
 Cell[BoxData[
  ButtonBox["PlotRegion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRegion"]], "InlineFormula"],
 " option. "
}], "Text",
 CellID->3359],

Cell[BoxData[GridBox[{
   {Cell[TextData[StyleBox["drag", "KeyEvent"]], "TableText"], Cell[
    "rotate the graphic about its center", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["drag", "KeyEvent"],
     " "
    }], "TableText"], Cell["zoom into or out of the graphic", "TableText"]},
   {Cell[TextData[{
     StyleBox["Shift", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["drag", "KeyEvent"]
    }], "TableText"], Cell[
    "pan across the graphic in the plane of the screen", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16828],

Cell["\<\
Mouse gestures used for interacting with three-dimensional graphics.\
\>", "Caption",
 CellID->13914],

Cell[TextData[{
 "When interactively modifying graphics, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " makes changes to the view options. If you have specified the position of \
the camera using ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 ", then rotating the graphic causes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to change the value of the ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 " option. If the position of the camera is specified using ",
 Cell[BoxData[
  ButtonBox["ViewVector",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVector"]], "InlineFormula"],
 ", interactive rotation will instead change the value of that option. In \
both cases, interactive rotation can also affect the value of the ",
 Cell[BoxData[
  ButtonBox["ViewVertical",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVertical"]], "InlineFormula"],
 " option. Interactive zooming of the graphic corresponds directly to \
changing the ",
 Cell[BoxData[
  ButtonBox["ViewAngle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewAngle"]], "InlineFormula"],
 " option. Interactively panning the graphic changes values of the ",
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 " option."
}], "Text",
 CellID->280867684],

Cell["This modifies the aspect ratio of the final image. ", "MathCaption",
 CellID->32257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"surf", ",", 
   RowBox[{"Axes", "->", "False"}], ",", 
   RowBox[{"AspectRatio", "->", "0.3"}]}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->24766],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyFWnlUVNmZf11ViHa3vdjdSfdk6+RkMpPJZJnlJDNzTiYnJzOZv9JpFwRk
ExAEFRFQcWORRaCq3qt936mCYilQFLW1tdvkJJ102y4giyLggqDiirJT35n5
vvteIUFzps7l1nvfu+/e+/2+735b8ZvU7VkZOanbs9NT3/+f/NRtWdnpBe//
OjcfSfKXOI5rx7+fvcvh9f/iFftrBwCOK8R+SUZGxs/Y3Tbso/FOQXdyvMBv
7LmfsqfZ0tNXFjylSxle/isbkSaNWLF4BHY06p/ZqARp1HuLRimkUT9ho9ZI
o769aFTUovsfstG/kUb//aKnS6Q5xVG/lkb9eNGopdKoH7BRv5BG/fQFc3EK
xA4iH3rn++ydf5Pe+XnkHU78yPFP9psfbmDvqf8EEnXRzN9jc/yTNMd/4rci
8h6Nwm82BXZy9rrVBxYXRGaiXYgz/ECSZmQGTk7vITrYRy+YLbIzLtqhmbNp
ZizqaUvljLlsxlQyTeSIJL7LZv3ugn3JF82qiPAm7hFbVGSEtBRxISPaUuuu
SfOOCVPBuDH/qSHviX7bmD53DB9ESat9h632DWm1X0g8LMP36TuKJotauBKh
zDB6FamWbY/MuQ/xwpTzwLj5nmHTqD57VJd1V7vxjjbzNtIjmvA+W+Ur0iq/
lHhiLMnnZ2fz0qqKRfTF92z96GcywvWzRowbh42Zw9wyAniRpL/BVn9dWv1X
tKd5Sf//qy/e5RJp3EKNE/HXJlzRxF/WxPVyMiG2h5PzsT382h4mBgkHcSdL
pZ38t4SDQppx8Uqvzq/0TPa0yyhaOFof36OL69Zii+3WYFvbxYYKMV0yIeaS
jF9zic0lYRAt7eBrbAeRu19LWMillZYt2gHJf4m0Q9oxF2WI79Zji+vSxbL1
aBZuiTbmkiamk9qaTmFNJyHCr+6Q8as6Fu4hggKzQeLJXiAluXSSF2o7W+EF
slqMlFw6Ay+S6VK2b3NSrymx15RA4kAeOJkhrouL0sde0q3txKaN6WRradZ0
MI4UmlUXhVUXsBGVX3kB/87L+Q/PL+Tn5UUcfIXxtdhW0rmWS5btr+3x+dP8
Ig4ZJ68hzZ561ba+z5pyhc5gUq85sQcZM63rNsZ3GeIuIVNI16/tlOliOrgo
7ZqL2tUXNasvaBgzqJsrkQth5bkM9kHufvslWwm/2SV2SDu3mFPC5cUcRksc
/uiv2KqIBkUkSWMYL2/5tgx5N91wZ11zZQ46MwYYa3229VdsKVesyZcjrHUj
HVkzxl0yxHYiX3pkS6Zbc5F7GR9oV1/QrjqvWYntnPAhti+RKBArZ+X8B2eZ
NKPmucMmEI84kpOLgBAHr0r8vc34Uyzi7xWJv+9KElyonSskXpi1XV5XcDeQ
d7t26zAyhvfurOvujcSbY8OAPa2fxMZkxsnMqIivmRO654XGJNaBnCFfOpEl
4uocMfPhl3LatEL47VmB9n+W6STxJ7EiSXIpJ1o5WSQaeI6T1xZYgXeY4fr8
DPzpY/jsGDm23zcBM6uMx2807HpQv/MeXgXy7tTmjvhyhr1bhjybbiJTSHSk
99uxpUmKaEm+bE7sFeVkWCAnXcxFEhSKSWLoPJ6xledkDH+RN2JN1EFSTPFD
GoNncPVF7ZoO3BC+KScsFChs1GlRwd9YxNvrjOPFXv5NSXbL8HsFk93hYTg2
Ah+PIK/s/vNO+PM5+PPnwCwN00v5cTMstOxfa9z7OLj7Yf3O+3U77gUKRv15
d5DqzRn2bB5yZd90brzhyLxm3zBoS+2nE5kswYGH0riu24CIsA2TpSH5duCJ
5GR4JrkleCrxAbKHrKOtQYaXipyv6RCVE/GREUBRCBhSEA7d2kvzdjdau4o0
BRFGtNGgGZl5Y+eT7VvxTE+5+XjwxTiRvrzFXjb1wPw7TTfE4IuTn7oRoYon
/I8ddM82wRDDm1N18LEfRNl9q7V6NlQ53Vw22VQ60VD8NLh3rH73I3xQW3DP
t+2ON/eOZ+ttT86we/MtUqaNN+wZ12zpg9bUfsv6q+bkK6aky6RMCT2GdT3k
cuK69bHocoh1MtVyBIgh9Q56G2H1RVFz+A/Pod1CQ40UdEQadEprOghEpKBl
QBOBChXTiZ4LXRgJBOcTrT2D7xIKC31ExB8uWYCgzQlWmxg1SCgufyGKZCdF
CR44BxVnYf/n4eI/hRlFzndGEGQzy9sG4Ug/Iykierfkk+NEOH0YTrXAyUY4
US/K8ZttOjgohFtV4ZaaueYDs00VM0gNFo/X73tat/dJYNdj/86Hvu33yeTk
3nFtGXFuHnZkD9mzbtoyb1g3XEO6OW3QvL7flNJvTL5qTOozJBK++vhemS6+
h/YnE1Z3cF8TVl3kV9FxxR4duLDmkrC2C6MJYXWnRP/wPF7gWAQX4w7t2i68
IBUmxC+K6onCMqzrNST0Mq1D6YkY44EwJ122rO/jnveBDGaCxaacs1TMmYrC
xt1z3LOYmGU/DPvFnpWd4ShDF2g6QXURqs8j7GFuOUPY0h1BnFlneX03NHZB
5J4hvvTkGTh5mmgnj8OJdjjRBicOwUetwGT0tTZz+JAxfFAXbhFoTHNNuKl6
tvHATLB8qn7/ZF3xpH/vONJ9Ox97tz/0FDxw591z5t51bCHzYNs0bMu6Zd04
ZMm8ad5ww5R+3ZR2jbksPPdxPZrYHmFtN8LLMwDl/OpO7n3EXL2KGlKwxxiO
j+nCWFKI68XB4kiSC4mmEyM+bVyPNr4XezoXeItnJI7FZ/E9hoTLKGc6RImX
TUlXzMl95pQ+0Rva0gbs6QMi+mw78xmELnuUEz1iBPllz5BXzCMf8fNRzqtg
uQyGbuA7ZqvPzbCkgFPUnAX1WdCcBf2XTD6ihWj7HbR9CodPi3aWU7Qfh/aj
cPQotB8WpfhemwsOOeCgjaBuMUHIEG7WhpuEcKM63FATrj8QRnpg/4y/dLq2
aNK3d8K7+6lnJyUzroJHzvyHjm0P7Ln3bDmj1i13WR7AvapPH9Kl3dClXNMm
9WsSrgrr+oR4csB8XC8f2yvG5zJ1TDfTRfxWx2BQqF7TJWaOMV08gh7bKxPi
L3PvCjSazIZA8XaPRoR+3RVdwhVtPDtNCZf1CVcMiVcMSX3G5D5T8lXTeuYP
UgcsaQPW9EFbxnW0dDIpWojErGh9NtzS0UZvatffkGlSri+MvBZ7cBY1i4ZH
JHJflaTB9FlRdwKCH0HDcWg8BqLWh9qh5Qi0tEn+7t2Dfmj1QasXWt00U8gB
IRs0W6DJBI16aNASMaiGemW4rjocqAz7y8O1+8O+UjqPnn3T7r1Trt2TzsJx
ZtVeM225b9xChseQdUefOYJ8aJGPtCFtOhl2zYYRTdqQkHKDTxqU8Qn9Is7r
rqrjr3IydXwfp1DF96nisJFUFGr8UuC1mhpBKuPxK5pHsS0QnmbdFc26PvSg
CX3cMl1iny6pX5d0lbaQ3G9AA7d+wJQ6aE6/zomW2Ftw37fjgRgiLZnPi3XJ
A9qkAUkt4q8IcZd5NnmUFC88jzN5SNFKk8cKgTME7hB4QuANSUgHQlDXDBEL
L2sKAPd2sx+aa4nW5IUmNzS5oMkBjTZotEADCzKCBqjXQZ0G6ngIqMGvJKKv
CnwHgOnwV6yFk5bCSXPhFN6Y8p4Ytz4ybHmgp/ZQl0PJt3bzA03WPSHzjpA+
IqQP8+kj/AZKvrFXpw2rUm7KVMk3OLkq+ToSVUnXOZkq8RoXpUy8pkocVCVQ
Y0CpEgZk6oQBpvt8wgCfSE0mJA5wS4SkAU0SWQxt8qA25Zpu/XXxfNm3jjrz
77sLybN7Cp94d4/V7nsSKBmvK5sIVk421kw3q2dI35l9J/XDI0MSjOsRmPkj
iyaPZKqRfITOxwssPcc952kl+8T2siTghTof1IvNS8NlQQ/IGlDLX25wQtAh
OYN6C9Sboc4EdUYIGCCgF99f5iwHRznYWbOVka2x7Js175oxFU5zMiN20YZd
0/pCqtVo88a1uU80W8c0OY/Rc+aMMbPOb36kznqg3nhflXlPlTmqyiBbitfK
DXdlyrTbMmXqCKdQpg4jVbn+ljLlllyZMsTJlck3iYI9yukmiiH5BspMjW39
0Cu0s2jjplFTzj1L/kPr9kfWfBK5o3CMk7n2PeVec+8b95ZM+MqmAlUUE9Sr
wg1CuEkPzVZoRXPqhyONcPQgQyOSpWBc3UEx02py6Ary63J+5UX1yotssUXI
y59DXiYhzzIM2qDbCh4beO3gw+aAWga03wkBJ9Q5cXwdEuR19vn4sc5G99bI
PTulb3oEcGvAxZqTBwc7BtZKsJaDpQLMFWDCxqRiKJrT753V7ZlFC7BrlntL
s2tWKJwl/Aum1flT6rxJ9bYJVe6Eaiu5ZuWWJzWbx2o2jdVkP67JflSTRapa
vfFBdeYDTladcZ+TV2fck3ZCqTX3vsAOlSbnoWbLQ+22R/rtT/QFY4a8MeP2
CaSb90xYdk9Y907aiqYcpdPOshlXBS3urQn7ePDroc5MqtbghWCQWDh0GA4d
hYOn4eAfoO1zOHJBrDIifizdYTnQygv8ygvMZjxXExHzbSljY9KL8pmg1kzN
j80ielNZwCbGncv9Nqi1UCMrYgUfE4zHAm4TuPREdGjBjjZeZsNuhVUAi4qo
phowVoHhAOgrQVcJ2nJCWlMKQkmYLwqr94XVe8OqPURU7gqzPOq9qoKpqm0E
cfW2yeqCyer88eptEzXYCsaVOwgqVcGkeseketcUv3NSKJwUdk1p9tLp0e2b
0RfPGEpmjWVzpvKwuVKKCJbbNODQg8sMbju4vOAOQC3DMNAGtR9B4DQ0nIGG
z6QMI0pLFQ2WVK6iC7HqS7aG+Q3ML6MoGRCz/g/PcdzzdQtJtxWijRc/34zY
k3fr3VCPGuxgjRV+Ax4I+MDvAb8Lap2k62T27OB2gNsJLhs4rWBnyFtNYDGC
2QAmPbxJ+zlQhtuuLIfKMqgshYoSqNjPzmRFMdLLS8LlJXMVRUB3HFdRMier
KApzUZXF4cqSucpi8rwHSsKcrKo0zL1SvT9cg60MlBU0WlUNaiWo1MDzIGhB
o5fQjNbbweAEgw909WBsAEsT2NqkZ3Lbx3+RiygMrPSgX3MR83UWoSrExJyw
k2ooCkrRI2UUqj6wQpHAiM/prWy++qCI1BwpNAxaIWiDoB0a8IS46JAgsTEA
DX5oqIVgLcjqa8UwJeCHQAD8fqitBV8teGtFU4MRqhu0LtA4JE6iVHZQ2qDG
CtVWqLJEqJUmqDBBuZFamSHCdakBSvVQQghRJy9mB4J6GXXvFBmgmDWk7jND
sRlKzVBigSIblDDztd8JJW4o8UK5FypqoawOShuIXtkElS0iixhdswxH/JjW
daPviO9iZ/PVZzWQSOFD+O1ZxJdnPYH7AdWsvkCsPzgrqiM+iuT/X2pWnmPt
/It0WUR8qRS9vBexzSEvhHwQ8kMoAM110FzP0phGaGqExkYQo+QVnoOSNjgO
gq0VLAfB3ArGVjC0El3TCkILqFtA2QI1LVDVwnS0BWRlIeCiSkNQHIKiEBH3
YvDzPs3zelPJk4a9j4O7HpAnyL9bm0vxiGfzkDv7pivrujPzmmPDoD2NgmNr
Sp/oAaL1YnkkhpVHcFlW0ePESpFUJqJhhJRiXhGRKqOS38vzVTB6b9V5hJpq
RdjYZIvReomhFanrfZU9JWPdxIBgcfKroY+g+QQ0nYSGjyF4ip3/01D7CXg/
Ac+n4PoU7GekuM94JnKamAbI807D1lOw+eSciK/8Dyzz/8MXIHL6zscBOOGF
4044aoEjhvBh3Vybhs54a/VMqGKyqXS8oehJ/Z7HdYXkiKhgknfXm3vbkzPi
2jTkzLopzvKGMbHXmNAbqY90iXUhLasuUTbOitdiXYTVP84reKnmRmUSvGT3
CqaKrHC68pwMsZNFTGkkGiMA5WQc1na8SO9EJF+TTvrbES+15NgpOPoJtJ+B
9t/DEXR9fxTpitAX0HwWGr+E4DnRY8mF8xH03mALHO+Bj7rg4044dQFOfynp
6Fsnm+FEEI774ZgHjrqgndneNiMc0kGrGkKsLNJYTu6lvniibt/TwO4xf+Ej
3/YH4vtvWNIHzaliCYTVPxLE+gf9hKKL7cbE+Vkpg/2EweohUX9RD1l1AV0K
OmqG4crzvFhGZx0r1eFzGVXtqKqnXU1Fd6RSOTdG+k3BEHvJGNdlXEdJ5OK8
TsRxhaSRb0VwlH/UCce65nMKTuG+DPZesPSAvkusZy4JnYPWs3DoC2j7Mxz5
DNo/E3F981grHGuGow1wtB7aA9DOspA2BxyyQKsRWnQQEqBZRS69sSocrJyr
L5uR9NOxdTRSwhixZt2yZA5R/SLtujGVKkmGlAF9cr8+6SqlXgl9mAFzLK7X
xPVSTSO2B88s5sk0lRBziUoY2FZ3qld3UomDKh2rOuQs6ozgehHdDesYYqyU
1CHTxnSyLCpSXbQxc8FwewlphJeI2TsSZisiVQl5YBDc/WC9LEYKivlqhfF3
YP4dWM+A4wy4zkS8gv8TqDsN9aek07n0UJukj20haGuCtkZoC8KhOlEe0RhU
t9ihxQohMzQbmf/SSm9+27t30r173FX41LWDqhL2vIe23PvWnHvWLaOWTXfM
2WQEjZnDxoxbhg1DhvSb+rQbutTrhF7KICZWmGFpEqUyBYEXfwWzXz4WW68a
m/hLIlUr5FShwI60Vb0akyfEFo8zAsxIQkwX8+FLDQm9qOqo8HhjTumzpA7Y
NlyzZ16fx3SB7/hLTN+VzjP9HwCbK6q+GYLN0IBNtJGyJvR8LzcHyaU0o2/x
M8figWZMcJ2U4zZJEen3/DVQewB8FWFvWdhTOucupnDZuWfasXvKXjhh2zlu
3f7Umk+Ambc9Mm19aHz2W/JdOkCZt7UZI9oNw5r0W5o0+lWFygnJ1/nka3zS
IJ84SCmrVFSQSgkyVewVsdIQz1wxqwa+rUm8qsVGxYJ+UYGZMvejVhtTB1nJ
4Jol4wap2sYhe9Ytx6Zh55bb7q13PLl3Wbz+HEpflzSP/bpNqkZBqxc8PvD6
wOeNVAV8UOelxsnqPaKfCboBm2iZvlPHclC88gtQqwafCrw14KkmirsSXOXg
LAs7SsP2krCtiLyEZc+sZdeMuXDKtGPSWDBhyH9Klix3TLf1sXbLIyoGZFM9
Rtg4KmTe5TPu8Om31ekjzLa+zmeP8ptG+ew7wqY72pz7OvbjvT7vsT7/sT7v
gW7bqHbTTW0mYaBLvYG2P+0m95Y+/Sap64YhYwahb944bMkasWbftm2+Y88Z
deZRluvZ8chbOFZb9Diwf6yudDJYPt14YHY+k4+gxnHfkhD7ZgQxjxm8FvCy
RKXWJkbeSzFXxBwRM8SABQKsSOI3gd8IsloMzd706cHLilRuHlxqcKnAqQQH
w8sm5otlYC4FU3HYWMTyxd1zkmdR5o8rGVo1eWPKvDFMvVHt/kFZQLqnLHis
zHuoyn+o3j7G73zKF9I4YddTfudjfscDTeEj7Z5xfRH5F2PJjKF40lD0xFD0
SF84qs8nLdVvGjVuuWvaOmreNmrJv2fNozTTvuOJc8+Yq3jMvW/SUzxTWzkZ
UNO0QTU06sLNtpkW5yz73X8en+8siJjZb8WIAPPRCAZBYgMZgsOqhwGMSJdR
tscSaS/iaAKPCdxGyvOcOhCz2eVCDfCYIVSBqhJUFaAsp9HKMsAUonr/XHXp
bFXJLLOrVcXTsqriKfaD14F9E1VFE1XFk9XFk5yspmSK+xZSq4snqoue1pSM
q/ZPqstm+ArSRr58mi+b4Pc/1VRM6arm9DUsm1SBSTVnUk4Zq58ay8dM+2kJ
a+WcrWrWXj3hqBl3qidcSqpX+ATwm2bZSSBNiZpH4nsLIlmxYldvg3orUG+H
eub+g04IujBnwD9M0FjsFW1lOYXZAyY3GF2gd4IukissF2zAW0FtAZUZlCYa
V22EagNU6eGADiq1UCmItq2Cx8i2Qg3lqnC5irgsU6I2l2P3VrlyrkI5hz1S
y6unK2pmKmpmK5VzB1RzVWpStyrlTFXNdLVqtoYPK3lQsSl5De6BF2a5KI0W
tDrQsQNvNEpSks9noKyKK9Yevy/pAotOSQfIrrqoiCha5EAQ/A2UIfuC4A1K
PL7hwDSvGawhMIfAyKJyXTNom0DTCEIQ1EFQsRSgJgBVfjhQC//IiTHdy7gS
+0WV/W8XIf/OvD89GILWFmpSdhVqg+bD0HQEGtsheHTejx4H30cMP4pLSH6v
4Cx/w+b8yYK4hoXXR4/D0ZPQfgqOfAqHz0Db70Vr+GNpJ3/L3voXCQHaFxmL
H0lP2X+ScT+T5ly+KJL6O2nUv7NR/yGNWvy/Gl+X9vcrNurn0kqL89gV0lwf
sFG/lOZa/KvfUmlUHBv1X9i/hndpYnXhpf8DoBiiwg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->257087532]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " usually scales the images of three\[Hyphen]dimensional objects to be as \
large as possible, given the display area you specify. Although in most cases \
this scaling is what you want, it does have the consequence that the size at \
which a particular three\[Hyphen]dimensional object is drawn may vary with \
the orientation of the object. You can set the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SphericalRegion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalRegion"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " to avoid such variation. With this option setting, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " effectively puts a sphere around the three\[Hyphen]dimensional bounding \
box, and scales the final image so that the whole of this sphere fits inside \
the display area you specify. The sphere has its center at the center of the \
bounding box, and is drawn so that the bounding box just fits inside it. "
}], "Text",
 CellID->14955],

Cell["This draws a rather elongated version of the plot. ", "MathCaption",
 CellID->23318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Show", "[", 
   RowBox[{"surf", ",", 
    RowBox[{"BoxRatios", "->", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "1"}], "}"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->32726],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{190, 213},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->559629353]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SphericalRegion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalRegion"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the final image is scaled so that a sphere placed around the bounding box \
would fit in the display area. "
}], "MathCaption",
 CellID->21025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Show", "[", 
   RowBox[{"surf", ",", 
    RowBox[{"BoxRatios", "->", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "1"}], "}"}]}], ",", 
    RowBox[{"SphericalRegion", "->", "True"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->20355],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{190, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->64096328]
}, Open  ]],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SphericalRegion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalRegion"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", you can make the scaling of an object consistent for all orientations of \
the object. This is useful if you create animated sequences which show a \
particular object in several different orientations. "
}], "Text",
 CellID->22549],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SphericalRegion",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SphericalRegion"], "->", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]}], Cell["\<\
scale three\[Hyphen]dimensional images to be as large as possible\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["SphericalRegion",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SphericalRegion"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}], Cell["\<\
scale images so that a sphere drawn around the three\[Hyphen]dimensional \
bounding box would fit in the final display area\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9496],

Cell["\<\
Changing the magnification of three\[Hyphen]dimensional images. \
\>", "Caption",
 CellID->18584],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->271707408],

Cell[TextData[ButtonBox["The Structure of Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], \
"RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Coordinate Systems for Three-Dimensional Graphics - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Structure of Graphics and Sound", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ThreeDimensionalGraphicsDirectives"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/LightingAndSurfaceProperties"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 46.9839440}", "context" -> "", 
    "keywords" -> {
     "absolute coordinates", "angle of view", "animation", "AspectRatio", 
      "aspect ratio", "bounding box", "bounding sphere", 
      "box coordinate system", "BoxRatios", "camera position", "centering", 
      "circumscribing sphere", "clipping", "coordinate systems", 
      "coordinate transformations", "display coordinate system", "framing", 
      "frustum", "gaze", "orientation", "perspective effects", "PlotRange", 
      "plot range", "PlotRegion", "plot region", "plots", "point of view", 
      "position", "projection point", "relative coordinates", 
      "Righthanded coordinate system", "rotation", "scaled", 
      "scaled coordinates", "shape", "SphericalRegion", 
      "stellated icosahedron", "Threedimensional graphics", "transformation", 
      "up direction", "vantage point", "vertical direction", "ViewCenter", 
      "viewing angle", "ViewPoint", "ViewVertical"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Whenever Mathematica draws a three-dimensional object, it always \
effectively puts a cuboidal box around the object. With the default option \
setting Boxed->True, Mathematica in fact draws the edges of this box \
explicitly. But in general, Mathematica automatically 'clips' any parts of \
your object that extend outside of the cuboidal box. The option PlotRange \
specifies the range of x, y and z coordinates that Mathematica should include \
in the box. As in two dimensions the default setting is PlotRange->Automatic, \
which makes Mathematica use an internal algorithm to try and include the \
'interesting parts' of a plot, but drop outlying parts. With PlotRange->All, \
Mathematica will include all parts. This loads a package defining polyhedron \
operations. ", "synonyms" -> {}, "title" -> 
    "Coordinate Systems for Three-Dimensional Graphics", "type" -> "Tutorial",
     "uri" -> "tutorial/CoordinateSystemsForThreeDimensionalGraphics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.10.10"->{
  Cell[2779, 72, 130, 4, 70, "Title",
   CellTags->{"S2.10.10", "10.1"},
   CellID->9601]},
 "10.1"->{
  Cell[2779, 72, 130, 4, 70, "Title",
   CellTags->{"S2.10.10", "10.1"},
   CellID->9601]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.10.10", 285979, 5405},
 {"10.1", 286082, 5409}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2154, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2779, 72, 130, 4, 70, "Title",
 CellTags->{"S2.10.10", "10.1"},
 CellID->9601],
Cell[2912, 78, 780, 23, 70, "Text",
 CellID->28323],
Cell[3695, 103, 1341, 46, 70, "Text",
 CellID->21132],
Cell[5039, 151, 92, 1, 70, "MathCaption",
 CellID->24472],
Cell[5134, 154, 104, 3, 70, "Input",
 CellID->27152],
Cell[5241, 159, 79, 1, 70, "MathCaption",
 CellID->21367079],
Cell[5323, 162, 251, 8, 70, "Input",
 CellID->67827138],
Cell[5577, 172, 93, 1, 70, "MathCaption",
 CellID->29763],
Cell[CellGroupData[{
Cell[5695, 177, 165, 5, 28, "Input",
 CellID->29901],
Cell[5863, 184, 5427, 93, 209, "Output",
 Evaluatable->False,
 CellID->155975824]
}, Open  ]],
Cell[11305, 280, 284, 9, 70, "MathCaption",
 CellID->14423],
Cell[CellGroupData[{
Cell[11614, 293, 225, 8, 28, "Input",
 CellID->3527],
Cell[11842, 303, 5224, 90, 180, "Output",
 Evaluatable->False,
 CellID->300547872]
}, Open  ]],
Cell[17081, 396, 754, 19, 70, "Text",
 CellID->26969],
Cell[17838, 417, 815, 24, 70, "DefinitionBox",
 CellID->14015],
Cell[18656, 443, 100, 3, 70, "Caption",
 CellID->5565],
Cell[18759, 448, 81, 1, 70, "MathCaption",
 CellID->28],
Cell[CellGroupData[{
Cell[18865, 453, 432, 14, 28, "Input",
 CellID->21543],
Cell[19300, 469, 5504, 94, 201, "Output",
 Evaluatable->False,
 CellID->291409727]
}, Open  ]],
Cell[24819, 566, 1125, 29, 70, "Text",
 CellID->2088],
Cell[25947, 597, 1158, 34, 70, "DefinitionBox",
 CellID->2943],
Cell[27108, 633, 125, 4, 70, "Caption",
 CellID->12637],
Cell[27236, 639, 94, 1, 70, "MathCaption",
 CellID->22409],
Cell[CellGroupData[{
Cell[27355, 644, 223, 7, 28, "Input",
 CellID->26463],
Cell[27581, 653, 3413, 60, 237, "Output",
 Evaluatable->False,
 CellID->200532319]
}, Open  ]],
Cell[31009, 716, 395, 13, 70, "Text",
 CellID->4681],
Cell[31407, 731, 368, 10, 70, "Text",
 CellID->1588],
Cell[31778, 743, 1325, 40, 70, "Text",
 CellID->11342],
Cell[33106, 785, 232, 8, 70, "MathCaption",
 CellID->608],
Cell[CellGroupData[{
Cell[33363, 797, 632, 21, 28, "Input",
 CellID->32060],
Cell[33998, 820, 24072, 399, 173, "Output",
 Evaluatable->False,
 CellID->360959365]
}, Open  ]],
Cell[58085, 1222, 127, 4, 70, "MathCaption",
 CellID->1758],
Cell[CellGroupData[{
Cell[58237, 1230, 223, 7, 28, "Input",
 CellID->29954],
Cell[58463, 1239, 19290, 320, 169, "Output",
 Evaluatable->False,
 CellID->197816202]
}, Open  ]],
Cell[77768, 1562, 115, 3, 70, "MathCaption",
 CellID->14146],
Cell[CellGroupData[{
Cell[77908, 1569, 215, 7, 28, "Input",
 CellID->690],
Cell[78126, 1578, 19765, 328, 166, "Output",
 Evaluatable->False,
 CellID->79380596]
}, Open  ]],
Cell[97906, 1909, 1931, 56, 70, "DefinitionBox3Col",
 CellID->12843],
Cell[99840, 1967, 123, 4, 70, "Caption",
 CellID->21430],
Cell[99966, 1973, 755, 24, 70, "Text",
 CellID->25620],
Cell[100724, 1999, 1381, 40, 70, "Text",
 CellID->748],
Cell[102108, 2041, 892, 26, 70, "Text",
 CellID->27067],
Cell[103003, 2069, 1848, 55, 70, "Text",
 CellID->559976476],
Cell[104854, 2126, 331, 11, 70, "MathCaption",
 CellID->32226],
Cell[CellGroupData[{
Cell[105210, 2141, 220, 7, 28, "Input",
 CellID->15185],
Cell[105433, 2150, 35866, 592, 237, "Output",
 Evaluatable->False,
 CellID->131773537]
}, Open  ]],
Cell[141314, 2745, 245, 8, 70, "MathCaption",
 CellID->124559076],
Cell[CellGroupData[{
Cell[141584, 2757, 191, 6, 28, "Input",
 CellID->222593067],
Cell[141778, 2765, 61161, 1007, 201, "Output",
 Evaluatable->False,
 CellID->814937398]
}, Open  ]],
Cell[202954, 3775, 1088, 34, 70, "Text",
 CellID->9853],
Cell[204045, 3811, 630, 19, 70, "Text",
 CellID->25629],
Cell[204678, 3832, 2202, 67, 70, "DefinitionBox",
 CellID->330853370],
Cell[206883, 3901, 214, 8, 70, "Caption",
 CellID->289417968],
Cell[207100, 3911, 905, 25, 70, "Text",
 CellID->431806326],
Cell[208008, 3938, 167, 4, 70, "MathCaption",
 CellID->2620803],
Cell[CellGroupData[{
Cell[208200, 3946, 248, 8, 28, "Input",
 CellID->277296951],
Cell[208451, 3956, 5807, 99, 101, "Output",
 Evaluatable->False,
 CellID->393288738]
}, Open  ]],
Cell[214273, 4058, 335, 9, 70, "MathCaption",
 CellID->115051531],
Cell[CellGroupData[{
Cell[214633, 4071, 474, 15, 28, "Input",
 CellID->344727871],
Cell[215110, 4088, 21043, 349, 201, "Output",
 Evaluatable->False,
 CellID->186846937]
}, Open  ]],
Cell[236168, 4440, 762, 18, 70, "Text",
 CellID->3359],
Cell[236933, 4460, 910, 23, 70, "DefinitionBox",
 CellID->16828],
Cell[237846, 4485, 111, 3, 70, "Caption",
 CellID->13914],
Cell[237960, 4490, 1474, 42, 70, "Text",
 CellID->280867684],
Cell[239437, 4534, 90, 1, 70, "MathCaption",
 CellID->32257],
Cell[CellGroupData[{
Cell[239552, 4539, 202, 6, 28, "Input",
 CellID->24766],
Cell[239757, 4547, 8736, 147, 76, "Output",
 Evaluatable->False,
 CellID->257087532]
}, Open  ]],
Cell[248508, 4697, 1114, 24, 70, "Text",
 CellID->14955],
Cell[249625, 4723, 90, 1, 70, "MathCaption",
 CellID->23318],
Cell[CellGroupData[{
Cell[249740, 4728, 254, 8, 28, "Input",
 CellID->32726],
Cell[249997, 4738, 19876, 330, 234, "Output",
 Evaluatable->False,
 CellID->559629353]
}, Open  ]],
Cell[269888, 5071, 409, 13, 70, "MathCaption",
 CellID->21025],
Cell[CellGroupData[{
Cell[270322, 5088, 307, 9, 28, "Input",
 CellID->20355],
Cell[270632, 5099, 9537, 160, 213, "Output",
 Evaluatable->False,
 CellID->64096328]
}, Open  ]],
Cell[280184, 5262, 504, 14, 70, "Text",
 CellID->22549],
Cell[280691, 5278, 1030, 30, 70, "DefinitionBox",
 CellID->9496],
Cell[281724, 5310, 107, 3, 70, "Caption",
 CellID->18584],
Cell[CellGroupData[{
Cell[281856, 5317, 72, 1, 70, "RelatedTutorialsSection",
 CellID->271707408],
Cell[281931, 5320, 201, 5, 70, "RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],
Cell[282159, 5329, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

