(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     43203,       1379]
NotebookOptionsPosition[     35498,       1149]
NotebookOutlinePosition[     39273,       1236]
CellTagsIndexPosition[     39179,       1230]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"The Structure of Graphics and Sound\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AspectRatio" :> 
          Documentation`HelpLookup["paclet:ref/AspectRatio"], "Automatic" :> 
          Documentation`HelpLookup["paclet:ref/Automatic"], "Circle" :> 
          Documentation`HelpLookup["paclet:ref/Circle"], "Disk" :> 
          Documentation`HelpLookup["paclet:ref/Disk"], "FontSize" :> 
          Documentation`HelpLookup["paclet:ref/FontSize"], "ImageScaled" :> 
          Documentation`HelpLookup["paclet:ref/ImageScaled"], "Offset" :> 
          Documentation`HelpLookup["paclet:ref/Offset"], "PlotRange" :> 
          Documentation`HelpLookup["paclet:ref/PlotRange"], "Scaled" :> 
          Documentation`HelpLookup["paclet:ref/Scaled"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"AspectRatio\"\>", 2->"\<\"Automatic\"\>", 
       3->"\<\"Circle\"\>", 4->"\<\"Disk\"\>", 5->"\<\"FontSize\"\>", 
       6->"\<\"ImageScaled\"\>", 7->"\<\"Offset\"\>", 8->"\<\"PlotRange\"\>", 
       9->"\<\"Scaled\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\<\
Coordinate Systems for Two\[Hyphen]Dimensional Graphics\
\>", "Title",
 CellTags->{"S2.10.4", "4.1"},
 CellID->17964],

Cell[TextData[{
 "When you set up a graphics object in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you give coordinates for the various graphical elements that appear. When \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " renders the graphics object, it has to translate the original coordinates \
you gave into \"display coordinates\" which specify where each element should \
be placed in the final display area. "
}], "Text",
 CellID->23342],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PlotRange",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PlotRange"], "->", "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", ",", "{", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["max", "TI"]], "}", "}"}], Cell[
    "the range of original coordinates to include in the plot", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30814],

Cell["\<\
Option which determines translation from original to display coordinates. \
\>", "Caption",
 CellID->5994],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " renders a graphics object, one of the first things it has to do is to work \
out what range of original ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinates it should actually display. Any graphical elements that are \
outside this range will be clipped, and not shown. "
}], "Text",
 CellID->8256],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " specifies the range of original coordinates to include. As discussed in\
\[NonBreakingSpace]\"",
 ButtonBox["Options for Graphics\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Options"],
 ", the default setting is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", which makes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " try to choose a range which includes all \"interesting\" parts of a plot, \
while dropping \"outliers\". By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", you can tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to include everything. You can also give explicit ranges of coordinates to \
include. "
}], "Text",
 CellID->6652],

Cell[TextData[{
 "This sets up a polygonal object whose corners have coordinates between \
roughly ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[PlusMinus]", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->23936],

Cell[BoxData[
 RowBox[{
  RowBox[{"obj", "=", 
   RowBox[{"Polygon", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"n", " ", 
           RowBox[{"Pi", "/", "10"}]}], "]"}], ",", 
         RowBox[{"Cos", "[", 
          RowBox[{"n", " ", 
           RowBox[{"Pi", "/", "10"}]}], "]"}]}], "}"}], "+", 
       RowBox[{"0.05", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "^", "n"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "20"}], "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[44]:=",
 CellID->30838],

Cell["\<\
In this case, the polygonal object fills almost the whole display area. \
\>", "MathCaption",
 CellID->20482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", "obj", "]"}]], "Input",
 CellLabel->"In[45]:=",
 CellID->1355],

Cell[BoxData[
 GraphicsBox[
  PolygonBox[{{0.25901699437494746`, 0.9010565162951535}, {0.6377852522924732,
    0.8590169943749475}, {0.7590169943749474, 0.5377852522924731}, {
   1.0010565162951535`, 0.35901699437494744`}, {0.95, -0.05}, {
   1.0010565162951535`, -0.25901699437494746`}, {
   0.7590169943749474, -0.6377852522924732}, {
   0.6377852522924732, -0.7590169943749474}, {
   0.25901699437494746`, -1.0010565162951535`}, {
   0.05, -0.95}, {-0.35901699437494744`, -1.0010565162951535`}, \
{-0.5377852522924731, -0.7590169943749474}, {-0.8590169943749475, \
-0.6377852522924732}, {-0.9010565162951535, -0.25901699437494746`}, {-1.05, \
-0.05}, {-0.9010565162951535, 0.35901699437494744`}, {-0.8590169943749475, 
   0.5377852522924731}, {-0.5377852522924731, 
   0.8590169943749475}, {-0.35901699437494744`, 0.9010565162951535}, {0.05, 
   1.05}}]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[45]=",
 CellID->144018705]
}, Open  ]],

Cell[TextData[{
 "Specifying an explicit ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " allows you to zoom in on a section of a graphic. "
}], "MathCaption",
 CellID->179929958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"obj", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", "All"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[49]:=",
 CellID->110439358],

Cell[BoxData[
 GraphicsBox[
  PolygonBox[{{0.25901699437494746`, 0.9010565162951535}, {0.6377852522924732,
    0.8590169943749475}, {0.7590169943749474, 0.5377852522924731}, {
   1.0010565162951535`, 0.35901699437494744`}, {0.95, -0.05}, {
   1.0010565162951535`, -0.25901699437494746`}, {
   0.7590169943749474, -0.6377852522924732}, {
   0.6377852522924732, -0.7590169943749474}, {
   0.25901699437494746`, -1.0010565162951535`}, {
   0.05, -0.95}, {-0.35901699437494744`, -1.0010565162951535`}, \
{-0.5377852522924731, -0.7590169943749474}, {-0.8590169943749475, \
-0.6377852522924732}, {-0.9010565162951535, -0.25901699437494746`}, {-1.05, \
-0.05}, {-0.9010565162951535, 0.35901699437494744`}, {-0.8590169943749475, 
   0.5377852522924731}, {-0.5377852522924731, 
   0.8590169943749475}, {-0.35901699437494744`, 0.9010565162951535}, {0.05, 
   1.05}}],
  PlotRange->{{0, 1}, All}]], "Output",
 ImageSize->{105, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[49]=",
 CellID->91032185]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["AspectRatio",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AspectRatio"], "->", 
     StyleBox["r", "TI"]}], Cell[TextData[{
     "make the ratio of height to width for the display area equal to ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AspectRatio",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AspectRatio"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}], Cell["\<\
determine the shape of the display area from the original coordinate system\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10893],

Cell["Specifying the shape of the display area. ", "Caption",
 CellID->10353],

Cell[TextData[{
 "What we have discussed so far is how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " translates the original coordinates you specify into positions in the \
final display area. What remains to discuss, however, is what the final \
display area is like. "
}], "Text",
 CellID->21416],

Cell[TextData[{
 "On most computer systems, there is a certain fixed region of screen or \
paper into which the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " display area must fit. How it fits into this region is determined by its \
\[OpenCurlyDoubleQuote]shape\[CloseCurlyDoubleQuote] or aspect ratio. In \
general, the option ",
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 " specifies the ratio of height to width for the final display area. "
}], "Text",
 CellID->13452],

Cell[TextData[{
 "It is important to note that the setting of ",
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 " does not affect the meaning of the scaled or display coordinates. These \
coordinates always run from 0 to 1 across the display area. What ",
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 " does is to change the shape of this display area. "
}], "Text",
 CellID->14008],

Cell[TextData[{
 "For two\[Hyphen]dimensional graphics, ",
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 " is set by default to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ". This determines the aspect ratio from the original coordinate system used \
in the plot instead of setting it at a fixed value. One unit in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction in the original coordinate system corresponds to the same \
distance in the final display as one unit in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction. In this way, objects that you define in the original coordinate \
system are displayed with their \"natural shape\"."
}], "Text",
 CellID->26303],

Cell[TextData[{
 "This generates a graphic object corresponding to a regular hexagon. With \
the default value of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AspectRatio",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AspectRatio"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the aspect ratio of the final display area is determined from the \
original coordinate system, and the hexagon is shown with its \"natural shape\
\". "
}], "MathCaption",
 CellID->7262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"n", " ", 
         RowBox[{"Pi", "/", "3"}]}], "]"}], ",", 
       RowBox[{"Cos", "[", 
        RowBox[{"n", " ", 
         RowBox[{"Pi", "/", "3"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "6"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[52]:=",
 CellID->22233],

Cell[BoxData[
 GraphicsBox[
  PolygonBox[
   NCache[{{Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}, {
     Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {0, -1}, {
     Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
     Rational[-1, 2] 3^Rational[1, 2], Rational[1, 2]}, {0, 1}}, {{
     0.8660254037844386, 0.5}, {0.8660254037844386, -0.5}, {
     0, -1}, {-0.8660254037844386, -0.5}, {-0.8660254037844386, 0.5}, {0, 
     1}}]]]], "Output",
 ImageSize->{184, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[52]=",
 CellID->43433422]
}, Open  ]],

Cell["\<\
This renders the hexagon in a display area whose height is three times its \
width. \
\>", "MathCaption",
 CellID->5454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"AspectRatio", "->", "3"}]}], "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->16303],

Cell[BoxData[
 GraphicsBox[
  PolygonBox[
   NCache[{{Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}, {
     Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {0, -1}, {
     Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
     Rational[-1, 2] 3^Rational[1, 2], Rational[1, 2]}, {0, 1}}, {{
     0.8660254037844386, 0.5}, {0.8660254037844386, -0.5}, {
     0, -1}, {-0.8660254037844386, -0.5}, {-0.8660254037844386, 0.5}, {0, 
     1}}]],
  AspectRatio->3]], "Output",
 ImageSize->{77, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]=",
 CellID->828510832]
}, Open  ]],

Cell[TextData[{
 "Sometimes, you may find it convenient to specify the display coordinates \
for a graphical element directly. You can do this by using scaled coordinates \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["sx", "TI"], ",", 
     StyleBox["sy", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " rather than ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 ". The scaled coordinates are defined to run from 0 to 1 in ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ", with the origin taken to be at the lower\[Hyphen]left corner of the plot \
range."
}], "Text",
 CellID->8075],

Cell[BoxData[GridBox[{
   {
    RowBox[{"{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}"}], Cell["original coordinates", "TableText"]},
   {
    RowBox[{
     ButtonBox["Scaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scaled"], "[", "{", 
     StyleBox["sx", "TI"], ",", 
     StyleBox["sy", "TI"], "}", "]"}], Cell[
    "coordinates scaled to the plot range", "TableText"]},
   {
    RowBox[{
     ButtonBox["ImageScaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ImageScaled"], "[", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["sx", "TI"], ",", 
       StyleBox["sy", "TI"]}], "}"}], "]"}], Cell[
    "coordinates scaled to the display area", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17913],

Cell["\<\
Coordinate systems for two\[Hyphen]dimensional graphics. \
\>", "Caption",
 CellID->16142],

Cell["\<\
The display area is significantly larger than the plot range due to the frame \
label. \
\>", "MathCaption",
 CellID->31196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Green", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "2"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<x\>\"", ",", "Large"}], "]"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[30]:=",
 CellID->21948],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0, 1, 0], DiskBox[{0, 0}]},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"x\"", Large, StripOnInput -> False], TraditionalForm]},
  PlotRange->2]], "Output",
 ImageSize->{184, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->15409967]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " coordinates, the rectangle falls at the origin, which is at the center of \
the specified plot range."
}], "MathCaption",
 CellID->1932893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Prolog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{"0.25", ",", "0.25"}], "}"}], "]"}], ",", 
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{"0.75", ",", "0.75"}], "}"}], "]"}]}], "]"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[33]:=",
 CellID->250591363],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0, 1, 0], DiskBox[{0, 0}]},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"x\"", Large, StripOnInput -> False], TraditionalForm]},
  PlotRange->2,
  Prolog->{
    RectangleBox[
     Scaled[{0.25, 0.25}], 
     Scaled[{0.75, 0.75}]]}]], "Output",
 ImageSize->{184, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->59007948]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " coordinates, the rectangle falls at exactly the center of the graphic, \
which does not coincide with the center of the plot range."
}], "MathCaption",
 CellID->138726416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Prolog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{"0.25", ",", "0.25"}], "}"}], "]"}], ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{"0.75", ",", "0.75"}], "}"}], "]"}]}], "]"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[56]:=",
 CellID->14542048],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0, 1, 0], DiskBox[{0, 0}]},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"x\"", Large, StripOnInput -> False], TraditionalForm]},
  PlotRange->2,
  Prolog->{
    RectangleBox[
     ImageScaled[{0.25, 0.25}], 
     ImageScaled[{0.75, 0.75}]]}]], "Output",
 ImageSize->{184, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[56]=",
 CellID->8290397]
}, Open  ]],

Cell[TextData[{
 "When you use ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 ",",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["sx", "TI"], ",", 
     StyleBox["sy", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageScaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageScaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["sx", "TI"], ",", 
     StyleBox["sy", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 ", you are specifying position either completely in original coordinates, or \
completely in scaled coordinates. Sometimes, however, you may need to use a \
combination of these coordinate systems. For example, if you want to draw a \
line at a particular point whose length is a definite fraction of the width \
of the plot, you will have to use original coordinates to specify the basic \
position of the line, and scaled coordinates to specify its length. "
}], "Text",
 CellID->20426],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["dsx", "TI"], ",", 
      StyleBox["dsy", "TI"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " to specify a position using a mixture of original and scaled coordinates. \
In this case, ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 " gives a position in original coordinates, and ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["dsx", "TI"], ",", 
    StyleBox["dsy", "TI"]}], "}"}]], "InlineFormula"],
 " gives the offset from the position in scaled coordinates."
}], "Text",
 CellID->14606],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Circle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Circle"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "}"}], ",", 
      RowBox[{
       ButtonBox["Scaled",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Scaled"], "[", 
       StyleBox["sx", "TI"], "]"}]}], "]"}], Cell["\<\
a circle whose radius is scaled to the width of the plot range\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Disk",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Disk"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "}"}], ",", 
      RowBox[{
       ButtonBox["Scaled",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Scaled"], "[", 
       StyleBox["sx", "TI"], "]"}]}], "]"}], Cell[
    "a disk whose radius is scaled to the width of the plot range", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["FontSize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FontSize"], "->", 
     RowBox[{
      ButtonBox["Scaled",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Scaled"], "[", 
      StyleBox["sx", "TI"], "]"}]}], Cell["\<\
specification for a font size scaled to the width of the plot range\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26873657],

Cell[TextData[{
 "Some places where ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " can be used with a single argument."
}], "Caption",
 CellID->282306469],

Cell[TextData[{
 "Both the radius of the circle and the size of the font are specified in ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " values."
}], "MathCaption",
 CellID->93385642],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"Scaled", "[", "0.3", "]"}]}], "]"}], ",", 
    RowBox[{"FontSize", "\[Rule]", 
     RowBox[{"Scaled", "[", "0.2", "]"}]}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{"\"\<some text\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[61]:=",
 CellID->95908548],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0, 0}, Scaled[0.3]], 
   StyleBox[InsetBox["\<\"some text\"\>", {0, 0}],
    FontSize->Scaled[0.2]]},
  ImageSize->{230., Automatic}]], "Output",
 ImageSize->{234, 230},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[61]=",
 CellID->691155791]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Scaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scaled"], "[", "{", 
     StyleBox["sdx", "TI"], ",", 
     StyleBox["sdy", "TI"], "}", ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", "]"}], Cell[
    "scaled offset from original coordinates", "TableText"]},
   {
    RowBox[{
     ButtonBox["ImageScaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ImageScaled"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["sdx", "TI"], ",", 
        StyleBox["sdy", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "}"}]}], "]"}], Cell[
    "image scaled offset from original coordinates", "TableText"]},
   {
    RowBox[{
     ButtonBox["Offset",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Offset"], "[", "{", 
     StyleBox["adx", "TI"], ",", 
     StyleBox["ady", "TI"], "}", ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", "]"}], Cell[
    "absolute offset from original coordinates", "TableText"]},
   {
    RowBox[{
     ButtonBox["Offset",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Offset"], "[", "{", 
     StyleBox["adx", "TI"], ",", 
     StyleBox["ady", "TI"], "}", ",", 
     ButtonBox["Scaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scaled"], "[", "{", 
     StyleBox["sx", "TI"], ",", 
     StyleBox["sy", "TI"], "}", "]", "]"}], Cell[
    "absolute offset from scaled coordinates", "TableText"]},
   {
    RowBox[{
     ButtonBox["Offset",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Offset"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["adx", "TI"], ",", 
        StyleBox["ady", "TI"]}], "}"}], ",", 
      RowBox[{
       ButtonBox["ImageScaled",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ImageScaled"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["sx", "TI"], ",", 
         StyleBox["sy", "TI"]}], "}"}], "]"}]}], "]"}], Cell[
    "absolute offset from image scaled coordinates", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24429],

Cell["Positions specified as offsets. ", "Caption",
 CellID->32404],

Cell["\<\
Each line drawn here has an absolute length of 6 printer\[CloseCurlyQuote]s \
points. \
\>", "MathCaption",
 CellID->6705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"x", "^", "2"}]}], "}"}], ",", 
        RowBox[{"Offset", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "6"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"x", "^", "2"}]}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->20626],

Cell[BoxData[
 GraphicsBox[{LineBox[{{1, 1}, Offset[{0, 6}, {1, 1}]}], 
   LineBox[{{2, 4}, Offset[{0, 6}, {2, 4}]}], 
   LineBox[{{3, 9}, Offset[{0, 6}, {3, 9}]}], 
   LineBox[{{4, 16}, Offset[{0, 6}, {4, 16}]}], 
   LineBox[{{5, 25}, Offset[{0, 6}, {5, 25}]}], 
   LineBox[{{6, 36}, Offset[{0, 6}, {6, 36}]}], 
   LineBox[{{7, 49}, Offset[{0, 6}, {7, 49}]}], 
   LineBox[{{8, 64}, Offset[{0, 6}, {8, 64}]}], 
   LineBox[{{9, 81}, Offset[{0, 6}, {9, 81}]}], 
   LineBox[{{10, 100}, Offset[{0, 6}, {10, 100}]}]},
  Frame->True]], "Output",
 ImageSize->{46, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->3571528]
}, Open  ]],

Cell[TextData[{
 "You can also use ",
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 " inside ",
 Cell[BoxData[
  ButtonBox["Circle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Circle"]], "InlineFormula"],
 " with just one argument to create a circle with a certain absolute radius. \
"
}], "MathCaption",
 CellID->19375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"x", "^", "2"}]}], "}"}], ",", 
       RowBox[{"Offset", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[36]:=",
 CellID->30093],

Cell[BoxData[
 GraphicsBox[{CircleBox[{1, 1}, Offset[{2., 2.}, {0., 0.}]], 
   CircleBox[{2, 4}, Offset[{2., 2.}, {0., 0.}]], 
   CircleBox[{3, 9}, Offset[{2., 2.}, {0., 0.}]], 
   CircleBox[{4, 16}, Offset[{2., 2.}, {0., 0.}]], 
   CircleBox[{5, 25}, Offset[{2., 2.}, {0., 0.}]], 
   CircleBox[{6, 36}, Offset[{2., 2.}, {0., 0.}]], 
   CircleBox[{7, 49}, Offset[{2., 2.}, {0., 0.}]], 
   CircleBox[{8, 64}, Offset[{2., 2.}, {0., 0.}]], 
   CircleBox[{9, 81}, Offset[{2., 2.}, {0., 0.}]], 
   CircleBox[{10, 100}, Offset[{2., 2.}, {0., 0.}]]},
  Frame->True]], "Output",
 ImageSize->{46, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]=",
 CellID->148171460]
}, Open  ]],

Cell["\<\
In most kinds of graphics, you typically want the relative positions of \
different objects to adjust automatically when you change the coordinates or \
the overall size of your plot. But sometimes you may instead want the offset \
from one object to another to be constrained to remain fixed. This can be the \
case, for example, when you are making a collection of plots in which you \
want certain features to remain consistent, even though the different plots \
have different forms.\
\>", "Text",
 CellID->16036],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Offset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Offset"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["adx", "TI"], ",", 
      StyleBox["ady", "TI"]}], "}"}], ",", 
    StyleBox["position", "TI"]}], "]"}]], "InlineFormula"],
 " allows you to specify the position of an object by giving an absolute \
offset from a position that is specified in original or scaled coordinates. \
The units for the offset are printer\[CloseCurlyQuote]s points, equal to ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "72"], TraditionalForm]], "InlineMath"],
 " of an inch."
}], "Text",
 CellID->14736],

Cell[TextData[{
 "When you give text in a plot, the size of the font that is used is also \
specified in printer\[CloseCurlyQuote]s points. Therefore, a 10\[Hyphen]point \
font, for example, has letters whose basic height is 10 printer\
\[CloseCurlyQuote]s points. You can use ",
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 " to move text around in a plot, and to create plotting symbols or icons \
which match the size of the text."
}], "Text",
 CellID->29141],

Cell[TextData[{
 "Using scaled coordinates, you can specify the sizes of graphical elements \
as fractions of the size of the display area. You cannot, however, tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " the actual physical size at which a particular graphical element should be \
rendered. Of course, this size ultimately depends on the details of your \
graphics output device, and cannot be determined for certain within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Nevertheless, graphics directives such as ",
 Cell[BoxData[
  ButtonBox["AbsoluteThickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteThickness"]], "InlineFormula"],
 " discussed in\[NonBreakingSpace]\"",
 ButtonBox["Graphics Directives and Options\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GraphicsDirectivesAndOptions"],
 " do allow you to indicate \[OpenCurlyDoubleQuote]absolute sizes\
\[CloseCurlyDoubleQuote] to use for particular graphical elements. The sizes \
you request in this way will be respected by most, but not all, output \
devices. (For example, if you optically project an image, it is neither \
possible nor desirable to maintain the same absolute size for a graphical \
element within it.) "
}], "Text",
 CellID->12317],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->941714234],

Cell[TextData[ButtonBox["The Structure of Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], \
"RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Coordinate Systems for Two-Dimensional Graphics - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Structure of Graphics and Sound", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/GraphicsDirectivesAndOptions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/LabelingTwoDimensionalGraphics"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 50.6246622}", "context" -> "", 
    "keywords" -> {
     "absolute coordinates", "AspectRatio", "aspect ratio", "Autoscaling", 
      "bounding box", "clipping", "coordinate systems", "distortion", 
      "elongation", "geometrical figures", "GoldenRatio", "graphics", 
      "height of plots", "hexagon", "icons", "margins", 
      "moving graphics object", "offset", "offsets", "outliers", "PlotRange", 
      "plot range", "PlotRegion", "plot region", "plots", "plotting symbols", 
      "points", "printers points", "relative coordinates", 
      "relative positions", "scaled", "scaled coordinates", "shape", 
      "shifting graphics objects", "size", "squashing", "text", 
      "transformation", "tweaking graphics", "width"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "When you set up a graphics object in Mathematica, you give coordinates \
for the various graphical elements that appear. When Mathematica renders the \
graphics object, it has to translate the original coordinates you gave into \
\"display coordinates\" which specify where each element should be placed in \
the final display area. Option which determines translation from original to \
display coordinates. When Mathematica renders a graphics object, one of the \
first things it has to do is to work out what range of original x and y \
coordinates it should actually display. Any graphical elements that are \
outside this range will be clipped, and not shown. ", "synonyms" -> {}, 
    "title" -> "Coordinate Systems for Two-Dimensional Graphics", "type" -> 
    "Tutorial", "uri" -> 
    "tutorial/CoordinateSystemsForTwoDimensionalGraphics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.10.4"->{
  Cell[2646, 70, 127, 4, 70, "Title",
   CellTags->{"S2.10.4", "4.1"},
   CellID->17964]},
 "4.1"->{
  Cell[2646, 70, 127, 4, 70, "Title",
   CellTags->{"S2.10.4", "4.1"},
   CellID->17964]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.10.4", 38964, 1219},
 {"4.1", 39065, 1223}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2021, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2646, 70, 127, 4, 70, "Title",
 CellTags->{"S2.10.4", "4.1"},
 CellID->17964],
Cell[2776, 76, 464, 12, 70, "Text",
 CellID->23342],
Cell[3243, 90, 899, 27, 70, "DefinitionBox",
 CellID->30814],
Cell[4145, 119, 116, 3, 70, "Caption",
 CellID->5994],
Cell[4264, 124, 479, 14, 70, "Text",
 CellID->8256],
Cell[4746, 140, 1215, 39, 70, "Text",
 CellID->6652],
Cell[5964, 181, 236, 8, 70, "MathCaption",
 CellID->23936],
Cell[6203, 191, 664, 22, 70, "Input",
 CellID->30838],
Cell[6870, 215, 119, 3, 70, "MathCaption",
 CellID->20482],
Cell[CellGroupData[{
Cell[7014, 222, 102, 3, 70, "Input",
 CellID->1355],
Cell[7119, 227, 1002, 20, 201, "Output",
 CellID->144018705]
}, Open  ]],
Cell[8136, 250, 257, 8, 70, "MathCaption",
 CellID->179929958],
Cell[CellGroupData[{
Cell[8418, 262, 279, 10, 70, "Input",
 CellID->110439358],
Cell[8700, 274, 1029, 21, 237, "Output",
 CellID->91032185]
}, Open  ]],
Cell[9744, 298, 994, 29, 70, "DefinitionBox",
 CellID->10893],
Cell[10741, 329, 77, 1, 70, "Caption",
 CellID->10353],
Cell[10821, 332, 307, 8, 70, "Text",
 CellID->21416],
Cell[11131, 342, 564, 14, 70, "Text",
 CellID->13452],
Cell[11698, 358, 542, 14, 70, "Text",
 CellID->14008],
Cell[12243, 374, 895, 22, 70, "Text",
 CellID->26303],
Cell[13141, 398, 545, 15, 70, "MathCaption",
 CellID->7262],
Cell[CellGroupData[{
Cell[13711, 417, 489, 16, 70, "Input",
 CellID->22233],
Cell[14203, 435, 591, 14, 227, "Output",
 CellID->43433422]
}, Open  ]],
Cell[14809, 452, 130, 4, 70, "MathCaption",
 CellID->5454],
Cell[CellGroupData[{
Cell[14964, 460, 155, 5, 70, "Input",
 CellID->16303],
Cell[15122, 467, 609, 15, 237, "Output",
 CellID->828510832]
}, Open  ]],
Cell[15746, 485, 877, 28, 70, "Text",
 CellID->8075],
Cell[16626, 515, 1028, 31, 70, "DefinitionBox",
 CellID->17913],
Cell[17657, 548, 100, 3, 70, "Caption",
 CellID->16142],
Cell[17760, 553, 134, 4, 70, "MathCaption",
 CellID->31196],
Cell[CellGroupData[{
Cell[17919, 561, 476, 15, 70, "Input",
 CellID->21948],
Cell[18398, 578, 344, 12, 237, "Output",
 CellID->15409967]
}, Open  ]],
Cell[18757, 593, 284, 9, 70, "MathCaption",
 CellID->1932893],
Cell[CellGroupData[{
Cell[19066, 606, 459, 15, 70, "Input",
 CellID->250591363],
Cell[19528, 623, 431, 16, 237, "Output",
 CellID->59007948]
}, Open  ]],
Cell[19974, 642, 326, 9, 70, "MathCaption",
 CellID->138726416],
Cell[CellGroupData[{
Cell[20325, 655, 468, 15, 70, "Input",
 CellID->14542048],
Cell[20796, 672, 440, 16, 237, "Output",
 CellID->8290397]
}, Open  ]],
Cell[21251, 691, 1163, 35, 70, "Text",
 CellID->20426],
Cell[22417, 728, 896, 31, 70, "Text",
 CellID->14606],
Cell[23316, 761, 1701, 55, 70, "DefinitionBox",
 CellID->26873657],
Cell[25020, 818, 228, 8, 70, "Caption",
 CellID->282306469],
Cell[25251, 828, 257, 8, 70, "MathCaption",
 CellID->93385642],
Cell[CellGroupData[{
Cell[25533, 840, 522, 16, 70, "Input",
 CellID->95908548],
Cell[26058, 858, 317, 9, 251, "Output",
 CellID->691155791]
}, Open  ]],
Cell[26390, 870, 2494, 76, 70, "DefinitionBox",
 CellID->24429],
Cell[28887, 948, 67, 1, 70, "Caption",
 CellID->32404],
Cell[28957, 951, 132, 4, 70, "MathCaption",
 CellID->6705],
Cell[CellGroupData[{
Cell[29114, 959, 675, 22, 70, "Input",
 CellID->20626],
Cell[29792, 983, 669, 16, 237, "Output",
 CellID->3571528]
}, Open  ]],
Cell[30476, 1002, 396, 14, 70, "MathCaption",
 CellID->19375],
Cell[CellGroupData[{
Cell[30897, 1020, 515, 17, 70, "Input",
 CellID->30093],
Cell[31415, 1039, 702, 16, 237, "Output",
 CellID->148171460]
}, Open  ]],
Cell[32132, 1058, 527, 9, 70, "Text",
 CellID->16036],
Cell[32662, 1069, 674, 20, 70, "Text",
 CellID->14736],
Cell[33339, 1091, 533, 12, 70, "Text",
 CellID->29141],
Cell[33875, 1105, 1268, 26, 70, "Text",
 CellID->12317],
Cell[CellGroupData[{
Cell[35168, 1135, 72, 1, 70, "RelatedTutorialsSection",
 CellID->941714234],
Cell[35243, 1138, 201, 5, 70, "RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],
Cell[35471, 1147, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

