(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39720,       1281]
NotebookOptionsPosition[     28163,        899]
NotebookOutlinePosition[     35259,       1111]
CellTagsIndexPosition[     35138,       1104]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Abel Equations", "Title",
 CellTags->{"AbelODE", "c:16", "b:1.1.0.7"},
 CellID->3584],

Cell[TextData[{
 "An ",
 ButtonBox["Abel ODE",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveIntroductionToODEs#14708"],
 " ",
 "is a first-order equation of the form "
}], "Text",
 CellID->86130161],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], 
      RowBox[{"(", "x", ")"}]}], "\[LongEqual]", 
     RowBox[{
      RowBox[{"f", "(", "x", ")"}], "+", 
      RowBox[{
       RowBox[{"g", "(", "x", ")"}], 
       RowBox[{"y", "(", "x", ")"}]}], "+", 
      RowBox[{
       RowBox[{"h", "(", "x", ")"}], 
       SuperscriptBox[
        RowBox[{"y", "(", "x", ")"}], "2"]}]}]}],
    TraditionalForm], "+", 
   RowBox[{
    RowBox[{"k", "(", "x", ")"}], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"y", "(", "x", ")"}], "3"], "."}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellID->574967433],

Cell["\<\
This equation arose in the context of the studies of Niels Henrik Abel on the \
theory of elliptic functions, and represents a natural generalization of the \
Riccati equation.\
\>", "Text",
 CellID->468358464],

Cell[TextData[{
 "Associated with any Abel ODE is a sequence of expressions that is built \
from the coefficients of the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["f", "0"], ",", 
     SubscriptBox["f", "1"], ",", 
     SubscriptBox["f", "2"], ",", 
     SubscriptBox["f", "3"]}], "}"}], TraditionalForm]], "InlineMath"],
 " and invariant under certain coordinate transformations of the independent \
variable and the dependent variable. These ",
 StyleBox["invariants",
  FontSlant->"Italic"],
 " characterize each equation and can be used for identifying integrable \
classes of Abel ODEs. In particular, Abel ODEs with zero or constant \
invariants can be integrated easily and constitute an important integrable",
 " ",
 "class of these equations."
}], "Text",
 CellTags->"b:1.1.0.7",
 CellID->6654],

Cell["\<\
Here is the construction of a particular invariant with value 0 and the \
solution of the corresponding Abel ODE.\
\>", "MathCaption",
 CellTags->"b:1.1.0.7",
 CellID->16972],

Cell[BoxData[
 RowBox[{
  RowBox[{"f0", "=", "0"}], ";", 
  RowBox[{"f1", "=", 
   FractionBox["1", "x"]}], ";", 
  RowBox[{"f2", "=", 
   RowBox[{"-", "3"}]}], ";", 
  RowBox[{"f3", "=", "x"}], ";"}]], "Input",
 CellTags->"b:1.1.0.7",
 CellLabel->"In[1]:=",
 CellID->21457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Invariant", "=", 
  RowBox[{
   RowBox[{"f0", " ", 
    SuperscriptBox["f3", "2"]}], "+", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["f2", "3"]}], "9"], "-", 
      RowBox[{"f1", " ", "f3", " ", "f2"}], "-", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], "f3"}], " ", "f2"}], "+", 
      RowBox[{"f3", " ", 
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], "f2"}]}]}], ")"}]}]}]}]], "Input",
 CellTags->"b:1.1.0.7",
 CellLabel->"In[2]:=",
 CellID->14369],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.7",
 CellLabel->"Out[2]=",
 CellID->333481074]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbelODE", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
   RowBox[{"f0", "+", 
    RowBox[{"f1", " ", 
     RowBox[{"y", "[", "x", "]"}]}], "+", 
    RowBox[{"f2", " ", 
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "2"]}], "+", 
    RowBox[{"f3", " ", 
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "3"]}]}]}]}]], "Input",
 CellTags->"b:1.1.0.7",
 CellLabel->"In[3]:=",
 CellID->2963],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["y", "\[Prime]",
    MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"y", "[", "x", "]"}], "x"], "-", 
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"y", "[", "x", "]"}], "2"]}], "+", 
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"y", "[", "x", "]"}], "3"]}]}]}]], "Output",
 ImageSize->{197, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.7",
 CellLabel->"Out[3]=",
 CellID->33589666]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"AbelODE", ",", " ", "y", ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:1.1.0.7",
 CellLabel->"In[4]:=",
 CellID->2483],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        FractionBox["1", "x"], "-", 
        FractionBox["1", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          SqrtBox[
           RowBox[{
            FractionBox["1", 
             SuperscriptBox["x", "2"]], "+", 
            RowBox[{"C", "[", "1", "]"}]}]]}]]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        FractionBox["1", "x"], "+", 
        FractionBox["1", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          SqrtBox[
           RowBox[{
            FractionBox["1", 
             SuperscriptBox["x", "2"]], "+", 
            RowBox[{"C", "[", "1", "]"}]}]]}]]}]}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{545, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.7",
 CellLabel->"Out[4]=",
 CellID->156181170]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AbelODE", "/.", "sol"}], "//", "Simplify"}]], "Input",
 CellTags->"b:1.1.0.7",
 CellLabel->"In[5]:=",
 CellID->11635],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.7",
 CellLabel->"Out[5]=",
 CellID->980547479]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"f0", ",", "f1", ",", "f2", ",", "f3"}], "]"}]], "Input",
 CellTags->"b:1.1.0.7",
 CellLabel->"In[6]:=",
 CellID->22848],

Cell["\<\
Another important class of integrable Abel ODEs are those that can be reduced \
to inverse linear first-order ODEs using a nonlinear coordinate \
transformation.\
\>", "Text",
 CellTags->"b:1.1.0.7",
 CellID->4675],

Cell[TextData[{
 "This Abel ODE is solved by transforming it to an inverse linear first-order \
ODE. The ",
 Cell[BoxData[
  ButtonBox["ExpIntegralEi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralEi"]], "InlineFormula"],
 " term in the solution to this equation comes from solving the linear ODE."
}], "MathCaption",
 CellTags->"b:1.1.0.7",
 CellID->12938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "3"], "-", 
     FractionBox[
      RowBox[{"x", " ", 
       SuperscriptBox[
        RowBox[{"y", "[", "x", "]"}], "2"]}], 
      RowBox[{"x", "-", "1"}]]}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.0.7",
 CellLabel->"In[7]:=",
 CellID->2223],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:1.1.0.7",
 CellLabel->"During evaluation of In[7]:=",
 CellID->401220905],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:1.1.0.7",
 CellLabel->"During evaluation of In[7]:=",
 CellID->280159665],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/tdep\\\", \
ButtonNote -> \\\"Solve::tdep\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:1.1.0.7",
 CellLabel->"During evaluation of In[7]:=",
 CellID->651453938],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"1", "-", "x", "+", 
        FractionBox["1", 
         RowBox[{"y", "[", "x", "]"}]]}]], 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}]], "+", 
     RowBox[{"C", "[", "1", "]"}], "+", 
     RowBox[{"ExpIntegralEi", "[", 
      RowBox[{"1", "-", "x", "+", 
       FractionBox["1", 
        RowBox[{"y", "[", "x", "]"}]]}], "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}]}], "]"}]], "Output",
 ImageSize->{401, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.7",
 CellLabel->"Out[7]=",
 CellID->230868372]
}, Open  ]],

Cell[TextData[{
 "Another important class of integrable Abel ODEs consists of those that can \
be transformed to an inverse Riccati equation. Since Riccati equations can be \
transformed to second-order linear ODEs, the solutions for this class are \
usually given in terms of special functions such as ",
 Cell[BoxData[
  ButtonBox["AiryAi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryAi"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BesselJ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselJ"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:1.1.0.7",
 CellID->20175],

Cell["\<\
This Abel ODE is solved by reducing it to an inverse Riccati equation.\
\>", "MathCaption",
 CellTags->"b:1.1.0.7",
 CellID->21459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbelODE", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}], "==", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "3"], 
     RowBox[{"8", " ", 
      SuperscriptBox["x", "2"]}]], "-", 
    SuperscriptBox[
     RowBox[{"y", "[", "x", "]"}], "2"]}]}]}]], "Input",
 CellTags->"b:1.1.0.7",
 CellLabel->"In[8]:=",
 CellID->17825],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["y", "\[Prime]",
    MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{"y", "[", "x", "]"}], "2"]}], "+", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"y", "[", "x", "]"}], "3"], 
    RowBox[{"8", " ", 
     SuperscriptBox["x", "2"]}]]}]}]], "Output",
 ImageSize->{144, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.7",
 CellLabel->"Out[8]=",
 CellID->565541212]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"AbelODE", ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:1.1.0.7",
 CellLabel->"In[9]:=",
 CellID->17870],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:1.1.0.7",
 CellLabel->"During evaluation of In[9]:=",
 CellID->361645924],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:1.1.0.7",
 CellLabel->"During evaluation of In[9]:=",
 CellID->22378944],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:1.1.0.7",
 CellLabel->"During evaluation of In[9]:=",
 CellID->88728690],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], ":", 
  " ", "\<\"Further output of \\!\\(InverseFunction :: \\\"ifun\\\"\\) will \
be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:1.1.0.7",
 CellLabel->"During evaluation of In[9]:=",
 CellID->325388927],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/tdep\\\", \
ButtonNote -> \\\"Solve::tdep\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:1.1.0.7",
 CellLabel->"During evaluation of In[9]:=",
 CellID->3109925],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{526, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.7",
 CellLabel->"Out[9]=",
 CellID->66259143]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
 CellTags->"b:1.1.0.7",
 CellID->22279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"sol", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellTags->"b:1.1.0.7",
 CellLabel->"In[10]:=",
 CellID->22701],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "8"], " ", 
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "8"}], "+", 
       FractionBox[
        RowBox[{"y", "[", "x", "]"}], 
        SuperscriptBox["x", "2"]]}], ")"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{204, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.7",
 CellLabel->"Out[10]=",
 CellID->268971667]
}, Open  ]],

Cell[TextData[{
 "The Abel ODEs considered so far are said to be of the ",
 StyleBox["first kind.",
  FontSlant->"Italic"],
 " Abel ODEs of the ",
 StyleBox["second kind",
  FontSlant->"Italic"],
 " are given by the following general formula."
}], "Text",
 CellTags->"b:1.1.0.7",
 CellID->12734],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "(", "x", ")"}], "\[LongEqual]", 
   FractionBox[
    RowBox[{
     RowBox[{"f", "(", "x", ")"}], "+", 
     RowBox[{
      RowBox[{"g", "(", "x", ")"}], 
      RowBox[{"y", "(", "x", ")"}]}], "+", 
     RowBox[{
      RowBox[{"h", "(", "x", ")"}], 
      SuperscriptBox[
       RowBox[{"y", "(", "x", ")"}], "2"]}], "+", 
     RowBox[{
      RowBox[{"k", "(", "x", ")"}], 
      SuperscriptBox[
       RowBox[{"y", "(", "x", ")"}], "3"]}]}], 
    RowBox[{
     RowBox[{"a", "(", "x", ")"}], "+", 
     RowBox[{
      RowBox[{"b", "(", "x", ")"}], 
      RowBox[{"y", "(", "x", ")"}]}]}]]}], TraditionalForm]], "DisplayMath",
 CellTags->"b:1.1.0.7",
 CellID->1637],

Cell["\<\
An Abel ODE of the second kind can be converted to an equation of the first \
kind with a coordinate transformation. Thus, the solution methods for this \
kind of Abel ODE are identical to the methods for equations of the first \
kind.\
\>", "Text",
 CellTags->"b:1.1.0.7",
 CellID->26534],

Cell["Here is the solution for an Abel ODE of the second kind.", "MathCaption",
 CellTags->"b:1.1.0.7",
 CellID->5556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"2", "x"}], "9"]}], "+", " ", 
       RowBox[{"x", "^", "3"}], "+", 
       RowBox[{"y", "[", "x", "]"}]}], 
      RowBox[{"y", "[", "x", "]"}]]}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:1.1.0.7",
 CellLabel->"In[11]:=",
 CellID->1993],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/tdep\\\", \
ButtonNote -> \\\"Solve::tdep\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:1.1.0.7",
 CellLabel->"During evaluation of In[11]:=",
 CellID->174982215],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/tdep\\\", \
ButtonNote -> \\\"Solve::tdep\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:1.1.0.7",
 CellLabel->"During evaluation of In[11]:=",
 CellID->3779317],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"C", "[", "1", "]"}], "\[Equal]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            SqrtBox["2"], 
            RowBox[{"3", " ", "x"}]], "-", 
           FractionBox[
            RowBox[{
             SqrtBox["2"], " ", 
             RowBox[{"y", "[", "x", "]"}]}], 
            SuperscriptBox["x", "2"]]}], ")"}], "2"]}], ")"}], 
      RowBox[{"1", "/", "4"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"3", " ", "x"}], 
         SqrtBox["2"]]}], "-", 
       FractionBox[
        RowBox[{
         RowBox[{"Hypergeometric2F1", "[", 
          RowBox[{
           FractionBox["1", "2"], ",", 
           FractionBox["3", "4"], ",", 
           FractionBox["3", "2"], ",", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FractionBox[
               SqrtBox["2"], 
               RowBox[{"3", " ", "x"}]], "-", 
              FractionBox[
               RowBox[{
                SqrtBox["2"], " ", 
                RowBox[{"y", "[", "x", "]"}]}], 
               SuperscriptBox["x", "2"]]}], ")"}], "2"]}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            SqrtBox["2"], 
            RowBox[{"3", " ", "x"}]], "-", 
           FractionBox[
            RowBox[{
             SqrtBox["2"], " ", 
             RowBox[{"y", "[", "x", "]"}]}], 
            SuperscriptBox["x", "2"]]}], ")"}]}], 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               FractionBox[
                SqrtBox["2"], 
                RowBox[{"3", " ", "x"}]], "-", 
               FractionBox[
                RowBox[{
                 SqrtBox["2"], " ", 
                 RowBox[{"y", "[", "x", "]"}]}], 
                SuperscriptBox["x", "2"]]}], ")"}], "2"]}], ")"}], 
          RowBox[{"1", "/", "4"}]]}]]}], ")"}]}]}], ",", 
   RowBox[{"y", "[", "x", "]"}]}], "]"}]], "Output",
 ImageSize->{539, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.7",
 CellLabel->"Out[11]=",
 CellID->169854283]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
 CellTags->"b:1.1.0.7",
 CellID->10548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"sol", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellTags->"b:1.1.0.7",
 CellLabel->"In[12]:=",
 CellID->15881],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
    RowBox[{"1", "+", 
     FractionBox[
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " ", "x"}], "9"]}], "+", 
       SuperscriptBox["x", "3"]}], 
      RowBox[{"y", "[", "x", "]"}]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{153, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.7",
 CellLabel->"Out[12]=",
 CellID->155915744]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->260305036],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Abel Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveClairautEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveChiniEquations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 15.0315370}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "An Abel ODE is a first-order equation of the form This equation arose in \
the context of the studies of Niels Henrik Abel on the theory of elliptic \
functions, and represents a natural generalization of the Riccati equation. \
Associated with any Abel ODE is a sequence of expressions that is built from \
the coefficients of the equation {f_0,f_1,f_2,f_3} and invariant under \
certain coordinate transformations of the independent variable and the \
dependent variable. These invariants characterize each equation and can be \
used for identifying integrable classes of Abel ODEs. In particular, Abel \
ODEs with zero or constant invariants can be integrated easily and constitute \
an important integrable class of these equations.", "synonyms" -> {}, "title" -> 
    "Abel Equations", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveAbelEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "AbelODE"->{
  Cell[1280, 43, 91, 2, 70, "Title",
   CellTags->{"AbelODE", "c:16", "b:1.1.0.7"},
   CellID->3584]},
 "c:16"->{
  Cell[1280, 43, 91, 2, 70, "Title",
   CellTags->{"AbelODE", "c:16", "b:1.1.0.7"},
   CellID->3584]},
 "b:1.1.0.7"->{
  Cell[1280, 43, 91, 2, 70, "Title",
   CellTags->{"AbelODE", "c:16", "b:1.1.0.7"},
   CellID->3584],
  Cell[2508, 91, 847, 22, 70, "Text",
   CellTags->"b:1.1.0.7",
   CellID->6654],
  Cell[3358, 115, 184, 5, 70, "MathCaption",
   CellTags->"b:1.1.0.7",
   CellID->16972],
  Cell[3545, 122, 274, 10, 70, "Input",
   CellTags->"b:1.1.0.7",
   CellID->21457],
  Cell[3844, 136, 617, 21, 45, "Input",
   CellTags->"b:1.1.0.7",
   CellID->14369],
  Cell[4464, 159, 182, 6, 36, "Output",
   CellTags->"b:1.1.0.7",
   CellID->333481074],
  Cell[4683, 170, 511, 17, 28, "Input",
   CellTags->"b:1.1.0.7",
   CellID->2963],
  Cell[5197, 189, 547, 19, 51, "Output",
   CellTags->"b:1.1.0.7",
   CellID->33589666],
  Cell[5781, 213, 191, 6, 70, "Input",
   CellTags->"b:1.1.0.7",
   CellID->2483],
  Cell[5975, 221, 1127, 39, 77, "Output",
   CellTags->"b:1.1.0.7",
   CellID->156181170],
  Cell[7139, 265, 152, 5, 70, "Input",
   CellTags->"b:1.1.0.7",
   CellID->11635],
  Cell[7294, 272, 233, 8, 36, "Output",
   CellTags->"b:1.1.0.7",
   CellID->980547479],
  Cell[7542, 283, 168, 5, 70, "Input",
   CellTags->"b:1.1.0.7",
   CellID->22848],
  Cell[7713, 290, 224, 6, 70, "Text",
   CellTags->"b:1.1.0.7",
   CellID->4675],
  Cell[7940, 298, 372, 10, 70, "MathCaption",
   CellTags->"b:1.1.0.7",
   CellID->12938],
  Cell[8337, 312, 534, 18, 70, "Input",
   CellTags->"b:1.1.0.7",
   CellID->2223],
  Cell[8874, 332, 496, 10, 70, "Message",
   CellTags->"b:1.1.0.7",
   CellID->401220905],
  Cell[9373, 344, 496, 10, 70, "Message",
   CellTags->"b:1.1.0.7",
   CellID->280159665],
  Cell[9872, 356, 487, 10, 70, "Message",
   CellTags->"b:1.1.0.7",
   CellID->651453938],
  Cell[10362, 368, 719, 23, 64, "Output",
   CellTags->"b:1.1.0.7",
   CellID->230868372],
  Cell[11096, 394, 604, 17, 70, "Text",
   CellTags->"b:1.1.0.7",
   CellID->20175],
  Cell[11703, 413, 141, 4, 70, "MathCaption",
   CellTags->"b:1.1.0.7",
   CellID->21459],
  Cell[11869, 421, 451, 16, 70, "Input",
   CellTags->"b:1.1.0.7",
   CellID->17825],
  Cell[12323, 439, 531, 19, 56, "Output",
   CellTags->"b:1.1.0.7",
   CellID->565541212],
  Cell[12891, 463, 217, 7, 70, "Input",
   CellTags->"b:1.1.0.7",
   CellID->17870],
  Cell[13111, 472, 496, 10, 70, "Message",
   CellTags->"b:1.1.0.7",
   CellID->361645924],
  Cell[13610, 484, 495, 10, 70, "Message",
   CellTags->"b:1.1.0.7",
   CellID->22378944],
  Cell[14108, 496, 495, 10, 70, "Message",
   CellTags->"b:1.1.0.7",
   CellID->88728690],
  Cell[14606, 508, 496, 10, 70, "Message",
   CellTags->"b:1.1.0.7",
   CellID->325388927],
  Cell[15105, 520, 485, 10, 19, "Message",
   CellTags->"b:1.1.0.7",
   CellID->3109925],
  Cell[15593, 532, 4522, 79, 180, "Output",
   Evaluatable->False,
   CellTags->"b:1.1.0.7",
   CellID->66259143],
  Cell[20130, 614, 90, 2, 70, "MathCaption",
   CellTags->"b:1.1.0.7",
   CellID->22279],
  Cell[20245, 620, 353, 13, 70, "Input",
   CellTags->"b:1.1.0.7",
   CellID->22701],
  Cell[20601, 635, 638, 22, 52, "Output",
   CellTags->"b:1.1.0.7",
   CellID->268971667],
  Cell[21254, 660, 295, 10, 70, "Text",
   CellTags->"b:1.1.0.7",
   CellID->12734],
  Cell[21552, 672, 778, 26, 70, "DisplayMath",
   CellTags->"b:1.1.0.7",
   CellID->1637],
  Cell[22333, 700, 299, 7, 70, "Text",
   CellTags->"b:1.1.0.7",
   CellID->26534],
  Cell[22635, 709, 118, 2, 70, "MathCaption",
   CellTags->"b:1.1.0.7",
   CellID->5556],
  Cell[22778, 715, 575, 19, 70, "Input",
   CellTags->"b:1.1.0.7",
   CellID->1993],
  Cell[23356, 736, 488, 10, 70, "Message",
   CellTags->"b:1.1.0.7",
   CellID->174982215],
  Cell[23847, 748, 486, 10, 70, "Message",
   CellTags->"b:1.1.0.7",
   CellID->3779317],
  Cell[24336, 760, 2427, 78, 150, "Output",
   CellTags->"b:1.1.0.7",
   CellID->169854283],
  Cell[26778, 841, 90, 2, 70, "MathCaption",
   CellTags->"b:1.1.0.7",
   CellID->10548],
  Cell[26893, 847, 353, 13, 70, "Input",
   CellTags->"b:1.1.0.7",
   CellID->15881],
  Cell[27249, 862, 571, 20, 61, "Output",
   CellTags->"b:1.1.0.7",
   CellID->155915744]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"AbelODE", 30870, 956},
 {"c:16", 30984, 960},
 {"b:1.1.0.7", 31103, 964}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 91, 2, 70, "Title",
 CellTags->{"AbelODE", "c:16", "b:1.1.0.7"},
 CellID->3584],
Cell[1374, 47, 211, 8, 70, "Text",
 CellID->86130161],
Cell[1588, 57, 694, 25, 70, "DisplayMath",
 CellID->574967433],
Cell[2285, 84, 220, 5, 70, "Text",
 CellID->468358464],
Cell[2508, 91, 847, 22, 70, "Text",
 CellTags->"b:1.1.0.7",
 CellID->6654],
Cell[3358, 115, 184, 5, 70, "MathCaption",
 CellTags->"b:1.1.0.7",
 CellID->16972],
Cell[3545, 122, 274, 10, 70, "Input",
 CellTags->"b:1.1.0.7",
 CellID->21457],
Cell[CellGroupData[{
Cell[3844, 136, 617, 21, 45, "Input",
 CellTags->"b:1.1.0.7",
 CellID->14369],
Cell[4464, 159, 182, 6, 36, "Output",
 CellTags->"b:1.1.0.7",
 CellID->333481074]
}, Open  ]],
Cell[CellGroupData[{
Cell[4683, 170, 511, 17, 28, "Input",
 CellTags->"b:1.1.0.7",
 CellID->2963],
Cell[5197, 189, 547, 19, 51, "Output",
 CellTags->"b:1.1.0.7",
 CellID->33589666]
}, Open  ]],
Cell[CellGroupData[{
Cell[5781, 213, 191, 6, 70, "Input",
 CellTags->"b:1.1.0.7",
 CellID->2483],
Cell[5975, 221, 1127, 39, 77, "Output",
 CellTags->"b:1.1.0.7",
 CellID->156181170]
}, Open  ]],
Cell[CellGroupData[{
Cell[7139, 265, 152, 5, 70, "Input",
 CellTags->"b:1.1.0.7",
 CellID->11635],
Cell[7294, 272, 233, 8, 36, "Output",
 CellTags->"b:1.1.0.7",
 CellID->980547479]
}, Open  ]],
Cell[7542, 283, 168, 5, 70, "Input",
 CellTags->"b:1.1.0.7",
 CellID->22848],
Cell[7713, 290, 224, 6, 70, "Text",
 CellTags->"b:1.1.0.7",
 CellID->4675],
Cell[7940, 298, 372, 10, 70, "MathCaption",
 CellTags->"b:1.1.0.7",
 CellID->12938],
Cell[CellGroupData[{
Cell[8337, 312, 534, 18, 70, "Input",
 CellTags->"b:1.1.0.7",
 CellID->2223],
Cell[8874, 332, 496, 10, 70, "Message",
 CellTags->"b:1.1.0.7",
 CellID->401220905],
Cell[9373, 344, 496, 10, 70, "Message",
 CellTags->"b:1.1.0.7",
 CellID->280159665],
Cell[9872, 356, 487, 10, 70, "Message",
 CellTags->"b:1.1.0.7",
 CellID->651453938],
Cell[10362, 368, 719, 23, 64, "Output",
 CellTags->"b:1.1.0.7",
 CellID->230868372]
}, Open  ]],
Cell[11096, 394, 604, 17, 70, "Text",
 CellTags->"b:1.1.0.7",
 CellID->20175],
Cell[11703, 413, 141, 4, 70, "MathCaption",
 CellTags->"b:1.1.0.7",
 CellID->21459],
Cell[CellGroupData[{
Cell[11869, 421, 451, 16, 70, "Input",
 CellTags->"b:1.1.0.7",
 CellID->17825],
Cell[12323, 439, 531, 19, 56, "Output",
 CellTags->"b:1.1.0.7",
 CellID->565541212]
}, Open  ]],
Cell[CellGroupData[{
Cell[12891, 463, 217, 7, 70, "Input",
 CellTags->"b:1.1.0.7",
 CellID->17870],
Cell[13111, 472, 496, 10, 70, "Message",
 CellTags->"b:1.1.0.7",
 CellID->361645924],
Cell[13610, 484, 495, 10, 70, "Message",
 CellTags->"b:1.1.0.7",
 CellID->22378944],
Cell[14108, 496, 495, 10, 70, "Message",
 CellTags->"b:1.1.0.7",
 CellID->88728690],
Cell[14606, 508, 496, 10, 70, "Message",
 CellTags->"b:1.1.0.7",
 CellID->325388927],
Cell[15105, 520, 485, 10, 19, "Message",
 CellTags->"b:1.1.0.7",
 CellID->3109925],
Cell[15593, 532, 4522, 79, 180, "Output",
 Evaluatable->False,
 CellTags->"b:1.1.0.7",
 CellID->66259143]
}, Open  ]],
Cell[20130, 614, 90, 2, 70, "MathCaption",
 CellTags->"b:1.1.0.7",
 CellID->22279],
Cell[CellGroupData[{
Cell[20245, 620, 353, 13, 70, "Input",
 CellTags->"b:1.1.0.7",
 CellID->22701],
Cell[20601, 635, 638, 22, 52, "Output",
 CellTags->"b:1.1.0.7",
 CellID->268971667]
}, Open  ]],
Cell[21254, 660, 295, 10, 70, "Text",
 CellTags->"b:1.1.0.7",
 CellID->12734],
Cell[21552, 672, 778, 26, 70, "DisplayMath",
 CellTags->"b:1.1.0.7",
 CellID->1637],
Cell[22333, 700, 299, 7, 70, "Text",
 CellTags->"b:1.1.0.7",
 CellID->26534],
Cell[22635, 709, 118, 2, 70, "MathCaption",
 CellTags->"b:1.1.0.7",
 CellID->5556],
Cell[CellGroupData[{
Cell[22778, 715, 575, 19, 70, "Input",
 CellTags->"b:1.1.0.7",
 CellID->1993],
Cell[23356, 736, 488, 10, 70, "Message",
 CellTags->"b:1.1.0.7",
 CellID->174982215],
Cell[23847, 748, 486, 10, 70, "Message",
 CellTags->"b:1.1.0.7",
 CellID->3779317],
Cell[24336, 760, 2427, 78, 150, "Output",
 CellTags->"b:1.1.0.7",
 CellID->169854283]
}, Open  ]],
Cell[26778, 841, 90, 2, 70, "MathCaption",
 CellTags->"b:1.1.0.7",
 CellID->10548],
Cell[CellGroupData[{
Cell[26893, 847, 353, 13, 70, "Input",
 CellTags->"b:1.1.0.7",
 CellID->15881],
Cell[27249, 862, 571, 20, 61, "Output",
 CellTags->"b:1.1.0.7",
 CellID->155915744]
}, Open  ]],
Cell[CellGroupData[{
Cell[27857, 887, 72, 1, 70, "RelatedTutorialsSection",
 CellID->260305036],
Cell[27932, 890, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[28136, 897, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

