(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15058,        486]
NotebookOptionsPosition[      9556,        313]
NotebookOutlinePosition[     13439,        424]
CellTagsIndexPosition[     13313,        417]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Bernoulli Equations", "Title",
 CellTags->{"BernoulliODE", "c:12", "b:1.1.0.3"},
 CellID->14413],

Cell[TextData[{
 "A ",
 ButtonBox["Bernoulli equation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveIntroductionToODEs#14708"],
 " ",
 "is a first-order equation of the form "
}], "Text",
 CellID->86130161],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "(", "x", ")"}], "+", 
    RowBox[{
     RowBox[{"P", "(", "x", ")"}], 
     RowBox[{"y", "(", "x", ")"}]}]}], "\[LongEqual]", 
   RowBox[{
    RowBox[{"Q", "(", "x", ")"}], "\[NoBreak]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"y", "(", "x", ")"}], "n"], "."}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellID->59506763],

Cell["\<\
The problem of solving equations of this type was posed by James Bernoulli in \
1695. A year later, in 1696, G. Leibniz showed that it can be reduced to a \
linear equation by a change of variable.\
\>", "Text",
 CellID->468358464],

Cell["Here is an example of a Bernoulli equation.", "MathCaption",
 CellTags->"b:1.1.0.3",
 CellID->16641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqn", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
    RowBox[{"11", "x", "*", 
     RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "*", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "^", "3"}]}]}]}]], "Input",
 CellTags->"b:1.1.0.3",
 CellLabel->"In[1]:=",
 CellID->19855],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"11", " ", "x", " ", 
    RowBox[{"y", "[", "x", "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}]}], "\[Equal]", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   SuperscriptBox[
    RowBox[{"y", "[", "x", "]"}], "3"]}]}]], "Output",
 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.3",
 CellLabel->"Out[1]=",
 CellID->503917553]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", " ", "y", ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:1.1.0.3",
 CellLabel->"In[2]:=",
 CellID->13142],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{"-", 
        FractionBox["11", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{"11", " ", 
            SuperscriptBox["x", "2"]}], "+", 
           RowBox[{"121", " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"11", " ", 
              SuperscriptBox["x", "2"]}]], " ", 
            RowBox[{"C", "[", "1", "]"}]}]}]]]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       FractionBox["11", 
        SqrtBox[
         RowBox[{"1", "+", 
          RowBox[{"11", " ", 
           SuperscriptBox["x", "2"]}], "+", 
          RowBox[{"121", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"11", " ", 
             SuperscriptBox["x", "2"]}]], " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]]]}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{335, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.3",
 CellLabel->"Out[2]=",
 CellID->83040588]
}, Open  ]],

Cell["This verifies that the solution is correct.", "MathCaption",
 CellTags->"b:1.1.0.3",
 CellID->27611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "/.", "sol"}], "//", "Simplify"}]], "Input",
 CellTags->"b:1.1.0.3",
 CellLabel->"In[3]:=",
 CellID->30877],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.3",
 CellLabel->"Out[3]=",
 CellID->31699]
}, Open  ]],

Cell[TextData[{
 "In general, the solution to a Bernoulli equation will consist of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "-", "1"}], TraditionalForm]], "InlineMath"],
 " branches, where ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is the degree of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " in the equation. "
}], "Text",
 CellTags->"b:1.1.0.3",
 CellID->32678],

Cell[TextData[{
 "Here is an example of a Bernoulli equation with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", "5"}], TraditionalForm]], "InlineMath"],
 ". The solution has four branches."
}], "MathCaption",
 CellTags->"b:1.1.0.3",
 CellID->1752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"3", "x", "*", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], " ", "-", 
     RowBox[{"7", "x", "*", 
      RowBox[{"Log", "[", "x", "]"}], "*", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "^", "5"}]}], "-", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", "0"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.0.3",
 CellLabel->"In[4]:=",
 CellID->18443],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{583, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.3",
 CellLabel->"Out[4]=",
 CellID->653222914]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->151017407],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Bernoulli Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveInverseLinearEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveRiccatiEquations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 15.3909212}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "A Bernoulli equation is a first-order equation of the form The problem \
of solving equations of this type was posed by James Bernoulli in 1695. A \
year later, in 1696, G. Leibniz showed that it can be reduced to a linear \
equation by a change of variable. Here is an example of a Bernoulli \
equation.", "synonyms" -> {}, "title" -> "Bernoulli Equations", "type" -> 
    "Tutorial", "uri" -> "tutorial/DSolveBernoulliEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "BernoulliODE"->{
  Cell[1280, 43, 102, 2, 70, "Title",
   CellTags->{"BernoulliODE", "c:12", "b:1.1.0.3"},
   CellID->14413]},
 "c:12"->{
  Cell[1280, 43, 102, 2, 70, "Title",
   CellTags->{"BernoulliODE", "c:12", "b:1.1.0.3"},
   CellID->14413]},
 "b:1.1.0.3"->{
  Cell[1280, 43, 102, 2, 70, "Title",
   CellTags->{"BernoulliODE", "c:12", "b:1.1.0.3"},
   CellID->14413],
  Cell[2315, 82, 106, 2, 70, "MathCaption",
   CellTags->"b:1.1.0.3",
   CellID->16641],
  Cell[2446, 88, 386, 14, 28, "Input",
   CellTags->"b:1.1.0.3",
   CellID->19855],
  Cell[2835, 104, 495, 17, 36, "Output",
   CellTags->"b:1.1.0.3",
   CellID->503917553],
  Cell[3367, 126, 188, 6, 28, "Input",
   CellTags->"b:1.1.0.3",
   CellID->13142],
  Cell[3558, 134, 1251, 40, 105, "Output",
   CellTags->"b:1.1.0.3",
   CellID->83040588],
  Cell[4824, 177, 106, 2, 70, "MathCaption",
   CellTags->"b:1.1.0.3",
   CellID->27611],
  Cell[4955, 183, 148, 5, 70, "Input",
   CellTags->"b:1.1.0.3",
   CellID->30877],
  Cell[5106, 190, 229, 8, 36, "Output",
   CellTags->"b:1.1.0.3",
   CellID->31699],
  Cell[5350, 201, 449, 15, 70, "Text",
   CellTags->"b:1.1.0.3",
   CellID->32678],
  Cell[5802, 218, 251, 8, 70, "MathCaption",
   CellTags->"b:1.1.0.3",
   CellID->1752],
  Cell[6078, 230, 512, 16, 28, "Input",
   CellTags->"b:1.1.0.3",
   CellID->18443],
  Cell[6593, 248, 2620, 48, 143, "Output",
   Evaluatable->False,
   CellTags->"b:1.1.0.3",
   CellID->653222914]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"BernoulliODE", 11863, 365},
 {"c:12", 11984, 369},
 {"b:1.1.0.3", 12110, 373}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 102, 2, 70, "Title",
 CellTags->{"BernoulliODE", "c:12", "b:1.1.0.3"},
 CellID->14413],
Cell[1385, 47, 220, 8, 70, "Text",
 CellID->86130161],
Cell[1608, 57, 460, 16, 70, "DisplayMath",
 CellID->59506763],
Cell[2071, 75, 241, 5, 70, "Text",
 CellID->468358464],
Cell[2315, 82, 106, 2, 70, "MathCaption",
 CellTags->"b:1.1.0.3",
 CellID->16641],
Cell[CellGroupData[{
Cell[2446, 88, 386, 14, 28, "Input",
 CellTags->"b:1.1.0.3",
 CellID->19855],
Cell[2835, 104, 495, 17, 36, "Output",
 CellTags->"b:1.1.0.3",
 CellID->503917553]
}, Open  ]],
Cell[CellGroupData[{
Cell[3367, 126, 188, 6, 28, "Input",
 CellTags->"b:1.1.0.3",
 CellID->13142],
Cell[3558, 134, 1251, 40, 105, "Output",
 CellTags->"b:1.1.0.3",
 CellID->83040588]
}, Open  ]],
Cell[4824, 177, 106, 2, 70, "MathCaption",
 CellTags->"b:1.1.0.3",
 CellID->27611],
Cell[CellGroupData[{
Cell[4955, 183, 148, 5, 70, "Input",
 CellTags->"b:1.1.0.3",
 CellID->30877],
Cell[5106, 190, 229, 8, 36, "Output",
 CellTags->"b:1.1.0.3",
 CellID->31699]
}, Open  ]],
Cell[5350, 201, 449, 15, 70, "Text",
 CellTags->"b:1.1.0.3",
 CellID->32678],
Cell[5802, 218, 251, 8, 70, "MathCaption",
 CellTags->"b:1.1.0.3",
 CellID->1752],
Cell[CellGroupData[{
Cell[6078, 230, 512, 16, 28, "Input",
 CellTags->"b:1.1.0.3",
 CellID->18443],
Cell[6593, 248, 2620, 48, 143, "Output",
 Evaluatable->False,
 CellTags->"b:1.1.0.3",
 CellID->653222914]
}, Open  ]],
Cell[CellGroupData[{
Cell[9250, 301, 72, 1, 70, "RelatedTutorialsSection",
 CellID->151017407],
Cell[9325, 304, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[9529, 311, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

