(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9848,        318]
NotebookOptionsPosition[      5698,        191]
NotebookOutlinePosition[      8940,        284]
CellTagsIndexPosition[      8821,        277]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Chini Equations", "Title",
 CellTags->{"ChiniODE", "c:17", "b:1.1.0.8"},
 CellID->12673],

Cell[TextData[{
 ButtonBox["Chini equations",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveIntroductionToODEs#14708"],
 " are a generalization of Abel and Riccati equations. "
}], "Text",
 CellTags->"b:1.1.0.8",
 CellID->10040],

Cell["This solves a Chini equation.", "MathCaption",
 CellTags->"b:1.1.0.8",
 CellID->9313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"5", "*", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "^", "4"}]}], "+", " ", 
     RowBox[{"3", "*", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "/", "3"}], ")"}]}]}]}]}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.0.8",
 CellLabel->"In[1]:=",
 CellID->875],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/tdep\\\", \
ButtonNote -> \\\"Solve::tdep\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:1.1.0.8",
 CellLabel->"During evaluation of In[1]:=",
 CellID->109477152],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/tdep\\\", \
ButtonNote -> \\\"Solve::tdep\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:1.1.0.8",
 CellLabel->"During evaluation of In[1]:=",
 CellID->489731602],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "45"}], " ", 
     RowBox[{"RootSum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "45"}], "+", 
         RowBox[{
          SuperscriptBox["3", 
           RowBox[{"1", "/", "4"}]], " ", 
          SuperscriptBox["5", 
           RowBox[{"3", "/", "4"}]], " ", "#1"}], "-", 
         RowBox[{"45", " ", 
          SuperscriptBox["#1", "4"]}]}], "&"}], ",", 
       RowBox[{
        FractionBox[
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"-", "#1"}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              FractionBox["5", "3"], ")"}], 
             RowBox[{"1", "/", "4"}]], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              SuperscriptBox["x", 
               RowBox[{"4", "/", "3"}]], ")"}], 
             RowBox[{"1", "/", "4"}]], " ", 
            RowBox[{"y", "[", "x", "]"}]}]}], "]"}], 
         RowBox[{
          RowBox[{
           SuperscriptBox["3", 
            RowBox[{"1", "/", "4"}]], " ", 
           SuperscriptBox["5", 
            RowBox[{"3", "/", "4"}]]}], "-", 
          RowBox[{"180", " ", 
           SuperscriptBox["#1", "3"]}]}]], "&"}]}], "]"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["3", 
        RowBox[{"3", "/", "4"}]], " ", 
       SuperscriptBox["5", 
        RowBox[{"1", "/", "4"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox["x", 
          RowBox[{"4", "/", "3"}]], ")"}], 
        RowBox[{"1", "/", "4"}]], " ", 
       RowBox[{"Log", "[", "x", "]"}]}], 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "3"}]]]}]}], ",", 
   RowBox[{"y", "[", "x", "]"}]}], "]"}]], "Output",
 ImageSize->{527, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.8",
 CellLabel->"Out[1]=",
 CellID->124696533]
}, Open  ]],

Cell["This concludes the discussion of first-order ODEs. ", "Text",
 CellTags->"b:1.1.0.8",
 CellID->1017],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->319377499],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Chini Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveAbelEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveIntroductionToLinearSecondOrderODEs"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 15.6721784}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Chini equations are a generalization of Abel and Riccati equations. This \
solves a Chini equation. This concludes the discussion of first-order ODEs. ",
     "synonyms" -> {}, "title" -> "Chini Equations", "type" -> "Tutorial", 
    "uri" -> "tutorial/DSolveChiniEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "ChiniODE"->{
  Cell[1280, 43, 94, 2, 70, "Title",
   CellTags->{"ChiniODE", "c:17", "b:1.1.0.8"},
   CellID->12673]},
 "c:17"->{
  Cell[1280, 43, 94, 2, 70, "Title",
   CellTags->{"ChiniODE", "c:17", "b:1.1.0.8"},
   CellID->12673]},
 "b:1.1.0.8"->{
  Cell[1280, 43, 94, 2, 70, "Title",
   CellTags->{"ChiniODE", "c:17", "b:1.1.0.8"},
   CellID->12673],
  Cell[1377, 47, 240, 7, 70, "Text",
   CellTags->"b:1.1.0.8",
   CellID->10040],
  Cell[1620, 56, 91, 2, 70, "MathCaption",
   CellTags->"b:1.1.0.8",
   CellID->9313],
  Cell[1736, 62, 520, 18, 70, "Input",
   CellTags->"b:1.1.0.8",
   CellID->875],
  Cell[2259, 82, 487, 10, 70, "Message",
   CellTags->"b:1.1.0.8",
   CellID->109477152],
  Cell[2749, 94, 487, 10, 19, "Message",
   CellTags->"b:1.1.0.8",
   CellID->489731602],
  Cell[3239, 106, 2007, 64, 100, "Output",
   CellTags->"b:1.1.0.8",
   CellID->124696533],
  Cell[5261, 173, 106, 2, 70, "Text",
   CellTags->"b:1.1.0.8",
   CellID->1017]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"ChiniODE", 7851, 241},
 {"c:17", 7967, 245},
 {"b:1.1.0.8", 8088, 249}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 94, 2, 70, "Title",
 CellTags->{"ChiniODE", "c:17", "b:1.1.0.8"},
 CellID->12673],
Cell[1377, 47, 240, 7, 70, "Text",
 CellTags->"b:1.1.0.8",
 CellID->10040],
Cell[1620, 56, 91, 2, 70, "MathCaption",
 CellTags->"b:1.1.0.8",
 CellID->9313],
Cell[CellGroupData[{
Cell[1736, 62, 520, 18, 70, "Input",
 CellTags->"b:1.1.0.8",
 CellID->875],
Cell[2259, 82, 487, 10, 70, "Message",
 CellTags->"b:1.1.0.8",
 CellID->109477152],
Cell[2749, 94, 487, 10, 19, "Message",
 CellTags->"b:1.1.0.8",
 CellID->489731602],
Cell[3239, 106, 2007, 64, 100, "Output",
 CellTags->"b:1.1.0.8",
 CellID->124696533]
}, Open  ]],
Cell[5261, 173, 106, 2, 70, "Text",
 CellTags->"b:1.1.0.8",
 CellID->1017],
Cell[CellGroupData[{
Cell[5392, 179, 72, 1, 70, "RelatedTutorialsSection",
 CellID->319377499],
Cell[5467, 182, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[5671, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

