(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16163,        457]
NotebookOptionsPosition[     11363,        312]
NotebookOutlinePosition[     14925,        411]
CellTagsIndexPosition[     14800,        404]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Clairaut Equations", "Title",
 CellTags->{"ClairautODE", "c:15", "b:1.1.0.6"},
 CellID->14932],

Cell[TextData[{
 "A ",
 ButtonBox["Clairaut equation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveIntroductionToODEs#14708"],
 " is a first-order equation of the form "
}], "Text",
 CellID->86130161],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox[
    RowBox[{
     RowBox[{"y", "(", "x", ")"}], "\[LongEqual]", 
     RowBox[{"x", 
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "(", "x", ")"}]}]}],
    TraditionalForm], "+", 
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "(", "x", ")"}], ")"}], "."}]}], 
  TraditionalForm]], "DisplayMath",
 CellID->59506763],

Cell["\<\
A remarkable feature of this nonlinear equation is that its general solution \
has a very simple form.\
\>", "Text",
 CellID->468358464],

Cell[TextData[{
 "This is an example of a Clairaut equation. The warning message from ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 StyleBox[" can be ignored. It is given because ", "MathCaption"],
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " first tries to find an expression for ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["y", "\[Prime]",
    MultilineFunction->None], "[", "x", "]"}]]],
 " from the given ODE."
}], "MathCaption",
 CellTags->"b:1.1.0.6",
 CellID->28112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{"x", "*", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}]}], " ", "+", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "^", "2"}], " ", "+", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "]"}]}]}], " ", ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:1.1.0.6",
 CellLabel->"In[1]:=",
 CellID->30695],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/tdep\\\", \
ButtonNote -> \\\"Solve::tdep\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:1.1.0.6",
 CellLabel->"During evaluation of In[1]:=",
 CellID->815757520],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"C", "[", "1", "]"}]], "+", 
     RowBox[{"x", " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     SuperscriptBox[
      RowBox[{"C", "[", "1", "]"}], "2"]}]}], "}"}], "}"}]], "Output",
 ImageSize->{201, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.6",
 CellLabel->"Out[1]=",
 CellID->78064495]
}, Open  ]],

Cell["\<\
The general solution to Clairaut equations is simply a family of straight \
lines.\
\>", "Text",
 CellTags->"b:1.1.0.6",
 CellID->20040],

Cell[TextData[{
 "This plots the solution for several values of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 StyleBox[".", "TR"]
}], "MathCaption",
 CellTags->"b:1.1.0.6",
 CellID->26488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "[", "x", "]"}], "/.", "sol"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "\[Rule]", " ", 
         RowBox[{"1", "/", "k"}]}], "}"}]}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"k", ",", 
        RowBox[{"-", "5"}], ",", "5", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
   " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:1.1.0.6",
 CellLabel->"In[2]:=",
 CellID->28685],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 219},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.6",
 CellLabel->"Out[2]=",
 CellID->155159639]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->449909199],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Clairaut Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveExactEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveAbelEquations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 16.1721912}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "A Clairaut equation is a first-order equation of the form A remarkable \
feature of this nonlinear equation is that its general solution has a very \
simple form. This is an example of a Clairaut equation. The warning message \
from Solve can be ignored. It is given because DSolve first tries to find an \
expression for y^,[x] from the given ODE.", "synonyms" -> {}, "title" -> 
    "Clairaut Equations", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveClairautEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "ClairautODE"->{
  Cell[1280, 43, 100, 2, 70, "Title",
   CellTags->{"ClairautODE", "c:15", "b:1.1.0.6"},
   CellID->14932]},
 "c:15"->{
  Cell[1280, 43, 100, 2, 70, "Title",
   CellTags->{"ClairautODE", "c:15", "b:1.1.0.6"},
   CellID->14932]},
 "b:1.1.0.6"->{
  Cell[1280, 43, 100, 2, 70, "Title",
   CellTags->{"ClairautODE", "c:15", "b:1.1.0.6"},
   CellID->14932],
  Cell[2228, 81, 620, 19, 70, "MathCaption",
   CellTags->"b:1.1.0.6",
   CellID->28112],
  Cell[2873, 104, 589, 19, 70, "Input",
   CellTags->"b:1.1.0.6",
   CellID->30695],
  Cell[3465, 125, 487, 10, 19, "Message",
   CellTags->"b:1.1.0.6",
   CellID->815757520],
  Cell[3955, 137, 512, 17, 39, "Output",
   CellTags->"b:1.1.0.6",
   CellID->78064495],
  Cell[4482, 157, 146, 5, 70, "Text",
   CellTags->"b:1.1.0.6",
   CellID->20040],
  Cell[4631, 164, 282, 10, 70, "MathCaption",
   CellTags->"b:1.1.0.6",
   CellID->26488],
  Cell[4938, 178, 637, 21, 28, "Input",
   CellTags->"b:1.1.0.6",
   CellID->28685],
  Cell[5578, 201, 5442, 94, 240, "Output",
   Evaluatable->False,
   CellTags->"b:1.1.0.6",
   CellID->155159639]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"ClairautODE", 13694, 364},
 {"c:15", 13814, 368},
 {"b:1.1.0.6", 13939, 372}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 100, 2, 70, "Title",
 CellTags->{"ClairautODE", "c:15", "b:1.1.0.6"},
 CellID->14932],
Cell[1383, 47, 214, 7, 70, "Text",
 CellID->86130161],
Cell[1600, 56, 476, 17, 70, "DisplayMath",
 CellID->59506763],
Cell[2079, 75, 146, 4, 70, "Text",
 CellID->468358464],
Cell[2228, 81, 620, 19, 70, "MathCaption",
 CellTags->"b:1.1.0.6",
 CellID->28112],
Cell[CellGroupData[{
Cell[2873, 104, 589, 19, 70, "Input",
 CellTags->"b:1.1.0.6",
 CellID->30695],
Cell[3465, 125, 487, 10, 19, "Message",
 CellTags->"b:1.1.0.6",
 CellID->815757520],
Cell[3955, 137, 512, 17, 39, "Output",
 CellTags->"b:1.1.0.6",
 CellID->78064495]
}, Open  ]],
Cell[4482, 157, 146, 5, 70, "Text",
 CellTags->"b:1.1.0.6",
 CellID->20040],
Cell[4631, 164, 282, 10, 70, "MathCaption",
 CellTags->"b:1.1.0.6",
 CellID->26488],
Cell[CellGroupData[{
Cell[4938, 178, 637, 21, 28, "Input",
 CellTags->"b:1.1.0.6",
 CellID->28685],
Cell[5578, 201, 5442, 94, 240, "Output",
 Evaluatable->False,
 CellTags->"b:1.1.0.6",
 CellID->155159639]
}, Open  ]],
Cell[CellGroupData[{
Cell[11057, 300, 72, 1, 70, "RelatedTutorialsSection",
 CellID->449909199],
Cell[11132, 303, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[11336, 310, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

