(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     83452,       1668]
NotebookOptionsPosition[     77543,       1474]
NotebookOutlinePosition[     81591,       1596]
CellTagsIndexPosition[     81466,       1589]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Exact Equations", "Title",
 CellTags->{"ExactODE", "c:14", "b:1.1.0.5"},
 CellID->503],

Cell[TextData[{
 "Here is an example of an ",
 ButtonBox["exact ODE",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveIntroductionToODEs#14708"],
 "."
}], "MathCaption",
 CellTags->"b:1.1.0.5",
 CellID->21221],

Cell[BoxData[
 RowBox[{
  RowBox[{"P", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"5", 
      RowBox[{"x", "^", "2"}]}], "-", 
     RowBox[{"2", 
      RowBox[{"y", "^", "2"}]}], "+", "11"}], ")"}]}]}]], "Input",
 CellTags->"b:1.1.0.5",
 CellLabel->"In[1]:=",
 CellID->22663],

Cell[BoxData[
 RowBox[{
  RowBox[{"Q", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Sin", "[", "y", "]"}], "+", 
    RowBox[{"4", "x", "*", "y"}], "+", "3"}], ")"}]}]], "Input",
 CellTags->"b:1.1.0.5",
 CellLabel->"In[2]:=",
 CellID->5706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"P", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}], " ", "-", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Q", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "]"}]], "Input",
 CellTags->"b:1.1.0.5",
 CellLabel->"In[3]:=",
 CellID->2363],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.5",
 CellLabel->"Out[3]=",
 CellID->332943462]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqn", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"P", "[", 
      RowBox[{"x", ",", 
       RowBox[{"y", "[", "x", "]"}]}], "]"}]}], "/", 
    RowBox[{"Q", "[", 
     RowBox[{"x", ",", 
      RowBox[{"y", "[", "x", "]"}]}], "]"}]}]}]}]], "Input",
 CellTags->"b:1.1.0.5",
 CellLabel->"In[4]:=",
 CellID->22171],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["y", "\[Prime]",
    MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
  FractionBox[
   RowBox[{"11", "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"y", "[", "x", "]"}], "2"]}]}], 
   RowBox[{"3", "+", 
    RowBox[{"Sin", "[", 
     RowBox[{"y", "[", "x", "]"}], "]"}], "+", 
    RowBox[{"4", " ", "x", " ", 
     RowBox[{"y", "[", "x", "]"}]}]}]]}]], "Output",
 ImageSize->{200, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.5",
 CellLabel->"Out[4]=",
 CellID->201305172]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", " ", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:1.1.0.5",
 CellLabel->"In[5]:=",
 CellID->18240],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/tdep\\\", \
ButtonNote -> \\\"Solve::tdep\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:1.1.0.5",
 CellLabel->"During evaluation of In[5]:=",
 CellID->451690273],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "11"}], " ", "x"}], "-", 
     FractionBox[
      RowBox[{"5", " ", 
       SuperscriptBox["x", "3"]}], "3"], "-", 
     RowBox[{"Cos", "[", 
      RowBox[{"y", "[", "x", "]"}], "]"}], "+", 
     RowBox[{"3", " ", 
      RowBox[{"y", "[", "x", "]"}]}], "+", 
     RowBox[{"2", " ", "x", " ", 
      SuperscriptBox[
       RowBox[{"y", "[", "x", "]"}], "2"]}]}], "\[Equal]", 
    RowBox[{"C", "[", "1", "]"}]}], ",", 
   RowBox[{"y", "[", "x", "]"}]}], "]"}]], "Output",
 ImageSize->{401, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.5",
 CellLabel->"Out[5]=",
 CellID->94912635]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
 CellTags->"b:1.1.0.5",
 CellID->7619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"sol", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", " ", 
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellTags->"b:1.1.0.5",
 CellLabel->"In[6]:=",
 CellID->20913],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{"11", "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["x", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"y", "[", "x", "]"}], "2"]}]}], 
     RowBox[{"3", "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"y", "[", "x", "]"}], "]"}], "+", 
      RowBox[{"4", " ", "x", " ", 
       RowBox[{"y", "[", "x", "]"}]}]}]]}], "}"}], "}"}]], "Output",
 ImageSize->{227, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.5",
 CellLabel->"Out[6]=",
 CellID->355493154]
}, Open  ]],

Cell["Here is a contour plot of the solution.", "MathCaption",
 CellTags->"b:1.1.0.5",
 CellID->6704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"sol", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "\[Rule]", " ", "y"}], "}"}]}], "]"}], 
   ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:1.1.0.5",
 CellLabel->"In[7]:=",
 CellID->31818],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFfQVYVUv3Ph3ncA4nUDGxMMDEwED3YHcrdnd3B3ZgYYuBXdfEzj3XxEQM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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVDtoVFEQvbrvd6OmEsVsZZs0FoKtYmnnro3pbET8g2iUzSZqJJBsYRXB
PoVFbPSBhcEPmDWIIpIs+GkUs8FgRBEhhYLncM6SYnizc+dz5szM7j1x/ui5
rSGEC5AKJElDGIYcgb6ahFDi8T5kFvoGHC5DlrIQliFzsD+H/TG+M/D/Bf1n
In/61fEd3iIfxtDvFmSC+WC/4nz04ds8ZBJ52vBdyFSb+stMPsTTtr3uGjXj
Kx07kMqfvsxP3PTbHUM42xdCB2/78PsN7Mfh38hDaEFmoa/AdhjxX/F95Roj
QT3NpcrZQPwYZMp4l8wD9T8VYWGOH4nyMAdz3QP+bqLeifkpap6Oiq2mwsoe
6b/gfr/D/0CmONYcd91++J9MxfmjQj0Qf+k65GE9UTxrEQfxTENvQRbN/z/E
/oUsJ8rXSTWrz8D1Jeo3e1/1TMlr29zOm3fW2kluC9Xjjqy77gzsdyA3U/XU
dl8XMYf9UX1cR9zbQtyV7p09ECt7PhXESc2zIBfMdww+e5BjLRdG7mPHs8iQ
bwRvgxXlJVbah2AfLDb3bsP7cwa2XVEcjXo/uBt9sL+Pm/vy2jvzDDVvFIon
j5wp8XyE7UGuGbXMO/sgv/2eV4n3ZiE7+eS+kpOa74I9cqeImTfBmonv8QOw
/C6EZQf07VE7exXfa1F3+w75h6JibhfigjxwNl3PpZmpzx5O9kD83Mcnubgi
rqqxTfhuia3hWPLwMFfPU8bO/MzDWbAH7tI3vK9BXkC/W2jenMlB1DoUVWe0
ENfkmXxvs07+WuZ20Vi5D5ztpVx9rfjO6MMbHfCdEmPDPX7KtXO9uyEuzoK7
VvfNjPuuezcy7VpVYoz6bxtzTtp5l9zDrms1vTf/AZrmxzs=
         "],
         VertexColors->None], 
        PolygonBox[{{2647, 2173, 816, 1662}, {1932, 2301, 1237, 165}, {2668, 
         2327, 1750, 1749}, {2617, 2454, 1411, 1591}, {2174, 2648, 1664, 
         651}, {2648, 1972, 650, 1664}, {2494, 2368, 1306, 1453}, {2369, 2041,
          1307, 1306}, {2347, 2425, 1371, 1284}, {2255, 2331, 1265, 686}, {
         2530, 2328, 1218, 1494}, {2026, 2494, 1453, 1264}, {1983, 2202, 1013,
          685}, {2356, 2434, 1383, 1294}, {1926, 2192, 810, 75}, {2059, 2522, 
         1230, 816}, {2282, 2232, 165, 1221}, {2300, 2012, 1294, 1237}, {2455,
          2263, 341, 1411}, {2407, 2156, 1262, 1347}, {2669, 1984, 685, 
         1750}, {2256, 2255, 686, 1013}, {2290, 2002, 1284, 1229}, {2330, 
         2329, 1264, 1265}, {2434, 2529, 1494, 1383}, {2090, 2248, 1189, 
         887}, {2325, 2324, 1260, 1261}, {2263, 2317, 1253, 341}, {1971, 2647,
          1662, 650}, {2157, 2617, 1591, 1260}, {2326, 1973, 651, 1262}, {
         2426, 1926, 75, 1371}, {2041, 2091, 887, 1307}, {2316, 2407, 1347, 
         1253}, {2248, 1985, 1016, 1189}, {2328, 2668, 1749, 1218}, {2291, 
         2290, 1229, 1230}, {2178, 2325, 1261, 1016}},
         VertexColors->None]}]}, 
     {RGBColor[
      0.43738380078346417`, 0.30772552489802196`, 0.7317761602193147], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNll1olmUYx5/2vs+e55l10qcuDDpwotOS6EDd0EUpzFREQTcLZ53MQHMF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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllEtszFEUxm/mP9P//07Z0BCExEKinXpE7FhUwgIViY2GhLAiVEM0KG1C
0oTGQjwqEY+FWBAbOtMpiWhJFwhT09SrJFWbzmAqKerVxu/LWXzJd8537r3n
nnvOnb+zYdO+mHNuI4iDh6Fze7xz6xLONeIowe9FzrXDP+Hrgx8HWezbwMOv
gqPwZ+hJeDMoBc69wF7O+v1J51LsW4OvDO0M2EV8L3or/jwxPfAVygHtMmhC
f4QvgL9E705YzBXs9dgLEnZmPXvPxB6Fr8XXgp5hz2+cNQrKsd+iP0fLgRL2
A/CYs56wJoK/QX+KVucsVndQ7lqzFLsZbINHYDV8gv3nBpbjPGLH8J1F24pv
FbwGTFLUadjV5FcFMvDKMueWobWA7cSXg0PeaqC712GnsPPYH1ifYs1n7AKo
hX9EnwHfq5oEdseF2DniXxNfiT0JX+MtF+Wo2r/HV4jZG/xi7bjWk3s+brn8
jowrp4vY7cqBtXfxZdDSoNXZHU6hndSbEnsgYb1R9JabeuQYZ3ThuwDfje8H
/DvIYfeBf/AJ8CpuOXV56zH11nVQZP0s7PHAatgJH8Q3Ar+Prw3+l/X9ccsp
C08lrbbn8KWJHwID7HUNnA4tJ+WiMxehVXt7a+XUCO/3VvvNem/2WgJKMbuj
eqXN213VM1nNg7dcFdPB3oPEdMat5zvQMt7OVs5T4FO91VJvdpD4w9hb0Fey
X5Xyj6xX7hD/BW069nnih4m5iX3LW2564zG0d956WT0yrNp7my3NgO6umqgW
qsFi7rIjstppzxvoDaA3Zj2rXhgIrbfVE5rtS5HNvma81luPqbc0c5qFn5G9
pWaiCC+ADYG9eRP6EW+9qxnXX9Id2mzqT1Gt0qHNpmpWj11BzEhgPfdH8xja
bOiNNfv6E/QX6A/QrOrP0V+jmVUt9afoL1FNNStfvdVOM3MCrSe02uqM2Whz
vP1d6rH/nHHAgg==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5995261405685849, 0.5849338753035778, 0.9103127115747968], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3mUVcW1xu907jmnMcGI0mgEhAb1RUAcGBzAgalxYmgUQV9sBIkQVNSg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mUVcURxu+8d9/c7ocruMR4ZBsEVNYBUXYXEAnmIARQQQ6ICMGYwEBQ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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7281919164140932, 0.7916639754543816, 0.9132458949680685], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3e4FdW5xmfXmdkqTQHpRcUDsYSm0lRQNIkdAU0EETiHEqSjooCiJtFE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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3m0V1UVxy+/e9/vnnNTGQxEIOUxWqkEgsQsT0X9w4EHGFQLlcHASgSe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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8472529649153034, 0.8752171704671493, 0.8761204355504478], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmG2MVeURx4/3nnvOPVd31RqRNrFVKy9WBQ1K/eALu9s0kXV3qf2gmN1t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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlElI1VEUxv/0fO9/7yMtG0jCCmmwCSVKc9EkQdFgmi2CeLooCMsyqNxk
YuBESkHQpgwqpZGKpk2DBSUVUVBkioJEpBZUi0ZbNP0+josPzne/c889955z
bsbmXcUVI4IgKAVJYJwLgjOgBtIdDYLZPghehkHQi9PMSBDUo92CL4kFwTp8
ZqG/gPegz0VfCT8PjrL3D/pO7Dr2rIWvAc/xjTqL9Re9B34Nnxa0AWJMREuB
V6MXgXfwi2AKud3HvwBtHYjhX8JaKtoRsB1tDmtv0GrAFuxOsBG7BORhHyXn
/djN+LcRO8FaFvwKCKMWcyRaITwT+xWojJOfs7NKyHU92mh4fsTeqIu1q6wd
j9qehfg/Qr/BXXI4bw12Oz4X4E9BLvp2Z9oC0IhWCRax9zZ8K3oF+k18r8Gb
iZ1g7SB2N5iE/Rv/NM5Pgw/g2w8y4YfJJ4H/Dm9vrTuvwu4EHdjTwGp877D/
LPEfg7XwscRMJlYKuITvZW++qqn2XnUWWzHusvcAPDVid5qHnqx6osV1B/Qa
+OiInTEfvTe02urN9Pa7OW9eaDV4C+8Dl9DbOaOZ9X2gLGo1HeWspqqlekRv
3R3aWXpzxWrCpzViMbvRX3vrxSfov7z1gGr/Gb4J/wJnd2+IWa8MedPUMznY
fcT5iL6cGBXwWme5FaC3orWw1hi1Hl3hrefV69mB1X4y/FuS9UAb/APogDeh
D7E/jxxyY/ZGmq098MXDM3YS31MggX8V/mVo2+LWG89YK0ZLh0+I2Uyc8NYj
6g3lNB1tBsiIWY/sctZT6iXVbC/2F2exdGadt5nXrJeDQWczpVl6iE8Wdow9
f+H/QJG3HJWbat6KfdrZ3ZRzA3q9t9kthzv2hqAwYjH0F+hN9Zb6E8ag/YB/
iloPTsJOB1+T7A0fhFYz1Uozcd3ZTGoWVXP9RV3eaq0/6Zy3P0Z/i/6gZXH7
s/RXLUUvdzaDmj3V4L2zO+uuqlG2tz9As68/4Sf8OyiNWI7T2Ds1brXWG9/j
rGPOZls9rNw1U5ol3UGzXeXtr9GMv8Mej96r+QJp2IdCeyu9kWq7wdlsq8Y6
Oz9uuSuHWm89qt7UjPR7q5Fqo5gD8EFvsdXD1cM1Vm3PkvN/oyzDKQ==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVDtoVFEQvfv27b73loiilipYxkoQdAtFrUw0FruIgp/GwiJqUrhgLEKE
xE9jCi1MjEWSjRZ+YC3XH2KRWAXBHwoSDNrEJglqLD2Hc8JaDHfu3LkzZ87M
vVtP91Z7ohDCECQPuVkMYaYQwgSMV9IQ9pWkP8lC+JyE0I6zu5A1kDZIIQ6h
ExJDOqzfiGQvWm8misU4PC/YXrPPMPRunO9ErlmAuJDXeiQXwkbYh5D7APYf
M8ViHNr6E9mHne9SULy9/2GIbWfss6nijkIuwl5hHKzL2B9FrjtYy9ZvFVXP
buwHsS4ZT8M+jNkXqwbmfwYsB1PFnvUd+vfAdga538FWhd9UTvZ63KqV9jc+
q+XlSwxciY86+7IAvqcLLa6vA0PT9bJu1jSRV1305R1y9RtcrQeGyUjnU7Hy
MAbrZJzxvDARz4zvMtdtSATJQTYgRlcq3/mi7pKfr7B9S4WFXD6MxeU0bLtK
ikuemsbJ87G8fMjrA+xHsJ4CzmOQ7QVxfD+n2qk3vKcvOab/T/gtmZfFonTW
yBrqkfTvwPAD8ipW3eS05vNF+9fN/YmgmAue/2nrtL9Afw+lwn0NZ1cj4WEs
6uSc+Xl/Mmph4t2ya+WccB2zzrXP89PpnrK3rL/DM7wCPgYy8cw56k1Vw3Ho
rxP1swfnQ6nm4HCqM9qXnXeVQ+bh3BIva+iG/hh3H2Xqc9Fvk35zsK1NlZc9
+eu+tPvdc2YGU+Vm3qo5YMwPsH3KNEfklfxy5n/B9icTR+SGdvLD+uZc471U
b57vmnwuur+cu02ZZo/rZutv+SdlrRnl2oWYDfi/h30P9P0l5WZe8nTemJc8
R8TG91c1/tU/jnWyx+SLHA7g7tNE9/j/beP7MJ8181z3/DHmOeQ5mamPHe4r
a2zz/8m7I/6PyN2I/wLeHfffwFma8btnXeuAoZIp95ZMb6zud9zuvlQ8n6xl
wvNO2xdg35Ep92Xce55oRsrgZyXRn8U48441Cp+Xid5u1fgYh7x2mtt/ANTP
Ig==
         "],
         VertexColors->None], 
        PolygonBox[{{2615, 2154, 974, 1187}, {1978, 2253, 1194, 1009}, {2212, 
         2213, 839, 151}, {2550, 2549, 674, 1515}, {1988, 2125, 929, 1143}, {
         1989, 2201, 1140, 1144}, {2377, 2378, 1281, 61}, {2552, 2551, 828, 
         1328}, {1982, 2269, 1209, 1140}, {2055, 2517, 1479, 76}, {1980, 2254,
          1195, 1010}, {2385, 2212, 151, 1322}, {2396, 2397, 1328, 653}, {
         2063, 2670, 1762, 828}, {2476, 2000, 1282, 1431}, {2254, 1981, 923, 
         1195}, {2519, 2518, 673, 1479}, {2413, 2412, 653, 1087}, {2277, 2224,
          61, 1216}, {2009, 2482, 1436, 1321}, {2040, 2176, 1010, 1156}, {
         2039, 2175, 1009, 1155}, {2253, 1979, 921, 1194}, {2273, 2179, 1087, 
         1209}, {2155, 2616, 1155, 974}, {2345, 2055, 76, 1282}, {2578, 2579, 
         928, 674}, {2122, 1988, 1143, 921}, {2123, 1989, 1144, 923}, {2670, 
         2481, 1321, 1762}, {2624, 2625, 1515, 673}, {2247, 2158, 979, 
         1188}, {2482, 2010, 1293, 1436}, {2355, 2064, 1322, 1293}, {2159, 
         2040, 1156, 979}, {1986, 2247, 1188, 929}, {2378, 2477, 1431, 
         1281}, {2333, 2334, 1187, 928}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1917, 2436, 2068, 2213, 2212, 2385, 2064, 2355, 2010, 2482, 
         2009, 2481, 2670, 2063, 2527, 2431, 2551, 2552, 2391, 2397, 2396, 
         2412, 2413, 2180, 2414, 2179, 2273, 2269, 1982, 2201, 1989, 2123, 
         1981, 2254, 1980, 2176, 2040, 2159, 2662, 2158, 2247, 1986, 2650, 
         2125, 1988, 2122, 1979, 2253, 1978, 2175, 2039, 2616, 2155, 2614, 
         2154, 2615, 2246, 2334, 2333, 2332, 2124, 2579, 2578, 2549, 2550, 
         2548, 2625, 2624, 2181, 1977, 2518, 2519, 2517, 2055, 2345, 2000, 
         2476, 2477, 2378, 2377, 2516, 2224, 2277, 2276}],
        "200"],
       Annotation[#, 200, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1920, 2652, 2443, 2460, 2459, 1954, 2318, 2074, 2544, 2437, 
         2438, 1933, 2072, 2543, 2073, 2567, 2568, 2566, 2094, 2532, 2069, 
         2531, 2534, 2533, 2303, 2302, 2013, 2357, 2435, 1914, 1931, 2193, 
         2065, 2278, 2279, 2280, 2211, 2230, 2209, 2210, 2182, 2208, 2207, 
         2384, 2061, 2353, 2007, 2480, 2006, 2383, 2060, 2351, 2003, 2478, 
         2350, 2382, 2381, 2523, 2225, 2677, 2226, 2126, 2270, 2186, 2674, 
         2187, 2428, 2427, 1909, 1927, 2665, 2664, 2289, 2676, 2288, 2675, 
         2001, 2346, 1906, 2627, 2053, 1997, 2471, 2472, 2375, 2374, 2510, 
         2223, 2595, 2596, 2594, 2598, 2597, 2044, 2589, 2131, 2588, 2130, 
         2218, 2275, 2274}],
        "100"],
       Annotation[#, 100, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1987, 2016, 2633, 1937, 2032, 1994, 2653, 1995, 2043, 2108, 
         2642, 1960, 2242, 2149, 2085, 1945, 2244, 2083, 2557, 2084, 2554, 
         2556, 2555, 2623, 2410, 2394, 2395, 2559, 2558, 2086, 2312, 2392, 
         2634, 1939, 2393, 1940, 2022, 2493, 2023, 2503, 2504, 2500, 2502, 
         2501, 1947, 2366, 2367, 2365, 2364, 2313, 2024, 2080, 2635, 1941, 
         2216, 1942, 2636, 2150, 2261, 2260, 1963, 2644, 2171, 2049, 2512, 
         2050, 2376, 2017, 2358, 2360, 2359, 1970, 2222, 2388, 2389, 2387, 
         2077, 2390, 2287, 2194, 1946, 2262, 2151, 2404, 2152, 2401, 2403, 
         2402, 1938, 2243, 2311, 2310, 2309, 2079, 2136, 2626, 1903, 2361, 
         2336, 2337, 2335, 2339, 2338, 2343, 1996, 2165, 2640, 1957, 2257, 
         2128, 2660, 2129, 2021, 2184, 2183}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1992, 2020, 2638, 1944, 2036, 1943, 2637, 2019, 1956, 2639, 
         2030, 1961, 2265, 1962, 2643, 2170, 2319, 1955, 2238, 2575, 2117, 
         2574, 2118, 2576, 1967, 2466, 2119, 2577, 2439, 2470, 1991, 2651, 
         2467, 1974, 2649, 2038, 2198, 2268, 1975, 2200, 2215, 2214, 2508, 
         2509, 2465, 2464, 2463, 2035, 2507, 2095, 2034, 2646, 1966, 2037, 
         1965, 2645, 2033, 2031, 2497, 2499, 2498, 1969, 2266, 1968, 2199, 
         2029, 2363, 1934, 2362, 2305, 2304, 2283, 1990, 2491, 2492, 2490, 
         2018, 2610, 2611, 2400, 2147, 2609, 2258, 2259, 2164, 2408, 2163, 
         2409, 2249, 2240, 2241, 2082, 2553, 2081, 2569, 2096, 1935, 1921, 
         2631, 2306, 2284, 2321, 2320, 2323, 2322, 2167, 2641, 1959, 2264, 
         1958, 2197, 2307, 2191, 2190}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2370, 2341, 2342, 2340, 1993, 2583, 2584, 2580, 2582, 2581, 
         2217, 2127, 2585, 2587, 2586, 2042, 2592, 2133, 2590, 2132, 2591, 
         2219, 2134, 2593, 2135, 2221, 2220, 2418, 2417, 2416, 2137, 2599, 
         2047, 2511, 2048, 2419, 2420, 1905, 2560, 1907, 2185, 2087, 2452, 
         2453, 1948, 2245, 1949, 2107, 2571, 2573, 2572, 2104, 2106, 2671, 
         2105, 2168, 2109, 2658, 2110, 2097, 2166, 2462, 2461, 2098, 2570, 
         2153, 2113, 1964, 2250, 2251, 2112, 2672, 2111, 2172, 2114, 2659, 
         2115, 2099, 2272, 2195, 2196, 2406, 2405, 1950, 2667, 2314, 2666, 
         2315, 2526, 2525, 2524, 2479, 2004, 2448, 2449, 1929, 1911, 2227, 
         1912, 2628, 2062, 2089, 2654, 2088, 2100, 2656, 2101, 2025, 2456, 
         2457, 2458, 2506, 2505, 1951, 2619, 2620, 2618, 2160, 2621, 2138, 
         2600, 2661, 2139, 2601, 2432, 2433, 2141, 2189, 2188, 2271, 2116, 
         2252, 2066, 2093, 2655, 2092, 1952, 2161, 2663, 2162, 2142, 2143, 
         2629, 1915, 2169, 1918, 2622, 2496, 2027, 2495, 2028, 2103, 2657, 
         2102, 1953, 2564, 2565, 2561, 2563, 2562, 2234, 2070, 2535, 2071, 
         2536, 1976, 2399, 2121, 2398, 2120, 2235, 2075, 2146, 2630, 1919, 
         2236, 1922, 2632, 2148, 2076, 2612, 2613, 2444, 2445, 1923, 2239, 
         1924, 2447, 2446, 2546, 2545, 2015, 2308, 2386, 2451, 1936, 2450}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1904, 2415, 2469, 2468, 2547, 2078, 2373, 2046, 2371, 2045, 
         2372, 2203, 2204, 2052, 2513, 2051, 2514, 1925, 2423, 2422, 2515, 
         2421, 2474, 2473, 1998, 2475, 1999, 2344, 2380, 2379, 2205, 2206, 
         2057, 2520, 2056, 1928, 1910, 2348, 2349, 2292, 2293, 2294, 2429, 
         2352, 2005, 2295, 2296, 2297, 2430, 2354, 2008, 2298, 2299, 1930, 
         1913, 2228, 2229, 2140, 2602, 2604, 2603, 2231, 2528, 2484, 2485, 
         2483, 2011, 2486, 2144, 2605, 2145, 2606, 2067, 2540, 2541, 2537, 
         2539, 2538, 2233, 2542, 2488, 2489, 2487, 2014, 2607, 2608, 2440, 
         2441, 2442, 2237, 2286, 2285}],
        RowBox[{"-", "100"}]],
       Annotation[#, -100, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1908, 2424, 2054, 2192, 1926, 2426, 2425, 2347, 2002, 2290, 
         2291, 2522, 2059, 2521, 2058, 2173, 2647, 1971, 2267, 1972, 2648, 
         2174, 1973, 2326, 2156, 2407, 2316, 2317, 2263, 2455, 2454, 2617, 
         2157, 2324, 2325, 2178, 1985, 2248, 2090, 2091, 2041, 2369, 2368, 
         2494, 2026, 2329, 2330, 2331, 2255, 2256, 2177, 2202, 1983, 2411, 
         1984, 2669, 2327, 2668, 2328, 2530, 2529, 2434, 2356, 2673, 2012, 
         2300, 2301, 1932, 1916, 2232, 2282, 2281}],
        RowBox[{"-", "200"}]],
       Annotation[#, -200, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->Automatic,
  PlotRange->{{-5, 5}, {-5, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{364, 360},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.5",
 CellLabel->"Out[7]=",
 CellID->159781593]
}, Open  ]],

Cell[TextData[{
 "If an equation is not exact, it may be possible to find an integrating \
factor (a multiplier for the functions ",
 Cell[BoxData["P"], "InlineFormula"],
 " and ",
 Cell[BoxData["Q"], "InlineFormula"],
 StyleBox[", defined previously", "TR"],
 ") that converts the equation into exact form. ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " tries a variety of techniques to automatically find integrating factors in \
such situations."
}], "Text",
 CellTags->"b:1.1.0.5",
 CellID->750],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->339016161],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Exact Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveRiccatiEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveClairautEquations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 17.5159756}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Here is an example of an exact ODE. This verifies the solution. Here is \
a contour plot of the solution.", "synonyms" -> {}, "title" -> 
    "Exact Equations", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveExactEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "ExactODE"->{
  Cell[1280, 43, 92, 2, 70, "Title",
   CellTags->{"ExactODE", "c:14", "b:1.1.0.5"},
   CellID->503]},
 "c:14"->{
  Cell[1280, 43, 92, 2, 70, "Title",
   CellTags->{"ExactODE", "c:14", "b:1.1.0.5"},
   CellID->503]},
 "b:1.1.0.5"->{
  Cell[1280, 43, 92, 2, 70, "Title",
   CellTags->{"ExactODE", "c:14", "b:1.1.0.5"},
   CellID->503],
  Cell[1375, 47, 219, 8, 70, "MathCaption",
   CellTags->"b:1.1.0.5",
   CellID->21221],
  Cell[1597, 57, 341, 13, 70, "Input",
   CellTags->"b:1.1.0.5",
   CellID->22663],
  Cell[1941, 72, 285, 10, 70, "Input",
   CellTags->"b:1.1.0.5",
   CellID->5706],
  Cell[2251, 86, 375, 13, 28, "Input",
   CellTags->"b:1.1.0.5",
   CellID->2363],
  Cell[2629, 101, 182, 6, 36, "Output",
   CellTags->"b:1.1.0.5",
   CellID->332943462],
  Cell[2848, 112, 410, 15, 28, "Input",
   CellTags->"b:1.1.0.5",
   CellID->22171],
  Cell[3261, 129, 656, 22, 56, "Output",
   CellTags->"b:1.1.0.5",
   CellID->201305172],
  Cell[3954, 156, 218, 7, 70, "Input",
   CellTags->"b:1.1.0.5",
   CellID->18240],
  Cell[4175, 165, 487, 10, 19, "Message",
   CellTags->"b:1.1.0.5",
   CellID->451690273],
  Cell[4665, 177, 730, 24, 54, "Output",
   CellTags->"b:1.1.0.5",
   CellID->94912635],
  Cell[5410, 204, 89, 2, 70, "MathCaption",
   CellTags->"b:1.1.0.5",
   CellID->7619],
  Cell[5524, 210, 353, 13, 70, "Input",
   CellTags->"b:1.1.0.5",
   CellID->20913],
  Cell[5880, 225, 732, 24, 56, "Output",
   CellTags->"b:1.1.0.5",
   CellID->355493154],
  Cell[6627, 252, 101, 2, 70, "MathCaption",
   CellTags->"b:1.1.0.5",
   CellID->6704],
  Cell[6753, 258, 581, 20, 70, "Input",
   CellTags->"b:1.1.0.5",
   CellID->31818],
  Cell[7337, 280, 69287, 1159, 70, "Output",
   CellTags->"b:1.1.0.5",
   CellID->159781593],
  Cell[76639, 1442, 573, 16, 70, "Text",
   CellTags->"b:1.1.0.5",
   CellID->750]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"ExactODE", 79625, 1523},
 {"c:14", 79739, 1527},
 {"b:1.1.0.5", 79858, 1531}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 92, 2, 70, "Title",
 CellTags->{"ExactODE", "c:14", "b:1.1.0.5"},
 CellID->503],
Cell[1375, 47, 219, 8, 70, "MathCaption",
 CellTags->"b:1.1.0.5",
 CellID->21221],
Cell[1597, 57, 341, 13, 70, "Input",
 CellTags->"b:1.1.0.5",
 CellID->22663],
Cell[1941, 72, 285, 10, 70, "Input",
 CellTags->"b:1.1.0.5",
 CellID->5706],
Cell[CellGroupData[{
Cell[2251, 86, 375, 13, 28, "Input",
 CellTags->"b:1.1.0.5",
 CellID->2363],
Cell[2629, 101, 182, 6, 36, "Output",
 CellTags->"b:1.1.0.5",
 CellID->332943462]
}, Open  ]],
Cell[CellGroupData[{
Cell[2848, 112, 410, 15, 28, "Input",
 CellTags->"b:1.1.0.5",
 CellID->22171],
Cell[3261, 129, 656, 22, 56, "Output",
 CellTags->"b:1.1.0.5",
 CellID->201305172]
}, Open  ]],
Cell[CellGroupData[{
Cell[3954, 156, 218, 7, 70, "Input",
 CellTags->"b:1.1.0.5",
 CellID->18240],
Cell[4175, 165, 487, 10, 19, "Message",
 CellTags->"b:1.1.0.5",
 CellID->451690273],
Cell[4665, 177, 730, 24, 54, "Output",
 CellTags->"b:1.1.0.5",
 CellID->94912635]
}, Open  ]],
Cell[5410, 204, 89, 2, 70, "MathCaption",
 CellTags->"b:1.1.0.5",
 CellID->7619],
Cell[CellGroupData[{
Cell[5524, 210, 353, 13, 70, "Input",
 CellTags->"b:1.1.0.5",
 CellID->20913],
Cell[5880, 225, 732, 24, 56, "Output",
 CellTags->"b:1.1.0.5",
 CellID->355493154]
}, Open  ]],
Cell[6627, 252, 101, 2, 70, "MathCaption",
 CellTags->"b:1.1.0.5",
 CellID->6704],
Cell[CellGroupData[{
Cell[6753, 258, 581, 20, 70, "Input",
 CellTags->"b:1.1.0.5",
 CellID->31818],
Cell[7337, 280, 69287, 1159, 70, "Output",
 CellTags->"b:1.1.0.5",
 CellID->159781593]
}, Open  ]],
Cell[76639, 1442, 573, 16, 70, "Text",
 CellTags->"b:1.1.0.5",
 CellID->750],
Cell[CellGroupData[{
Cell[77237, 1462, 72, 1, 70, "RelatedTutorialsSection",
 CellID->339016161],
Cell[77312, 1465, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[77516, 1472, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

