(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12764,        463]
NotebookOptionsPosition[      7141,        281]
NotebookOutlinePosition[     10991,        395]
CellTagsIndexPosition[     10898,        389]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Exact Linear Second-Order Equations", "Title",
 CellTags->{"c:21", "b:1.1.1.3"},
 CellID->25205],

Cell["A linear second-order ordinary differential equation", "Text",
 CellID->86130161],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["a", "0"], "(", "x", ")"}], 
     RowBox[{
      SuperscriptBox["y", "\[DoublePrime]",
       MultilineFunction->None], "(", "x", ")"}]}], "+", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "1"], "(", "x", ")"}], " ", 
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "(", "x", ")"}]}], "+", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "2"], "(", "x", ")"}], 
     RowBox[{"y", "(", "x", ")"}]}]}], "\[LongEqual]", "0"}], 
  TraditionalForm]], "DisplayMath",
 CellID->59506763],

Cell[TextData[{
 "is said to be ",
 StyleBox["exact",
  FontSlant->"Italic"],
 " ",
 "if "
}], "Text",
 FontSize->12,
 CellTags->"b:1.1.1.3",
 CellID->42920136],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      SubscriptBox["a", "0"], "\[DoublePrime]"], "(", "x", ")"}], "-", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["a", "1"], "\[Prime]"], "(", "x", ")"}], "+", 
    RowBox[{
     SubscriptBox["a", "2"], "(", "x", ")"}]}], "\[LongEqual]", "0."}], 
  TraditionalForm]], "DisplayMath",
 CellID->169270890],

Cell["\<\
An exact linear second-order ODE is solved by reduction to a linear \
first-order ODE.\
\>", "Text",
 CellTags->"b:1.1.1.3",
 CellID->4975],

Cell[TextData[{
 "Here is an example. The appearance of the unevaluated integral in the \
solution is explained ",
 ButtonBox["here",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveLinearFirstOrderEquations#25472"],
 "."
}], "MathCaption",
 CellTags->"b:1.1.1.3",
 CellID->1539],

Cell[BoxData[
 RowBox[{
  RowBox[{"a0", "=", "1"}], ";"}]], "Input",
 CellTags->"b:1.1.1.3",
 CellLabel->"In[5]:=",
 CellID->303],

Cell[BoxData[
 RowBox[{
  RowBox[{"a1", "=", 
   RowBox[{"Log", "[", "x", "]"}]}], ";"}]], "Input",
 CellTags->"b:1.1.1.3",
 CellLabel->"In[6]:=",
 CellID->11422],

Cell[BoxData[
 RowBox[{
  RowBox[{"a2", "=", 
   RowBox[{"1", "/", "x"}]}], ";"}]], "Input",
 CellTags->"b:1.1.1.3",
 CellLabel->"In[7]:=",
 CellID->21098],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"a0", "*", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
     RowBox[{"a1", "*", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", " ", 
     RowBox[{"a2", "*", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}]}], ";"}]], "Input",
 CellTags->"b:1.1.1.3",
 CellLabel->"In[8]:=",
 CellID->11247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conditionforexactness", " ", "=", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"a0", ",", " ", 
       RowBox[{"{", 
        RowBox[{"x", ",", "2"}], "}"}]}], "]"}], "-", 
     RowBox[{"D", "[", 
      RowBox[{"a1", ",", "x"}], "]"}], "+", "a2"}], "\[Equal]", "0"}], 
   ")"}]}]], "Input",
 CellTags->"b:1.1.1.3",
 CellLabel->"In[9]:=",
 CellID->13584],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.3",
 CellLabel->"Out[9]=",
 CellID->65526361]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", " ", "y", ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:1.1.1.3",
 CellLabel->"In[10]:=",
 CellID->2971],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"x", "-", 
          RowBox[{"x", " ", 
           RowBox[{"Log", "[", "x", "]"}]}]}]], " ", 
        RowBox[{"C", "[", "2", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"x", "-", 
          RowBox[{"x", " ", 
           RowBox[{"Log", "[", "x", "]"}]}]}]], " ", 
        RowBox[{
         SubsuperscriptBox["\[Integral]", "1", "x"], 
         RowBox[{
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"K", "[", "1", "]"}]}], "+", 
             RowBox[{
              RowBox[{"K", "[", "1", "]"}], " ", 
              RowBox[{"Log", "[", 
               RowBox[{"K", "[", "1", "]"}], "]"}]}]}]], " ", 
           RowBox[{"C", "[", "1", "]"}]}], 
          RowBox[{"\[DifferentialD]", 
           RowBox[{"K", "[", "1", "]"}]}]}]}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{506, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.3",
 CellLabel->"Out[10]=",
 CellID->329492396]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
 CellTags->"b:1.1.1.3",
 CellID->22913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "/.", "sol"}], "//", "FullSimplify"}]], "Input",
 CellTags->"b:1.1.1.3",
 CellLabel->"In[7]:=",
 CellID->11075],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.3",
 CellLabel->"Out[7]=",
 CellID->69610143]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"a0", ",", "a1", ",", "a2"}], "]"}]], "Input",
 CellTags->"b:1.1.1.3",
 CellLabel->"In[8]:=",
 CellID->28712],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->145111743],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Exact Linear Second-Order Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveSecondOrderEulerAndLegendreEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveLinearSecondOrderSpecialFunctionODEs"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 18.2347440}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "A linear second-order ordinary differential equation is said to be exact \
if An exact linear second-order ODE is solved by reduction to a linear \
first-order ODE.", "synonyms" -> {}, "title" -> 
    "Exact Linear Second-Order Equations", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveExactLinearSecondOrderODEs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:21"->{
  Cell[1280, 43, 102, 2, 70, "Title",
   CellTags->{"c:21", "b:1.1.1.3"},
   CellID->25205]},
 "b:1.1.1.3"->{
  Cell[1280, 43, 102, 2, 70, "Title",
   CellTags->{"c:21", "b:1.1.1.3"},
   CellID->25205],
  Cell[2098, 73, 160, 9, 70, "Text",
   CellTags->"b:1.1.1.3",
   CellID->42920136],
  Cell[2658, 99, 149, 5, 70, "Text",
   CellTags->"b:1.1.1.3",
   CellID->4975],
  Cell[2810, 106, 289, 9, 70, "MathCaption",
   CellTags->"b:1.1.1.3",
   CellID->1539],
  Cell[3102, 117, 129, 5, 70, "Input",
   CellTags->"b:1.1.1.3",
   CellID->303],
  Cell[3234, 124, 162, 6, 70, "Input",
   CellTags->"b:1.1.1.3",
   CellID->11422],
  Cell[3399, 132, 155, 6, 70, "Input",
   CellTags->"b:1.1.1.3",
   CellID->21098],
  Cell[3557, 140, 427, 15, 70, "Input",
   CellTags->"b:1.1.1.3",
   CellID->11247],
  Cell[4009, 159, 416, 14, 70, "Input",
   CellTags->"b:1.1.1.3",
   CellID->13584],
  Cell[4428, 175, 184, 6, 36, "Output",
   CellTags->"b:1.1.1.3",
   CellID->65526361],
  Cell[4649, 186, 188, 6, 70, "Input",
   CellTags->"b:1.1.1.3",
   CellID->2971],
  Cell[4840, 194, 1307, 40, 50, "Output",
   CellTags->"b:1.1.1.3",
   CellID->329492396],
  Cell[6162, 237, 90, 2, 70, "MathCaption",
   CellTags->"b:1.1.1.3",
   CellID->22913],
  Cell[6277, 243, 152, 5, 70, "Input",
   CellTags->"b:1.1.1.3",
   CellID->11075],
  Cell[6432, 250, 206, 7, 36, "Output",
   CellTags->"b:1.1.1.3",
   CellID->69610143],
  Cell[6653, 260, 157, 5, 70, "Input",
   CellTags->"b:1.1.1.3",
   CellID->28712]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:21", 9389, 333},
 {"b:1.1.1.3", 9499, 337}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 102, 2, 70, "Title",
 CellTags->{"c:21", "b:1.1.1.3"},
 CellID->25205],
Cell[1385, 47, 87, 1, 70, "Text",
 CellID->86130161],
Cell[1475, 50, 620, 21, 70, "DisplayMath",
 CellID->59506763],
Cell[2098, 73, 160, 9, 70, "Text",
 CellTags->"b:1.1.1.3",
 CellID->42920136],
Cell[2261, 84, 394, 13, 70, "DisplayMath",
 CellID->169270890],
Cell[2658, 99, 149, 5, 70, "Text",
 CellTags->"b:1.1.1.3",
 CellID->4975],
Cell[2810, 106, 289, 9, 70, "MathCaption",
 CellTags->"b:1.1.1.3",
 CellID->1539],
Cell[3102, 117, 129, 5, 70, "Input",
 CellTags->"b:1.1.1.3",
 CellID->303],
Cell[3234, 124, 162, 6, 70, "Input",
 CellTags->"b:1.1.1.3",
 CellID->11422],
Cell[3399, 132, 155, 6, 70, "Input",
 CellTags->"b:1.1.1.3",
 CellID->21098],
Cell[3557, 140, 427, 15, 70, "Input",
 CellTags->"b:1.1.1.3",
 CellID->11247],
Cell[CellGroupData[{
Cell[4009, 159, 416, 14, 70, "Input",
 CellTags->"b:1.1.1.3",
 CellID->13584],
Cell[4428, 175, 184, 6, 36, "Output",
 CellTags->"b:1.1.1.3",
 CellID->65526361]
}, Open  ]],
Cell[CellGroupData[{
Cell[4649, 186, 188, 6, 70, "Input",
 CellTags->"b:1.1.1.3",
 CellID->2971],
Cell[4840, 194, 1307, 40, 50, "Output",
 CellTags->"b:1.1.1.3",
 CellID->329492396]
}, Open  ]],
Cell[6162, 237, 90, 2, 70, "MathCaption",
 CellTags->"b:1.1.1.3",
 CellID->22913],
Cell[CellGroupData[{
Cell[6277, 243, 152, 5, 70, "Input",
 CellTags->"b:1.1.1.3",
 CellID->11075],
Cell[6432, 250, 206, 7, 36, "Output",
 CellTags->"b:1.1.1.3",
 CellID->69610143]
}, Open  ]],
Cell[6653, 260, 157, 5, 70, "Input",
 CellTags->"b:1.1.1.3",
 CellID->28712],
Cell[CellGroupData[{
Cell[6835, 269, 72, 1, 70, "RelatedTutorialsSection",
 CellID->145111743],
Cell[6910, 272, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[7114, 279, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

