(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     76425,       2371]
NotebookOptionsPosition[     62394,       1865]
NotebookOutlinePosition[     70302,       2124]
CellTagsIndexPosition[     70209,       2118]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Examples of DAEs", "Title",
 CellTags->{"c:44", "b:3.1"},
 CellID->17546],

Cell["This is a simple homogeneous DAE with constant coefficients.", \
"MathCaption",
 CellTags->"b:3.1",
 CellID->18678],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["eqns",
    FormatType->StandardForm], 
   StyleBox[" ",
    FormatType->StandardForm], 
   StyleBox["=",
    FormatType->StandardForm], 
   StyleBox[" ",
    FormatType->StandardForm], 
   RowBox[{
    StyleBox["{",
     FormatType->StandardForm], 
    RowBox[{
     RowBox[{
      StyleBox[
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "t", "]"}], " ", "-", " ", 
        RowBox[{"y", "[", "t", "]"}]}],
       FormatType->StandardForm], 
      StyleBox["\[Equal]",
       FormatType->StandardForm], "0"}], 
     StyleBox[",",
      FormatType->StandardForm], 
     StyleBox[" ",
      FormatType->StandardForm], 
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], " ", "+", " ", 
        RowBox[{"y", "[", "t", "]"}]}], " ", "==", " ", "0"}],
      FormatType->StandardForm]}], 
    StyleBox["}",
     FormatType->StandardForm]}]}], 
  StyleBox[";",
   FormatType->StandardForm]}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[1]:=",
 CellID->1769],

Cell[TextData[{
 "This finds the general solution. It has only one arbitrary constant \
because",
 " ",
 "the second equation in the system specifies the relationship between ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "[", 
   StyleBox["t", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], "[", 
   StyleBox["t", "TI"], "]"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:3.1",
 CellID->15262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqns", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", " ", "t"}], "]"}]}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[2]:=",
 CellID->8519],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "t"}]], " ", 
        RowBox[{"C", "[", "1", "]"}]}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "4"]}], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "t"}]], " ", 
        RowBox[{"C", "[", "1", "]"}]}]}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{427, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:3.1",
 CellLabel->"Out[2]=",
 CellID->90088651]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
 CellTags->"b:3.1",
 CellID->28289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eqns", "/.", "sol"}], "//", "Simplify"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[3]:=",
 CellID->15944],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"True", ",", "True"}], "}"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:3.1",
 CellLabel->"Out[3]=",
 CellID->468486480]
}, Open  ]],

Cell["\<\
Here is an inhomogeneous system derived from the previous example.\
\>", "MathCaption",
 CellTags->"b:3.1",
 CellID->18540],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqns", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}], " ", "-", 
       RowBox[{"y", "[", "t", "]"}]}], "\[Equal]", 
      RowBox[{"Sin", "[", "t", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], "+", 
       RowBox[{"y", "[", "t", "]"}]}], " ", "==", " ", "1"}]}], "}"}]}], 
  ";"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[4]:=",
 CellID->23245],

Cell["\<\
The general solution is composed of the general solution to the corresponding \
homogeneous system and a particular solution to the inhomogeneous equation.\
\>", "MathCaption",
 CellTags->"b:3.1",
 CellID->25508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], ",", " ", 
      RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", 
    RowBox[{
     RowBox[{"DSolve", "[", 
      RowBox[{"eqns", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], ",", 
         RowBox[{"y", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "//", "Expand"}]}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[5]:=",
 CellID->28318],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "t"}]], " ", 
     RowBox[{"C", "[", "1", "]"}]}], "-", 
    FractionBox[
     RowBox[{"Cos", "[", "t", "]"}], "2"], "+", 
    FractionBox[
     RowBox[{"Sin", "[", "t", "]"}], "2"]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "4"]}], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "t"}]], " ", 
     RowBox[{"C", "[", "1", "]"}]}], "+", 
    FractionBox[
     RowBox[{"Cos", "[", "t", "]"}], "2"], "-", 
    FractionBox[
     RowBox[{"Sin", "[", "t", "]"}], "2"]}]}], "}"}]], "Output",
 ImageSize->{417, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:3.1",
 CellLabel->"Out[5]=",
 CellID->508209721]
}, Open  ]],

Cell["\<\
This solves an initial value problem for the previous equation.\
\>", "MathCaption",
 CellTags->"b:3.1",
 CellID->9601],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"eqns", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "t", "]"}], " ", "-", 
        RowBox[{"y", "[", "t", "]"}]}], "\[Equal]", 
       RowBox[{"Sin", "[", "t", "]"}]}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], "+", 
        RowBox[{"y", "[", "t", "]"}]}], " ", "==", " ", "1"}], ",", " ", 
      RowBox[{
       RowBox[{"x", "[", "Pi", "]"}], " ", "==", " ", 
       RowBox[{"1", "/", "2"}]}]}], "}"}]}], ";"}], " "}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[6]:=",
 CellID->28323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqns", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", " ", "t"}], "]"}]}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[7]:=",
 CellID->21132],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "t"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", "\[Pi]"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", "t"]}], "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "t"], " ", 
           RowBox[{"Cos", "[", "t", "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "t"], " ", 
           RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}]}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "t"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", "\[Pi]"]}], "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "t"], " ", 
           RowBox[{"Cos", "[", "t", "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "t"], " ", 
           RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}]}]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{406, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:3.1",
 CellLabel->"Out[7]=",
 CellID->529716637]
}, Open  ]],

Cell["\<\
Here is a plot of the solution and the constraint (algebraic) condition.\
\>", "MathCaption",
 CellTags->"b:3.1",
 CellID->27152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], "/.", "sol"}], ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], "/.", "sol"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], "+", 
        RowBox[{"y", "[", "t", "]"}]}], ")"}], "/.", "sol"}]}], "}"}], ",", 
   " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "3", ",", "8"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[8]:=",
 CellID->25087],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 213},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:3.1",
 CellLabel->"Out[8]=",
 CellID->156046518]
}, Open  ]],

Cell["In this DAE, the inhomogeneous part is quite general. ", "MathCaption",
 CellTags->"b:3.1",
 CellID->29763],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"x", ",", "y", ",", "z", ",", "f", ",", "g", ",", "h", ",", "t"}], 
  "]"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[9]:=",
 CellID->29901],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqns", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], " ", "+", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "t", "]"}]}], "\[Equal]", 
      RowBox[{"f", "[", "t", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"2", 
        RowBox[{"y", "[", "t", "]"}]}], "+", 
       RowBox[{
        RowBox[{"z", "'"}], "[", "t", "]"}]}], "\[Equal]", 
      RowBox[{"g", "[", "t", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{"5", 
       RowBox[{"z", "[", "t", "]"}]}], "\[Equal]", 
      RowBox[{"h", "[", "t", "]"}]}]}], "}"}]}], ";"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[10]:=",
 CellID->17103],

Cell[TextData[{
 "Note that there are no degrees of freedom in the solution (that is, there",
 " ",
 "are no arbitrary constants) because ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    StyleBox["z", "TI"], "[", 
    StyleBox["t", "TI"], "]"}]], "InlineFormula"]], "InlineFormula"]]],
 " is given algebraically, and thus ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    StyleBox["x", "TI"], "[", 
    StyleBox["t", "TI"], "]"}]], "InlineFormula"]], "InlineFormula"]]],
 " and ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    StyleBox["y", "TI"], "[", 
    StyleBox["t", "TI"], "]"}]], "InlineFormula"]], "InlineFormula"]]],
 " can be determined uniquely from ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    StyleBox["z", "TI"], "[", 
    StyleBox["t", "TI"], "]"}]], "InlineFormula"]], "InlineFormula"]]],
 " using differentiation."
}], "MathCaption",
 CellTags->"b:3.1",
 CellID->14423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqns", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", " ", "t"}], 
   "]"}]}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[11]:=",
 CellID->3527],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{"f", "[", "t", "]"}], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["g", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "2"], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["h", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "10"]}]}], "]"}]}], ",",
     
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        FractionBox[
         RowBox[{"g", "[", "t", "]"}], "2"], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "10"]}]}], "]"}]}], ",",
     
    RowBox[{"z", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       FractionBox[
        RowBox[{"h", "[", "t", "]"}], "5"]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{407, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:3.1",
 CellLabel->"Out[11]=",
 CellID->150854090]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eqns", "/.", "sol"}], "//", "Simplify"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[12]:=",
 CellID->26969],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"True", ",", "True", ",", "True"}], "}"}], "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:3.1",
 CellLabel->"Out[12]=",
 CellID->27110773]
}, Open  ]],

Cell["\<\
In this example, the algebraic constraint is present only implicitly: all \
three equations contain derivatives of the unknown functions.\
\>", "MathCaption",
 CellTags->"b:3.1",
 CellID->5565],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"x1", ",", "x2", ",", "x3", ",", "t", ",", "eqns"}], "]"}], 
  " "}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[13]:=",
 CellID->28],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqns", " ", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x2", "[", "t", "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"x3", "[", "t", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["x1", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "-", 
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["x3", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "27"}], " ", 
        RowBox[{"x1", "[", "t", "]"}]}], "-", 
       RowBox[{"22", " ", 
        RowBox[{"x2", "[", "t", "]"}]}], "-", 
       RowBox[{"17", " ", 
        RowBox[{"x3", "[", "t", "]"}]}], "-", 
       RowBox[{
        SuperscriptBox["x1", "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["x3", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"18", " ", 
        RowBox[{"x1", "[", "t", "]"}]}], "+", 
       RowBox[{"14", " ", 
        RowBox[{"x2", "[", "t", "]"}]}], "+", 
       RowBox[{"10", " ", 
        RowBox[{"x3", "[", "t", "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["x1", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], "+", 
       RowBox[{"3", " ", 
        RowBox[{
         SuperscriptBox["x2", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["x3", "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}], "==", "0"}]}], 
    "}"}]}], ";"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[14]:=",
 CellID->21543],

Cell["\<\
The Jacobian with respect to the derivatives of the unknown functions is \
singular, so that it is not possible to solve for them.\
\>", "MathCaption",
 CellTags->"b:3.1",
 CellID->390382706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", "=", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"eqns", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x1", "'"}], "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"x2", "'"}], "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"x3", "'"}], "[", "t", "]"}]}], "}"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[15]:=",
 CellID->153406824],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->596693358]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", "A", "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->1560715],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->28592530]
}, Open  ]],

Cell["\<\
The differential-algebraic character of this problem is clear from the \
smaller number of arbitrary constants (two rather than three) in the general \
solution.\
\>", "MathCaption",
 CellTags->"b:3.1",
 CellID->25347],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqns", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", " ", "t"}], 
   "]"}]}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[17]:=",
 CellID->2088],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{425, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:3.1",
 CellLabel->"Out[17]=",
 CellID->677104168]
}, Open  ]],

Cell["\<\
Systems of equations with higher-order derivatives are solved by reducing \
them to first-order systems.\
\>", "Text",
 CellTags->"b:3.1",
 CellID->12637],

Cell["\<\
Here is the general solution to a homogeneous DAE of order two with constant \
coefficients.\
\>", "MathCaption",
 CellTags->"b:3.1",
 CellID->22409],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"eqns", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], " ", "==", " ", 
       RowBox[{"y", "[", "t", "]"}]}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], " ", "+", " ", 
        RowBox[{"4", 
         RowBox[{"y", "[", "t", "]"}]}]}], " ", "==", " ", "0"}]}], "}"}]}], 
   ";"}], " "}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[18]:=",
 CellID->26463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqns", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "t"}], "]"}]}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[19]:=",
 CellID->5049],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{
         FractionBox["176", "125"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"C", "[", "2", "]"}], " ", 
            RowBox[{"Cos", "[", 
             FractionBox["t", "2"], "]"}]}], "-", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"C", "[", "1", "]"}], " ", 
            RowBox[{"Sin", "[", 
             FractionBox["t", "2"], "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         FractionBox["16", "125"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"C", "[", "1", "]"}], " ", 
            RowBox[{"Cos", "[", 
             FractionBox["t", "2"], "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"C", "[", "2", "]"}], " ", 
            RowBox[{"Sin", "[", 
             FractionBox["t", "2"], "]"}]}]}], ")"}]}]}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          FractionBox["44", "125"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"C", "[", "2", "]"}], " ", 
            RowBox[{"Cos", "[", 
             FractionBox["t", "2"], "]"}]}], "-", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"C", "[", "1", "]"}], " ", 
            RowBox[{"Sin", "[", 
             FractionBox["t", "2"], "]"}]}]}], ")"}]}], "-", 
        RowBox[{
         FractionBox["4", "125"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"C", "[", "1", "]"}], " ", 
            RowBox[{"Cos", "[", 
             FractionBox["t", "2"], "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"C", "[", "2", "]"}], " ", 
            RowBox[{"Sin", "[", 
             FractionBox["t", "2"], "]"}]}]}], ")"}]}]}]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{591, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:3.1",
 CellLabel->"Out[19]=",
 CellID->696218884]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eqns", "/.", "sol"}], "//", "Simplify"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[20]:=",
 CellID->1588],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"True", ",", "True"}], "}"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:3.1",
 CellLabel->"Out[20]=",
 CellID->102996516]
}, Open  ]],

Cell["\<\
This inhomogeneous system of ODEs is based on the previous example.\
\>", "MathCaption",
 CellTags->"b:3.1",
 CellID->608],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{
    RowBox[{"eqns", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "''"}], "[", "t", "]"}], " ", "==", " ", 
        RowBox[{"y", "[", "t", "]"}]}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], " ", "+", 
         RowBox[{"4", " ", 
          RowBox[{"y", "[", "t", "]"}]}]}], " ", "==", " ", 
        RowBox[{"6", " ", 
         RowBox[{"Sin", "[", "t", "]"}]}]}]}], "}"}]}], ";"}], " "}],
  FormatType->StandardForm]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[21]:=",
 CellID->32060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqns", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "t"}], "]"}]}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[22]:=",
 CellID->21221],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{
         FractionBox["16", "125"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"C", "[", "1", "]"}], " ", 
            RowBox[{"Cos", "[", 
             FractionBox["t", "2"], "]"}]}], "+", 
           FractionBox[
            RowBox[{"11", " ", 
             RowBox[{"Cos", "[", "t", "]"}]}], "8"], "+", 
           RowBox[{"2", " ", 
            RowBox[{"C", "[", "2", "]"}], " ", 
            RowBox[{"Sin", "[", 
             FractionBox["t", "2"], "]"}]}], "-", 
           RowBox[{
            FractionBox["3", "2"], " ", 
            RowBox[{"Cos", "[", 
             FractionBox["t", "2"], "]"}], " ", 
            RowBox[{"Sin", "[", 
             FractionBox["t", "2"], "]"}]}], "-", 
           RowBox[{
            FractionBox["33", "16"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               SuperscriptBox[
                RowBox[{"Cos", "[", 
                 FractionBox["t", "2"], "]"}], "2"]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{"Sin", "[", 
                 FractionBox["t", "2"], "]"}], "2"]}]}], ")"}]}], "+", 
           FractionBox[
            RowBox[{"Sin", "[", "t", "]"}], "4"]}], ")"}]}], "+", 
        RowBox[{
         FractionBox["176", "125"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"C", "[", "2", "]"}], " ", 
            RowBox[{"Cos", "[", 
             FractionBox["t", "2"], "]"}]}], "-", 
           FractionBox[
            RowBox[{"Cos", "[", "t", "]"}], "8"], "-", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"C", "[", "1", "]"}], " ", 
            RowBox[{"Sin", "[", 
             FractionBox["t", "2"], "]"}]}], "-", 
           RowBox[{
            FractionBox["33", "8"], " ", 
            RowBox[{"Cos", "[", 
             FractionBox["t", "2"], "]"}], " ", 
            RowBox[{"Sin", "[", 
             FractionBox["t", "2"], "]"}]}], "+", 
           RowBox[{
            FractionBox["3", "16"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               SuperscriptBox[
                RowBox[{"Cos", "[", 
                 FractionBox["t", "2"], "]"}], "2"]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{"Sin", "[", 
                 FractionBox["t", "2"], "]"}], "2"]}]}], ")"}]}], "+", 
           FractionBox[
            RowBox[{"11", " ", 
             RowBox[{"Sin", "[", "t", "]"}]}], "16"]}], ")"}]}]}]}], "]"}]}], 
    ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          FractionBox["4", "125"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"C", "[", "1", "]"}], " ", 
            RowBox[{"Cos", "[", 
             FractionBox["t", "2"], "]"}]}], "+", 
           FractionBox[
            RowBox[{"11", " ", 
             RowBox[{"Cos", "[", "t", "]"}]}], "8"], "+", 
           RowBox[{"2", " ", 
            RowBox[{"C", "[", "2", "]"}], " ", 
            RowBox[{"Sin", "[", 
             FractionBox["t", "2"], "]"}]}], "-", 
           RowBox[{
            FractionBox["3", "2"], " ", 
            RowBox[{"Cos", "[", 
             FractionBox["t", "2"], "]"}], " ", 
            RowBox[{"Sin", "[", 
             FractionBox["t", "2"], "]"}]}], "-", 
           RowBox[{
            FractionBox["33", "16"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               SuperscriptBox[
                RowBox[{"Cos", "[", 
                 FractionBox["t", "2"], "]"}], "2"]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{"Sin", "[", 
                 FractionBox["t", "2"], "]"}], "2"]}]}], ")"}]}], "+", 
           FractionBox[
            RowBox[{"Sin", "[", "t", "]"}], "4"]}], ")"}]}], "-", 
        RowBox[{
         FractionBox["44", "125"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"C", "[", "2", "]"}], " ", 
            RowBox[{"Cos", "[", 
             FractionBox["t", "2"], "]"}]}], "-", 
           FractionBox[
            RowBox[{"Cos", "[", "t", "]"}], "8"], "-", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"C", "[", "1", "]"}], " ", 
            RowBox[{"Sin", "[", 
             FractionBox["t", "2"], "]"}]}], "-", 
           RowBox[{
            FractionBox["33", "8"], " ", 
            RowBox[{"Cos", "[", 
             FractionBox["t", "2"], "]"}], " ", 
            RowBox[{"Sin", "[", 
             FractionBox["t", "2"], "]"}]}], "+", 
           RowBox[{
            FractionBox["3", "16"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               SuperscriptBox[
                RowBox[{"Cos", "[", 
                 FractionBox["t", "2"], "]"}], "2"]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{"Sin", "[", 
                 FractionBox["t", "2"], "]"}], "2"]}]}], ")"}]}], "+", 
           FractionBox[
            RowBox[{"11", " ", 
             RowBox[{"Sin", "[", "t", "]"}]}], "16"]}], ")"}]}], "+", 
        FractionBox[
         RowBox[{"3", " ", 
          RowBox[{"Sin", "[", "t", "]"}]}], "2"]}]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{536, 240},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:3.1",
 CellLabel->"Out[22]=",
 CellID->282487]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eqns", "/.", "sol"}], "//", "Simplify"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[23]:=",
 CellID->29954],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"True", ",", "True"}], "}"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:3.1",
 CellLabel->"Out[23]=",
 CellID->289725556]
}, Open  ]],

Cell["\<\
Here is an initial value problem for the previous system of equations.\
\>", "MathCaption",
 CellTags->"b:3.1",
 CellID->14146],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{
    RowBox[{"eqns", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "''"}], "[", "t", "]"}], " ", "==", " ", 
        RowBox[{"y", "[", "t", "]"}]}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], " ", "+", " ", 
         RowBox[{"4", 
          RowBox[{"y", "[", "t", "]"}]}]}], " ", "==", " ", 
        RowBox[{"Sin", "[", "t", "]"}]}], ",", " ", 
       RowBox[{
        RowBox[{"x", "[", "Pi", "]"}], " ", "==", " ", "1"}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "Pi", "]"}], " ", "==", " ", "0"}]}], 
      "}"}]}], ";"}], " "}],
  FormatType->StandardForm]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[24]:=",
 CellID->690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqns", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "t"}], "]"}]}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[25]:=",
 CellID->7949],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           RowBox[{"Cos", "[", 
            FractionBox["t", "2"], "]"}]}], "+", 
          RowBox[{"6", " ", 
           RowBox[{"Sin", "[", 
            FractionBox["t", "2"], "]"}]}], "-", 
          RowBox[{"6", " ", 
           RowBox[{"Cos", "[", 
            FractionBox["t", "2"], "]"}], " ", 
           RowBox[{"Sin", "[", 
            FractionBox["t", "2"], "]"}]}], "+", 
          RowBox[{"Sin", "[", "t", "]"}]}], ")"}]}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        FractionBox["1", "24"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           RowBox[{"Cos", "[", 
            FractionBox["t", "2"], "]"}]}], "-", 
          RowBox[{"6", " ", 
           RowBox[{"Sin", "[", 
            FractionBox["t", "2"], "]"}]}], "+", 
          RowBox[{"6", " ", 
           RowBox[{"Cos", "[", 
            FractionBox["t", "2"], "]"}], " ", 
           RowBox[{"Sin", "[", 
            FractionBox["t", "2"], "]"}]}], "+", 
          RowBox[{"5", " ", 
           RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}]}]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{508, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:3.1",
 CellLabel->"Out[25]=",
 CellID->185404961]
}, Open  ]],

Cell["Here is a plot of the solution.", "MathCaption",
 CellTags->"b:3.1",
 CellID->21430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], "/.", "sol"}], ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], "/.", "sol"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "7"}], ",", "7"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[26]:=",
 CellID->25620],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 224},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:3.1",
 CellLabel->"Out[26]=",
 CellID->53300676]
}, Open  ]],

Cell["\<\
Finally, here is a system with a third-order ODE. Since the coefficients are \
exact quantities, the computation takes some time.\
\>", "MathCaption",
 CellTags->"b:3.1",
 CellID->27067],

Cell[BoxData[
 RowBox[{"Clear", " ", "[", 
  RowBox[{"p", ",", "q", ",", "r"}], "]"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[27]:=",
 CellID->4536],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"eqns", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"p", "'''"}], "[", "t", "]"}], " ", "-", " ", 
       RowBox[{"q", "[", "t", "]"}], " ", "+", " ", 
       RowBox[{"r", "[", "t", "]"}], " ", "-", " ", 
       RowBox[{"Sin", "[", "t", "]"}]}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"p", "''"}], "[", "t", "]"}], " ", "-", " ", 
       RowBox[{"r", "[", "t", "]"}], " ", "-", 
       RowBox[{"Cos", "[", "t", "]"}]}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"p", "'"}], "[", "t", "]"}], " ", "-", " ", 
       RowBox[{"q", "[", "t", "]"}], "+", " ", "4"}], ",", " ", 
      RowBox[{
       RowBox[{"p", "[", "0", "]"}], " ", "-", " ", "1"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"p", "'"}], "[", "0", "]"}], " ", "-", " ", "1"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"p", "''"}], "[", "0", "]"}], " ", "-", " ", "1"}]}], "}"}]}],
    ";"}], " "}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[28]:=",
 CellID->20783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\n", 
  RowBox[{
   RowBox[{"Timing", "[", 
    RowBox[{"sol", "=", 
     RowBox[{"DSolve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#1", "==", "0"}], "&"}], ")"}], "/@", "eqns"}], ",", 
       RowBox[{"{", 
        RowBox[{"p", ",", "q", ",", "r"}], "}"}], ",", "t"}], "]"}]}], "]"}], 
   "\n"}]}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[29]:=",
 CellID->18035],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9.156`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "\[Rule]", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", "t", "}"}], ",", 
         RowBox[{"-", 
          RowBox[{
           FractionBox["1", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SqrtBox["5"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               SqrtBox["5"]}], ")"}]}]], 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "410"}], "-", 
              RowBox[{"17", " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "-", 
                   SqrtBox["5"]}], ")"}], " ", "t"}]]}], "+", 
              RowBox[{"9", " ", 
               SqrtBox["5"], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "-", 
                   SqrtBox["5"]}], ")"}], " ", "t"}]]}], "-", 
              RowBox[{"17", " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   SqrtBox["5"]}], ")"}], " ", "t"}]]}], "-", 
              RowBox[{"9", " ", 
               SqrtBox["5"], " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   SqrtBox["5"]}], ")"}], " ", "t"}]]}], "+", 
              RowBox[{"440", " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 FractionBox["t", "2"], "+", 
                 FractionBox[
                  RowBox[{
                   SqrtBox["5"], " ", "t"}], "2"], "+", 
                 RowBox[{
                  FractionBox["1", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "-", 
                    SqrtBox["5"]}], ")"}], " ", "t"}]}]]}], "+", 
              RowBox[{"20", " ", "t"}], "-", 
              RowBox[{"34", " ", 
               RowBox[{"Cos", "[", "t", "]"}]}], "+", 
              RowBox[{"33", " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 FractionBox["t", "2"], "+", 
                 FractionBox[
                  RowBox[{
                   SqrtBox["5"], " ", "t"}], "2"], "+", 
                 RowBox[{
                  FractionBox["1", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "-", 
                    SqrtBox["5"]}], ")"}], " ", "t"}]}]], " ", 
               RowBox[{"Cos", "[", "t", "]"}]}], "-", 
              RowBox[{"118", " ", 
               RowBox[{"Sin", "[", "t", "]"}]}], "+", 
              RowBox[{"121", " ", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 FractionBox["t", "2"], "+", 
                 FractionBox[
                  RowBox[{
                   SqrtBox["5"], " ", "t"}], "2"], "+", 
                 RowBox[{
                  FractionBox["1", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "-", 
                    SqrtBox["5"]}], ")"}], " ", "t"}]}]], " ", 
               RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}]}]}]}]}], "]"}]}], 
      ",", 
      RowBox[{"q", "\[Rule]", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", "t", "}"}], ",", 
         RowBox[{
          FractionBox["1", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"20", "+", 
            RowBox[{"14", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               FractionBox["1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "-", 
                 SqrtBox["5"]}], ")"}], " ", "t"}]]}], "-", 
            RowBox[{"4", " ", 
             SqrtBox["5"], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               FractionBox["1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "-", 
                 SqrtBox["5"]}], ")"}], " ", "t"}]]}], "+", 
            RowBox[{"14", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               FractionBox["1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 SqrtBox["5"]}], ")"}], " ", "t"}]]}], "+", 
            RowBox[{"4", " ", 
             SqrtBox["5"], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               FractionBox["1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 SqrtBox["5"]}], ")"}], " ", "t"}]]}], "-", 
            RowBox[{"20", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               FractionBox["t", "2"], "+", 
               FractionBox[
                RowBox[{
                 SqrtBox["5"], " ", "t"}], "2"], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "-", 
                  SqrtBox["5"]}], ")"}], " ", "t"}]}]]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               FractionBox["t", "2"], "+", 
               FractionBox[
                RowBox[{
                 SqrtBox["5"], " ", "t"}], "2"], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "-", 
                  SqrtBox["5"]}], ")"}], " ", "t"}]}]], " ", 
             RowBox[{"Cos", "[", "t", "]"}]}], "-", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               FractionBox["t", "2"], "+", 
               FractionBox[
                RowBox[{
                 SqrtBox["5"], " ", "t"}], "2"], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "-", 
                  SqrtBox["5"]}], ")"}], " ", "t"}]}]], " ", 
             RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}]}]}], "]"}]}], ",", 
      RowBox[{"r", "\[Rule]", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", "t", "}"}], ",", 
         RowBox[{
          FractionBox["1", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               FractionBox["1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "-", 
                 SqrtBox["5"]}], ")"}], " ", "t"}]]}], "-", 
            RowBox[{"5", " ", 
             SqrtBox["5"], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               FractionBox["1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "-", 
                 SqrtBox["5"]}], ")"}], " ", "t"}]]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               FractionBox["1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 SqrtBox["5"]}], ")"}], " ", "t"}]]}], "+", 
            RowBox[{"5", " ", 
             SqrtBox["5"], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               FractionBox["1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 SqrtBox["5"]}], ")"}], " ", "t"}]]}], "-", 
            RowBox[{"5", " ", 
             RowBox[{"Cos", "[", "t", "]"}]}], "-", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               FractionBox["t", "2"], "+", 
               FractionBox[
                RowBox[{
                 SqrtBox["5"], " ", "t"}], "2"], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "-", 
                  SqrtBox["5"]}], ")"}], " ", "t"}]}]], " ", 
             RowBox[{"Cos", "[", "t", "]"}]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               FractionBox["t", "2"], "+", 
               FractionBox[
                RowBox[{
                 SqrtBox["5"], " ", "t"}], "2"], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "-", 
                  SqrtBox["5"]}], ")"}], " ", "t"}]}]], " ", 
             RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}]}]}], "]"}]}]}], "}"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{585, 413},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:3.1",
 CellLabel->"Out[29]=",
 CellID->77692078]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eqns", "/.", "sol"}], "//", "Simplify"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[30]:=",
 CellID->15185],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
  "}"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:3.1",
 CellLabel->"Out[30]=",
 CellID->552557984]
}, Open  ]],

Cell[TextData[{
 "The symbolic solution of DAEs that are nonlinear or have non-constant \
coefficients is a difficult problem. Such systems can often be solved \
numerically with the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ". "
}], "Text",
 CellTags->"b:3.1",
 CellID->9853],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->782509925],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Examples of DAEs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveIntroductionToDAEs"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveIntroductionToBVPs"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 18.6566298}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "This is a simple homogeneous DAE with constant coefficients. This finds \
the general solution. It has only one arbitrary constant because the second \
equation in the system specifies the relationship between x[t] and y[t]. This \
verifies the solution.", "synonyms" -> {}, "title" -> "Examples of DAEs", 
    "type" -> "Tutorial", "uri" -> "tutorial/DSolveExamplesOfDAEs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:44"->{
  Cell[1280, 43, 79, 2, 70, "Title",
   CellTags->{"c:44", "b:3.1"},
   CellID->17546]},
 "b:3.1"->{
  Cell[1280, 43, 79, 2, 70, "Title",
   CellTags->{"c:44", "b:3.1"},
   CellID->17546],
  Cell[1362, 47, 121, 3, 70, "MathCaption",
   CellTags->"b:3.1",
   CellID->18678],
  Cell[1486, 52, 1054, 40, 70, "Input",
   CellTags->"b:3.1",
   CellID->1769],
  Cell[2543, 94, 459, 17, 70, "MathCaption",
   CellTags->"b:3.1",
   CellID->15262],
  Cell[3027, 115, 250, 8, 28, "Input",
   CellTags->"b:3.1",
   CellID->8519],
  Cell[3280, 125, 856, 28, 51, "Output",
   CellTags->"b:3.1",
   CellID->90088651],
  Cell[4151, 156, 86, 2, 70, "MathCaption",
   CellTags->"b:3.1",
   CellID->28289],
  Cell[4262, 162, 145, 5, 28, "Input",
   CellTags->"b:3.1",
   CellID->15944],
  Cell[4410, 169, 254, 9, 36, "Output",
   CellTags->"b:3.1",
   CellID->468486480],
  Cell[4679, 181, 133, 4, 70, "MathCaption",
   CellTags->"b:3.1",
   CellID->18540],
  Cell[4815, 187, 515, 18, 70, "Input",
   CellTags->"b:3.1",
   CellID->23245],
  Cell[5333, 207, 222, 5, 70, "MathCaption",
   CellTags->"b:3.1",
   CellID->25508],
  Cell[5580, 216, 548, 18, 70, "Input",
   CellTags->"b:3.1",
   CellID->28318],
  Cell[6131, 236, 854, 29, 51, "Output",
   CellTags->"b:3.1",
   CellID->508209721],
  Cell[7000, 268, 129, 4, 70, "MathCaption",
   CellTags->"b:3.1",
   CellID->9601],
  Cell[7132, 274, 658, 21, 70, "Input",
   CellTags->"b:3.1",
   CellID->28323],
  Cell[7815, 299, 241, 8, 70, "Input",
   CellTags->"b:3.1",
   CellID->21132],
  Cell[8059, 309, 1650, 49, 81, "Output",
   CellTags->"b:3.1",
   CellID->529716637],
  Cell[9724, 361, 139, 4, 70, "MathCaption",
   CellTags->"b:3.1",
   CellID->27152],
  Cell[9888, 369, 545, 19, 28, "Input",
   CellTags->"b:3.1",
   CellID->25087],
  Cell[10436, 390, 5548, 96, 234, "Output",
   Evaluatable->False,
   CellTags->"b:3.1",
   CellID->156046518],
  Cell[15999, 489, 113, 2, 70, "MathCaption",
   CellTags->"b:3.1",
   CellID->29763],
  Cell[16115, 493, 193, 6, 70, "Input",
   CellTags->"b:3.1",
   CellID->29901],
  Cell[16311, 501, 722, 24, 70, "Input",
   CellTags->"b:3.1",
   CellID->17103],
  Cell[17036, 527, 937, 26, 70, "MathCaption",
   CellTags->"b:3.1",
   CellID->14423],
  Cell[17998, 557, 265, 9, 70, "Input",
   CellTags->"b:3.1",
   CellID->3527],
  Cell[18266, 568, 1287, 43, 81, "Output",
   CellTags->"b:3.1",
   CellID->150854090],
  Cell[19590, 616, 146, 5, 70, "Input",
   CellTags->"b:3.1",
   CellID->26969],
  Cell[19739, 623, 267, 9, 36, "Output",
   CellTags->"b:3.1",
   CellID->27110773],
  Cell[20021, 635, 203, 5, 70, "MathCaption",
   CellTags->"b:3.1",
   CellID->5565],
  Cell[20227, 642, 196, 7, 70, "Input",
   CellTags->"b:3.1",
   CellID->28],
  Cell[20426, 651, 1846, 56, 70, "Input",
   CellTags->"b:3.1",
   CellID->21543],
  Cell[22275, 709, 201, 5, 70, "MathCaption",
   CellTags->"b:3.1",
   CellID->390382706],
  Cell[23748, 771, 228, 6, 70, "MathCaption",
   CellTags->"b:3.1",
   CellID->25347],
  Cell[24001, 781, 268, 9, 28, "Input",
   CellTags->"b:3.1",
   CellID->2088],
  Cell[24272, 792, 2469, 45, 111, "Output",
   Evaluatable->False,
   CellTags->"b:3.1",
   CellID->677104168],
  Cell[26756, 840, 164, 5, 70, "Text",
   CellTags->"b:3.1",
   CellID->12637],
  Cell[26923, 847, 159, 5, 70, "MathCaption",
   CellTags->"b:3.1",
   CellID->22409],
  Cell[27085, 854, 517, 18, 70, "Input",
   CellTags->"b:3.1",
   CellID->26463],
  Cell[27627, 876, 246, 8, 70, "Input",
   CellTags->"b:3.1",
   CellID->5049],
  Cell[27876, 886, 2304, 71, 103, "Output",
   CellTags->"b:3.1",
   CellID->696218884],
  Cell[30217, 962, 145, 5, 70, "Input",
   CellTags->"b:3.1",
   CellID->1588],
  Cell[30365, 969, 255, 9, 36, "Output",
   CellTags->"b:3.1",
   CellID->102996516],
  Cell[30635, 981, 132, 4, 70, "MathCaption",
   CellTags->"b:3.1",
   CellID->608],
  Cell[30770, 987, 633, 21, 70, "Input",
   CellTags->"b:3.1",
   CellID->32060],
  Cell[31428, 1012, 247, 8, 70, "Input",
   CellTags->"b:3.1",
   CellID->21221],
  Cell[31678, 1022, 6010, 171, 261, "Output",
   CellTags->"b:3.1",
   CellID->282487],
  Cell[37725, 1198, 146, 5, 70, "Input",
   CellTags->"b:3.1",
   CellID->29954],
  Cell[37874, 1205, 255, 9, 36, "Output",
   CellTags->"b:3.1",
   CellID->289725556],
  Cell[38144, 1217, 137, 4, 70, "MathCaption",
   CellTags->"b:3.1",
   CellID->14146],
  Cell[38284, 1223, 811, 26, 70, "Input",
   CellTags->"b:3.1",
   CellID->690],
  Cell[39120, 1253, 246, 8, 70, "Input",
   CellTags->"b:3.1",
   CellID->7949],
  Cell[39369, 1263, 1670, 52, 81, "Output",
   CellTags->"b:3.1",
   CellID->185404961],
  Cell[41054, 1318, 90, 2, 70, "MathCaption",
   CellTags->"b:3.1",
   CellID->21430],
  Cell[41169, 1324, 401, 14, 28, "Input",
   CellTags->"b:3.1",
   CellID->25620],
  Cell[41573, 1340, 7736, 132, 245, "Output",
   Evaluatable->False,
   CellTags->"b:3.1",
   CellID->53300676],
  Cell[49324, 1475, 196, 5, 70, "MathCaption",
   CellTags->"b:3.1",
   CellID->27067],
  Cell[49523, 1482, 155, 5, 70, "Input",
   CellTags->"b:3.1",
   CellID->4536],
  Cell[49681, 1489, 1095, 32, 70, "Input",
   CellTags->"b:3.1",
   CellID->20783],
  Cell[50801, 1525, 448, 16, 70, "Input",
   CellTags->"b:3.1",
   CellID->18035],
  Cell[51252, 1543, 9899, 267, 434, "Output",
   CellTags->"b:3.1",
   CellID->77692078],
  Cell[61188, 1815, 146, 5, 70, "Input",
   CellTags->"b:3.1",
   CellID->15185],
  Cell[61337, 1822, 292, 10, 36, "Output",
   CellTags->"b:3.1",
   CellID->552557984],
  Cell[61644, 1835, 419, 14, 70, "Text",
   CellTags->"b:3.1",
   CellID->9853]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:44", 64621, 1915},
 {"b:3.1", 64722, 1919}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 79, 2, 70, "Title",
 CellTags->{"c:44", "b:3.1"},
 CellID->17546],
Cell[1362, 47, 121, 3, 70, "MathCaption",
 CellTags->"b:3.1",
 CellID->18678],
Cell[1486, 52, 1054, 40, 70, "Input",
 CellTags->"b:3.1",
 CellID->1769],
Cell[2543, 94, 459, 17, 70, "MathCaption",
 CellTags->"b:3.1",
 CellID->15262],
Cell[CellGroupData[{
Cell[3027, 115, 250, 8, 28, "Input",
 CellTags->"b:3.1",
 CellID->8519],
Cell[3280, 125, 856, 28, 51, "Output",
 CellTags->"b:3.1",
 CellID->90088651]
}, Open  ]],
Cell[4151, 156, 86, 2, 70, "MathCaption",
 CellTags->"b:3.1",
 CellID->28289],
Cell[CellGroupData[{
Cell[4262, 162, 145, 5, 28, "Input",
 CellTags->"b:3.1",
 CellID->15944],
Cell[4410, 169, 254, 9, 36, "Output",
 CellTags->"b:3.1",
 CellID->468486480]
}, Open  ]],
Cell[4679, 181, 133, 4, 70, "MathCaption",
 CellTags->"b:3.1",
 CellID->18540],
Cell[4815, 187, 515, 18, 70, "Input",
 CellTags->"b:3.1",
 CellID->23245],
Cell[5333, 207, 222, 5, 70, "MathCaption",
 CellTags->"b:3.1",
 CellID->25508],
Cell[CellGroupData[{
Cell[5580, 216, 548, 18, 70, "Input",
 CellTags->"b:3.1",
 CellID->28318],
Cell[6131, 236, 854, 29, 51, "Output",
 CellTags->"b:3.1",
 CellID->508209721]
}, Open  ]],
Cell[7000, 268, 129, 4, 70, "MathCaption",
 CellTags->"b:3.1",
 CellID->9601],
Cell[7132, 274, 658, 21, 70, "Input",
 CellTags->"b:3.1",
 CellID->28323],
Cell[CellGroupData[{
Cell[7815, 299, 241, 8, 70, "Input",
 CellTags->"b:3.1",
 CellID->21132],
Cell[8059, 309, 1650, 49, 81, "Output",
 CellTags->"b:3.1",
 CellID->529716637]
}, Open  ]],
Cell[9724, 361, 139, 4, 70, "MathCaption",
 CellTags->"b:3.1",
 CellID->27152],
Cell[CellGroupData[{
Cell[9888, 369, 545, 19, 28, "Input",
 CellTags->"b:3.1",
 CellID->25087],
Cell[10436, 390, 5548, 96, 234, "Output",
 Evaluatable->False,
 CellTags->"b:3.1",
 CellID->156046518]
}, Open  ]],
Cell[15999, 489, 113, 2, 70, "MathCaption",
 CellTags->"b:3.1",
 CellID->29763],
Cell[16115, 493, 193, 6, 70, "Input",
 CellTags->"b:3.1",
 CellID->29901],
Cell[16311, 501, 722, 24, 70, "Input",
 CellTags->"b:3.1",
 CellID->17103],
Cell[17036, 527, 937, 26, 70, "MathCaption",
 CellTags->"b:3.1",
 CellID->14423],
Cell[CellGroupData[{
Cell[17998, 557, 265, 9, 70, "Input",
 CellTags->"b:3.1",
 CellID->3527],
Cell[18266, 568, 1287, 43, 81, "Output",
 CellTags->"b:3.1",
 CellID->150854090]
}, Open  ]],
Cell[CellGroupData[{
Cell[19590, 616, 146, 5, 70, "Input",
 CellTags->"b:3.1",
 CellID->26969],
Cell[19739, 623, 267, 9, 36, "Output",
 CellTags->"b:3.1",
 CellID->27110773]
}, Open  ]],
Cell[20021, 635, 203, 5, 70, "MathCaption",
 CellTags->"b:3.1",
 CellID->5565],
Cell[20227, 642, 196, 7, 70, "Input",
 CellTags->"b:3.1",
 CellID->28],
Cell[20426, 651, 1846, 56, 70, "Input",
 CellTags->"b:3.1",
 CellID->21543],
Cell[22275, 709, 201, 5, 70, "MathCaption",
 CellTags->"b:3.1",
 CellID->390382706],
Cell[CellGroupData[{
Cell[22501, 718, 499, 18, 70, "Input",
 CellID->153406824],
Cell[23003, 738, 434, 15, 36, "Output",
 CellID->596693358]
}, Open  ]],
Cell[CellGroupData[{
Cell[23474, 758, 98, 3, 70, "Input",
 CellID->1560715],
Cell[23575, 763, 158, 5, 36, "Output",
 CellID->28592530]
}, Open  ]],
Cell[23748, 771, 228, 6, 70, "MathCaption",
 CellTags->"b:3.1",
 CellID->25347],
Cell[CellGroupData[{
Cell[24001, 781, 268, 9, 28, "Input",
 CellTags->"b:3.1",
 CellID->2088],
Cell[24272, 792, 2469, 45, 111, "Output",
 Evaluatable->False,
 CellTags->"b:3.1",
 CellID->677104168]
}, Open  ]],
Cell[26756, 840, 164, 5, 70, "Text",
 CellTags->"b:3.1",
 CellID->12637],
Cell[26923, 847, 159, 5, 70, "MathCaption",
 CellTags->"b:3.1",
 CellID->22409],
Cell[27085, 854, 517, 18, 70, "Input",
 CellTags->"b:3.1",
 CellID->26463],
Cell[CellGroupData[{
Cell[27627, 876, 246, 8, 70, "Input",
 CellTags->"b:3.1",
 CellID->5049],
Cell[27876, 886, 2304, 71, 103, "Output",
 CellTags->"b:3.1",
 CellID->696218884]
}, Open  ]],
Cell[CellGroupData[{
Cell[30217, 962, 145, 5, 70, "Input",
 CellTags->"b:3.1",
 CellID->1588],
Cell[30365, 969, 255, 9, 36, "Output",
 CellTags->"b:3.1",
 CellID->102996516]
}, Open  ]],
Cell[30635, 981, 132, 4, 70, "MathCaption",
 CellTags->"b:3.1",
 CellID->608],
Cell[30770, 987, 633, 21, 70, "Input",
 CellTags->"b:3.1",
 CellID->32060],
Cell[CellGroupData[{
Cell[31428, 1012, 247, 8, 70, "Input",
 CellTags->"b:3.1",
 CellID->21221],
Cell[31678, 1022, 6010, 171, 261, "Output",
 CellTags->"b:3.1",
 CellID->282487]
}, Open  ]],
Cell[CellGroupData[{
Cell[37725, 1198, 146, 5, 70, "Input",
 CellTags->"b:3.1",
 CellID->29954],
Cell[37874, 1205, 255, 9, 36, "Output",
 CellTags->"b:3.1",
 CellID->289725556]
}, Open  ]],
Cell[38144, 1217, 137, 4, 70, "MathCaption",
 CellTags->"b:3.1",
 CellID->14146],
Cell[38284, 1223, 811, 26, 70, "Input",
 CellTags->"b:3.1",
 CellID->690],
Cell[CellGroupData[{
Cell[39120, 1253, 246, 8, 70, "Input",
 CellTags->"b:3.1",
 CellID->7949],
Cell[39369, 1263, 1670, 52, 81, "Output",
 CellTags->"b:3.1",
 CellID->185404961]
}, Open  ]],
Cell[41054, 1318, 90, 2, 70, "MathCaption",
 CellTags->"b:3.1",
 CellID->21430],
Cell[CellGroupData[{
Cell[41169, 1324, 401, 14, 28, "Input",
 CellTags->"b:3.1",
 CellID->25620],
Cell[41573, 1340, 7736, 132, 245, "Output",
 Evaluatable->False,
 CellTags->"b:3.1",
 CellID->53300676]
}, Open  ]],
Cell[49324, 1475, 196, 5, 70, "MathCaption",
 CellTags->"b:3.1",
 CellID->27067],
Cell[49523, 1482, 155, 5, 70, "Input",
 CellTags->"b:3.1",
 CellID->4536],
Cell[49681, 1489, 1095, 32, 70, "Input",
 CellTags->"b:3.1",
 CellID->20783],
Cell[CellGroupData[{
Cell[50801, 1525, 448, 16, 70, "Input",
 CellTags->"b:3.1",
 CellID->18035],
Cell[51252, 1543, 9899, 267, 434, "Output",
 CellTags->"b:3.1",
 CellID->77692078]
}, Open  ]],
Cell[CellGroupData[{
Cell[61188, 1815, 146, 5, 70, "Input",
 CellTags->"b:3.1",
 CellID->15185],
Cell[61337, 1822, 292, 10, 36, "Output",
 CellTags->"b:3.1",
 CellID->552557984]
}, Open  ]],
Cell[61644, 1835, 419, 14, 70, "Text",
 CellTags->"b:3.1",
 CellID->9853],
Cell[CellGroupData[{
Cell[62088, 1853, 72, 1, 70, "RelatedTutorialsSection",
 CellID->782509925],
Cell[62163, 1856, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[62367, 1863, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

