(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22869,        864]
NotebookOptionsPosition[     14222,        562]
NotebookOutlinePosition[     19653,        733]
CellTagsIndexPosition[     19562,        727]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["The GeneratedParameters Option", "Title",
 CellTags->{"c:55", "b:5.4"},
 CellID->16565],

Cell[TextData[{
 "The general solution to a differential equation",
 " ",
 "contains undetermined coefficients that are labeled ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "2", "]"}]], "InlineFormula"],
 ", and so on. "
}], "Text",
 CellTags->"b:5.4",
 CellID->16036],

Cell[TextData[{
 "This example has one undetermined parameter, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:5.4",
 CellID->14736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], " ", "+", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", " ", "1"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:5.4",
 CellLabel->"In[1]:=",
 CellID->29141],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "x"}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.4",
 CellLabel->"Out[1]=",
 CellID->47412867]
}, Open  ]],

Cell[TextData[{
 "To change the name of the undetermined parameter, use the ",
 Cell[BoxData[
  ButtonBox["GeneratedParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeneratedParameters"]], "InlineFormula"],
 " option."
}], "Text",
 CellTags->"b:5.4",
 CellID->5994],

Cell[TextData[{
 "This changes the name of the undetermined coefficient to ",
 Cell[BoxData[
  RowBox[{"P", "[", "1", "]"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:5.4",
 CellID->8256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], " ", "+", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", " ", "1"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x", ",", " ", 
   RowBox[{"GeneratedParameters", " ", "\[Rule]", " ", "P"}]}], 
  "]"}]], "Input",
 CellTags->"b:5.4",
 CellLabel->"In[3]:=",
 CellID->6652],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "x"}]], " ", 
      RowBox[{"P", "[", "1", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.4",
 CellLabel->"Out[3]=",
 CellID->281601890]
}, Open  ]],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  ButtonBox["C",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/C"]], "InlineFormula"],
 " should be thought of as a pure function that acts on a set of indices to \
generate different constants ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:5.4",
 CellID->30838],

Cell[TextData[{
 "This shows the behavior of ",
 Cell[BoxData[
  ButtonBox["C",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/C"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:5.4",
 CellID->20482],

Cell[BoxData[
 RowBox[{
  RowBox[{"parameter", " ", "=", 
   RowBox[{
    RowBox[{"C", "[", "#", "]"}], "&"}]}], ";"}]], "Input",
 CellTags->"b:5.4",
 CellLabel->"In[4]:=",
 CellID->1355],

Cell[BoxData[
 RowBox[{
  RowBox[{"indexset", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], ";"}]], "Input",
 CellTags->"b:5.4",
 CellLabel->"In[5]:=",
 CellID->21015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parameter", "[", 
  RowBox[{"indexset", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}]], "Input",
 CellTags->"b:5.4",
 CellLabel->"In[6]:=",
 CellID->1131],

Cell[BoxData[
 RowBox[{"C", "[", "1", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.4",
 CellLabel->"Out[6]=",
 CellID->154528506]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parameter", "[", 
  RowBox[{"indexset", "[", 
   RowBox[{"[", "3", "]"}], "]"}], "]"}]], "Input",
 CellTags->"b:5.4",
 CellLabel->"In[7]:=",
 CellID->17841],

Cell[BoxData[
 RowBox[{"C", "[", "3", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.4",
 CellLabel->"Out[7]=",
 CellID->471575352]
}, Open  ]],

Cell[TextData[{
 "Internally, the use of a pure function allows ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " to increment the argument ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 " correctly for higher-order ODEs and systems of ODEs. "
}], "Text",
 CellTags->"b:5.4",
 CellID->2011],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GeneratedParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeneratedParameters"]], "InlineFormula"],
 " can be specified using a pure function."
}], "MathCaption",
 CellTags->"b:5.4",
 CellID->32637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], " ", "+", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", " ", "1"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x", ",", " ", 
   RowBox[{"GeneratedParameters", " ", "\[Rule]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"const", "[", "#", "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellTags->"b:5.4",
 CellLabel->"In[8]:=",
 CellID->4186],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"const", "[", "1", "]"}], " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"const", "[", "2", "]"}], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{311, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.4",
 CellLabel->"Out[8]=",
 CellID->452534489]
}, Open  ]],

Cell["\<\
Using a pure function is particularly useful if you want to begin indexing \
the parameters at any value other than the default (1).\
\>", "Text",
 CellTags->"b:5.4",
 CellID->1650],

Cell[TextData[{
 "This uses a pure function to label the parameters in the previous example",
 " ",
 Cell[BoxData[
  RowBox[{
   StyleBox["const", "TI"], "[", "2", "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   StyleBox["const", "TI"], "[", "3", "]"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:5.4",
 CellID->5662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], " ", "+", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", " ", "1"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x", ",", " ", 
   RowBox[{"GeneratedParameters", " ", "\[Rule]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"const", "[", 
       RowBox[{"1", "+", "#"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellTags->"b:5.4",
 CellLabel->"In[9]:=",
 CellID->21634],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"const", "[", "2", "]"}], " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"const", "[", "3", "]"}], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{311, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.4",
 CellLabel->"Out[9]=",
 CellID->203375411]
}, Open  ]],

Cell["\<\
It is sometimes useful to display the solution using subscripts or other \
styles for the parameter indices.\
\>", "Text",
 CellTags->"b:5.4",
 CellID->237756888],

Cell["Here, the parameters are named using subscripted variables.", \
"MathCaption",
 CellTags->"b:5.4",
 CellID->60303112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], " ", "+", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", " ", "1"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x", ",", " ", 
   RowBox[{"GeneratedParameters", " ", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["c", "#1"], "&"}], ")"}]}]}], "]"}]], "Input",
 CellTags->"b:5.4",
 CellLabel->"In[4]:=",
 CellID->198995984],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      SubscriptBox["c", "1"]}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], " ", 
      SubscriptBox["c", "2"]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{224, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.4",
 CellLabel->"Out[4]=",
 CellID->261641070]
}, Open  ]],

Cell[TextData[{
 "Finally, with ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " variables, you can get names for the parameters that are unique across \
different invocations of ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:5.4",
 CellID->10353],

Cell[TextData[{
 "Here the same ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " call generates different parameter names."
}], "MathCaption",
 CellTags->"b:5.4",
 CellID->21416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], " ", "+", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", " ", "1"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x", ",", " ", 
   RowBox[{"GeneratedParameters", " ", "\[Rule]", " ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "C", "}"}], ",", " ", 
      RowBox[{
       RowBox[{"C", "[", "#", "]"}], "&"}]}], "]"}]}]}], "]"}]], "Input",
 CellTags->"b:5.4",
 CellLabel->"In[10]:=",
 CellID->13452],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      RowBox[{"C$102", "[", "1", "]"}]}], "+", 
     RowBox[{
      RowBox[{"C$102", "[", "2", "]"}], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{311, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.4",
 CellLabel->"Out[10]=",
 CellID->723633624]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], " ", "+", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", " ", "1"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x", ",", " ", 
   RowBox[{"GeneratedParameters", " ", "\[Rule]", " ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "C", "}"}], ",", " ", 
      RowBox[{
       RowBox[{"C", "[", "#", "]"}], "&"}]}], "]"}]}]}], "]"}]], "Input",
 CellTags->"b:5.4",
 CellLabel->"In[11]:=",
 CellID->7262],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      RowBox[{"C$106", "[", "1", "]"}]}], "+", 
     RowBox[{
      RowBox[{"C$106", "[", "2", "]"}], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{311, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.4",
 CellLabel->"Out[11]=",
 CellID->188876633]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->336754120],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The GeneratedParameters Option - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolvePlottingTheSolution"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveSymbolicAndInexactQuantities"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 20.9066874}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The general solution to a differential equation contains undetermined \
coefficients that are labeled C[1], C[2], and so on. This example has one \
undetermined parameter, C[1]. To change the name of the undetermined \
parameter, use the GeneratedParameters option.", "synonyms" -> {}, "title" -> 
    "The GeneratedParameters Option", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveGeneratedParametersOption"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:55"->{
  Cell[1280, 43, 93, 2, 70, "Title",
   CellTags->{"c:55", "b:5.4"},
   CellID->16565]},
 "b:5.4"->{
  Cell[1280, 43, 93, 2, 70, "Title",
   CellTags->{"c:55", "b:5.4"},
   CellID->16565],
  Cell[1376, 47, 474, 18, 70, "Text",
   CellTags->"b:5.4",
   CellID->16036],
  Cell[1853, 67, 261, 10, 70, "MathCaption",
   CellTags->"b:5.4",
   CellID->14736],
  Cell[2139, 81, 335, 11, 28, "Input",
   CellTags->"b:5.4",
   CellID->29141],
  Cell[2477, 94, 431, 15, 36, "Output",
   CellTags->"b:5.4",
   CellID->47412867],
  Cell[2923, 112, 278, 9, 70, "Text",
   CellTags->"b:5.4",
   CellID->5994],
  Cell[3204, 123, 202, 7, 70, "MathCaption",
   CellTags->"b:5.4",
   CellID->8256],
  Cell[3431, 134, 410, 13, 28, "Input",
   CellTags->"b:5.4",
   CellID->6652],
  Cell[3844, 149, 432, 15, 36, "Output",
   CellTags->"b:5.4",
   CellID->281601890],
  Cell[4291, 167, 458, 17, 70, "Text",
   CellTags->"b:5.4",
   CellID->30838],
  Cell[4752, 186, 212, 9, 70, "MathCaption",
   CellTags->"b:5.4",
   CellID->20482],
  Cell[4967, 197, 187, 7, 70, "Input",
   CellTags->"b:5.4",
   CellID->1355],
  Cell[5157, 206, 212, 7, 70, "Input",
   CellTags->"b:5.4",
   CellID->21015],
  Cell[5394, 217, 179, 6, 70, "Input",
   CellTags->"b:5.4",
   CellID->1131],
  Cell[5576, 225, 205, 7, 36, "Output",
   CellTags->"b:5.4",
   CellID->154528506],
  Cell[5818, 237, 180, 6, 70, "Input",
   CellTags->"b:5.4",
   CellID->17841],
  Cell[6001, 245, 205, 7, 36, "Output",
   CellTags->"b:5.4",
   CellID->471575352],
  Cell[6221, 255, 547, 19, 70, "Text",
   CellTags->"b:5.4",
   CellID->2011],
  Cell[6771, 276, 255, 8, 70, "MathCaption",
   CellTags->"b:5.4",
   CellID->32637],
  Cell[7051, 288, 490, 15, 70, "Input",
   CellTags->"b:5.4",
   CellID->4186],
  Cell[7544, 305, 511, 17, 36, "Output",
   CellTags->"b:5.4",
   CellID->452534489],
  Cell[8070, 325, 191, 5, 70, "Text",
   CellTags->"b:5.4",
   CellID->1650],
  Cell[8264, 332, 348, 13, 70, "MathCaption",
   CellTags->"b:5.4",
   CellID->5662],
  Cell[8637, 349, 519, 16, 70, "Input",
   CellTags->"b:5.4",
   CellID->21634],
  Cell[9159, 367, 511, 17, 36, "Output",
   CellTags->"b:5.4",
   CellID->203375411],
  Cell[9685, 387, 172, 5, 70, "Text",
   CellTags->"b:5.4",
   CellID->237756888],
  Cell[9860, 394, 123, 3, 70, "MathCaption",
   CellTags->"b:5.4",
   CellID->60303112],
  Cell[10008, 401, 481, 15, 70, "Input",
   CellTags->"b:5.4",
   CellID->198995984],
  Cell[10492, 418, 491, 17, 36, "Output",
   CellTags->"b:5.4",
   CellID->261641070],
  Cell[10998, 438, 421, 15, 70, "Text",
   CellTags->"b:5.4",
   CellID->10353],
  Cell[11422, 455, 250, 9, 70, "MathCaption",
   CellTags->"b:5.4",
   CellID->21416],
  Cell[11697, 468, 558, 17, 70, "Input",
   CellTags->"b:5.4",
   CellID->13452],
  Cell[12258, 487, 512, 17, 36, "Output",
   CellTags->"b:5.4",
   CellID->723633624],
  Cell[12807, 509, 557, 17, 70, "Input",
   CellTags->"b:5.4",
   CellID->7262],
  Cell[13367, 528, 512, 17, 36, "Output",
   CellTags->"b:5.4",
   CellID->188876633]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:55", 16525, 614},
 {"b:5.4", 16626, 618}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 93, 2, 70, "Title",
 CellTags->{"c:55", "b:5.4"},
 CellID->16565],
Cell[1376, 47, 474, 18, 70, "Text",
 CellTags->"b:5.4",
 CellID->16036],
Cell[1853, 67, 261, 10, 70, "MathCaption",
 CellTags->"b:5.4",
 CellID->14736],
Cell[CellGroupData[{
Cell[2139, 81, 335, 11, 28, "Input",
 CellTags->"b:5.4",
 CellID->29141],
Cell[2477, 94, 431, 15, 36, "Output",
 CellTags->"b:5.4",
 CellID->47412867]
}, Open  ]],
Cell[2923, 112, 278, 9, 70, "Text",
 CellTags->"b:5.4",
 CellID->5994],
Cell[3204, 123, 202, 7, 70, "MathCaption",
 CellTags->"b:5.4",
 CellID->8256],
Cell[CellGroupData[{
Cell[3431, 134, 410, 13, 28, "Input",
 CellTags->"b:5.4",
 CellID->6652],
Cell[3844, 149, 432, 15, 36, "Output",
 CellTags->"b:5.4",
 CellID->281601890]
}, Open  ]],
Cell[4291, 167, 458, 17, 70, "Text",
 CellTags->"b:5.4",
 CellID->30838],
Cell[4752, 186, 212, 9, 70, "MathCaption",
 CellTags->"b:5.4",
 CellID->20482],
Cell[4967, 197, 187, 7, 70, "Input",
 CellTags->"b:5.4",
 CellID->1355],
Cell[5157, 206, 212, 7, 70, "Input",
 CellTags->"b:5.4",
 CellID->21015],
Cell[CellGroupData[{
Cell[5394, 217, 179, 6, 70, "Input",
 CellTags->"b:5.4",
 CellID->1131],
Cell[5576, 225, 205, 7, 36, "Output",
 CellTags->"b:5.4",
 CellID->154528506]
}, Open  ]],
Cell[CellGroupData[{
Cell[5818, 237, 180, 6, 70, "Input",
 CellTags->"b:5.4",
 CellID->17841],
Cell[6001, 245, 205, 7, 36, "Output",
 CellTags->"b:5.4",
 CellID->471575352]
}, Open  ]],
Cell[6221, 255, 547, 19, 70, "Text",
 CellTags->"b:5.4",
 CellID->2011],
Cell[6771, 276, 255, 8, 70, "MathCaption",
 CellTags->"b:5.4",
 CellID->32637],
Cell[CellGroupData[{
Cell[7051, 288, 490, 15, 70, "Input",
 CellTags->"b:5.4",
 CellID->4186],
Cell[7544, 305, 511, 17, 36, "Output",
 CellTags->"b:5.4",
 CellID->452534489]
}, Open  ]],
Cell[8070, 325, 191, 5, 70, "Text",
 CellTags->"b:5.4",
 CellID->1650],
Cell[8264, 332, 348, 13, 70, "MathCaption",
 CellTags->"b:5.4",
 CellID->5662],
Cell[CellGroupData[{
Cell[8637, 349, 519, 16, 70, "Input",
 CellTags->"b:5.4",
 CellID->21634],
Cell[9159, 367, 511, 17, 36, "Output",
 CellTags->"b:5.4",
 CellID->203375411]
}, Open  ]],
Cell[9685, 387, 172, 5, 70, "Text",
 CellTags->"b:5.4",
 CellID->237756888],
Cell[9860, 394, 123, 3, 70, "MathCaption",
 CellTags->"b:5.4",
 CellID->60303112],
Cell[CellGroupData[{
Cell[10008, 401, 481, 15, 70, "Input",
 CellTags->"b:5.4",
 CellID->198995984],
Cell[10492, 418, 491, 17, 36, "Output",
 CellTags->"b:5.4",
 CellID->261641070]
}, Open  ]],
Cell[10998, 438, 421, 15, 70, "Text",
 CellTags->"b:5.4",
 CellID->10353],
Cell[11422, 455, 250, 9, 70, "MathCaption",
 CellTags->"b:5.4",
 CellID->21416],
Cell[CellGroupData[{
Cell[11697, 468, 558, 17, 70, "Input",
 CellTags->"b:5.4",
 CellID->13452],
Cell[12258, 487, 512, 17, 36, "Output",
 CellTags->"b:5.4",
 CellID->723633624]
}, Open  ]],
Cell[CellGroupData[{
Cell[12807, 509, 557, 17, 70, "Input",
 CellTags->"b:5.4",
 CellID->7262],
Cell[13367, 528, 512, 17, 36, "Output",
 CellTags->"b:5.4",
 CellID->188876633]
}, Open  ]],
Cell[CellGroupData[{
Cell[13916, 550, 72, 1, 70, "RelatedTutorialsSection",
 CellID->336754120],
Cell[13991, 553, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[14195, 560, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

