(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15391,        472]
NotebookOptionsPosition[     10640,        323]
NotebookOutlinePosition[     14165,        425]
CellTagsIndexPosition[     14070,        419]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Higher-Order Euler and Legendre Equations", "Title",
 CellTags->{"c:29", "b:1.1.3.2"},
 CellID->5454],

Cell[TextData[{
 "An ",
 StyleBox["Euler equation",
  FontSlant->"Italic"],
 " is an ODE of the form"
}], "Text",
 CellTags->"b:1.1.3.2",
 CellID->16303],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "n"], 
       RowBox[{
        SuperscriptBox["y", 
         RowBox[{"(", "n", ")"}],
         MultilineFunction->None], "(", "x", ")"}]}], "+", 
      RowBox[{
       SubscriptBox["a", "1"], 
       SuperscriptBox["x", 
        RowBox[{"n", "-", "1"}]], 
       RowBox[{
        SuperscriptBox["y", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}],
         MultilineFunction->None], "(", "x", ")"}]}], "+", 
      RowBox[{
       SubscriptBox["a", "2"], 
       SuperscriptBox["x", 
        RowBox[{"n", "-", "2"}]], 
       RowBox[{
        SuperscriptBox["y", 
         RowBox[{"(", 
          RowBox[{"n", "-", "2"}], ")"}],
         MultilineFunction->None], "(", "x", ")"}]}]}], "\[Ellipsis]"}], "+", 
    
    RowBox[{
     SubscriptBox["a", "n"], 
     RowBox[{"y", "(", "x", ")"}]}]}], "\[LongEqual]", "0."}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:1.1.3.2",
 CellID->16634],

Cell["The following is an example of an Euler equation.", "MathCaption",
 CellTags->"b:1.1.3.2",
 CellID->26303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "4"}], "*", 
      RowBox[{
       RowBox[{"y", "''''"}], "[", "x", "]"}]}], " ", "-", 
     RowBox[{"2", "*", 
      RowBox[{"x", "^", "3"}], "*", 
      RowBox[{
       RowBox[{"y", "'''"}], "[", "x", "]"}]}], " ", "-", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "*", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], " ", "+", 
     RowBox[{"5", "*", "x", "*", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", "0"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.3.2",
 CellLabel->"In[1]:=",
 CellID->14256],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWUtPFEEQHubBLiwgYIKAoAQ5GePF9fUHfMaz5w0xgYPRIEf4LV6NP8EY
Y+LJk/yjcR7du71fV0/VzI47uxNJlpnuqq7u/rqquqe/N4Pzk3fvB+enx4OD
52eDjyenx58Onn04S6qCBc9b+ON5Xn/bS97j5C37pX9XyS9//ZL8/KQ6Us/b
Q8nX9C3QLWIvhPLeDGj+VqPuqed3KC+KrZi1PSh/Y+Role5lT43JV8/PyTNQ
yJvagaOemovEXqTqg0qj3s9Eo9q8Hy8a1uSVVmtfpIVziir2hnZ8ym7BXG9m
dm8pJHfU80I9O0xvXO9pb5HyRtP+ZUx7KWVvkVhBzrt3rVmZ0gsGo7KzpPSp
fi+ZUZP9sB4gW2Hbm7cnREVHIadnezb2XBaXwLLIRbQsL92YEBHOT1aZ/sri
YMopz5Ch8BRq96GM8i0oY47IUKopS94tOTZEFMcWinqtB9c7cb775GIt9FU2
w+cYgirzBspXltUTdfKG+V+o9FYInNP6LtQvq+wbatujeFKjorwvVPVaHhjl
rUbmu+qYL668rgsJ277RN3qyOWOd14O4zBnrKAPPzFb5f7M3z1W2s9zYOoUE
mmiHQjvT6UAcxLa3U+21HxjrLGwVWa2K9nV51njUMoS1n5ZDOBIh3AErMoSP
QMvt6cM4EqwH7qfUuQrxp2ZOxXNV7Hsg5/S7BX1R3p3mjSVm/P0W4LgCconP
S3HsKBy7MZ3PD6FckJfHol+fy3R+N/cbat8q+g6QzJnE29qHI8rKmFbg2fs7
uda0bSHqrl0y65nOya1BFyNWhm5YAV1uR0R5VV/HmxwOPR1zqd5wf8P4tbwg
MrUtqYmqV2DbtdORetbacQj2ZxKb5YrYhEI97W/m2Mv7VfqNk0K3aSHvwxwQ
N8/ICN14FC/45WHq4RjwjI9RKWln6gVqNtQ3lFl+0OisuUzvaodxgLNeiyk/
PIypW3L87n4CZbz5Woe+N0H+krG3C+VrYO86yF+Qo3wMrbYJK75gdGhnJ7Zn
54tHhXPF2zG0sh4Xj45bC5zdhnOU5k3w63j85vZVppU2uII3817QV2Z/ZRLu
Hn5eNNPICY0Zas7lJ5SRk1kTWefKuDv9YOQch7NSfVRW7nPlHsyJUgYnlUdM
LqvDHu4kWc4m2Qw8h1A34Pa9AmqQPFoF9ocr18UyyW5raRT1OX/YP47HyJwU
I+i6aVvybF5JyltJcJyEt6JOrM4TLOtntneghgsn9DPtsZMyYmX9ri5GjOuX
9kBJPhfGQGFUY5bjma9/jXv93BsVoRVXwPpS0zeX+R/9Te3aYTZAPimXxyFd
N5fHcYeyXRrjHcv3oTwdro8rN8PyyaJejrt50ku/V0yPztVmlvsD2677Y/NL
1TzhzxnzZ+UdarcuYjpl5/iHGXSjsj7kzCsrNXXej43NfssQnjrvV3iaybKy
yMt19M4rV/Wf86sHx2lwfhyOcq9tDzvVHPdHnvYxQ7cG5+ZYQA7nql4/C0zX
dFjA8p46C9hMiwXkONLcv/Dcn2LWPvav52jXTtaP+oqyV/4t1M4a30ePsmm+
T4Zd03zfaJRFfN+9TCttkLN83sJfaqMjLA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{463, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.2",
 CellLabel->"Out[1]=",
 CellID->32738682]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["Legendre linear",
  FontSlant->"Italic"],
 " equation is a generalization of the Euler equation. It has the form "
}], "Text",
 CellTags->"b:1.1.3.2",
 CellID->11124],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", "x"}], "+", "d"}], ")"}], "n"], 
       RowBox[{
        SuperscriptBox["y", 
         RowBox[{"(", "n", ")"}],
         MultilineFunction->None], "(", "x", ")"}]}], "+", 
      RowBox[{
       SubscriptBox["a", "1"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", "x"}], "+", "d"}], ")"}], 
        RowBox[{"n", "-", "1"}]], 
       RowBox[{
        SuperscriptBox["y", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}],
         MultilineFunction->None], "(", "x", ")"}]}], "+", 
      RowBox[{
       SubscriptBox["a", "2"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", "x"}], "+", "d"}], ")"}], 
        RowBox[{"n", "-", "2"}]], 
       RowBox[{
        SuperscriptBox["y", 
         RowBox[{"(", 
          RowBox[{"n", "-", "2"}], ")"}],
         MultilineFunction->None], "(", "x", ")"}]}]}], "\[Ellipsis]"}], "+", 
    
    RowBox[{
     SubscriptBox["a", "n"], 
     RowBox[{"y", "(", "x", ")"}]}]}], "\[LongEqual]", "0."}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:1.1.3.2",
 CellID->12317],

Cell["This is a Legendre linear equation.", "MathCaption",
 CellTags->"b:1.1.3.2",
 CellID->4213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", "x"}], "+", "5"}], ")"}], "^", "4"}], "*", 
      RowBox[{
       RowBox[{"y", "''''"}], "[", "x", "]"}]}], " ", "-", 
     RowBox[{"2", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", "x"}], "+", "5"}], ")"}], "^", "3"}], "*", 
      RowBox[{
       RowBox[{"y", "'''"}], "[", "x", "]"}]}], " ", "-", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", "x"}], "+", "5"}], ")"}], "^", "2"}], "*", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], " ", "+", 
     RowBox[{"5", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", "x"}], "+", "5"}], ")"}], "*", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", "0"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.3.2",
 CellLabel->"In[2]:=",
 CellID->27109],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{566, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.2",
 CellLabel->"Out[2]=",
 CellID->269242451]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->8181457],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Higher-Order Euler and Legendre Equations - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveHigherOrderODEsWithConstantCoefficients"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveHigherOrderExactEquations"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 21.3598240}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "An Euler equation is an ODE of the form The following is an example of \
an Euler equation. The Legendre linear equation is a generalization of the \
Euler equation. It has the form ", "synonyms" -> {}, "title" -> 
    "Higher-Order Euler and Legendre Equations", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveHigherOrderEulerAndLegendreEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:29"->{
  Cell[1280, 43, 107, 2, 70, "Title",
   CellTags->{"c:29", "b:1.1.3.2"},
   CellID->5454]},
 "b:1.1.3.2"->{
  Cell[1280, 43, 107, 2, 70, "Title",
   CellTags->{"c:29", "b:1.1.3.2"},
   CellID->5454],
  Cell[1390, 47, 153, 7, 70, "Text",
   CellTags->"b:1.1.3.2",
   CellID->16303],
  Cell[1546, 56, 1028, 36, 70, "DisplayMath",
   CellTags->"b:1.1.3.2",
   CellID->16634],
  Cell[2577, 94, 112, 2, 70, "MathCaption",
   CellTags->"b:1.1.3.2",
   CellID->26303],
  Cell[2714, 100, 752, 24, 28, "Input",
   CellTags->"b:1.1.3.2",
   CellID->14256],
  Cell[3469, 126, 1857, 35, 73, "Output",
   Evaluatable->False,
   CellTags->"b:1.1.3.2",
   CellID->32738682],
  Cell[5341, 164, 202, 7, 70, "Text",
   CellTags->"b:1.1.3.2",
   CellID->11124],
  Cell[5546, 173, 1283, 45, 70, "DisplayMath",
   CellTags->"b:1.1.3.2",
   CellID->12317],
  Cell[6832, 220, 97, 2, 70, "MathCaption",
   CellTags->"b:1.1.3.2",
   CellID->4213],
  Cell[6954, 226, 1077, 36, 47, "Input",
   CellTags->"b:1.1.3.2",
   CellID->27109],
  Cell[8034, 264, 2265, 42, 95, "Output",
   Evaluatable->False,
   CellTags->"b:1.1.3.2",
   CellID->269242451]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:29", 12922, 376},
 {"b:1.1.3.2", 13031, 380}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 107, 2, 70, "Title",
 CellTags->{"c:29", "b:1.1.3.2"},
 CellID->5454],
Cell[1390, 47, 153, 7, 70, "Text",
 CellTags->"b:1.1.3.2",
 CellID->16303],
Cell[1546, 56, 1028, 36, 70, "DisplayMath",
 CellTags->"b:1.1.3.2",
 CellID->16634],
Cell[2577, 94, 112, 2, 70, "MathCaption",
 CellTags->"b:1.1.3.2",
 CellID->26303],
Cell[CellGroupData[{
Cell[2714, 100, 752, 24, 28, "Input",
 CellTags->"b:1.1.3.2",
 CellID->14256],
Cell[3469, 126, 1857, 35, 73, "Output",
 Evaluatable->False,
 CellTags->"b:1.1.3.2",
 CellID->32738682]
}, Open  ]],
Cell[5341, 164, 202, 7, 70, "Text",
 CellTags->"b:1.1.3.2",
 CellID->11124],
Cell[5546, 173, 1283, 45, 70, "DisplayMath",
 CellTags->"b:1.1.3.2",
 CellID->12317],
Cell[6832, 220, 97, 2, 70, "MathCaption",
 CellTags->"b:1.1.3.2",
 CellID->4213],
Cell[CellGroupData[{
Cell[6954, 226, 1077, 36, 47, "Input",
 CellTags->"b:1.1.3.2",
 CellID->27109],
Cell[8034, 264, 2265, 42, 95, "Output",
 Evaluatable->False,
 CellTags->"b:1.1.3.2",
 CellID->269242451]
}, Open  ]],
Cell[CellGroupData[{
Cell[10336, 311, 70, 1, 70, "RelatedTutorialsSection",
 CellID->8181457],
Cell[10409, 314, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[10613, 321, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

