(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20555,        655]
NotebookOptionsPosition[     13980,        437]
NotebookOutlinePosition[     18367,        571]
CellTagsIndexPosition[     18220,        563]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Exact Higher-Order Equations", "Title",
 CellTags->{"c:30", "b:1.1.3.3"},
 CellID->29200],

Cell[TextData[{
 "A linear ordinary differential equation of order ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"]
}], "Text",
 CellTags->"b:1.0",
 CellID->12290],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["a", "0"], "(", "x", ")"}], 
        FormBox[
         RowBox[{
          SuperscriptBox["y", 
           RowBox[{"(", "n", ")"}]], "(", "x"}],
         TraditionalForm]}], ")"}], "+", 
      RowBox[{
       RowBox[{
        SubscriptBox["a", "1"], "(", "x", ")"}], 
       RowBox[{
        FormBox[
         SuperscriptBox["y", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]],
         TraditionalForm], "(", "x", ")"}]}], "+"}], "\[Ellipsis]"}], "+", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", 
       RowBox[{"n", "-", "1"}]], "(", "x", ")"}], 
     RowBox[{
      SuperscriptBox["y", "\[Prime]"], "(", "x", ")"}]}], "+", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "n"], "(", "x", ")"}], 
     RowBox[{"y", "(", "x", ")"}]}]}], "\[LongEqual]", "0"}], 
  TraditionalForm]], "DisplayMath",
 CellID->13744723],

Cell[TextData[{
 "is said to be ",
 StyleBox["exact",
  FontSlant->"Italic"],
 " ",
 "if "
}], "Text",
 FontSize->12,
 CellTags->"b:1.1.1.3",
 CellID->42920136],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "n"], 
        FormBox[
         RowBox[{
          SuperscriptBox[
           SubscriptBox["a", "0"], 
           RowBox[{"(", "n", ")"}]], "(", "x"}],
         TraditionalForm]}], ")"}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]], 
       RowBox[{
        FormBox[
         SuperscriptBox[
          SubscriptBox["a", "1"], 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]],
         TraditionalForm], "(", "x", ")"}]}], "+"}], "\[Ellipsis]"}], "-", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["a", 
       RowBox[{"n", "-", "1"}]], "\[Prime]"], "(", "x", ")"}], "+", 
    RowBox[{
     SubscriptBox["a", "n"], "(", "x", ")"}]}], "\[LongEqual]", "0."}], 
  TraditionalForm]], "DisplayMath",
 CellID->44544190],

Cell[TextData[{
 "The condition of exactness can be used to reduce the problem to that of \
solving an equation of order ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "-", "1"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellTags->"b:1.0",
 CellID->132507362],

Cell["This is an example of an exact ODE.", "MathCaption",
 CellTags->"b:1.1.3.3",
 CellID->21080],

Cell[BoxData[
 RowBox[{
  RowBox[{"a0", " ", "=", " ", "1"}], ";"}]], "Input",
 CellTags->"b:1.1.3.3",
 CellLabel->"In[12]:=",
 CellID->21318],

Cell[BoxData[
 RowBox[{
  RowBox[{"a1", "=", 
   RowBox[{"-", "1"}]}], " ", ";"}]], "Input",
 CellTags->"b:1.1.3.3",
 CellLabel->"In[13]:=",
 CellID->16858],

Cell[BoxData[
 RowBox[{
  RowBox[{"a2", "=", 
   RowBox[{"5", "x"}]}], ";"}]], "Input",
 CellTags->"b:1.1.3.3",
 CellLabel->"In[14]:=",
 CellID->24050],

Cell[BoxData[
 RowBox[{
  RowBox[{"a3", "=", "5"}], ";"}]], "Input",
 CellTags->"b:1.1.3.3",
 CellLabel->"In[15]:=",
 CellID->24155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExactODE", "=", 
  RowBox[{
   RowBox[{"a0", "*", 
    RowBox[{
     RowBox[{"y", "'''"}], "[", "x", "]"}]}], " ", "+", 
   RowBox[{"a1", "*", 
    RowBox[{
     RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
   RowBox[{"a2", "*", 
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
   RowBox[{"a3", "*", 
    RowBox[{"y", "[", "x", "]"}]}]}]}]], "Input",
 CellTags->"b:1.1.3.3",
 CellLabel->"In[16]:=",
 CellID->31361],

Cell[BoxData[
 RowBox[{
  RowBox[{"5", " ", 
   RowBox[{"y", "[", "x", "]"}]}], "+", 
  RowBox[{"5", " ", "x", " ", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["y", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "x", "]"}], "+", 
  RowBox[{
   SuperscriptBox["y", 
    TagBox[
     RowBox[{"(", "3", ")"}],
     Derivative],
    MultilineFunction->None], "[", "x", "]"}]}]], "Output",
 ImageSize->{210, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.3",
 CellLabel->"Out[16]=",
 CellID->287310150]
}, Open  ]],

Cell["This verifies the condition for exactness.", "MathCaption",
 CellTags->"b:1.1.3.3",
 CellID->11903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conditionforexactness", "=", " ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"D", "[", 
     RowBox[{"a0", ",", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", "3"}], "}"}]}], "]"}]}], "+", 
   RowBox[{"D", "[", 
    RowBox[{"a1", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "2"}], "}"}]}], "]"}], "-", 
   RowBox[{"D", "[", 
    RowBox[{"a2", ",", "x"}], "]"}], "+", "a3"}]}]], "Input",
 CellTags->"b:1.1.3.3",
 CellLabel->"In[17]:=",
 CellID->3676],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.3",
 CellLabel->"Out[17]=",
 CellID->40982742]
}, Open  ]],

Cell["This solves the equation.", "MathCaption",
 CellTags->"b:1.1.3.3",
 CellID->26909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"ExactODE", "\[Equal]", "0"}], ",", " ", "y", ",", "x"}], 
   "]"}]}]], "Input",
 CellTags->"b:1.1.3.3",
 CellLabel->"In[18]:=",
 CellID->14902],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{583, 232},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.3",
 CellLabel->"Out[18]=",
 CellID->158151696]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
 CellTags->"b:1.1.3.3",
 CellID->28489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ExactODE", "/.", 
      RowBox[{"sol", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "/.", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", " ", 
        RowBox[{"RandomReal", "[", "]"}]}], ",", " ", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "\[Rule]", " ", 
        RowBox[{"RandomReal", "[", "]"}]}], ",", " ", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], "\[Rule]", " ", 
        RowBox[{"RandomReal", "[", "]"}]}]}], "}"}]}], "//", "N"}], "//", 
   "Simplify"}], "//", "Chop"}]], "Input",
 CellTags->"b:1.1.3.3",
 CellLabel->"In[19]:=",
 CellID->24948],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.3.3",
 CellLabel->"Out[19]=",
 CellID->508481951]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"a0", ",", "a1", ",", "a2", ",", "a3"}], "]"}]], "Input",
 CellTags->"b:1.1.3.3",
 CellLabel->"In[20]:=",
 CellID->13653],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->361824569],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Exact Higher-Order Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveHigherOrderEulerAndLegendreEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveFurtherHigherOrderODEs"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 21.6567066}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "A linear ordinary differential equation of order n is said to be exact \
if The condition of exactness can be used to reduce the problem to that of \
solving an equation of order n-1.", "synonyms" -> {}, "title" -> 
    "Exact Higher-Order Equations", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveHigherOrderExactEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:30"->{
  Cell[1280, 43, 95, 2, 70, "Title",
   CellTags->{"c:30", "b:1.1.3.3"},
   CellID->29200]},
 "b:1.1.3.3"->{
  Cell[1280, 43, 95, 2, 70, "Title",
   CellTags->{"c:30", "b:1.1.3.3"},
   CellID->29200],
  Cell[4036, 153, 98, 2, 70, "MathCaption",
   CellTags->"b:1.1.3.3",
   CellID->21080],
  Cell[4137, 157, 142, 5, 70, "Input",
   CellTags->"b:1.1.3.3",
   CellID->21318],
  Cell[4282, 164, 156, 6, 70, "Input",
   CellTags->"b:1.1.3.3",
   CellID->16858],
  Cell[4441, 172, 151, 6, 70, "Input",
   CellTags->"b:1.1.3.3",
   CellID->24050],
  Cell[4595, 180, 132, 5, 70, "Input",
   CellTags->"b:1.1.3.3",
   CellID->24155],
  Cell[4752, 189, 454, 16, 70, "Input",
   CellTags->"b:1.1.3.3",
   CellID->31361],
  Cell[5209, 207, 638, 22, 36, "Output",
   CellTags->"b:1.1.3.3",
   CellID->287310150],
  Cell[5862, 232, 105, 2, 70, "MathCaption",
   CellTags->"b:1.1.3.3",
   CellID->11903],
  Cell[5992, 238, 480, 16, 70, "Input",
   CellTags->"b:1.1.3.3",
   CellID->3676],
  Cell[6475, 256, 182, 6, 36, "Output",
   CellTags->"b:1.1.3.3",
   CellID->40982742],
  Cell[6672, 265, 88, 2, 70, "MathCaption",
   CellTags->"b:1.1.3.3",
   CellID->26909],
  Cell[6785, 271, 230, 8, 28, "Input",
   CellTags->"b:1.1.3.3",
   CellID->14902],
  Cell[7018, 281, 5455, 94, 253, "Output",
   Evaluatable->False,
   CellTags->"b:1.1.3.3",
   CellID->158151696],
  Cell[12488, 378, 90, 2, 70, "MathCaption",
   CellTags->"b:1.1.3.3",
   CellID->28489],
  Cell[12603, 384, 676, 21, 70, "Input",
   CellTags->"b:1.1.3.3",
   CellID->24948],
  Cell[13282, 407, 183, 6, 36, "Output",
   CellTags->"b:1.1.3.3",
   CellID->508481951],
  Cell[13480, 416, 169, 5, 70, "Input",
   CellTags->"b:1.1.3.3",
   CellID->13653]},
 "b:1.0"->{
  Cell[1378, 47, 173, 6, 70, "Text",
   CellTags->"b:1.0",
   CellID->12290],
  Cell[3765, 142, 268, 9, 70, "Text",
   CellTags->"b:1.0",
   CellID->132507362]},
 "b:1.1.1.3"->{
  Cell[2548, 92, 160, 9, 70, "Text",
   CellTags->"b:1.1.1.3",
   CellID->42920136]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:30", 16218, 489},
 {"b:1.1.3.3", 16327, 493},
 {"b:1.0", 17933, 549},
 {"b:1.1.1.3", 18111, 556}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 95, 2, 70, "Title",
 CellTags->{"c:30", "b:1.1.3.3"},
 CellID->29200],
Cell[1378, 47, 173, 6, 70, "Text",
 CellTags->"b:1.0",
 CellID->12290],
Cell[1554, 55, 991, 35, 70, "DisplayMath",
 CellID->13744723],
Cell[2548, 92, 160, 9, 70, "Text",
 CellTags->"b:1.1.1.3",
 CellID->42920136],
Cell[2711, 103, 1051, 37, 70, "DisplayMath",
 CellID->44544190],
Cell[3765, 142, 268, 9, 70, "Text",
 CellTags->"b:1.0",
 CellID->132507362],
Cell[4036, 153, 98, 2, 70, "MathCaption",
 CellTags->"b:1.1.3.3",
 CellID->21080],
Cell[4137, 157, 142, 5, 70, "Input",
 CellTags->"b:1.1.3.3",
 CellID->21318],
Cell[4282, 164, 156, 6, 70, "Input",
 CellTags->"b:1.1.3.3",
 CellID->16858],
Cell[4441, 172, 151, 6, 70, "Input",
 CellTags->"b:1.1.3.3",
 CellID->24050],
Cell[4595, 180, 132, 5, 70, "Input",
 CellTags->"b:1.1.3.3",
 CellID->24155],
Cell[CellGroupData[{
Cell[4752, 189, 454, 16, 70, "Input",
 CellTags->"b:1.1.3.3",
 CellID->31361],
Cell[5209, 207, 638, 22, 36, "Output",
 CellTags->"b:1.1.3.3",
 CellID->287310150]
}, Open  ]],
Cell[5862, 232, 105, 2, 70, "MathCaption",
 CellTags->"b:1.1.3.3",
 CellID->11903],
Cell[CellGroupData[{
Cell[5992, 238, 480, 16, 70, "Input",
 CellTags->"b:1.1.3.3",
 CellID->3676],
Cell[6475, 256, 182, 6, 36, "Output",
 CellTags->"b:1.1.3.3",
 CellID->40982742]
}, Open  ]],
Cell[6672, 265, 88, 2, 70, "MathCaption",
 CellTags->"b:1.1.3.3",
 CellID->26909],
Cell[CellGroupData[{
Cell[6785, 271, 230, 8, 28, "Input",
 CellTags->"b:1.1.3.3",
 CellID->14902],
Cell[7018, 281, 5455, 94, 253, "Output",
 Evaluatable->False,
 CellTags->"b:1.1.3.3",
 CellID->158151696]
}, Open  ]],
Cell[12488, 378, 90, 2, 70, "MathCaption",
 CellTags->"b:1.1.3.3",
 CellID->28489],
Cell[CellGroupData[{
Cell[12603, 384, 676, 21, 70, "Input",
 CellTags->"b:1.1.3.3",
 CellID->24948],
Cell[13282, 407, 183, 6, 36, "Output",
 CellTags->"b:1.1.3.3",
 CellID->508481951]
}, Open  ]],
Cell[13480, 416, 169, 5, 70, "Input",
 CellTags->"b:1.1.3.3",
 CellID->13653],
Cell[CellGroupData[{
Cell[13674, 425, 72, 1, 70, "RelatedTutorialsSection",
 CellID->361824569],
Cell[13749, 428, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[13953, 435, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

