(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    124971,       3091]
NotebookOptionsPosition[    108615,       2507]
NotebookOutlinePosition[    118188,       2820]
CellTagsIndexPosition[    117939,       2808]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Differential Equation Solving with DSolve" :> 
          Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DSolve" :> Documentation`HelpLookup["paclet:ref/DSolve"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"DSolve\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Introduction to Differential Equation Solving with DSolve", "Title",
 CellTags->{"c:2", "b:0.0"},
 CellID->9961],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 StyleBox[" ", "TR"],
 "finds ",
 StyleBox["symbolic solutions",
  FontSlant->"Italic"],
 " to differential equations. (The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ", on the other hand, is a general numerical differential equation \
solver.)",
 " ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " can handle the following types of equations:"
}], "Text",
 CellTags->"b:0.0",
 CellID->3959],

Cell[TextData[{
 StyleBox["Ordinary Differential Equations ",
  FontSlant->"Italic"],
 StyleBox["(ODEs)",
  FontVariations->{"CompatibilityType"->0}],
 ", in which there is a single independent variable ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " and one or more dependent variables ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "i"], "(", "t", ")"}], TraditionalForm]], 
  "InlineMath"],
 ". ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " is equipped with a wide variety of techniques for solving single ODEs as \
well as systems of ODEs."
}], "BulletedText",
 CellTags->"b:0.0",
 CellID->6493],

Cell[TextData[{
 StyleBox["Partial Differential Equations",
  FontSlant->"Italic"],
 " (PDEs), in which there are two or more independent variables and one \
dependent variable. Finding exact symbolic solutions of PDEs is a difficult \
problem, but ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " can solve most first-order PDEs and a limited number of the second-order \
PDEs found in standard reference books."
}], "BulletedText",
 CellTags->"b:0.0",
 CellID->1515],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Differential-Algebraic Equations",
  FontSlant->"Italic"],
 " (DAEs), in which some members of the system are differential equations and \
the others are purely algebraic, having no derivatives in them. As with PDEs, \
it is difficult to find exact solutions to DAEs, but ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " can solve many examples of such systems that occur in applications."
}], "BulletedText",
 CellTags->"b:0.0",
 CellID->25269],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DSolve"], "[", 
     RowBox[{
      StyleBox["eqn", "TI"], ",", 
      RowBox[{
       StyleBox["y", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[TextData[{
     "solve a differential equation for ",
     Cell[BoxData[
      FormBox[
       RowBox[{"y", "[", "x", "]"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DSolve"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["eqn", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["eqn", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["1", "TR"]], "[", 
         StyleBox["x", "TI"], "]"}], ",", 
        RowBox[{
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["2", "TR"]], "[", 
         StyleBox["x", "TI"], "]"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["x", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "solve a system of differential equations for ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["y", "i"], "[", "x", "]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"b:0.0",
 CellID->24937],

Cell["\<\
Finding symbolic solutions to ordinary differential equations.\
\>", "Caption",
 CellTags->"b:0.0",
 CellID->28869],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " returns results as lists of rules. This makes it possible to return \
multiple solutions to an equation. For a system of equations, possibly \
multiple solution sets are grouped together. You can use the rules to \
substitute the solutions into other calculations."
}], "Text",
 CellTags->"b:0.0",
 CellID->58],

Cell[TextData[{
 "This finds the ",
 StyleBox["general solution",
  FontSlant->"Italic"],
 " for the given ODE. A rule for the function that satisfies the equation is \
returned. "
}], "MathCaption",
 CellTags->"b:0.0",
 CellID->14700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
     RowBox[{"y", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", " ", "x"}], "]"}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[42]:=",
 CellID->13971],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "x"], " ", 
     RowBox[{"C", "[", "1", "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{120, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[42]=",
 CellID->3205678]
}, Open  ]],

Cell[TextData[{
 "You can pick out a specific solution by using ",
 Cell[BoxData["/."], "InlineFormula"],
 " (",
 Cell[BoxData[
  ButtonBox["ReplaceAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"]], "InlineFormula"],
 ")."
}], "MathCaption",
 CellTags->"b:0.0",
 CellID->15117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", "x", "]"}], "/.", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"y", "[", "x", "]"}]}], "}"}], ",", " ", 
    RowBox[{"y", "[", "x", "]"}], ",", " ", "x"}], "]"}]}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[44]:=",
 CellID->16215],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], " ", 
   RowBox[{"C", "[", "1", "]"}]}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[44]=",
 CellID->492436931]
}, Open  ]],

Cell[TextData[{
 "A general solution contains arbitrary parameters ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 " which can be varied to produce particular solutions for the equation. When \
an adequate number of ",
 StyleBox["initial conditions",
  FontSlant->"Italic"],
 " are specified, ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " returns particular solutions to the given equations."
}], "Text",
 CellTags->"b:0.0",
 CellID->7815],

Cell[TextData[{
 "Here, the initial condition ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"y", "[", "0", "]"}], "==", "1"}]], "InlineFormula"],
 " is specified, and ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " returns a particular solution for the problem."
}], "MathCaption",
 CellTags->"b:0.0",
 CellID->18330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
       RowBox[{"y", "[", "x", "]"}]}], ",", " ", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", " ", 
    RowBox[{"y", "[", "x", "]"}], ",", " ", "x"}], "]"}]}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[45]:=",
 CellID->3039],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    SuperscriptBox["\[ExponentialE]", "x"]}], "}"}], "}"}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[45]=",
 CellID->592829817]
}, Open  ]],

Cell[TextData[{
 "This plots the solution. ",
 Cell[BoxData[
  ButtonBox["ReplaceAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"]], "InlineFormula"],
 " (",
 Cell[BoxData["/."], "InlineFormula"],
 ") is used in the ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " command to substitute the solution for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "x", "]"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:0.0",
 CellID->29288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "/.", "sol"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[46]:=",
 CellID->28082],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx38803kcwPGh3cSkooX6orOzUtF5aELX+6NRTnFu111uJSQXoqkrqai7
Un4loZKiOrGahX6pcavv14+lHzcuP/tBIr+JaDY/xve+98fr8Xo8l+wU8oO1
aTSaN9X/j+3xGiVJBvEmbP/4nVgxdB9ljb3TMAj/4FtPHsSLwXtum/rRBINY
37LogCxNDJZOkdPCLwzCuaz/XnO+GCqS0nU/dDMIad5FyXc1YtC1bTYnFAxi
35zs7mcWBXD+QMCmP64wCPeY0NQeeQFItH7PozkyiFva8sXXzW8DPXijvanf
V0SrnX5U9YZiMHotD89NoxPOqzf5JrvfBX7l5aBlL2YRMocQu/ez78NjtTn3
2YgOwWMWSsmlJdDi4lXSzNEh7Bv/iRMIHgHnuc1ccrM2kW65sDJdUwo3anZw
2FFahKlWTmFYiwzqP64dKC2kEa5ow22yHocdcecX1N4i8TzW9DfG98rhWIBO
kb7RDF7kpOitS6wE2koLnHdKg/ftS/EaiZfD2+SseEnjJI5v61MJB6thsV6I
WLl+Ak/Ont5pG/wCHppdOBFxVo3/7FlVb+KngHuLhA3t7WO4kHkn28TrX2Ct
zTnuyFfiRSFb39SOv4K6oWUdsuujuL6aeBA6WQ8qQu+qFXMERx8W2u42aIIO
z/NfH5AM4bY+SUdWJr+GHGX4ZKb3AN6Br4kM4r0DTuunuGPLe3Gp+ku++/z3
ENi//FhVVSd+Z9OFbS+lHyCMO99GkdmOPxJttgw91AGRT/POZo214F1TntsP
CjohPPSaaKtDE/6gn8+OvtoNBsaNG7mKWrzTw5TeONYL2r3+085WFXipSdlP
xfIBsNF4tEd05uL6RW9DXJqHgCgL1e3iFEMts+ykhjYCksR013Pb5ODRlCGV
94xCSYODyxydV2Au20Nb1aYEvRuD+39b0wwTHy25R0kVkBwbBalshV/ppzUz
ZyagIFO/fbZFBxha97Jn7DQgUlWFO8R3get4W1KugIQ6VpN7dkkvBPbR4mp8
tJDTLykrDRoGQKsqwC2bpYNGIuNF5txhsL0kyj/tSEcRovCHXLsRSFVLGp+H
MZCetuNO265R2K7J+/YHQz3Ei9hywSZDCdaeU2PSESZilWJCd7YKrHSGF+kP
GqJz+xPSVjWrobhsbQyBz0O5zGsC54gJqL25Ue2aZYT4D3UlHlOTEORP5/Oz
FqAChZEbR6KBm+Faw0tpJuiy/MVJ9roZiDbiHg4+aobsl1sxR0dJ8A7LNf4x
CkPlBqd41l9I4D4rd7lL2edz9xEBZZbSbNe8QxjaW1LQV0G5Qn5E+oqyBOyr
M5Qk1BCfhfzDGGJvcT2xWkXCnIulpltiMMSK9R+PniBBVfHW1/cEhvL9y+0K
Ka/+y+WmlLLDeqvd7ZQTFU0qk5MY4jN6Gr+fJCHGUpb1hnJq2t77ZlMkEBa8
IcEpDOmKYvfKNCQk0TfU+SVgKDOhLf8zZUzk5fCEsvUe11b2NAn9DamZ5okY
cltF35xCmfupMrCN8p9lZ5btmCFhOHpgVmAyhubmDAWkU86Yqo4sp3z9uM+l
p5QTVrS1LjmDoSduxgw7koTd4sd/d1D24kStC6LsOx23gpeCoZbZrw9mUs43
jL96g/KeQafCl5R9OivnzTqLocmaK50kZb/jLqd3Uf4PhaR59A==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{-3, 2}, {0., 7.3890553449453735`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[46]=",
 CellID->173906007]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DSolve"], "[", 
     RowBox[{
      StyleBox["eqn", "TI"], ",", 
      StyleBox["y", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[TextData[{
     "solve a differential equation for ",
     Cell[BoxData[
      FormBox["y", TraditionalForm]], "InlineMath"],
     " as a pure function"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DSolve"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["eqn", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["eqn", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["x", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "solve a system of differential equations for the pure functions ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["y", "i"], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"b:0.0",
 CellID->16085],

Cell["\<\
Finding symbolic solutions to ordinary differential equations as pure \
functions.\
\>", "Caption",
 CellTags->"b:0.0",
 CellID->20710],

Cell[TextData[{
 "When the second argument to ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " is specified as ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " instead of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "x", "]"}], TraditionalForm]], "InlineMath"],
 ", the solution is returned as a pure function. This form is useful for \
verifying the solution of the ODE and for using the solution in further work. \
More details are given in \"",
 ButtonBox["Setting Up the Problem\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveSettingUpTheProblem"],
 "."
}], "Text",
 CellTags->"b:0.0",
 CellID->24484],

Cell["\<\
The solution to this differential equation is given as a pure function.\
\>", "MathCaption",
 CellTags->"b:0.0",
 CellID->24774],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "^", "2"}]}], ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{"sol", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", " ", "y", ",", " ", "x"}], "]"}]}]}], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[47]:=",
 CellID->8380],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      FractionBox["1", 
       RowBox[{"1", "-", "x"}]]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{188, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[48]=",
 CellID->19606113]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
 CellTags->"b:0.0",
 CellID->25951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqn", "/.", "sol"}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[49]:=",
 CellID->6541],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"True", ",", "True"}], "}"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[49]=",
 CellID->117711839]
}, Open  ]],

Cell[TextData[{
 "This solves a system of ODEs. Each solution is labeled according",
 " ",
 "to the name of the function (here, ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 "), making it easier to pick out individual functions."
}], "MathCaption",
 CellTags->"b:0.0",
 CellID->1679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqns", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"t", "^", "2"}], "+", "1"}], ")"}], "*", 
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "t"}], "*", 
        RowBox[{"x", "[", "t", "]"}]}], "+", 
       RowBox[{"y", "[", "t", "]"}], "-", 
       RowBox[{"Sign", "[", "t", "]"}]}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"t", "^", "2"}], "+", "1"}], ")"}], "*", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "t", "]"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"x", "[", "t", "]"}]}], "-", 
       RowBox[{"t", "*", 
        RowBox[{"y", "[", "t", "]"}]}], "+", 
       RowBox[{"t", "*", 
        RowBox[{"UnitStep", "[", "t", "]"}]}]}]}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}]}], ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "2"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqns", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "t"}], "]"}]}]}], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[63]:=",
 CellID->17110],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{521, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[64]=",
 CellID->362633553]
}, Open  ]],

Cell["\<\
This substitutes a random value for the independent variable and shows that \
the solutions are correct at that point.\
\>", "MathCaption",
 CellTags->"b:0.0",
 CellID->23073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eqns", "/.", "sol"}], "/.", 
  RowBox[{"{", 
   RowBox[{"t", "\[Rule]", " ", 
    RowBox[{"RandomReal", "[", "]"}]}], "}"}]}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[65]:=",
 CellID->788],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}], 
  "}"}]], "Output",
 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[65]=",
 CellID->11944266]
}, Open  ]],

Cell["This plots the solutions.", "MathCaption",
 CellTags->"b:0.0",
 CellID->18132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], "/.", "sol"}], ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], "/.", "sol"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[66]:=",
 CellID->29956],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[66]=",
 CellID->274207920]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DSolve"], "[", 
     RowBox[{
      StyleBox["eqn", "TI"], ",", 
      RowBox[{
       StyleBox["u", "TI"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "}"}]}], "]"}], Cell[TextData[{
     "solve a partial differential equation for ",
     Cell[BoxData[
      FormBox[
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y"}], "]"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"b:0.0",
 CellID->26113],

Cell["\<\
Finding symbolic solutions to partial differential equations.\
\>", "Caption",
 CellTags->{"S3.9.7", "ndsg:0", "b:0.0"},
 CellID->10008],

Cell[TextData[{
 "While general solutions to ordinary differential equations involve \
arbitrary ",
 StyleBox["constants",
  FontSlant->"Italic"],
 ", general solutions to partial differential equations involve arbitrary ",
 StyleBox["functions",
  FontSlant->"Italic"],
 ". ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " labels these arbitrary functions as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.0",
 CellID->12941],

Cell[TextData[{
 "Here is the general solution to a linear first-order PDE. In the solution, \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 " labels an arbitrary function of ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{
     RowBox[{"-", "x"}], "+", "y"}], 
    RowBox[{"x", " ", "y"}]], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:0.0",
 CellID->15790],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"y", "^", "2"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "y"}], ")"}], "*", 
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"eqn", "\[Equal]", "0"}], ",", " ", "u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[54]:=",
 CellID->1723],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       RowBox[{"-", "x"}], " ", "y", " ", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "[", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "x"}], "+", "y"}], 
         RowBox[{"x", " ", "y"}]], "]"}]}]}], "]"}]}], "}"}], "}"}]], "Output",\

 ImageSize->{284, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[55]=",
 CellID->6996066]
}, Open  ]],

Cell[TextData[{
 "This obtains a particular solution to the PDE for a specific choice of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:0.0",
 CellID->28],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fn", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], "/.", 
    RowBox[{"sol", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", "t_", "]"}], "\[Rule]", " ", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"t", "^", "2"}], "]"}], " ", "+", 
      RowBox[{"(", 
       RowBox[{"t", "/", "10"}], ")"}]}]}], "}"}]}]}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[56]:=",
 CellID->25184],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "x"}], " ", "y", " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"-", "x"}], "+", "y"}], 
     RowBox[{"10", " ", "x", " ", "y"}]], "+", 
    RowBox[{"Sin", "[", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "x"}], "+", "y"}], ")"}], "2"], 
      RowBox[{
       SuperscriptBox["x", "2"], " ", 
       SuperscriptBox["y", "2"]}]], "]"}]}], ")"}]}]], "Output",
 ImageSize->{190, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[56]=",
 CellID->470875405]
}, Open  ]],

Cell["Here is a plot of the surface for this solution.", "MathCaption",
 CellTags->"b:0.0",
 CellID->7200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{"fn", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[58]:=",
 CellID->5071],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 251},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[58]=",
 CellID->251149555]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " can also solve differential-algebraic equations. The syntax is the same as \
for a system of ordinary differential equations."
}], "Text",
 CellTags->"b:0.0",
 CellID->21974],

Cell["This solves a DAE.", "MathCaption",
 CellTags->"b:0.0",
 CellID->1071],

Cell[CellGroupData[{

Cell[BoxData[{
 StyleBox[
  RowBox[{
   RowBox[{
    RowBox[{"eqns", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"f", "''"}], "[", "x", "]"}], " ", "==", " ", 
        RowBox[{"g", "[", "x", "]"}]}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "[", "x", "]"}], " ", "+", " ", 
         RowBox[{"g", "[", "x", "]"}]}], " ", "==", " ", 
        RowBox[{"3", " ", 
         RowBox[{"Sin", "[", "x", "]"}]}]}], ",", " ", 
       RowBox[{
        RowBox[{"f", "[", "Pi", "]"}], " ", "==", " ", "1"}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "'"}], "[", "Pi", "]"}], " ", "==", " ", "0"}]}], 
      "}"}]}], ";"}], " "}],
  FormatType->StandardForm], "\n", 
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqns", ",", " ", 
    RowBox[{"{", 
     RowBox[{"f", ",", " ", "g"}], "}"}], ",", " ", "x"}], "]"}]}]}], "Input",\

 CellTags->"b:0.0",
 CellLabel->"In[59]:=",
 CellID->11333],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           RowBox[{"Cos", "[", "x", "]"}]}], "+", 
          RowBox[{"3", " ", "\[Pi]", " ", 
           RowBox[{"Cos", "[", "x", "]"}]}], "-", 
          RowBox[{"3", " ", "x", " ", 
           RowBox[{"Cos", "[", "x", "]"}]}], "+", 
          RowBox[{"3", " ", 
           RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}]}], "]"}]}], ",", 
    RowBox[{"g", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"Cos", "[", "x", "]"}]}], "-", 
          RowBox[{"3", " ", "\[Pi]", " ", 
           RowBox[{"Cos", "[", "x", "]"}]}], "+", 
          RowBox[{"3", " ", "x", " ", 
           RowBox[{"Cos", "[", "x", "]"}]}], "+", 
          RowBox[{"3", " ", 
           RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{453, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[60]=",
 CellID->386746683]
}, Open  ]],

Cell["This verifies the solutions.", "MathCaption",
 CellTags->"b:0.0",
 CellID->26153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"eqns", "/.", "sol"}], "]"}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[61]:=",
 CellID->14295],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}], 
  "}"}]], "Output",
 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[61]=",
 CellID->30167876]
}, Open  ]],

Cell[TextData[{
 "A plot of the solutions shows that their sum satisfies the algebraic \
relation ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["x", "TI"], "]"}], "+", 
    RowBox[{
     StyleBox["g", "TI"], "[", 
     StyleBox["x", "TI"], "]"}]}], "\[Equal]", 
   RowBox[{"3", " ", 
    RowBox[{
     ButtonBox["Sin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sin"], "[", 
     StyleBox["x", "TI"], "]"}]}]}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:0.0",
 CellID->20825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], "/.", "sol"}], ",", " ", 
     RowBox[{
      RowBox[{"g", "[", "x", "]"}], "/.", "sol"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], "+", 
       RowBox[{"g", "[", "x", "]"}]}], "/.", "sol"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.0",
 CellLabel->"In[62]:=",
 CellID->9676],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.0",
 CellLabel->"Out[62]=",
 CellID->39832753]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Goals of These Tutorials", "Section",
 CellTags->{"c:4", "b:0.2"},
 CellID->28650],

Cell[TextData[{
 "The design of ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " is modular: the algorithms for different classes of problems work \
independently of one another. Once a problem has been classified (as \
described in \"",
 ButtonBox["Classification of Differential Equations\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveClassificationOfDifferentialEquations"],
 "), the available methods for that class are tried in a specific sequence \
until a solution is obtained. The code has a hierarchical structure whereby \
the solution of complex problems is reduced to the solution of relatively \
simpler problems, for which a greater variety of methods is available. For \
example, higher-order ODEs are typically solved by reducing their order to 1 \
or 2. "
}], "Text",
 CellTags->"b:0.2",
 CellID->2598],

Cell["\<\
The process described is done internally and does not require any \
intervention from the user. For this reason, these tutorials have the \
following basic goals.\
\>", "Text",
 CellTags->"b:0.2",
 CellID->3309],

Cell[TextData[{
 "To provide enough information and tips so that users can pose problems to \
",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " in the most appropriate form and apply the solutions in their work. This \
is accomplished through a substantial number of examples. A summary of this \
information is given in the tutorials on \"",
 ButtonBox["Working with DSolve\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/WorkingWithDSolveIntroduction"],
 "."
}], "BulletedText",
 CellTags->"b:0.2",
 CellID->4693],

Cell[CellGroupData[{

Cell[TextData[{
 "To give a catalog of the kinds of problems that can be handled by ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " as well as the nature of the solutions for each case. This is provided in \
the tutorials on ODEs, PDEs, DAEs and boundary value problems (BVPs)."
}], "BulletedText",
 CellTags->"b:0.2",
 CellID->4686],

Cell[TextData[{
 "The author hopes that these tutorials will be useful in acquiring a basic \
knowledge of ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " and also serve as a ready reference for information on more advanced \
topics."
}], "Text",
 CellTags->"b:0.2",
 CellID->30080]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Acknowledgments", "Section",
 CellTags->{"c:59", "b:0.3"},
 CellID->10116],

Cell["\<\
I would like to thank Tom Wickham-Jones for suggesting this documentation \
project and for providing guidance on how to make it more useful.\
\>", "Text",
 CellTags->"b:0.3",
 CellID->12249],

Cell[TextData[{
 "Thanks to Unal Goktas and Roger Germundsson, who have been involved in the \
design and algorithm implementation aspects of ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " over a long period of time. Their suggestions and insights have always \
been fruitful for me."
}], "Text",
 CellTags->"b:0.3",
 CellID->26667],

Cell["\<\
Thanks to Andy Hunt for giving very useful advice that helped in organizing \
the material and finishing the project in a reasonable amount of time.\
\>", "Text",
 CellTags->"b:0.3",
 CellID->1528],

Cell["\<\
Lisa Byrge edited the entire document and made a vast number of suggestions \
for stylistic and more substantial changes. I would like to thank her for her \
patience and hard work. Lisa and George Beck put in a great deal of effort \
into bringing the original documentation to its current, user-friendly \
format.\
\>", "Text",
 CellTags->"b:0.3",
 CellID->26679],

Cell["\<\
Thanks to Robert Knapp for a thorough review of the documentation and for \
many useful suggestions on both the style and mathematical content of the \
tutorials.\
\>", "Text",
 CellID->64984333],

Cell["Devendra Kapadia", "Text",
 CellTags->"b:0.3",
 CellID->7864],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->427844460],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction to Differential Equation Solving with DSolve - \
Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveClassificationOfDifferentialEquations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 25.0942946}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The Mathematica function DSolve finds symbolic solutions to differential \
equations. (The Mathematica function NDSolve, on the other hand, is a general \
numerical differential equation solver.) DSolve can handle the following \
types of equations: Finding symbolic solutions to ordinary differential \
equations. DSolve returns results as lists of rules. This makes it possible \
to return multiple solutions to an equation. For a system of equations, \
possibly multiple solution sets are grouped together. You can use the rules \
to substitute the solutions into other calculations.", "synonyms" -> {}, 
    "title" -> "Introduction to Differential Equation Solving with DSolve", 
    "type" -> "Tutorial", "uri" -> "tutorial/DSolveIntroduction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:2"->{
  Cell[1820, 58, 118, 2, 70, "Title",
   CellTags->{"c:2", "b:0.0"},
   CellID->9961]},
 "b:0.0"->{
  Cell[1820, 58, 118, 2, 70, "Title",
   CellTags->{"c:2", "b:0.0"},
   CellID->9961],
  Cell[1941, 62, 809, 31, 70, "Text",
   CellTags->"b:0.0",
   CellID->3959],
  Cell[2753, 95, 712, 23, 70, "BulletedText",
   CellTags->"b:0.0",
   CellID->6493],
  Cell[3468, 120, 540, 14, 70, "BulletedText",
   CellTags->"b:0.0",
   CellID->1515],
  Cell[4033, 138, 544, 13, 70, "BulletedText",
   CellTags->"b:0.0",
   CellID->25269],
  Cell[4580, 153, 1650, 56, 70, "DefinitionBox",
   CellTags->"b:0.0",
   CellID->24937],
  Cell[6233, 211, 125, 4, 70, "Caption",
   CellTags->"b:0.0",
   CellID->28869],
  Cell[6361, 217, 444, 11, 70, "Text",
   CellTags->"b:0.0",
   CellID->58],
  Cell[6808, 230, 235, 8, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->14700],
  Cell[7068, 242, 331, 11, 70, "Input",
   CellTags->"b:0.0",
   CellID->13971],
  Cell[7402, 255, 380, 13, 36, "Output",
   CellTags->"b:0.0",
   CellID->3205678],
  Cell[7797, 271, 296, 11, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->15117],
  Cell[8118, 286, 390, 13, 70, "Input",
   CellTags->"b:0.0",
   CellID->16215],
  Cell[8511, 301, 292, 10, 36, "Output",
   CellTags->"b:0.0",
   CellID->492436931],
  Cell[8818, 314, 626, 20, 70, "Text",
   CellTags->"b:0.0",
   CellID->7815],
  Cell[9447, 336, 384, 13, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->18330],
  Cell[9856, 353, 464, 15, 70, "Input",
   CellTags->"b:0.0",
   CellID->3039],
  Cell[10323, 370, 324, 11, 36, "Output",
   CellTags->"b:0.0",
   CellID->592829817],
  Cell[10662, 384, 545, 20, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->29288],
  Cell[11232, 408, 277, 10, 70, "Input",
   CellTags->"b:0.0",
   CellID->28082],
  Cell[11512, 420, 2251, 47, 172, "Output",
   CellTags->"b:0.0",
   CellID->173906007],
  Cell[13778, 470, 1440, 48, 70, "DefinitionBox",
   CellTags->"b:0.0",
   CellID->16085],
  Cell[15221, 520, 145, 5, 70, "Caption",
   CellTags->"b:0.0",
   CellID->20710],
  Cell[15369, 527, 718, 22, 70, "Text",
   CellTags->"b:0.0",
   CellID->24484],
  Cell[16090, 551, 138, 4, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->24774],
  Cell[16253, 559, 529, 18, 70, "Input",
   CellTags->"b:0.0",
   CellID->8380],
  Cell[16785, 579, 397, 14, 51, "Output",
   CellTags->"b:0.0",
   CellID->19606113],
  Cell[17197, 596, 86, 2, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->25951],
  Cell[17308, 602, 113, 4, 70, "Input",
   CellTags->"b:0.0",
   CellID->6541],
  Cell[17424, 608, 255, 9, 36, "Output",
   CellTags->"b:0.0",
   CellID->117711839],
  Cell[17694, 620, 379, 12, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->1679],
  Cell[18098, 636, 1385, 46, 65, "Input",
   CellTags->"b:0.0",
   CellID->17110],
  Cell[19486, 684, 3101, 56, 125, "Output",
   Evaluatable->False,
   CellTags->"b:0.0",
   CellID->362633553],
  Cell[22602, 743, 185, 5, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->23073],
  Cell[22812, 752, 229, 8, 70, "Input",
   CellTags->"b:0.0",
   CellID->788],
  Cell[23044, 762, 283, 10, 36, "Output",
   CellTags->"b:0.0",
   CellID->11944266],
  Cell[23342, 775, 84, 2, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->18132],
  Cell[23451, 781, 403, 14, 28, "Input",
   CellTags->"b:0.0",
   CellID->29956],
  Cell[23857, 797, 3739, 66, 159, "Output",
   Evaluatable->False,
   CellTags->"b:0.0",
   CellID->274207920],
  Cell[27611, 866, 729, 25, 70, "DefinitionBox",
   CellTags->"b:0.0",
   CellID->26113],
  Cell[28343, 893, 146, 4, 70, "Caption",
   CellTags->{"S3.9.7", "ndsg:0", "b:0.0"},
   CellID->10008],
  Cell[28492, 899, 643, 23, 70, "Text",
   CellTags->"b:0.0",
   CellID->12941],
  Cell[29138, 924, 488, 18, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->15790],
  Cell[29651, 946, 839, 29, 70, "Input",
   CellTags->"b:0.0",
   CellID->1723],
  Cell[30493, 977, 613, 22, 51, "Output",
   CellTags->"b:0.0",
   CellID->6996066],
  Cell[31121, 1002, 284, 10, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->28],
  Cell[31430, 1016, 546, 19, 70, "Input",
   CellTags->"b:0.0",
   CellID->25184],
  Cell[31979, 1037, 636, 23, 57, "Output",
   CellTags->"b:0.0",
   CellID->470875405],
  Cell[32630, 1063, 106, 2, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->7200],
  Cell[32761, 1069, 322, 11, 28, "Input",
   CellTags->"b:0.0",
   CellID->5071],
  Cell[33086, 1082, 59794, 985, 272, "Output",
   Evaluatable->False,
   CellTags->"b:0.0",
   CellID->251149555],
  Cell[92895, 2070, 308, 9, 70, "Text",
   CellTags->"b:0.0",
   CellID->21974],
  Cell[93206, 2081, 76, 2, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->1071],
  Cell[93307, 2087, 1002, 32, 70, "Input",
   CellTags->"b:0.0",
   CellID->11333],
  Cell[94312, 2121, 1403, 43, 81, "Output",
   CellTags->"b:0.0",
   CellID->386746683],
  Cell[95730, 2167, 87, 2, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->26153],
  Cell[95842, 2173, 150, 5, 70, "Input",
   CellTags->"b:0.0",
   CellID->14295],
  Cell[95995, 2180, 283, 10, 36, "Output",
   CellTags->"b:0.0",
   CellID->30167876],
  Cell[96293, 2193, 556, 21, 70, "MathCaption",
   CellTags->"b:0.0",
   CellID->20825],
  Cell[96874, 2218, 537, 18, 28, "Input",
   CellTags->"b:0.0",
   CellID->9676],
  Cell[97414, 2238, 6593, 113, 161, "Output",
   Evaluatable->False,
   CellTags->"b:0.0",
   CellID->39832753]},
 "S3.9.7"->{
  Cell[28343, 893, 146, 4, 70, "Caption",
   CellTags->{"S3.9.7", "ndsg:0", "b:0.0"},
   CellID->10008]},
 "ndsg:0"->{
  Cell[28343, 893, 146, 4, 70, "Caption",
   CellTags->{"S3.9.7", "ndsg:0", "b:0.0"},
   CellID->10008]},
 "c:4"->{
  Cell[104056, 2357, 88, 2, 70, "Section",
   CellTags->{"c:4", "b:0.2"},
   CellID->28650]},
 "b:0.2"->{
  Cell[104056, 2357, 88, 2, 70, "Section",
   CellTags->{"c:4", "b:0.2"},
   CellID->28650],
  Cell[104147, 2361, 907, 20, 70, "Text",
   CellTags->"b:0.2",
   CellID->2598],
  Cell[105057, 2383, 221, 6, 70, "Text",
   CellTags->"b:0.2",
   CellID->3309],
  Cell[105281, 2391, 594, 16, 70, "BulletedText",
   CellTags->"b:0.2",
   CellID->4693],
  Cell[105900, 2411, 406, 10, 70, "BulletedText",
   CellTags->"b:0.2",
   CellID->4686],
  Cell[106309, 2423, 355, 11, 70, "Text",
   CellTags->"b:0.2",
   CellID->30080]},
 "c:59"->{
  Cell[106713, 2440, 80, 2, 70, "Section",
   CellTags->{"c:59", "b:0.3"},
   CellID->10116]},
 "b:0.3"->{
  Cell[106713, 2440, 80, 2, 70, "Section",
   CellTags->{"c:59", "b:0.3"},
   CellID->10116],
  Cell[106796, 2444, 201, 5, 70, "Text",
   CellTags->"b:0.3",
   CellID->12249],
  Cell[107000, 2451, 406, 11, 70, "Text",
   CellTags->"b:0.3",
   CellID->26667],
  Cell[107409, 2464, 207, 5, 70, "Text",
   CellTags->"b:0.3",
   CellID->1528],
  Cell[107619, 2471, 375, 8, 70, "Text",
   CellTags->"b:0.3",
   CellID->26679],
  Cell[108205, 2488, 67, 2, 70, "Text",
   CellTags->"b:0.3",
   CellID->7864]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:2", 111022, 2559},
 {"b:0.0", 111122, 2563},
 {"S3.9.7", 116434, 2751},
 {"ndsg:0", 116553, 2755},
 {"c:4", 116669, 2759},
 {"b:0.2", 116775, 2763},
 {"c:59", 117306, 2782},
 {"b:0.3", 117413, 2786}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1195, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1820, 58, 118, 2, 70, "Title",
 CellTags->{"c:2", "b:0.0"},
 CellID->9961],
Cell[1941, 62, 809, 31, 70, "Text",
 CellTags->"b:0.0",
 CellID->3959],
Cell[2753, 95, 712, 23, 70, "BulletedText",
 CellTags->"b:0.0",
 CellID->6493],
Cell[3468, 120, 540, 14, 70, "BulletedText",
 CellTags->"b:0.0",
 CellID->1515],
Cell[CellGroupData[{
Cell[4033, 138, 544, 13, 70, "BulletedText",
 CellTags->"b:0.0",
 CellID->25269],
Cell[4580, 153, 1650, 56, 70, "DefinitionBox",
 CellTags->"b:0.0",
 CellID->24937],
Cell[6233, 211, 125, 4, 70, "Caption",
 CellTags->"b:0.0",
 CellID->28869],
Cell[6361, 217, 444, 11, 70, "Text",
 CellTags->"b:0.0",
 CellID->58],
Cell[6808, 230, 235, 8, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->14700],
Cell[CellGroupData[{
Cell[7068, 242, 331, 11, 70, "Input",
 CellTags->"b:0.0",
 CellID->13971],
Cell[7402, 255, 380, 13, 36, "Output",
 CellTags->"b:0.0",
 CellID->3205678]
}, Open  ]],
Cell[7797, 271, 296, 11, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->15117],
Cell[CellGroupData[{
Cell[8118, 286, 390, 13, 70, "Input",
 CellTags->"b:0.0",
 CellID->16215],
Cell[8511, 301, 292, 10, 36, "Output",
 CellTags->"b:0.0",
 CellID->492436931]
}, Open  ]],
Cell[8818, 314, 626, 20, 70, "Text",
 CellTags->"b:0.0",
 CellID->7815],
Cell[9447, 336, 384, 13, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->18330],
Cell[CellGroupData[{
Cell[9856, 353, 464, 15, 70, "Input",
 CellTags->"b:0.0",
 CellID->3039],
Cell[10323, 370, 324, 11, 36, "Output",
 CellTags->"b:0.0",
 CellID->592829817]
}, Open  ]],
Cell[10662, 384, 545, 20, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->29288],
Cell[CellGroupData[{
Cell[11232, 408, 277, 10, 70, "Input",
 CellTags->"b:0.0",
 CellID->28082],
Cell[11512, 420, 2251, 47, 172, "Output",
 CellTags->"b:0.0",
 CellID->173906007]
}, Open  ]],
Cell[13778, 470, 1440, 48, 70, "DefinitionBox",
 CellTags->"b:0.0",
 CellID->16085],
Cell[15221, 520, 145, 5, 70, "Caption",
 CellTags->"b:0.0",
 CellID->20710],
Cell[15369, 527, 718, 22, 70, "Text",
 CellTags->"b:0.0",
 CellID->24484],
Cell[16090, 551, 138, 4, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->24774],
Cell[CellGroupData[{
Cell[16253, 559, 529, 18, 70, "Input",
 CellTags->"b:0.0",
 CellID->8380],
Cell[16785, 579, 397, 14, 51, "Output",
 CellTags->"b:0.0",
 CellID->19606113]
}, Open  ]],
Cell[17197, 596, 86, 2, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->25951],
Cell[CellGroupData[{
Cell[17308, 602, 113, 4, 70, "Input",
 CellTags->"b:0.0",
 CellID->6541],
Cell[17424, 608, 255, 9, 36, "Output",
 CellTags->"b:0.0",
 CellID->117711839]
}, Open  ]],
Cell[17694, 620, 379, 12, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->1679],
Cell[CellGroupData[{
Cell[18098, 636, 1385, 46, 65, "Input",
 CellTags->"b:0.0",
 CellID->17110],
Cell[19486, 684, 3101, 56, 125, "Output",
 Evaluatable->False,
 CellTags->"b:0.0",
 CellID->362633553]
}, Open  ]],
Cell[22602, 743, 185, 5, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->23073],
Cell[CellGroupData[{
Cell[22812, 752, 229, 8, 70, "Input",
 CellTags->"b:0.0",
 CellID->788],
Cell[23044, 762, 283, 10, 36, "Output",
 CellTags->"b:0.0",
 CellID->11944266]
}, Open  ]],
Cell[23342, 775, 84, 2, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->18132],
Cell[CellGroupData[{
Cell[23451, 781, 403, 14, 28, "Input",
 CellTags->"b:0.0",
 CellID->29956],
Cell[23857, 797, 3739, 66, 159, "Output",
 Evaluatable->False,
 CellTags->"b:0.0",
 CellID->274207920]
}, Open  ]],
Cell[27611, 866, 729, 25, 70, "DefinitionBox",
 CellTags->"b:0.0",
 CellID->26113],
Cell[28343, 893, 146, 4, 70, "Caption",
 CellTags->{"S3.9.7", "ndsg:0", "b:0.0"},
 CellID->10008],
Cell[28492, 899, 643, 23, 70, "Text",
 CellTags->"b:0.0",
 CellID->12941],
Cell[29138, 924, 488, 18, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->15790],
Cell[CellGroupData[{
Cell[29651, 946, 839, 29, 70, "Input",
 CellTags->"b:0.0",
 CellID->1723],
Cell[30493, 977, 613, 22, 51, "Output",
 CellTags->"b:0.0",
 CellID->6996066]
}, Open  ]],
Cell[31121, 1002, 284, 10, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->28],
Cell[CellGroupData[{
Cell[31430, 1016, 546, 19, 70, "Input",
 CellTags->"b:0.0",
 CellID->25184],
Cell[31979, 1037, 636, 23, 57, "Output",
 CellTags->"b:0.0",
 CellID->470875405]
}, Open  ]],
Cell[32630, 1063, 106, 2, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->7200],
Cell[CellGroupData[{
Cell[32761, 1069, 322, 11, 28, "Input",
 CellTags->"b:0.0",
 CellID->5071],
Cell[33086, 1082, 59794, 985, 272, "Output",
 Evaluatable->False,
 CellTags->"b:0.0",
 CellID->251149555]
}, Open  ]],
Cell[92895, 2070, 308, 9, 70, "Text",
 CellTags->"b:0.0",
 CellID->21974],
Cell[93206, 2081, 76, 2, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->1071],
Cell[CellGroupData[{
Cell[93307, 2087, 1002, 32, 70, "Input",
 CellTags->"b:0.0",
 CellID->11333],
Cell[94312, 2121, 1403, 43, 81, "Output",
 CellTags->"b:0.0",
 CellID->386746683]
}, Open  ]],
Cell[95730, 2167, 87, 2, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->26153],
Cell[CellGroupData[{
Cell[95842, 2173, 150, 5, 70, "Input",
 CellTags->"b:0.0",
 CellID->14295],
Cell[95995, 2180, 283, 10, 36, "Output",
 CellTags->"b:0.0",
 CellID->30167876]
}, Open  ]],
Cell[96293, 2193, 556, 21, 70, "MathCaption",
 CellTags->"b:0.0",
 CellID->20825],
Cell[CellGroupData[{
Cell[96874, 2218, 537, 18, 28, "Input",
 CellTags->"b:0.0",
 CellID->9676],
Cell[97414, 2238, 6593, 113, 161, "Output",
 Evaluatable->False,
 CellTags->"b:0.0",
 CellID->39832753]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[104056, 2357, 88, 2, 70, "Section",
 CellTags->{"c:4", "b:0.2"},
 CellID->28650],
Cell[104147, 2361, 907, 20, 70, "Text",
 CellTags->"b:0.2",
 CellID->2598],
Cell[105057, 2383, 221, 6, 70, "Text",
 CellTags->"b:0.2",
 CellID->3309],
Cell[105281, 2391, 594, 16, 70, "BulletedText",
 CellTags->"b:0.2",
 CellID->4693],
Cell[CellGroupData[{
Cell[105900, 2411, 406, 10, 70, "BulletedText",
 CellTags->"b:0.2",
 CellID->4686],
Cell[106309, 2423, 355, 11, 70, "Text",
 CellTags->"b:0.2",
 CellID->30080]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[106713, 2440, 80, 2, 70, "Section",
 CellTags->{"c:59", "b:0.3"},
 CellID->10116],
Cell[106796, 2444, 201, 5, 70, "Text",
 CellTags->"b:0.3",
 CellID->12249],
Cell[107000, 2451, 406, 11, 70, "Text",
 CellTags->"b:0.3",
 CellID->26667],
Cell[107409, 2464, 207, 5, 70, "Text",
 CellTags->"b:0.3",
 CellID->1528],
Cell[107619, 2471, 375, 8, 70, "Text",
 CellTags->"b:0.3",
 CellID->26679],
Cell[107997, 2481, 205, 5, 70, "Text",
 CellID->64984333],
Cell[108205, 2488, 67, 2, 70, "Text",
 CellTags->"b:0.3",
 CellID->7864],
Cell[CellGroupData[{
Cell[108297, 2494, 72, 1, 70, "RelatedTutorialsSection",
 CellID->427844460],
Cell[108372, 2497, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[108588, 2505, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

