(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9669,        279]
NotebookOptionsPosition[      4940,        156]
NotebookOutlinePosition[      9070,        255]
CellTagsIndexPosition[      8981,        249]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Introduction to Initial and Boundary Value Problems", "Title",
 CellTags->{"c:46", "b:4.0"},
 CellID->29421],

Cell["\<\
DSolve can be used for finding the general solution to a differential \
equation or system of differential equations. The general solution gives \
information about the structure of the complete solution space for the \
problem. However, in practice, one is often interested only in particular \
solutions that satisfy some conditions related to the area of application. \
These conditions are usually of two types.\
\>", "Text",
 CellTags->"b:4.0",
 CellID->8405],

Cell[TextData[{
 "The solution ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
 " and/or its derivatives are required to have specific values at a single \
point, for example, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "(", "0", ")"}], "\[LongEqual]", "1"}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None], "(", "0", ")"}], "\[LongEqual]", "2"}], 
   TraditionalForm]], "InlineMath"],
 ". Such problems are traditionally called ",
 StyleBox["initial value problems",
  FontSlant->"Italic"],
 " (IVPs) because the system is assumed to start evolving from the fixed \
initial point (in this case, 0)."
}], "BulletedText",
 CellTags->"b:4.0",
 CellID->8826],

Cell[CellGroupData[{

Cell[TextData[{
 "The solution ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
 " is required to have specific values at a pair of points, for example, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "(", "0", ")"}], "\[LongEqual]", "3"}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "(", "1", ")"}], "\[LongEqual]", "5"}], TraditionalForm]], 
  "InlineMath"],
 ". These problems are known as ",
 StyleBox["boundary value problems ",
  FontSlant->"Italic"],
 "(BVPs) since the points 0 and 1 are regarded as boundary points (or edges) \
of the domain of interest in the application."
}], "BulletedText",
 CellTags->"b:4.0",
 CellID->6816],

Cell["\<\
The symbolic solution of both IVPs and BVPs requires knowledge of the general \
solution for the problem. The final step, in which the particular solution is \
obtained using the initial or boundary values, involves mostly algebraic \
operations, and is similar for IVPs and for BVPs.\
\>", "Text",
 CellTags->"b:4.0",
 CellID->7516],

Cell[TextData[{
 "IVPs and BVPs for ",
 StyleBox["linear ",
  FontSlant->"Italic"],
 "differential equations are solved rather easily since the final algebraic \
step involves the solution of linear equations. However, if the underlying \
equations are ",
 StyleBox["nonlinear",
  FontSlant->"Italic"],
 ", the solution could have several branches, or the arbitrary constants from \
the general solution could occur in different arguments of transcendental \
functions. As a result, it is not always possible to complete the final \
algebraic step for nonlinear problems. Finally, if the underlying equations \
have",
 " ",
 StyleBox["piecewise",
  FontSlant->"Italic"],
 " (that is, discontinuous) coefficients, an IVP naturally breaks up into \
simpler IVPs over the regions in which the coefficients are continuous. "
}], "Text",
 CellTags->"b:4.0",
 CellID->27726],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction to Initial and Boundary Value Problems - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveExamplesOfDAEs"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveLinearBVPs"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 26.0786948}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "DSolve can be used for finding the general solution to a differential \
equation or system of differential equations. The general solution gives \
information about the structure of the complete solution space for the \
problem. However, in practice, one is often interested only in particular \
solutions that satisfy some conditions related to the area of application. \
These conditions are usually of two types. The symbolic solution of both IVPs \
and BVPs requires knowledge of the general solution for the problem. The \
final step, in which the particular solution is obtained using the initial or \
boundary values, involves mostly algebraic operations, and is similar for \
IVPs and for BVPs. IVPs and BVPs for linear differential equations are solved \
rather easily since the final algebraic step involves the solution of linear \
equations. However, if the underlying equations are nonlinear, the solution \
could have several branches, or the arbitrary constants from the general \
solution could occur in different arguments of transcendental functions. As a \
result, it is not always possible to complete the final algebraic step for \
nonlinear problems. Finally, if the underlying equations have piecewise (that \
is, discontinuous) coefficients, an IVP naturally breaks up into simpler IVPs \
over the regions in which the coefficients are continuous. ", 
    "synonyms" -> {}, "title" -> 
    "Introduction to Initial and Boundary Value Problems", "type" -> 
    "Tutorial", "uri" -> "tutorial/DSolveIntroductionToBVPs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:46"->{
  Cell[1280, 43, 114, 2, 70, "Title",
   CellTags->{"c:46", "b:4.0"},
   CellID->29421]},
 "b:4.0"->{
  Cell[1280, 43, 114, 2, 70, "Title",
   CellTags->{"c:46", "b:4.0"},
   CellID->29421],
  Cell[1397, 47, 474, 9, 70, "Text",
   CellTags->"b:4.0",
   CellID->8405],
  Cell[1874, 58, 836, 27, 70, "BulletedText",
   CellTags->"b:4.0",
   CellID->8826],
  Cell[2735, 89, 754, 24, 70, "BulletedText",
   CellTags->"b:4.0",
   CellID->6816],
  Cell[3492, 115, 343, 7, 70, "Text",
   CellTags->"b:4.0",
   CellID->7516],
  Cell[3838, 124, 868, 21, 70, "Text",
   CellTags->"b:4.0",
   CellID->27726]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:46", 8359, 223},
 {"b:4.0", 8461, 227}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 114, 2, 70, "Title",
 CellTags->{"c:46", "b:4.0"},
 CellID->29421],
Cell[1397, 47, 474, 9, 70, "Text",
 CellTags->"b:4.0",
 CellID->8405],
Cell[1874, 58, 836, 27, 70, "BulletedText",
 CellTags->"b:4.0",
 CellID->8826],
Cell[CellGroupData[{
Cell[2735, 89, 754, 24, 70, "BulletedText",
 CellTags->"b:4.0",
 CellID->6816],
Cell[3492, 115, 343, 7, 70, "Text",
 CellTags->"b:4.0",
 CellID->7516],
Cell[3838, 124, 868, 21, 70, "Text",
 CellTags->"b:4.0",
 CellID->27726],
Cell[4709, 147, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[4913, 154, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

