(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21381,        669]
NotebookOptionsPosition[     16593,        528]
NotebookOutlinePosition[     20411,        632]
CellTagsIndexPosition[     20289,        625]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Overview of Ordinary Differential Equations (ODEs)", "Title",
 CellTags->{"c:6", "b:1.0"},
 CellID->23556],

Cell["\<\
There are four major areas in the study of ordinary differential equations \
that are of interest in pure and applied science.\
\>", "Text",
 CellTags->"b:1.0",
 CellID->12290],

Cell["\<\
Exact solutions, which are closed-form or implicit analytical expressions \
that satisfy the given problem.\
\>", "BulletedText",
 CellTags->"b:1.0",
 CellID->21293],

Cell["\<\
Numerical solutions, which are available for a wider class of problems, but \
are typically only valid over a limited range of the independent variables.\
\>", "BulletedText",
 CellTags->"b:1.0",
 CellID->29996],

Cell["\<\
Qualitative theory, which is concerned with the global properties of \
solutions and is particularly important in the modern approach to dynamical \
systems.\
\>", "BulletedText",
 CellTags->"b:1.0",
 CellID->29152],

Cell[CellGroupData[{

Cell["\<\
Existence and uniqueness theorems, which guarantee that there are solutions \
with certain desirable properties provided a set of conditions is fulfilled \
by the differential equation.\
\>", "BulletedText",
 CellTags->"b:1.0",
 CellID->1054],

Cell[TextData[{
 "Of these four areas, the study of exact solutions has the longest history, \
dating back to the period just after the discovery of calculus by Sir Isaac \
Newton and Gottfried Wilhelm von Leibniz. The following table is given as an \
introduction to the types of equations that can be solved by ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:1.0",
 CellID->25345],

Cell[BoxData[
 FormBox[
  FrameBox[GridBox[{
     {
      StyleBox[
       RowBox[{"Name", " ", "of", " ", "Equation"}],
       FontWeight->"Bold"], 
      StyleBox[
       RowBox[{"General", " ", "Form", " "}],
       FontWeight->"Bold"], 
      StyleBox[
       RowBox[{" ", 
        RowBox[{"Date", " ", "of", " ", "Discovery"}]}],
       FontWeight->"Bold"], 
      StyleBox["Mathematician",
       FontFamily->"Palatino",
       FontWeight->"Bold"]},
     {
      ButtonBox["Separable",
       BaseStyle->"Link",
       ButtonData->"paclet:tutorial/DSolveSeparableEquations",
       ButtonFrame->"None",
       ImageSize->Automatic], 
      FormBox[
       RowBox[{
        RowBox[{
         SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], "(", "x", ")"}], "\[LongEqual]", 
        RowBox[{
         RowBox[{"f", "(", "x", ")"}], " ", 
         RowBox[{"g", "(", "y", ")"}]}]}],
       TraditionalForm], "1691", 
      RowBox[{
       StyleBox["G",
        FontSlant->"Plain"], ".", " ", "Leibniz"}]},
     {
      ButtonBox["Homogeneous",
       BaseStyle->"Link",
       ButtonData->"paclet:tutorial/DSolveHomogeneousEquations",
       ButtonFrame->"None",
       ImageSize->Automatic], 
      FormBox[
       RowBox[{
        RowBox[{
         SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], "(", "x", ")"}], "\[LongEqual]", 
        RowBox[{"f", "(", 
         FractionBox["x", 
          RowBox[{"y", "(", "x", ")"}]], ")"}]}],
       TraditionalForm], "1691", 
      RowBox[{
       StyleBox["G",
        FontSlant->"Plain"], ".", " ", "Leibniz"}]},
     {
      ButtonBox[
       RowBox[{
        RowBox[{"Linear", " ", "first"}], "-", 
        RowBox[{"order", " ", "ODE"}]}],
       BaseStyle->"Link",
       ButtonData->"paclet:tutorial/DSolveLinearFirstOrderEquations",
       ButtonFrame->"None",
       ImageSize->Automatic], 
      FormBox[
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["y", "\[Prime]",
           MultilineFunction->None], "(", "x", ")"}], " ", "+", " ", 
         RowBox[{
          RowBox[{"P", "(", "x", ")"}], " ", 
          RowBox[{"y", "(", "x", ")"}]}]}], "\[LongEqual]", 
        RowBox[{"Q", "(", "x", ")"}]}],
       TraditionalForm], "1694", 
      RowBox[{
       StyleBox["G",
        FontSlant->"Plain"], ".", " ", "Leibniz"}]},
     {
      ButtonBox["Bernoulli",
       BaseStyle->"Link",
       ButtonData->"paclet:tutorial/DSolveBernoulliEquations",
       ButtonFrame->"None",
       ImageSize->Automatic], 
      RowBox[{
       FormBox[
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "(", "x", ")"}], "+", 
          RowBox[{
           RowBox[{"P", "(", "x", ")"}], 
           RowBox[{"y", "(", "x", ")"}]}]}], " ", "\[LongEqual]", 
         RowBox[{"Q", "(", "x", ")"}], "\[NoBreak]"}],
        TraditionalForm], 
       SuperscriptBox[
        RowBox[{"y", "(", "x", ")"}], "n"]}], "1695", 
      RowBox[{"James", " ", "Bernoulli"}]},
     {
      ButtonBox["Riccati",
       BaseStyle->"Link",
       ButtonData->"paclet:tutorial/DSolveRiccatiEquations",
       ButtonFrame->"None",
       ImageSize->Automatic], 
      FormBox[
       RowBox[{
        RowBox[{
         SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], " ", 
         RowBox[{"(", "x", ")"}]}], "\[LongEqual]", " ", 
        RowBox[{
         RowBox[{"f", "(", "x", ")"}], " ", "+", " ", 
         RowBox[{
          RowBox[{"g", "(", "x", ")"}], 
          RowBox[{"y", "(", "x", ")"}]}], " ", "+", " ", 
         RowBox[{
          RowBox[{"h", "(", "x", ")"}], " ", 
          SuperscriptBox[
           RowBox[{"y", "(", "x", ")"}], "2"]}]}]}],
       TraditionalForm], "1724", 
      RowBox[{"Count", " ", "Riccati"}]},
     {
      ButtonBox[
       RowBox[{
        RowBox[{"Exact", " ", "first"}], "-", 
        RowBox[{"order", " ", "ODE"}]}],
       BaseStyle->"Link",
       ButtonData->"paclet:tutorial/DSolveExactEquations",
       ButtonFrame->"None",
       ImageSize->Automatic], 
      FormBox[
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"M", " ", "dx"}], "+", " ", 
          RowBox[{"N", " ", "dy"}]}], "\[LongEqual]", 
         RowBox[{"0", " ", "with", " ", 
          FractionBox[
           RowBox[{"\[PartialD]", "M"}], 
           RowBox[{"\[PartialD]", "y"}],
           MultilineFunction->None]}]}], "=", 
        FractionBox[
         RowBox[{"\[PartialD]", "N"}], 
         RowBox[{"\[PartialD]", "x"}],
         MultilineFunction->None]}],
       TraditionalForm], "1734", 
      RowBox[{
       StyleBox["L",
        FontSlant->"Plain"], ".", " ", "Euler"}]},
     {
      ButtonBox["Clairaut",
       BaseStyle->"Link",
       ButtonData->"paclet:tutorial/DSolveClairautEquations",
       ButtonFrame->"None",
       ImageSize->Automatic], 
      RowBox[{
       FormBox[
        RowBox[{
         RowBox[{"y", "(", "x", ")"}], "\[LongEqual]", 
         RowBox[{"x", " ", 
          RowBox[{
           SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "(", "x", ")"}]}]}],
        TraditionalForm], " ", "+", " ", 
       RowBox[{"f", "(", 
        RowBox[{
         SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], "(", "x", ")"}], ")"}]}], "1734", Cell[
      "A-C. Clairaut"]},
     {
      ButtonBox[
       RowBox[{"Linear", " ", "with", " ", "constant", " ", "coefficients"}],
       BaseStyle->"Link",
       ButtonData->
        "paclet:tutorial/\
DSolveLinearSecondOrderEquationsWithConstantCoefficients",
       ButtonFrame->"None",
       ImageSize->Automatic], 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           FormBox[
            RowBox[{
             SuperscriptBox["y", 
              RowBox[{"(", "n", ")"}]], "(", "x"}],
            TraditionalForm], ")"}], "+", 
          RowBox[{
           SubscriptBox["a", 
            RowBox[{"n", "-", "1"}]], 
           FormBox[
            SuperscriptBox["y", 
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}]],
            TraditionalForm], 
           RowBox[{"(", "x", ")"}]}], "+"}], "..."}], "+", 
        RowBox[{
         SubscriptBox["a", "0"], 
         RowBox[{"y", "(", "x", ")"}]}]}], "\[LongEqual]", 
       RowBox[{
        RowBox[{"P", "(", "x", ")"}], " ", "with", " ", 
        FormBox[
         RowBox[{
          SubscriptBox["a", "i"], " ", "constant"}],
         TraditionalForm]}]}], "1743", 
      RowBox[{
       StyleBox["L",
        FontSlant->"Plain"], ".", " ", "Euler"}]},
     {
      ButtonBox["Hypergeometric",
       BaseStyle->"Link",
       ButtonData->
        "paclet:tutorial/DSolveLinearSecondOrderODEsWithRationalCoefficients",
       
       ButtonFrame->"None",
       ImageSize->Automatic], 
      FormBox[
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "(", 
           RowBox[{"1", "-", "x"}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "(", "x", ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", "b", "+", "1"}], ")"}], " ", "x"}]}], ")"}], 
          " ", 
          RowBox[{
           SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "(", "x", ")"}]}], "-", 
         RowBox[{"a", " ", "b", " ", 
          RowBox[{"y", "(", "x", ")"}]}]}], "\[LongEqual]", "0"}],
       TraditionalForm], "1769", 
      RowBox[{
       StyleBox["L",
        FontSlant->"Plain"], ".", " ", "Euler"}]},
     {
      ButtonBox["Legendre",
       BaseStyle->"Link",
       ButtonData->
        "paclet:tutorial/DSolveLinearSecondOrderSpecialFunctionODEs#24474"], 
      RowBox[{
       FormBox[
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             SuperscriptBox["x", "2"]}], ")"}], 
           RowBox[{
            SuperscriptBox["y", "\[Prime]\[Prime]",
             MultilineFunction->None], "(", "x", ")"}]}], "-", 
          RowBox[{"2", "x", " ", 
           RowBox[{
            SuperscriptBox["y", "\[Prime]",
             MultilineFunction->None], "(", "x", ")"}]}], "+", 
          RowBox[{
           RowBox[{"n", "(", 
            RowBox[{"n", "+", "1"}], ")"}], 
           RowBox[{"y", "(", "x", ")"}]}]}], " ", "="}],
        TraditionalForm], " ", "0"}], "1785", 
      RowBox[{
       StyleBox["M",
        FontSlant->"Plain"], ".", " ", "Legendre"}]},
     {
      ButtonBox["Bessel",
       BaseStyle->"Link",
       ButtonData->
        "paclet:tutorial/DSolveLinearSecondOrderSpecialFunctionODEs#24474"], 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], 
         RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]"], "(", "x", ")"}]}], "+", 
        RowBox[{"x", " ", 
         RowBox[{
          SuperscriptBox["y", "\[Prime]"], "(", "x", ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "2"], "-", 
           SuperscriptBox["n", "2"]}], ")"}], 
         RowBox[{"y", "(", "x", ")"}]}]}], "=", "0"}], "1824", 
      RowBox[{
       StyleBox["F",
        FontSlant->"Plain"], ".", " ", "Bessel"}]},
     {
      ButtonBox["Mathieu",
       BaseStyle->"Link",
       ButtonData->
        "paclet:tutorial/DSolveClassificationOfDifferentialEquations#5601"], 
      RowBox[{" ", 
       FormBox[
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["y", "\[Prime]\[Prime]"], "(", "x", ")"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", 
             RowBox[{"2", "q", 
              RowBox[{"cos", "(", 
               RowBox[{"2", "x"}], " ", ")"}]}]}], ")"}], 
           RowBox[{"y", "(", "x", ")"}]}]}], "=", "0"}],
        TraditionalForm]}], "1868", 
      RowBox[{
       StyleBox["E",
        FontSlant->"Plain"], 
       StyleBox[".",
        FontSlant->"Italic"], " ", "Mathieu"}]},
     {
      ButtonBox["Abel",
       BaseStyle->"Link",
       ButtonData->"paclet:tutorial/DSolveAbelEquations",
       ButtonFrame->"None",
       ImageSize->Automatic], 
      RowBox[{
       FormBox[
        RowBox[{
         RowBox[{
          SuperscriptBox["y", "\[Prime]",
           MultilineFunction->None], " ", 
          RowBox[{"(", "x", ")"}]}], "\[LongEqual]", " ", 
         RowBox[{
          RowBox[{"f", "(", "x", ")"}], " ", "+", " ", 
          RowBox[{
           RowBox[{"g", "(", "x", ")"}], 
           RowBox[{"y", "(", "x", ")"}]}], " ", "+", " ", 
          RowBox[{
           RowBox[{"h", "(", "x", ")"}], " ", 
           SuperscriptBox[
            RowBox[{"y", "(", "x", ")"}], "2"]}]}]}],
        TraditionalForm], "+", " ", 
       RowBox[{
        RowBox[{"k", "(", "x", ")"}], " ", 
        SuperscriptBox[
         RowBox[{"y", "(", "x", ")"}], "3"]}]}], "1834", 
      RowBox[{
       StyleBox["N",
        FontSlant->"Plain"], 
       StyleBox[".",
        FontSlant->"Plain"], 
       StyleBox[" ",
        FontSlant->"Plain"], 
       StyleBox["H",
        FontSlant->"Plain"], 
       StyleBox[".",
        FontSlant->"Plain"], 
       StyleBox[" ",
        FontSlant->"Plain"], "Abel"}]},
     {
      ButtonBox["Chini",
       BaseStyle->"Link",
       ButtonData->"paclet:tutorial/DSolveChiniEquations",
       ButtonFrame->"None",
       ImageSize->Automatic], 
      RowBox[{
       FormBox[
        RowBox[{
         RowBox[{
          SuperscriptBox["y", "\[Prime]",
           MultilineFunction->None], "(", "x", ")"}], "\[LongEqual]", " ", 
         RowBox[{"f", "(", "x", ")"}], " "}],
        TraditionalForm], "+", 
       RowBox[{"g", 
        RowBox[{"(", "x", ")"}], " ", 
        RowBox[{"y", "(", "x", ")"}]}], "+", 
       RowBox[{
        RowBox[{"h", "(", "x", ")"}], " ", 
        SuperscriptBox[
         RowBox[{"y", "(", "x", ")"}], "n"]}]}], "1924", 
      RowBox[{
       StyleBox["M",
        FontSlant->"Plain"], ".", " ", "Chini"}]}
    },
    GridBoxDividers->{
     "Columns" -> {False, {True}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
    GridBoxItemSize->{"Columns" -> {
        Scaled[0.2], 
        Scaled[0.43], 
        Scaled[0.14], {
         Scaled[0.2]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
      "RowsIndexed" -> {}}]], TraditionalForm]], "DisplayMath",
 CellMargins->{{22, Inherited}, {Inherited, Inherited}},
 TextAlignment->Center,
 TextJustification->0,
 FrameBoxOptions->{FrameMargins->0.25},
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.175, {0.56}, 0.175}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.1, {0.4}, 0.1}, "RowsIndexed" -> {}},
 MultilineFunction->Automatic},
 CellTags->{"EquationTypes", "b:1.0"},
 CellID->14708],

Cell["\<\
Examples of ODEs belonging to each of these types are given in other \
tutorials (clicking a link in the table will bring up the relevant examples).\
\
\>", "Text",
 CellTags->"b:1.0",
 CellID->248]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->82828609],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Overview of Ordinary Differential Equations (ODEs) - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveClassificationOfDifferentialEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveStraightIntegration"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 27.5318570}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "There are four major areas in the study of ordinary differential \
equations that are of interest in pure and applied science. Of these four \
areas, the study of exact solutions has the longest history, dating back to \
the period just after the discovery of calculus by Sir Isaac Newton and \
Gottfried Wilhelm von Leibniz. The following table is given as an \
introduction to the types of equations that can be solved by DSolve. Examples \
of ODEs belonging to each of these types are given in other tutorials \
(clicking a link in the table will bring up the relevant examples).", 
    "synonyms" -> {}, "title" -> 
    "Overview of Ordinary Differential Equations ODEs", "type" -> "Tutorial", 
    "uri" -> "tutorial/DSolveIntroductionToODEs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:6"->{
  Cell[1280, 43, 112, 2, 70, "Title",
   CellTags->{"c:6", "b:1.0"},
   CellID->23556]},
 "b:1.0"->{
  Cell[1280, 43, 112, 2, 70, "Title",
   CellTags->{"c:6", "b:1.0"},
   CellID->23556],
  Cell[1395, 47, 186, 5, 70, "Text",
   CellTags->"b:1.0",
   CellID->12290],
  Cell[1584, 54, 175, 5, 70, "BulletedText",
   CellTags->"b:1.0",
   CellID->21293],
  Cell[1762, 61, 221, 5, 70, "BulletedText",
   CellTags->"b:1.0",
   CellID->29996],
  Cell[1986, 68, 225, 6, 70, "BulletedText",
   CellTags->"b:1.0",
   CellID->29152],
  Cell[2236, 78, 252, 6, 70, "BulletedText",
   CellTags->"b:1.0",
   CellID->1054],
  Cell[2491, 86, 483, 12, 70, "Text",
   CellTags->"b:1.0",
   CellID->25345],
  Cell[2977, 100, 13063, 403, 70, "DisplayMath",
   CellTags->{"EquationTypes", "b:1.0"},
   CellID->14708],
  Cell[16043, 505, 208, 6, 70, "Text",
   CellTags->"b:1.0",
   CellID->248]},
 "EquationTypes"->{
  Cell[2977, 100, 13063, 403, 70, "DisplayMath",
   CellTags->{"EquationTypes", "b:1.0"},
   CellID->14708]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:6", 19259, 586},
 {"b:1.0", 19360, 590},
 {"EquationTypes", 20156, 618}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 112, 2, 70, "Title",
 CellTags->{"c:6", "b:1.0"},
 CellID->23556],
Cell[1395, 47, 186, 5, 70, "Text",
 CellTags->"b:1.0",
 CellID->12290],
Cell[1584, 54, 175, 5, 70, "BulletedText",
 CellTags->"b:1.0",
 CellID->21293],
Cell[1762, 61, 221, 5, 70, "BulletedText",
 CellTags->"b:1.0",
 CellID->29996],
Cell[1986, 68, 225, 6, 70, "BulletedText",
 CellTags->"b:1.0",
 CellID->29152],
Cell[CellGroupData[{
Cell[2236, 78, 252, 6, 70, "BulletedText",
 CellTags->"b:1.0",
 CellID->1054],
Cell[2491, 86, 483, 12, 70, "Text",
 CellTags->"b:1.0",
 CellID->25345],
Cell[2977, 100, 13063, 403, 70, "DisplayMath",
 CellTags->{"EquationTypes", "b:1.0"},
 CellID->14708],
Cell[16043, 505, 208, 6, 70, "Text",
 CellTags->"b:1.0",
 CellID->248]
}, Open  ]],
Cell[CellGroupData[{
Cell[16288, 516, 71, 1, 70, "RelatedTutorialsSection",
 CellID->82828609],
Cell[16362, 519, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[16566, 526, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

