(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22967,        767]
NotebookOptionsPosition[     15110,        517]
NotebookOutlinePosition[     21020,        691]
CellTagsIndexPosition[     20757,        679]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Introduction to Partial Differential Equations (PDEs)", "Title",
 CellTags->{"c:37", "b:2.0"},
 CellID->7491],

Cell[TextData[{
 "A partial differential equation (PDE) is a relationship between an unknown \
function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", 
     SubscriptBox["x", "2"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], ")"}], TraditionalForm]], "InlineMath"],
 " and its derivatives with respect to the variables ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", 
    SubscriptBox["x", "2"], ",", "\[Ellipsis]", ",", 
    SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellTags->"b:2.0",
 CellID->13712],

Cell["Here is an example of a PDE.", "MathCaption",
 CellTags->"b:2.0",
 CellID->5131],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"equation1", "=", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"\[PartialD]", 
        RowBox[{"u", "(", 
         RowBox[{"x", ",", "y"}], ")"}]}], 
       RowBox[{"\[PartialD]", "x"}],
       MultilineFunction->None], "+", 
      RowBox[{"x", " ", 
       FractionBox[
        RowBox[{"\[PartialD]", 
         RowBox[{"u", "(", 
          RowBox[{"x", ",", "y"}], ")"}]}], 
        RowBox[{"\[PartialD]", "y"}],
        MultilineFunction->None]}]}], "\[LongEqual]", 
     RowBox[{"sin", "(", "x", ")"}]}]}], ";"}], TraditionalForm]], "Input",
 TextAlignment->Left,
 CellTags->"b:2.0",
 CellLabel->"In[1]:=",
 CellID->1099455815],

Cell[TextData[{
 "PDEs occur naturally in applications because one tries to model the rate of \
change of a physical quantity with respect to both space variables and time \
variables. At this stage of development, ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " typically only works with PDEs having two independent variables."
}], "Text",
 CellTags->"b:2.0",
 CellID->16439],

Cell["\<\
The order of a PDE is the order of the highest derivative that occurs in it. \
The previous equation is a first-order PDE.\
\>", "Text",
 CellTags->"b:2.0",
 CellID->7958],

Cell[TextData[{
 "A function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath"],
 " is a ",
 StyleBox["solution",
  FontSlant->"Italic"],
 " to a given PDE if ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " and its derivatives satisfy the equation. "
}], "Text",
 CellTags->"b:2.0",
 CellID->24722],

Cell["Here is one solution to the previous equation.", "MathCaption",
 CellTags->"b:2.0",
 CellID->29704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   StyleBox[
    RowBox[{"u", "/.", 
     RowBox[{
      RowBox[{"DSolve", "[", 
       RowBox[{"equation1", ",", " ", "u", ",", " ", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}],
    FontSlant->"Plain"], "/.", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "[", "t_", "]"}], "\[Rule]", 
    "t"}]}]}]], "Input",
 CellTags->"b:2.0",
 CellLabel->"In[2]:=",
 CellID->6995],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Cos", "[", "x", "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"2", " ", "y"}]}], ")"}]}]}]}], "]"}]], "Output",
 ImageSize->{265, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.0",
 CellLabel->"Out[2]=",
 CellID->289213530]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
 CellTags->"b:2.0",
 CellID->25269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"equation1", " ", "/.", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", " ", "sol"}], "}"}]}]], "Input",
 CellTags->"b:2.0",
 CellLabel->"In[3]:=",
 CellID->7479],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.0",
 CellLabel->"Out[3]=",
 CellID->99066346]
}, Open  ]],

Cell[TextData[{
 "Here are some well-known examples of PDEs (clicking a link in the table \
will bring up the relevant examples). ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " gives symbolic solutions to equations of all these types, with certain \
restrictions, particularly for second-order PDEs."
}], "Text",
 CellTags->"b:2.0",
 CellID->26423],

Cell[BoxData[
 FormBox[
  FrameBox[GridBox[{
     {
      StyleBox[
       RowBox[{"Name", " ", "of", " ", "Equation"}],
       FontWeight->"Bold"], 
      StyleBox[
       RowBox[{"General", " ", "Form", " "}],
       FontWeight->"Bold"], 
      StyleBox[
       RowBox[{" ", "Classification"}],
       FontWeight->"Bold"]},
     {
      ButtonBox[
       RowBox[{"Transport", " ", "equation"}],
       BaseStyle->"Link",
       ButtonData->
        "paclet:tutorial/DSolveLinearAndQuasiLinearFirstOrderPDEs#9573"], 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{"\[PartialD]", "u"}], 
         RowBox[{"\[PartialD]", "x"}],
         MultilineFunction->None], "+", 
        RowBox[{"c", " ", 
         FractionBox[
          RowBox[{"\[PartialD]", "u"}], 
          RowBox[{"\[PartialD]", "y"}],
          MultilineFunction->None]}]}], "\[LongEqual]", 
       RowBox[{"0", " ", "with", " ", 
        StyleBox["c",
         FontSlant->"Italic"], 
        StyleBox[" ",
         FontSlant->"Plain"], 
        StyleBox["constant",
         FontSlant->"Plain"]}]}], Cell[TextData[ButtonBox[
      "linear first-order PDE",
       BaseStyle->"Link",
       ButtonData->
        "paclet:tutorial/DSolveLinearAndQuasiLinearFirstOrderPDEs"]]]},
     {Cell[TextData[ButtonBox["Burgers\[CloseCurlyQuote] equation",
       BaseStyle->"Link",
       ButtonData->
        "paclet:tutorial/DSolveLinearAndQuasiLinearFirstOrderPDEs#30195"]]], 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{"\[PartialD]", "u"}], 
         RowBox[{"\[PartialD]", "t"}],
         MultilineFunction->None], "+", 
        RowBox[{"u", " ", 
         FractionBox[
          RowBox[{"\[PartialD]", "u"}], 
          RowBox[{"\[PartialD]", "x"}],
          MultilineFunction->None]}]}], "\[LongEqual]", "0"}], Cell[TextData[
      ButtonBox["quasilinear first-order PDE",
       BaseStyle->"Link",
       ButtonData->
        "paclet:tutorial/DSolveLinearAndQuasiLinearFirstOrderPDEs"]]]},
     {
      ButtonBox[
       RowBox[{"Eikonal", " ", "equation"}],
       BaseStyle->"Link",
       ButtonData->"paclet:tutorial/DSolveNonlinearFirstOrderPDEs#8922"], 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox[
           RowBox[{"\[PartialD]", "u"}], 
           RowBox[{"\[PartialD]", "x"}],
           MultilineFunction->None], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox[
           RowBox[{"\[PartialD]", "u"}], 
           RowBox[{"\[PartialD]", "y"}],
           MultilineFunction->None], ")"}], "2"]}], "\[LongEqual]", "1"}], 
      Cell[TextData[ButtonBox["nonlinear first-order PDE",
       BaseStyle->"Link",
       ButtonData->"paclet:tutorial/DSolveNonlinearFirstOrderPDEs"]]]},
     {Cell[TextData[ButtonBox["Laplace\[CloseCurlyQuote]s equation",
       BaseStyle->"Link",
       ButtonData->"paclet:tutorial/DSolveSecondOrderPDEs#22885"]]], 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["\[PartialD]", "2"], "u"}], 
         RowBox[{"\[PartialD]", 
          SuperscriptBox["x", "2"]}]], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[PartialD]", "2"], "u"}], 
         RowBox[{"\[PartialD]", 
          SuperscriptBox["y", "2"]}]]}], "\[LongEqual]", "0"}], Cell[TextData[
      ButtonBox["elliptic linear second-order PDE",
       BaseStyle->"Link",
       ButtonData->"paclet:tutorial/DSolveSecondOrderPDEs"]]]},
     {
      ButtonBox[
       RowBox[{"Wave", " ", "equation"}],
       BaseStyle->"Link",
       ButtonData->"paclet:tutorial/DSolveSecondOrderPDEs#11072"], 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["\[PartialD]", "2"], "u"}], 
        RowBox[{"\[PartialD]", 
         SuperscriptBox["x", "2"]}],
        MultilineFunction->None], "=", " ", 
       RowBox[{
        FormBox[
         SuperscriptBox["c", "2"],
         TraditionalForm], 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[PartialD]", "2"], "u"}], 
         RowBox[{"\[PartialD]", 
          SuperscriptBox["t", "2"]}],
         MultilineFunction->None], " ", "where", " ", 
        StyleBox["c",
         FontSlant->"Italic"], 
        StyleBox[" ",
         FontSlant->"Plain"], "is", " ", "the", " ", "speed", " ", "of", " ", 
        "light"}]}], Cell[TextData[{
       ButtonBox["hyperbolic linear second-order PDE",
        BaseStyle->"Link",
        ButtonData->"paclet:tutorial/DSolveSecondOrderPDEs"],
       " "
      }]]},
     {
      ButtonBox[
       RowBox[{"Heat", " ", "equation"}],
       BaseStyle->"Link",
       ButtonData->"paclet:tutorial/DSolveSecondOrderPDEs#5303"], 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["\[PartialD]", "2"], "u"}], 
        RowBox[{"\[PartialD]", 
         SuperscriptBox["x", "2"]}]], "=", " ", 
       RowBox[{"k", 
        FractionBox[
         RowBox[{"\[PartialD]", "u"}], 
         RowBox[{"\[PartialD]", "t"}]], " ", "where", " ", 
        StyleBox["k",
         FontSlant->"Italic"], 
        StyleBox[" ",
         FontSlant->"Italic"], "is", " ", "the", " ", "thermal", " ", 
        "diffusivity"}]}], Cell[TextData[{
       ButtonBox["parabolic linear second-order PDE",
        BaseStyle->"Link",
        ButtonData->"paclet:tutorial/DSolveSecondOrderPDEs"],
       " "
      }]]}
    },
    GridBoxDividers->{
     "Columns" -> {False, {True}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
    GridBoxItemSize->{"Columns" -> {{
         Scaled[0.3]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
      "RowsIndexed" -> {}}]], TraditionalForm]], "DisplayMath",
 CellMargins->{{22, Inherited}, {Inherited, Inherited}},
 TextAlignment->Center,
 TextJustification->0,
 FrameBoxOptions->{FrameMargins->0.25},
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.175, {0.56}, 0.175}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.1, {0.4}, 0.1}, "RowsIndexed" -> {}},
 MultilineFunction->Automatic},
 CellTags->{
  "TransportEqn", "Burger'sEqn", "EikonalEqn", "LaplacesEqn", "WaveEqn", 
   "HeatEqn", "b:2.0"},
 CellID->27918],

Cell[TextData[{
 "Recall that the general solutions to PDEs involve arbitrary ",
 StyleBox["functions",
  FontSlant->"Italic"],
 " rather than arbitrary ",
 StyleBox["constants",
  FontSlant->"Italic"],
 ". The reason for this can be seen from the following example."
}], "Text",
 CellTags->"b:2.0",
 CellID->10866],

Cell[TextData[{
 "The partial derivative with respect to ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "does not appear in this example, so an arbitrary function ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["C",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/C"], "[", "1", "]"}], "[", 
   StyleBox["y", "TI"], "]"}]], "InlineFormula"],
 " can be added to the solution, since the partial derivative of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["C",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/C"], "[", "1", "]"}], "[", 
   StyleBox["y", "TI"], "]"}]], "InlineFormula"],
 " with respect to",
 StyleBox[" ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "is 0."
}], "MathCaption",
 CellTags->"b:2.0",
 CellID->17659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], "\[Equal]", "1"}], 
   ",", " ", 
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:2.0",
 CellLabel->"In[4]:=",
 CellID->32498],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], "\[Rule]", 
    RowBox[{"x", "+", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", "y", "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.0",
 CellLabel->"Out[4]=",
 CellID->413988716]
}, Open  ]],

Cell[TextData[{
 "If there are several arbitrary functions in the solution, they are labeled \
as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "2", "]"}]], "InlineFormula"],
 ", and so on."
}], "Text",
 CellTags->"b:2.0",
 CellID->21196],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->574175460],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction to Partial Differential Equations (PDEs) - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveLieSymmetryMethods"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveLinearAndQuasiLinearFirstOrderPDEs"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 28.1099968}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "A partial differential equation (PDE) is a relationship between an \
unknown function u(x_1,x_2,...,x_n) and its derivatives with respect to the \
variables x_1,x_2,...,x_n. Here is an example of a PDE. PDEs occur naturally \
in applications because one tries to model the rate of change of a physical \
quantity with respect to both space variables and time variables. At this \
stage of development, DSolve typically only works with PDEs having two \
independent variables.", "synonyms" -> {}, "title" -> 
    "Introduction to Partial Differential Equations PDEs", "type" -> 
    "Tutorial", "uri" -> "tutorial/DSolveIntroductionToPDEs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:37"->{
  Cell[1280, 43, 115, 2, 70, "Title",
   CellTags->{"c:37", "b:2.0"},
   CellID->7491]},
 "b:2.0"->{
  Cell[1280, 43, 115, 2, 70, "Title",
   CellTags->{"c:37", "b:2.0"},
   CellID->7491],
  Cell[1398, 47, 629, 20, 70, "Text",
   CellTags->"b:2.0",
   CellID->13712],
  Cell[2030, 69, 86, 2, 70, "MathCaption",
   CellTags->"b:2.0",
   CellID->5131],
  Cell[2119, 73, 693, 23, 70, "Input",
   CellTags->"b:2.0",
   CellID->1099455815],
  Cell[2815, 98, 449, 11, 70, "Text",
   CellTags->"b:2.0",
   CellID->16439],
  Cell[3267, 111, 181, 5, 70, "Text",
   CellTags->"b:2.0",
   CellID->7958],
  Cell[3451, 118, 389, 15, 70, "Text",
   CellTags->"b:2.0",
   CellID->24722],
  Cell[3843, 135, 105, 2, 70, "MathCaption",
   CellTags->"b:2.0",
   CellID->29704],
  Cell[3973, 141, 504, 18, 28, "Input",
   CellTags->"b:2.0",
   CellID->6995],
  Cell[4480, 161, 545, 20, 51, "Output",
   CellTags->"b:2.0",
   CellID->289213530],
  Cell[5040, 184, 86, 2, 70, "MathCaption",
   CellTags->"b:2.0",
   CellID->25269],
  Cell[5151, 190, 181, 6, 70, "Input",
   CellTags->"b:2.0",
   CellID->7479],
  Cell[5335, 198, 180, 6, 36, "Output",
   CellTags->"b:2.0",
   CellID->99066346],
  Cell[5530, 207, 422, 11, 70, "Text",
   CellTags->"b:2.0",
   CellID->26423],
  Cell[5955, 220, 6310, 179, 70, "DisplayMath",
   CellTags->{
    "TransportEqn", "Burger'sEqn", "EikonalEqn", "LaplacesEqn", "WaveEqn", 
     "HeatEqn", "b:2.0"},
   CellID->27918],
  Cell[12268, 401, 315, 10, 70, "Text",
   CellTags->"b:2.0",
   CellID->10866],
  Cell[12586, 413, 896, 32, 70, "MathCaption",
   CellTags->"b:2.0",
   CellID->17659],
  Cell[13507, 449, 410, 15, 70, "Input",
   CellTags->"b:2.0",
   CellID->32498],
  Cell[13920, 466, 401, 15, 36, "Output",
   CellTags->"b:2.0",
   CellID->413988716],
  Cell[14336, 484, 443, 17, 70, "Text",
   CellTags->"b:2.0",
   CellID->21196]},
 "TransportEqn"->{
  Cell[5955, 220, 6310, 179, 70, "DisplayMath",
   CellTags->{
    "TransportEqn", "Burger'sEqn", "EikonalEqn", "LaplacesEqn", "WaveEqn", 
     "HeatEqn", "b:2.0"},
   CellID->27918]},
 "Burger'sEqn"->{
  Cell[5955, 220, 6310, 179, 70, "DisplayMath",
   CellTags->{
    "TransportEqn", "Burger'sEqn", "EikonalEqn", "LaplacesEqn", "WaveEqn", 
     "HeatEqn", "b:2.0"},
   CellID->27918]},
 "EikonalEqn"->{
  Cell[5955, 220, 6310, 179, 70, "DisplayMath",
   CellTags->{
    "TransportEqn", "Burger'sEqn", "EikonalEqn", "LaplacesEqn", "WaveEqn", 
     "HeatEqn", "b:2.0"},
   CellID->27918]},
 "LaplacesEqn"->{
  Cell[5955, 220, 6310, 179, 70, "DisplayMath",
   CellTags->{
    "TransportEqn", "Burger'sEqn", "EikonalEqn", "LaplacesEqn", "WaveEqn", 
     "HeatEqn", "b:2.0"},
   CellID->27918]},
 "WaveEqn"->{
  Cell[5955, 220, 6310, 179, 70, "DisplayMath",
   CellTags->{
    "TransportEqn", "Burger'sEqn", "EikonalEqn", "LaplacesEqn", "WaveEqn", 
     "HeatEqn", "b:2.0"},
   CellID->27918]},
 "HeatEqn"->{
  Cell[5955, 220, 6310, 179, 70, "DisplayMath",
   CellTags->{
    "TransportEqn", "Burger'sEqn", "EikonalEqn", "LaplacesEqn", "WaveEqn", 
     "HeatEqn", "b:2.0"},
   CellID->27918]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:37", 17667, 573},
 {"b:2.0", 17768, 577},
 {"TransportEqn", 19543, 640},
 {"Burger'sEqn", 19746, 646},
 {"EikonalEqn", 19948, 652},
 {"LaplacesEqn", 20151, 658},
 {"WaveEqn", 20350, 664},
 {"HeatEqn", 20549, 670}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 115, 2, 70, "Title",
 CellTags->{"c:37", "b:2.0"},
 CellID->7491],
Cell[1398, 47, 629, 20, 70, "Text",
 CellTags->"b:2.0",
 CellID->13712],
Cell[2030, 69, 86, 2, 70, "MathCaption",
 CellTags->"b:2.0",
 CellID->5131],
Cell[2119, 73, 693, 23, 70, "Input",
 CellTags->"b:2.0",
 CellID->1099455815],
Cell[2815, 98, 449, 11, 70, "Text",
 CellTags->"b:2.0",
 CellID->16439],
Cell[3267, 111, 181, 5, 70, "Text",
 CellTags->"b:2.0",
 CellID->7958],
Cell[3451, 118, 389, 15, 70, "Text",
 CellTags->"b:2.0",
 CellID->24722],
Cell[3843, 135, 105, 2, 70, "MathCaption",
 CellTags->"b:2.0",
 CellID->29704],
Cell[CellGroupData[{
Cell[3973, 141, 504, 18, 28, "Input",
 CellTags->"b:2.0",
 CellID->6995],
Cell[4480, 161, 545, 20, 51, "Output",
 CellTags->"b:2.0",
 CellID->289213530]
}, Open  ]],
Cell[5040, 184, 86, 2, 70, "MathCaption",
 CellTags->"b:2.0",
 CellID->25269],
Cell[CellGroupData[{
Cell[5151, 190, 181, 6, 70, "Input",
 CellTags->"b:2.0",
 CellID->7479],
Cell[5335, 198, 180, 6, 36, "Output",
 CellTags->"b:2.0",
 CellID->99066346]
}, Open  ]],
Cell[5530, 207, 422, 11, 70, "Text",
 CellTags->"b:2.0",
 CellID->26423],
Cell[5955, 220, 6310, 179, 70, "DisplayMath",
 CellTags->{
  "TransportEqn", "Burger'sEqn", "EikonalEqn", "LaplacesEqn", "WaveEqn", 
   "HeatEqn", "b:2.0"},
 CellID->27918],
Cell[12268, 401, 315, 10, 70, "Text",
 CellTags->"b:2.0",
 CellID->10866],
Cell[12586, 413, 896, 32, 70, "MathCaption",
 CellTags->"b:2.0",
 CellID->17659],
Cell[CellGroupData[{
Cell[13507, 449, 410, 15, 70, "Input",
 CellTags->"b:2.0",
 CellID->32498],
Cell[13920, 466, 401, 15, 36, "Output",
 CellTags->"b:2.0",
 CellID->413988716]
}, Open  ]],
Cell[14336, 484, 443, 17, 70, "Text",
 CellTags->"b:2.0",
 CellID->21196],
Cell[CellGroupData[{
Cell[14804, 505, 72, 1, 70, "RelatedTutorialsSection",
 CellID->574175460],
Cell[14879, 508, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[15083, 515, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

