(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     89274,       2567]
NotebookOptionsPosition[     72765,       1963]
NotebookOutlinePosition[     81951,       2269]
CellTagsIndexPosition[     81858,       2263]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Linear IVPs and BVPs", "Title",
 CellTags->{"c:47", "b:4.1"},
 CellID->9762],

Cell["\<\
To begin, consider an initial value problem for a linear first-order ODE.\
\>", "Text",
 CellTags->"b:4.1",
 CellID->5967],

Cell["This is a linear first-order ODE.", "MathCaption",
 CellTags->"b:4.1",
 CellID->24408],

Cell[BoxData[
 RowBox[{
  RowBox[{"linearequation", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "t", "]"}], "-", 
     RowBox[{"3", "*", "t", "*", 
      RowBox[{"y", "[", "t", "]"}]}]}], "\[Equal]", "1"}]}], ";"}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[1]:=",
 CellID->4415],

Cell[TextData[{
 "Notice that the general solution is a linear function of the arbitrary \
constant ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:4.1",
 CellID->1908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"generalsolution", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{"linearequation", ",", " ", 
    RowBox[{"y", "[", "t", "]"}], ",", "t"}], "]"}]}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[2]:=",
 CellID->17223],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "t", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{"3", " ", 
         SuperscriptBox["t", "2"]}], "2"]], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{"3", " ", 
         SuperscriptBox["t", "2"]}], "2"]], " ", 
      SqrtBox[
       FractionBox["\[Pi]", "6"]], " ", 
      RowBox[{"Erf", "[", 
       RowBox[{
        SqrtBox[
         FractionBox["3", "2"]], " ", "t"}], "]"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{290, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[2]=",
 CellID->46618248]
}, Open  ]],

Cell[TextData[{
 "This finds a particular solution for the initial condition ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"y", "[", "0", "]"}], "==", "4"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:4.1",
 CellID->26434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"particularsolution", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"linearequation", ",", " ", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "4"}]}], "}"}], ",", " ", 
    "y", ",", "t"}], "]"}]}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[3]:=",
 CellID->5204],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ",", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"3", " ", 
          SuperscriptBox["t", "2"]}], "2"]], " ", 
       RowBox[{"(", 
        RowBox[{"24", "+", 
         RowBox[{
          SqrtBox[
           RowBox[{"6", " ", "\[Pi]"}]], " ", 
          RowBox[{"Erf", "[", 
           RowBox[{
            SqrtBox[
             FractionBox["3", "2"]], " ", "t"}], "]"}]}]}], ")"}]}]}], 
     "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{357, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[3]=",
 CellID->36699021]
}, Open  ]],

Cell["\<\
This verifies that the solution satisfies both the equation and the initial \
condition.\
\>", "MathCaption",
 CellTags->"b:4.1",
 CellID->4319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"linearequation", "/.", 
  RowBox[{"particularsolution", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[4]:=",
 CellID->958],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[4]=",
 CellID->108940101]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", "0", "]"}], "/.", 
  RowBox[{"particularsolution", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[5]:=",
 CellID->26806],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[5]=",
 CellID->298534757]
}, Open  ]],

Cell[TextData[{
 "Here is the solution to the same problem with the general initial condition \
",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"y", "[", "0", "]"}], "==", "a"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:4.1",
 CellID->18700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"particularsolution", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"linearequation", ",", " ", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "a"}]}], "}"}], ",", " ", 
    "y", ",", "t"}], "]"}]}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[6]:=",
 CellID->11367],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ",", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"3", " ", 
          SuperscriptBox["t", "2"]}], "2"]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", "a"}], "+", 
         RowBox[{
          SqrtBox[
           RowBox[{"6", " ", "\[Pi]"}]], " ", 
          RowBox[{"Erf", "[", 
           RowBox[{
            SqrtBox[
             FractionBox["3", "2"]], " ", "t"}], "]"}]}]}], ")"}]}]}], 
     "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{360, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[6]=",
 CellID->63888536]
}, Open  ]],

Cell[TextData[{
 "This plots several integral curves of the equation for different values of \
",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ". The plot shows that the solutions have an inflection point if the \
parameter ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " lies between ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ", while a global maximum or minimum arises for other values of ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:4.1",
 CellID->21787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "[", "t", "]"}], "/.", 
        RowBox[{"particularsolution", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
       RowBox[{"a", "\[Rule]", " ", "i"}]}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"-", "2"}], ",", "2", ",", "0.6"}], "}"}]}], "]"}], "]"}], 
   ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "1.8"}], ",", "1.8"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "4"}], ",", "4"}], "}"}]}]}], "]"}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[7]:=",
 CellID->28532],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 235},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[7]=",
 CellID->242609016]
}, Open  ]],

Cell[TextData[{
 "Here is the solution to a linear second-order equation with initial values \
prescribed for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "[", "t", "]"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "[", "t", "]"}], TraditionalForm]], 
  "InlineMath"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "==", "0"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:4.1",
 CellID->30974],

Cell[BoxData[
 RowBox[{
  RowBox[{"linearsecondorderODE", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", 
     RowBox[{"5", "*", 
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}]}], " ", "+", 
     RowBox[{"6", "*", 
      RowBox[{"x", "[", "t", "]"}]}]}], "\[Equal]", "0"}]}], ";"}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[8]:=",
 CellID->3447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"generalsolution", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{"linearsecondorderODE", ",", " ", "x", ",", "t"}], 
   "]"}]}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[9]:=",
 CellID->5021],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "3"}], " ", "t"}]], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "2"}], " ", "t"}]], " ", 
        RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{281, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[9]=",
 CellID->795622561]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"particularsolution", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"linearsecondorderODE", ",", " ", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
    " ", "x", ",", "t"}], "]"}]}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[10]:=",
 CellID->26222],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ",", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "3"}], " ", "t"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["\[ExponentialE]", "t"]}]}], ")"}]}]}], "]"}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{249, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[10]=",
 CellID->910248565]
}, Open  ]],

Cell["\<\
This verifies that the solution satisfies the equation and the initial \
conditions.\
\>", "MathCaption",
 CellTags->"b:4.1",
 CellID->2376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"linearsecondorderODE", "/.", 
   RowBox[{"particularsolution", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[11]:=",
 CellID->28583],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[11]=",
 CellID->21474770]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "[", "0", "]"}], "/.", 
  RowBox[{"particularsolution", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[12]:=",
 CellID->12723],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[12]=",
 CellID->5317203]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "'"}], "[", "0", "]"}], "/.", 
  RowBox[{"particularsolution", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[13]:=",
 CellID->22018],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[13]=",
 CellID->111268472]
}, Open  ]],

Cell["Here is a plot of the solution.", "MathCaption",
 CellTags->"b:4.1",
 CellID->9220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", "t", "]"}], "/.", "particularsolution"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "3"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[14]:=",
 CellID->31111],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW2m0VmUVPvB9d2BQZAwCgzAKCtBs0Aa7EKGZWVGZFdnqSrouFWKITeRS
G6QMW5orFzZApVkpyyzNoSRLSrFIyqTMLIIyzNQKmmg6PXt4z97fPt+951z4
QT9i6ccZ9vO8+93Tu897Dif2ruw7bVnvyqVLeqcdt6L3zL6lS86aduzyFbjU
GJJlQ/qyLNs+McNxjiP+n/4sxf9ZdjT9NtK1nP+au893uvjO1rsf3LNnLx3O
rZBcfcG3brrxvmrJoevXbTm8ggtEoEtcTRWc4yTu2rzz7JU31tFrx44/nLL4
S3Uk9+7918IFnxpYspvvnHD8erXKnArJJadu+Pn9j9SRxHQwqTqSF63Z9JXr
tiXJVut0q4WrZmAWrhoNEbD8jOvrSJqlqyTN0v1LDuM7i15+xaOP/oUOZ1dI
Lu27btu9D9WRPP+8Wzfe+kCSbLWfSFy+9q7PX7m1DhccAXfUkbSIrZI0O1ZJ
mh0PJb9DsOEQGZ3j/2a/LMODjSfTT9Mks6wj8FVxmRfGq22Hljg7Awfp3KGn
sx2X+amsV1fgGFqhl3l0/7nM52WuZvsrA7BZXExRH3bq3x0VSBga5qbDp1VI
wr1w8sCSI/gOwglBRYdPrZBEiCJQk2RrFomEVbQqLqtoVZJwIlxZR3LT7dtX
veeWOpIo0CjTdSRR9FH6B5YcyXdshZhVso5IWKbMquCyPKiStCivkrT6HyXn
5+0rCV2bh+NGymmfMf3cS7ie3NWCgGs6rWytiVoR+8BZ+4Jw3igh5gWJWIeO
CZqXc7nhdN21a/fJJ111oHStZhBdD8pbs3rmAdC1J5yXVwSvq9UV0rWp0VNe
lSh25g9at6YiXzgonaySVdsvVu2oQT0dSx6oWGW8tlZNo7Ypt7v07568dcWZ
V3G/6Ua55up7Lv3YHe1GoZ+5TtIqcZWkVeIqSet8+pckuyylRJaMVXtJfI0I
qJHhvOp+1fn+4v/X9NlfPGdFix8QEgiM//vhQPjhYL5q3cLwIPX4cD45nMcV
L44SdxWOq7g/kJbWqTylgnWw534U6zziKPQz10laL92/5Ci+Y6vukyskbZeA
JFu7RZGQbKnDZV5tJzmVDroxB0wYll2/bgu6S8wcuuK4y/GY3dvxTKSDg9Hi
FjzQEC1tzzGXwzogBBYX0bdCAFbodsz23NKOeQwHBMyBFRcM4BH10FEXtDAF
SA5xnOaVdpwjEyeAoipWAagKu2NpxxVMQfScwJzM7Hr4GW04ucsZIRYQM4JN
OMEvSmKh4SfzxGg9/wzn52w4eknRDNpgGjJVMR+UPswxrC522aJO/2xlAgFo
0KGKMjAmTDTTMdmTVGT6KzPBGDIz6OSZZEdwjmOy9T0y7aafYRgYE0FXAtPA
kTI1KASa7EjHY6t/5HmMoxbWlKCELrASLI42B6CjHIf1BZHj4cQBEKAgQAyI
OWG05zHHaMaAHlfo8EmB47fMgZuih3BgYpgeJtnjOKxjjBw7k54wG6DZUAyX
/AqSbIFjQYOFNiuxULz8kk66MAtcxxiYK0yPGUEnqW+KtO4sjs8Pkp1QDoNj
aEwAgjg9waFtTyKiOfS6oCe0hRUxPgR1/Jc5BsvHyMCNaRfkoSLyAVKYOwwI
i2SLmGFMyL7DAgMbpFMYEDCYBGaAvDrJoS3TxuX1d8a4bHZCd8yoYEaEvdYx
W3c9ln4GtVu2hfkxU1gPfsPcwQb+xY7fPFfm72/nbDOddCCgYErYDb84zt7o
WC1Hy6xV+193staIOdQLqAweqI9JvMnx257l4Pm/w/xwNmjhN/CgNsEJSxjO
fG4tHVPir95zu53tg4CQpMUvjrPTHb+twGPzgXfhbkvaIgqgKhQWa/Q5Ntux
mR7QG1kTWEuyD7+0RrzVYa0uR+w3GAtiVFCMjPGpgi5zWMvbiL2ZsZBHeGFc
KIg6np3psJaxhCVzfo0xyDPRFVFJWb6CMePy1hx9YhjvBsZiDEQLsKrrSoe1
DI3Yr7I/MRfME/8hdN/pcJZ/EcctRRPisqxj8Hc7nOVVxF3rcFAXcbDK4cym
EbehhDvH4cyeEXd1CXcu48YHm05TP3yhJH++k7eVZloY56pkxwL3foeztSXi
rmQcxGF8sOPggw5nu98R9znGYd7ILwwJ+692OOv6Iu4zjMOk0RYgVpBOH3Y4
W9Ejbj3jJA0BheCFjOMezu0jTQ24TzMO+kBJTAUKr3E4y92I+2SaH0QwFdjl
ow5neTtV/baW5aEWbmFeYL3YyVtFjuOsTX7DFEAJgksczuIq4i5z+sFvSNZL
Gfe4EFdPCLiPJ79iPCgp54pCCMCP7VDM3YSJYQpYEdyXOZxFF/XnxfrbUeBZ
tlxdL0k2w8ShDpy01rFCO8yNDvlZrHJt9OcXpyiE1+GQ7BOO11avMm9TvUl/
k/prnIaYOqAcF9nEYOWD2jL57iDO/aJc642sgBKnymt+KPOm3dDI95Fc8wr5
KPGwzjGah+ozXug0RJpK5ipfq2/SLuJAHvlQsiRUgX4I3M86PvPJoQG3Ot2H
JzGF7AqHAhtcQL1kRF3A59Iy0prLVS6bxFdtLZoSUB/INaegINSkZHY4s+EU
jZL3JQthFPxK7VZpe6KOowgKASVmyL7oUGaHiDqPz+FWqE/xwuuK7t1YHMa9
m3NzrT7QkLqgaxzKdhki6hznK0iBe0OBo+8Nom7vTbohcMlH17pRbEWNo6wK
un3Zoezd22S1Na/uDXmep+6CFxfltH4u7mW9K7HJc6h0G4qyp+uI4g5En1Cp
c7reocyvEfWOdB8eot7pBoeyp92IOpvPUVPBSpHMfZh63/w6KaDOcvNCLc9u
cijrESJqRYoxndfNDmUdU0S9PflJ53WLQ9lO2iT10/LEpn76upO2fI1jnJHu
wwpQI+PSollt1XBiQC1zVqAKtbFAUZTGMd6WolTj7ZtuDFuf4xjcretKQrO/
zaEsSukLjfjcSYft6upb+Fw6e7IQB5OuuBbJXE8H+eTDX4ZRb4LaTFb+tmO2
ncK6zLT+neb8AoZsk2M03++LrqcnC8oTpjwXKrPFSXvmRhuriqaop9CJavF3
WXxqiKDOEl/kiXq+OdeckSYwu6PgpRjrzlvfoUX0khQ9mjt3Oq3MfhMC6tRc
Y1IjZLNDwSroCOlqRPXyOaoBLEq24/ZU+2ir9eMDip/rqa5qn/89h7IuN33f
w7sMDdmXpcPvO2lbu+IYpyTNEZfk6x8wSp6UbP9tXEC9IaGgPHWqdzuUPRdG
1OIUV7A4xcFWh7K1KKJen+fFCkZe/qFDWTRG1OsC6keMmh4sPjageH9JVwSK
iXscyp63CEWgk1MEaSz82EnbVwlxjNek+SrqXkbJ3po9K40JKN5Ta8h2Fc13
W4GiWI9jvDpJ68r1EzeGPf/FMV6V4k1X0Z8ySvYN7du00QH1ylxrmMbdfQ5l
sRBRi1K0auX7mUNZ9kXUKxJKu4P7GTUjRCvtQFNGnBhi+wEnbTX3kDBGgdLY
/oVDme0i6qUORbHN+8P6DsQ0GxVQvNfrMmK7Q5mGEfWShNLY/pVDWabXXfOO
T/GqbDuYjd+pdSANfEGusXa8OLDtdGzUf1az0dq2MM0FLJSHv3YslDNZppuQ
AzwjHZtrLmt9/w3Lz0xjagWoM6eFiUkz9sFWJq1bdZhelGvuQydi4vcY/BZ3
oJ3OBQmlub+rQPl1IL67lS9rrGI85FBIZQQlXY2o+QmlleN3jJKv7Kxuxrff
8/LWyvGwQ1nOEIrMI18yWcX4PUvLF5HWZcV34YKyivGIQ9kzb0Q9P2+tAY85
FK7CCvScF1H8FooyDL6lGsAlWb8Ctm58WEA9N9lWmprsjw5lY0XUc1Ksaxfz
J0bNCWN1B9TRzrYU3bsdysYiFIGOShGkEbyHpeeGMeI+wbNTLMAKFAt/diic
6/N7RD0reVdjgReNTP6lgfXycZfoGYkV9+kZ+m+MOoKv2lNTzIwjk8VhBXrT
8neHsue6iHp6uq8W58c4vWo7CTF3j0gzUIv/w6GgN6ouXY2ow5ONNQv57bDq
bT1PQzOjiBV91vo3S4ttbC2N721muwiiGP+PQ8Hb2stEVJE5agW+mD2TDSY9
jdVYltVdBySSPPnmQ/gu+7tp3VHKe9tzIFn5Lm5W3v93qw1nfxpzVrK3PhOS
oHz3Fr/57eebS6oVclHWRt2Bk4dfEuwYFBt5T/6Q8PTkQd2BI9GumnxFjGiv
wFy6tyUbTyTYPRi2piyJ8g56avKW7HdL7uTDB8PXKVfAUWx/8D5BE3MtdsMJ
MKLwa2kF6ypY8Qc49SM/+zcRd1ANzNIZ5bz3WfoeSb4GlciGLCzDfX6HvPWT
92cU2yQ8qi1DM2ldvDjjzo3eiK3md5CYX2IY3ZaB50LviuWNHTTBAeBcx7uQ
OTiFGvKtiLyCZOjYgq2pT6GcV1ACcvJ9StaBw6yz+F4F92AXjc4JbbWR9Rqj
QgNaYxr8I0sm3aKfSW2R9LPv/wqNjuRft2VD/gvWH6J5\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[14]=",
 CellID->457677084]
}, Open  ]],

Cell[TextData[{
 "To get more information about the solutions for the problem, set ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None], "[", "0", "]"}], "==", "x0"}], 
   TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:4.1",
 CellID->23856],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"particularsolution", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"linearsecondorderODE", ",", " ", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "x0"}]}], "}"}], ",",
     " ", "x", ",", "t"}], "]"}]}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[15]:=",
 CellID->19490],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ",", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "3"}], " ", "t"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["\[ExponentialE]", "t"]}], "-", "x0", "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", "t"], " ", "x0"}]}], ")"}]}]}], 
     "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{318, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[15]=",
 CellID->515409851]
}, Open  ]],

Cell[TextData[{
 "Here is a plot of the solutions for different initial directions. The \
solution approaches ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 " as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "\[Rule]", 
    RowBox[{"-", "\[Infinity]"}]}], TraditionalForm]], "InlineMath"],
 " according to whether the value of ",
 Cell[BoxData[
  FormBox["x0", TraditionalForm]], "InlineMath"],
 " is less than or greater than ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "2"}], TraditionalForm]], "InlineMath"],
 ", which is the largest root of the auxiliary equation for the ODE."
}], "MathCaption",
 CellTags->"b:4.1",
 CellID->4324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"GraphicsArray", "[", 
   RowBox[{
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"Evaluate", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"x", "[", "t", "]"}], "/.", 
             RowBox[{"particularsolution", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
            RowBox[{"x0", "\[Rule]", " ", "i"}]}], "]"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"t", ",", 
            RowBox[{"-", "1"}], ",", "3"}], "}"}], ",", " ", 
          RowBox[{"PlotStyle", " ", "\[Rule]", " ", 
           RowBox[{"{", "Red", "}"}]}], ",", " ", 
          RowBox[{"PlotLabel", " ", "\[Rule]", " ", 
           RowBox[{"StringJoin", "[", 
            RowBox[{"\"\<x0= \>\"", ",", " ", 
             RowBox[{"ToString", "[", "i", "]"}]}], "]"}]}], ",", " ", 
          RowBox[{"Ticks", " ", "\[Rule]", " ", "None"}]}], "]"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"-", "4"}], ",", "1"}], "}"}]}], "]"}], ",", " ", 
      RowBox[{"{", "3", "}"}]}], "]"}], ",", " ", 
    RowBox[{"ImageSize", " ", "\[Rule]", " ", "400"}]}], "]"}], 
  "]"}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[16]:=",
 CellID->6486],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{400, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[16]=",
 CellID->551322452]
}, Open  ]],

Cell["\<\
Here is a BVP for an inhomogeneous linear second-order equation.\
\>", "MathCaption",
 CellTags->"b:4.1",
 CellID->15969],

Cell[BoxData[
 RowBox[{
  RowBox[{"inhomogeneousequation", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], " ", "+", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", 
    RowBox[{"E", "^", "x"}]}]}], ";"}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[17]:=",
 CellID->11643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"generalsolution", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{"inhomogeneousequation", ",", " ", "y", ",", "x"}], 
   "]"}]}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[18]:=",
 CellID->7534],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"Cos", "[", "x", "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"Sin", "[", "x", "]"}]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", "x"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"Cos", "[", "x", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "x", "]"}], "2"]}], ")"}]}]}]}], "]"}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{480, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[18]=",
 CellID->543402448]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"inhomogeneousequation", ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "\[Equal]", 
      RowBox[{"1", "/", "2"}]}]}], "}"}], ",", " ", "y", ",", "x"}], 
  "]"}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[19]:=",
 CellID->22668],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Cos", "[", "x", "]"}], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", "x"], " ", 
          SuperscriptBox[
           RowBox[{"Cos", "[", "x", "]"}], "2"]}], "-", 
         RowBox[{
          RowBox[{"Cot", "[", "1", "]"}], " ", 
          RowBox[{"Sin", "[", "x", "]"}]}], "-", 
         RowBox[{"\[ExponentialE]", " ", 
          RowBox[{"Cos", "[", "1", "]"}], " ", 
          RowBox[{"Cot", "[", "1", "]"}], " ", 
          RowBox[{"Sin", "[", "x", "]"}]}], "+", 
         RowBox[{
          RowBox[{"Csc", "[", "1", "]"}], " ", 
          RowBox[{"Sin", "[", "x", "]"}]}], "-", 
         RowBox[{"\[ExponentialE]", " ", 
          RowBox[{"Sin", "[", "1", "]"}], " ", 
          RowBox[{"Sin", "[", "x", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", "x"], " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}]}]}], "]"}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{508, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[19]=",
 CellID->188591108]
}, Open  ]],

Cell["\<\
It should be noted that, in contrast to initial value problems, there are no \
general existence or uniqueness theorems when boundary values are prescribed, \
and there may be no solution in some cases.\
\>", "Text",
 CellTags->"b:4.1",
 CellID->21991],

Cell[TextData[{
 "This problem has no solution because the term with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "2", "]"}]], "InlineFormula"],
 " in the general solution vanishes at both ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[LongEqual]", "0"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[LongEqual]", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 ". Hence there are two inconsistent conditions for the parameter ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 " and the solution is an empty set."
}], "MathCaption",
 CellTags->"b:4.1",
 CellID->32196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"inhomogeneousequation", ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "Pi", "]"}], "\[Equal]", "6"}]}], "}"}], ",", " ", 
   "y", ",", "x"}], "]"}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[20]:=",
 CellID->7783],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"bvnul\"\>"}], ":", 
  " ", "\<\"For some branches of the general solution, the given boundary \
conditions lead to an empty solution. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\
\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/DSolve/bvnul\\\", ButtonNote -> \
\\\"DSolve::bvnul\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:4.1",
 CellLabel->"During evaluation of In[20]:=",
 CellID->665656],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[20]=",
 CellID->51367051]
}, Open  ]],

Cell["\<\
The previous discussion of linear equations generalizes to the case of \
higher-order linear ODEs and linear systems of ODEs.\
\>", "Text",
 CellTags->"b:4.1",
 CellID->29426],

Cell["\<\
Here is the solution to an Initial Value Problem (IVP) for a linear ODE of \
order four.\
\>", "MathCaption",
 CellTags->"b:4.1",
 CellID->15871],

Cell[BoxData[
 RowBox[{
  RowBox[{"fourthorderODE", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''''"}], "[", "x", "]"}], " ", "+", " ", 
     RowBox[{"2", "*", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], " ", "+", 
     RowBox[{"y", "[", "x", "]"}]}], " ", "\[Equal]", 
    RowBox[{"Cos", "[", "x", "]"}]}]}], ";"}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[21]:=",
 CellID->10697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"fourthorderODE", ",", " ", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "6"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "0", "]"}], "\[Equal]", "3"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'''"}], "[", "0", "]"}], "\[Equal]", 
       RowBox[{"-", "1"}]}]}], "}"}], ",", " ", "y", ",", "x"}], 
   "]"}]}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[22]:=",
 CellID->17612],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       FractionBox["1", "16"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"11", " ", 
          RowBox[{"Cos", "[", "x", "]"}]}], "-", 
         RowBox[{"40", " ", "x", " ", 
          RowBox[{"Cos", "[", "x", "]"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"Cos", "[", "x", "]"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"Cos", "[", "x", "]"}], "3"]}], "+", 
         RowBox[{
          RowBox[{"Cos", "[", "x", "]"}], " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"2", " ", "x"}], "]"}]}], "+", 
         RowBox[{"136", " ", 
          RowBox[{"Sin", "[", "x", "]"}]}], "+", 
         RowBox[{"34", " ", "x", " ", 
          RowBox[{"Sin", "[", "x", "]"}]}], "+", 
         RowBox[{"3", " ", 
          RowBox[{"Sin", "[", "x", "]"}], " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"2", " ", "x"}], "]"}]}]}], ")"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{528, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[22]=",
 CellID->151281219]
}, Open  ]],

Cell["This verifies the solution and the initial conditions.", "MathCaption",
 CellTags->"b:4.1",
 CellID->11027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"fourthorderODE", ",", " ", 
     RowBox[{"y", "[", "0", "]"}], ",", " ", 
     RowBox[{
      RowBox[{"y", "'"}], "[", "0", "]"}], ",", " ", 
     RowBox[{
      RowBox[{"y", "''"}], "[", "0", "]"}], ",", " ", 
     RowBox[{
      RowBox[{"y", "'''"}], "[", "0", "]"}]}], "}"}], "/.", "sol"}], "//", 
  "Simplify"}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[23]:=",
 CellID->11408],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"True", ",", "1", ",", "6", ",", "3", ",", 
    RowBox[{"-", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[23]=",
 CellID->479111200]
}, Open  ]],

Cell[TextData[{
 "Since this is a fourth-order ODE, four independent conditions must be \
specified to find a particular solution for an IVP. If there is an \
insufficient number of conditions, the solution returned by ",
 StyleBox["DSolve", "MR"],
 " may contain some of the arbitrary parameters, as follows."
}], "MathCaption",
 CellTags->"b:4.1",
 CellID->9508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"fourthorderODE", ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "6"}]}], "}"}], ",", 
   " ", "y", ",", "x"}], "]"}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[24]:=",
 CellID->7185],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       FractionBox["1", "16"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"11", " ", 
          RowBox[{"Cos", "[", "x", "]"}]}], "+", 
         RowBox[{"96", " ", "x", " ", 
          RowBox[{"Cos", "[", "x", "]"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"Cos", "[", "x", "]"}]}], "-", 
         RowBox[{"16", " ", "x", " ", 
          RowBox[{"C", "[", "3", "]"}], " ", 
          RowBox[{"Cos", "[", "x", "]"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"Cos", "[", "x", "]"}], "3"]}], "+", 
         RowBox[{
          RowBox[{"Cos", "[", "x", "]"}], " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"2", " ", "x"}], "]"}]}], "+", 
         RowBox[{"4", " ", "x", " ", 
          RowBox[{"Sin", "[", "x", "]"}]}], "+", 
         RowBox[{"16", " ", 
          RowBox[{"C", "[", "3", "]"}], " ", 
          RowBox[{"Sin", "[", "x", "]"}]}], "+", 
         RowBox[{"16", " ", "x", " ", 
          RowBox[{"C", "[", "4", "]"}], " ", 
          RowBox[{"Sin", "[", "x", "]"}]}], "+", 
         RowBox[{"3", " ", 
          RowBox[{"Sin", "[", "x", "]"}], " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"2", " ", "x"}], "]"}]}]}], ")"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{588, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[24]=",
 CellID->201282968]
}, Open  ]],

Cell["\<\
Finally, here is the solution of an IVP for a linear system of ODEs.\
\>", "MathCaption",
 CellTags->"b:4.1",
 CellID->24237],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "]"}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[25]:=",
 CellID->26443],

Cell[BoxData[
 RowBox[{
  RowBox[{"linearsystem", " ", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], "-", 
       RowBox[{"4", "*", 
        RowBox[{"y", "[", "t", "]"}]}], "+", "1"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "t", "]"}], " ", "\[Equal]", " ", 
      RowBox[{
       RowBox[{"4", "*", " ", 
        RowBox[{"x", "[", "t", "]"}]}], " ", "+", " ", 
       RowBox[{"y", "[", "t", "]"}]}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"z", "[", "t", "]"}]}]}], "}"}]}], ";"}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[26]:=",
 CellID->21313],

Cell[BoxData[
 RowBox[{
  RowBox[{"initialvalues", " ", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "2"}], ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", 
      RowBox[{"-", "1"}]}], ",", " ", 
     RowBox[{
      RowBox[{"z", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}]}], 
  ";"}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[27]:=",
 CellID->22501],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{"linearsystem", ",", " ", "initialvalues"}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "t"}], "]"}]}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[28]:=",
 CellID->8850],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        FractionBox["1", "17"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"35", " ", 
           SuperscriptBox["\[ExponentialE]", "t"], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"4", " ", "t"}], "]"}]}], "-", 
          SuperscriptBox[
           RowBox[{"Cos", "[", 
            RowBox[{"4", " ", "t"}], "]"}], "2"], "+", 
          RowBox[{"21", " ", 
           SuperscriptBox["\[ExponentialE]", "t"], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"4", " ", "t"}], "]"}]}], "-", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"4", " ", "t"}], "]"}], "2"]}], ")"}]}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        FractionBox["1", "17"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "21"}], " ", 
           SuperscriptBox["\[ExponentialE]", "t"], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"4", " ", "t"}], "]"}]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"Cos", "[", 
             RowBox[{"4", " ", "t"}], "]"}], "2"]}], "+", 
          RowBox[{"35", " ", 
           SuperscriptBox["\[ExponentialE]", "t"], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"4", " ", "t"}], "]"}]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"4", " ", "t"}], "]"}], "2"]}]}], ")"}]}]}], "]"}]}], 
    ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       SuperscriptBox["\[ExponentialE]", "t"]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{535, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[28]=",
 CellID->4508852]
}, Open  ]],

Cell["\<\
This verifies that the solution satisfies the system and the initial \
conditions.\
\>", "MathCaption",
 CellTags->"b:4.1",
 CellID->2111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"linearsystem", ",", " ", "initialvalues"}], "}"}], "/.", 
   RowBox[{"sol", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[29]:=",
 CellID->23650],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], "}"}]], "Output",
 ImageSize->{270, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[29]=",
 CellID->94483441]
}, Open  ]],

Cell[TextData[{
 "The solutions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "[", "t", "]"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "t", "]"}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "[", "t", "]"}], TraditionalForm]], "InlineMath"],
 " are parametrized by the variable ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " and can be plotted separately in the plane or as a curve in space."
}], "MathCaption",
 CellTags->"b:4.1",
 CellID->11192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", " ", 
       RowBox[{"y", "[", "t", "]"}], ",", " ", 
       RowBox[{"z", "[", "t", "]"}]}], "}"}], "/.", "sol"}], "]"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[30]:=",
 CellID->1454],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[30]=",
 CellID->6772032]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", " ", 
       RowBox[{"y", "[", "t", "]"}], ",", " ", 
       RowBox[{"z", "[", "t", "]"}]}], "}"}], "/.", "sol"}], "]"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", " ", 
   RowBox[{"PlotRange", " ", "\[Rule]", " ", "All"}]}], "]"}]], "Input",
 CellTags->"b:4.1",
 CellLabel->"In[31]:=",
 CellID->681],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 249},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:4.1",
 CellLabel->"Out[31]=",
 CellID->51964927]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->237223511],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Linear IVPs and BVPs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveIntroductionToBVPs"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveNonlinearBVPs"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 34.5007854}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "To begin, consider an initial value problem for a linear first-order \
ODE. This is a linear first-order ODE. Notice that the general solution is a \
linear function of the arbitrary constant C[1].", "synonyms" -> {}, "title" -> 
    "Linear IVPs and BVPs", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveLinearBVPs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:47"->{
  Cell[1280, 43, 82, 2, 70, "Title",
   CellTags->{"c:47", "b:4.1"},
   CellID->9762]},
 "b:4.1"->{
  Cell[1280, 43, 82, 2, 70, "Title",
   CellTags->{"c:47", "b:4.1"},
   CellID->9762],
  Cell[1365, 47, 132, 4, 70, "Text",
   CellTags->"b:4.1",
   CellID->5967],
  Cell[1500, 53, 92, 2, 70, "MathCaption",
   CellTags->"b:4.1",
   CellID->24408],
  Cell[1595, 57, 325, 11, 70, "Input",
   CellTags->"b:4.1",
   CellID->4415],
  Cell[1923, 70, 297, 11, 70, "MathCaption",
   CellTags->"b:4.1",
   CellID->1908],
  Cell[2245, 85, 247, 7, 28, "Input",
   CellTags->"b:4.1",
   CellID->17223],
  Cell[2495, 94, 815, 29, 61, "Output",
   CellTags->"b:4.1",
   CellID->46618248],
  Cell[3325, 126, 261, 10, 70, "MathCaption",
   CellTags->"b:4.1",
   CellID->26434],
  Cell[3611, 140, 347, 11, 28, "Input",
   CellTags->"b:4.1",
   CellID->5204],
  Cell[3961, 153, 812, 28, 63, "Output",
   CellTags->"b:4.1",
   CellID->36699021],
  Cell[4788, 184, 154, 5, 70, "MathCaption",
   CellTags->"b:4.1",
   CellID->4319],
  Cell[4967, 193, 189, 6, 70, "Input",
   CellTags->"b:4.1",
   CellID->958],
  Cell[5159, 201, 181, 6, 36, "Output",
   CellTags->"b:4.1",
   CellID->108940101],
  Cell[5377, 212, 206, 7, 70, "Input",
   CellTags->"b:4.1",
   CellID->26806],
  Cell[5586, 221, 178, 6, 36, "Output",
   CellTags->"b:4.1",
   CellID->298534757],
  Cell[5779, 230, 280, 11, 70, "MathCaption",
   CellTags->"b:4.1",
   CellID->18700],
  Cell[6084, 245, 348, 11, 70, "Input",
   CellTags->"b:4.1",
   CellID->11367],
  Cell[6435, 258, 841, 29, 63, "Output",
   CellTags->"b:4.1",
   CellID->63888536],
  Cell[7291, 290, 678, 22, 70, "MathCaption",
   CellTags->"b:4.1",
   CellID->21787],
  Cell[7994, 316, 781, 25, 47, "Input",
   CellTags->"b:4.1",
   CellID->28532],
  Cell[8778, 343, 12778, 214, 256, "Output",
   Evaluatable->False,
   CellTags->"b:4.1",
   CellID->242609016],
  Cell[21571, 560, 532, 20, 70, "MathCaption",
   CellTags->"b:4.1",
   CellID->30974],
  Cell[22106, 582, 423, 14, 70, "Input",
   CellTags->"b:4.1",
   CellID->3447],
  Cell[22554, 600, 226, 7, 70, "Input",
   CellTags->"b:4.1",
   CellID->5021],
  Cell[22783, 609, 695, 23, 39, "Output",
   CellTags->"b:4.1",
   CellID->795622561],
  Cell[23515, 637, 461, 14, 70, "Input",
   CellTags->"b:4.1",
   CellID->26222],
  Cell[23979, 653, 631, 22, 39, "Output",
   CellTags->"b:4.1",
   CellID->910248565],
  Cell[24625, 678, 150, 5, 70, "MathCaption",
   CellTags->"b:4.1",
   CellID->2376],
  Cell[24800, 687, 231, 7, 70, "Input",
   CellTags->"b:4.1",
   CellID->28583],
  Cell[25034, 696, 181, 6, 36, "Output",
   CellTags->"b:4.1",
   CellID->21474770],
  Cell[25252, 707, 207, 7, 70, "Input",
   CellTags->"b:4.1",
   CellID->12723],
  Cell[25462, 716, 177, 6, 36, "Output",
   CellTags->"b:4.1",
   CellID->5317203],
  Cell[25676, 727, 226, 8, 70, "Input",
   CellTags->"b:4.1",
   CellID->22018],
  Cell[25905, 737, 179, 6, 36, "Output",
   CellTags->"b:4.1",
   CellID->111268472],
  Cell[26099, 746, 89, 2, 70, "MathCaption",
   CellTags->"b:4.1",
   CellID->9220],
  Cell[26213, 752, 324, 11, 28, "Input",
   CellTags->"b:4.1",
   CellID->31111],
  Cell[26540, 765, 4792, 83, 244, "Output",
   Evaluatable->False,
   CellTags->"b:4.1",
   CellID->457677084],
  Cell[31347, 851, 334, 12, 70, "MathCaption",
   CellTags->"b:4.1",
   CellID->23856],
  Cell[31706, 867, 462, 14, 70, "Input",
   CellTags->"b:4.1",
   CellID->19490],
  Cell[32171, 883, 731, 24, 39, "Output",
   CellTags->"b:4.1",
   CellID->515409851],
  Cell[32917, 910, 768, 24, 70, "MathCaption",
   CellTags->"b:4.1",
   CellID->4324],
  Cell[33710, 938, 1341, 35, 83, "Input",
   CellTags->"b:4.1",
   CellID->6486],
  Cell[35054, 975, 4670, 81, 184, "Output",
   Evaluatable->False,
   CellTags->"b:4.1",
   CellID->551322452],
  Cell[39739, 1059, 131, 4, 70, "MathCaption",
   CellTags->"b:4.1",
   CellID->15969],
  Cell[39873, 1065, 328, 11, 70, "Input",
   CellTags->"b:4.1",
   CellID->11643],
  Cell[40226, 1080, 228, 7, 70, "Input",
   CellTags->"b:4.1",
   CellID->7534],
  Cell[40457, 1089, 892, 29, 51, "Output",
   CellTags->"b:4.1",
   CellID->543402448],
  Cell[41386, 1123, 406, 13, 70, "Input",
   CellTags->"b:4.1",
   CellID->22668],
  Cell[41795, 1138, 1360, 39, 73, "Output",
   CellTags->"b:4.1",
   CellID->188591108],
  Cell[43170, 1180, 262, 6, 70, "Text",
   CellTags->"b:4.1",
   CellID->21991],
  Cell[43435, 1188, 764, 24, 70, "MathCaption",
   CellTags->"b:4.1",
   CellID->32196],
  Cell[44224, 1216, 380, 12, 70, "Input",
   CellTags->"b:4.1",
   CellID->7783],
  Cell[44607, 1230, 487, 10, 70, "Message",
   CellTags->"b:4.1",
   CellID->665656],
  Cell[45097, 1242, 195, 7, 36, "Output",
   CellTags->"b:4.1",
   CellID->51367051],
  Cell[45307, 1252, 185, 5, 70, "Text",
   CellTags->"b:4.1",
   CellID->29426],
  Cell[45495, 1259, 155, 5, 70, "MathCaption",
   CellTags->"b:4.1",
   CellID->15871],
  Cell[45653, 1266, 437, 14, 70, "Input",
   CellTags->"b:4.1",
   CellID->10697],
  Cell[46115, 1284, 667, 21, 70, "Input",
   CellTags->"b:4.1",
   CellID->17612],
  Cell[46785, 1307, 1313, 39, 73, "Output",
   CellTags->"b:4.1",
   CellID->151281219],
  Cell[48113, 1349, 113, 2, 70, "MathCaption",
   CellTags->"b:4.1",
   CellID->11027],
  Cell[48251, 1355, 451, 15, 70, "Input",
   CellTags->"b:4.1",
   CellID->11408],
  Cell[48705, 1372, 302, 10, 36, "Output",
   CellTags->"b:4.1",
   CellID->479111200],
  Cell[49022, 1385, 364, 8, 70, "MathCaption",
   CellTags->"b:4.1",
   CellID->9508],
  Cell[49411, 1397, 395, 13, 70, "Input",
   CellTags->"b:4.1",
   CellID->7185],
  Cell[49809, 1412, 1627, 46, 73, "Output",
   CellTags->"b:4.1",
   CellID->201282968],
  Cell[51451, 1461, 135, 4, 70, "MathCaption",
   CellTags->"b:4.1",
   CellID->24237],
  Cell[51589, 1467, 161, 5, 70, "Input",
   CellTags->"b:4.1",
   CellID->26443],
  Cell[51753, 1474, 787, 25, 70, "Input",
   CellTags->"b:4.1",
   CellID->21313],
  Cell[52543, 1501, 433, 15, 70, "Input",
   CellTags->"b:4.1",
   CellID->22501],
  Cell[53001, 1520, 330, 10, 70, "Input",
   CellTags->"b:4.1",
   CellID->8850],
  Cell[53334, 1532, 2105, 63, 103, "Output",
   CellTags->"b:4.1",
   CellID->4508852],
  Cell[55454, 1598, 148, 5, 70, "MathCaption",
   CellTags->"b:4.1",
   CellID->2111],
  Cell[55627, 1607, 274, 9, 70, "Input",
   CellTags->"b:4.1",
   CellID->23650],
  Cell[55904, 1618, 360, 12, 36, "Output",
   CellTags->"b:4.1",
   CellID->94483441],
  Cell[56279, 1633, 560, 19, 70, "MathCaption",
   CellTags->"b:4.1",
   CellID->11192],
  Cell[56864, 1656, 464, 16, 28, "Input",
   CellTags->"b:4.1",
   CellID->1454],
  Cell[57331, 1674, 9003, 152, 246, "Output",
   Evaluatable->False,
   CellTags->"b:4.1",
   CellID->6772032],
  Cell[66371, 1831, 561, 18, 28, "Input",
   CellTags->"b:4.1",
   CellID->681],
  Cell[66935, 1851, 5487, 95, 270, "Output",
   Evaluatable->False,
   CellTags->"b:4.1",
   CellID->51964927]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:47", 74939, 2013},
 {"b:4.1", 75039, 2017}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 82, 2, 70, "Title",
 CellTags->{"c:47", "b:4.1"},
 CellID->9762],
Cell[1365, 47, 132, 4, 70, "Text",
 CellTags->"b:4.1",
 CellID->5967],
Cell[1500, 53, 92, 2, 70, "MathCaption",
 CellTags->"b:4.1",
 CellID->24408],
Cell[1595, 57, 325, 11, 70, "Input",
 CellTags->"b:4.1",
 CellID->4415],
Cell[1923, 70, 297, 11, 70, "MathCaption",
 CellTags->"b:4.1",
 CellID->1908],
Cell[CellGroupData[{
Cell[2245, 85, 247, 7, 28, "Input",
 CellTags->"b:4.1",
 CellID->17223],
Cell[2495, 94, 815, 29, 61, "Output",
 CellTags->"b:4.1",
 CellID->46618248]
}, Open  ]],
Cell[3325, 126, 261, 10, 70, "MathCaption",
 CellTags->"b:4.1",
 CellID->26434],
Cell[CellGroupData[{
Cell[3611, 140, 347, 11, 28, "Input",
 CellTags->"b:4.1",
 CellID->5204],
Cell[3961, 153, 812, 28, 63, "Output",
 CellTags->"b:4.1",
 CellID->36699021]
}, Open  ]],
Cell[4788, 184, 154, 5, 70, "MathCaption",
 CellTags->"b:4.1",
 CellID->4319],
Cell[CellGroupData[{
Cell[4967, 193, 189, 6, 70, "Input",
 CellTags->"b:4.1",
 CellID->958],
Cell[5159, 201, 181, 6, 36, "Output",
 CellTags->"b:4.1",
 CellID->108940101]
}, Open  ]],
Cell[CellGroupData[{
Cell[5377, 212, 206, 7, 70, "Input",
 CellTags->"b:4.1",
 CellID->26806],
Cell[5586, 221, 178, 6, 36, "Output",
 CellTags->"b:4.1",
 CellID->298534757]
}, Open  ]],
Cell[5779, 230, 280, 11, 70, "MathCaption",
 CellTags->"b:4.1",
 CellID->18700],
Cell[CellGroupData[{
Cell[6084, 245, 348, 11, 70, "Input",
 CellTags->"b:4.1",
 CellID->11367],
Cell[6435, 258, 841, 29, 63, "Output",
 CellTags->"b:4.1",
 CellID->63888536]
}, Open  ]],
Cell[7291, 290, 678, 22, 70, "MathCaption",
 CellTags->"b:4.1",
 CellID->21787],
Cell[CellGroupData[{
Cell[7994, 316, 781, 25, 47, "Input",
 CellTags->"b:4.1",
 CellID->28532],
Cell[8778, 343, 12778, 214, 256, "Output",
 Evaluatable->False,
 CellTags->"b:4.1",
 CellID->242609016]
}, Open  ]],
Cell[21571, 560, 532, 20, 70, "MathCaption",
 CellTags->"b:4.1",
 CellID->30974],
Cell[22106, 582, 423, 14, 70, "Input",
 CellTags->"b:4.1",
 CellID->3447],
Cell[CellGroupData[{
Cell[22554, 600, 226, 7, 70, "Input",
 CellTags->"b:4.1",
 CellID->5021],
Cell[22783, 609, 695, 23, 39, "Output",
 CellTags->"b:4.1",
 CellID->795622561]
}, Open  ]],
Cell[CellGroupData[{
Cell[23515, 637, 461, 14, 70, "Input",
 CellTags->"b:4.1",
 CellID->26222],
Cell[23979, 653, 631, 22, 39, "Output",
 CellTags->"b:4.1",
 CellID->910248565]
}, Open  ]],
Cell[24625, 678, 150, 5, 70, "MathCaption",
 CellTags->"b:4.1",
 CellID->2376],
Cell[CellGroupData[{
Cell[24800, 687, 231, 7, 70, "Input",
 CellTags->"b:4.1",
 CellID->28583],
Cell[25034, 696, 181, 6, 36, "Output",
 CellTags->"b:4.1",
 CellID->21474770]
}, Open  ]],
Cell[CellGroupData[{
Cell[25252, 707, 207, 7, 70, "Input",
 CellTags->"b:4.1",
 CellID->12723],
Cell[25462, 716, 177, 6, 36, "Output",
 CellTags->"b:4.1",
 CellID->5317203]
}, Open  ]],
Cell[CellGroupData[{
Cell[25676, 727, 226, 8, 70, "Input",
 CellTags->"b:4.1",
 CellID->22018],
Cell[25905, 737, 179, 6, 36, "Output",
 CellTags->"b:4.1",
 CellID->111268472]
}, Open  ]],
Cell[26099, 746, 89, 2, 70, "MathCaption",
 CellTags->"b:4.1",
 CellID->9220],
Cell[CellGroupData[{
Cell[26213, 752, 324, 11, 28, "Input",
 CellTags->"b:4.1",
 CellID->31111],
Cell[26540, 765, 4792, 83, 244, "Output",
 Evaluatable->False,
 CellTags->"b:4.1",
 CellID->457677084]
}, Open  ]],
Cell[31347, 851, 334, 12, 70, "MathCaption",
 CellTags->"b:4.1",
 CellID->23856],
Cell[CellGroupData[{
Cell[31706, 867, 462, 14, 70, "Input",
 CellTags->"b:4.1",
 CellID->19490],
Cell[32171, 883, 731, 24, 39, "Output",
 CellTags->"b:4.1",
 CellID->515409851]
}, Open  ]],
Cell[32917, 910, 768, 24, 70, "MathCaption",
 CellTags->"b:4.1",
 CellID->4324],
Cell[CellGroupData[{
Cell[33710, 938, 1341, 35, 83, "Input",
 CellTags->"b:4.1",
 CellID->6486],
Cell[35054, 975, 4670, 81, 184, "Output",
 Evaluatable->False,
 CellTags->"b:4.1",
 CellID->551322452]
}, Open  ]],
Cell[39739, 1059, 131, 4, 70, "MathCaption",
 CellTags->"b:4.1",
 CellID->15969],
Cell[39873, 1065, 328, 11, 70, "Input",
 CellTags->"b:4.1",
 CellID->11643],
Cell[CellGroupData[{
Cell[40226, 1080, 228, 7, 70, "Input",
 CellTags->"b:4.1",
 CellID->7534],
Cell[40457, 1089, 892, 29, 51, "Output",
 CellTags->"b:4.1",
 CellID->543402448]
}, Open  ]],
Cell[CellGroupData[{
Cell[41386, 1123, 406, 13, 70, "Input",
 CellTags->"b:4.1",
 CellID->22668],
Cell[41795, 1138, 1360, 39, 73, "Output",
 CellTags->"b:4.1",
 CellID->188591108]
}, Open  ]],
Cell[43170, 1180, 262, 6, 70, "Text",
 CellTags->"b:4.1",
 CellID->21991],
Cell[43435, 1188, 764, 24, 70, "MathCaption",
 CellTags->"b:4.1",
 CellID->32196],
Cell[CellGroupData[{
Cell[44224, 1216, 380, 12, 70, "Input",
 CellTags->"b:4.1",
 CellID->7783],
Cell[44607, 1230, 487, 10, 70, "Message",
 CellTags->"b:4.1",
 CellID->665656],
Cell[45097, 1242, 195, 7, 36, "Output",
 CellTags->"b:4.1",
 CellID->51367051]
}, Open  ]],
Cell[45307, 1252, 185, 5, 70, "Text",
 CellTags->"b:4.1",
 CellID->29426],
Cell[45495, 1259, 155, 5, 70, "MathCaption",
 CellTags->"b:4.1",
 CellID->15871],
Cell[45653, 1266, 437, 14, 70, "Input",
 CellTags->"b:4.1",
 CellID->10697],
Cell[CellGroupData[{
Cell[46115, 1284, 667, 21, 70, "Input",
 CellTags->"b:4.1",
 CellID->17612],
Cell[46785, 1307, 1313, 39, 73, "Output",
 CellTags->"b:4.1",
 CellID->151281219]
}, Open  ]],
Cell[48113, 1349, 113, 2, 70, "MathCaption",
 CellTags->"b:4.1",
 CellID->11027],
Cell[CellGroupData[{
Cell[48251, 1355, 451, 15, 70, "Input",
 CellTags->"b:4.1",
 CellID->11408],
Cell[48705, 1372, 302, 10, 36, "Output",
 CellTags->"b:4.1",
 CellID->479111200]
}, Open  ]],
Cell[49022, 1385, 364, 8, 70, "MathCaption",
 CellTags->"b:4.1",
 CellID->9508],
Cell[CellGroupData[{
Cell[49411, 1397, 395, 13, 70, "Input",
 CellTags->"b:4.1",
 CellID->7185],
Cell[49809, 1412, 1627, 46, 73, "Output",
 CellTags->"b:4.1",
 CellID->201282968]
}, Open  ]],
Cell[51451, 1461, 135, 4, 70, "MathCaption",
 CellTags->"b:4.1",
 CellID->24237],
Cell[51589, 1467, 161, 5, 70, "Input",
 CellTags->"b:4.1",
 CellID->26443],
Cell[51753, 1474, 787, 25, 70, "Input",
 CellTags->"b:4.1",
 CellID->21313],
Cell[52543, 1501, 433, 15, 70, "Input",
 CellTags->"b:4.1",
 CellID->22501],
Cell[CellGroupData[{
Cell[53001, 1520, 330, 10, 70, "Input",
 CellTags->"b:4.1",
 CellID->8850],
Cell[53334, 1532, 2105, 63, 103, "Output",
 CellTags->"b:4.1",
 CellID->4508852]
}, Open  ]],
Cell[55454, 1598, 148, 5, 70, "MathCaption",
 CellTags->"b:4.1",
 CellID->2111],
Cell[CellGroupData[{
Cell[55627, 1607, 274, 9, 70, "Input",
 CellTags->"b:4.1",
 CellID->23650],
Cell[55904, 1618, 360, 12, 36, "Output",
 CellTags->"b:4.1",
 CellID->94483441]
}, Open  ]],
Cell[56279, 1633, 560, 19, 70, "MathCaption",
 CellTags->"b:4.1",
 CellID->11192],
Cell[CellGroupData[{
Cell[56864, 1656, 464, 16, 28, "Input",
 CellTags->"b:4.1",
 CellID->1454],
Cell[57331, 1674, 9003, 152, 246, "Output",
 Evaluatable->False,
 CellTags->"b:4.1",
 CellID->6772032]
}, Open  ]],
Cell[CellGroupData[{
Cell[66371, 1831, 561, 18, 28, "Input",
 CellTags->"b:4.1",
 CellID->681],
Cell[66935, 1851, 5487, 95, 270, "Output",
 Evaluatable->False,
 CellTags->"b:4.1",
 CellID->51964927]
}, Open  ]],
Cell[CellGroupData[{
Cell[72459, 1951, 72, 1, 70, "RelatedTutorialsSection",
 CellID->237223511],
Cell[72534, 1954, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[72738, 1961, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

