(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12281,        409]
NotebookOptionsPosition[      7024,        255]
NotebookOutlinePosition[     11099,        365]
CellTagsIndexPosition[     10946,        357]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Linear First-Order Equations", "Title",
 CellTags->{"LinearODE", "c:11b", "b:1.1.0.2b"},
 CellID->20267],

Cell[TextData[{
 "The following is a linear first-order ODE because both ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "x", "]"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}], TraditionalForm]], 
  "InlineMath"],
 " occur in it with power 1 and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}], TraditionalForm]], 
  "InlineMath"],
 " is the highest derivative. Note that the solution contains the imaginary \
error function ",
 Cell[BoxData[
  ButtonBox["Erfi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erfi"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:1.1.0.2b",
 CellID->17713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], " ", "+", " ", 
     RowBox[{"x", "*", 
      RowBox[{"y", "[", "x", "]"}]}]}], " ", "\[Equal]", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"3", "x"}], "]"}]}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.0.2b",
 CellLabel->"In[207]:=",
 CellID->19793],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox["x", "2"], "2"]}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["9", "2"]}], "-", 
        FractionBox[
         SuperscriptBox["x", "2"], "2"]}]], " ", 
      SqrtBox[
       FractionBox["\[Pi]", "2"]], " ", 
      RowBox[{"Erfi", "[", 
       FractionBox[
        RowBox[{"3", "+", "x"}], 
        SqrtBox["2"]], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{296, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.2b",
 CellLabel->"Out[207]=",
 CellID->242663229]
}, Open  ]],

Cell[TextData[{
 "Here is the solution for a more general linear first-order ODE. The ",
 Cell[BoxData["K"], "InlineFormula"],
 " variables are used as dummy variables for integration. The ",
 Cell[BoxData[
  ButtonBox["Erfi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Erfi"]], "InlineFormula"],
 " term in the previous example comes from the integral in the second term of \
the general solution as follows."
}], "MathCaption",
 CellTags->{"k$_variables", "b:1.1.0.2b"},
 CellID->25472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], " ", "+", " ", 
      RowBox[{"y", "[", "x", "]"}]}], " ", "\[Equal]", " ", 
     RowBox[{"Q", "[", "x", "]"}]}], ",", " ", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:1.1.0.2b",
 CellLabel->"In[208]:=",
 CellID->20972],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "x"}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "x"}]], " ", 
      RowBox[{
       SubsuperscriptBox["\[Integral]", "1", "x"], 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"K", "[", "1", "]"}]], " ", 
         RowBox[{"Q", "[", 
          RowBox[{"K", "[", "1", "]"}], "]"}]}], 
        RowBox[{"\[DifferentialD]", 
         RowBox[{"K", "[", "1", "]"}]}]}]}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{294, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.2b",
 CellLabel->"Out[208]=",
 CellID->590218013]
}, Open  ]],

Cell[TextData[{
 "A more traditional form of the solution can be obtained by replacing ",
 Cell[BoxData[
  RowBox[{"K", "[", "1", "]"}]], "InlineFormula"],
 " with a variable such as ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellTags->"b:1.1.0.2b",
 CellID->24901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"K", "[", "1", "]"}], "\[Rule]", "t"}], "}"}]}]], "Input",
 CellTags->"b:1.1.0.2b",
 CellLabel->"In[210]:=",
 CellID->28442],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "x"}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "x"}]], " ", 
      RowBox[{
       SubsuperscriptBox["\[Integral]", "1", "x"], 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "t"], " ", 
         RowBox[{"Q", "[", "t", "]"}]}], 
        RowBox[{"\[DifferentialD]", "t"}]}]}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{237, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.2b",
 CellLabel->"Out[210]=",
 CellID->470236646]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->100815401],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Linear First-Order Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveHomogeneousEquations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveInverseLinearEquations"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 36.5477128}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The following is a linear first-order ODE because both y[x] and y^,[x] \
occur in it with power 1 and y^,[x] is the highest derivative. Note that the \
solution contains the imaginary error function Erfi. Here is the solution for \
a more general linear first-order ODE. The K variables are used as dummy \
variables for integration. The Erfi term in the previous example comes from \
the integral in the second term of the general solution as follows. A more \
traditional form of the solution can be obtained by replacing K[1] with a \
variable such as t. ", "synonyms" -> {}, "title" -> 
    "Linear First-Order Equations", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveLinearFirstOrderEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "LinearODE"->{
  Cell[1280, 43, 110, 2, 70, "Title",
   CellTags->{"LinearODE", "c:11b", "b:1.1.0.2b"},
   CellID->20267]},
 "c:11b"->{
  Cell[1280, 43, 110, 2, 70, "Title",
   CellTags->{"LinearODE", "c:11b", "b:1.1.0.2b"},
   CellID->20267]},
 "b:1.1.0.2b"->{
  Cell[1280, 43, 110, 2, 70, "Title",
   CellTags->{"LinearODE", "c:11b", "b:1.1.0.2b"},
   CellID->20267],
  Cell[1393, 47, 803, 28, 70, "MathCaption",
   CellTags->"b:1.1.0.2b",
   CellID->17713],
  Cell[2221, 79, 432, 14, 28, "Input",
   CellTags->"b:1.1.0.2b",
   CellID->19793],
  Cell[2656, 95, 867, 30, 61, "Output",
   CellTags->"b:1.1.0.2b",
   CellID->242663229],
  Cell[3538, 128, 494, 12, 70, "MathCaption",
   CellTags->{"k$_variables", "b:1.1.0.2b"},
   CellID->25472],
  Cell[4057, 144, 415, 13, 28, "Input",
   CellTags->"b:1.1.0.2b",
   CellID->20972],
  Cell[4475, 159, 877, 28, 50, "Output",
   CellTags->"b:1.1.0.2b",
   CellID->590218013],
  Cell[5367, 190, 315, 10, 70, "MathCaption",
   CellTags->"b:1.1.0.2b",
   CellID->24901],
  Cell[5707, 204, 201, 7, 28, "Input",
   CellTags->"b:1.1.0.2b",
   CellID->28442],
  Cell[5911, 213, 770, 25, 50, "Output",
   CellTags->"b:1.1.0.2b",
   CellID->470236646]},
 "k$_variables"->{
  Cell[3538, 128, 494, 12, 70, "MathCaption",
   CellTags->{"k$_variables", "b:1.1.0.2b"},
   CellID->25472]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"LinearODE", 9616, 311},
 {"c:11b", 9737, 315},
 {"b:1.1.0.2b", 9863, 319},
 {"k$_variables", 10812, 350}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 110, 2, 70, "Title",
 CellTags->{"LinearODE", "c:11b", "b:1.1.0.2b"},
 CellID->20267],
Cell[1393, 47, 803, 28, 70, "MathCaption",
 CellTags->"b:1.1.0.2b",
 CellID->17713],
Cell[CellGroupData[{
Cell[2221, 79, 432, 14, 28, "Input",
 CellTags->"b:1.1.0.2b",
 CellID->19793],
Cell[2656, 95, 867, 30, 61, "Output",
 CellTags->"b:1.1.0.2b",
 CellID->242663229]
}, Open  ]],
Cell[3538, 128, 494, 12, 70, "MathCaption",
 CellTags->{"k$_variables", "b:1.1.0.2b"},
 CellID->25472],
Cell[CellGroupData[{
Cell[4057, 144, 415, 13, 28, "Input",
 CellTags->"b:1.1.0.2b",
 CellID->20972],
Cell[4475, 159, 877, 28, 50, "Output",
 CellTags->"b:1.1.0.2b",
 CellID->590218013]
}, Open  ]],
Cell[5367, 190, 315, 10, 70, "MathCaption",
 CellTags->"b:1.1.0.2b",
 CellID->24901],
Cell[CellGroupData[{
Cell[5707, 204, 201, 7, 28, "Input",
 CellTags->"b:1.1.0.2b",
 CellID->28442],
Cell[5911, 213, 770, 25, 50, "Output",
 CellTags->"b:1.1.0.2b",
 CellID->470236646]
}, Open  ]],
Cell[CellGroupData[{
Cell[6718, 243, 72, 1, 70, "RelatedTutorialsSection",
 CellID->100815401],
Cell[6793, 246, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[6997, 253, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

