(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26898,        898]
NotebookOptionsPosition[     19216,        657]
NotebookOutlinePosition[     24662,        813]
CellTagsIndexPosition[     24506,        805]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Linear Second-Order ODEs with Rational Coefficients", "Title",
 CellTags->{"HypergeometricODE", "c:23", "b:1.1.1.5"},
 CellID->8928],

Cell["\<\
The hypergeometric functions play a unifying role in mathematical analysis \
since many important functions, such as the Bessel functions and Legendre \
functions, are special cases of them. Each hypergeometric function is \
associated with a linear ODE having rational coefficients.\
\>", "Text",
 CellTags->"b:1.1.1.5",
 CellID->29492],

Cell[TextData[{
 "Here is the ODE for the ",
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFormula"],
 " function."
}], "MathCaption",
 CellTags->"b:1.1.1.5",
 CellID->12433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", "x"}], ")"}], "*", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", "b", "+", "1"}], ")"}], "*", "x"}], "-", "c"}], 
       ")"}], "*", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{"b", "*", "a", "*", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", " ", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.1.5",
 CellLabel->"In[1]:=",
 CellID->23840],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Hypergeometric2F1", "[", 
       RowBox[{"a", ",", "b", ",", "c", ",", "x"}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"1", "-", "c"}]], " ", 
      SuperscriptBox["x", 
       RowBox[{"1", "-", "c"}]], " ", 
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Hypergeometric2F1", "[", 
       RowBox[{
        RowBox[{"1", "+", "a", "-", "c"}], ",", 
        RowBox[{"1", "+", "b", "-", "c"}], ",", 
        RowBox[{"2", "-", "c"}], ",", "x"}], "]"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{443, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.5",
 CellLabel->"Out[1]=",
 CellID->70764176]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " can solve a large class of second-order linear ODEs by reducing them to \
the ODEs for hypergeometric functions. The reduction involves coordinate \
transformations of both the independent and dependent variables."
}], "Text",
 CellTags->"b:1.1.1.5",
 CellID->1735],

Cell[TextData[{
 "This equation is ",
 StyleBox["equivalent",
  FontSlant->"Italic"],
 " to the ODE for ",
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:1.1.1.5",
 CellID->19810],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"64", " ", 
       SuperscriptBox["x", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], "2"], " ", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "'"}], "[", "x", "]"}]}], "+", 
      RowBox[{"32", " ", "x", " ", 
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "x"}], "-", "1"}], ")"}], " ", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", "x"}], "-", "21"}], ")"}], " ", 
       RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", "y", ",", "x"}], 
   "]"}]}]], "Input",
 CellTags->{"DSolve", "b:1.1.1.5"},
 CellLabel->"In[2]:=",
 CellID->11599],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           FractionBox["1", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              RowBox[{"Log", "[", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "-", 
             RowBox[{"Log", "[", "x", "]"}]}], ")"}]}]], " ", 
         RowBox[{"C", "[", "1", "]"}], " ", 
         RowBox[{"Hypergeometric2F1", "[", 
          RowBox[{
           RowBox[{"-", 
            FractionBox["7", "8"]}], ",", 
           RowBox[{"-", 
            FractionBox["3", "8"]}], ",", 
           RowBox[{"-", 
            FractionBox["1", "4"]}], ",", "x"}], "]"}]}], 
        SuperscriptBox["x", 
         RowBox[{"1", "/", "8"}]]], "-", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"1", "/", "4"}]], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             RowBox[{"Log", "[", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "-", 
            RowBox[{"Log", "[", "x", "]"}]}], ")"}]}]], " ", 
        SuperscriptBox["x", 
         RowBox[{"9", "/", "8"}]], " ", 
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"Hypergeometric2F1", "[", 
         RowBox[{
          FractionBox["3", "8"], ",", 
          FractionBox["7", "8"], ",", 
          FractionBox["9", "4"], ",", "x"}], "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{531, 76},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"DSolve", "b:1.1.1.5"},
 CellLabel->"Out[2]=",
 CellID->419875196]
}, Open  ]],

Cell["This verifies the solution using numerical values.", "MathCaption",
 CellTags->"b:1.1.1.5",
 CellID->21892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"64", " ", 
        SuperscriptBox["x", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], "2"], " ", 
        RowBox[{
         RowBox[{
          RowBox[{"y", "'"}], "'"}], "[", "x", "]"}]}], "+", 
       RowBox[{"32", " ", "x", " ", 
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "x"}], "-", "1"}], ")"}], " ", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", "x"}], "-", "21"}], ")"}], " ", 
        RowBox[{"y", "[", "x", "]"}]}]}], "/.", " ", 
      RowBox[{"sol", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", " ", 
       RowBox[{"RandomComplex", "[", "]"}]}], "}"}]}], "//", "Simplify"}], "//",
    "Chop"}]}]], "Input",
 CellTags->"b:1.1.1.5",
 CellLabel->"In[3]:=",
 CellID->31982],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.5",
 CellLabel->"Out[3]=",
 CellID->270470275]
}, Open  ]],

Cell[TextData[{
 "Solutions to this equation are returned in terms of ",
 Cell[BoxData[
  ButtonBox["HypergeometricU",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricU"]], "InlineFormula"],
 " (the confluent hypergeometric function) and ",
 Cell[BoxData[
  ButtonBox["LaguerreL",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LaguerreL"]], "InlineFormula"],
 ". This example appears on (equation 2.16, page 403 of [",
 ButtonBox["K59",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveReferences#21388"],
 "]). "
}], "MathCaption",
 CellTags->"b:1.1.1.5",
 CellID->29352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\n", 
  RowBox[{
   RowBox[{"sol", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"PowerExpand", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", 
       RowBox[{
        RowBox[{"DSolve", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Derivative", "[", "2", "]"}], "[", "y", "]"}], "[", 
             "x", "]"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", 
                RowBox[{"x", "^", 
                 RowBox[{"(", 
                  RowBox[{"2", "*", "c"}], ")"}]}]}], "+", 
               RowBox[{"b", "*", 
                RowBox[{"x", "^", 
                 RowBox[{"(", 
                  RowBox[{"c", "-", "1"}], ")"}]}]}]}], ")"}], "*", 
             RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", "y", ",", 
          "x"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}]}], "\n"}]}]], "Input",
 CellTags->"b:1.1.1.5",
 CellLabel->"In[4]:=",
 CellID->11369],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   FractionBox["c", 
    RowBox[{"2", "+", 
     RowBox[{"2", " ", "c"}]}]]], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SqrtBox["a"], " ", 
      SuperscriptBox["x", 
       RowBox[{"1", "+", "c"}]]}], 
     SqrtBox[
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "c"}], ")"}], "2"]}]]]}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], " ", 
     RowBox[{"HypergeometricU", "[", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "c"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"b", " ", "c"}], "+", 
            RowBox[{
             SqrtBox["a"], " ", "c", " ", 
             SqrtBox[
              RowBox[{"-", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"1", "+", "c"}], ")"}], "2"]}]]}]}], ")"}]}], 
         RowBox[{"2", " ", 
          SqrtBox["a"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", "c"}], ")"}], "2"]}], ")"}], 
           RowBox[{"3", "/", "2"}]]}]]}], ",", 
       FractionBox["c", 
        RowBox[{"1", "+", "c"}]], ",", 
       FractionBox[
        RowBox[{"2", " ", 
         SqrtBox["a"], " ", 
         SuperscriptBox["x", 
          RowBox[{"1", "+", "c"}]]}], 
        SqrtBox[
         RowBox[{"-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "c"}], ")"}], "2"]}]]]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"C", "[", "2", "]"}], " ", 
     RowBox[{"LaguerreL", "[", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "c"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "b"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "c"}], ")"}]}], "-", 
            RowBox[{
             SqrtBox["a"], " ", "c", " ", 
             SqrtBox[
              RowBox[{"-", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"1", "+", "c"}], ")"}], "2"]}]]}]}], ")"}]}], 
         RowBox[{"2", " ", 
          SqrtBox["a"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", "c"}], ")"}], "2"]}], ")"}], 
           RowBox[{"3", "/", "2"}]]}]]}], ",", 
       RowBox[{"-", 
        FractionBox["1", 
         RowBox[{"1", "+", "c"}]]}], ",", 
       FractionBox[
        RowBox[{"2", " ", 
         SqrtBox["a"], " ", 
         SuperscriptBox["x", 
          RowBox[{"1", "+", "c"}]]}], 
        SqrtBox[
         RowBox[{"-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "c"}], ")"}], "2"]}]]]}], "]"}]}]}], 
   ")"}]}]], "Output",
 ImageSize->{536, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.5",
 CellLabel->"Out[4]=",
 CellID->182722387]
}, Open  ]],

Cell[TextData[{
 "The ODEs for special functions have been studied since the eighteenth \
century. During the last thirty years, powerful algorithms have been \
developed for systematically solving ODEs with rational coefficients. An \
important algorithm of this type is ",
 StyleBox["Kovacic\[CloseCurlyQuote]s algorithm",
  FontSlant->"Italic"],
 ", a decision procedure that either generates a solution for the given ODE \
in terms of Liouvillian functions or proves that the given ODE does not have \
a Liouvillian solution."
}], "Text",
 CellTags->"b:1.1.1.5",
 CellID->21794],

Cell["\<\
This equation is solved using Kovacic\[CloseCurlyQuote]s algorithm.\
\>", "MathCaption",
 CellTags->"b:1.1.1.5",
 CellID->6608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "*", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], " ", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"10", 
         RowBox[{"x", "^", "3"}]}], "-", "1"}], ")"}], "*", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], " ", "+", 
     RowBox[{"5", 
      RowBox[{"x", "^", "2"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", 
         RowBox[{"x", "^", "3"}]}], "+", "1"}], ")"}], "*", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.1.5",
 CellLabel->"In[5]:=",
 CellID->9252],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"5", " ", 
          SuperscriptBox["x", "3"]}], "3"]}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"5", " ", 
          SuperscriptBox["x", "3"]}], "3"]}]], " ", 
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"C", "[", "2", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{247, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.5",
 CellLabel->"Out[5]=",
 CellID->71981571]
}, Open  ]],

Cell[TextData[{
 "The solution returned from Kovacic\[CloseCurlyQuote]s algorithm may \
occasionally include functions such as ",
 Cell[BoxData[
  ButtonBox["ExpIntegralEi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralEi"]], "InlineFormula"],
 " or an unevaluated integral of elementary functions because, while it is \
easy to find a second solution for a second-order linear ODE once one \
solution is known, the integral involved in finding the second solution may \
be hard to evaluate explicitly. "
}], "Text",
 CellTags->"b:1.1.1.5",
 CellID->17432],

Cell[TextData[{
 "The solution to this equation is obtained using Kovacic\[CloseCurlyQuote]s \
algorithm. It includes ",
 Cell[BoxData[
  ButtonBox["ExpIntegralEi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralEi"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:1.1.1.5",
 CellID->9535],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"4", "x", "*", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], " ", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"7", "x"}], "+", "12"}], ")"}], "*", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], " ", "+", 
     RowBox[{"21", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.1.5",
 CellLabel->"In[6]:=",
 CellID->7208],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "7"}], " ", "x"}], "/", "4"}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "7"}], " ", "x"}], "/", "4"}]], " ", 
       RowBox[{"C", "[", "2", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"7", " ", "x"}], "/", "4"}]]}], "+", 
         RowBox[{"28", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"7", " ", "x"}], "/", "4"}]], " ", "x"}], "-", 
         RowBox[{"49", " ", 
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"ExpIntegralEi", "[", 
           FractionBox[
            RowBox[{"7", " ", "x"}], "4"], "]"}]}]}], ")"}]}], 
      RowBox[{"32", " ", 
       SuperscriptBox["x", "2"]}]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{523, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.1.5",
 CellLabel->"Out[6]=",
 CellID->86029737]
}, Open  ]],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Linear Second-Order ODEs with Rational Coefficients - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveLinearSecondOrderSpecialFunctionODEs"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/\
DSolveLinearSecondOrderODEsWithNonRationalCoefficients"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 40.2040564}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The hypergeometric functions play a unifying role in mathematical \
analysis since many important functions, such as the Bessel functions and \
Legendre functions, are special cases of them. Each hypergeometric function \
is associated with a linear ODE having rational coefficients. Here is the ODE \
for the Hypergeometric2F1 function. DSolve can solve a large class of \
second-order linear ODEs by reducing them to the ODEs for hypergeometric \
functions. The reduction involves coordinate transformations of both the \
independent and dependent variables.", "synonyms" -> {}, "title" -> 
    "Linear Second-Order ODEs with Rational Coefficients", "type" -> 
    "Tutorial", "uri" -> 
    "tutorial/DSolveLinearSecondOrderODEsWithRationalCoefficients"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "HypergeometricODE"->{
  Cell[1280, 43, 138, 2, 70, "Title",
   CellTags->{"HypergeometricODE", "c:23", "b:1.1.1.5"},
   CellID->8928]},
 "c:23"->{
  Cell[1280, 43, 138, 2, 70, "Title",
   CellTags->{"HypergeometricODE", "c:23", "b:1.1.1.5"},
   CellID->8928]},
 "b:1.1.1.5"->{
  Cell[1280, 43, 138, 2, 70, "Title",
   CellTags->{"HypergeometricODE", "c:23", "b:1.1.1.5"},
   CellID->8928],
  Cell[1421, 47, 347, 7, 70, "Text",
   CellTags->"b:1.1.1.5",
   CellID->29492],
  Cell[1771, 56, 254, 9, 70, "MathCaption",
   CellTags->"b:1.1.1.5",
   CellID->12433],
  Cell[2050, 69, 743, 25, 28, "Input",
   CellTags->"b:1.1.1.5",
   CellID->23840],
  Cell[2796, 96, 914, 29, 58, "Output",
   CellTags->"b:1.1.1.5",
   CellID->70764176],
  Cell[3725, 128, 399, 10, 70, "Text",
   CellTags->"b:1.1.1.5",
   CellID->1735],
  Cell[4127, 140, 307, 12, 70, "MathCaption",
   CellTags->"b:1.1.1.5",
   CellID->19810],
  Cell[4459, 156, 908, 30, 30, "Input",
   CellTags->{"DSolve", "b:1.1.1.5"},
   CellID->11599],
  Cell[5370, 188, 2042, 62, 97, "Output",
   CellTags->{"DSolve", "b:1.1.1.5"},
   CellID->419875196],
  Cell[7427, 253, 113, 2, 70, "MathCaption",
   CellTags->"b:1.1.1.5",
   CellID->21892],
  Cell[7565, 259, 1101, 36, 70, "Input",
   CellTags->"b:1.1.1.5",
   CellID->31982],
  Cell[8669, 297, 182, 6, 36, "Output",
   CellTags->"b:1.1.1.5",
   CellID->270470275],
  Cell[8866, 306, 599, 18, 70, "MathCaption",
   CellTags->"b:1.1.1.5",
   CellID->29352],
  Cell[9490, 328, 1089, 33, 70, "Input",
   CellTags->"b:1.1.1.5",
   CellID->11369],
  Cell[10582, 363, 3272, 110, 198, "Output",
   CellTags->"b:1.1.1.5",
   CellID->182722387],
  Cell[13869, 476, 582, 12, 70, "Text",
   CellTags->"b:1.1.1.5",
   CellID->21794],
  Cell[14454, 490, 137, 4, 70, "MathCaption",
   CellTags->"b:1.1.1.5",
   CellID->6608],
  Cell[14616, 498, 741, 25, 70, "Input",
   CellTags->"b:1.1.1.5",
   CellID->9252],
  Cell[15360, 525, 809, 27, 55, "Output",
   CellTags->"b:1.1.1.5",
   CellID->71981571],
  Cell[16184, 555, 571, 13, 70, "Text",
   CellTags->"b:1.1.1.5",
   CellID->17432],
  Cell[16758, 570, 312, 10, 70, "MathCaption",
   CellTags->"b:1.1.1.5",
   CellID->9535],
  Cell[17095, 584, 566, 19, 70, "Input",
   CellTags->"b:1.1.1.5",
   CellID->7208],
  Cell[17664, 605, 1318, 41, 61, "Output",
   CellTags->"b:1.1.1.5",
   CellID->86029737]},
 "DSolve"->{
  Cell[4459, 156, 908, 30, 30, "Input",
   CellTags->{"DSolve", "b:1.1.1.5"},
   CellID->11599],
  Cell[5370, 188, 2042, 62, 97, "Output",
   CellTags->{"DSolve", "b:1.1.1.5"},
   CellID->419875196]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"HypergeometricODE", 21945, 717},
 {"c:23", 22070, 721},
 {"b:1.1.1.5", 22200, 725},
 {"DSolve", 24282, 795}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 138, 2, 70, "Title",
 CellTags->{"HypergeometricODE", "c:23", "b:1.1.1.5"},
 CellID->8928],
Cell[1421, 47, 347, 7, 70, "Text",
 CellTags->"b:1.1.1.5",
 CellID->29492],
Cell[1771, 56, 254, 9, 70, "MathCaption",
 CellTags->"b:1.1.1.5",
 CellID->12433],
Cell[CellGroupData[{
Cell[2050, 69, 743, 25, 28, "Input",
 CellTags->"b:1.1.1.5",
 CellID->23840],
Cell[2796, 96, 914, 29, 58, "Output",
 CellTags->"b:1.1.1.5",
 CellID->70764176]
}, Open  ]],
Cell[3725, 128, 399, 10, 70, "Text",
 CellTags->"b:1.1.1.5",
 CellID->1735],
Cell[4127, 140, 307, 12, 70, "MathCaption",
 CellTags->"b:1.1.1.5",
 CellID->19810],
Cell[CellGroupData[{
Cell[4459, 156, 908, 30, 30, "Input",
 CellTags->{"DSolve", "b:1.1.1.5"},
 CellID->11599],
Cell[5370, 188, 2042, 62, 97, "Output",
 CellTags->{"DSolve", "b:1.1.1.5"},
 CellID->419875196]
}, Open  ]],
Cell[7427, 253, 113, 2, 70, "MathCaption",
 CellTags->"b:1.1.1.5",
 CellID->21892],
Cell[CellGroupData[{
Cell[7565, 259, 1101, 36, 70, "Input",
 CellTags->"b:1.1.1.5",
 CellID->31982],
Cell[8669, 297, 182, 6, 36, "Output",
 CellTags->"b:1.1.1.5",
 CellID->270470275]
}, Open  ]],
Cell[8866, 306, 599, 18, 70, "MathCaption",
 CellTags->"b:1.1.1.5",
 CellID->29352],
Cell[CellGroupData[{
Cell[9490, 328, 1089, 33, 70, "Input",
 CellTags->"b:1.1.1.5",
 CellID->11369],
Cell[10582, 363, 3272, 110, 198, "Output",
 CellTags->"b:1.1.1.5",
 CellID->182722387]
}, Open  ]],
Cell[13869, 476, 582, 12, 70, "Text",
 CellTags->"b:1.1.1.5",
 CellID->21794],
Cell[14454, 490, 137, 4, 70, "MathCaption",
 CellTags->"b:1.1.1.5",
 CellID->6608],
Cell[CellGroupData[{
Cell[14616, 498, 741, 25, 70, "Input",
 CellTags->"b:1.1.1.5",
 CellID->9252],
Cell[15360, 525, 809, 27, 55, "Output",
 CellTags->"b:1.1.1.5",
 CellID->71981571]
}, Open  ]],
Cell[16184, 555, 571, 13, 70, "Text",
 CellTags->"b:1.1.1.5",
 CellID->17432],
Cell[16758, 570, 312, 10, 70, "MathCaption",
 CellTags->"b:1.1.1.5",
 CellID->9535],
Cell[CellGroupData[{
Cell[17095, 584, 566, 19, 70, "Input",
 CellTags->"b:1.1.1.5",
 CellID->7208],
Cell[17664, 605, 1318, 41, 61, "Output",
 CellTags->"b:1.1.1.5",
 CellID->86029737]
}, Open  ]],
Cell[18997, 649, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]],
Cell[19189, 655, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

