(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     75478,       2696]
NotebookOptionsPosition[     52646,       1887]
NotebookOutlinePosition[     65258,       2296]
CellTagsIndexPosition[     65128,       2289]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Nonlinear PDEs", "Title",
 CellTags->{"c:40", "b:2.1.1"},
 CellID->10396],

Cell[TextData[{
 "The general first-order nonlinear PDE for an unknown function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]]],
 " is given by"
}], "Text",
 CellTags->"b:2.1.1",
 CellID->15460],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"F", "(", 
    RowBox[{"u", ",", "p", ",", "q"}], ")"}], "\[LongEqual]", "0."}], 
  TraditionalForm]], "DisplayMath",
 CellTags->"b:2.1.1",
 CellID->20615],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  FormBox["F", TraditionalForm]], "InlineMath"],
 " is a function of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "=", 
    RowBox[{"u", "(", 
     RowBox[{"x", ",", "y"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "=", 
    FractionBox[
     RowBox[{"\[PartialD]", 
      RowBox[{"u", "(", 
       RowBox[{"x", ",", "y"}], ")"}]}], 
     RowBox[{"\[PartialD]", "x"}],
     MultilineFunction->None]}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "=", 
    FractionBox[
     RowBox[{"\[PartialD]", 
      RowBox[{"u", "(", 
       RowBox[{"x", ",", "y"}], ")"}]}], 
     RowBox[{"\[PartialD]", "y"}],
     MultilineFunction->None]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellTags->"b:2.1.1",
 CellID->10904],

Cell[TextData[{
 "The term \[OpenCurlyDoubleQuote]nonlinear\[CloseCurlyDoubleQuote] refers to \
the fact that ",
 Cell[BoxData[
  FormBox["F", TraditionalForm]], "InlineMath"],
 " is a nonlinear function of ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 ". For instance, the eikonal equation involves a quadratic expression in ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellTags->"b:2.1.1",
 CellID->2599],

Cell[TextData[{
 "The general solution to a first-order linear or quasi-linear PDE involves \
an arbitrary function. If the PDE is nonlinear, a very useful solution is \
given by the complete integral. This is a function of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["u", "TI"], "(", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    RowBox[{
     ButtonBox["C",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/C"], "[", "1", "]"}], ",", 
    RowBox[{
     ButtonBox["C",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/C"], "[", "2", "]"}]}], ")"}]], 
  "InlineFormula"],
 ", where ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 StyleBox[" ", "TR"],
 "and",
 StyleBox[" ", "TR"],
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "2", "]"}]], "InlineFormula"],
 StyleBox[" ", "TR"],
 "are independent parameters and ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " satisfies the PDE for all values of",
 StyleBox[" ", "TR"],
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     ButtonBox["C",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/C"], "[", "1", "]"}], ",", 
    RowBox[{
     ButtonBox["C",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/C"], "[", "2", "]"}]}], ")"}]], 
  "InlineFormula"],
 StyleBox[" ", "TR"],
 "in an open subset of the plane",
 StyleBox[".", "TR"],
 " The complete integral can be used to find a general solution for the PDE \
as well as to solve initial value problems for it. "
}], "Text",
 CellTags->"b:2.1.1",
 CellID->20136],

Cell["Here is a simple nonlinear PDE. ", "MathCaption",
 CellTags->"b:2.1.1",
 CellID->4680],

Cell[BoxData[
 RowBox[{"z", ":=", 
  RowBox[{"u", "[", 
   RowBox[{"x", ",", "y"}], "]"}]}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[1]:=",
 CellID->9198],

Cell[BoxData[
 RowBox[{"p", ":=", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[2]:=",
 CellID->27032],

Cell[BoxData[
 RowBox[{"q", ":=", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[3]:=",
 CellID->14387],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", " ", "=", 
   RowBox[{
    RowBox[{"p", "*", "q"}], "\[Equal]", "1"}]}], ";"}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[4]:=",
 CellID->32584],

Cell[TextData[{
 "The complete integral depends on the parameters ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "2", "]"}]], "InlineFormula"],
 ". Since ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " returns a general solution for linear and quasi-linear PDEs, a warning \
message appears before a complete integral is returned."
}], "MathCaption",
 CellTags->"b:2.1.1",
 CellID->7240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", " ", "u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[5]:=",
 CellID->3517],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"nlpde\"\>"}], ":", 
  " ", "\<\"Solution requested to nonlinear partial differential equation. \
Trying to build a special solution. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/DSolve/nlpde\\\", ButtonNote -> \
\\\"DSolve::nlpde\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:2.1.1",
 CellLabel->"During evaluation of In[5]:=",
 CellID->106763084],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "+", 
       FractionBox["x", 
        RowBox[{"C", "[", "2", "]"}]], "+", 
       RowBox[{"y", " ", 
        RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{299, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[5]=",
 CellID->443567229]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
 CellTags->"b:2.1.1",
 CellID->241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqn", "/.", "sol"}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[6]:=",
 CellID->18882],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[6]=",
 CellID->581909309]
}, Open  ]],

Cell[TextData[{
 "If the values of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "2", "]"}]], "InlineFormula"],
 StyleBox[" are fixed,", "TR"],
 " the previous solution represents a plane in three dimensions. Thus, the \
complete integral for this PDE is a two-parameter family of planes, each of \
which is a solution surface for the equation."
}], "Text",
 CellTags->"b:2.1.1",
 CellID->3523],

Cell[TextData[{
 "Next,",
 " ",
 "the envelope of a one-parameter family of surfaces is a surface that \
touches each member of the family. If the complete integral is restricted to \
a one-parameter family of planes, for example by setting ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["C",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/C"], "[", "2", "]"}], "=", 
   RowBox[{"5", 
    RowBox[{
     ButtonBox["C",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/C"], "[", "1", "]"}]}]}]], "InlineFormula"],
 ", the envelope of this family is also a solution to the PDE called a \
general integral. "
}], "Text",
 CellID->203256104],

Cell[TextData[{
 "This finds the envelope of the one-parameter family given by setting ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["C",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/C"], "[", "2", "]"}], "=", 
   RowBox[{"5", 
    RowBox[{
     ButtonBox["C",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/C"], "[", "1", "]"}]}]}]], "InlineFormula"],
 " in the complete integral for the preceding PDE ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"p", "*", "q"}], "==", "1"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:2.1.1",
 CellID->7296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"oneparametersol", " ", "=", " ", 
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "y"}], "]"}], "/.", 
      RowBox[{"sol", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], "\[Rule]", " ", 
      RowBox[{"5", "*", 
       RowBox[{"C", "[", "1", "]"}]}]}]}], ")"}]}]}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[7]:=",
 CellID->9916],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", 
  RowBox[{
   FractionBox["x", 
    RowBox[{"5", " ", 
     RowBox[{"C", "[", "1", "]"}]}]], "+", 
   RowBox[{"C", "[", "1", "]"}], "+", 
   RowBox[{"5", " ", "y", " ", 
    RowBox[{"C", "[", "1", "]"}]}]}]}]], "Output",
 ImageSize->{211, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[7]=",
 CellID->96382683]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"oneparameterenvelope", " ", "=", " ", 
  RowBox[{"Eliminate", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"oneparametersol", ",", " ", 
      RowBox[{"D", "[", 
       RowBox[{"oneparametersol", ",", " ", 
        RowBox[{"C", "[", "1", "]"}]}], "]"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"C", "[", "1", "]"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[8]:=",
 CellID->10178],

Cell[BoxData[
 RowBox[{
  RowBox[{"5", " ", 
   SuperscriptBox[
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], "2"]}], "\[Equal]", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"4", "+", 
     RowBox[{"20", " ", "y"}]}], ")"}]}]}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[8]=",
 CellID->3850533]
}, Open  ]],

Cell["\<\
This verifies that the envelope surface is a solution to the PDE.\
\>", "MathCaption",
 CellTags->"b:2.1.1",
 CellID->25058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p1", "=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], "/.", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"oneparameterenvelope", ",", " ", "x"}], "]"}], ",", " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[9]:=",
 CellID->27577],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"5", " ", "y"}]}], ")"}]}], 
  RowBox[{"5", " ", 
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}]]], "Output",
 ImageSize->{69, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[9]=",
 CellID->126629157]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"q1", "=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}], "/.", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"oneparameterenvelope", ",", " ", "y"}], "]"}], ",", " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[10]:=",
 CellID->14007],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "x"}], 
  RowBox[{"u", "[", 
   RowBox[{"x", ",", "y"}], "]"}]]], "Output",
 ImageSize->{55, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[10]=",
 CellID->17145273]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"p1", "*", "q1"}], ",", " ", 
   RowBox[{"{", "oneparameterenvelope", "}"}]}], "]"}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[11]:=",
 CellID->24081],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[11]=",
 CellID->107208435]
}, Open  ]],

Cell["\<\
Like nonlinear ODEs, some nonlinear PDEs also have a singular solution (or \
singular integral) that is obtained by constructing the envelope of the \
entire two-parameter family of surfaces represented by the complete integral.\
\
\>", "Text",
 CellTags->"b:2.1.1",
 CellID->2678],

Cell[TextData[{
 "Here is an example of such a construction, (equation 6.4.13, page 429 of \
[",
 ButtonBox["K00",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveReferences#7355"],
 "])."
}], "MathCaption",
 CellTags->"b:2.1.1",
 CellID->24676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"4", "z"}], "+", 
      RowBox[{"p", "^", "2"}], "+", 
      RowBox[{"q", "^", "2"}]}], "\[Equal]", "4"}], ",", " ", "u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[12]:=",
 CellID->27753],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"nlpde\"\>"}], ":", 
  " ", "\<\"Solution requested to nonlinear partial differential equation. \
Trying to build a special solution. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/DSolve/nlpde\\\", ButtonNote -> \
\\\"DSolve::nlpde\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:2.1.1",
 CellLabel->"During evaluation of In[12]:=",
 CellID->52889925],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      FractionBox[
       RowBox[{"1", "-", 
        SuperscriptBox["y", "2"], "-", 
        RowBox[{"2", " ", "x", " ", "y", " ", 
         RowBox[{"C", "[", "1", "]"}]}], "+", 
        SuperscriptBox[
         RowBox[{"C", "[", "1", "]"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox[
          RowBox[{"C", "[", "1", "]"}], "2"]}], "-", 
        RowBox[{"2", " ", "y", " ", 
         RowBox[{"C", "[", "2", "]"}]}], "-", 
        RowBox[{"2", " ", "x", " ", 
         RowBox[{"C", "[", "1", "]"}], " ", 
         RowBox[{"C", "[", "2", "]"}]}], "-", 
        SuperscriptBox[
         RowBox[{"C", "[", "2", "]"}], "2"]}], 
       RowBox[{"1", "+", 
        SuperscriptBox[
         RowBox[{"C", "[", "1", "]"}], "2"]}]]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{589, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[12]=",
 CellID->179200]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"twoparameterfamily", " ", "=", " ", 
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "/.", 
     RowBox[{"sol", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[13]:=",
 CellID->15565],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", 
  FractionBox[
   RowBox[{"1", "-", 
    SuperscriptBox["y", "2"], "-", 
    RowBox[{"2", " ", "x", " ", "y", " ", 
     RowBox[{"C", "[", "1", "]"}]}], "+", 
    SuperscriptBox[
     RowBox[{"C", "[", "1", "]"}], "2"], "-", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     SuperscriptBox[
      RowBox[{"C", "[", "1", "]"}], "2"]}], "-", 
    RowBox[{"2", " ", "y", " ", 
     RowBox[{"C", "[", "2", "]"}]}], "-", 
    RowBox[{"2", " ", "x", " ", 
     RowBox[{"C", "[", "1", "]"}], " ", 
     RowBox[{"C", "[", "2", "]"}]}], "-", 
    SuperscriptBox[
     RowBox[{"C", "[", "2", "]"}], "2"]}], 
   RowBox[{"1", "+", 
    SuperscriptBox[
     RowBox[{"C", "[", "1", "]"}], "2"]}]]}]], "Output",
 ImageSize->{481, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[13]=",
 CellID->348825550]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"envelopeoftwoparameterfamily", " ", "=", " ", 
  RowBox[{"Eliminate", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"twoparameterfamily", ",", " ", 
      RowBox[{"D", "[", 
       RowBox[{"twoparameterfamily", ",", " ", 
        RowBox[{"C", "[", "1", "]"}]}], "]"}], ",", " ", 
      RowBox[{"D", "[", 
       RowBox[{"twoparameterfamily", ",", " ", 
        RowBox[{"C", "[", "2", "]"}]}], "]"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], ",", 
      RowBox[{"C", "[", "2", "]"}]}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[14]:=",
 CellID->13608],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", "1"}]], "Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[14]=",
 CellID->195625603]
}, Open  ]],

Cell[TextData[{
 "Thus, the singular integral for this PDE is a plane parallel to the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 "-",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " plane."
}], "Text",
 CellTags->"b:2.1.1",
 CellID->11243],

Cell["\<\
To summarize, the complete integral for a nonlinear PDE includes a rich \
variety of solutions.\
\>", "Text",
 CellTags->"b:2.1.1",
 CellID->29929],

Cell["\<\
Every member of the two-parameter family gives a particular solution to the \
PDE.\
\>", "BulletedText",
 CellTags->"b:2.1.1",
 CellID->7514],

Cell["\<\
The envelope of any one-parameter family is a solution called a general \
integral of the PDE.\
\>", "BulletedText",
 CellTags->"b:2.1.1",
 CellID->10168],

Cell["\<\
The envelope of the entire two-parameter family is a solution called the \
singular integral of the PDE.\
\>", "BulletedText",
 CellTags->"b:2.1.1",
 CellID->5055],

Cell[CellGroupData[{

Cell["\<\
The complete integral is not unique, but any other complete integral for the \
PDE can be obtained from it by the process of envelope formation.\
\>", "BulletedText",
 CellTags->"b:2.1.1",
 CellID->11191],

Cell["\<\
These remarkable properties account for the usefulness of the complete \
integral in geometrical optics, dynamics, and other areas of application. \
Following are various examples of nonlinear PDEs that show different kinds of \
complete integrals.\
\>", "Text",
 CellTags->"b:2.1.1",
 CellID->5973],

Cell[TextData[{
 "Here is the complete integral for the ",
 ButtonBox["eikonal equation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveIntroductionToPDEs#27918"],
 "."
}], "MathCaption",
 CellTags->{"EikonalEquation", "b:2.1.1"},
 CellID->8922],

Cell[BoxData[
 RowBox[{
  RowBox[{"Eikonal", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}], "^", "2"}]}], "==",
     "1"}]}], ";"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->698675620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"Eikonal", ",", " ", "u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[16]:=",
 CellID->5651],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"nlpde\"\>"}], ":", 
  " ", "\<\"Solution requested to nonlinear partial differential equation. \
Trying to build a special solution. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/DSolve/nlpde\\\", ButtonNote -> \
\\\"DSolve::nlpde\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:2.1.1",
 CellLabel->"During evaluation of In[16]:=",
 CellID->201881942],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "+", 
        RowBox[{"y", " ", 
         RowBox[{"C", "[", "2", "]"}]}], "-", 
        RowBox[{"x", " ", 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox[
            RowBox[{"C", "[", "2", "]"}], "2"]}]]}]}]}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"u", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "+", 
        RowBox[{"y", " ", 
         RowBox[{"C", "[", "2", "]"}]}], "+", 
        RowBox[{"x", " ", 
         SqrtBox[
          RowBox[{"1", "-", 
           SuperscriptBox[
            RowBox[{"C", "[", "2", "]"}], "2"]}]]}]}]}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{349, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[16]=",
 CellID->66721432]
}, Open  ]],

Cell[TextData[{
 "This complete integral is a two-parameter family of planes. This type of \
solution arises whenever the PDE depends explicitly only on ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 ", but not on ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", or ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ". For a fixed value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}], TraditionalForm]], "InlineMath"],
 ", it is a line in the plane at a distance of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 StyleBox[" ", "TR"],
 "units from the origin that makes an angle of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArcCos",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCos"], "[", 
   RowBox[{
    ButtonBox["C",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/C"], "[", "2", "]"}], "]"}]], "InlineFormula"],
 " with the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis. This is the familiar picture of wave-front propagation from \
geometrical optics."
}], "Text",
 CellTags->"b:2.1.1",
 CellID->16446],

Cell["This verifies the solution for the eikonal equation.", "MathCaption",
 CellTags->"b:2.1.1",
 CellID->31577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eikonal", "/.", "sol"}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[17]:=",
 CellID->26517],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[17]=",
 CellID->88012804]
}, Open  ]],

Cell[TextData[{
 "This is an example of a Clairaut equation (",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{
     RowBox[{"p", "x"}], "+", 
     RowBox[{"q", "y"}], "+", 
     RowBox[{"f", "(", 
      RowBox[{"p", ",", "q"}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 "). "
}], "MathCaption",
 CellTags->"b:2.1.1",
 CellID->29916],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clairaut", " ", "=", 
   RowBox[{"z", "\[Equal]", " ", 
    RowBox[{
     RowBox[{"x", "*", "p"}], "+", 
     RowBox[{"y", "*", "q"}], "+", " ", 
     RowBox[{"2", "p", "*", "q", "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "-", 
        RowBox[{"p", "^", "2"}]}], "]"}]}]}]}]}], ";"}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[18]:=",
 CellID->5874],

Cell["Once again, the complete integral is a family of planes.", "MathCaption",
 CellTags->"b:2.1.1",
 CellID->15791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"Clairaut", ",", " ", "u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[19]:=",
 CellID->15469],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"nlpde\"\>"}], ":", 
  " ", "\<\"Solution requested to nonlinear partial differential equation. \
Trying to build a special solution. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/DSolve/nlpde\\\", ButtonNote -> \
\\\"DSolve::nlpde\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:2.1.1",
 CellLabel->"During evaluation of In[19]:=",
 CellID->551755893],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       RowBox[{"x", " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{"y", " ", 
        RowBox[{"C", "[", "2", "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"C", "[", "1", "]"}], " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox[
           RowBox[{"C", "[", "1", "]"}], "2"]}]], " ", 
        RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{421, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[19]=",
 CellID->275678723]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
 CellTags->"b:2.1.1",
 CellID->30693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Clairaut", "/.", "sol"}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[20]:=",
 CellID->9091],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[20]=",
 CellID->149074497]
}, Open  ]],

Cell[TextData[{
 "In the following equation, the variables can be separated; that is, the PDE \
can be written in the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"x", ",", "p"}], ")"}], "\[LongEqual]", 
    RowBox[{"g", "(", 
     RowBox[{"y", ",", "q"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". Hence, the equation can be integrated easily."
}], "MathCaption",
 CellTags->"b:2.1.1",
 CellID->26949],

Cell[BoxData[
 RowBox[{
  RowBox[{"Separable", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"p", "^", "2"}], "+", 
     RowBox[{"a", "*", "q"}]}], "\[Equal]", 
    RowBox[{"x", "+", 
     RowBox[{"3", "y"}]}]}]}], ";"}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[21]:=",
 CellID->26857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{"Separable", ",", " ", "u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[22]:=",
 CellID->20640],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"nlpde\"\>"}], ":", 
  " ", "\<\"Solution requested to nonlinear partial differential equation. \
Trying to build a special solution. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/DSolve/nlpde\\\", ButtonNote -> \
\\\"DSolve::nlpde\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:2.1.1",
 CellLabel->"During evaluation of In[22]:=",
 CellID->211984604],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", 
       RowBox[{
        FractionBox[
         RowBox[{"3", " ", 
          SuperscriptBox["y", "2"]}], 
         RowBox[{"2", " ", "a"}]], "-", 
        RowBox[{
         FractionBox["2", "3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "-", 
            RowBox[{"C", "[", "1", "]"}]}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        FractionBox[
         RowBox[{"y", " ", 
          RowBox[{"C", "[", "1", "]"}]}], "a"], "+", 
        RowBox[{"C", "[", "2", "]"}]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", 
       RowBox[{
        FractionBox[
         RowBox[{"3", " ", 
          SuperscriptBox["y", "2"]}], 
         RowBox[{"2", " ", "a"}]], "+", 
        RowBox[{
         FractionBox["2", "3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "-", 
            RowBox[{"C", "[", "1", "]"}]}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        FractionBox[
         RowBox[{"y", " ", 
          RowBox[{"C", "[", "1", "]"}]}], "a"], "+", 
        RowBox[{"C", "[", "2", "]"}]}]}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{402, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[22]=",
 CellID->72243147]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
 CellTags->"b:2.1.1",
 CellID->8551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Separable", "/.", "sol"}], "//", "Simplify"}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[23]:=",
 CellID->9487],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[23]=",
 CellID->46345772]
}, Open  ]],

Cell[TextData[{
 "In this example (equation 6.49, page 202 of [",
 ButtonBox["K74",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveReferences#7355"],
 "]), the independent variables ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " are not explicitly present."
}], "MathCaption",
 CellTags->"b:2.1.1",
 CellID->28162],

Cell[BoxData[
 RowBox[{
  RowBox[{"MissingIndependentVariables", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "*", 
      RowBox[{"p", "^", "2"}]}], "+", 
     RowBox[{"b", "*", "p", "*", "q"}]}], "\[Equal]", 
    RowBox[{"c", "*", 
     RowBox[{"z", "^", "2"}]}]}]}], ";"}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[24]:=",
 CellID->16955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{"MissingIndependentVariables", ",", " ", "u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[25]:=",
 CellID->23183],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"nlpde\"\>"}], ":", 
  " ", "\<\"Solution requested to nonlinear partial differential equation. \
Trying to build a special solution. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/DSolve/nlpde\\\", ButtonNote -> \
\\\"DSolve::nlpde\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:2.1.1",
 CellLabel->"During evaluation of In[25]:=",
 CellID->130653092],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["c"], " ", "y"}], 
          SqrtBox[
           RowBox[{
            RowBox[{
             RowBox[{"-", "b"}], " ", 
             RowBox[{"C", "[", "1", "]"}]}], "-", 
            RowBox[{"a", " ", 
             SuperscriptBox[
              RowBox[{"C", "[", "1", "]"}], "2"]}]}]]]}], "-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["c"], " ", "x", " ", 
          RowBox[{"C", "[", "1", "]"}]}], 
         SqrtBox[
          RowBox[{
           RowBox[{
            RowBox[{"-", "b"}], " ", 
            RowBox[{"C", "[", "1", "]"}]}], "-", 
           RowBox[{"a", " ", 
            SuperscriptBox[
             RowBox[{"C", "[", "1", "]"}], "2"]}]}]]], "-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["c"], " ", 
          RowBox[{"C", "[", "2", "]"}]}], 
         SqrtBox[
          RowBox[{
           RowBox[{
            RowBox[{"-", "b"}], " ", 
            RowBox[{"C", "[", "1", "]"}]}], "-", 
           RowBox[{"a", " ", 
            SuperscriptBox[
             RowBox[{"C", "[", "1", "]"}], "2"]}]}]]]}]]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{462, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[25]=",
 CellID->226342698]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
 CellTags->"b:2.1.1",
 CellID->16097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MissingIndependentVariables", "/.", "sol"}], "//", 
  "Simplify"}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[26]:=",
 CellID->3065],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[26]=",
 CellID->313066424]
}, Open  ]],

Cell[TextData[{
 "Often a coordinate transformation can be used to cast a given PDE into one \
of the previous types. The expression for the complete integral will then \
have the same form as for the standard types. Here are some examples of \
nonlinear PDEs for which ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " applies a coordinate transformation to find the complete integral."
}], "Text",
 CellTags->"b:2.1.1",
 CellID->2513],

Cell[TextData[{
 "This PDE (equation 6.47, page 201 of [",
 ButtonBox["K74",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveReferences#7355"],
 "]) can be reduced to the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"p", ",", "q"}], ")"}], "\[LongEqual]", "0"}], TraditionalForm]],
   "InlineMath"],
 " using the transformation ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", "=", 
    RowBox[{"log", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Y", "=", 
    RowBox[{"log", "(", "y", ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellTags->"b:2.1.1",
 CellID->9261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", "y", "*", "p", "*", "q"}], "\[Equal]", "1"}], ",", " ", 
   
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[27]:=",
 CellID->12578],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"nlpde\"\>"}], ":", 
  " ", "\<\"Solution requested to nonlinear partial differential equation. \
Trying to build a special solution. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/DSolve/nlpde\\\", ButtonNote -> \
\\\"DSolve::nlpde\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:2.1.1",
 CellLabel->"During evaluation of In[27]:=",
 CellID->322503206],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"C", "[", "2", "]"}], "+", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Log", "[", "x", "]"}]}], "+", 
     FractionBox[
      RowBox[{"Log", "[", "y", "]"}], 
      RowBox[{"C", "[", "1", "]"}]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{267, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[27]=",
 CellID->39058936]
}, Open  ]],

Cell[TextData[{
 "This PDE (equation 6.93, page 213 of [",
 ButtonBox["K74",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveReferences#7355"],
 "]) can be solved easily in a polar coordinate system, in which the \
variables are separable."
}], "MathCaption",
 CellTags->"b:2.1.1",
 CellID->14140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "*", "p"}], "-", 
        RowBox[{"x", "*", "q"}]}], ")"}], "^", "2"}], "+", 
     RowBox[{"a", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "*", "p"}], "+", 
        RowBox[{"y", "*", "q"}]}], ")"}]}]}], "\[Equal]", "b"}], ",", " ", 
   "z", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[28]:=",
 CellID->4611],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"nlpde\"\>"}], ":", 
  " ", "\<\"Solution requested to nonlinear partial differential equation. \
Trying to build a special solution. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/DSolve/nlpde\\\", ButtonNote -> \
\\\"DSolve::nlpde\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:2.1.1",
 CellLabel->"During evaluation of In[28]:=",
 CellID->212164399],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"ArcTan", "[", 
        FractionBox["y", "x"], "]"}]}], " ", 
      SqrtBox[
       RowBox[{"C", "[", "1", "]"}]]}], "+", 
     RowBox[{"C", "[", "2", "]"}], "+", 
     FractionBox[
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}]], "]"}]}], "a"], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], " ", 
       RowBox[{"Log", "[", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}]], "]"}]}], "a"]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{515, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[28]=",
 CellID->118251704]
}, Open  ]],

Cell[TextData[{
 "This equation (equation 6.36, page 196 of [",
 ButtonBox["K74",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveReferences#7355"],
 "]) can be transformed into a linear PDE using a Legendre transformation."
}], "MathCaption",
 CellTags->"b:2.1.1",
 CellID->170],

Cell[BoxData[
 RowBox[{
  RowBox[{"LegendreTransformable", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "*", "p", "*", "q"}], "-", 
     RowBox[{"z", "*", "p"}], "+", 
     RowBox[{"a", "*", "q"}]}], "\[Equal]", "0"}]}], ";"}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[29]:=",
 CellID->29975],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{"LegendreTransformable", ",", " ", "u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[30]:=",
 CellID->13489],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"nlpde\"\>"}], ":", 
  " ", "\<\"Solution requested to nonlinear partial differential equation. \
Trying to build a special solution. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/DSolve/nlpde\\\", ButtonNote -> \
\\\"DSolve::nlpde\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:2.1.1",
 CellLabel->"During evaluation of In[30]:=",
 CellID->53558406],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{499, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[30]=",
 CellID->19995935]
}, Open  ]],

Cell["This verifies the solution.", "MathCaption",
 CellTags->"b:2.1.1",
 CellID->3333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LegendreTransformable", " ", "/.", "sol"}], "//", 
  "Simplify"}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[31]:=",
 CellID->13865],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[31]=",
 CellID->311974248]
}, Open  ]],

Cell["\<\
It should be noted that there is no general practical algorithm for finding \
complete integrals, and that the answers are often available only in implicit \
form.\
\>", "Text",
 CellTags->"b:2.1.1",
 CellID->17282],

Cell[TextData[{
 "The solution to this example (problem 2, page 66 of [",
 ButtonBox["S57",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveReferences#22104"],
 "]) is in implicit form."
}], "MathCaption",
 CellTags->"b:2.1.1",
 CellID->27007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"q", "^", "2"}]}], ")"}], "*", "z"}], "\[Equal]", 
     RowBox[{"p", "*", "x"}]}], ",", "u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[32]:=",
 CellID->27432],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"nlpde\"\>"}], ":", 
  " ", "\<\"Solution requested to nonlinear partial differential equation. \
Trying to build a special solution. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/DSolve/nlpde\\\", ButtonNote -> \
\\\"DSolve::nlpde\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:2.1.1",
 CellLabel->"During evaluation of In[32]:=",
 CellID->602527761],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/tdep\\\", \
ButtonNote -> \\\"Solve::tdep\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:2.1.1",
 CellLabel->"During evaluation of In[32]:=",
 CellID->78117734],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/tdep\\\", \
ButtonNote -> \\\"Solve::tdep\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:2.1.1",
 CellLabel->"During evaluation of In[32]:=",
 CellID->6260608],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"Log", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"C", "[", "1", "]"}]}], "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"C", "[", "1", "]"}], "2"], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox[
              RowBox[{"u", "[", 
               RowBox[{"x", ",", "y"}], "]"}], "2"]}]}]]}], "]"}]}], "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"C", "[", "1", "]"}], "2"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"u", "[", 
            RowBox[{"x", ",", "y"}], "]"}], "2"]}]}]]}], ")"}]}], "\[Equal]", 
    
    RowBox[{"y", "+", 
     RowBox[{"C", "[", "2", "]"}], "+", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Log", "[", "x", "]"}]}]}]}], ",", 
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], "]"}]], "Output",
 ImageSize->{468, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[32]=",
 CellID->192699348]
}, Open  ]],

Cell["The solution can be verified as follows.", "MathCaption",
 CellTags->"b:2.1.1",
 CellID->31810],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], "/.", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"sol", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[33]:=",
 CellID->17641],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "-", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"C", "[", "1", "]"}], "2"], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"u", "[", 
          RowBox[{"x", ",", "y"}], "]"}], "2"]}]}]]}], ")"}]}], 
  RowBox[{"2", " ", "x", " ", 
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}]]], "Output",
 ImageSize->{221, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[33]=",
 CellID->125090651]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"q", "=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}], "/.", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"sol", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", "y"}], "]"}], ",", " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[34]:=",
 CellID->2187],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "-", 
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"C", "[", "1", "]"}], "2"], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y"}], "]"}], "2"]}]}]]}], 
  RowBox[{"2", " ", 
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}]]], "Output",
 ImageSize->{176, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[34]=",
 CellID->193213981]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"q", "^", "2"}]}], ")"}], "*", "z"}], "-", 
   RowBox[{"p", "*", "x"}]}], "//", "Simplify"}]], "Input",
 CellTags->"b:2.1.1",
 CellLabel->"In[35]:=",
 CellID->6479],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.1",
 CellLabel->"Out[35]=",
 CellID->329083213]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->987281901],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Nonlinear PDEs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveLinearAndQuasiLinearFirstOrderPDEs"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveSecondOrderPDEs"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 41.7509710}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The general first-order nonlinear PDE for an unknown function u(x,y) is \
given by Here F is a function of u=u(x,y), \
p=FractionBox[RowBox[{\\[PartialD], RowBox[{u, (, RowBox[{x, ,, y}], )}]}], \
RowBox[{\\[PartialD], x}], MultilineFunction -> None], and \
q=FractionBox[RowBox[{\\[PartialD], RowBox[{u, (, RowBox[{x, ,, y}], )}]}], \
RowBox[{\\[PartialD], y}], MultilineFunction -> None]. The term 'nonlinear' \
refers to the fact that F is a nonlinear function of p and q. For instance, \
the eikonal equation involves a quadratic expression in p and q.", 
    "synonyms" -> {}, "title" -> "Nonlinear PDEs", "type" -> "Tutorial", 
    "uri" -> "tutorial/DSolveNonlinearFirstOrderPDEs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:40"->{
  Cell[1280, 43, 79, 2, 70, "Title",
   CellTags->{"c:40", "b:2.1.1"},
   CellID->10396]},
 "b:2.1.1"->{
  Cell[1280, 43, 79, 2, 70, "Title",
   CellTags->{"c:40", "b:2.1.1"},
   CellID->10396],
  Cell[1362, 47, 252, 9, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->15460],
  Cell[1617, 58, 201, 7, 70, "DisplayMath",
   CellTags->"b:2.1.1",
   CellID->20615],
  Cell[1821, 67, 855, 33, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->10904],
  Cell[2679, 102, 616, 20, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->2599],
  Cell[3298, 124, 1695, 58, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->20136],
  Cell[4996, 184, 92, 2, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->4680],
  Cell[5091, 188, 162, 6, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->9198],
  Cell[5256, 196, 219, 8, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->27032],
  Cell[5478, 206, 219, 8, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->14387],
  Cell[5700, 216, 191, 7, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->32584],
  Cell[5894, 225, 667, 22, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->7240],
  Cell[6586, 251, 241, 8, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->3517],
  Cell[6830, 261, 490, 10, 70, "Message",
   CellTags->"b:2.1.1",
   CellID->106763084],
  Cell[7323, 273, 566, 19, 51, "Output",
   CellTags->"b:2.1.1",
   CellID->443567229],
  Cell[7904, 295, 86, 2, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->241],
  Cell[8015, 301, 115, 4, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->18882],
  Cell[8133, 307, 205, 7, 36, "Output",
   CellTags->"b:2.1.1",
   CellID->581909309],
  Cell[8353, 317, 602, 19, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->3523],
  Cell[9617, 360, 605, 21, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->7296],
  Cell[10247, 385, 550, 18, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->9916],
  Cell[10800, 405, 465, 16, 51, "Output",
   CellTags->"b:2.1.1",
   CellID->96382683],
  Cell[11302, 426, 443, 13, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->10178],
  Cell[11748, 441, 411, 15, 36, "Output",
   CellTags->"b:2.1.1",
   CellID->3850533],
  Cell[12174, 459, 134, 4, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->25058],
  Cell[12333, 467, 574, 19, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->27577],
  Cell[12910, 488, 375, 14, 53, "Output",
   CellTags->"b:2.1.1",
   CellID->126629157],
  Cell[13322, 507, 575, 19, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->14007],
  Cell[13900, 528, 275, 10, 53, "Output",
   CellTags->"b:2.1.1",
   CellID->17145273],
  Cell[14212, 543, 224, 7, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->24081],
  Cell[14439, 552, 181, 6, 36, "Output",
   CellTags->"b:2.1.1",
   CellID->107208435],
  Cell[14635, 561, 291, 7, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->2678],
  Cell[14929, 570, 255, 9, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->24676],
  Cell[15209, 583, 385, 13, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->27753],
  Cell[15597, 598, 490, 10, 70, "Message",
   CellTags->"b:2.1.1",
   CellID->52889925],
  Cell[16090, 610, 1145, 35, 57, "Output",
   CellTags->"b:2.1.1",
   CellID->179200],
  Cell[17272, 650, 395, 13, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->15565],
  Cell[17670, 665, 949, 30, 57, "Output",
   CellTags->"b:2.1.1",
   CellID->348825550],
  Cell[18656, 700, 648, 18, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->13608],
  Cell[19307, 720, 262, 9, 36, "Output",
   CellTags->"b:2.1.1",
   CellID->195625603],
  Cell[19584, 732, 283, 10, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->11243],
  Cell[19870, 744, 157, 5, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->29929],
  Cell[20030, 751, 151, 5, 70, "BulletedText",
   CellTags->"b:2.1.1",
   CellID->7514],
  Cell[20184, 758, 164, 5, 70, "BulletedText",
   CellTags->"b:2.1.1",
   CellID->10168],
  Cell[20351, 765, 173, 5, 70, "BulletedText",
   CellTags->"b:2.1.1",
   CellID->5055],
  Cell[20549, 774, 214, 5, 70, "BulletedText",
   CellTags->"b:2.1.1",
   CellID->11191],
  Cell[20766, 781, 309, 7, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->5973],
  Cell[21078, 790, 257, 8, 70, "MathCaption",
   CellTags->{"EikonalEquation", "b:2.1.1"},
   CellID->8922],
  Cell[21835, 821, 246, 8, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->5651],
  Cell[22084, 831, 491, 10, 70, "Message",
   CellTags->"b:2.1.1",
   CellID->201881942],
  Cell[22578, 843, 1159, 40, 75, "Output",
   CellTags->"b:2.1.1",
   CellID->66721432],
  Cell[23752, 886, 1447, 48, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->16446],
  Cell[25202, 936, 113, 2, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->31577],
  Cell[25340, 942, 120, 4, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->26517],
  Cell[25463, 948, 231, 8, 36, "Output",
   CellTags->"b:2.1.1",
   CellID->88012804],
  Cell[25709, 959, 350, 13, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->29916],
  Cell[26062, 974, 401, 13, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->5874],
  Cell[26466, 989, 117, 2, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->15791],
  Cell[26608, 995, 248, 8, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->15469],
  Cell[26859, 1005, 491, 10, 70, "Message",
   CellTags->"b:2.1.1",
   CellID->551755893],
  Cell[27353, 1017, 769, 25, 48, "Output",
   CellTags->"b:2.1.1",
   CellID->275678723],
  Cell[28137, 1045, 88, 2, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->30693],
  Cell[28250, 1051, 120, 4, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->9091],
  Cell[28373, 1057, 206, 7, 36, "Output",
   CellTags->"b:2.1.1",
   CellID->149074497],
  Cell[28594, 1067, 444, 13, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->26949],
  Cell[29041, 1082, 301, 11, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->26857],
  Cell[29367, 1097, 249, 8, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->20640],
  Cell[29619, 1107, 491, 10, 70, "Message",
   CellTags->"b:2.1.1",
   CellID->211984604],
  Cell[30113, 1119, 1608, 52, 89, "Output",
   CellTags->"b:2.1.1",
   CellID->72243147],
  Cell[31736, 1174, 87, 2, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->8551],
  Cell[31848, 1180, 152, 5, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->9487],
  Cell[32003, 1187, 231, 8, 36, "Output",
   CellTags->"b:2.1.1",
   CellID->46345772],
  Cell[32249, 1198, 422, 14, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->28162],
  Cell[32674, 1214, 361, 12, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->16955],
  Cell[33060, 1230, 277, 8, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->23183],
  Cell[33340, 1240, 491, 10, 70, "Message",
   CellTags->"b:2.1.1",
   CellID->130653092],
  Cell[33834, 1252, 1631, 52, 67, "Output",
   CellTags->"b:2.1.1",
   CellID->226342698],
  Cell[35480, 1307, 88, 2, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->16097],
  Cell[35593, 1313, 173, 6, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->3065],
  Cell[35769, 1321, 206, 7, 36, "Output",
   CellTags->"b:2.1.1",
   CellID->313066424],
  Cell[35990, 1331, 507, 12, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->2513],
  Cell[36500, 1345, 689, 25, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->9261],
  Cell[37214, 1374, 342, 12, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->12578],
  Cell[37559, 1388, 491, 10, 70, "Message",
   CellTags->"b:2.1.1",
   CellID->322503206],
  Cell[38053, 1400, 560, 19, 53, "Output",
   CellTags->"b:2.1.1",
   CellID->39058936],
  Cell[38628, 1422, 307, 9, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->14140],
  Cell[38960, 1435, 550, 20, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->4611],
  Cell[39513, 1457, 491, 10, 70, "Message",
   CellTags->"b:2.1.1",
   CellID->212164399],
  Cell[40007, 1469, 983, 35, 65, "Output",
   CellTags->"b:2.1.1",
   CellID->118251704],
  Cell[41005, 1507, 289, 8, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->170],
  Cell[41297, 1517, 313, 10, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->29975],
  Cell[41635, 1531, 271, 8, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->13489],
  Cell[41909, 1541, 490, 10, 19, "Message",
   CellTags->"b:2.1.1",
   CellID->53558406],
  Cell[42402, 1553, 2569, 47, 151, "Output",
   Evaluatable->False,
   CellTags->"b:2.1.1",
   CellID->19995935],
  Cell[44986, 1603, 87, 2, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->3333],
  Cell[45098, 1609, 173, 6, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->13865],
  Cell[45274, 1617, 232, 8, 36, "Output",
   CellTags->"b:2.1.1",
   CellID->311974248],
  Cell[45521, 1628, 225, 6, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->17282],
  Cell[45749, 1636, 253, 8, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->27007],
  Cell[46027, 1648, 404, 14, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->27432],
  Cell[46434, 1664, 491, 10, 70, "Message",
   CellTags->"b:2.1.1",
   CellID->602527761],
  Cell[46928, 1676, 485, 10, 70, "Message",
   CellTags->"b:2.1.1",
   CellID->78117734],
  Cell[47416, 1688, 484, 10, 70, "Message",
   CellTags->"b:2.1.1",
   CellID->6260608],
  Cell[47903, 1700, 1291, 43, 74, "Output",
   CellTags->"b:2.1.1",
   CellID->192699348],
  Cell[49209, 1746, 101, 2, 70, "MathCaption",
   CellTags->"b:2.1.1",
   CellID->31810],
  Cell[49335, 1752, 616, 21, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->17641],
  Cell[49954, 1775, 650, 23, 71, "Output",
   CellTags->"b:2.1.1",
   CellID->125090651],
  Cell[50641, 1803, 615, 21, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->2187],
  Cell[51259, 1826, 544, 20, 63, "Output",
   CellTags->"b:2.1.1",
   CellID->193213981],
  Cell[51840, 1851, 267, 10, 70, "Input",
   CellTags->"b:2.1.1",
   CellID->6479],
  Cell[52110, 1863, 181, 6, 36, "Output",
   CellTags->"b:2.1.1",
   CellID->329083213]},
 "EikonalEquation"->{
  Cell[21078, 790, 257, 8, 70, "MathCaption",
   CellTags->{"EikonalEquation", "b:2.1.1"},
   CellID->8922]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:40", 55208, 1943},
 {"b:2.1.1", 55313, 1947},
 {"EikonalEquation", 64995, 2282}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 79, 2, 70, "Title",
 CellTags->{"c:40", "b:2.1.1"},
 CellID->10396],
Cell[1362, 47, 252, 9, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->15460],
Cell[1617, 58, 201, 7, 70, "DisplayMath",
 CellTags->"b:2.1.1",
 CellID->20615],
Cell[1821, 67, 855, 33, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->10904],
Cell[2679, 102, 616, 20, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->2599],
Cell[3298, 124, 1695, 58, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->20136],
Cell[4996, 184, 92, 2, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->4680],
Cell[5091, 188, 162, 6, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->9198],
Cell[5256, 196, 219, 8, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->27032],
Cell[5478, 206, 219, 8, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->14387],
Cell[5700, 216, 191, 7, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->32584],
Cell[5894, 225, 667, 22, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->7240],
Cell[CellGroupData[{
Cell[6586, 251, 241, 8, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->3517],
Cell[6830, 261, 490, 10, 70, "Message",
 CellTags->"b:2.1.1",
 CellID->106763084],
Cell[7323, 273, 566, 19, 51, "Output",
 CellTags->"b:2.1.1",
 CellID->443567229]
}, Open  ]],
Cell[7904, 295, 86, 2, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->241],
Cell[CellGroupData[{
Cell[8015, 301, 115, 4, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->18882],
Cell[8133, 307, 205, 7, 36, "Output",
 CellTags->"b:2.1.1",
 CellID->581909309]
}, Open  ]],
Cell[8353, 317, 602, 19, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->3523],
Cell[8958, 338, 656, 20, 70, "Text",
 CellID->203256104],
Cell[9617, 360, 605, 21, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->7296],
Cell[CellGroupData[{
Cell[10247, 385, 550, 18, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->9916],
Cell[10800, 405, 465, 16, 51, "Output",
 CellTags->"b:2.1.1",
 CellID->96382683]
}, Open  ]],
Cell[CellGroupData[{
Cell[11302, 426, 443, 13, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->10178],
Cell[11748, 441, 411, 15, 36, "Output",
 CellTags->"b:2.1.1",
 CellID->3850533]
}, Open  ]],
Cell[12174, 459, 134, 4, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->25058],
Cell[CellGroupData[{
Cell[12333, 467, 574, 19, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->27577],
Cell[12910, 488, 375, 14, 53, "Output",
 CellTags->"b:2.1.1",
 CellID->126629157]
}, Open  ]],
Cell[CellGroupData[{
Cell[13322, 507, 575, 19, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->14007],
Cell[13900, 528, 275, 10, 53, "Output",
 CellTags->"b:2.1.1",
 CellID->17145273]
}, Open  ]],
Cell[CellGroupData[{
Cell[14212, 543, 224, 7, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->24081],
Cell[14439, 552, 181, 6, 36, "Output",
 CellTags->"b:2.1.1",
 CellID->107208435]
}, Open  ]],
Cell[14635, 561, 291, 7, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->2678],
Cell[14929, 570, 255, 9, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->24676],
Cell[CellGroupData[{
Cell[15209, 583, 385, 13, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->27753],
Cell[15597, 598, 490, 10, 70, "Message",
 CellTags->"b:2.1.1",
 CellID->52889925],
Cell[16090, 610, 1145, 35, 57, "Output",
 CellTags->"b:2.1.1",
 CellID->179200]
}, Open  ]],
Cell[CellGroupData[{
Cell[17272, 650, 395, 13, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->15565],
Cell[17670, 665, 949, 30, 57, "Output",
 CellTags->"b:2.1.1",
 CellID->348825550]
}, Open  ]],
Cell[CellGroupData[{
Cell[18656, 700, 648, 18, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->13608],
Cell[19307, 720, 262, 9, 36, "Output",
 CellTags->"b:2.1.1",
 CellID->195625603]
}, Open  ]],
Cell[19584, 732, 283, 10, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->11243],
Cell[19870, 744, 157, 5, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->29929],
Cell[20030, 751, 151, 5, 70, "BulletedText",
 CellTags->"b:2.1.1",
 CellID->7514],
Cell[20184, 758, 164, 5, 70, "BulletedText",
 CellTags->"b:2.1.1",
 CellID->10168],
Cell[20351, 765, 173, 5, 70, "BulletedText",
 CellTags->"b:2.1.1",
 CellID->5055],
Cell[CellGroupData[{
Cell[20549, 774, 214, 5, 70, "BulletedText",
 CellTags->"b:2.1.1",
 CellID->11191],
Cell[20766, 781, 309, 7, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->5973],
Cell[21078, 790, 257, 8, 70, "MathCaption",
 CellTags->{"EikonalEquation", "b:2.1.1"},
 CellID->8922],
Cell[21338, 800, 472, 17, 70, "Input",
 CellID->698675620],
Cell[CellGroupData[{
Cell[21835, 821, 246, 8, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->5651],
Cell[22084, 831, 491, 10, 70, "Message",
 CellTags->"b:2.1.1",
 CellID->201881942],
Cell[22578, 843, 1159, 40, 75, "Output",
 CellTags->"b:2.1.1",
 CellID->66721432]
}, Open  ]],
Cell[23752, 886, 1447, 48, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->16446],
Cell[25202, 936, 113, 2, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->31577],
Cell[CellGroupData[{
Cell[25340, 942, 120, 4, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->26517],
Cell[25463, 948, 231, 8, 36, "Output",
 CellTags->"b:2.1.1",
 CellID->88012804]
}, Open  ]],
Cell[25709, 959, 350, 13, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->29916],
Cell[26062, 974, 401, 13, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->5874],
Cell[26466, 989, 117, 2, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->15791],
Cell[CellGroupData[{
Cell[26608, 995, 248, 8, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->15469],
Cell[26859, 1005, 491, 10, 70, "Message",
 CellTags->"b:2.1.1",
 CellID->551755893],
Cell[27353, 1017, 769, 25, 48, "Output",
 CellTags->"b:2.1.1",
 CellID->275678723]
}, Open  ]],
Cell[28137, 1045, 88, 2, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->30693],
Cell[CellGroupData[{
Cell[28250, 1051, 120, 4, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->9091],
Cell[28373, 1057, 206, 7, 36, "Output",
 CellTags->"b:2.1.1",
 CellID->149074497]
}, Open  ]],
Cell[28594, 1067, 444, 13, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->26949],
Cell[29041, 1082, 301, 11, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->26857],
Cell[CellGroupData[{
Cell[29367, 1097, 249, 8, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->20640],
Cell[29619, 1107, 491, 10, 70, "Message",
 CellTags->"b:2.1.1",
 CellID->211984604],
Cell[30113, 1119, 1608, 52, 89, "Output",
 CellTags->"b:2.1.1",
 CellID->72243147]
}, Open  ]],
Cell[31736, 1174, 87, 2, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->8551],
Cell[CellGroupData[{
Cell[31848, 1180, 152, 5, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->9487],
Cell[32003, 1187, 231, 8, 36, "Output",
 CellTags->"b:2.1.1",
 CellID->46345772]
}, Open  ]],
Cell[32249, 1198, 422, 14, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->28162],
Cell[32674, 1214, 361, 12, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->16955],
Cell[CellGroupData[{
Cell[33060, 1230, 277, 8, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->23183],
Cell[33340, 1240, 491, 10, 70, "Message",
 CellTags->"b:2.1.1",
 CellID->130653092],
Cell[33834, 1252, 1631, 52, 67, "Output",
 CellTags->"b:2.1.1",
 CellID->226342698]
}, Open  ]],
Cell[35480, 1307, 88, 2, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->16097],
Cell[CellGroupData[{
Cell[35593, 1313, 173, 6, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->3065],
Cell[35769, 1321, 206, 7, 36, "Output",
 CellTags->"b:2.1.1",
 CellID->313066424]
}, Open  ]],
Cell[35990, 1331, 507, 12, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->2513],
Cell[36500, 1345, 689, 25, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->9261],
Cell[CellGroupData[{
Cell[37214, 1374, 342, 12, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->12578],
Cell[37559, 1388, 491, 10, 70, "Message",
 CellTags->"b:2.1.1",
 CellID->322503206],
Cell[38053, 1400, 560, 19, 53, "Output",
 CellTags->"b:2.1.1",
 CellID->39058936]
}, Open  ]],
Cell[38628, 1422, 307, 9, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->14140],
Cell[CellGroupData[{
Cell[38960, 1435, 550, 20, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->4611],
Cell[39513, 1457, 491, 10, 70, "Message",
 CellTags->"b:2.1.1",
 CellID->212164399],
Cell[40007, 1469, 983, 35, 65, "Output",
 CellTags->"b:2.1.1",
 CellID->118251704]
}, Open  ]],
Cell[41005, 1507, 289, 8, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->170],
Cell[41297, 1517, 313, 10, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->29975],
Cell[CellGroupData[{
Cell[41635, 1531, 271, 8, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->13489],
Cell[41909, 1541, 490, 10, 19, "Message",
 CellTags->"b:2.1.1",
 CellID->53558406],
Cell[42402, 1553, 2569, 47, 151, "Output",
 Evaluatable->False,
 CellTags->"b:2.1.1",
 CellID->19995935]
}, Open  ]],
Cell[44986, 1603, 87, 2, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->3333],
Cell[CellGroupData[{
Cell[45098, 1609, 173, 6, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->13865],
Cell[45274, 1617, 232, 8, 36, "Output",
 CellTags->"b:2.1.1",
 CellID->311974248]
}, Open  ]],
Cell[45521, 1628, 225, 6, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->17282],
Cell[45749, 1636, 253, 8, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->27007],
Cell[CellGroupData[{
Cell[46027, 1648, 404, 14, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->27432],
Cell[46434, 1664, 491, 10, 70, "Message",
 CellTags->"b:2.1.1",
 CellID->602527761],
Cell[46928, 1676, 485, 10, 70, "Message",
 CellTags->"b:2.1.1",
 CellID->78117734],
Cell[47416, 1688, 484, 10, 70, "Message",
 CellTags->"b:2.1.1",
 CellID->6260608],
Cell[47903, 1700, 1291, 43, 74, "Output",
 CellTags->"b:2.1.1",
 CellID->192699348]
}, Open  ]],
Cell[49209, 1746, 101, 2, 70, "MathCaption",
 CellTags->"b:2.1.1",
 CellID->31810],
Cell[CellGroupData[{
Cell[49335, 1752, 616, 21, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->17641],
Cell[49954, 1775, 650, 23, 71, "Output",
 CellTags->"b:2.1.1",
 CellID->125090651]
}, Open  ]],
Cell[CellGroupData[{
Cell[50641, 1803, 615, 21, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->2187],
Cell[51259, 1826, 544, 20, 63, "Output",
 CellTags->"b:2.1.1",
 CellID->193213981]
}, Open  ]],
Cell[CellGroupData[{
Cell[51840, 1851, 267, 10, 70, "Input",
 CellTags->"b:2.1.1",
 CellID->6479],
Cell[52110, 1863, 181, 6, 36, "Output",
 CellTags->"b:2.1.1",
 CellID->329083213]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[52340, 1875, 72, 1, 70, "RelatedTutorialsSection",
 CellID->987281901],
Cell[52415, 1878, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[52619, 1885, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

