(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30745,       1143]
NotebookOptionsPosition[     23730,        915]
NotebookOutlinePosition[     26977,       1001]
CellTagsIndexPosition[     26777,        992]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Second-Order PDEs", "Title",
 CellTags->{"second_order_pdes", "c:41"},
 CellID->18455],

Cell["The general form of a linear second-order PDE is ", "Text",
 CellID->5725],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"a", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], "u"}], 
      RowBox[{"\[PartialD]", 
       SuperscriptBox["x", "2"]}]]}], "+", 
    RowBox[{"b", " ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], "u"}], 
      RowBox[{
       RowBox[{"\[PartialD]", "x"}], "\[ThinSpace]", 
       RowBox[{"\[PartialD]", "y"}]}]]}], " ", "+", " ", 
    RowBox[{"c", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], "u"}], 
      RowBox[{"\[PartialD]", 
       SuperscriptBox["y", "2"]}]]}], " ", "+", " ", 
    RowBox[{"d", 
     FractionBox[
      RowBox[{"\[PartialD]", "u"}], 
      RowBox[{"\[PartialD]", "x"}]]}], " ", "+", 
    RowBox[{"e", 
     FractionBox[
      RowBox[{"\[PartialD]", "u"}], 
      RowBox[{"\[PartialD]", "y"}]]}], " ", "+", " ", 
    RowBox[{"f", " ", "u"}]}], "\[LongEqual]", " ", 
   RowBox[{"g", "."}]}], TraditionalForm]], "DisplayMath",
 CellID->4071],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "=", 
    RowBox[{"u", "(", 
     RowBox[{"x", ",", "y"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["e", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " are functions of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " only\[LongDash]they do not depend on ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 ". If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", the equation is said to be homogeneous."
}], "Text",
 CellID->24808],

Cell[TextData[{
 "The first three terms containing the second derivatives are called the",
 StyleBox[" principal part ",
  FontSlant->"Italic"],
 "of the PDE. They determine the nature of the general solution to the \
equation. In fact, the coefficients of the principal part can be used to \
classify the PDE as follows."
}], "Text",
 CellID->13559],

Cell[TextData[{
 "The PDE is said to be ",
 StyleBox["elliptic",
  FontSlant->"Italic"],
 " if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", "a", "c"}]}], "<", "0"}], TraditionalForm]], "InlineMath"],
 ". The Laplace equation has ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", "1"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", "=", "1"}], TraditionalForm]], "InlineMath"],
 " and is therefore an elliptic PDE."
}], "Text",
 CellID->9156],

Cell[TextData[{
 "The PDE is said to be",
 StyleBox[" hyperbolic",
  FontSlant->"Italic"],
 " if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", "a", "c"}]}], ">", "0"}], TraditionalForm]], "InlineMath"],
 ". The wave equation has ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", "1"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath"],
 " and is therefore a hyperbolic PDE."
}], "Text",
 CellID->5602],

Cell[TextData[{
 "The PDE is said to be ",
 StyleBox["parabolic",
  FontSlant->"Italic"],
 " if",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", "a", "c"}]}], "=", "0"}], TraditionalForm]], "InlineMath"],
 ". The heat equation has ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", "1"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", "=", "0"}], TraditionalForm]], "InlineMath"],
 " and is therefore a parabolic PDE."
}], "Text",
 CellID->17832],

Cell[TextData[{
 StyleBox["DSolve", "MR"],
 " can find the general solution for a restricted type of homogeneous linear \
second-order PDEs; namely, equations of the following form"
}], "Text",
 CellID->7905],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"a", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], "u"}], 
      RowBox[{"\[PartialD]", 
       SuperscriptBox["x", "2"]}]]}], "+", 
    RowBox[{"b", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], "u"}], 
      RowBox[{
       RowBox[{"\[PartialD]", "x"}], "\[ThinSpace]", 
       RowBox[{"\[PartialD]", "y"}]}]]}], " ", "+", " ", 
    RowBox[{"c", " ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], "u"}], 
      RowBox[{"\[PartialD]", 
       SuperscriptBox["y", "2"]}]]}]}], " ", "=", " ", "0."}], 
  TraditionalForm]], "DisplayMath",
 CellID->10440],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " are ",
 "constants. ",
 "Thus, ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " assumes that the equation has constant coefficients and a vanishing \
non-principal part."
}], "Text",
 CellID->7375],

Cell["\<\
Following are some examples of the three basic types (elliptic, hyperbolic, \
and parabolic) and an explanation of their significance.\
\>", "Text",
 CellID->21562],

Cell[TextData[{
 "Here is the general solution for ",
 ButtonBox["Laplace\[CloseCurlyQuote]s equation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveIntroductionToPDEs#27918"],
 ", an elliptic PDE."
}], "MathCaption",
 CellTags->"LaplacesEquation",
 CellID->22885],

Cell[BoxData[
 RowBox[{
  RowBox[{"LaplaceEquation", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"x", ",", "2"}], "}"}]}], "]"}], "+", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"y", ",", " ", "2"}], "}"}]}], "]"}]}], "\[Equal]", "0"}]}], 
  ";"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->21962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{"LaplaceEquation", ",", 
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->21080],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", "x"}], "+", "y"}], "]"}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}], "+", "y"}], "]"}]}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{274, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->30516879]
}, Open  ]],

Cell[TextData[{
 "This general solution contains two arbitrary functions, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "2", "]"}]], "InlineFormula"],
 ". The arguments of these functions, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "+", 
    RowBox[{"\[ImaginaryI]", "x"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "-", 
    RowBox[{"\[ImaginaryI]", "x"}]}], TraditionalForm]], "InlineMath"],
 ", indicate that the solution is constant along the imaginary straight line \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], "x"}], "+", "\[Alpha]"}]}], 
   TraditionalForm]], "InlineMath"],
 " when ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["C",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/C"], "[", "2", "]"}], "\[Equal]", "0"}]], 
  "InlineFormula"],
 " and along ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", "x"}], "+", "\[Alpha]"}]}], TraditionalForm]], 
  "InlineMath"],
 " when ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["C",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/C"], "[", "1", "]"}], "\[Equal]", "0"}]], 
  "InlineFormula"],
 " . These straight lines are called ",
 "characteristic curves ",
 "of the PDE. In general, elliptic PDEs have ",
 "imaginary",
 " characteristic curves."
}], "Text",
 CellID->10797],

Cell["Here is another elliptic PDE.", "MathCaption",
 CellID->31202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", " ", "3"}], ";", 
  RowBox[{"b", "=", "1"}], ";", 
  RowBox[{"c", "=", "5"}], ";", 
  RowBox[{
   RowBox[{"b", "^", "2"}], "-", 
   RowBox[{"4", "a", "*", "c"}]}]}]], "Input",
 CellLabel->"In[18]:=",
 CellID->10508],

Cell[BoxData[
 RowBox[{"-", "59"}]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->140485443]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], "+", 
     RowBox[{"b", "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", " ", "x", ",", "y"}], "]"}]}], 
     "+", 
     RowBox[{"c", "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}]}], "\[Equal]", "0"}]}], 
  ";"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->31493],

Cell["Note the imaginary characteristic curves for the equation. ", \
"MathCaption",
 CellID->7740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", " ", "u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[20]:=",
 CellID->8546],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "[", 
        RowBox[{
         RowBox[{
          FractionBox["1", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["59"]}]}], ")"}], " ", "x"}], "+", "y"}], "]"}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], "[", 
        RowBox[{
         RowBox[{
          FractionBox["1", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "-", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["59"]}]}], ")"}], " ", "x"}], "+", "y"}], "]"}]}]}], 
     "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{526, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->319888934]
}, Open  ]],

Cell["The solution is verified as follows.", "MathCaption",
 CellID->24773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "/.", "sol"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->19097],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->296882826]
}, Open  ]],

Cell[TextData[{
 "This finds the general solution of the ",
 ButtonBox["wave equation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveIntroductionToPDEs#27918"],
 ", a hyperbolic PDE. The constant ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " in the wave equation represents the speed of light and is set to 1 here \
for convenience."
}], "MathCaption",
 CellTags->"WaveEquation",
 CellID->11072],

Cell[BoxData[
 RowBox[{
  RowBox[{"WaveEquation", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "t"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "2"}], "}"}]}], "]"}], "-", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "t"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "2"}], "}"}]}], "]"}]}], "\[Equal]", "0"}]}], 
  ";"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->385687097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{"WaveEquation", " ", ",", " ", 
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "t"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->707],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "t"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{
       RowBox[{"-", "t"}], "+", "x"}], "]"}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], "[", 
      RowBox[{"t", "+", "x"}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{252, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->221386211]
}, Open  ]],

Cell[TextData[{
 "The characteristic lines for the wave equation are ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{"k", "+", "t"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{"k", "-", "t"}]}], TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " is an arbitrary constant. Hence the wave equation (or any hyperbolic PDE) \
has two families of real characteristic curves. If initial conditions are \
specified for the wave equation, the solution propagates along the \
characteristic lines. Also, any fixed pair of characteristic lines determine \
the null cone of an observer sitting at their intersection."
}], "Text",
 CellID->20666],

Cell["Here is another example of a hyperbolic PDE.", "MathCaption",
 CellID->4141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", " ", "2"}], ";", 
  RowBox[{"b", "=", "7"}], ";", 
  RowBox[{"c", "=", 
   RowBox[{"-", "1"}]}], ";", 
  RowBox[{
   RowBox[{"b", "^", "2"}], "-", 
   RowBox[{"4", "a", "*", "c"}]}]}]], "Input",
 CellLabel->"In[24]:=",
 CellID->23588],

Cell[BoxData["57"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->354069276]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], "+", 
     RowBox[{"b", "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", " ", "x", ",", "y"}], "]"}]}], 
     "+", 
     RowBox[{"c", "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}]}], "\[Equal]", "0"}]}], 
  ";"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->16225],

Cell["\<\
Notice that the equation has two families of real characteristics.\
\>", "MathCaption",
 CellID->1009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", " ", "u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[26]:=",
 CellID->22012],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"7", "+", 
            SqrtBox["57"]}], ")"}], " ", "x"}], "+", "y"}], "]"}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"7", "-", 
            SqrtBox["57"]}], ")"}], " ", "x"}], "+", "y"}], "]"}]}]}], 
     "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{504, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->32793023]
}, Open  ]],

Cell["The solution can be verified as follows.", "MathCaption",
 CellID->11455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "/.", "sol"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->18762],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->3897662]
}, Open  ]],

Cell["Finally, here is an example of a parabolic PDE.", "MathCaption",
 CellID->21],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", " ", "3"}], ";", 
  RowBox[{"b", "=", "30"}], ";", 
  RowBox[{"c", "=", " ", "75"}], ";", 
  RowBox[{
   RowBox[{"b", "^", "2"}], "-", 
   RowBox[{"4", "a", "*", "c"}]}]}]], "Input",
 CellLabel->"In[28]:=",
 CellID->17922],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->143874325]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "2"}], "}"}]}], "]"}]}], "+", 
     RowBox[{"b", "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", " ", "x", ",", "y"}], "]"}]}], 
     "+", 
     RowBox[{"c", "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}]}], "\[Equal]", "0"}]}], 
  ";"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->23717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{"eqn", ",", " ", "u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[30]:=",
 CellID->9714],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "5"}], " ", "x"}], "+", "y"}], "]"}], "+", 
       RowBox[{"x", " ", 
        RowBox[{
         RowBox[{"C", "[", "2", "]"}], "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "5"}], " ", "x"}], "+", "y"}], "]"}]}]}]}], "]"}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->191427841]
}, Open  ]],

Cell[TextData[{
 "The equation has only one family of real characteristics, the lines ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{
     RowBox[{"5", "x"}], "+", "\[Alpha]"}]}], TraditionalForm]], 
  "InlineMath"],
 ". In fact, any parabolic PDE has only a single family of real \
characteristics. "
}], "Text",
 CellID->13290],

Cell["The solution can be verified as follows.", "MathCaption",
 CellID->3335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "/.", "sol"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->12759],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->10215471]
}, Open  ]],

Cell[TextData[{
 "The ",
 ButtonBox["heat equation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DSolveIntroductionToPDEs#27918"],
 " is parabolic, but it is not considered here because it has a nonvanishing \
non-principal part, and the algorithm used by ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " is not applicable in this case."
}], "Text",
 CellTags->"HeatEquation",
 CellID->5303],

Cell["\<\
This concludes the discussion of partial differential equations. \
\>", "Text",
 CellID->22640],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->122680434],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Second-Order PDEs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveNonlinearFirstOrderPDEs"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveIntroductionToDAEs"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 48.7980264}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The general form of a linear second-order PDE is Here u=u(x,y), and a, \
b, c, d, e, f, and g are functions of x and y only--they do not depend on u. \
If g=0, the equation is said to be homogeneous. The first three terms \
containing the second derivatives are called the principal part of the PDE. \
They determine the nature of the general solution to the equation. In fact, \
the coefficients of the principal part can be used to classify the PDE as \
follows.", "synonyms" -> {}, "title" -> "Second-Order PDEs", "type" -> 
    "Tutorial", "uri" -> "tutorial/DSolveSecondOrderPDEs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "second_order_pdes"->{
  Cell[1280, 43, 92, 2, 70, "Title",
   CellTags->{"second_order_pdes", "c:41"},
   CellID->18455]},
 "c:41"->{
  Cell[1280, 43, 92, 2, 70, "Title",
   CellTags->{"second_order_pdes", "c:41"},
   CellID->18455]},
 "LaplacesEquation"->{
  Cell[7515, 284, 277, 8, 70, "MathCaption",
   CellTags->"LaplacesEquation",
   CellID->22885]},
 "WaveEquation"->{
  Cell[14043, 540, 432, 12, 70, "MathCaption",
   CellTags->"WaveEquation",
   CellID->11072]},
 "HeatEquation"->{
  Cell[22820, 880, 471, 14, 70, "Text",
   CellTags->"HeatEquation",
   CellID->5303]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"second_order_pdes", 26198, 969},
 {"c:41", 26310, 973},
 {"LaplacesEquation", 26434, 977},
 {"WaveEquation", 26551, 981},
 {"HeatEquation", 26666, 985}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 92, 2, 70, "Title",
 CellTags->{"second_order_pdes", "c:41"},
 CellID->18455],
Cell[1375, 47, 80, 1, 70, "Text",
 CellID->5725],
Cell[1458, 50, 1020, 33, 70, "DisplayMath",
 CellID->4071],
Cell[2481, 85, 1113, 43, 70, "Text",
 CellID->24808],
Cell[3597, 130, 350, 8, 70, "Text",
 CellID->13559],
Cell[3950, 140, 642, 25, 70, "Text",
 CellID->9156],
Cell[4595, 167, 662, 26, 70, "Text",
 CellID->5602],
Cell[5260, 195, 646, 26, 70, "Text",
 CellID->17832],
Cell[5909, 223, 208, 5, 70, "Text",
 CellID->7905],
Cell[6120, 230, 704, 24, 70, "DisplayMath",
 CellID->10440],
Cell[6827, 256, 508, 20, 70, "Text",
 CellID->7375],
Cell[7338, 278, 174, 4, 70, "Text",
 CellID->21562],
Cell[7515, 284, 277, 8, 70, "MathCaption",
 CellTags->"LaplacesEquation",
 CellID->22885],
Cell[7795, 294, 549, 19, 70, "Input",
 CellID->21962],
Cell[CellGroupData[{
Cell[8369, 317, 249, 8, 70, "Input",
 CellID->21080],
Cell[8621, 327, 603, 21, 36, "Output",
 CellID->30516879]
}, Open  ]],
Cell[9239, 351, 1634, 61, 70, "Text",
 CellID->10797],
Cell[10876, 414, 68, 1, 70, "MathCaption",
 CellID->31202],
Cell[CellGroupData[{
Cell[10969, 419, 259, 9, 70, "Input",
 CellID->10508],
Cell[11231, 430, 177, 6, 36, "Output",
 CellID->140485443]
}, Open  ]],
Cell[11423, 439, 782, 27, 70, "Input",
 CellID->31493],
Cell[12208, 468, 99, 2, 70, "MathCaption",
 CellID->7740],
Cell[CellGroupData[{
Cell[12332, 474, 230, 7, 70, "Input",
 CellID->8546],
Cell[12565, 483, 1036, 34, 51, "Output",
 CellID->319888934]
}, Open  ]],
Cell[13616, 520, 75, 1, 70, "MathCaption",
 CellID->24773],
Cell[CellGroupData[{
Cell[13716, 525, 125, 4, 70, "Input",
 CellID->19097],
Cell[13844, 531, 184, 6, 36, "Output",
 CellID->296882826]
}, Open  ]],
Cell[14043, 540, 432, 12, 70, "MathCaption",
 CellTags->"WaveEquation",
 CellID->11072],
Cell[14478, 554, 535, 19, 70, "Input",
 CellID->385687097],
Cell[CellGroupData[{
Cell[15038, 577, 259, 8, 70, "Input",
 CellID->707],
Cell[15300, 587, 519, 18, 36, "Output",
 CellID->221386211]
}, Open  ]],
Cell[15834, 608, 775, 20, 70, "Text",
 CellID->20666],
Cell[16612, 630, 82, 1, 70, "MathCaption",
 CellID->4141],
Cell[CellGroupData[{
Cell[16719, 635, 278, 10, 70, "Input",
 CellID->23588],
Cell[17000, 647, 160, 5, 36, "Output",
 CellID->354069276]
}, Open  ]],
Cell[17175, 655, 782, 27, 70, "Input",
 CellID->16225],
Cell[17960, 684, 112, 3, 70, "MathCaption",
 CellID->1009],
Cell[CellGroupData[{
Cell[18097, 691, 231, 7, 70, "Input",
 CellID->22012],
Cell[18331, 700, 941, 32, 51, "Output",
 CellID->32793023]
}, Open  ]],
Cell[19287, 735, 79, 1, 70, "MathCaption",
 CellID->11455],
Cell[CellGroupData[{
Cell[19391, 740, 125, 4, 70, "Input",
 CellID->18762],
Cell[19519, 746, 182, 6, 36, "Output",
 CellID->3897662]
}, Open  ]],
Cell[19716, 755, 83, 1, 70, "MathCaption",
 CellID->21],
Cell[CellGroupData[{
Cell[19824, 760, 266, 9, 70, "Input",
 CellID->17922],
Cell[20093, 771, 159, 5, 36, "Output",
 CellID->143874325]
}, Open  ]],
Cell[20267, 779, 782, 27, 70, "Input",
 CellID->23717],
Cell[CellGroupData[{
Cell[21074, 810, 230, 7, 70, "Input",
 CellID->9714],
Cell[21307, 819, 721, 25, 36, "Output",
 CellID->191427841]
}, Open  ]],
Cell[22043, 847, 345, 11, 70, "Text",
 CellID->13290],
Cell[22391, 860, 78, 1, 70, "MathCaption",
 CellID->3335],
Cell[CellGroupData[{
Cell[22494, 865, 125, 4, 70, "Input",
 CellID->12759],
Cell[22622, 871, 183, 6, 36, "Output",
 CellID->10215471]
}, Open  ]],
Cell[22820, 880, 471, 14, 70, "Text",
 CellTags->"HeatEquation",
 CellID->5303],
Cell[23294, 896, 105, 3, 70, "Text",
 CellID->22640],
Cell[CellGroupData[{
Cell[23424, 903, 72, 1, 70, "RelatedTutorialsSection",
 CellID->122680434],
Cell[23499, 906, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[23703, 913, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

