(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15680,        521]
NotebookOptionsPosition[     10006,        344]
NotebookOutlinePosition[     14139,        462]
CellTagsIndexPosition[     14013,        455]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Separable Equations", "Title",
 CellTags->{"separableODE", "c:10", "b:1.1.0.1"},
 CellID->21979],

Cell[TextData[StyleBox["The general solution to this equation is found by \
separation of variables.",
 FontColor->GrayLevel[0]]], "MathCaption",
 CellTags->"b:1.1.0.1",
 CellID->24199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "^", "2"}]}], 
     SqrtBox[
      RowBox[{"3", "-", 
       SuperscriptBox["x", "2"]}]]]}], ",", "y", ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.0.1",
 CellLabel->"In[1]:=",
 CellID->29105],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      FractionBox["2", 
       RowBox[{
        RowBox[{"x", " ", 
         SqrtBox[
          RowBox[{"3", "-", 
           SuperscriptBox["x", "2"]}]]}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"ArcSin", "[", 
          FractionBox["x", 
           SqrtBox["3"]], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "1", "]"}]}]}]]}], "]"}]}], "}"}], "}"}]], "Output",\

 ImageSize->{376, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.1",
 CellLabel->"Out[1]=",
 CellID->32757]
}, Open  ]],

Cell[TextData[{
 "Even when variables can be separated, the final solution might be \
accompanied by a warning message from ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 ", or it might only be given as an ",
 Cell[BoxData[
  ButtonBox["InverseFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFunction"]], "InlineFormula"],
 " object."
}], "Text",
 CellTags->"b:1.1.0.1",
 CellID->18661],

Cell[TextData[{
 "Solving this ODE generates a warning message because ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " obtains an expression for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "x", "]"}], TraditionalForm]], "InlineMath"],
 " using ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 ", the inverse of ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 ". This warning message can be ignored."
}], "MathCaption",
 CellTags->"b:1.1.0.1",
 CellID->8681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"Exp", "[", 
       RowBox[{"y", "[", "x", "]"}], "]"}]}], 
     SqrtBox[
      RowBox[{"3", "-", 
       SuperscriptBox["x", "2"]}]]]}], ",", "y", ",", "x"}], "]"}]], "Input",
 CellTags->"b:1.1.0.1",
 CellLabel->"In[2]:=",
 CellID->3652],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Inverse functions are being used by \
\\\\\\\"\\\", \\\"MSG\\\"]\\)\\!\\(Solve\\)\\!\\(\\*StyleBox[\\\"\\\\\\\", so \
some solutions may not be found; use Reduce for complete solution \
information.\\\\\\\"\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/Solve/ifun\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellTags->"b:1.1.0.1",
 CellLabel->"During evaluation of In[2]:=",
 CellID->20037],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"-", 
       RowBox[{"Log", "[", 
        RowBox[{
         RowBox[{
          FractionBox["1", "2"], " ", "x", " ", 
          SqrtBox[
           RowBox[{"3", "-", 
            SuperscriptBox["x", "2"]}]]}], "-", 
         RowBox[{
          FractionBox["3", "2"], " ", 
          RowBox[{"ArcSin", "[", 
           FractionBox["x", 
            SqrtBox["3"]], "]"}]}], "-", 
         RowBox[{"C", "[", "1", "]"}]}], "]"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{427, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.1",
 CellLabel->"Out[2]=",
 CellID->12859]
}, Open  ]],

Cell[TextData[{
 "The solution to this equation is given as an ",
 Cell[BoxData[
  ButtonBox["InverseFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFunction"]], "InlineFormula"],
 " object, in order to get an explicit expression for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "x", "]"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:1.1.0.1",
 CellID->32029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "2"], " "}], 
      RowBox[{
       SqrtBox[
        RowBox[{"9", "-", 
         SuperscriptBox["x", "2"]}]], 
       RowBox[{"Log", "[", 
        RowBox[{"y", "[", "x", "]"}], "]"}], "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"y", "[", "x", "]"}], "]"}]}]]}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:1.1.0.1",
 CellLabel->"In[3]:=",
 CellID->15987],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Inverse functions are being used. \
Values may be lost for multivalued inverses.\\\\\\\"\\\", \\\"MSG\\\"]\\) \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/InverseFunction/ifun\\\"]\\)\"\>"}]], \
"Message", "MSG",
 CellTags->"b:1.1.0.1",
 CellLabel->"During evaluation of In[3]:=",
 CellID->8723],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Inverse functions are being used. \
Values may be lost for multivalued inverses.\\\\\\\"\\\", \\\"MSG\\\"]\\) \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/InverseFunction/ifun\\\"]\\)\"\>"}]], \
"Message", "MSG",
 CellTags->"b:1.1.0.1",
 CellLabel->"During evaluation of In[3]:=",
 CellID->9741],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The equations appear to involve the \
variables to be solved for in an essentially non-algebraic way.\\\\\\\"\\\", \
\\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/Solve/tdep\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellTags->"b:1.1.0.1",
 CellLabel->"During evaluation of In[3]:=",
 CellID->27529],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"InverseFunction", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"CosIntegral", "[", "#1", "]"}], "-", 
        RowBox[{
         RowBox[{"Cos", "[", "#1", "]"}], " ", 
         RowBox[{"Log", "[", "#1", "]"}]}]}], "&"}], "]"}], "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FractionBox["1", "2"], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "3"}], "+", "x"}]], " ", "x", " ", 
          SqrtBox[
           RowBox[{"3", "+", "x"}]]}], "+", 
         RowBox[{"9", " ", 
          RowBox[{"ArcSinh", "[", 
           FractionBox[
            SqrtBox[
             RowBox[{
              RowBox[{"-", "3"}], "+", "x"}]], 
            SqrtBox["6"]], "]"}]}]}], ")"}]}], "+", 
      RowBox[{"C", "[", "1", "]"}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{418, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.1",
 CellLabel->"Out[3]=",
 CellID->778]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->376424147],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Separable Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveStraightIntegration"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveHomogeneousEquations"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 49.1574106}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The general solution to this equation is found by separation of \
variables. Even when variables can be separated, the final solution might be \
accompanied by a warning message from Solve, or it might only be given as an \
InverseFunction object. Solving this ODE generates a warning message because \
Solve obtains an expression for y[x] using Log, the inverse of Exp. This \
warning message can be ignored.", "synonyms" -> {}, "title" -> 
    "Separable Equations", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveSeparableEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "separableODE"->{
  Cell[1280, 43, 102, 2, 70, "Title",
   CellTags->{"separableODE", "c:10", "b:1.1.0.1"},
   CellID->21979]},
 "c:10"->{
  Cell[1280, 43, 102, 2, 70, "Title",
   CellTags->{"separableODE", "c:10", "b:1.1.0.1"},
   CellID->21979]},
 "b:1.1.0.1"->{
  Cell[1280, 43, 102, 2, 70, "Title",
   CellTags->{"separableODE", "c:10", "b:1.1.0.1"},
   CellID->21979],
  Cell[1385, 47, 185, 4, 70, "MathCaption",
   CellTags->"b:1.1.0.1",
   CellID->24199],
  Cell[1595, 55, 489, 17, 51, "Input",
   CellTags->"b:1.1.0.1",
   CellID->29105],
  Cell[2087, 74, 704, 25, 74, "Output",
   CellTags->"b:1.1.0.1",
   CellID->32757],
  Cell[2806, 102, 475, 15, 70, "Text",
   CellTags->"b:1.1.0.1",
   CellID->18661],
  Cell[3284, 119, 663, 23, 70, "MathCaption",
   CellTags->"b:1.1.0.1",
   CellID->8681],
  Cell[3972, 146, 495, 17, 70, "Input",
   CellTags->"b:1.1.0.1",
   CellID->3652],
  Cell[4470, 165, 603, 12, 34, "Message",
   CellTags->"b:1.1.0.1",
   CellID->20037],
  Cell[5076, 179, 785, 27, 56, "Output",
   CellTags->"b:1.1.0.1",
   CellID->12859],
  Cell[5876, 209, 412, 13, 70, "MathCaption",
   CellTags->"b:1.1.0.1",
   CellID->32029],
  Cell[6313, 226, 663, 22, 70, "Input",
   CellTags->"b:1.1.0.1",
   CellID->15987],
  Cell[6979, 250, 506, 11, 70, "Message",
   CellTags->"b:1.1.0.1",
   CellID->8723],
  Cell[7488, 263, 506, 11, 70, "Message",
   CellTags->"b:1.1.0.1",
   CellID->9741],
  Cell[7997, 276, 508, 11, 70, "Message",
   CellTags->"b:1.1.0.1",
   CellID->27529],
  Cell[8508, 289, 1155, 38, 83, "Output",
   CellTags->"b:1.1.0.1",
   CellID->778]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"separableODE", 12424, 398},
 {"c:10", 12545, 402},
 {"b:1.1.0.1", 12671, 406}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 102, 2, 70, "Title",
 CellTags->{"separableODE", "c:10", "b:1.1.0.1"},
 CellID->21979],
Cell[1385, 47, 185, 4, 70, "MathCaption",
 CellTags->"b:1.1.0.1",
 CellID->24199],
Cell[CellGroupData[{
Cell[1595, 55, 489, 17, 51, "Input",
 CellTags->"b:1.1.0.1",
 CellID->29105],
Cell[2087, 74, 704, 25, 74, "Output",
 CellTags->"b:1.1.0.1",
 CellID->32757]
}, Open  ]],
Cell[2806, 102, 475, 15, 70, "Text",
 CellTags->"b:1.1.0.1",
 CellID->18661],
Cell[3284, 119, 663, 23, 70, "MathCaption",
 CellTags->"b:1.1.0.1",
 CellID->8681],
Cell[CellGroupData[{
Cell[3972, 146, 495, 17, 70, "Input",
 CellTags->"b:1.1.0.1",
 CellID->3652],
Cell[4470, 165, 603, 12, 34, "Message",
 CellTags->"b:1.1.0.1",
 CellID->20037],
Cell[5076, 179, 785, 27, 56, "Output",
 CellTags->"b:1.1.0.1",
 CellID->12859]
}, Open  ]],
Cell[5876, 209, 412, 13, 70, "MathCaption",
 CellTags->"b:1.1.0.1",
 CellID->32029],
Cell[CellGroupData[{
Cell[6313, 226, 663, 22, 70, "Input",
 CellTags->"b:1.1.0.1",
 CellID->15987],
Cell[6979, 250, 506, 11, 70, "Message",
 CellTags->"b:1.1.0.1",
 CellID->8723],
Cell[7488, 263, 506, 11, 70, "Message",
 CellTags->"b:1.1.0.1",
 CellID->9741],
Cell[7997, 276, 508, 11, 70, "Message",
 CellTags->"b:1.1.0.1",
 CellID->27529],
Cell[8508, 289, 1155, 38, 83, "Output",
 CellTags->"b:1.1.0.1",
 CellID->778]
}, Open  ]],
Cell[CellGroupData[{
Cell[9700, 332, 72, 1, 70, "RelatedTutorialsSection",
 CellID->376424147],
Cell[9775, 335, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[9979, 342, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

