(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     60223,       2161]
NotebookOptionsPosition[     42166,       1513]
NotebookOutlinePosition[     52476,       1845]
CellTagsIndexPosition[     52341,       1838]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Setting Up the Problem", "Title",
 CellTags->{"setting_up_the_problem", "c:52", "b:5.1"},
 CellID->15814],

Cell[TextData[{
 "The first argument given to ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " is the differential equation, the second argument is the unknown function, \
and the last argument identifies the independent variable."
}], "Text",
 CellTags->"b:5.1",
 CellID->32718],

Cell[TextData[{
 "Here is the input for solving for a first-order linear ODE using ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ". The variable ",
 Cell[BoxData["sol"], "InlineFormula"],
 " identifies the solution for use in further work. "
}], "MathCaption",
 CellTags->"b:5.1",
 CellID->12244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
      RowBox[{"5", 
       RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "1"}], ",", " ", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"In[5]:=",
 CellID->31063],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "5"], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "5"}], " ", "x"}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{156, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"Out[5]=",
 CellID->5662249]
}, Open  ]],

Cell[TextData[{
 "The output of ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " is a list of solutions for the differential equation. The extra list is \
required since some equations have multiple solutions. Here, since the \
equation is of order 1 and is linear, there is only one solution: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
   RowBox[{
    FractionBox["1", "5"], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "5"}], " ", "x"}]], " ", 
     RowBox[{
      ButtonBox["C",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/C"], "[", "1", "]"}]}]}]}]], "InlineFormula"],
 ". The solution has an undetermined constant ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 " because no initial condition was specified. The solution can be extracted \
from the list of solutions using a part specification. "
}], "Text",
 CellTags->"b:5.1",
 CellID->20652],

Cell["This extracts the solution. ", "MathCaption",
 CellTags->"b:5.1",
 CellID->18864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", " ", "=", 
  RowBox[{"sol", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"In[6]:=",
 CellID->4769],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
   RowBox[{
    FractionBox["1", "5"], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "5"}], " ", "x"}]], " ", 
     RowBox[{"C", "[", "1", "]"}]}]}]}], "}"}]], "Output",
 ImageSize->{142, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"Out[6]=",
 CellID->228601805]
}, Open  ]],

Cell[TextData[{
 "This form of the solution is useful for finding ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "x", "]"}], TraditionalForm]], "InlineMath"],
 " itself, but not for finding derivatives of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "x", "]"}], TraditionalForm]], "InlineMath"],
 " or the value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "x", "]"}], TraditionalForm]], "InlineMath"],
 " at a point."
}], "Text",
 CellTags->"b:5.1",
 CellID->15005],

Cell[TextData[{
 "This shows the value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "x", "]"}], TraditionalForm]], "InlineMath"],
 " given by the solution."
}], "MathCaption",
 CellTags->"b:5.1",
 CellID->21047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", "x", "]"}], "/.", "m"}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"In[7]:=",
 CellID->1594],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "5"], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "5"}], " ", "x"}]], " ", 
   RowBox[{"C", "[", "1", "]"}]}]}]], "Output",
 ImageSize->{84, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"Out[7]=",
 CellID->1641241]
}, Open  ]],

Cell[TextData[{
 "The solution does not apply to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}], TraditionalForm]], 
  "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "1", "]"}], TraditionalForm]], "InlineMath"],
 " because the solution is a rule for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "x", "]"}], TraditionalForm]], "InlineMath"],
 " only."
}], "MathCaption",
 CellTags->"b:5.1",
 CellID->24326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"y", "'"}], "[", "x", "]"}], "/.", "m"}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"In[8]:=",
 CellID->3276],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["y", "\[Prime]",
   MultilineFunction->None], "[", "x", "]"}]], "Output",
 ImageSize->{36, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"Out[8]=",
 CellID->535550650]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", "1", "]"}], "/.", "m"}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"In[9]:=",
 CellID->6540],

Cell[BoxData[
 RowBox[{"y", "[", "1", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"Out[9]=",
 CellID->77178811]
}, Open  ]],

Cell[TextData[{
 "If the solution will be used in further work, it is best to specify the \
unknown function using ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " rather than ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "x", "]"}], TraditionalForm]], "InlineMath"],
 ". This gives the solution using pure functions of the type ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Function",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Function"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellTags->"b:5.1",
 CellID->23990],

Cell[TextData[{
 "Here, the unknown function is specified as ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ". The solution is a pure function."
}], "MathCaption",
 CellTags->"b:5.1",
 CellID->32588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
      RowBox[{"5", 
       RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "1"}], ",", " ", "y", 
    ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"In[12]:=",
 CellID->24710],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       FractionBox["1", "5"], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "5"}], " ", "x"}]], " ", 
        RowBox[{"C", "[", "1", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{237, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"Out[12]=",
 CellID->457687157]
}, Open  ]],

Cell[TextData[{
 "When the solution is in the form of pure functions, expressions can be \
found for derivatives of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " and for the values of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " at specific points."
}], "Text",
 CellTags->"b:5.1",
 CellID->17945],

Cell[TextData[{
 "This gives expressions for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "x", "]"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}], TraditionalForm]], 
  "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "[", "1", "]"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:5.1",
 CellID->29221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", " ", 
  RowBox[{"sol", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellLabel->"In[14]:=",
 CellID->539037766],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"y", "\[Rule]", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{
      FractionBox["1", "5"], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "5"}], " ", "x"}]], " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{223, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->114896255]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", "x", "]"}], "/.", "m"}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"In[15]:=",
 CellID->28470],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "5"], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "5"}], " ", "x"}]], " ", 
   RowBox[{"C", "[", "1", "]"}]}]}]], "Output",
 ImageSize->{84, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"Out[15]=",
 CellID->30456000]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"y", "'"}], "[", "x", "]"}], "/.", "m"}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"In[16]:=",
 CellID->23589],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "5"}], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "5"}], " ", "x"}]], " ", 
  RowBox[{"C", "[", "1", "]"}]}]], "Output",
 ImageSize->{78, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"Out[16]=",
 CellID->383385118]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", "1", "]"}], "/.", "m"}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"In[17]:=",
 CellID->4978],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "5"], "+", 
  FractionBox[
   RowBox[{"C", "[", "1", "]"}], 
   SuperscriptBox["\[ExponentialE]", "5"]]}]], "Output",
 ImageSize->{60, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"Out[17]=",
 CellID->1029326842]
}, Open  ]],

Cell["\<\
When a problem has multiple solutions, you can pick out individual solutions \
from the solution list or you can work directly with the list.\
\>", "Text",
 CellTags->"b:5.1",
 CellID->5006],

Cell["\<\
This solves a nonlinear first-order equation. There are two solutions.\
\>", "MathCaption",
 CellTags->"b:5.1",
 CellID->13262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "^", "2"}], " ", "\[Equal]", " ", 
     
     RowBox[{"x", "+", "11"}]}], ",", " ", "y", ",", "x"}], "]"}]}]], "Input",\

 CellTags->"b:5.1",
 CellLabel->"(Local) In[10]:=",
 CellID->20135],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          FractionBox["2", "3"]}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"11", "+", "x"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"C", "[", "1", "]"}]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        RowBox[{
         FractionBox["2", "3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"11", "+", "x"}], ")"}], 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"C", "[", "1", "]"}]}]}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{551, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"(Local) Out[10]=",
 CellID->23487]
}, Open  ]],

Cell["The solutions can be extracted using part specifications.", \
"MathCaption",
 CellTags->"b:5.1",
 CellID->27196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", "x", "]"}], "/.", 
  RowBox[{"sol", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"(Local) In[11]:=",
 CellID->29033],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["2", "3"]}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"11", "+", "x"}], ")"}], 
    RowBox[{"3", "/", "2"}]]}], "+", 
  RowBox[{"C", "[", "1", "]"}]}]], "Output",
 ImageSize->{130, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"(Local) Out[11]=",
 CellID->2088]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", "x", "]"}], "/.", 
  RowBox[{"sol", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"(Local) In[12]:=",
 CellID->12935],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["2", "3"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"11", "+", "x"}], ")"}], 
    RowBox[{"3", "/", "2"}]]}], "+", 
  RowBox[{"C", "[", "1", "]"}]}]], "Output",
 ImageSize->{122, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"(Local) Out[12]=",
 CellID->19779]
}, Open  ]],

Cell["This returns a list of both expressions.", "MathCaption",
 CellTags->"b:5.1",
 CellID->15993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", "x", "]"}], "/.", "sol"}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"(Local) In[13]:=",
 CellID->14790],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["2", "3"]}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"11", "+", "x"}], ")"}], 
      RowBox[{"3", "/", "2"}]]}], "+", 
    RowBox[{"C", "[", "1", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     FractionBox["2", "3"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"11", "+", "x"}], ")"}], 
      RowBox[{"3", "/", "2"}]]}], "+", 
    RowBox[{"C", "[", "1", "]"}]}]}], "}"}]], "Output",
 ImageSize->{273, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"(Local) Out[13]=",
 CellID->24962]
}, Open  ]],

Cell[TextData[{
 "To solve a system of equations, the first argument to ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " must be a list of the equations and the second argument must be a list of \
the unknown functions. "
}], "Text",
 CellTags->"b:5.1",
 CellID->18965],

Cell["\<\
Here is an example of a system of first-order linear equations with three \
unknowns. Because this system is linear, there is only one solution.\
\>", "MathCaption",
 CellTags->"b:5.1",
 CellID->11001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"y", "[", "t", "]"}], "+", 
        RowBox[{"z", "[", "t", "]"}]}]}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "t", "]"}], "+", 
        RowBox[{"z", "[", "t", "]"}], "-", 
        RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", "0"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"z", "'"}], "[", "t", "]"}], " ", "+", 
        RowBox[{"y", "[", "t", "]"}]}], "\[Equal]", 
       RowBox[{"x", "[", "t", "]"}]}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "t"}], "]"}]}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"(Local) In[14]:=",
 CellID->19105],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{582, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"(Local) Out[14]=",
 CellID->383640909]
}, Open  ]],

Cell["\<\
Each solution to the system is a list of replacement rules for the unknown \
functions. The expressions for the unknown functions can be extracted as in \
previous examples.\
\>", "Text",
 CellTags->"b:5.1",
 CellID->24567],

Cell[TextData[{
 "This gives a list of the expressions for the unknown functions. ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " is used to return the expressions in a compact form."
}], "MathCaption",
 CellTags->"b:5.1",
 CellID->2669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], ",", " ", 
     RowBox[{"y", "[", "t", "]"}], ",", 
     RowBox[{"z", "[", "t", "]"}]}], "}"}], "/.", 
   RowBox[{"sol", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"(Local) In[15]:=",
 CellID->3134],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{379, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"(Local) Out[15]=",
 CellID->483566136]
}, Open  ]],

Cell["\<\
If initial conditions are prescribed for the problem, some or all of the \
undetermined constants can be eliminated.\
\>", "Text",
 CellTags->"b:5.1",
 CellID->1457],

Cell["\<\
Here the value of the unknown function and its derivative are both prescribed \
at the initial point.\
\>", "MathCaption",
 CellTags->"b:5.1",
 CellID->12998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], " ", "+", 
       RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", "5"}], ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "7"}]}], "}"}], ",", 
   " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"(Local) In[16]:=",
 CellID->3545],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{"5", "-", 
     RowBox[{"4", " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], "+", 
     RowBox[{"7", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"(Local) Out[16]=",
 CellID->13597]
}, Open  ]],

Cell["\<\
If only the initial value is specified, then the solution still contains an \
arbitrary constant.\
\>", "MathCaption",
 CellTags->"b:5.1",
 CellID->14218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], " ", "+", 
       RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", "5"}], ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"(Local) In[17]:=",
 CellID->8838],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{"5", "-", 
     RowBox[{"4", " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"(Local) Out[17]=",
 CellID->14844]
}, Open  ]],

Cell[TextData[{
 "For a partial differential equation, the third argument to ",
 StyleBox["DSolve", "MR"],
 " is a list of the independent variables for the equation."
}], "Text",
 CellTags->"b:5.1",
 CellID->7372],

Cell[TextData[{
 "This solves a PDE with independent variables ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 " represents an arbitrary function of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], " ", "+", " ", 
   RowBox[{
    ButtonBox["Cos",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Cos"], "[", 
    RowBox[{
     StyleBox["y", "TI"], "[", 
     StyleBox["x", "TI"], "]"}], "]"}]}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:5.1",
 CellID->8563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", " ", "x"}], "]"}], " ", "+", " ",
      
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}], "\[Equal]", 
    "8"}], ",", " ", "u", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"(Local) In[18]:=",
 CellID->21028],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       RowBox[{"8", " ", "x"}], "+", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "[", 
        RowBox[{"y", "+", 
         RowBox[{"Cos", "[", "x", "]"}]}], "]"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"(Local) Out[18]=",
 CellID->29264]
}, Open  ]],

Cell["\<\
A differential-algebraic equation is specified in the same way as a system of \
ordinary differential equations.\
\>", "Text",
 CellTags->"b:5.1",
 CellID->28801],

Cell["Here is an example of a DAE with an initial condition.", "MathCaption",
 CellTags->"b:5.1",
 CellID->14723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}], " ", "+", 
       RowBox[{"y", "[", "t", "]"}]}], "\[Equal]", 
      RowBox[{"Sin", "[", "t", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], "+", 
       RowBox[{"y", "[", "t", "]"}]}], "\[Equal]", "1"}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "4"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "t"}], "]"}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"(Local) In[19]:=",
 CellID->13490],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", 
          RowBox[{"7", " ", 
           SuperscriptBox["\[ExponentialE]", "t"]}], "-", 
          RowBox[{"Cos", "[", "t", "]"}], "-", 
          RowBox[{"Sin", "[", "t", "]"}]}], ")"}]}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "t", "}"}], ",", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "7"}], " ", 
           SuperscriptBox["\[ExponentialE]", "t"]}], "+", 
          RowBox[{"Cos", "[", "t", "]"}], "+", 
          RowBox[{"Sin", "[", "t", "]"}]}], ")"}]}]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{330, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"(Local) Out[19]=",
 CellID->7604]
}, Open  ]],

Cell[TextData[{
 "Note that it is not always possible to give the solutions for a problem in \
explicit form. In this case, the solution is given using an unevaluated ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " object or using ",
 Cell[BoxData[
  ButtonBox["InverseFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFunction"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:5.1",
 CellID->31601],

Cell["\<\
The solution to this equation is not available explicitly. The output \
represents an implicit solution.\
\>", "MathCaption",
 CellTags->"b:5.1",
 CellID->24227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "^", "3"}], "+", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "^", "2"}]}], "\[Equal]", "1"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"In[20]:=",
 CellID->11197],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The equations appear to involve the \
variables to be solved for in an essentially non-algebraic way.\\\\\\\"\\\", \
\\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/Solve/tdep\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellTags->"b:5.1",
 CellLabel->"During evaluation of In[20]:=",
 CellID->12316],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The equations appear to involve the \
variables to be solved for in an essentially non-algebraic way.\\\\\\\"\\\", \
\\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/Solve/tdep\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellTags->"b:5.1",
 CellLabel->"During evaluation of In[20]:=",
 CellID->3035],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"RootSum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["#1", "2"], "+", 
        SuperscriptBox["#1", "3"]}], "&"}], ",", 
      RowBox[{
       FractionBox[
        RowBox[{"Log", "[", 
         RowBox[{
          RowBox[{"-", "#1"}], "+", 
          RowBox[{"y", "[", "x", "]"}]}], "]"}], 
        RowBox[{
         RowBox[{"2", " ", "#1"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "2"]}]}]], "&"}]}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"-", "x"}], "+", 
     RowBox[{"C", "[", "1", "]"}]}]}], ",", 
   RowBox[{"y", "[", "x", "]"}]}], "]"}]], "Output",
 ImageSize->{441, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"Out[20]=",
 CellID->22190]
}, Open  ]],

Cell["\<\
The solution can be extracted as usual with a part specification.\
\>", "MathCaption",
 CellTags->"b:5.1",
 CellID->29301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"In[21]:=",
 CellID->22363],

Cell[BoxData[
 RowBox[{
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["#1", "2"], "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"-", "#1"}], "+", 
        RowBox[{"y", "[", "x", "]"}]}], "]"}], 
      RowBox[{
       RowBox[{"2", " ", "#1"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "2"]}]}]], "&"}]}], "]"}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", "x"}], "+", 
   RowBox[{"C", "[", "1", "]"}]}]}]], "Output",
 ImageSize->{352, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"Out[21]=",
 CellID->1842]
}, Open  ]],

Cell[TextData[{
 "The solutions to this equation are given as ",
 Cell[BoxData[
  ButtonBox["InverseFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFunction"]], "InlineFormula"],
 " objects."
}], "MathCaption",
 CellTags->"b:5.1",
 CellID->3565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", "2", "]"}], "[", "y", "]"}], "[", "x", 
       "]"}], " ", "+", " ", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "*", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Derivative", "[", "1", "]"}], "[", "y", "]"}], "[", "x", 
         "]"}], "^", "4"}]}]}], " ", "==", " ", "0"}], ",", " ", "y", ",", 
    " ", "x"}], "]"}]}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"In[22]:=",
 CellID->17421],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The equations appear to involve the \
variables to be solved for in an essentially non-algebraic way.\\\\\\\"\\\", \
\\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/Solve/tdep\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellTags->"b:5.1",
 CellLabel->"During evaluation of In[22]:=",
 CellID->288],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The equations appear to involve the \
variables to be solved for in an essentially non-algebraic way.\\\\\\\"\\\", \
\\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/Solve/tdep\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellTags->"b:5.1",
 CellLabel->"During evaluation of In[22]:=",
 CellID->30106],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        RowBox[{"InverseFunction", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"C", "[", "1", "]"}], " ", 
            RowBox[{"Log", "[", 
             RowBox[{"#1", "+", 
              SqrtBox[
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", 
                 RowBox[{"C", "[", "1", "]"}]}], "+", 
                SuperscriptBox["#1", "2"]}]]}], "]"}]}], "-", 
           RowBox[{
            FractionBox["1", "2"], " ", "#1", " ", 
            SqrtBox[
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               RowBox[{"C", "[", "1", "]"}]}], "+", 
              SuperscriptBox["#1", "2"]}]]}]}], "&"}], "]"}], "[", 
        RowBox[{"x", "+", 
         RowBox[{"C", "[", "2", "]"}]}], "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        RowBox[{"InverseFunction", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{"C", "[", "1", "]"}]}], " ", 
            RowBox[{"Log", "[", 
             RowBox[{"#1", "+", 
              SqrtBox[
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", 
                 RowBox[{"C", "[", "1", "]"}]}], "+", 
                SuperscriptBox["#1", "2"]}]]}], "]"}]}], "+", 
           RowBox[{
            FractionBox["1", "2"], " ", "#1", " ", 
            SqrtBox[
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               RowBox[{"C", "[", "1", "]"}]}], "+", 
              SuperscriptBox["#1", "2"]}]]}]}], "&"}], "]"}], "[", 
        RowBox[{"x", "+", 
         RowBox[{"C", "[", "2", "]"}]}], "]"}]}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{574, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"Out[22]=",
 CellID->9040]
}, Open  ]],

Cell[TextData[{
 "Each solution can be rewritten as an implicit equation by eliminating the \
",
 Cell[BoxData[
  ButtonBox["InverseFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFunction"]], "InlineFormula"],
 " object as follows."
}], "MathCaption",
 CellTags->"b:5.1",
 CellID->16741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"soly", "=", " ", 
  RowBox[{
   RowBox[{"y", "[", "x", "]"}], "/.", 
   RowBox[{"sol", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"(Local) In[23]:=",
 CellID->15022],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"#1", "+", 
        SqrtBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           RowBox[{"C", "[", "1", "]"}]}], "+", 
          SuperscriptBox["#1", "2"]}]]}], "]"}]}], "-", 
     RowBox[{
      FractionBox["1", "2"], " ", "#1", " ", 
      SqrtBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"C", "[", "1", "]"}]}], "+", 
        SuperscriptBox["#1", "2"]}]]}]}], "&"}], "]"}], "[", 
  RowBox[{"x", "+", 
   RowBox[{"C", "[", "2", "]"}]}], "]"}]], "Output",
 ImageSize->{525, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"(Local) Out[23]=",
 CellID->31812]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"implicitequation", " ", "=", 
  RowBox[{"(", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Head", "[", "soly", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "[", 
     RowBox[{"y", "[", "x", "]"}], "]"}], "==", 
    RowBox[{"soly", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], " ", ")"}]}]], "Input",
 CellTags->"b:5.1",
 CellLabel->"(Local) In[24]:=",
 CellID->29151],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"C", "[", "1", "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "+", 
      SqrtBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"C", "[", "1", "]"}]}], "+", 
        SuperscriptBox[
         RowBox[{"y", "[", "x", "]"}], "2"]}]]}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"y", "[", "x", "]"}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"C", "[", "1", "]"}]}], "+", 
      SuperscriptBox[
       RowBox[{"y", "[", "x", "]"}], "2"]}]]}]}], "\[Equal]", 
  RowBox[{"x", "+", 
   RowBox[{"C", "[", "2", "]"}]}]}]], "Output",
 ImageSize->{455, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellLabel->"(Local) Out[24]=",
 CellID->23015]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->593717399],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Setting Up the Problem - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/WorkingWithDSolveIntroduction"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DSolveSolutionVerification"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 49.5324202}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The first argument given to DSolve is the differential equation, the \
second argument is the unknown function, and the last argument identifies the \
independent variable. Here is the input for solving for a first-order linear \
ODE using DSolve. The variable sol identifies the solution for use in further \
work. The output of DSolve is a list of solutions for the differential \
equation. The extra list is required since some equations have multiple \
solutions. Here, since the equation is of order 1 and is linear, there is \
only one solution: y[x]->FractionBox[1, 5]+E^-5 x C[1]. The solution has an \
undetermined constant C[1] because no initial condition was specified. The \
solution can be extracted from the list of solutions using a part \
specification. ", "synonyms" -> {}, "title" -> "Setting Up the Problem", 
    "type" -> "Tutorial", "uri" -> "tutorial/DSolveSettingUpTheProblem"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "setting_up_the_problem"->{
  Cell[1280, 43, 111, 2, 70, "Title",
   CellTags->{"setting_up_the_problem", "c:52", "b:5.1"},
   CellID->15814]},
 "c:52"->{
  Cell[1280, 43, 111, 2, 70, "Title",
   CellTags->{"setting_up_the_problem", "c:52", "b:5.1"},
   CellID->15814]},
 "b:5.1"->{
  Cell[1280, 43, 111, 2, 70, "Title",
   CellTags->{"setting_up_the_problem", "c:52", "b:5.1"},
   CellID->15814],
  Cell[1394, 47, 351, 10, 70, "Text",
   CellTags->"b:5.1",
   CellID->32718],
  Cell[1748, 59, 369, 11, 70, "MathCaption",
   CellTags->"b:5.1",
   CellID->12244],
  Cell[2142, 74, 390, 13, 28, "Input",
   CellTags->"b:5.1",
   CellID->31063],
  Cell[2535, 89, 483, 17, 51, "Output",
   CellTags->"b:5.1",
   CellID->5662249],
  Cell[3033, 109, 1106, 32, 70, "Text",
   CellTags->"b:5.1",
   CellID->20652],
  Cell[4142, 143, 87, 2, 70, "MathCaption",
   CellTags->"b:5.1",
   CellID->18864],
  Cell[4254, 149, 166, 6, 28, "Input",
   CellTags->"b:5.1",
   CellID->4769],
  Cell[4423, 157, 453, 16, 51, "Output",
   CellTags->"b:5.1",
   CellID->228601805],
  Cell[4891, 176, 482, 16, 70, "Text",
   CellTags->"b:5.1",
   CellID->15005],
  Cell[5376, 194, 219, 8, 70, "MathCaption",
   CellTags->"b:5.1",
   CellID->21047],
  Cell[5620, 206, 136, 5, 70, "Input",
   CellTags->"b:5.1",
   CellID->1594],
  Cell[5759, 213, 356, 13, 51, "Output",
   CellTags->"b:5.1",
   CellID->1641241],
  Cell[6130, 229, 511, 19, 70, "MathCaption",
   CellTags->"b:5.1",
   CellID->24326],
  Cell[6666, 252, 155, 6, 70, "Input",
   CellTags->"b:5.1",
   CellID->3276],
  Cell[6824, 260, 264, 9, 36, "Output",
   CellTags->"b:5.1",
   CellID->535550650],
  Cell[7125, 274, 136, 5, 70, "Input",
   CellTags->"b:5.1",
   CellID->6540],
  Cell[7264, 281, 204, 7, 36, "Output",
   CellTags->"b:5.1",
   CellID->77178811],
  Cell[7483, 291, 629, 21, 70, "Text",
   CellTags->"b:5.1",
   CellID->23990],
  Cell[8115, 314, 220, 7, 70, "MathCaption",
   CellTags->"b:5.1",
   CellID->32588],
  Cell[8360, 325, 366, 13, 70, "Input",
   CellTags->"b:5.1",
   CellID->24710],
  Cell[8729, 340, 560, 19, 51, "Output",
   CellTags->"b:5.1",
   CellID->457687157],
  Cell[9304, 362, 346, 11, 70, "Text",
   CellTags->"b:5.1",
   CellID->17945],
  Cell[9653, 375, 470, 19, 70, "MathCaption",
   CellTags->"b:5.1",
   CellID->29221],
  Cell[10846, 427, 138, 5, 70, "Input",
   CellTags->"b:5.1",
   CellID->28470],
  Cell[10987, 434, 358, 13, 51, "Output",
   CellTags->"b:5.1",
   CellID->30456000],
  Cell[11382, 452, 157, 6, 70, "Input",
   CellTags->"b:5.1",
   CellID->23589],
  Cell[11542, 460, 339, 12, 36, "Output",
   CellTags->"b:5.1",
   CellID->383385118],
  Cell[11918, 477, 137, 5, 70, "Input",
   CellTags->"b:5.1",
   CellID->4978],
  Cell[12058, 484, 312, 11, 52, "Output",
   CellTags->"b:5.1",
   CellID->1029326842],
  Cell[12385, 498, 200, 5, 70, "Text",
   CellTags->"b:5.1",
   CellID->5006],
  Cell[12588, 505, 137, 4, 70, "MathCaption",
   CellTags->"b:5.1",
   CellID->13262],
  Cell[12750, 513, 349, 13, 70, "Input",
   CellTags->"b:5.1",
   CellID->20135],
  Cell[13102, 528, 1041, 35, 65, "Output",
   CellTags->"b:5.1",
   CellID->23487],
  Cell[14158, 566, 118, 3, 70, "MathCaption",
   CellTags->"b:5.1",
   CellID->27196],
  Cell[14301, 573, 200, 7, 70, "Input",
   CellTags->"b:5.1",
   CellID->29033],
  Cell[14504, 582, 400, 15, 65, "Output",
   CellTags->"b:5.1",
   CellID->2088],
  Cell[14941, 602, 200, 7, 70, "Input",
   CellTags->"b:5.1",
   CellID->12935],
  Cell[15144, 611, 381, 14, 65, "Output",
   CellTags->"b:5.1",
   CellID->19779],
  Cell[15540, 628, 99, 2, 70, "MathCaption",
   CellTags->"b:5.1",
   CellID->15993],
  Cell[15664, 634, 148, 5, 70, "Input",
   CellTags->"b:5.1",
   CellID->14790],
  Cell[15815, 641, 677, 25, 65, "Output",
   CellTags->"b:5.1",
   CellID->24962],
  Cell[16507, 669, 341, 10, 70, "Text",
   CellTags->"b:5.1",
   CellID->18965],
  Cell[16851, 681, 211, 5, 70, "MathCaption",
   CellTags->"b:5.1",
   CellID->11001],
  Cell[17087, 690, 902, 28, 61, "Input",
   CellTags->"b:5.1",
   CellID->19105],
  Cell[17992, 720, 2786, 50, 125, "Output",
   Evaluatable->False,
   CellTags->"b:5.1",
   CellID->383640909],
  Cell[20793, 773, 233, 6, 70, "Text",
   CellTags->"b:5.1",
   CellID->24567],
  Cell[21029, 781, 314, 9, 70, "MathCaption",
   CellTags->"b:5.1",
   CellID->2669],
  Cell[21368, 794, 361, 12, 42, "Input",
   CellTags->"b:5.1",
   CellID->3134],
  Cell[21732, 808, 2245, 41, 125, "Output",
   Evaluatable->False,
   CellTags->"b:5.1",
   CellID->483566136],
  Cell[23992, 852, 175, 5, 70, "Text",
   CellTags->"b:5.1",
   CellID->1457],
  Cell[24170, 859, 168, 5, 70, "MathCaption",
   CellTags->"b:5.1",
   CellID->12998],
  Cell[24363, 868, 575, 19, 70, "Input",
   CellTags->"b:5.1",
   CellID->3545],
  Cell[24941, 889, 444, 15, 50, "Output",
   CellTags->"b:5.1",
   CellID->13597],
  Cell[25400, 907, 164, 5, 70, "MathCaption",
   CellTags->"b:5.1",
   CellID->14218],
  Cell[25589, 916, 468, 15, 70, "Input",
   CellTags->"b:5.1",
   CellID->8838],
  Cell[26060, 933, 476, 16, 50, "Output",
   CellTags->"b:5.1",
   CellID->14844],
  Cell[26551, 952, 214, 6, 70, "Text",
   CellTags->"b:5.1",
   CellID->7372],
  Cell[26768, 960, 718, 27, 70, "MathCaption",
   CellTags->"b:5.1",
   CellID->8563],
  Cell[27511, 991, 605, 21, 70, "Input",
   CellTags->"b:5.1",
   CellID->21028],
  Cell[28119, 1014, 568, 20, 50, "Output",
   CellTags->"b:5.1",
   CellID->29264],
  Cell[28702, 1037, 172, 5, 70, "Text",
   CellTags->"b:5.1",
   CellID->28801],
  Cell[28877, 1044, 113, 2, 70, "MathCaption",
   CellTags->"b:5.1",
   CellID->14723],
  Cell[29015, 1050, 663, 21, 70, "Input",
   CellTags->"b:5.1",
   CellID->13490],
  Cell[29681, 1073, 1096, 35, 95, "Output",
   CellTags->"b:5.1",
   CellID->7604],
  Cell[30792, 1111, 490, 15, 70, "Text",
   CellTags->"b:5.1",
   CellID->31601],
  Cell[31285, 1128, 171, 5, 70, "MathCaption",
   CellTags->"b:5.1",
   CellID->24227],
  Cell[31481, 1137, 451, 15, 70, "Input",
   CellTags->"b:5.1",
   CellID->11197],
  Cell[31935, 1154, 505, 11, 70, "Message",
   CellTags->"b:5.1",
   CellID->12316],
  Cell[32443, 1167, 504, 11, 70, "Message",
   CellTags->"b:5.1",
   CellID->3035],
  Cell[32950, 1180, 875, 30, 53, "Output",
   CellTags->"b:5.1",
   CellID->22190],
  Cell[33840, 1213, 132, 4, 70, "MathCaption",
   CellTags->"b:5.1",
   CellID->29301],
  Cell[33997, 1221, 139, 5, 70, "Input",
   CellTags->"b:5.1",
   CellID->22363],
  Cell[34139, 1228, 749, 27, 53, "Output",
   CellTags->"b:5.1",
   CellID->1842],
  Cell[34903, 1258, 264, 9, 70, "MathCaption",
   CellTags->"b:5.1",
   CellID->3565],
  Cell[35192, 1271, 593, 20, 70, "Input",
   CellTags->"b:5.1",
   CellID->17421],
  Cell[35788, 1293, 503, 11, 70, "Message",
   CellTags->"b:5.1",
   CellID->288],
  Cell[36294, 1306, 505, 11, 70, "Message",
   CellTags->"b:5.1",
   CellID->30106],
  Cell[36802, 1319, 2213, 68, 127, "Output",
   CellTags->"b:5.1",
   CellID->9040],
  Cell[39030, 1390, 307, 10, 70, "MathCaption",
   CellTags->"b:5.1",
   CellID->16741],
  Cell[39362, 1404, 234, 8, 70, "Input",
   CellTags->"b:5.1",
   CellID->15022],
  Cell[39599, 1414, 872, 30, 66, "Output",
   CellTags->"b:5.1",
   CellID->31812],
  Cell[40508, 1449, 411, 13, 70, "Input",
   CellTags->"b:5.1",
   CellID->29151],
  Cell[40922, 1464, 901, 32, 66, "Output",
   CellTags->"b:5.1",
   CellID->23015]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"setting_up_the_problem", 44972, 1572},
 {"c:52", 45099, 1576},
 {"b:5.1", 45227, 1580}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 111, 2, 70, "Title",
 CellTags->{"setting_up_the_problem", "c:52", "b:5.1"},
 CellID->15814],
Cell[1394, 47, 351, 10, 70, "Text",
 CellTags->"b:5.1",
 CellID->32718],
Cell[1748, 59, 369, 11, 70, "MathCaption",
 CellTags->"b:5.1",
 CellID->12244],
Cell[CellGroupData[{
Cell[2142, 74, 390, 13, 28, "Input",
 CellTags->"b:5.1",
 CellID->31063],
Cell[2535, 89, 483, 17, 51, "Output",
 CellTags->"b:5.1",
 CellID->5662249]
}, Open  ]],
Cell[3033, 109, 1106, 32, 70, "Text",
 CellTags->"b:5.1",
 CellID->20652],
Cell[4142, 143, 87, 2, 70, "MathCaption",
 CellTags->"b:5.1",
 CellID->18864],
Cell[CellGroupData[{
Cell[4254, 149, 166, 6, 28, "Input",
 CellTags->"b:5.1",
 CellID->4769],
Cell[4423, 157, 453, 16, 51, "Output",
 CellTags->"b:5.1",
 CellID->228601805]
}, Open  ]],
Cell[4891, 176, 482, 16, 70, "Text",
 CellTags->"b:5.1",
 CellID->15005],
Cell[5376, 194, 219, 8, 70, "MathCaption",
 CellTags->"b:5.1",
 CellID->21047],
Cell[CellGroupData[{
Cell[5620, 206, 136, 5, 70, "Input",
 CellTags->"b:5.1",
 CellID->1594],
Cell[5759, 213, 356, 13, 51, "Output",
 CellTags->"b:5.1",
 CellID->1641241]
}, Open  ]],
Cell[6130, 229, 511, 19, 70, "MathCaption",
 CellTags->"b:5.1",
 CellID->24326],
Cell[CellGroupData[{
Cell[6666, 252, 155, 6, 70, "Input",
 CellTags->"b:5.1",
 CellID->3276],
Cell[6824, 260, 264, 9, 36, "Output",
 CellTags->"b:5.1",
 CellID->535550650]
}, Open  ]],
Cell[CellGroupData[{
Cell[7125, 274, 136, 5, 70, "Input",
 CellTags->"b:5.1",
 CellID->6540],
Cell[7264, 281, 204, 7, 36, "Output",
 CellTags->"b:5.1",
 CellID->77178811]
}, Open  ]],
Cell[7483, 291, 629, 21, 70, "Text",
 CellTags->"b:5.1",
 CellID->23990],
Cell[8115, 314, 220, 7, 70, "MathCaption",
 CellTags->"b:5.1",
 CellID->32588],
Cell[CellGroupData[{
Cell[8360, 325, 366, 13, 70, "Input",
 CellTags->"b:5.1",
 CellID->24710],
Cell[8729, 340, 560, 19, 51, "Output",
 CellTags->"b:5.1",
 CellID->457687157]
}, Open  ]],
Cell[9304, 362, 346, 11, 70, "Text",
 CellTags->"b:5.1",
 CellID->17945],
Cell[9653, 375, 470, 19, 70, "MathCaption",
 CellTags->"b:5.1",
 CellID->29221],
Cell[CellGroupData[{
Cell[10148, 398, 152, 5, 70, "Input",
 CellID->539037766],
Cell[10303, 405, 506, 17, 51, "Output",
 CellID->114896255]
}, Open  ]],
Cell[CellGroupData[{
Cell[10846, 427, 138, 5, 70, "Input",
 CellTags->"b:5.1",
 CellID->28470],
Cell[10987, 434, 358, 13, 51, "Output",
 CellTags->"b:5.1",
 CellID->30456000]
}, Open  ]],
Cell[CellGroupData[{
Cell[11382, 452, 157, 6, 70, "Input",
 CellTags->"b:5.1",
 CellID->23589],
Cell[11542, 460, 339, 12, 36, "Output",
 CellTags->"b:5.1",
 CellID->383385118]
}, Open  ]],
Cell[CellGroupData[{
Cell[11918, 477, 137, 5, 70, "Input",
 CellTags->"b:5.1",
 CellID->4978],
Cell[12058, 484, 312, 11, 52, "Output",
 CellTags->"b:5.1",
 CellID->1029326842]
}, Open  ]],
Cell[12385, 498, 200, 5, 70, "Text",
 CellTags->"b:5.1",
 CellID->5006],
Cell[12588, 505, 137, 4, 70, "MathCaption",
 CellTags->"b:5.1",
 CellID->13262],
Cell[CellGroupData[{
Cell[12750, 513, 349, 13, 70, "Input",
 CellTags->"b:5.1",
 CellID->20135],
Cell[13102, 528, 1041, 35, 65, "Output",
 CellTags->"b:5.1",
 CellID->23487]
}, Open  ]],
Cell[14158, 566, 118, 3, 70, "MathCaption",
 CellTags->"b:5.1",
 CellID->27196],
Cell[CellGroupData[{
Cell[14301, 573, 200, 7, 70, "Input",
 CellTags->"b:5.1",
 CellID->29033],
Cell[14504, 582, 400, 15, 65, "Output",
 CellTags->"b:5.1",
 CellID->2088]
}, Open  ]],
Cell[CellGroupData[{
Cell[14941, 602, 200, 7, 70, "Input",
 CellTags->"b:5.1",
 CellID->12935],
Cell[15144, 611, 381, 14, 65, "Output",
 CellTags->"b:5.1",
 CellID->19779]
}, Open  ]],
Cell[15540, 628, 99, 2, 70, "MathCaption",
 CellTags->"b:5.1",
 CellID->15993],
Cell[CellGroupData[{
Cell[15664, 634, 148, 5, 70, "Input",
 CellTags->"b:5.1",
 CellID->14790],
Cell[15815, 641, 677, 25, 65, "Output",
 CellTags->"b:5.1",
 CellID->24962]
}, Open  ]],
Cell[16507, 669, 341, 10, 70, "Text",
 CellTags->"b:5.1",
 CellID->18965],
Cell[16851, 681, 211, 5, 70, "MathCaption",
 CellTags->"b:5.1",
 CellID->11001],
Cell[CellGroupData[{
Cell[17087, 690, 902, 28, 61, "Input",
 CellTags->"b:5.1",
 CellID->19105],
Cell[17992, 720, 2786, 50, 125, "Output",
 Evaluatable->False,
 CellTags->"b:5.1",
 CellID->383640909]
}, Open  ]],
Cell[20793, 773, 233, 6, 70, "Text",
 CellTags->"b:5.1",
 CellID->24567],
Cell[21029, 781, 314, 9, 70, "MathCaption",
 CellTags->"b:5.1",
 CellID->2669],
Cell[CellGroupData[{
Cell[21368, 794, 361, 12, 42, "Input",
 CellTags->"b:5.1",
 CellID->3134],
Cell[21732, 808, 2245, 41, 125, "Output",
 Evaluatable->False,
 CellTags->"b:5.1",
 CellID->483566136]
}, Open  ]],
Cell[23992, 852, 175, 5, 70, "Text",
 CellTags->"b:5.1",
 CellID->1457],
Cell[24170, 859, 168, 5, 70, "MathCaption",
 CellTags->"b:5.1",
 CellID->12998],
Cell[CellGroupData[{
Cell[24363, 868, 575, 19, 70, "Input",
 CellTags->"b:5.1",
 CellID->3545],
Cell[24941, 889, 444, 15, 50, "Output",
 CellTags->"b:5.1",
 CellID->13597]
}, Open  ]],
Cell[25400, 907, 164, 5, 70, "MathCaption",
 CellTags->"b:5.1",
 CellID->14218],
Cell[CellGroupData[{
Cell[25589, 916, 468, 15, 70, "Input",
 CellTags->"b:5.1",
 CellID->8838],
Cell[26060, 933, 476, 16, 50, "Output",
 CellTags->"b:5.1",
 CellID->14844]
}, Open  ]],
Cell[26551, 952, 214, 6, 70, "Text",
 CellTags->"b:5.1",
 CellID->7372],
Cell[26768, 960, 718, 27, 70, "MathCaption",
 CellTags->"b:5.1",
 CellID->8563],
Cell[CellGroupData[{
Cell[27511, 991, 605, 21, 70, "Input",
 CellTags->"b:5.1",
 CellID->21028],
Cell[28119, 1014, 568, 20, 50, "Output",
 CellTags->"b:5.1",
 CellID->29264]
}, Open  ]],
Cell[28702, 1037, 172, 5, 70, "Text",
 CellTags->"b:5.1",
 CellID->28801],
Cell[28877, 1044, 113, 2, 70, "MathCaption",
 CellTags->"b:5.1",
 CellID->14723],
Cell[CellGroupData[{
Cell[29015, 1050, 663, 21, 70, "Input",
 CellTags->"b:5.1",
 CellID->13490],
Cell[29681, 1073, 1096, 35, 95, "Output",
 CellTags->"b:5.1",
 CellID->7604]
}, Open  ]],
Cell[30792, 1111, 490, 15, 70, "Text",
 CellTags->"b:5.1",
 CellID->31601],
Cell[31285, 1128, 171, 5, 70, "MathCaption",
 CellTags->"b:5.1",
 CellID->24227],
Cell[CellGroupData[{
Cell[31481, 1137, 451, 15, 70, "Input",
 CellTags->"b:5.1",
 CellID->11197],
Cell[31935, 1154, 505, 11, 70, "Message",
 CellTags->"b:5.1",
 CellID->12316],
Cell[32443, 1167, 504, 11, 70, "Message",
 CellTags->"b:5.1",
 CellID->3035],
Cell[32950, 1180, 875, 30, 53, "Output",
 CellTags->"b:5.1",
 CellID->22190]
}, Open  ]],
Cell[33840, 1213, 132, 4, 70, "MathCaption",
 CellTags->"b:5.1",
 CellID->29301],
Cell[CellGroupData[{
Cell[33997, 1221, 139, 5, 70, "Input",
 CellTags->"b:5.1",
 CellID->22363],
Cell[34139, 1228, 749, 27, 53, "Output",
 CellTags->"b:5.1",
 CellID->1842]
}, Open  ]],
Cell[34903, 1258, 264, 9, 70, "MathCaption",
 CellTags->"b:5.1",
 CellID->3565],
Cell[CellGroupData[{
Cell[35192, 1271, 593, 20, 70, "Input",
 CellTags->"b:5.1",
 CellID->17421],
Cell[35788, 1293, 503, 11, 70, "Message",
 CellTags->"b:5.1",
 CellID->288],
Cell[36294, 1306, 505, 11, 70, "Message",
 CellTags->"b:5.1",
 CellID->30106],
Cell[36802, 1319, 2213, 68, 127, "Output",
 CellTags->"b:5.1",
 CellID->9040]
}, Open  ]],
Cell[39030, 1390, 307, 10, 70, "MathCaption",
 CellTags->"b:5.1",
 CellID->16741],
Cell[CellGroupData[{
Cell[39362, 1404, 234, 8, 70, "Input",
 CellTags->"b:5.1",
 CellID->15022],
Cell[39599, 1414, 872, 30, 66, "Output",
 CellTags->"b:5.1",
 CellID->31812]
}, Open  ]],
Cell[CellGroupData[{
Cell[40508, 1449, 411, 13, 70, "Input",
 CellTags->"b:5.1",
 CellID->29151],
Cell[40922, 1464, 901, 32, 66, "Output",
 CellTags->"b:5.1",
 CellID->23015]
}, Open  ]],
Cell[CellGroupData[{
Cell[41860, 1501, 72, 1, 70, "RelatedTutorialsSection",
 CellID->593717399],
Cell[41935, 1504, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[42139, 1511, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

