(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25239,        578]
NotebookOptionsPosition[     21160,        452]
NotebookOutlinePosition[     24280,        541]
CellTagsIndexPosition[     24186,        535]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Straight Integration", "Title",
 CellTags->{"c:9", "b:1.1.0.0"},
 CellID->2136],

Cell[TextData[{
 "This equation is solved by simply integrating the right-hand side with \
respect to ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellTags->"b:1.1.0.0",
 CellID->4580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], " ", "\[Equal]", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "*", 
       RowBox[{"Sin", "[", "x", "]"}]}], "+", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "+", 
        RowBox[{"x", "^", "2"}]}], "]"}]}]}], ",", " ", "y", ",", "x"}], 
   "]"}]}]], "Input",
 CellTags->"b:1.1.0.0",
 CellLabel->"In[180]:=",
 CellID->14875],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", "x", " ", 
        SqrtBox[
         RowBox[{"1", "+", 
          SuperscriptBox["x", "2"]}]]}], "+", 
       FractionBox[
        RowBox[{"ArcSinh", "[", "x", "]"}], "2"], "+", 
       RowBox[{"C", "[", "1", "]"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          SuperscriptBox["x", "2"]}], ")"}], " ", 
        RowBox[{"Cos", "[", "x", "]"}]}], "+", 
       RowBox[{"2", " ", "x", " ", 
        RowBox[{"Sin", "[", "x", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",\

 ImageSize->{546, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.0",
 CellLabel->"Out[180]=",
 CellID->140627619]
}, Open  ]],

Cell[TextData[{
 "Here is a plot of the integral curves for different values of the arbitrary \
constant ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:1.1.0.0",
 CellID->21184],

Cell[BoxData[
 RowBox[{
  RowBox[{"tab", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], " ", "/.", 
       RowBox[{"sol", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], " ", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", "->", " ", "k"}], "}"}]}], ",", 
     " ", 
     RowBox[{"{", 
      RowBox[{"k", ",", " ", 
       RowBox[{"-", "80"}], ",", " ", "80", ",", " ", "40"}], "}"}]}], 
    "]"}]}], ";"}]], "Input",
 CellTags->"b:1.1.0.0",
 CellLabel->"In[181]:=",
 CellID->28074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "tab", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "3", ",", " ", "18"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:1.1.0.0",
 CellLabel->"In[182]:=",
 CellID->8719],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.1.0.0",
 CellLabel->"Out[182]=",
 CellID->64964460]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->432588576],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Straight Integration - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveIntroductionToODEs"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveSeparableEquations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 50.4386934}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "This equation is solved by simply integrating the right-hand side with \
respect to x. Here is a plot of the integral curves for different values of \
the arbitrary constant C[1].", "synonyms" -> {}, "title" -> 
    "Straight Integration", "type" -> "Tutorial", "uri" -> 
    "tutorial/DSolveStraightIntegration"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:9"->{
  Cell[1280, 43, 85, 2, 70, "Title",
   CellTags->{"c:9", "b:1.1.0.0"},
   CellID->2136]},
 "b:1.1.0.0"->{
  Cell[1280, 43, 85, 2, 70, "Title",
   CellTags->{"c:9", "b:1.1.0.0"},
   CellID->2136],
  Cell[1368, 47, 231, 8, 70, "MathCaption",
   CellTags->"b:1.1.0.0",
   CellID->4580],
  Cell[1624, 59, 490, 17, 28, "Input",
   CellTags->"b:1.1.0.0",
   CellID->14875],
  Cell[2117, 78, 908, 30, 52, "Output",
   CellTags->"b:1.1.0.0",
   CellID->140627619],
  Cell[3040, 111, 307, 11, 70, "MathCaption",
   CellTags->"b:1.1.0.0",
   CellID->21184],
  Cell[3350, 124, 584, 20, 70, "Input",
   CellTags->"b:1.1.0.0",
   CellID->28074],
  Cell[3959, 148, 257, 8, 28, "Input",
   CellTags->"b:1.1.0.0",
   CellID->8719],
  Cell[4219, 158, 16598, 277, 244, "Output",
   Evaluatable->False,
   CellTags->"b:1.1.0.0",
   CellID->64964460]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:9", 23329, 502},
 {"b:1.1.0.0", 23436, 506}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 85, 2, 70, "Title",
 CellTags->{"c:9", "b:1.1.0.0"},
 CellID->2136],
Cell[1368, 47, 231, 8, 70, "MathCaption",
 CellTags->"b:1.1.0.0",
 CellID->4580],
Cell[CellGroupData[{
Cell[1624, 59, 490, 17, 28, "Input",
 CellTags->"b:1.1.0.0",
 CellID->14875],
Cell[2117, 78, 908, 30, 52, "Output",
 CellTags->"b:1.1.0.0",
 CellID->140627619]
}, Open  ]],
Cell[3040, 111, 307, 11, 70, "MathCaption",
 CellTags->"b:1.1.0.0",
 CellID->21184],
Cell[3350, 124, 584, 20, 70, "Input",
 CellTags->"b:1.1.0.0",
 CellID->28074],
Cell[CellGroupData[{
Cell[3959, 148, 257, 8, 28, "Input",
 CellTags->"b:1.1.0.0",
 CellID->8719],
Cell[4219, 158, 16598, 277, 244, "Output",
 Evaluatable->False,
 CellTags->"b:1.1.0.0",
 CellID->64964460]
}, Open  ]],
Cell[CellGroupData[{
Cell[20854, 440, 72, 1, 70, "RelatedTutorialsSection",
 CellID->432588576],
Cell[20929, 443, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[21133, 450, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

