(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15608,        583]
NotebookOptionsPosition[     10852,        432]
NotebookOutlinePosition[     13451,        500]
CellTagsIndexPosition[     13360,        494]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> 
          Documentation`HelpLookup["paclet:tutorial/CalculusOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Calculus\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Derivative" :> 
          Documentation`HelpLookup["paclet:ref/Derivative"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Derivative\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Defining Derivatives", "Title",
 CellTags->{"S3.5.5", "5.1"},
 CellID->1054],

Cell[TextData[{
 "You can define the derivative in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " of a function ",
 Cell[BoxData["f"], "InlineFormula"],
 " of one argument simply by an assignment like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"f", "'"}], "[", "x_", "]"}], "=", 
   RowBox[{"fp", "[", "x", "]"}]}]], "InlineFormula"],
 "."
}], "Text",
 CellID->25345],

Cell[TextData[{
 "This defines the derivative of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "\[InvisibleSpace]", 
    RowBox[{"p", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 ". In this case, you could have used ",
 Cell[BoxData["="], "InlineFormula"],
 " instead of ",
 Cell[BoxData[":="], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14708],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "'"}], "[", "x_", "]"}], ":=", 
  RowBox[{"fp", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->248],

Cell[TextData[{
 "The rule for ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "'"}], "[", "x_", "]"}]], "InlineFormula"],
 " is used to evaluate this derivative. "
}], "MathCaption",
 CellID->7491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->13712],

Cell[BoxData[
 RowBox[{"2", " ", "x", " ", 
  RowBox[{"fp", "[", 
   SuperscriptBox["x", "2"], "]"}]}]], "Output",
 ImageSize->{65, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->5131]
}, Open  ]],

Cell[TextData[{
 "Differentiating again gives derivatives of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "\[InvisibleSpace]", "p"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->30114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->16439],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   RowBox[{"fp", "[", 
    SuperscriptBox["x", "2"], "]"}]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "2"], " ", 
   RowBox[{
    SuperscriptBox["fp", "\[Prime]",
     MultilineFunction->None], "[", 
    SuperscriptBox["x", "2"], "]"}]}]}]], "Output",
 ImageSize->{137, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->7958]
}, Open  ]],

Cell[TextData[{
 "This defines a value for the derivative of ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " at the origin. "
}], "MathCaption",
 CellID->24722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "'"}], "[", "0", "]"}], "=", "g0"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->29704],

Cell[BoxData["g0"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->6995]
}, Open  ]],

Cell[TextData[{
 "The value for ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"g", "'"}], "[", "0", "]"}]], "InlineFormula"],
 " is used. "
}], "MathCaption",
 CellID->1052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"g", "[", "x", "]"}], "^", "2"}], ",", "x"}], "]"}], "/.", 
  RowBox[{"x", "->", "0"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->25269],

Cell[BoxData[
 RowBox[{"2", " ", "g0", " ", 
  RowBox[{"g", "[", "0", "]"}]}]], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->7479]
}, Open  ]],

Cell[TextData[{
 "This defines the second derivative of ",
 Cell[BoxData["g"], "InlineFormula"],
 ", with any argument. "
}], "MathCaption",
 CellID->18238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "''"}], "[", "x_", "]"}], "=", 
  RowBox[{"gpp", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->26423],

Cell[BoxData[
 RowBox[{"gpp", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->27918]
}, Open  ]],

Cell["The value defined for the second derivative is used. ", "MathCaption",
 CellID->10866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"g", "[", "x", "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->17659],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   RowBox[{"g", "[", "x", "]"}], " ", 
   RowBox[{"gpp", "[", "x", "]"}]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox[
    RowBox[{
     SuperscriptBox["g", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}], "2"]}]}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->32498]
}, Open  ]],

Cell[TextData[{
 "To define derivatives of functions with several arguments, you have to use \
the general representation of derivatives in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->28486],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["f", "TI"], "'", "[", 
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], "]", ":=", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     "define the first derivative of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Derivative",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Derivative"], "[", 
     StyleBox["n", "TI"], "]", "[", 
     StyleBox["f", "TI"], "]", "[", 
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], "]", ":=", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     "define the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " derivative of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Derivative",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Derivative"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", "[", 
     StyleBox["g", "TI"], "]", "[", 
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], ",", "_", ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", ":=", 
     StyleBox["rhs", "TI"]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "define derivatives of ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " with respect to various arguments"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21196],

Cell["Defining derivatives. ", "Caption",
 CellID->7462],

Cell[TextData[{
 "This defines the second derivative of ",
 Cell[BoxData["g"], "InlineFormula"],
 " with respect to its second argument. "
}], "MathCaption",
 CellID->26633],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Derivative", "[", 
     RowBox[{"0", ",", "2"}], "]"}], "[", "g", "]"}], "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"g2p", "[", 
   RowBox[{"x", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->12158],

Cell["This uses the definition just given. ", "MathCaption",
 CellID->12022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"a", "^", "2"}], ",", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", "x", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->1146],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", 
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"g2p", "[", 
    RowBox[{
     SuperscriptBox["a", "2"], ",", 
     SuperscriptBox["x", "2"]}], "]"}]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{
    SuperscriptBox["g", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     SuperscriptBox["a", "2"], ",", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 ImageSize->{206, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->18392]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->321679723],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CalculusOverview"]], "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Defining Derivatives - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Calculus", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/CalculusOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheRepresentationOfDerivatives"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/IndefiniteIntegrals"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 52.5153356}", "context" -> "", 
    "keywords" -> {"defining derivatives", "derivative", "derivatives"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "You can define the derivative in Mathematica of a function f of one \
argument simply by an assignment like f'[x_]=fp[x]. This defines the \
derivative of f(x) to be fp(x). In this case, you could have used = instead \
of :=. The rule for f'[x_] is used to evaluate this derivative. ", 
    "synonyms" -> {"3.5.5"}, "title" -> "Defining Derivatives", "type" -> 
    "Tutorial", "uri" -> "tutorial/DefiningDerivatives"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.5.5"->{
  Cell[1776, 58, 82, 2, 70, "Title",
   CellTags->{"S3.5.5", "5.1"},
   CellID->1054]},
 "5.1"->{
  Cell[1776, 58, 82, 2, 70, "Title",
   CellTags->{"S3.5.5", "5.1"},
   CellID->1054]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.5.5", 13151, 483},
 {"5.1", 13249, 487}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1151, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1776, 58, 82, 2, 70, "Title",
 CellTags->{"S3.5.5", "5.1"},
 CellID->1054],
Cell[1861, 62, 385, 14, 70, "Text",
 CellID->25345],
Cell[2249, 78, 466, 16, 70, "MathCaption",
 CellID->14708],
Cell[2718, 96, 165, 6, 70, "Input",
 CellID->248],
Cell[2886, 104, 195, 7, 70, "MathCaption",
 CellID->7491],
Cell[CellGroupData[{
Cell[3106, 115, 171, 6, 28, "Input",
 CellID->13712],
Cell[3280, 123, 240, 8, 39, "Output",
 CellID->5131]
}, Open  ]],
Cell[3535, 134, 208, 7, 70, "MathCaption",
 CellID->30114],
Cell[CellGroupData[{
Cell[3768, 145, 117, 4, 28, "Input",
 CellID->16439],
Cell[3888, 151, 433, 15, 39, "Output",
 CellID->7958]
}, Open  ]],
Cell[4336, 169, 182, 6, 70, "MathCaption",
 CellID->24722],
Cell[CellGroupData[{
Cell[4543, 179, 137, 5, 70, "Input",
 CellID->29704],
Cell[4683, 186, 155, 5, 36, "Output",
 CellID->6995]
}, Open  ]],
Cell[4853, 194, 167, 7, 70, "MathCaption",
 CellID->1052],
Cell[CellGroupData[{
Cell[5045, 205, 222, 8, 70, "Input",
 CellID->25269],
Cell[5270, 215, 215, 7, 36, "Output",
 CellID->7479]
}, Open  ]],
Cell[5500, 225, 156, 5, 70, "MathCaption",
 CellID->18238],
Cell[CellGroupData[{
Cell[5681, 234, 168, 6, 70, "Input",
 CellID->26423],
Cell[5852, 242, 184, 6, 36, "Output",
 CellID->27918]
}, Open  ]],
Cell[6051, 251, 92, 1, 70, "MathCaption",
 CellID->10866],
Cell[CellGroupData[{
Cell[6168, 256, 220, 8, 70, "Input",
 CellID->17659],
Cell[6391, 266, 414, 14, 36, "Output",
 CellID->32498]
}, Open  ]],
Cell[6820, 283, 225, 7, 70, "Text",
 CellID->28486],
Cell[7048, 292, 2003, 61, 70, "DefinitionBox",
 CellID->21196],
Cell[9054, 355, 56, 1, 70, "Caption",
 CellID->7462],
Cell[9113, 358, 173, 5, 70, "MathCaption",
 CellID->26633],
Cell[9289, 365, 292, 10, 70, "Input",
 CellID->12158],
Cell[9584, 377, 76, 1, 70, "MathCaption",
 CellID->12022],
Cell[CellGroupData[{
Cell[9685, 382, 232, 8, 70, "Input",
 CellID->1146],
Cell[9920, 392, 620, 23, 39, "Output",
 CellID->18392]
}, Open  ]],
Cell[CellGroupData[{
Cell[10577, 420, 72, 1, 70, "RelatedTutorialsSection",
 CellID->321679723],
Cell[10652, 423, 146, 3, 70, "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],
Cell[10825, 430, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

