(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18426,        662]
NotebookOptionsPosition[     12135,        470]
NotebookOutlinePosition[     15683,        559]
CellTagsIndexPosition[     15510,        551]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions and Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FunctionsAndProgramsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Functions and Programs\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Clear" :> Documentation`HelpLookup["paclet:ref/Clear"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Clear\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Defining Functions", "Title",
 CellTags->{"S1.7.1", "1.1"},
 CellID->13037],

Cell[TextData[{
 "There are many functions that are built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Here we discuss how you can add your own simple functions to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->3925],

Cell[TextData[{
 "As a first example, consider adding a function called ",
 Cell[BoxData["f"], "InlineFormula"],
 " which squares its argument. The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " command to define this function is ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}]], "InlineFormula"],
 ". The ",
 Cell[BoxData["_"], "InlineFormula"],
 " (referred to as \[OpenCurlyDoubleQuote]blank\[CloseCurlyDoubleQuote]) on \
the left\[Hyphen]hand side is very important; what it means will be discussed \
below. For now, just remember to put a ",
 Cell[BoxData["_"], "InlineFormula"],
 " on the left\[Hyphen]hand side, but not on the right\[Hyphen]hand side, of \
your definition. "
}], "Text",
 CellID->10647],

Cell[TextData[{
 "This defines the function ",
 Cell[BoxData["f"], "InlineFormula"],
 ". Notice the ",
 Cell[BoxData["_"], "InlineFormula"],
 " on the left\[Hyphen]hand side. "
}], "MathCaption",
 CellID->29458],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6602],

Cell[TextData[{
 Cell[BoxData["f"], "InlineFormula"],
 " squares its argument. "
}], "MathCaption",
 CellID->30807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", "+", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4098],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "+", "a"}], ")"}], "2"]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2048403441]
}, Open  ]],

Cell["The argument can be a number. ", "MathCaption",
 CellID->29292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "4", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14600],

Cell[BoxData["16"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1530095753]
}, Open  ]],

Cell["Or it can be a more complicated expression. ", "MathCaption",
 CellID->20799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"3", "x"}], "+", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->18352],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}], "2"]], "Output",
 ImageSize->{66, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1449163478]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData["f"], "InlineFormula"],
 " in a calculation. "
}], "MathCaption",
 CellID->13882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"f", "[", 
   RowBox[{"(", 
    RowBox[{"x", "+", "1", "+", "y"}], ")"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->540],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "x"}], "+", 
  SuperscriptBox["x", "2"], "+", 
  RowBox[{"2", " ", "y"}], "+", 
  RowBox[{"2", " ", "x", " ", "y"}], "+", 
  SuperscriptBox["y", "2"]}]], "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->41203951]
}, Open  ]],

Cell[TextData[{
 "This shows the definition you made for\[NonBreakingSpace]",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->8762],

Cell[CellGroupData[{

Cell["Global`f", "Print", "PrintUsage",
 CellTags->"Info3370257360-2937831",
 CellID->2110549221],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", 
         SuperscriptBox["x", "2"]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["f"],
  Editable->False]], "Print",
 CellTags->"Info3370257360-2937831",
 CellID->1506611136]
}, Open  ]]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{"f", "[", "x_", "]", ":=", "x", "^", "2"}], Cell[TextData[{
     "define the function ",
     Cell[BoxData["f"], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"?", 
     StyleBox["f", "TI"]}], Cell[TextData[{
     "show the definition of ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Clear",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Clear"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "clear all definitions for ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18397],

Cell[TextData[{
 "Defining a function in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->31418],

Cell[TextData[{
 "The names like ",
 Cell[BoxData["f"], "InlineFormula"],
 " that you use for functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are just symbols. Because of this, you should make sure to avoid using \
names that begin with capital letters, to prevent confusion with built\
\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions. You should also make sure that you have not used the names for \
anything else earlier in your session. "
}], "Text",
 CellID->19897],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions can have any number of arguments. "
}], "MathCaption",
 CellID->25828],

Cell[BoxData[
 RowBox[{
  RowBox[{"hump", "[", 
   RowBox[{"x_", ",", "xmax_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "xmax"}], ")"}], "^", "2"}], "/", "xmax"}]}]], "Input",\

 CellLabel->"In[7]:=",
 CellID->13851],

Cell[TextData[{
 "You can use the ",
 Cell[BoxData["hump"], "InlineFormula"],
 " function just as you would any of the built\[Hyphen]in functions. "
}], "MathCaption",
 CellID->26816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"hump", "[", 
   RowBox[{"x", ",", "3.5"}], "]"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->24230],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"0.2857142857142857`", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3.5`"}], "+", "x"}], ")"}], "2"]}]}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->219317762]
}, Open  ]],

Cell[TextData[{
 "This gives a new definition for ",
 Cell[BoxData["hump"], "InlineFormula"],
 ", which overwrites the previous one. "
}], "MathCaption",
 CellID->16925],

Cell[BoxData[
 RowBox[{
  RowBox[{"hump", "[", 
   RowBox[{"x_", ",", "xmax_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "-", "xmax"}], ")"}], "^", "4"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->658],

Cell["The new definition is displayed. ", "MathCaption",
 CellID->229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "hump"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->24520],

Cell[CellGroupData[{

Cell["Global`hump", "Print", "PrintUsage",
 CellTags->"Info3370257378-2847621",
 CellID->1433849689],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"hump", "[", 
          RowBox[{"x_", ",", "xmax_"}], "]"}], ":=", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "-", "xmax"}], ")"}], "4"]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["hump"],
  Editable->False]], "Print",
 CellTags->"Info3370257378-2847621",
 CellID->969751545]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "This clears all definitions for ",
 Cell[BoxData["hump"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15147],

Cell[BoxData[
 RowBox[{"Clear", "[", "hump", "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->25162],

Cell[TextData[{
 "When you have finished with a particular function, it is always a good idea \
to clear definitions you have made for it. If you do not do this, then you \
will run into trouble if you try to use the same function for a different \
purpose later in your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. You can clear all definitions you have made for a function or \
symbol ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " by using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Clear",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clear"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->1655],

Cell[TextData[ButtonBox["Functions and Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FunctionsAndProgramsOverview"]], "RelatedTutorials",
 CellID->1392681]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Defining Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Functions and Programs", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/FunctionsAndProgramsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/FunctionsAsProcedures"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 52.8747198}", "context" -> "", 
    "keywords" -> {
     "_.", "_:", "___", "__", "_", "?", ":=", "blank", "blanks", "clear", 
      "commands", "defining functions", "deleting functions", 
      "dummy variables", "function definitions", "functions", "information", 
      "killing", "macros", "names", "removing functions", "routines", 
      "SetDelayed", "subroutines", "undefining functions", "Underbar", 
      "underscore", "user-defined functions"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "There are many functions that are built into Mathematica. Here we \
discuss how you can add your own simple functions to Mathematica. As a first \
example, consider adding a function called f which squares its argument. The \
Mathematica command to define this function is f[x_]:=x^2. The _ (referred to \
as 'blank') on the left-hand side is very important; what it means will be \
discussed below. For now, just remember to put a _ on the left-hand side, but \
not on the right-hand side, of your definition. This defines the function f. \
Notice the _ on the left-hand side. ", "synonyms" -> {"1.7.1"}, "title" -> 
    "Defining Functions", "type" -> "Tutorial", "uri" -> 
    "tutorial/DefiningFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.7.1"->{
  Cell[1802, 58, 81, 2, 70, "Title",
   CellTags->{"S1.7.1", "1.1"},
   CellID->13037]},
 "1.1"->{
  Cell[1802, 58, 81, 2, 70, "Title",
   CellTags->{"S1.7.1", "1.1"},
   CellID->13037]},
 "Info3370257360-2937831"->{
  Cell[5701, 227, 97, 2, 70, "Print",
   CellTags->"Info3370257360-2937831",
   CellID->2110549221],
  Cell[5801, 231, 778, 23, 70, "Print",
   CellTags->"Info3370257360-2937831",
   CellID->1506611136]},
 "Info3370257378-2847621"->{
  Cell[9978, 393, 100, 2, 70, "Print",
   CellTags->"Info3370257378-2847621",
   CellID->1433849689],
  Cell[10081, 397, 884, 26, 70, "Print",
   CellTags->"Info3370257378-2847621",
   CellID->969751545]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.7.1", 14830, 526},
 {"1.1", 14929, 530},
 {"Info3370257360-2937831", 15047, 534},
 {"Info3370257378-2847621", 15281, 541}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1177, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1802, 58, 81, 2, 70, "Title",
 CellTags->{"S1.7.1", "1.1"},
 CellID->13037],
Cell[1886, 62, 263, 9, 70, "Text",
 CellID->3925],
Cell[2152, 73, 769, 20, 70, "Text",
 CellID->10647],
Cell[2924, 95, 211, 7, 70, "MathCaption",
 CellID->29458],
Cell[3138, 104, 140, 5, 70, "Input",
 CellID->6602],
Cell[3281, 111, 115, 4, 70, "MathCaption",
 CellID->30807],
Cell[CellGroupData[{
Cell[3421, 119, 115, 4, 28, "Input",
 CellID->4098],
Cell[3539, 125, 229, 8, 36, "Output",
 CellID->2048403441]
}, Open  ]],
Cell[3783, 136, 69, 1, 70, "MathCaption",
 CellID->29292],
Cell[CellGroupData[{
Cell[3877, 141, 93, 3, 28, "Input",
 CellID->14600],
Cell[3973, 146, 160, 5, 36, "Output",
 CellID->1530095753]
}, Open  ]],
Cell[4148, 154, 83, 1, 70, "MathCaption",
 CellID->20799],
Cell[CellGroupData[{
Cell[4256, 159, 159, 6, 70, "Input",
 CellID->18352],
Cell[4418, 167, 280, 10, 41, "Output",
 CellID->1449163478]
}, Open  ]],
Cell[4713, 180, 128, 5, 70, "MathCaption",
 CellID->13882],
Cell[CellGroupData[{
Cell[4866, 189, 183, 6, 70, "Input",
 CellID->540],
Cell[5052, 197, 347, 11, 36, "Output",
 CellID->41203951]
}, Open  ]],
Cell[5414, 211, 155, 5, 70, "MathCaption",
 CellID->4575],
Cell[CellGroupData[{
Cell[5594, 220, 82, 3, 70, "Input",
 CellID->8762],
Cell[CellGroupData[{
Cell[5701, 227, 97, 2, 70, "Print",
 CellTags->"Info3370257360-2937831",
 CellID->2110549221],
Cell[5801, 231, 778, 23, 70, "Print",
 CellTags->"Info3370257360-2937831",
 CellID->1506611136]
}, Open  ]]
}, Open  ]],
Cell[6606, 258, 1009, 31, 70, "DefinitionBox",
 CellID->18397],
Cell[7618, 291, 129, 6, 70, "Caption",
 CellID->31418],
Cell[7750, 299, 518, 14, 70, "Text",
 CellID->19897],
Cell[8271, 315, 148, 5, 70, "MathCaption",
 CellID->25828],
Cell[8422, 322, 255, 10, 70, "Input",
 CellID->13851],
Cell[8680, 334, 183, 5, 70, "MathCaption",
 CellID->26816],
Cell[CellGroupData[{
Cell[8888, 343, 145, 5, 70, "Input",
 CellID->24230],
Cell[9036, 350, 323, 11, 36, "Output",
 CellID->219317762]
}, Open  ]],
Cell[9374, 364, 169, 5, 70, "MathCaption",
 CellID->16925],
Cell[9546, 371, 222, 8, 70, "Input",
 CellID->658],
Cell[9771, 381, 70, 1, 70, "MathCaption",
 CellID->229],
Cell[CellGroupData[{
Cell[9866, 386, 87, 3, 70, "Input",
 CellID->24520],
Cell[CellGroupData[{
Cell[9978, 393, 100, 2, 70, "Print",
 CellTags->"Info3370257378-2847621",
 CellID->1433849689],
Cell[10081, 397, 884, 26, 70, "Print",
 CellTags->"Info3370257378-2847621",
 CellID->969751545]
}, Open  ]]
}, Open  ]],
Cell[10992, 427, 134, 5, 70, "MathCaption",
 CellID->15147],
Cell[11129, 434, 101, 3, 70, "Input",
 CellID->25162],
Cell[11233, 439, 684, 20, 70, "Text",
 CellID->1655],
Cell[11920, 461, 173, 4, 70, "RelatedTutorials",
 CellID->1392681]
}, Open  ]],
Cell[12108, 468, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

